/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jpa;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.cdk.unittest.FakeTranslationFactory;
import org.teiid.language.Command;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jpa.JPA2ExecutionFactory;
import org.teiid.translator.jpa.JPQLDirectQueryExecution;

public class TestJPADirectQueryExecution {
    private static JPA2ExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void setUp() throws TranslatorException {
        TRANSLATOR = new JPA2ExecutionFactory();
        TRANSLATOR.setSupportsDirectQueryProcedure(true);
        TRANSLATOR.start();
    }

    @Test
    public void testSearch() throws Exception {
        String input = "exec native('search;SELECT Account.Id, Account.Type, Account.Name FROM Account')";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        EntityManager connection = (EntityManager)Mockito.mock(EntityManager.class);
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.stub((Object)connection.createQuery("SELECT Account.Id, Account.Type, Account.Name FROM Account")).toReturn((Object)query);
        JPQLDirectQueryExecution execution = (JPQLDirectQueryExecution)TRANSLATOR.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        ((EntityManager)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).createQuery("SELECT Account.Id, Account.Type, Account.Name FROM Account");
    }

    @Test
    public void testWithoutMarker() throws Exception {
        String input = "exec native('jpa query')";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        EntityManager connection = (EntityManager)Mockito.mock(EntityManager.class);
        try {
            JPQLDirectQueryExecution execution = (JPQLDirectQueryExecution)TRANSLATOR.createExecution(command, ec, rm, (Object)connection);
            execution.execute();
            Assert.fail((String)"the above should have thrown exception");
        }
        catch (TranslatorException translatorException) {
            // empty catch block
        }
    }

    @Test
    public void testDelete() throws Exception {
        String input = "exec native('delete;delete-query')";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        EntityManager connection = (EntityManager)Mockito.mock(EntityManager.class);
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.stub((Object)query.executeUpdate()).toReturn((Object)12);
        Mockito.stub((Object)connection.createQuery("delete-query")).toReturn((Object)query);
        ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        JPQLDirectQueryExecution execution = (JPQLDirectQueryExecution)TRANSLATOR.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        ((EntityManager)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).createQuery((String)argument.capture());
        Assert.assertEquals((Object)"delete-query", (Object)argument.getValue());
        Assert.assertArrayEquals((Object[])new Object[]{12}, (Object[])((Object[])execution.next().get(0)));
    }

    @Test
    public void testCreate() throws Exception {
        String input = "exec native('create;', 'one')";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        EntityManager connection = (EntityManager)Mockito.mock(EntityManager.class);
        ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        Mockito.stub((Object)connection.merge(argument.capture())).toReturn((Object)new String("one"));
        JPQLDirectQueryExecution execution = (JPQLDirectQueryExecution)TRANSLATOR.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        ((EntityManager)Mockito.verify((Object)connection)).merge(argument.capture());
        Assert.assertEquals((Object)"one", (Object)argument.getValue());
    }
}

