/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jpa;

import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jpa.JPA2ExecutionFactory;

public class TestJPAMetadataImport {
    private static JPA2ExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void setUp() throws TranslatorException {
        TRANSLATOR = new JPA2ExecutionFactory();
        TRANSLATOR.start();
    }

    @Test
    public void testImport() throws Exception {
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"org.teiid.translator.jpa.test");
        Properties props = new Properties();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "market", SystemMetadata.getInstance().getRuntimeTypeMap(), props, null);
        MetadataProcessor processor = TRANSLATOR.getMetadataProcessor();
        processor.process(mf, (Object)factory.createEntityManager());
        String ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, (String)".*Marketdata");
        Assert.assertEquals((Object)"CREATE FOREIGN TABLE Marketdata (\n\tid string OPTIONS (NAMEINSOURCE 'id'),\n\texchange_name string OPTIONS (NAMEINSOURCE 'name', \"teiid_jpa:assosiated_with_table\" 'market.Exchange', \"teiid_jpa:relation_key\" 'name', \"teiid_jpa:relation_property\" 'exchange'),\n\tprice bigdecimal OPTIONS (NAMEINSOURCE 'price'),\n\tstock_id string OPTIONS (NAMEINSOURCE 'id', \"teiid_jpa:assosiated_with_table\" 'market.Stock', \"teiid_jpa:relation_key\" 'id', \"teiid_jpa:relation_property\" 'stock'),\n\tCONSTRAINT PK_Marketdata PRIMARY KEY(id),\n\tCONSTRAINT FK_exchange FOREIGN KEY(exchange_name) REFERENCES Exchange  OPTIONS (NAMEINSOURCE 'exchange'),\n\tCONSTRAINT FK_stock FOREIGN KEY(stock_id) REFERENCES Stock  OPTIONS (NAMEINSOURCE 'stock')\n) OPTIONS (UPDATABLE TRUE, \"teiid_jpa:entity_class\" 'org.teiid.translator.jpa.model.Marketdata');", (Object)ddl);
        ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, (String)"Stock");
        Assert.assertEquals((Object)"CREATE FOREIGN TABLE Stock (\n\tid string OPTIONS (NAMEINSOURCE 'id'),\n\tcompanyName string OPTIONS (NAMEINSOURCE 'companyName'),\n\tsymbol string OPTIONS (NAMEINSOURCE 'symbol'),\n\tCONSTRAINT PK_Stock PRIMARY KEY(id)\n) OPTIONS (UPDATABLE TRUE, \"teiid_jpa:entity_class\" 'org.teiid.translator.jpa.model.Stock');", (Object)ddl);
        ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, (String)"Exchange");
        Assert.assertEquals((Object)"CREATE FOREIGN TABLE Exchange (\n\tname string OPTIONS (NAMEINSOURCE 'name'),\n\tCONSTRAINT PK_Exchange PRIMARY KEY(name)\n) OPTIONS (UPDATABLE TRUE, \"teiid_jpa:entity_class\" 'org.teiid.translator.jpa.model.Exchange');", (Object)ddl);
    }
}

