/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jpa;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.core.BundleUtil;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Function;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.language.TableReference;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jpa.JPA2ExecutionFactory;
import org.teiid.translator.jpa.JPAPlugin;

public class JPQLSelectVisitor
extends HierarchyVisitor {
    protected JPA2ExecutionFactory executionFactory;
    protected static final String UNDEFINED = "<undefined>";
    private LinkedList<JoinTable> joins = new LinkedList();
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    protected LinkedHashMap<String, NamedTable> implicitGroups = new LinkedHashMap();
    protected AtomicInteger aliasCounter = new AtomicInteger(0);
    protected RuntimeMetadata metadata;

    public JPQLSelectVisitor(JPA2ExecutionFactory executionFactory, RuntimeMetadata metadata) {
        super(false);
        this.executionFactory = executionFactory;
        this.metadata = metadata;
    }

    public static String getJPQLString(Select obj, JPA2ExecutionFactory executionFactory, RuntimeMetadata metadata) throws TranslatorException {
        JPQLSelectVisitor visitor = new JPQLSelectVisitor(executionFactory, metadata);
        visitor.visitNode((LanguageObject)obj);
        if (!visitor.exceptions.isEmpty()) {
            throw visitor.exceptions.get(0);
        }
        return visitor.convertToQuery(obj);
    }

    private String convertToQuery(Select obj) {
        JPQLSelectStringVisitor visitor = new JPQLSelectStringVisitor(this);
        visitor.visitNode((LanguageObject)obj);
        return visitor.toString();
    }

    public void visit(Select obj) {
        this.visitNodes(obj.getDerivedColumns());
        this.visitNodes(obj.getFrom());
        this.visitNode((LanguageObject)obj.getWhere());
        this.visitNode((LanguageObject)obj.getGroupBy());
        this.visitNode((LanguageObject)obj.getHaving());
        this.visitNode((LanguageObject)obj.getOrderBy());
    }

    public void visit(ColumnReference obj) {
        String name;
        Column record = obj.getMetadataObject();
        if (record != null && (name = record.getProperty("teiid_jpa:assosiated_with_table", false)) != null) {
            try {
                Table t = this.metadata.getTable(name);
                String correlationName = obj.getTable().getCorrelationName();
                String attrName = record.getProperty("teiid_jpa:relation_property", false);
                String groupName = correlationName + "." + attrName;
                NamedTable nt = this.implicitGroups.get(groupName);
                if (nt == null) {
                    nt = new NamedTable(groupName, "J_" + this.aliasCounter.getAndIncrement(), t);
                    this.implicitGroups.put(groupName, nt);
                }
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
            }
        }
    }

    private boolean alreadyInJoin(NamedTable table) {
        String[] splits = table.getName().split("\\.");
        String correlationName = splits[0];
        String attrName = splits[1];
        for (JoinTable joinTable : this.joins) {
            if (joinTable.parent == null || !joinTable.parent.getCorrelationName().equals(correlationName) || !attrName.equals(joinTable.childAttributeName)) continue;
            return true;
        }
        return false;
    }

    public void visit(NamedTable obj) {
        if (this.implicitGroups.isEmpty()) {
            this.joins.add(new JoinTable(obj, null, Join.JoinType.INNER_JOIN));
        } else {
            for (NamedTable table : this.implicitGroups.values()) {
                this.joins.add(new JoinTable(obj, table, Join.JoinType.LEFT_OUTER_JOIN));
            }
        }
    }

    public void visit(Join obj) {
        try {
            this.handleJoin(obj);
            for (NamedTable table : this.implicitGroups.values()) {
                NamedTable parent = this.findParent(table);
                if (parent != null) {
                    if (this.alreadyInJoin(table)) continue;
                    this.joins.add(new JoinTable(parent, table, Join.JoinType.LEFT_OUTER_JOIN));
                    continue;
                }
                this.exceptions.add(new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14004, new Object[]{table.getName()})));
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    private NamedTable findParent(NamedTable child) {
        for (JoinTable jt : this.joins) {
            if (jt.getParent() != null && this.isParentOf(jt.getParent(), child)) {
                return jt.getParent();
            }
            if (jt.getChild() == null || !this.isParentOf(jt.getChild(), child)) continue;
            return jt.getChild();
        }
        return null;
    }

    private JoinTable handleJoin(Join obj) throws TranslatorException {
        TableReference left = obj.getLeftItem();
        TableReference right = obj.getRightItem();
        if (left instanceof NamedTable && right instanceof NamedTable) {
            JoinTable join = this.handleJoin(obj.getJoinType(), left, right, obj.getCondition(), true);
            this.joins.add(join);
            return join;
        }
        JoinTable leftJoin = null;
        if (left instanceof Join) {
            leftJoin = this.handleJoin((Join)left);
            if (right instanceof NamedTable) {
                JoinTable join = this.handleJoin(obj.getJoinType(), leftJoin, (NamedTable)right, obj.getCondition());
                this.joins.add(join);
                return join;
            }
        }
        JoinTable rightJoin = null;
        if (right instanceof Join) {
            rightJoin = this.handleJoin((Join)right);
            if (left instanceof NamedTable) {
                JoinTable join = this.handleJoin(obj.getJoinType(), (NamedTable)left, rightJoin, obj.getCondition());
                this.joins.add(join);
                return join;
            }
        }
        throw new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14005, new Object[0]));
    }

    private JoinTable handleJoin(Join.JoinType joinType, JoinTable left, NamedTable right, Condition condition) throws TranslatorException {
        JoinTable withParent = this.handleJoin(joinType, (TableReference)left.getParent(), (TableReference)right, condition, false);
        JoinTable withChild = this.handleJoin(joinType, (TableReference)left.getChild(), (TableReference)right, condition, false);
        NamedTable parent = null;
        if (withParent != null && withParent.getParent() != null) {
            parent = withParent.getParent();
        } else if (withChild != null && withChild.getParent() != null) {
            parent = withChild.getParent();
        }
        if (parent != null) {
            return this.handleJoin(joinType, (TableReference)parent, (TableReference)right, condition, true);
        }
        throw new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14006, new Object[0]));
    }

    private JoinTable handleJoin(Join.JoinType joinType, NamedTable left, JoinTable right, Condition condition) throws TranslatorException {
        JoinTable withParent = this.handleJoin(joinType, (TableReference)left, (TableReference)right.getParent(), condition, false);
        JoinTable withChild = this.handleJoin(joinType, (TableReference)left, (TableReference)right.getChild(), condition, false);
        NamedTable parent = null;
        if (withParent != null && withParent.getParent() != null) {
            parent = withParent.getParent();
        } else if (withChild != null && withChild.getParent() != null) {
            parent = withChild.getParent();
        }
        if (parent != null) {
            return this.handleJoin(joinType, (TableReference)left, (TableReference)parent, condition, true);
        }
        throw new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14006, new Object[0]));
    }

    private JoinTable handleJoin(Join.JoinType joinType, TableReference left, TableReference right, Condition condition, boolean fixCorrelatedNames) {
        NamedTable leftTable = (NamedTable)left;
        NamedTable rightTable = (NamedTable)right;
        Comparison comp = (Comparison)condition;
        if (!this.isInComparison(leftTable, comp) || !this.isInComparison(rightTable, comp)) {
            return null;
        }
        JoinTable joinTable = new JoinTable(leftTable, rightTable, joinType);
        if (fixCorrelatedNames) {
            String groupName = rightTable.getCorrelationName() + "." + leftTable.getName();
            NamedTable table = this.implicitGroups.get(groupName);
            if (table != null) {
                table.setCorrelationName(leftTable.getCorrelationName());
            }
            if ((table = this.implicitGroups.get(groupName = leftTable.getCorrelationName() + "." + rightTable.getName())) != null) {
                table.setCorrelationName(rightTable.getCorrelationName());
            }
        }
        return joinTable;
    }

    private boolean isInComparison(NamedTable table, Comparison comparison) {
        return this.isInReference(table, (ColumnReference)comparison.getLeftExpression()) || this.isInReference(table, (ColumnReference)comparison.getRightExpression());
    }

    private boolean isInReference(NamedTable table, ColumnReference reference) {
        return table.getCorrelationName().equals(reference.getTable().getCorrelationName()) && table.getName().equals(reference.getTable().getName());
    }

    private boolean isParentOf(NamedTable parent, NamedTable child) {
        String[] splits = child.getName().split("\\.");
        String correlation = splits[0];
        String attrName = splits[1];
        if (!parent.getCorrelationName().equals(correlation)) {
            return false;
        }
        for (ForeignKey fk : parent.getMetadataObject().getForeignKeys()) {
            if (!((Table)fk.getReferenceKey().getParent()).equals((Object)child.getMetadataObject())) continue;
            return true;
        }
        return false;
    }

    static class JPQLSelectStringVisitor
    extends SQLStringVisitor {
        private JPQLSelectVisitor visitor;

        public JPQLSelectStringVisitor(JPQLSelectVisitor visitor) {
            this.visitor = visitor;
        }

        public void visit(Select obj) {
            this.buffer.append("SELECT").append(" ");
            if (obj.isDistinct()) {
                this.buffer.append("DISTINCT").append(" ");
            }
            this.append(obj.getDerivedColumns());
            if (obj.getFrom() != null && !obj.getFrom().isEmpty()) {
                this.buffer.append(" ").append("FROM").append(" ");
                this.append(obj.getFrom());
            }
            if (obj.getWhere() != null) {
                this.buffer.append(" ").append("WHERE").append(" ");
                this.append((LanguageObject)obj.getWhere());
            }
            if (obj.getGroupBy() != null) {
                this.buffer.append(" ");
                this.append((LanguageObject)obj.getGroupBy());
            }
            if (obj.getHaving() != null) {
                this.buffer.append(" ").append("HAVING").append(" ");
                this.append((LanguageObject)obj.getHaving());
            }
            if (obj.getOrderBy() != null) {
                this.buffer.append(" ");
                this.append((LanguageObject)obj.getOrderBy());
            }
        }

        public void visit(ColumnReference column) {
            Column record = column.getMetadataObject();
            if (record != null) {
                String name = record.getProperty("teiid_jpa:assosiated_with_table", false);
                if (name == null) {
                    this.buffer.append(column.getTable().getCorrelationName()).append(".").append(record.getSourceName());
                } else {
                    String attrName = record.getProperty("teiid_jpa:relation_property", false);
                    String attrColumnName = record.getProperty("teiid_jpa:relation_key", false);
                    String groupName = column.getTable().getCorrelationName() + "." + attrName;
                    String correlationName = this.visitor.implicitGroups.get(groupName).getCorrelationName();
                    this.buffer.append(correlationName).append(".").append(attrColumnName);
                }
            } else {
                this.buffer.append(column.getName());
            }
        }

        public void visit(Join obj) {
            this.addFromClause();
        }

        public void visit(Function func) {
            if (this.visitor.executionFactory.getFunctionModifiers().containsKey(func.getName())) {
                this.visitor.executionFactory.getFunctionModifiers().get(func.getName()).translate(func);
            }
            super.visit(func);
        }

        public void visit(NamedTable obj) {
            this.addFromClause();
        }

        private void addFromClause() {
            boolean first = true;
            for (JoinTable joinTable : this.visitor.joins) {
                if (!joinTable.isLeftParent() && joinTable.joinType == Join.JoinType.LEFT_OUTER_JOIN) {
                    joinTable.joinType = Join.JoinType.RIGHT_OUTER_JOIN;
                }
                if (first) {
                    this.buffer.append(joinTable.getParent().getName());
                    this.buffer.append(" ");
                    this.buffer.append("AS").append(" ");
                    this.buffer.append(joinTable.getParent().getCorrelationName());
                    first = false;
                }
                if (joinTable.getChild() == null) continue;
                this.buffer.append(" ");
                switch (joinTable.joinType) {
                    case CROSS_JOIN: {
                        this.buffer.append("CROSS");
                        break;
                    }
                    case FULL_OUTER_JOIN: {
                        this.buffer.append("FULL").append(" ").append("OUTER");
                        break;
                    }
                    case INNER_JOIN: {
                        this.buffer.append("INNER");
                        break;
                    }
                    case LEFT_OUTER_JOIN: {
                        this.buffer.append("LEFT").append(" ").append("OUTER");
                        break;
                    }
                    case RIGHT_OUTER_JOIN: {
                        this.buffer.append("RIGHT").append(" ").append("OUTER");
                        break;
                    }
                    default: {
                        this.buffer.append(JPQLSelectVisitor.UNDEFINED);
                    }
                }
                this.buffer.append(" ").append("JOIN").append(" ");
                this.buffer.append(joinTable.getParent().getCorrelationName()).append(".").append(joinTable.childAttributeName());
                this.buffer.append(" ");
                this.buffer.append("AS").append(" ");
                this.buffer.append(joinTable.getChild().getCorrelationName());
            }
        }
    }

    static class JoinTable {
        NamedTable parent;
        NamedTable child;
        NamedTable left;
        NamedTable right;
        String childAttributeName;
        String parentAttributeName;
        Join.JoinType joinType;

        JoinTable(NamedTable left, NamedTable right, Join.JoinType type) {
            this.left = left;
            this.right = right;
            this.joinType = type;
            if (right == null) {
                this.parent = left;
                this.parentAttributeName = left.getName();
            } else {
                String[] splits = right.getName().split("\\.");
                boolean isImplicit = splits.length > 1;
                String attrName = null;
                if (isImplicit) {
                    attrName = splits[1];
                }
                for (ForeignKey fk : left.getMetadataObject().getForeignKeys()) {
                    if (!((Table)fk.getReferenceKey().getParent()).equals((Object)right.getMetadataObject()) || isImplicit && !attrName.equals(fk.getSourceName())) continue;
                    this.parent = left;
                    this.child = right;
                    this.childAttributeName = fk.getSourceName();
                    this.parentAttributeName = left.getName();
                }
                if (this.parent == null) {
                    for (ForeignKey fk : right.getMetadataObject().getForeignKeys()) {
                        if (!((Table)fk.getReferenceKey().getParent()).equals((Object)left.getMetadataObject())) continue;
                        this.parent = right;
                        this.child = left;
                        this.childAttributeName = fk.getSourceName();
                        this.parentAttributeName = right.getName();
                    }
                }
            }
        }

        NamedTable getParent() {
            return this.parent;
        }

        NamedTable getChild() {
            return this.child;
        }

        NamedTable getLeft() {
            return this.left;
        }

        NamedTable getRight() {
            return this.right;
        }

        String childAttributeName() {
            return this.childAttributeName;
        }

        String parentAttributeName() {
            return this.parentAttributeName;
        }

        public boolean isLeftParent() {
            return this.left == this.parent;
        }
    }
}

