/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ldap;

import java.util.ArrayList;
import java.util.List;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapContext;
import org.teiid.language.Argument;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.ldap.IQueryToLdapSearchParser;
import org.teiid.translator.ldap.LDAPExecutionFactory;
import org.teiid.translator.ldap.LDAPQueryExecution;
import org.teiid.translator.ldap.LDAPSearchDetails;
import org.teiid.translator.ldap.LDAPSyncQueryExecution;

public class LDAPDirectSearchQueryExecution
extends LDAPSyncQueryExecution
implements ProcedureExecution {
    private String query;
    private boolean returnsArray = true;

    public LDAPDirectSearchQueryExecution(List<Argument> arguments, LDAPExecutionFactory factory, ExecutionContext executionContext, LdapContext connection, String query, boolean returnsArray) {
        super(null, factory, executionContext, connection);
        StringBuilder sb = new StringBuilder();
        SQLStringVisitor.parseNativeQueryParts((String)query.substring(7), arguments, (StringBuilder)sb, (SQLStringVisitor.Substitutor)new SQLStringVisitor.Substitutor(){

            public void substitute(Argument arg, StringBuilder builder, int index) {
                builder.append(IQueryToLdapSearchParser.escapeReservedChars(IQueryToLdapSearchParser.getLiteralString(arg.getArgumentValue())));
            }
        });
        this.query = sb.toString();
        this.returnsArray = returnsArray;
    }

    @Override
    public void execute() throws TranslatorException {
        IQueryToLdapSearchParser parser = new IQueryToLdapSearchParser(this.executionFactory);
        LDAPSearchDetails details = parser.buildRequest(this.query);
        LdapContext context = this.createSearchContext(details.getContextName());
        SearchControls controls = new SearchControls();
        controls.setSearchScope(details.getSearchScope());
        controls.setTimeLimit(details.getTimeLimit());
        controls.setCountLimit(details.getCountLimit());
        controls.setReturningAttributes(details.getAttributes());
        this.delegate = new LDAPQueryExecution(context, details, controls, this.executionFactory, this.executionContext);
        this.delegate.execute();
    }

    @Override
    public List<?> next() throws TranslatorException, DataNotAvailableException {
        List<?> vals = super.next();
        if (vals == null) {
            return null;
        }
        if (this.returnsArray) {
            ArrayList<Object[]> row = new ArrayList<Object[]>(1);
            row.add(vals.toArray(new Object[vals.size()]));
            return row;
        }
        return vals;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }
}

