/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.language.Command;
import org.teiid.language.Expression;
import org.teiid.language.Literal;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ldap.LDAPExecutionFactory;
import org.teiid.translator.ldap.LDAPSyncQueryExecution;
import org.teiid.translator.ldap.LDAPUpdateExecution;

public class TestQueryExecution {
    @Test
    public void testUnwrap() throws Exception {
        TranslationUtility util = new TranslationUtility((QueryMetadataInterface)RealMetadataFactory.fromDDL((String)"CREATE FOREIGN TABLE GROUP_PEOPLE (objectClass string options (\"teiid_ldap:unwrap\" true)) OPTIONS(nameinsource 'ou=Infrastructure,ou=Support,o=DEMOCORP,c=AU', updatable true);", (String)"x", (String)"y"));
        Command command = util.parseCommand("select * from group_people");
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        LdapContext connection = (LdapContext)Mockito.mock(LdapContext.class);
        LdapContext ctx = (LdapContext)Mockito.mock(LdapContext.class);
        Mockito.stub((Object)connection.lookup("ou=Infrastructure,ou=Support,o=DEMOCORP,c=AU")).toReturn((Object)ctx);
        Attributes attribs = (Attributes)Mockito.mock(Attributes.class);
        Attribute attrib = (Attribute)Mockito.mock(Attribute.class);
        Mockito.stub((Object)attrib.size()).toReturn((Object)2);
        SimpleNamingEnumeration attribValues = new SimpleNamingEnumeration(Arrays.asList("foo", "bar").iterator());
        Mockito.stub(attrib.getAll()).toReturn(attribValues);
        Mockito.stub((Object)attribs.get("objectClass")).toReturn((Object)attrib);
        SearchResult sr = new SearchResult("x", (Object)null, attribs);
        SimpleNamingEnumeration enumeration = new SimpleNamingEnumeration(Arrays.asList(sr).iterator());
        Mockito.stub(ctx.search((String)Mockito.any(), (String)Mockito.any(), (SearchControls)Mockito.any())).toReturn(enumeration);
        LDAPExecutionFactory lef = new LDAPExecutionFactory();
        lef.start();
        LDAPSyncQueryExecution execution = (LDAPSyncQueryExecution)lef.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        List result = execution.next();
        Assert.assertEquals(Arrays.asList("foo"), (Object)result);
        result = execution.next();
        Assert.assertEquals(Arrays.asList("bar"), (Object)result);
        Assert.assertNull((Object)execution.next());
        Mockito.stub((Object)attribs.get("objectClass")).toReturn(null);
        enumeration = new SimpleNamingEnumeration(Arrays.asList(sr).iterator());
        Mockito.stub(ctx.search((String)Mockito.any(), (String)Mockito.any(), (SearchControls)Mockito.any())).toReturn(enumeration);
        execution = (LDAPSyncQueryExecution)lef.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        result = execution.next();
        Assert.assertEquals(Collections.singletonList(null), (Object)result);
        Assert.assertNull((Object)execution.next());
        attribValues = new SimpleNamingEnumeration(new ArrayList().iterator());
        Mockito.stub((Object)attrib.size()).toReturn((Object)0);
        Mockito.stub(attrib.getAll()).toReturn(attribValues);
        Mockito.stub((Object)attribs.get("objectClass")).toReturn((Object)attrib);
        enumeration = new SimpleNamingEnumeration(Arrays.asList(sr).iterator());
        Mockito.stub(ctx.search((String)Mockito.any(), (String)Mockito.any(), (SearchControls)Mockito.any())).toReturn(enumeration);
        execution = (LDAPSyncQueryExecution)lef.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        result = execution.next();
        Assert.assertEquals(Collections.singletonList(null), (Object)result);
        Assert.assertNull((Object)execution.next());
    }

    @Test
    public void testUnwrapExtract() throws Exception {
        TranslationUtility util = new TranslationUtility((QueryMetadataInterface)RealMetadataFactory.fromDDL((String)"CREATE FOREIGN TABLE GROUP_PEOPLE (\"member\" string options (\"teiid_ldap:unwrap\" true, \"teiid_ldap:rdn_type\" 'uid', \"teiid_ldap:dn_prefix\" 'ou=users')) OPTIONS(nameinsource 'ou=Infrastructure,ou=Support,o=DEMOCORP,c=AU', updatable true);", (String)"x", (String)"y"));
        Command command = util.parseCommand("select * from group_people");
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        LdapContext connection = (LdapContext)Mockito.mock(LdapContext.class);
        LdapContext ctx = (LdapContext)Mockito.mock(LdapContext.class);
        Mockito.stub((Object)connection.lookup("ou=Infrastructure,ou=Support,o=DEMOCORP,c=AU")).toReturn((Object)ctx);
        BasicAttributes attributes = new BasicAttributes(true);
        BasicAttribute attrib = new BasicAttribute("member");
        attributes.put(attrib);
        attrib.add("uid=foo,ou=users");
        attrib.add("user=bar,ou=users");
        attrib.add("uid=bar");
        SearchResult sr = new SearchResult("x", (Object)null, attributes);
        SimpleNamingEnumeration enumeration = new SimpleNamingEnumeration(Arrays.asList(sr).iterator());
        Mockito.stub(ctx.search((String)Mockito.any(), (String)Mockito.any(), (SearchControls)Mockito.any())).toReturn(enumeration);
        LDAPExecutionFactory lef = new LDAPExecutionFactory();
        lef.start();
        LDAPSyncQueryExecution execution = (LDAPSyncQueryExecution)lef.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        List result = execution.next();
        Assert.assertEquals(Arrays.asList("foo"), (Object)result);
        Assert.assertNull((Object)execution.next());
    }

    @Test
    public void testMultiAttribute() throws NamingException {
        Column c = new Column();
        c.setDefaultValue("multivalued-concat");
        Attribute a = LDAPUpdateExecution.createBasicAttribute((String)"x", (Expression)new Literal((Object)"a?b?c", String.class), (Column)c);
        Assert.assertEquals((long)3L, (long)a.size());
        Assert.assertEquals((Object)"b", Collections.list(a.getAll()).get(1));
    }

    private static final class SimpleNamingEnumeration<T>
    implements NamingEnumeration<T> {
        private final Iterator<T> iter;

        private SimpleNamingEnumeration(Iterator<T> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iter.next();
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        @Override
        public T next() throws NamingException {
            return this.nextElement();
        }
    }
}

