/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ldap;

import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.cdk.unittest.FakeTranslationFactory;
import org.teiid.language.Command;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.ldap.LDAPDirectCreateUpdateDeleteQueryExecution;
import org.teiid.translator.ldap.LDAPDirectSearchQueryExecution;
import org.teiid.translator.ldap.LDAPExecutionFactory;
import org.teiid.translator.ldap.LDAPSearchDetails;

public class TestLDAPDirectQueryExecution {
    private static LDAPExecutionFactory TRANSLATOR;

    @BeforeClass
    public static void setUp() throws TranslatorException {
        TRANSLATOR = new LDAPExecutionFactory();
        TRANSLATOR.setSupportsDirectQueryProcedure(true);
        TRANSLATOR.start();
    }

    @Test
    public void testSearch() throws Exception {
        String input = "exec native('search;context-name=corporate;filter=(objectClass=*);count-limit=5;timeout=6;search-scope=ONELEVEL_SCOPE;attributes=uid,cn')";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        LdapContext connection = (LdapContext)Mockito.mock(LdapContext.class);
        LdapContext ctx = (LdapContext)Mockito.mock(LdapContext.class);
        Mockito.stub((Object)connection.lookup("corporate")).toReturn((Object)ctx);
        LDAPDirectSearchQueryExecution execution = (LDAPDirectSearchQueryExecution)TRANSLATOR.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        LDAPSearchDetails details = execution.getDelegate().getSearchDetails();
        Assert.assertEquals((Object)"corporate", (Object)details.getContextName());
        Assert.assertEquals((Object)"(objectClass=*)", (Object)details.getContextFilter());
        Assert.assertEquals((long)5L, (long)details.getCountLimit());
        Assert.assertEquals((long)6L, (long)details.getTimeLimit());
        Assert.assertEquals((long)1L, (long)details.getSearchScope());
        Assert.assertEquals((long)2L, (long)details.getElementList().size());
        Assert.assertEquals((Object)"uid", (Object)((Column)details.getElementList().get(0)).getName());
        Assert.assertEquals((Object)"cn", (Object)((Column)details.getElementList().get(1)).getName());
    }

    @Test
    public void testSearchDefaultsAndEscaping() throws Exception {
        String input = "exec native('search;context-name=corporate;filter=(;;)')";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        LdapContext connection = (LdapContext)Mockito.mock(LdapContext.class);
        LdapContext ctx = (LdapContext)Mockito.mock(LdapContext.class);
        Mockito.stub((Object)connection.lookup("corporate")).toReturn((Object)ctx);
        LDAPDirectSearchQueryExecution execution = (LDAPDirectSearchQueryExecution)TRANSLATOR.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        LDAPSearchDetails details = execution.getDelegate().getSearchDetails();
        Assert.assertEquals((Object)"corporate", (Object)details.getContextName());
        Assert.assertEquals((Object)"(;)", (Object)details.getContextFilter());
        Assert.assertEquals((long)-1L, (long)details.getCountLimit());
        Assert.assertEquals((long)0L, (long)details.getTimeLimit());
        Assert.assertEquals((long)1L, (long)details.getSearchScope());
        Assert.assertEquals((long)0L, (long)details.getElementList().size());
    }

    @Test(expected=TranslatorException.class)
    public void testWithoutMarker() throws Exception {
        String input = "exec native('context-name=corporate;filter=(objectClass=*);count-limit=5;timout=6;search-scope=ONELEVEL_SCOPE;attributes=uid,cn')";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        LdapContext connection = (LdapContext)Mockito.mock(LdapContext.class);
        LdapContext ctx = (LdapContext)Mockito.mock(LdapContext.class);
        Mockito.stub((Object)connection.lookup("corporate")).toReturn((Object)ctx);
        Execution execution = TRANSLATOR.createExecution(command, ec, rm, (Object)connection);
        Assert.assertTrue((!(execution instanceof LDAPDirectSearchQueryExecution) ? 1 : 0) != 0);
        execution.execute();
    }

    @Test
    public void testDelete() throws Exception {
        String input = "exec native('delete;uid=doe,ou=people,o=teiid.org')";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        LdapContext connection = (LdapContext)Mockito.mock(LdapContext.class);
        LdapContext ctx = (LdapContext)Mockito.mock(LdapContext.class);
        Mockito.stub((Object)connection.lookup("")).toReturn((Object)ctx);
        LDAPDirectCreateUpdateDeleteQueryExecution execution = (LDAPDirectCreateUpdateDeleteQueryExecution)TRANSLATOR.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        ((LdapContext)Mockito.verify((Object)ctx, (VerificationMode)Mockito.times((int)1))).destroySubcontext("uid=doe,ou=people,o=teiid.org");
    }

    @Test
    public void testUpdate() throws Exception {
        String input = "exec native('update;uid=doe,ou=people,o=teiid.org;attributes=one,two,three', 'one', 2, 3.0)";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        LdapContext connection = (LdapContext)Mockito.mock(LdapContext.class);
        LdapContext ctx = (LdapContext)Mockito.mock(LdapContext.class);
        Mockito.stub((Object)connection.lookup("")).toReturn((Object)ctx);
        LDAPDirectCreateUpdateDeleteQueryExecution execution = (LDAPDirectCreateUpdateDeleteQueryExecution)TRANSLATOR.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        ArgumentCaptor nameArgument = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor modificationItemArgument = ArgumentCaptor.forClass(ModificationItem[].class);
        ((LdapContext)Mockito.verify((Object)ctx)).modifyAttributes((String)nameArgument.capture(), (ModificationItem[])modificationItemArgument.capture());
        Assert.assertEquals((Object)"uid=doe,ou=people,o=teiid.org", (Object)nameArgument.getValue());
        Assert.assertEquals((Object)"one", (Object)((ModificationItem[])modificationItemArgument.getValue())[0].getAttribute().getID());
        Assert.assertEquals((Object)"one", (Object)((ModificationItem[])modificationItemArgument.getValue())[0].getAttribute().get());
        Assert.assertEquals((Object)"two", (Object)((ModificationItem[])modificationItemArgument.getValue())[1].getAttribute().getID());
        Assert.assertEquals((Object)"2", (Object)((ModificationItem[])modificationItemArgument.getValue())[1].getAttribute().get());
        Assert.assertEquals((Object)"three", (Object)((ModificationItem[])modificationItemArgument.getValue())[2].getAttribute().getID());
        Assert.assertEquals((Object)"3.0", (Object)((ModificationItem[])modificationItemArgument.getValue())[2].getAttribute().get());
    }

    @Test
    public void testCreate() throws Exception {
        String input = "exec native('create;uid=doe,ou=people,o=teiid.org;attributes=one,two,three', 'one', 2, 3.0)";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        LdapContext connection = (LdapContext)Mockito.mock(LdapContext.class);
        LdapContext ctx = (LdapContext)Mockito.mock(LdapContext.class);
        Mockito.stub((Object)connection.lookup("")).toReturn((Object)ctx);
        LDAPDirectCreateUpdateDeleteQueryExecution execution = (LDAPDirectCreateUpdateDeleteQueryExecution)TRANSLATOR.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
        ArgumentCaptor nameArgument = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor createItemArgument = ArgumentCaptor.forClass(BasicAttributes.class);
        ((LdapContext)Mockito.verify((Object)ctx)).createSubcontext((String)nameArgument.capture(), (Attributes)createItemArgument.capture());
        Assert.assertEquals((Object)"uid=doe,ou=people,o=teiid.org", (Object)nameArgument.getValue());
        Assert.assertEquals((Object)"one", (Object)((BasicAttributes)createItemArgument.getValue()).get("one").getID());
        Assert.assertEquals((Object)"one", (Object)((BasicAttributes)createItemArgument.getValue()).get("one").get());
        Assert.assertEquals((Object)"two", (Object)((BasicAttributes)createItemArgument.getValue()).get("two").getID());
        Assert.assertEquals((Object)"2", (Object)((BasicAttributes)createItemArgument.getValue()).get("two").get());
        Assert.assertEquals((Object)"three", (Object)((BasicAttributes)createItemArgument.getValue()).get("three").getID());
        Assert.assertEquals((Object)"3.0", (Object)((BasicAttributes)createItemArgument.getValue()).get("three").get());
    }

    @Test(expected=TranslatorException.class)
    public void testCreateFail() throws Exception {
        String input = "exec native('create;uid=doe,ou=people,o=teiid.org;attributes=one,two,three', 'one')";
        TranslationUtility util = FakeTranslationFactory.getInstance().getExampleTranslationUtility();
        Command command = util.parseCommand(input);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        RuntimeMetadata rm = (RuntimeMetadata)Mockito.mock(RuntimeMetadata.class);
        LdapContext connection = (LdapContext)Mockito.mock(LdapContext.class);
        LdapContext ctx = (LdapContext)Mockito.mock(LdapContext.class);
        Mockito.stub((Object)connection.lookup("")).toReturn((Object)ctx);
        LDAPDirectCreateUpdateDeleteQueryExecution execution = (LDAPDirectCreateUpdateDeleteQueryExecution)TRANSLATOR.createExecution(command, ec, rm, (Object)connection);
        execution.execute();
    }
}

