/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ldap;

import java.util.List;
import javax.naming.ldap.LdapContext;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.resource.api.ConnectionFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.ldap.LDAPDirectCreateUpdateDeleteQueryExecution;
import org.teiid.translator.ldap.LDAPDirectSearchQueryExecution;
import org.teiid.translator.ldap.LDAPSyncQueryExecution;
import org.teiid.translator.ldap.LDAPUpdateExecution;

@Translator(name="ldap", description="A translator for LDAP directory")
public class LDAPExecutionFactory
extends ExecutionFactory<ConnectionFactory, LdapContext> {
    public static final String DN_PREFIX = "{http://www.teiid.org/translator/ldap/2015}dn_prefix";
    public static final String RDN_TYPE = "{http://www.teiid.org/translator/ldap/2015}rdn_type";
    public static final String UNWRAP = "{http://www.teiid.org/translator/ldap/2015}unwrap";
    private String searchDefaultBaseDN;
    private boolean restrictToObjectClass;
    private SearchDefaultScope searchDefaultScope = SearchDefaultScope.ONELEVEL_SCOPE;
    private boolean usePagination;
    private boolean exceptionOnSizeLimitExceeded;

    public LDAPExecutionFactory() {
        this.setMaxInCriteriaSize(1000);
        this.setMaxDependentInPredicates(25);
        this.setSupportsInnerJoins(true);
        this.setSupportedJoinCriteria(ExecutionFactory.SupportedJoinCriteria.KEY);
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
    }

    @TranslatorProperty(display="Default Search Base DN", description="Default Base DN for LDAP Searches")
    public String getSearchDefaultBaseDN() {
        return this.searchDefaultBaseDN;
    }

    public void setSearchDefaultBaseDN(String searchDefaultBaseDN) {
        this.searchDefaultBaseDN = searchDefaultBaseDN;
    }

    @TranslatorProperty(display="Restrict Searches To Named Object Class", description="Restrict Searches to objectClass named in the Name field for a table", advanced=true)
    public boolean isRestrictToObjectClass() {
        return this.restrictToObjectClass;
    }

    public void setRestrictToObjectClass(boolean restrictToObjectClass) {
        this.restrictToObjectClass = restrictToObjectClass;
    }

    @TranslatorProperty(display="Default Search Scope", description="Default Scope for LDAP Searches")
    public SearchDefaultScope getSearchDefaultScope() {
        return this.searchDefaultScope;
    }

    public void setSearchDefaultScope(SearchDefaultScope searchDefaultScope) {
        this.searchDefaultScope = searchDefaultScope;
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, LdapContext context) throws TranslatorException {
        return new LDAPSyncQueryExecution((Select)command, this, executionContext, context);
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, LdapContext context) throws TranslatorException {
        return new LDAPUpdateExecution(command, context);
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, LdapContext context) throws TranslatorException {
        String query = (String)arguments.get(0).getArgumentValue().getValue();
        if (query.startsWith("search;")) {
            return new LDAPDirectSearchQueryExecution(arguments.subList(1, arguments.size()), this, executionContext, context, query, true);
        }
        return new LDAPDirectCreateUpdateDeleteQueryExecution(arguments.subList(1, arguments.size()), this, executionContext, context, query, true);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, LdapContext connection) throws TranslatorException {
        String nativeQuery = command.getMetadataObject().getProperty("{http://www.teiid.org/ext/relational/2012}native-query", false);
        if (nativeQuery != null) {
            if (nativeQuery.startsWith("search;")) {
                return new LDAPDirectSearchQueryExecution(command.getArguments(), this, executionContext, connection, nativeQuery, false);
            }
            return new LDAPDirectCreateUpdateDeleteQueryExecution(command.getArguments(), this, executionContext, connection, nativeQuery, false);
        }
        throw new TranslatorException("Missing native-query extension metadata.");
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsLikeCriteria() {
        return true;
    }

    public boolean supportsOrCriteria() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return false;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsNotCriteria() {
        return true;
    }

    @TranslatorProperty(display="Use Pagination", description="Use a PagedResultsControl to page through large results.  This is not supported by all directory servers.")
    public boolean usePagination() {
        return this.usePagination;
    }

    public void setUsePagination(boolean usePagination) {
        this.usePagination = usePagination;
    }

    @TranslatorProperty(display="Exception on Size Limit Exceeded", description="Set to true to throw an exception when a SizeLimitExceededException is received and a LIMIT is not properly enforced.")
    public boolean isExceptionOnSizeLimitExceeded() {
        return this.exceptionOnSizeLimitExceeded;
    }

    public void setExceptionOnSizeLimitExceeded(boolean exceptionOnSizeLimitExceeded) {
        this.exceptionOnSizeLimitExceeded = exceptionOnSizeLimitExceeded;
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public boolean supportsLikeCriteriaEscapeCharacter() {
        return true;
    }

    public int getMaxFromGroups() {
        return 2;
    }

    public boolean useAnsiJoin() {
        return true;
    }

    public boolean supportsPartialFiltering() {
        return true;
    }

    public static enum SearchDefaultScope {
        SUBTREE_SCOPE,
        OBJECT_SCOPE,
        ONELEVEL_SCOPE;

    }
}

