/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.SortKey;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.teiid.cdk.CommandBuilder;
import org.teiid.language.Command;
import org.teiid.language.Select;
import org.teiid.language.Update;
import org.teiid.metadata.Column;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.ldap.IQueryToLdapSearchParser;
import org.teiid.translator.ldap.LDAPExecutionFactory;
import org.teiid.translator.ldap.LDAPSearchDetails;
import org.teiid.translator.ldap.LDAPUpdateExecution;

public class TestIQueryToLdapSearchParser {
    public Command getCommand(String sql, QueryMetadataInterface metadata) {
        CommandBuilder builder = new CommandBuilder(metadata);
        return builder.getCommand(sql);
    }

    public void helpTestSearchDetails(LDAPSearchDetails searchDetails, String expectedContextName, String expectedContextFilter, List<String> expectedAttrNameList, long expectedCountLimit, int expectedSearchScope, SortKey[] expectedSortKeys) {
        String contextName = searchDetails.getContextName();
        String contextFilter = searchDetails.getContextFilter();
        ArrayList attrList = searchDetails.getElementList();
        long countLimit = searchDetails.getCountLimit();
        int searchScope = searchDetails.getSearchScope();
        Object[] sortKeys = searchDetails.getSortKeys();
        Assert.assertEquals((Object)expectedContextName, (Object)contextName);
        Assert.assertEquals((Object)expectedContextFilter, (Object)contextFilter);
        Assert.assertEquals((long)attrList.size(), (long)expectedAttrNameList.size());
        Iterator iter = attrList.iterator();
        Iterator<String> eIter = expectedAttrNameList.iterator();
        while (iter.hasNext() && eIter.hasNext()) {
            String actualName = ((Column)iter.next()).getSourceName();
            String expectedName = eIter.next();
            Assert.assertEquals((Object)actualName, (Object)expectedName);
        }
        Assert.assertEquals((long)expectedCountLimit, (long)countLimit);
        Assert.assertEquals((long)expectedSearchScope, (long)searchScope);
        Assert.assertArrayEquals((Object[])expectedSortKeys, (Object[])sortKeys);
    }

    @Test
    public void testSelectFrom1() throws Exception {
        LDAPSearchDetails searchDetails = this.helpGetSearchDetails("SELECT UserID, Name FROM LdapModel.People");
        String expectedContextName = "ou=people,dc=metamatrix,dc=com";
        String expectedContextFilter = "(objectClass=*)";
        ArrayList<String> expectedAttrNameList = new ArrayList<String>();
        expectedAttrNameList.add("uid");
        expectedAttrNameList.add("cn");
        long expectedCountLimit = -1L;
        int expectedSearchScope = 1;
        SortKey[] expectedSortKeys = null;
        this.helpTestSearchDetails(searchDetails, expectedContextName, expectedContextFilter, expectedAttrNameList, expectedCountLimit, expectedSearchScope, expectedSortKeys);
    }

    @Test
    public void testUpdateNull() throws Exception {
        String sql = "update LdapModel.People set userid = 1, name = null where dn = 'x'";
        QueryMetadataInterface metadata = TestIQueryToLdapSearchParser.exampleLdap();
        Update query = (Update)this.getCommand(sql, metadata);
        LDAPExecutionFactory config = new LDAPExecutionFactory();
        LdapContext context = (LdapContext)Mockito.mock(LdapContext.class);
        Mockito.stub((Object)context.lookup("")).toReturn((Object)context);
        LDAPUpdateExecution lue = new LDAPUpdateExecution((Command)query, context);
        lue.execute();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ModificationItem[].class);
        ((LdapContext)Mockito.verify((Object)context)).modifyAttributes((String)ArgumentCaptor.forClass(String.class).capture(), (ModificationItem[])captor.capture());
        ModificationItem[] modifications = (ModificationItem[])captor.getValue();
        Assert.assertEquals((long)2L, (long)modifications.length);
        Assert.assertEquals((Object)"uid: 1", (Object)modifications[0].getAttribute().toString());
        Assert.assertEquals((Object)"cn: null", (Object)modifications[1].getAttribute().toString());
    }

    @Test
    public void testUpdateArray() throws Exception {
        String sql = "update LdapModel.People set userid = 1, vals = ('a','b') where dn = 'x'";
        QueryMetadataInterface metadata = TestIQueryToLdapSearchParser.exampleLdap();
        Update query = (Update)this.getCommand(sql, metadata);
        LDAPExecutionFactory config = new LDAPExecutionFactory();
        LdapContext context = (LdapContext)Mockito.mock(LdapContext.class);
        Mockito.stub((Object)context.lookup("")).toReturn((Object)context);
        LDAPUpdateExecution lue = new LDAPUpdateExecution((Command)query, context);
        lue.execute();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ModificationItem[].class);
        ((LdapContext)Mockito.verify((Object)context)).modifyAttributes((String)ArgumentCaptor.forClass(String.class).capture(), (ModificationItem[])captor.capture());
        ModificationItem[] modifications = (ModificationItem[])captor.getValue();
        Assert.assertEquals((long)2L, (long)modifications.length);
        Assert.assertEquals((Object)"uid: 1", (Object)modifications[0].getAttribute().toString());
        Assert.assertEquals((Object)"vals: a, b", (Object)modifications[1].getAttribute().toString());
    }

    @Test
    public void testSelectFromWhere1() throws Exception {
        LDAPSearchDetails searchDetails = this.helpGetSearchDetails("SELECT UserID, Name FROM LdapModel.People WHERE Name = 'R%'");
        String expectedContextName = "ou=people,dc=metamatrix,dc=com";
        String expectedContextFilter = "(cn=R%)";
        ArrayList<String> expectedAttrNameList = new ArrayList<String>();
        expectedAttrNameList.add("uid");
        expectedAttrNameList.add("cn");
        long expectedCountLimit = -1L;
        int expectedSearchScope = 1;
        SortKey[] expectedSortKeys = null;
        this.helpTestSearchDetails(searchDetails, expectedContextName, expectedContextFilter, expectedAttrNameList, expectedCountLimit, expectedSearchScope, expectedSortKeys);
    }

    @Test
    public void testEscaping() throws Exception {
        LDAPSearchDetails searchDetails = this.helpGetSearchDetails("SELECT UserID, Name FROM LdapModel.People WHERE Name = 'R*'");
        String expectedContextName = "ou=people,dc=metamatrix,dc=com";
        String expectedContextFilter = "(cn=R\\2a)";
        ArrayList<String> expectedAttrNameList = new ArrayList<String>();
        expectedAttrNameList.add("uid");
        expectedAttrNameList.add("cn");
        long expectedCountLimit = -1L;
        int expectedSearchScope = 1;
        SortKey[] expectedSortKeys = null;
        this.helpTestSearchDetails(searchDetails, expectedContextName, expectedContextFilter, expectedAttrNameList, expectedCountLimit, expectedSearchScope, expectedSortKeys);
    }

    @Test
    public void testNot() throws Exception {
        LDAPSearchDetails searchDetails = this.helpGetSearchDetails("SELECT UserID, Name FROM LdapModel.People WHERE not (Name like 'R%' or Name like 'S%')");
        String expectedContextName = "ou=people,dc=metamatrix,dc=com";
        String expectedContextFilter = "(&(!(cn=R*))(!(cn=S*)))";
        ArrayList<String> expectedAttrNameList = new ArrayList<String>();
        expectedAttrNameList.add("uid");
        expectedAttrNameList.add("cn");
        long expectedCountLimit = -1L;
        int expectedSearchScope = 1;
        SortKey[] expectedSortKeys = null;
        this.helpTestSearchDetails(searchDetails, expectedContextName, expectedContextFilter, expectedAttrNameList, expectedCountLimit, expectedSearchScope, expectedSortKeys);
    }

    @Test
    public void testGT() throws Exception {
        LDAPSearchDetails searchDetails = this.helpGetSearchDetails("SELECT UserID, Name FROM LdapModel.People WHERE Name > 'R'");
        String expectedContextName = "ou=people,dc=metamatrix,dc=com";
        String expectedContextFilter = "(!(cn<=R))";
        ArrayList<String> expectedAttrNameList = new ArrayList<String>();
        expectedAttrNameList.add("uid");
        expectedAttrNameList.add("cn");
        long expectedCountLimit = -1L;
        int expectedSearchScope = 1;
        SortKey[] expectedSortKeys = null;
        this.helpTestSearchDetails(searchDetails, expectedContextName, expectedContextFilter, expectedAttrNameList, expectedCountLimit, expectedSearchScope, expectedSortKeys);
    }

    @Test
    public void testLT() throws Exception {
        LDAPSearchDetails searchDetails = this.helpGetSearchDetails("SELECT UserID, Name FROM LdapModel.People WHERE Name < 'R'");
        String expectedContextName = "ou=people,dc=metamatrix,dc=com";
        String expectedContextFilter = "(!(cn>=R))";
        ArrayList<String> expectedAttrNameList = new ArrayList<String>();
        expectedAttrNameList.add("uid");
        expectedAttrNameList.add("cn");
        long expectedCountLimit = -1L;
        int expectedSearchScope = 1;
        SortKey[] expectedSortKeys = null;
        this.helpTestSearchDetails(searchDetails, expectedContextName, expectedContextFilter, expectedAttrNameList, expectedCountLimit, expectedSearchScope, expectedSortKeys);
    }

    private LDAPSearchDetails helpGetSearchDetails(String queryString) throws Exception {
        QueryMetadataInterface metadata = TestIQueryToLdapSearchParser.exampleLdap();
        Select query = (Select)this.getCommand(queryString, metadata);
        LDAPExecutionFactory config = new LDAPExecutionFactory();
        IQueryToLdapSearchParser searchParser = new IQueryToLdapSearchParser(config);
        LDAPSearchDetails searchDetails = searchParser.translateSQLQueryToLDAPSearch(query);
        return searchDetails;
    }

    public static QueryMetadataInterface exampleLdap() throws Exception {
        String ddl = "create foreign table People (UserID string options (nameinsource 'uid'), Name string options (nameinsource 'cn'), dn string, vals string[]) options (nameinsource 'ou=people,dc=metamatrix,dc=com');create foreign table People_Groups (user_dn string options (nameinsource 'dn'), groupname string options (nameinsource 'memberOf', \"teiid_ldap:dn_prefix\" 'ou=groups,dc=metamatrix,dc=com', \"teiid_ldap:rdn_type\" 'cn')) options (nameinsource 'ou=people,dc=metamatrix,dc=com')";
        return RealMetadataFactory.fromDDL((String)ddl, (String)"x", (String)"LdapModel");
    }

    @Test
    public void testLike() throws Exception {
        String query = "Name like 'R*%'";
        String expectedContextFilter = "(cn=R\\2a*)";
        this.helpTestLike(query, expectedContextFilter);
    }

    @Test
    public void testLikeEscaped() throws Exception {
        String query = "Name like 'R%*\\%\\_' escape '\\'";
        String expectedContextFilter = "(cn=R*\\2a%_)";
        this.helpTestLike(query, expectedContextFilter);
    }

    @Test(expected=TranslatorException.class)
    public void testLikeUnsupported() throws Exception {
        String query = "Name like 'R*_'";
        String expectedContextFilter = null;
        this.helpTestLike(query, expectedContextFilter);
    }

    @Test(expected=TranslatorException.class)
    public void testLikeUnsupported1() throws Exception {
        String query = "Name like 'R\\%_' escape '\\'";
        String expectedContextFilter = null;
        this.helpTestLike(query, expectedContextFilter);
    }

    private void helpTestLike(String query, String expectedContextFilter) throws Exception {
        LDAPSearchDetails searchDetails = this.helpGetSearchDetails("SELECT UserID FROM LdapModel.People WHERE " + query);
        String expectedContextName = "ou=people,dc=metamatrix,dc=com";
        ArrayList<String> expectedAttrNameList = new ArrayList<String>();
        expectedAttrNameList.add("uid");
        long expectedCountLimit = -1L;
        int expectedSearchScope = 1;
        SortKey[] expectedSortKeys = null;
        this.helpTestSearchDetails(searchDetails, expectedContextName, expectedContextFilter, expectedAttrNameList, expectedCountLimit, expectedSearchScope, expectedSortKeys);
    }

    @Test
    public void testJoin() throws Exception {
        LDAPSearchDetails searchDetails = this.helpGetSearchDetails("SELECT UserID, Name, people_groups.groupname FROM LdapModel.People inner join people_groups on people.dn = people_groups.user_dn where Name = 'R%'");
        String expectedContextName = "ou=people,dc=metamatrix,dc=com";
        String expectedContextFilter = "(cn=R%)";
        ArrayList<String> expectedAttrNameList = new ArrayList<String>();
        expectedAttrNameList.add("uid");
        expectedAttrNameList.add("cn");
        expectedAttrNameList.add("memberOf");
        long expectedCountLimit = -1L;
        int expectedSearchScope = 1;
        SortKey[] expectedSortKeys = null;
        this.helpTestSearchDetails(searchDetails, expectedContextName, expectedContextFilter, expectedAttrNameList, expectedCountLimit, expectedSearchScope, expectedSortKeys);
    }

    @Test
    public void testRdnTypePredicates() throws Exception {
        LDAPSearchDetails searchDetails = this.helpGetSearchDetails("SELECT people_groups.groupname FROM people_groups where groupname like 'R%' and groupname < 'q'");
        String expectedContextName = "ou=people,dc=metamatrix,dc=com";
        String expectedContextFilter = "(&(memberOf=cn=R*,ou=groups,dc=metamatrix,dc=com)(!(memberOf>=cn=q,ou=groups,dc=metamatrix,dc=com)))";
        ArrayList<String> expectedAttrNameList = new ArrayList<String>();
        expectedAttrNameList.add("memberOf");
        long expectedCountLimit = -1L;
        int expectedSearchScope = 1;
        SortKey[] expectedSortKeys = null;
        this.helpTestSearchDetails(searchDetails, expectedContextName, expectedContextFilter, expectedAttrNameList, expectedCountLimit, expectedSearchScope, expectedSortKeys);
    }
}

