/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ldap;

import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.Rdn;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.SortKey;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.ArrayImpl;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.ldap.LDAPExecutionFactory;
import org.teiid.translator.ldap.LDAPPlugin;
import org.teiid.translator.ldap.LDAPSearchDetails;

public class LDAPQueryExecution
implements ResultSetExecution {
    static final String MULTIVALUED_CONCAT = "multivalued-concat";
    static final String delimiter = "?";
    private LDAPSearchDetails searchDetails;
    private LdapContext ldapCtx;
    private NamingEnumeration<?> searchEnumeration;
    private LDAPExecutionFactory executionFactory;
    private ExecutionContext executionContext;
    private SearchControls ctrls;
    private int resultCount;
    private Iterator<List<Object>> unwrapIterator;
    private int unwrapPos = -1;

    public LDAPQueryExecution(LdapContext ldapContext, LDAPSearchDetails search, SearchControls searchControls, LDAPExecutionFactory factory, ExecutionContext context) {
        this.searchDetails = search;
        this.ldapCtx = ldapContext;
        this.ctrls = searchControls;
        this.executionFactory = factory;
        this.executionContext = context;
    }

    public void execute() throws TranslatorException {
        String ctxName = this.searchDetails.getContextName();
        String filter = this.searchDetails.getContextFilter();
        if (ctxName == null || filter == null || this.ctrls == null) {
            throw new TranslatorException("Search context, filter, or controls were null. Cannot execute search.");
        }
        ArrayList<Column> attributeList = this.searchDetails.getElementList();
        for (int i = 0; i < attributeList.size(); ++i) {
            Column col = attributeList.get(i);
            if (!Boolean.valueOf(col.getProperty("teiid_ldap:unwrap", false)).booleanValue()) continue;
            if (this.unwrapPos > -1) {
                throw new TranslatorException(LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12014, new Object[]{col, attributeList.get(this.unwrapPos)}));
            }
            this.unwrapPos = i;
        }
        this.setRequestControls(null);
        this.executeSearch();
    }

    private void setRequestControls(byte[] cookie) throws TranslatorException {
        ArrayList<BasicControl> ctrl = new ArrayList<BasicControl>();
        SortKey[] keys = this.searchDetails.getSortKeys();
        try {
            if (keys != null) {
                ctrl.add(new SortControl(keys, false));
            }
            if (this.executionFactory.usePagination()) {
                ctrl.add(new PagedResultsControl(this.executionContext.getBatchSize(), cookie, true));
            }
            if (!ctrl.isEmpty()) {
                this.ldapCtx.setRequestControls(ctrl.toArray(new Control[ctrl.size()]));
                LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)"Sort/pagination controls were created successfully.");
            }
        }
        catch (NamingException ne) {
            String msg = LDAPPlugin.Util.getString("LDAPSyncQueryExecution.setControlsError") + " : " + ne.getExplanation();
            throw new TranslatorException((Throwable)ne, msg);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private void executeSearch() throws TranslatorException {
        String filter = this.searchDetails.getContextFilter();
        try {
            this.searchEnumeration = this.ldapCtx.search("", filter, this.ctrls);
        }
        catch (NamingException ne) {
            String msg = LDAPPlugin.Util.getString("LDAPSyncQueryExecution.execSearchError");
            throw new TranslatorException((Throwable)ne, msg + " : " + ne.getExplanation());
        }
        catch (Exception e) {
            String msg = LDAPPlugin.Util.getString("LDAPSyncQueryExecution.execSearchError");
            throw new TranslatorException((Throwable)e, msg);
        }
    }

    public void cancel() throws TranslatorException {
        this.close();
    }

    public void close() {
        if (this.searchEnumeration != null) {
            try {
                this.searchEnumeration.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.ldapCtx != null) {
            try {
                this.ldapCtx.close();
            }
            catch (NamingException ne) {
                LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12003, new Object[]{ne.getExplanation()}));
            }
        }
    }

    public List<?> next() throws TranslatorException {
        try {
            if (this.unwrapIterator != null) {
                if (this.unwrapIterator.hasNext()) {
                    return this.unwrapIterator.next();
                }
                this.unwrapIterator = null;
            }
            List<?> result = null;
            while (result == null && this.searchEnumeration != null && this.searchEnumeration.hasMore()) {
                SearchResult searchResult = (SearchResult)this.searchEnumeration.next();
                try {
                    result = this.getRow(searchResult);
                }
                catch (InvalidNameException invalidNameException) {}
            }
            if (result == null && this.executionFactory.usePagination()) {
                byte[] cookie = null;
                Control[] controls = this.ldapCtx.getResponseControls();
                if (controls != null) {
                    for (int i = 0; i < controls.length; ++i) {
                        if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                        PagedResultsResponseControl prrc = (PagedResultsResponseControl)controls[i];
                        cookie = prrc.getCookie();
                    }
                }
                if (cookie == null) {
                    return null;
                }
                this.setRequestControls(cookie);
                this.executeSearch();
                return this.next();
            }
            if (result != null) {
                ++this.resultCount;
            }
            return result;
        }
        catch (SizeLimitExceededException e) {
            if ((long)this.resultCount != this.searchDetails.getCountLimit()) {
                String msg = LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12008, new Object[0]);
                TranslatorException te = new TranslatorException((Throwable)e, msg);
                if (this.executionFactory.isExceptionOnSizeLimitExceeded()) {
                    throw te;
                }
                this.executionContext.addWarning((Exception)te);
                LogManager.logWarning((String)"org.teiid.CONNECTOR", (Throwable)e, (Object)msg);
            }
            return null;
        }
        catch (NamingException ne) {
            throw new TranslatorException((Throwable)ne, LDAPPlugin.Util.gs("ldap_error", new Object[0]));
        }
    }

    private List<?> getRow(SearchResult result) throws TranslatorException, InvalidNameException {
        Attributes attrs = result.getAttributes();
        ArrayList<Column> attributeList = this.searchDetails.getElementList();
        final ArrayList<Object> row = new ArrayList<Object>(attributeList.size());
        for (int i = 0; i < attributeList.size(); ++i) {
            Column col = attributeList.get(i);
            Object val = this.getValue(col, result, attrs, i == this.unwrapPos);
            row.add(val);
        }
        if (this.unwrapPos > -1) {
            Object toUnwrap = row.get(this.unwrapPos);
            if (toUnwrap == null) {
                return row;
            }
            if (toUnwrap instanceof ArrayImpl) {
                final Object[] val = ((ArrayImpl)toUnwrap).getValues();
                if (val.length == 0) {
                    row.set(this.unwrapPos, null);
                } else {
                    this.unwrapIterator = new Iterator<List<Object>>(){
                        int i = 0;

                        @Override
                        public boolean hasNext() {
                            return this.i < val.length;
                        }

                        @Override
                        public List<Object> next() {
                            ArrayList<Object> newRow = new ArrayList<Object>(row);
                            newRow.set(LDAPQueryExecution.this.unwrapPos, val[this.i++]);
                            return newRow;
                        }

                        @Override
                        public void remove() {
                        }
                    };
                    if (this.unwrapIterator.hasNext()) {
                        return this.unwrapIterator.next();
                    }
                }
            }
        }
        return row;
    }

    private Object getValue(Column modelElement, SearchResult result, Attributes attrs, boolean unwrap) throws TranslatorException, InvalidNameException {
        String modelAttrName = modelElement.getSourceName();
        Class modelAttrClass = modelElement.getJavaType();
        String multivalAttr = modelElement.getDefaultValue();
        if (modelAttrName == null) {
            String msg = LDAPPlugin.Util.getString("LDAPSyncQueryExecution.nullAttrError");
            throw new TranslatorException(msg);
        }
        Attribute resultAttr = attrs.get(modelAttrName);
        if (resultAttr == null) {
            if (modelAttrName.equalsIgnoreCase("DN")) {
                return result.getNameInNamespace();
            }
            return null;
        }
        Object objResult = null;
        try {
            if (TypeFacility.RUNTIME_TYPES.STRING.equals(modelAttrClass) && MULTIVALUED_CONCAT.equalsIgnoreCase(multivalAttr)) {
                ArrayList<String> multivalList = new ArrayList<String>();
                NamingEnumeration<?> attrNE = resultAttr.getAll();
                int length = 0;
                while (attrNE.hasMore()) {
                    String val = (String)attrNE.next();
                    multivalList.add(val);
                    length += (val == null ? 0 : val.length()) + 1;
                }
                Collections.sort(multivalList);
                StringBuilder multivalSB = new StringBuilder(length);
                Iterator itr = multivalList.iterator();
                while (itr.hasNext()) {
                    multivalSB.append((String)itr.next());
                    if (!itr.hasNext()) continue;
                    multivalSB.append(delimiter);
                }
                return multivalSB.toString();
            }
            if (modelAttrClass.isArray()) {
                return this.getArray(modelAttrClass.getComponentType(), resultAttr, modelElement, modelAttrName);
            }
            if (unwrap && resultAttr.size() > 1) {
                return this.getArray(modelAttrClass, resultAttr, modelElement, modelAttrName);
            }
            objResult = resultAttr.get();
        }
        catch (NamingException ne) {
            String msg = LDAPPlugin.Util.gs((BundleUtil.Event)LDAPPlugin.Event.TEIID12004, new Object[]{modelAttrName}) + " : " + ne.getExplanation();
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)msg);
            throw new TranslatorException((Throwable)ne, msg);
        }
        return this.convertSingleValue(modelElement, modelAttrName, modelAttrClass, objResult);
    }

    private Object convertSingleValue(Column modelElement, String modelAttrName, Class<?> modelAttrClass, Object objResult) throws TranslatorException, InvalidNameException {
        if (objResult == null) {
            return null;
        }
        if (!(objResult instanceof String)) {
            return objResult;
        }
        String strResult = (String)objResult;
        if (strResult.equals("")) {
            return null;
        }
        if (TypeFacility.RUNTIME_TYPES.TIMESTAMP.equals(modelAttrClass)) {
            String timestampFormat = modelElement.getFormat();
            if (timestampFormat == null) {
                timestampFormat = "yyyyMMddhhmmss'Z'";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(timestampFormat);
            try {
                Date dateResult = dateFormat.parse(strResult);
                Timestamp tsResult = new Timestamp(dateResult.getTime());
                return tsResult;
            }
            catch (ParseException pe) {
                throw new TranslatorException((Throwable)pe, LDAPPlugin.Util.getString("LDAPSyncQueryExecution.timestampParseFailed", new Object[]{modelAttrName}));
            }
        }
        String type = modelElement.getProperty("teiid_ldap:rdn_type", false);
        if (type != null) {
            String prefix = modelElement.getProperty("teiid_ldap:dn_prefix", false);
            LdapName name = new LdapName(strResult);
            if (prefix != null ? !name.getPrefix(name.size() - 1).toString().equals(prefix) : name.size() > 1) {
                throw new InvalidNameException();
            }
            Rdn rdn = name.getRdn(name.size() - 1);
            if (!rdn.getType().equals(type)) {
                throw new InvalidNameException();
            }
            return rdn.getValue();
        }
        return strResult;
    }

    private ArrayImpl getArray(Class<?> componentType, Attribute resultAttr, Column modelElement, String modelAttrName) throws NamingException, TranslatorException {
        ArrayList<Object> multivalList = new ArrayList<Object>();
        NamingEnumeration<?> attrNE = resultAttr.getAll();
        int length = 0;
        while (attrNE.hasMore()) {
            try {
                multivalList.add(this.convertSingleValue(modelElement, modelAttrName, componentType, attrNE.next()));
                ++length;
            }
            catch (InvalidNameException invalidNameException) {}
        }
        Object[] values = (Object[])Array.newInstance(componentType, length);
        ArrayImpl value = new ArrayImpl(multivalList.toArray(values));
        return value;
    }

    LDAPSearchDetails getSearchDetails() {
        return this.searchDetails;
    }
}

