/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBRef;
import java.sql.Date;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.MongoDBMetadataProcessor;

public class TestMongoDBMetadataProcessor {
    @Test
    public void testMetadata() throws TranslatorException {
        MongoDBMetadataProcessor mp = new MongoDBMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "mongodb", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        MongoDBConnection conn = (MongoDBConnection)Mockito.mock(MongoDBConnection.class);
        DBCollection tableDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DBCollection embeddedDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DBCollection emptyDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DBCollection emptyFirstDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        tables.add("table");
        tables.add("embedded");
        tables.add("empty");
        tables.add("emptyFirst");
        DB db = (DB)Mockito.mock(DB.class);
        BasicDBList array = new BasicDBList();
        array.add((Object)"one");
        array.add((Object)"two");
        BasicDBObject row = new BasicDBObject();
        row.append("_id", (Object)new Integer(1));
        row.append("col2", (Object)new Double(2.0));
        row.append("col3", (Object)new Long(3L));
        row.append("col5", (Object)Boolean.TRUE);
        row.append("col6", (Object)new Date(0L));
        row.append("col6", (Object)new DBRef(db.getName(), "ns", (Object)"one"));
        row.append("col7", (Object)array);
        row.append("col8", (Object)new Binary("binary".getBytes()));
        BasicDBObject child = new BasicDBObject();
        child.append("col1", (Object)"one");
        child.append("col2", (Object)"two");
        row.append("child", (Object)child);
        BasicDBObject emptyFirstRow = new BasicDBObject();
        emptyFirstRow.append("_id", (Object)new ObjectId("5835a598944716c40d2f26ae"));
        emptyFirstRow.append("col2", (Object)new Double(2.0));
        emptyFirstRow.append("col3", (Object)new Long(3L));
        BasicDBObject embedded = new BasicDBObject();
        embedded.append("col1", (Object)"one");
        embedded.append("col2", (Object)"two");
        row.append("embedded", (Object)embedded);
        Mockito.stub((Object)db.getCollectionNames()).toReturn(tables);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"table"))).toReturn((Object)tableDBCollection);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"embedded"))).toReturn((Object)embeddedDBCollection);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"empty"))).toReturn((Object)emptyDBCollection);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"emptyFirst"))).toReturn((Object)emptyFirstDBCollection);
        DBCursor tableCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)tableCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)tableCursor.next()).thenReturn((Object)row);
        Mockito.when((Object)tableDBCollection.find()).thenReturn((Object)tableCursor);
        DBCursor embeddedCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)embeddedCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)embeddedCursor.next()).thenReturn((Object)child);
        Mockito.when((Object)embeddedDBCollection.find()).thenReturn((Object)embeddedCursor);
        DBCursor emptyFirstCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)emptyFirstCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)emptyFirstCursor.next()).thenReturn(null).thenReturn((Object)emptyFirstRow);
        Mockito.when((Object)emptyFirstDBCollection.find()).thenReturn((Object)emptyFirstCursor);
        DBCursor emptyCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)emptyCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)emptyCursor.next()).thenReturn(null);
        Mockito.when((Object)emptyDBCollection.find()).thenReturn((Object)emptyCursor);
        Mockito.stub((Object)conn.getDatabase()).toReturn((Object)db);
        mp.process(mf, conn);
        String metadataDDL = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        String expected = "SET NAMESPACE 'http://www.teiid.org/translator/mongodb/2013' AS teiid_mongo;\n\nCREATE FOREIGN TABLE \"table\" (\n\t\"_id\" integer,\n\tcol2 double,\n\tcol3 long,\n\tcol5 boolean,\n\tcol6 string,\n\tcol7 object[] OPTIONS (SEARCHABLE 'Unsearchable'),\n\tcol8 varbinary OPTIONS (NATIVE_TYPE 'org.bson.types.Binary'),\n\tCONSTRAINT PK0 PRIMARY KEY(\"_id\"),\n\tCONSTRAINT FK_col6 FOREIGN KEY(col6) REFERENCES ns \n) OPTIONS (UPDATABLE TRUE);\n\nCREATE FOREIGN TABLE child (\n\tcol1 string,\n\tcol2 string,\n\t\"_id\" integer OPTIONS (UPDATABLE FALSE),\n\tCONSTRAINT PK0 PRIMARY KEY(\"_id\"),\n\tFOREIGN KEY(\"_id\") REFERENCES \"table\" \n) OPTIONS (UPDATABLE TRUE, \"teiid_mongo:MERGE\" 'table');\n\nCREATE FOREIGN TABLE embedded (\n\tcol1 string,\n\tcol2 string,\n\t\"_id\" integer OPTIONS (UPDATABLE FALSE),\n\tCONSTRAINT PK0 PRIMARY KEY(\"_id\"),\n\tFOREIGN KEY(\"_id\") REFERENCES \"table\" \n) OPTIONS (UPDATABLE TRUE, \"teiid_mongo:EMBEDDABLE\" 'true');\n\nCREATE FOREIGN TABLE emptyFirst (\n\t\"_id\" string AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'org.bson.types.ObjectId'),\n\tcol2 double,\n\tcol3 long,\n\tCONSTRAINT PK0 PRIMARY KEY(\"_id\")\n) OPTIONS (UPDATABLE TRUE);";
        Assert.assertEquals((Object)expected, (Object)metadataDDL);
    }

    @Test
    public void testExclusion() throws TranslatorException {
        MongoDBMetadataProcessor mp = new MongoDBMetadataProcessor();
        mp.setExcludeTables("e.*");
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "mongodb", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        MongoDBConnection conn = (MongoDBConnection)Mockito.mock(MongoDBConnection.class);
        DBCollection tableDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DBCollection embeddedDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DBCollection emptyDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DBCollection emptyFirstDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        tables.add("table");
        tables.add("embedded");
        tables.add("empty");
        tables.add("emptyFirst");
        DB db = (DB)Mockito.mock(DB.class);
        BasicDBList array = new BasicDBList();
        array.add((Object)"one");
        array.add((Object)"two");
        BasicDBObject row = new BasicDBObject();
        row.append("_id", (Object)new Integer(1));
        row.append("col2", (Object)new Double(2.0));
        row.append("col3", (Object)new Long(3L));
        row.append("col5", (Object)Boolean.TRUE);
        row.append("col6", (Object)new Date(0L));
        row.append("col6", (Object)new DBRef(db.getName(), "ns", (Object)"one"));
        row.append("col7", (Object)array);
        row.append("col8", (Object)new Binary("binary".getBytes()));
        BasicDBObject child = new BasicDBObject();
        child.append("col1", (Object)"one");
        child.append("col2", (Object)"two");
        row.append("child", (Object)child);
        BasicDBObject emptyFirstRow = new BasicDBObject();
        emptyFirstRow.append("_id", (Object)new ObjectId("5835a598944716c40d2f26ae"));
        emptyFirstRow.append("col2", (Object)new Double(2.0));
        emptyFirstRow.append("col3", (Object)new Long(3L));
        BasicDBObject embedded = new BasicDBObject();
        embedded.append("col1", (Object)"one");
        embedded.append("col2", (Object)"two");
        row.append("embedded", (Object)embedded);
        Mockito.stub((Object)db.getCollectionNames()).toReturn(tables);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"table"))).toReturn((Object)tableDBCollection);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"embedded"))).toReturn((Object)embeddedDBCollection);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"empty"))).toReturn((Object)emptyDBCollection);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"emptyFirst"))).toReturn((Object)emptyFirstDBCollection);
        DBCursor tableCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)tableCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)tableCursor.next()).thenReturn((Object)row);
        Mockito.when((Object)tableDBCollection.find()).thenReturn((Object)tableCursor);
        DBCursor embeddedCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)embeddedCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)embeddedCursor.next()).thenReturn((Object)child);
        Mockito.when((Object)embeddedDBCollection.find()).thenReturn((Object)embeddedCursor);
        DBCursor emptyFirstCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)emptyFirstCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)emptyFirstCursor.next()).thenReturn(null).thenReturn((Object)emptyFirstRow);
        Mockito.when((Object)emptyFirstDBCollection.find()).thenReturn((Object)emptyFirstCursor);
        DBCursor emptyCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)emptyCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)emptyCursor.next()).thenReturn(null);
        Mockito.when((Object)emptyDBCollection.find()).thenReturn((Object)emptyCursor);
        Mockito.stub((Object)conn.getDatabase()).toReturn((Object)db);
        mp.process(mf, conn);
        String metadataDDL = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        String expected = "SET NAMESPACE 'http://www.teiid.org/translator/mongodb/2013' AS teiid_mongo;\n\nCREATE FOREIGN TABLE \"table\" (\n\t\"_id\" integer,\n\tcol2 double,\n\tcol3 long,\n\tcol5 boolean,\n\tcol6 string,\n\tcol7 object[] OPTIONS (SEARCHABLE 'Unsearchable'),\n\tcol8 varbinary OPTIONS (NATIVE_TYPE 'org.bson.types.Binary'),\n\tCONSTRAINT PK0 PRIMARY KEY(\"_id\"),\n\tCONSTRAINT FK_col6 FOREIGN KEY(col6) REFERENCES ns \n) OPTIONS (UPDATABLE TRUE);\n\nCREATE FOREIGN TABLE child (\n\tcol1 string,\n\tcol2 string,\n\t\"_id\" integer OPTIONS (UPDATABLE FALSE),\n\tCONSTRAINT PK0 PRIMARY KEY(\"_id\"),\n\tFOREIGN KEY(\"_id\") REFERENCES \"table\" \n) OPTIONS (UPDATABLE TRUE, \"teiid_mongo:MERGE\" 'table');\n\nCREATE FOREIGN TABLE embedded (\n\tcol1 string,\n\tcol2 string,\n\t\"_id\" integer OPTIONS (UPDATABLE FALSE),\n\tCONSTRAINT PK0 PRIMARY KEY(\"_id\"),\n\tFOREIGN KEY(\"_id\") REFERENCES \"table\" \n) OPTIONS (UPDATABLE TRUE, \"teiid_mongo:MERGE\" 'table');";
        Assert.assertEquals((Object)expected, (Object)metadataDDL);
    }
}

