/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import java.io.File;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.CommandContext;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Command;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.mongodb.EmbeddedMongoDB;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;
import org.teiid.translator.mongodb.MongoDBQueryExecution;

@Ignore
public class TestEmbeddedMongoExecution {
    private static MongoDBExecutionFactory translator;
    private static TranslationUtility utility;
    private static EmbeddedMongoDB mongodb;
    private MongoClient client;
    private MongoDBConnection connection;

    @BeforeClass
    public static void setUp() throws Exception {
        translator = new MongoDBExecutionFactory();
        translator.start();
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"test.ddl")), (String)"test", (String)"dummy");
        utility = new TranslationUtility((QueryMetadataInterface)metadata);
        mongodb = new EmbeddedMongoDB();
    }

    @Before
    public void beforeTest() throws Exception {
        this.client = new MongoClient("localhost", 12345);
        this.connection = TestEmbeddedMongoExecution.getConnection(this.client);
    }

    @After
    public void afterTest() throws Exception {
        this.connection.close();
        this.client.close();
    }

    private static MongoDBConnection getConnection(MongoClient client) {
        MongoDBConnection connection = (MongoDBConnection)Mockito.mock(MongoDBConnection.class);
        Mockito.stub((Object)connection.getDatabase()).toReturn((Object)client.getDB("test"));
        return connection;
    }

    public static void stop() {
        mongodb.stop();
    }

    private Execution executeCmd(String sql) throws Exception {
        Command cmd = utility.parseCommand(sql);
        CommandContext cc = (CommandContext)Mockito.mock(CommandContext.class);
        Mockito.stub((Object)cc.isReturnAutoGeneratedKeys()).toReturn((Object)false);
        ExecutionContext ec = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        Mockito.stub((Object)ec.getCommandContext()).toReturn((Object)cc);
        Execution exec = translator.createExecution(cmd, ec, utility.createRuntimeMetadata(), (Object)this.connection);
        exec.execute();
        return exec;
    }

    @Test
    public void testSingleTableExecution() throws Exception {
        this.executeCmd("delete from G1");
        this.executeCmd("insert into G1 (e1, e2, e3) values (1, 1, 1)");
        this.executeCmd("insert into G1 (e1, e2, e3) values (2, 2, 2)");
        this.executeCmd("insert into G1 (e1, e2, e3) values (3, 3, 3)");
        MongoDBQueryExecution exec = (MongoDBQueryExecution)this.executeCmd("select * from G1");
        Assert.assertEquals(Arrays.asList(1, 1, 1), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(2, 2, 2), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(3, 3, 3), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        this.executeCmd("update G1 set e2=4 where e3 >= 2");
        exec = (MongoDBQueryExecution)this.executeCmd("select * from G1");
        Assert.assertEquals(Arrays.asList(1, 1, 1), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(2, 4, 2), (Object)exec.next());
        Assert.assertEquals(Arrays.asList(3, 4, 3), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        this.executeCmd("delete from G1 where e2=4");
        exec = (MongoDBQueryExecution)this.executeCmd("select * from G1");
        Assert.assertEquals(Arrays.asList(1, 1, 1), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
    }

    @Test
    public void testOne2OneMerge() throws Exception {
        this.executeCmd("delete from G1");
        this.executeCmd("insert into G1 (e1, e2, e3) values (1, 1, 1)");
        this.executeCmd("insert into G2 (e1, e2, e3) values (1, 2, 3)");
        MongoDBQueryExecution exec = (MongoDBQueryExecution)this.executeCmd("select * from G2");
        Assert.assertEquals(Arrays.asList(1, 2, 3), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        MongoClient client = new MongoClient("localhost", 12345);
        Assert.assertNull((Object)client.getDB("test").getCollection("G2").findOne());
        BasicDBObject row = new BasicDBObject("_id", (Object)1).append("e2", (Object)1).append("e3", (Object)1);
        row.append("G2", (Object)new BasicDBObject("e2", (Object)2).append("e3", (Object)3));
        Assert.assertEquals((Object)row, (Object)client.getDB("test").getCollection("G1").findOne());
        exec = (MongoDBQueryExecution)this.executeCmd("select g1.e1, g1.e2, g2.e3 from G1 JOIN G2 ON G1.e1=G2.e1");
        Assert.assertEquals(Arrays.asList(1, 1, 3), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        client.close();
    }

    @Test
    public void testOne2ManyMerge() throws Exception {
        this.executeCmd("delete from G1");
        this.executeCmd("insert into G1 (e1, e2, e3) values (1, 1, 1)");
        this.executeCmd("insert into G3 (e1, e2, e3) values (2, 1, 3)");
        MongoDBQueryExecution exec = (MongoDBQueryExecution)this.executeCmd("select * from G3");
        Assert.assertEquals(Arrays.asList(2, 1, 3), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        MongoClient client = new MongoClient("localhost", 12345);
        Assert.assertNull((Object)client.getDB("test").getCollection("G3").findOne());
        BasicDBObject row = new BasicDBObject("_id", (Object)1).append("e2", (Object)1).append("e3", (Object)1);
        BasicDBList list = new BasicDBList();
        list.add((Object)new BasicDBObject("_id", (Object)2).append("e3", (Object)3));
        row.append("G3", (Object)list);
        Assert.assertEquals((Object)row, (Object)client.getDB("test").getCollection("G1").findOne());
        exec = (MongoDBQueryExecution)this.executeCmd("select G1.e1, G1.e2, G3.e2, G3.e3 from G1 JOIN G3 ON G1.e1=G3.e2");
        Assert.assertEquals(Arrays.asList(1, 1, 1, 3), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        this.executeCmd("update G3 set e3=4 where e2=1");
        exec = (MongoDBQueryExecution)this.executeCmd("select G1.e1, G1.e2, G3.e2, G3.e3 from G1 JOIN G3 ON G1.e1=G3.e2");
        Assert.assertEquals(Arrays.asList(1, 1, 1, 4), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        this.executeCmd("delete from G3 where G3.e2=1");
        exec = (MongoDBQueryExecution)this.executeCmd("select G1.e1, G1.e2, G3.e2, G3.e3 from G1 JOIN G3 ON G1.e1=G3.e2");
        Assert.assertNull((Object)exec.next());
        client.close();
    }

    @Test
    public void testEmbedded() throws Exception {
        this.executeCmd("delete from G1");
        this.executeCmd("insert into G4 (e1, e2, e3) values (2, 2, 3)");
        this.executeCmd("insert into G1E (e1, e2, e3, e4) values (2, 2, 2, 2)");
        MongoDBQueryExecution exec = (MongoDBQueryExecution)this.executeCmd("select * from G4");
        Assert.assertEquals(Arrays.asList(2, 2, 3), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        BasicDBObject g4_row = new BasicDBObject("_id", (Object)2).append("e2", (Object)2).append("e3", (Object)3);
        MongoClient client = new MongoClient("localhost", 12345);
        Assert.assertEquals((Object)g4_row, (Object)client.getDB("test").getCollection("G4").findOne());
        BasicDBObject row = new BasicDBObject("_id", (Object)2).append("e2", (Object)2).append("e3", (Object)2).append("e4", (Object)2);
        row.append("G4", (Object)new BasicDBObject("e2", (Object)2).append("e3", (Object)3));
        Assert.assertEquals((Object)row, (Object)client.getDB("test").getCollection("G1E").findOne());
        exec = (MongoDBQueryExecution)this.executeCmd("select G1E.e1, G1E.e2, G4.e3 from G1E JOIN G4 ON G1E.e1=G4.e1");
        Assert.assertEquals(Arrays.asList(2, 2, 3), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        client.close();
    }

    @Test
    public void testTimeFunction() throws Exception {
        this.executeCmd("delete from TIME_TEST");
        this.executeCmd("insert into TIME_TEST (e1, e2) values (1, null)");
        MongoDBQueryExecution exec = (MongoDBQueryExecution)this.executeCmd("select * from TIME_TEST where YEAR(e2) = 1");
        Assert.assertNull((Object)exec.next());
        this.executeCmd("insert into TIME_TEST (e1, e2) values (2, '2001-01-01 01:02:03')");
        exec = (MongoDBQueryExecution)this.executeCmd("SELECT e2, second(e2) as sec FROM TIME_TEST WHERE second(e2) >= 0");
        Assert.assertEquals(Arrays.asList(TimestampUtil.createTimestamp((int)101, (int)0, (int)1, (int)1, (int)2, (int)3, (int)0), 3), (Object)exec.next());
        this.client.close();
    }

    @Test
    public void testGroupByHaving() throws Exception {
        this.executeCmd("delete from TIME_TEST");
        this.executeCmd("insert into TIME_TEST (e1, e2) values (1, null)");
        this.executeCmd("insert into TIME_TEST (e1, e2) values (2, null)");
        String sql = "SELECT max(e1), e2, count(*) FROM TIME_TEST GROUP BY e2 HAVING count(*) = 2";
        MongoDBQueryExecution exec = (MongoDBQueryExecution)this.executeCmd(sql);
        Assert.assertEquals(Arrays.asList(2, null, 2), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        sql = "SELECT min(e1), e2 FROM TIME_TEST GROUP BY e2 HAVING count(*) = 2";
        exec = (MongoDBQueryExecution)this.executeCmd(sql);
        Assert.assertEquals(Arrays.asList(1, null), (Object)exec.next());
        Assert.assertNull((Object)exec.next());
        sql = "SELECT min(e1)+1, e2 FROM TIME_TEST GROUP BY e2";
        this.client.close();
    }
}

