/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.AggregationOptions;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.io.File;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Table;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.GeometryUtils;
import org.teiid.query.function.UDFSource;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.TestDDLParser;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;

public class TestMongoDBQueryExecution {
    private MongoDBExecutionFactory translator;
    private TranslationUtility utility;
    private static AggregationOptions options = AggregationOptions.builder().batchSize(Integer.valueOf(256)).outputMode(AggregationOptions.OutputMode.CURSOR).allowDiskUse(Boolean.valueOf(true)).build();

    @Before
    public void setUp() throws Exception {
        this.translator = new MongoDBExecutionFactory();
        this.translator.setDatabaseVersion("2.6");
        this.translator.start();
        MetadataFactory mf = TestDDLParser.helpParse((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"northwind.ddl")), (String)"northwind");
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"sakila", (FunctionTree[])new FunctionTree[]{new FunctionTree("mongo", (FunctionMetadataSource)new UDFSource((Collection)this.translator.getPushDownFunctions()))});
        ValidatorReport report = new MetadataValidator().validate(metadata.getVdbMetaData(), (MetadataStore)metadata.getMetadataStore());
        if (report.hasItems()) {
            throw new RuntimeException(report.getFailureMessage());
        }
        this.utility = new TranslationUtility((QueryMetadataInterface)metadata);
    }

    private DBCollection helpExecute(String query, String[] expectedCollection, int expectedParameters) throws TranslatorException {
        Command cmd = this.utility.parseCommand(query);
        return this.helpExecute(cmd, expectedCollection, expectedParameters);
    }

    private DBCollection helpExecute(Command cmd, String[] expectedCollection, int expectedParameters) throws TranslatorException {
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        Mockito.stub((Object)context.getBatchSize()).toReturn((Object)256);
        MongoDBConnection connection = (MongoDBConnection)Mockito.mock(MongoDBConnection.class);
        DB db = (DB)Mockito.mock(DB.class);
        DBCollection dbCollection = (DBCollection)Mockito.mock(DBCollection.class);
        for (String collection : expectedCollection) {
            Mockito.stub((Object)db.getCollection(collection)).toReturn((Object)dbCollection);
        }
        AggregationOutput output = (AggregationOutput)Mockito.mock(AggregationOutput.class);
        Mockito.stub((Object)output.results()).toReturn(new ArrayList());
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 0; i < expectedParameters; ++i) {
            params.add(Mockito.any(DBObject.class));
        }
        Mockito.stub((Object)dbCollection.aggregate((DBObject)params.remove(0), params.toArray(new DBObject[params.size()]))).toReturn((Object)output);
        Mockito.stub((Object)db.collectionExists(Mockito.anyString())).toReturn((Object)true);
        Mockito.stub((Object)connection.getDatabase()).toReturn((Object)db);
        Mockito.stub((Object)db.getCollectionFromString(Mockito.anyString())).toReturn((Object)dbCollection);
        ResultSetExecution execution = this.translator.createResultSetExecution((QueryExpression)cmd, context, this.utility.createRuntimeMetadata(), connection);
        execution.execute();
        return dbCollection;
    }

    @Test
    public void testSimpleSelectNoAssosiations() throws Exception {
        String query = "SELECT * FROM Customers";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Customers"}, 1);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$_id");
        result.append("_m1", (Object)"$CompanyName");
        result.append("_m2", (Object)"$ContactName");
        result.append("_m3", (Object)"$ContactTitle");
        result.append("_m4", (Object)"$Address");
        result.append("_m5", (Object)"$City");
        result.append("_m6", (Object)"$Region");
        result.append("_m7", (Object)"$PostalCode");
        result.append("_m8", (Object)"$Country");
        result.append("_m9", (Object)"$Phone");
        result.append("_m10", (Object)"$Fax");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSimpleWhere() throws Exception {
        String query = "SELECT CompanyName, ContactTitle FROM Customers WHERE Country='USA'";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Customers"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$CompanyName");
        result.append("_m1", (Object)"$ContactTitle");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)new BasicDBObject("Country", (Object)"USA")), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSelectEmbeddable() throws Exception {
        String query = "SELECT CategoryName FROM Categories";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 1);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$CategoryName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSelectEmbeddableWithWhere_ON_NONPK() throws Exception {
        String query = "SELECT CategoryName FROM Categories WHERE CategoryName = 'Drinks'";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$CategoryName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)new BasicDBObject("CategoryName", (Object)"Drinks")), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSelectEmbeddableWithWhere_ON_PK() throws Exception {
        String query = "SELECT CategoryName FROM Categories WHERE CategoryID = 10";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$CategoryName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)new BasicDBObject("_id", (Object)10)), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSelectFromMerged() throws Exception {
        String query = "SELECT UnitPrice FROM OrderDetails";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Orders"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$OrderDetails.UnitPrice");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$unwind", (Object)"$OrderDetails"), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSelectMergedWithWhere_ON_NON_PK() throws Exception {
        String query = "SELECT Quantity FROM OrderDetails WHERE UnitPrice = '0.99'";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Orders"}, 3);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$OrderDetails.Quantity");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$unwind", (Object)"$OrderDetails"), new BasicDBObject("$match", (Object)new BasicDBObject("OrderDetails.UnitPrice", (Object)0.99)), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSelectMergedWithWhere_ON_NON_PK_one_to_one() throws Exception {
        String query = "SELECT cust_id, zip FROM Address WHERE Street = 'Highway 100'";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"customer"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$_id");
        result.append("_m1", (Object)"$address.zip");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)QueryBuilder.start((String)"address").exists((Object)"true").notEquals(null).get()), new BasicDBObject("$match", (Object)new BasicDBObject("address.street", (Object)"Highway 100")), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSelectONE_TO_ONE() throws Exception {
        String query = "SELECT c.name, a.zip FROM customer c join address a on c.customer_id=a.cust_id";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"customer"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$name");
        result.append("_m1", (Object)"$address.zip");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)new BasicDBObject("address", (Object)new BasicDBObject("$exists", (Object)"true").append("$ne", null))), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSelectMergedWithNOWhere_one_to_one() throws Exception {
        String query = "SELECT cust_id, zip FROM Address";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"customer"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$_id");
        result.append("_m1", (Object)"$address.zip");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)QueryBuilder.start((String)"address").exists((Object)"true").notEquals(null).get()), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testTwoTableInnerJoinEmbeddableAssosiationOne() throws Exception {
        String query = "select p.ProductName, c.CategoryName from Products p join Categories c on p.CategoryID = c.CategoryID";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Products"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$ProductName");
        result.append("_m1", (Object)"$Categories.CategoryName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)QueryBuilder.start((String)"Categories").exists((Object)"true").notEquals(null).get()), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testTwoTableInnerJoinEmbeddableWithWhere() throws Exception {
        String query = "select p.ProductName, c.CategoryName from Products p JOIN Categories c on p.CategoryID = c.CategoryID WHERE p.CategoryID = 1 AND c.CategoryID = 1";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Products"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$ProductName");
        result.append("_m1", (Object)"$Categories.CategoryName");
        DBObject exists = QueryBuilder.start((String)"Categories").exists((Object)"true").notEquals(null).get();
        DBObject p1 = QueryBuilder.start((String)"CategoryID").is((Object)1).get();
        DBObject p2 = QueryBuilder.start((String)"CategoryID").is((Object)1).get();
        DBObject match = QueryBuilder.start().and(new DBObject[]{p1, p2}).get();
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)exists), new BasicDBObject("$match", (Object)match), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSelectNestedEmbedding() throws Exception {
        String query = "select T1.e1, T1.e2, T2.t2e1, T2.t2e2, T3.t3e1, T3.t3e2 from T1 JOIN T2 ON T1.e1=T2.t2e1 JOIN T3 ON T2.t2e1 = T3.t3e1";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"T1", "T2", "T3"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$e1");
        result.append("_m1", (Object)"$_id");
        result.append("_m2", (Object)"$e1");
        result.append("_m3", (Object)"$T2.t2e2");
        result.append("_m4", (Object)"$e1");
        result.append("_m5", (Object)"$T3.t3e2");
        DBObject t2 = QueryBuilder.start((String)"T2").exists((Object)"true").notEquals(null).get();
        DBObject t3 = QueryBuilder.start((String)"T3").exists((Object)"true").notEquals(null).get();
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)t2), new BasicDBObject("$match", (Object)t3), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSelectNestedMerge() throws Exception {
        String query = "select * from payment";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"customer"}, 3);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$rental.payment._id");
        result.append("_m1", (Object)"$rental._id");
        result.append("_m2", (Object)"$rental.payment.amount");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$unwind", (Object)"$rental"), new BasicDBObject("$unwind", (Object)"$rental.payment"), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testEmbeddedJoin_INNER() throws Exception {
        String query = "SELECT p.ProductName,s.CompanyName FROM Suppliers s JOIN Products p ON s.SupplierID = p.SupplierID";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Products"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$ProductName");
        result.append("_m1", (Object)"$Suppliers.CompanyName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)QueryBuilder.start((String)"Suppliers").exists((Object)"true").notEquals(null).get()), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testEmbeddedJoin_INNER_REVERSE() throws Exception {
        String query = "SELECT p.ProductName,s.CompanyName FROM Products p JOIN Suppliers s ON s.SupplierID = p.SupplierID";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Products"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$ProductName");
        result.append("_m1", (Object)"$Suppliers.CompanyName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)QueryBuilder.start((String)"Suppliers").exists((Object)"true").notEquals(null).get()), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test(expected=TranslatorException.class)
    public void testEmbeddedJoin_LEFTOUTER() throws Exception {
        String query = "SELECT p.ProductName,s.CompanyName FROM Suppliers s LEFT OUTER JOIN Products p ON s.SupplierID = p.SupplierID";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Products"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$ProductName");
        result.append("_m1", (Object)"$Suppliers.CompanyName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)QueryBuilder.start((String)"SupplierID").notEquals(null).and(new DBObject[]{QueryBuilder.start((String)"Suppliers._id").notEquals(null).get()}).get()), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testEmbeddedJoin_LEFTOUTER2() throws Exception {
        String query = "SELECT p.ProductName,s.CompanyName FROM  Products p LEFT OUTER JOIN Suppliers s ON s.SupplierID = p.SupplierID";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Products"}, 1);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$ProductName");
        result.append("_m1", (Object)"$Suppliers.CompanyName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testEmbeddedJoin_RIGHTOUTER() throws Exception {
        String query = "SELECT p.ProductName,s.CompanyName FROM Suppliers s RIGHT OUTER JOIN Products p ON s.SupplierID = p.SupplierID";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Products"}, 1);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$ProductName");
        result.append("_m1", (Object)"$Suppliers.CompanyName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test(expected=TranslatorException.class)
    public void testEmbeddedJoin_RIGHTOUTER2() throws Exception {
        String query = "SELECT p.ProductName,s.CompanyName FROM  Products p RIGHT OUTER JOIN Suppliers s ON s.SupplierID = p.SupplierID";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Products"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$ProductName");
        result.append("_m1", (Object)"$Suppliers.CompanyName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)QueryBuilder.start((String)"_id").notEquals(null).get()), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testMERGE_ONE_TO_MANY_Join_INNER() throws Exception {
        String query = "SELECT c.name,n.Comment,n.CustomerId FROM customer c JOIN Notes n ON c.customer_id = n.CustomerId";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"customer"}, 3);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$name");
        result.append("_m1", (Object)"$Notes.Comment");
        result.append("_m2", (Object)"$_id");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$unwind", (Object)"$Notes"), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testMERGE_ONE_TO_ONE_Join_INNER_ORDERBY() throws Exception {
        String query = "SELECT N2.e1 AS c_0, N1.e1 AS c_1, N1.e2 AS c_2, N1.e3 AS c_3, N2.e2 AS c_4, N2.e3 AS c_5 FROM N1 INNER JOIN N2 ON N1.e1 = N2.e1 ORDER BY c_0";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"N1"}, 3);
        BasicDBObject result = new BasicDBObject();
        result.append("c_0", (Object)"$_id");
        result.append("c_1", (Object)"$_id");
        result.append("c_2", (Object)"$e2");
        result.append("c_3", (Object)"$e3");
        result.append("c_4", (Object)"$N2.e2");
        result.append("c_5", (Object)"$N2.e3");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)QueryBuilder.start((String)"N2").exists((Object)"true").notEquals(null).get()), new BasicDBObject("$project", (Object)result), new BasicDBObject("$sort", (Object)new BasicDBObject("c_1", (Object)1))});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testMERGE_ONE_TO_MANY_Join_LEFT_OUTER() throws Exception {
        String query = "SELECT c.name,n.Comment FROM customer c LEFT JOIN Notes n ON c.customer_id = n.CustomerId";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"customer"}, 3);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$name");
        result.append("_m1", (Object)"$__NN_Notes.Comment");
        BasicDBObject ifnull = this.buildIfNullExpression("Notes");
        BasicDBObject project = new BasicDBObject();
        project.append("customer_id", (Object)1);
        project.append("name", (Object)1);
        project.append("__NN_Notes", (Object)ifnull);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)project), new BasicDBObject("$unwind", (Object)"$__NN_Notes"), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testMERGE_ONE_TO_MANY_Join_LEFT_OUTER4() throws Exception {
        String query = "SELECT c.name,n.Comment FROM customer c RIGHT JOIN Notes n ON c.customer_id = n.CustomerId";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"customer"}, 3);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$name");
        result.append("_m1", (Object)"$Notes.Comment");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$unwind", (Object)"$Notes"), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testMERGE_ONE_TO_MANY_Join_LEFT_OUTER3() throws Exception {
        String query = "SELECT c.name,n.Comment FROM Notes n LEFT JOIN Customer c ON c.customer_id = n.CustomerId";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"customer"}, 3);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$name");
        result.append("_m1", (Object)"$Notes.Comment");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$unwind", (Object)"$Notes"), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testMERGE_ONE_TO_MANY_Join_INNER_OUTER2() throws Exception {
        String query = "SELECT c.name,n.Comment ,r.amount FROM customer c LEFT JOIN Notes n ON c.customer_id = n.CustomerId LEFT JOIN rental r ON r.customer_id = c.customer_id";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"customer"}, 4);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$name");
        result.append("_m1", (Object)"$__NN_Notes.Comment");
        result.append("_m2", (Object)"$__NN_rental.amount");
        BasicDBObject project = new BasicDBObject();
        project.append("customer_id", (Object)1);
        project.append("name", (Object)1);
        project.append("__NN_Notes", (Object)this.buildIfNullExpression("Notes"));
        project.append("__NN_rental", (Object)this.buildIfNullExpression("rental"));
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)project), new BasicDBObject("$unwind", (Object)"$__NN_Notes"), new BasicDBObject("$unwind", (Object)"$__NN_rental"), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    private BasicDBObject buildIfNullExpression(String table) {
        BasicDBList exprs = new BasicDBList();
        exprs.add((Object)("$" + table));
        BasicDBList list = new BasicDBList();
        list.add((Object)new BasicDBObject());
        exprs.add((Object)list);
        BasicDBObject ifnull = new BasicDBObject("$ifNull", (Object)exprs);
        return ifnull;
    }

    @Test
    public void testSimpleGroupBy() throws Exception {
        String query = "SELECT Country FROM Customers GROUP BY Country";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Customers"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$_id._c0");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("_c0", (Object)"$Country"))), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testMultipleGroupBy() throws Exception {
        String query = "SELECT Country,City FROM Customers GROUP BY Country,City";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Customers"}, 2);
        BasicDBObject project = new BasicDBObject();
        project.append("_m0", (Object)"$_id._c0");
        project.append("_m1", (Object)"$_id._c1");
        BasicDBObject group = new BasicDBObject();
        group.append("_c0", (Object)"$Country");
        group.append("_c1", (Object)"$City");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)group)), new BasicDBObject("$project", (Object)project)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testDistinctSingle() throws Exception {
        String query = "SELECT DISTINCT Country FROM Customers";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Customers"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$_id._m0");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)new BasicDBObject("_m0", (Object)"$Country"))), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testDistinctMulti() throws Exception {
        String query = "SELECT DISTINCT Country, City FROM Customers";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Customers"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$_id._m0");
        result.append("_m1", (Object)"$_id._m1");
        BasicDBObject group = new BasicDBObject();
        group.append("_m0", (Object)"$Country");
        group.append("_m1", (Object)"$City");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)group)), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testONE_TO_ONE_WithGroupBy() throws Exception {
        String query = "SELECT c.name, a.zip FROM customer c join address a on c.customer_id=a.cust_id GROUP BY c.name, a.zip";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"customer"}, 3);
        BasicDBObject project = new BasicDBObject();
        project.append("_m0", (Object)"$_id._c0");
        project.append("_m1", (Object)"$_id._c1");
        BasicDBObject group = new BasicDBObject();
        group.append("_c0", (Object)"$name");
        group.append("_c1", (Object)"$address.zip");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)new BasicDBObject("address", (Object)new BasicDBObject("$exists", (Object)"true").append("$ne", null))), new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)group)), new BasicDBObject("$project", (Object)project)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testONE_TO_ONE_WithGroupByOrderBy() throws Exception {
        String query = "SELECT c.name, a.zip FROM customer c join address a on c.customer_id=a.cust_id GROUP BY c.name, a.zip ORDER BY c.name, a.zip limit 2";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"customer"}, 6);
        BasicDBObject project = new BasicDBObject();
        project.append("_m0", (Object)"$_id._c0");
        project.append("_m1", (Object)"$_id._c1");
        BasicDBObject group = new BasicDBObject();
        group.append("_c0", (Object)"$name");
        group.append("_c1", (Object)"$address.zip");
        BasicDBObject sort = new BasicDBObject();
        sort.append("_m0", (Object)1);
        sort.append("_m1", (Object)1);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)new BasicDBObject("address", (Object)new BasicDBObject("$exists", (Object)"true").append("$ne", null))), new BasicDBObject("$group", (Object)new BasicDBObject("_id", (Object)group)), new BasicDBObject("$project", (Object)project), new BasicDBObject("$sort", (Object)sort), new BasicDBObject("$skip", (Object)0), new BasicDBObject("$limit", (Object)2)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSumWithGroupBy() throws Exception {
        String query = "SELECT SUM(age) as total FROM users GROUP BY user_id";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"users"}, 2);
        BasicDBObject id = new BasicDBObject();
        id.append("_c0", (Object)"$user_id");
        BasicDBObject group = new BasicDBObject("_id", (Object)id);
        group.append("total", (Object)new BasicDBObject("$sum", (Object)"$age"));
        BasicDBObject project = new BasicDBObject();
        project.append("total", (Object)1);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)group), new BasicDBObject("$project", (Object)project)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSumWithGroupBy2() throws Exception {
        String query = "SELECT user_id, status, SUM(age) as total FROM users GROUP BY user_id, status";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"users"}, 2);
        BasicDBObject project = new BasicDBObject();
        project.append("_m0", (Object)"$_id._c0");
        project.append("_m1", (Object)"$_id._c1");
        project.append("total", (Object)1);
        BasicDBObject id = new BasicDBObject();
        id.append("_c0", (Object)"$user_id");
        id.append("_c1", (Object)"$status");
        BasicDBObject group = new BasicDBObject("_id", (Object)id);
        group.append("total", (Object)new BasicDBObject("$sum", (Object)"$age"));
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)group), new BasicDBObject("$project", (Object)project)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSumWithGroupBy3() throws Exception {
        String query = "SELECT user_id, SUM(age) as total FROM users GROUP BY user_id";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"users"}, 2);
        BasicDBObject project = new BasicDBObject();
        project.append("_m0", (Object)"$_id._c0");
        project.append("total", (Object)1);
        BasicDBObject id = new BasicDBObject();
        id.append("_c0", (Object)"$user_id");
        BasicDBObject group = new BasicDBObject("_id", (Object)id);
        group.append("total", (Object)new BasicDBObject("$sum", (Object)"$age"));
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)group), new BasicDBObject("$project", (Object)project)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testAggregateWithHaving() throws Exception {
        String query = "SELECT SUM(age) as total FROM users GROUP BY user_id HAVING SUM(age) > 250";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"users"}, 3);
        BasicDBObject project = new BasicDBObject();
        project.append("_m0", (Object)1);
        BasicDBObject id = new BasicDBObject();
        id.append("_c0", (Object)"$user_id");
        BasicDBObject group = new BasicDBObject("_id", (Object)id);
        group.append("_m0", (Object)new BasicDBObject("$sum", (Object)"$age"));
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)group), new BasicDBObject("$match", (Object)QueryBuilder.start((String)"_m0").greaterThan((Object)250).get()), new BasicDBObject("$project", (Object)project)});
        ArgumentCaptor actualCapture = ArgumentCaptor.forClass(List.class);
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)actualCapture.capture(), (AggregationOptions)Mockito.any(AggregationOptions.class));
        Assert.assertEquals((Object)((Object)pipeline).toString(), (Object)((List)actualCapture.getValue()).toString());
    }

    @Test
    public void testAggregateWithHavingAndWhere() throws Exception {
        String query = "SELECT SUM(age) as total FROM users WHERE age > 45 GROUP BY user_id HAVING SUM(age) > 250";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"users"}, 4);
        BasicDBObject project = new BasicDBObject();
        project.append("_m0", (Object)1);
        BasicDBObject id = new BasicDBObject();
        id.append("_c0", (Object)"$user_id");
        BasicDBObject group = new BasicDBObject("_id", (Object)id);
        group.append("_m0", (Object)new BasicDBObject("$sum", (Object)"$age"));
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)QueryBuilder.start((String)"age").greaterThan((Object)45).get()), new BasicDBObject("$group", (Object)group), new BasicDBObject("$match", (Object)QueryBuilder.start((String)"_m0").greaterThan((Object)250).get()), new BasicDBObject("$project", (Object)project)});
        ArgumentCaptor actualCapture = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor optionsCapture = ArgumentCaptor.forClass(AggregationOptions.class);
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)actualCapture.capture(), (AggregationOptions)optionsCapture.capture());
        Assert.assertEquals((Object)pipeline.toString(), (Object)((List)actualCapture.getValue()).toString());
        Assert.assertEquals((Object)options.toString(), (Object)((AggregationOptions)optionsCapture.getValue()).toString());
    }

    public static ArrayList<DBObject> buildArray(DBObject ... basicDBObjects) {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject obj : basicDBObjects) {
            list.add(obj);
        }
        return list;
    }

    @Test
    public void testCountStar() throws Exception {
        String query = "SELECT count(*) FROM Categories";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 2);
        BasicDBObject group = new BasicDBObject();
        group.append("_id", null);
        group.append("_m0", (Object)new BasicDBObject("$sum", (Object)1));
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)1);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)group), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testCountOnColumn() throws Exception {
        String query = "SELECT count(CategoryName) FROM Categories";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 3);
        BasicDBList eq = new BasicDBList();
        eq.add(0, (Object)"$CategoryName");
        eq.add(1, null);
        BasicDBList values = new BasicDBList();
        values.add(0, (Object)new BasicDBObject("$eq", (Object)eq));
        values.add(1, (Object)0);
        values.add(2, (Object)1);
        BasicDBObject expr = new BasicDBObject("$sum", (Object)new BasicDBObject("$cond", (Object)values));
        BasicDBObject group = new BasicDBObject();
        group.append("_m0", (Object)expr);
        group.append("_id", null);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)1);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)group), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testCountOnmultipleDifferentColumns() throws Exception {
        String query = "SELECT count(CategoryName), avg(CategoryID) FROM Categories";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 3);
        BasicDBList eq = new BasicDBList();
        eq.add(0, (Object)"$CategoryName");
        eq.add(1, null);
        BasicDBList values = new BasicDBList();
        values.add(0, (Object)new BasicDBObject("$eq", (Object)eq));
        values.add(1, (Object)0);
        values.add(2, (Object)1);
        BasicDBObject expr = new BasicDBObject("$sum", (Object)new BasicDBObject("$cond", (Object)values));
        BasicDBObject group = new BasicDBObject();
        group.append("_m0", (Object)expr);
        group.append("_m1", (Object)new BasicDBObject("$avg", (Object)"$_id"));
        group.append("_id", null);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)1);
        result.append("_m1", (Object)1);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)group), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testMultipleAggregateWithCountOnSameColumn() throws Exception {
        String query = "SELECT count(CategoryName), avg(CategoryName) FROM Categories";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 3);
        BasicDBList eq = new BasicDBList();
        eq.add(0, (Object)"$CategoryName");
        eq.add(1, null);
        BasicDBList values = new BasicDBList();
        values.add(0, (Object)new BasicDBObject("$eq", (Object)eq));
        values.add(1, (Object)0);
        values.add(2, (Object)1);
        BasicDBObject expr = new BasicDBObject("$sum", (Object)new BasicDBObject("$cond", (Object)values));
        BasicDBObject group = new BasicDBObject();
        group.append("_m0", (Object)expr);
        group.append("_m1", (Object)new BasicDBObject("$avg", (Object)"$CategoryName"));
        group.append("_id", null);
        BasicDBObject project = new BasicDBObject();
        project.append("_m0", (Object)1);
        project.append("_m1", (Object)1);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)group), new BasicDBObject("$project", (Object)project)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testMultipleAggregateOnSameColumn() throws Exception {
        String query = "SELECT sum(CategoryName), avg(CategoryName) FROM Categories";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 3);
        BasicDBObject group = new BasicDBObject();
        group.append("_id", null);
        group.append("_m0", (Object)new BasicDBObject("$sum", (Object)"$CategoryName"));
        group.append("_m1", (Object)new BasicDBObject("$avg", (Object)"$CategoryName"));
        BasicDBObject project = new BasicDBObject();
        project.append("_m0", (Object)1);
        project.append("_m1", (Object)1);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)group), new BasicDBObject("$project", (Object)project)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testMultipleAggregateOnSameColumnWithGroupBy() throws Exception {
        String query = "SELECT sum(CategoryName), avg(CategoryName) FROM Categories Group By Picture";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 3);
        BasicDBObject group = new BasicDBObject();
        group.append("_id", (Object)new BasicDBObject("_c0", (Object)"$Picture"));
        group.append("_m0", (Object)new BasicDBObject("$sum", (Object)"$CategoryName"));
        group.append("_m1", (Object)new BasicDBObject("$avg", (Object)"$CategoryName"));
        BasicDBObject project = new BasicDBObject();
        project.append("_m0", (Object)1);
        project.append("_m1", (Object)1);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)group), new BasicDBObject("$project", (Object)project)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testMultipleAggregateOnSameColumn_withCountSTAR() throws Exception {
        String query = "SELECT count(*), avg(CategoryName) FROM Categories";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 3);
        BasicDBObject group = new BasicDBObject();
        group.append("_id", null);
        group.append("_m0", (Object)new BasicDBObject("$sum", (Object)1));
        group.append("_m1", (Object)new BasicDBObject("$avg", (Object)"$CategoryName"));
        BasicDBObject project = new BasicDBObject();
        project.append("_m0", (Object)1);
        project.append("_m1", (Object)1);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$group", (Object)group), new BasicDBObject("$project", (Object)project)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testFunctionInWhere() throws Exception {
        String query = "SELECT CategoryName FROM Categories WHERE CONCAT(CategoryName, '2') = '2'";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 2);
        BasicDBList params = new BasicDBList();
        params.add((Object)"$CategoryName");
        params.add((Object)"2");
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)new BasicDBObject("$concat", (Object)params));
        result.append("CategoryName", (Object)"$CategoryName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)result), new BasicDBObject("$match", (Object)QueryBuilder.start((String)"_m0").is((Object)"2").get())});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testDateFunction() throws Exception {
        String query = "SELECT YEAR(e2) FROM TIME_TEST";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"TIME_TEST"}, 1);
        BasicDBList params = new BasicDBList();
        params.add((Object)"$e2");
        BasicDBList values = new BasicDBList();
        values.add(0, (Object)"$e2");
        values.add(1, null);
        BasicDBObject isNull = new BasicDBObject("$eq", (Object)values);
        BasicDBObject func = new BasicDBObject("$year", (Object)params);
        BasicDBObject expr = this.buildCondition(isNull, null, func);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)expr);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSubStr() throws Exception {
        String query = "SELECT SUBSTRING(CategoryName, 3) FROM Categories";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 1);
        BasicDBList subtract = new BasicDBList();
        subtract.add((Object)3);
        subtract.add((Object)1);
        BasicDBList params = new BasicDBList();
        params.add((Object)"$CategoryName");
        params.add((Object)new BasicDBObject("$subtract", (Object)subtract));
        params.add((Object)4000);
        BasicDBObject ne = this.buildNE("$CategoryName", null);
        BasicDBObject func = new BasicDBObject("$substr", (Object)params);
        BasicDBObject expr = this.buildCondition(ne, func, null);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)expr);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testToLower() throws Exception {
        String query = "SELECT LCASE(CategoryName) FROM Categories";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 1);
        BasicDBObject ne = this.buildNE("$CategoryName", null);
        BasicDBObject func = new BasicDBObject("$toLower", (Object)"$CategoryName");
        BasicDBObject expr = this.buildCondition(ne, func, null);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)expr);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    private BasicDBObject buildCondition(Object expr, Object trueExpr, Object falseExpr) {
        BasicDBList values = new BasicDBList();
        values.add(0, expr);
        values.add(1, trueExpr);
        values.add(2, falseExpr);
        return new BasicDBObject("$cond", (Object)values);
    }

    private BasicDBObject buildNE(Object leftExpr, Object rightExpr) {
        BasicDBList values = new BasicDBList();
        values.add(0, leftExpr);
        values.add(1, rightExpr);
        return new BasicDBObject("$ne", (Object)values);
    }

    @Test
    public void testSubStr2() throws Exception {
        String query = "SELECT SUBSTRING(CategoryName, CategoryID, 4) FROM Categories";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 1);
        BasicDBList subtract = new BasicDBList();
        subtract.add((Object)"$_id");
        subtract.add((Object)1);
        BasicDBList params = new BasicDBList();
        params.add((Object)"$CategoryName");
        params.add((Object)new BasicDBObject("$subtract", (Object)subtract));
        params.add((Object)4);
        BasicDBObject ne = this.buildNE("$CategoryName", null);
        BasicDBObject func = new BasicDBObject("$substr", (Object)params);
        BasicDBObject expr = this.buildCondition(ne, func, null);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)expr);
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testSelectConstant() throws Exception {
        String query = "SELECT 'hit' FROM Categories";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 1);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)new BasicDBObject("$literal", (Object)"hit"));
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testOffsetWithoutLimit() throws Exception {
        String query = "SELECT CategoryName FROM Categories OFFSET 45 ROWS";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$CategoryName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)result), new BasicDBObject("$skip", (Object)45)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testArrtyType() throws Exception {
        String query = "SELECT * FROM ArrayTest";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"ArrayTest"}, 1);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$id");
        result.append("_m1", (Object)"$column1");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testArrtyTypeInWhere() throws Exception {
        String query = "SELECT * FROM ArrayTest where column1 is not null";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"ArrayTest"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$id");
        result.append("_m1", (Object)"$column1");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)QueryBuilder.start((String)"column1").notEquals(null).get()), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testGeoFunctionInWhere() throws Exception {
        String query = "SELECT CategoryName FROM Categories WHERE mongo.geoWithin(CategoryName, 'Polygon', ((cast(1.0 as double), cast(2.0 as double)),(cast(3.0 as double), cast(4.0 as double)))) or CategoryID=1";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Categories"}, 2);
        BasicDBObjectBuilder builder = new BasicDBObjectBuilder();
        builder.push("CategoryName");
        builder.push("$geoWithin");
        builder.push("$geometry");
        builder.add("type", (Object)"Polygon");
        BasicDBList coordinates = new BasicDBList();
        BasicDBList pointOne = new BasicDBList();
        pointOne.add((Object)new Double("1.0"));
        pointOne.add((Object)new Double("2.0"));
        BasicDBList pointTwo = new BasicDBList();
        pointTwo.add((Object)new Double("3.0"));
        pointTwo.add((Object)new Double("4.0"));
        BasicDBList points = new BasicDBList();
        points.add((Object)pointOne);
        points.add((Object)pointTwo);
        coordinates.add((Object)points);
        builder.add("coordinates", (Object)coordinates);
        QueryBuilder qb = QueryBuilder.start().or(new DBObject[]{builder.get(), new BasicDBObject("_id", (Object)1)});
        BasicDBObject result = new BasicDBObject();
        result.append("_m1", (Object)"$CategoryName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)qb.get()), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    private FunctionMethod getFunctionMethod(String name) {
        for (FunctionMethod fm : this.translator.getPushDownFunctions()) {
            if (!fm.getName().equalsIgnoreCase(name)) continue;
            for (FunctionParameter fp : fm.getInputParameters()) {
                if (!fp.getType().equals("geometry")) continue;
                return fm;
            }
        }
        return null;
    }

    @Test
    public void testGeoFunctionInWhereWithGeometry() throws Exception {
        Table table = this.utility.createRuntimeMetadata().getTable("northwind.Categories");
        NamedTable namedTable = new NamedTable("Categories", "g0", table);
        ColumnReference colRef = new ColumnReference(namedTable, "CategoryName", table.getColumnByName("CategoryName"), String.class);
        DerivedColumn col = new DerivedColumn("CategoryName", (Expression)colRef);
        Select select = new Select();
        select.setDerivedColumns(Arrays.asList(col));
        ArrayList<NamedTable> tables = new ArrayList<NamedTable>();
        tables.add(namedTable);
        select.setFrom(tables);
        GeometryType geo = GeometryUtils.geometryFromClob((ClobType)new ClobType((Clob)new ClobImpl("POLYGON ((1.0 2.0,3.0 4.0,5.0 6.0,1.0 2.0))")));
        Function function = new Function("mongo.geoWithin", Arrays.asList(colRef, new Literal((Object)geo, GeometryType.class)), Boolean.class);
        function.setMetadataObject(this.getFunctionMethod("mongo.geoWithin"));
        Comparison c = new Comparison((Expression)function, (Expression)new Literal((Object)true, Boolean.class), Comparison.Operator.EQ);
        select.setWhere((Condition)c);
        DBCollection dbCollection = this.helpExecute((Command)select, new String[]{"Categories"}, 2);
        BasicDBObjectBuilder builder = new BasicDBObjectBuilder();
        builder.push("CategoryName");
        builder.push("$geoWithin");
        builder.add("$geometry", (Object)"{\"type\":\"Polygon\",\"coordinates\":[[[1.0,2.0],[3.0,4.0],[5.0,6.0],[1.0,2.0]]]}");
        BasicDBObject result = new BasicDBObject();
        result.append("CategoryName", (Object)"$CategoryName");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)builder.get()), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test(expected=TranslatorException.class)
    public void testGeoFunctionInWhereWithFalse() throws Exception {
        String query = "SELECT CategoryName FROM Categories WHERE mongo.geoWithin(CategoryName, 'Polygon', ((cast(1.0 as double), cast(2.0 as double)),(cast(3.0 as double), cast(4.0 as double)))) = false";
        this.helpExecute(query, new String[]{"Categories"}, 2);
    }

    @Test
    public void testAdd() throws Exception {
        String query = "SELECT SupplierID+1 FROM Suppliers";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"Suppliers"}, 1);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)new BasicDBObject("$add", this.buildObjectArray("$_id", 1)));
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    ArrayList<Object> buildObjectArray(Object ... objs) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : objs) {
            list.add(obj);
        }
        return list;
    }

    @Test
    public void testNextWithGroupAndOrder() throws Exception {
        String query = "select \"FirstName\" from \"TeiidArray\" group by \"FirstName\" order by \"FirstName\" limit 1000";
        String[] expectedCollection = new String[]{"TeiidArray"};
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)"CREATE FOREIGN TABLE TeiidArray (ID String PRIMARY KEY, FirstName varchar(25), LastName varchar(25), Score object[]) OPTIONS(UPDATABLE 'TRUE');", (String)"x", (String)"y");
        TranslationUtility util = new TranslationUtility((QueryMetadataInterface)metadata);
        Command cmd = util.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        Mockito.stub((Object)context.getBatchSize()).toReturn((Object)256);
        MongoDBConnection connection = (MongoDBConnection)Mockito.mock(MongoDBConnection.class);
        DB db = (DB)Mockito.mock(DB.class);
        DBCollection dbCollection = (DBCollection)Mockito.mock(DBCollection.class);
        for (String collection : expectedCollection) {
            Mockito.stub((Object)db.getCollection(collection)).toReturn((Object)dbCollection);
        }
        Cursor c = (Cursor)Mockito.mock(Cursor.class);
        Mockito.stub((Object)c.hasNext()).toAnswer((Answer)new Answer<Boolean>(){
            boolean next = true;

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                if (this.next) {
                    this.next = false;
                    return true;
                }
                return false;
            }
        });
        DBObject dbo = (DBObject)Mockito.mock(DBObject.class);
        Mockito.stub((Object)c.next()).toReturn((Object)dbo);
        Mockito.stub((Object)dbCollection.aggregate(Mockito.anyList(), (AggregationOptions)Mockito.anyObject())).toReturn((Object)c);
        Mockito.stub((Object)db.collectionExists(Mockito.anyString())).toReturn((Object)true);
        Mockito.stub((Object)connection.getDatabase()).toReturn((Object)db);
        Mockito.stub((Object)db.getCollectionFromString(Mockito.anyString())).toReturn((Object)dbCollection);
        ResultSetExecution execution = this.translator.createResultSetExecution((QueryExpression)cmd, context, util.createRuntimeMetadata(), connection);
        execution.execute();
        execution.next();
    }

    @Test
    public void testNestedMergeSelect_one_2_one() throws Exception {
        String query = "SELECT e1, e2, e3 FROM N3";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"N1"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$_id");
        result.append("_m1", (Object)"$N2.N3.e2");
        result.append("_m2", (Object)"$N2.N3.e3");
        DBObject n2 = QueryBuilder.start((String)"N2").exists((Object)"true").notEquals(null).get();
        DBObject n3 = QueryBuilder.start((String)"N2.N3").exists((Object)"true").notEquals(null).get();
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)n2), new BasicDBObject("$match", (Object)n3), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testNestedMergeSelect_one_2_one_inner_joined() throws Exception {
        String query = "select N1.e1, N2.e2, N3.e3 FROM N1 JOIN N2 ON N1.e1=N2.e1 JOIN N3 ON N2.e1 = N3.e1";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"N1"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$_id");
        result.append("_m1", (Object)"$N2.e2");
        result.append("_m2", (Object)"$N2.N3.e3");
        DBObject n2 = QueryBuilder.start((String)"N2").exists((Object)"true").notEquals(null).get();
        DBObject n3 = QueryBuilder.start((String)"N2.N3").exists((Object)"true").notEquals(null).get();
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)n2), new BasicDBObject("$match", (Object)n3), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testNestedMergeSelect_one_2_many() throws Exception {
        String query = "SELECT e1, e2, e3 FROM N4 Where N4.e3 = 4";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"N1"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$N2.N4._id");
        result.append("_m1", (Object)"$_id");
        result.append("_m2", (Object)"$N2.N4.e3");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)QueryBuilder.start((String)"N2").exists((Object)"true").notEquals(null).get()), new BasicDBObject("$unwind", (Object)"$N2.N4"), new BasicDBObject("$match", (Object)QueryBuilder.start((String)"N2.N4.e3").is((Object)4).get()), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testNestedMergeSelect_one_2_many_onid() throws Exception {
        String query = "SELECT e1, e2, e3 FROM N4 Where N4.e2 = 4";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"N1"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$N2.N4._id");
        result.append("_m1", (Object)"$_id");
        result.append("_m2", (Object)"$N2.N4.e3");
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)QueryBuilder.start((String)"N2").exists((Object)"true").notEquals(null).get()), new BasicDBObject("$unwind", (Object)"$N2.N4"), new BasicDBObject("$match", (Object)QueryBuilder.start((String)"_id").is((Object)4).get()), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testNestedMergeSelect_one_2_many_inner_joined() throws Exception {
        String query = "select N1.e1, N2.e2, N4.e3 FROM N1 JOIN N2 ON N1.e1=N2.e1 JOIN N4 ON N2.e1 = N4.e2 Order by N1.e1";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"N1"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$_id");
        result.append("_m1", (Object)"$N2.e2");
        result.append("_m2", (Object)"$N2.N4.e3");
        DBObject n2 = QueryBuilder.start((String)"N2").exists((Object)"true").notEquals(null).get();
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)n2), new BasicDBObject("$unwind", (Object)"$N2.N4"), new BasicDBObject("$project", (Object)result), new BasicDBObject("$sort", (Object)new BasicDBObject("_m0", (Object)1))});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testNestedMergeSelect_one_2_many2() throws Exception {
        String query = "select N2.*, N4.* FROM N2 LEFT OUTER JOIN N4 ON N2.e1 = N4.e2";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"N1"}, 2);
        BasicDBObject projection = new BasicDBObject();
        projection.append("N2.e1", (Object)1);
        projection.append("N2.e2", (Object)1);
        projection.append("N2.e3", (Object)1);
        projection.append("__NN_N4", (Object)this.buildIfNullExpression("N2.N4"));
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$_id");
        result.append("_m1", (Object)"$N2.e2");
        result.append("_m2", (Object)"$N2.e3");
        result.append("_m3", (Object)"$__NN_N4._id");
        result.append("_m4", (Object)"$_id");
        result.append("_m5", (Object)"$__NN_N4.e3");
        DBObject n2 = QueryBuilder.start((String)"N2").exists((Object)"true").notEquals(null).get();
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$project", (Object)projection), new BasicDBObject("$match", (Object)n2), new BasicDBObject("$unwind", (Object)"$__NN_N4"), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testNestedMergeSelect_inner_and_left_joined() throws Exception {
        String query = "select N1.e1, N2.e2, N4.e1, N4.e2, N4.e3  FROM N1 JOIN N2 ON N1.e1=N2.e1 LEFT JOIN N4 ON N2.e1 = N4.e2 ";
        DBCollection dbCollection = this.helpExecute(query, new String[]{"N1"}, 2);
        BasicDBObject result = new BasicDBObject();
        result.append("_m0", (Object)"$_id");
        result.append("_m1", (Object)"$N2.e2");
        result.append("_m2", (Object)"$__NN_N4._id");
        result.append("_m3", (Object)"$_id");
        result.append("_m4", (Object)"$__NN_N4.e3");
        BasicDBObject projection = new BasicDBObject();
        projection.append("e1", (Object)1);
        projection.append("e2", (Object)1);
        projection.append("e3", (Object)1);
        projection.append("__NN_N4", (Object)this.buildIfNullExpression("N2.N4"));
        DBObject n2 = QueryBuilder.start((String)"N2").exists((Object)"true").notEquals(null).get();
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)n2), new BasicDBObject("$project", (Object)projection), new BasicDBObject("$unwind", (Object)"$__NN_N4"), new BasicDBObject("$project", (Object)result)});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }
}

