/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.AggregationOptions;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.language.Literal;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;
import org.teiid.translator.mongodb.TestMongoDBQueryExecution;

public class TestMongoDBDirectQueryExecution {
    private MongoDBExecutionFactory translator;
    private TranslationUtility utility;

    @Before
    public void setUp() throws Exception {
        this.translator = new MongoDBExecutionFactory();
        this.translator.start();
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"northwind.ddl")), (String)"sakila", (String)"northwind");
        this.utility = new TranslationUtility((QueryMetadataInterface)metadata);
    }

    @Test
    public void testDirect() throws Exception {
        Command cmd = this.utility.parseCommand("SELECT * FROM Customers");
        MongoDBConnection connection = (MongoDBConnection)Mockito.mock(MongoDBConnection.class);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        DBCollection dbCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DB db = (DB)Mockito.mock(DB.class);
        Mockito.stub((Object)db.getCollection("MyTable")).toReturn((Object)dbCollection);
        Mockito.stub((Object)db.collectionExists(Mockito.anyString())).toReturn((Object)true);
        Mockito.stub((Object)connection.getDatabase()).toReturn((Object)db);
        AggregationOutput output = (AggregationOutput)Mockito.mock(AggregationOutput.class);
        Mockito.stub((Object)output.results()).toReturn(new ArrayList());
        Mockito.stub((Object)dbCollection.aggregate((DBObject)Mockito.any(DBObject.class), new DBObject[]{(DBObject)Mockito.any(DBObject.class)})).toReturn((Object)output);
        Argument arg = new Argument(Argument.Direction.IN, null, String.class, null);
        arg.setArgumentValue(new Literal((Object)"MyTable;{$match:{\"id\":\"$1\"}};{$project:{\"_m0\":\"$user\"}}", String.class));
        Argument arg2 = new Argument(Argument.Direction.IN, null, String.class, null);
        arg2.setArgumentValue(new Literal((Object)"foo", String.class));
        ProcedureExecution execution = this.translator.createDirectExecution(Arrays.asList(arg, arg2), cmd, context, this.utility.createRuntimeMetadata(), connection);
        execution.execute();
        ArrayList<DBObject> pipeline = TestMongoDBQueryExecution.buildArray(new DBObject[]{new BasicDBObject("$match", (Object)new BasicDBObject("id", (Object)"foo")), new BasicDBObject("$project", (Object)new BasicDBObject("_m0", (Object)"$user"))});
        ((DBCollection)Mockito.verify((Object)dbCollection)).aggregate((List)Mockito.eq(pipeline), (AggregationOptions)Mockito.any(AggregationOptions.class));
    }

    @Test
    public void testShellDirect() throws Exception {
        Command cmd = this.utility.parseCommand("SELECT * FROM Customers");
        MongoDBConnection connection = (MongoDBConnection)Mockito.mock(MongoDBConnection.class);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        DBCollection dbCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DB db = (DB)Mockito.mock(DB.class);
        Mockito.stub((Object)db.getCollection("MyTable")).toReturn((Object)dbCollection);
        Mockito.stub((Object)db.collectionExists(Mockito.anyString())).toReturn((Object)true);
        Mockito.stub((Object)connection.getDatabase()).toReturn((Object)db);
        Argument arg = new Argument(Argument.Direction.IN, null, String.class, null);
        arg.setArgumentValue(new Literal((Object)"$ShellCmd;MyTable;remove;{ qty: { $gt: 20 }}", String.class));
        ProcedureExecution execution = this.translator.createDirectExecution(Arrays.asList(arg), cmd, context, this.utility.createRuntimeMetadata(), connection);
        execution.execute();
        ((DBCollection)Mockito.verify((Object)dbCollection)).remove(QueryBuilder.start((String)"qty").greaterThan((Object)20).get());
    }
}

