/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.QueryBuilder;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.CommandContext;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Command;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;

public class TestMongoDBUpdateExecution {
    private MongoDBExecutionFactory translator;
    private TranslationUtility utility;

    @Before
    public void setUp() throws Exception {
        this.translator = new MongoDBExecutionFactory();
        this.translator.start();
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"northwind.ddl")), (String)"sakila", (String)"northwind");
        this.utility = new TranslationUtility((QueryMetadataInterface)metadata);
    }

    @Test
    public void testSimpleInsertNoAssosiations() throws Exception {
        String query = "insert into Customers (CustomerID,CompanyName,ContactName,ContactTitle,Address,City,Region,PostalCode,Country,Phone,Fax) VALUES ('11', 'jboss', 'teiid', 'Mr.Lizard', 'jboss.org', 'internet', 'all', '1111', 'US', '555-1212', '555-1212')";
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"Customers"}, null, null);
        BasicDBObject result = new BasicDBObject();
        result.append("_id", (Object)"11");
        result.append("CompanyName", (Object)"jboss");
        result.append("ContactName", (Object)"teiid");
        result.append("ContactTitle", (Object)"Mr.Lizard");
        result.append("Address", (Object)"jboss.org");
        result.append("City", (Object)"internet");
        result.append("Region", (Object)"all");
        result.append("PostalCode", (Object)"1111");
        result.append("Country", (Object)"US");
        result.append("Phone", (Object)"555-1212");
        result.append("Fax", (Object)"555-1212");
        ((DBCollection)Mockito.verify((Object)dbCollection)).insert((DBObject)result, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).update((DBObject)new BasicDBObject(), (DBObject)result, false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testEmbeddableInsert() throws Exception {
        String query = "INSERT INTO Categories (CategoryID, CategoryName, Description, Picture) VALUES (12, 'mongo', 'mongo with sql', null)";
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"Categories"}, null, null);
        BasicDBObject result = new BasicDBObject();
        result.append("_id", (Object)12);
        result.append("CategoryName", (Object)"mongo");
        result.append("Description", (Object)"mongo with sql");
        result.append("Picture", null);
        ((DBCollection)Mockito.verify((Object)dbCollection)).insert((DBObject)result, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).update((DBObject)new BasicDBObject(), (DBObject)result, false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeInsert() throws Exception {
        String query = "INSERT INTO OrderDetails (odID, ProductID, UnitPrice, Quantity, Discount) VALUES (14, 15, 34.50, 10, 12)";
        BasicDBObject match = new BasicDBObject("_id", (Object)14);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"Orders"}, (DBObject)match, null);
        BasicDBObject details = new BasicDBObject();
        BasicDBObject pk = new BasicDBObject();
        pk.append("odID", (Object)14);
        pk.append("ProductID", (Object)15);
        details.append("UnitPrice", (Object)34.5);
        details.append("Quantity", (Object)10);
        details.append("Discount", (Object)12.0);
        details.append("_id", (Object)pk);
        details = new BasicDBObject("OrderDetails", (Object)details);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)details, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$push", (Object)details), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeInsertOne2One() throws Exception {
        String query = "INSERT INTO address (cust_id, street, zip) VALUES (100, '123 Street', '90210')";
        BasicDBObject match = new BasicDBObject("_id", (Object)100);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"customer"}, (DBObject)match, null);
        BasicDBObject details = new BasicDBObject();
        details.append("street", (Object)"123 Street");
        details.append("zip", (Object)"90210");
        details = new BasicDBObject("address", (Object)details);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)details, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$set", (Object)details), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeInsertOne2Many() throws Exception {
        String query = "INSERT INTO Notes (CustomerId, PostDate, Comment) VALUES (100, null, 'Hello')";
        BasicDBObject match = new BasicDBObject("_id", (Object)100);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"customer"}, (DBObject)match, null);
        BasicDBObject details = new BasicDBObject();
        details.append("PostDate", null);
        details.append("Comment", (Object)"Hello");
        details = new BasicDBObject("Notes", (Object)details);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)details, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$push", (Object)details), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeDeleteOne2OneonPK() throws Exception {
        String query = "DELETE FROM address WHERE cust_id = 100";
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        BasicDBObject address = new BasicDBObject();
        address.append("street", (Object)"123 Street").append("zip", (Object)"90210").append("_id", (Object)new DBRef(null, "customer", (Object)100));
        results.add((DBObject)new BasicDBObject("_id", (Object)100).append("address", (Object)address));
        BasicDBObject match = new BasicDBObject("_id", (Object)100);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"customer"}, (DBObject)match, results);
        BasicDBObject details = new BasicDBObject("address", (Object)"");
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$unset", (Object)details), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeDeleteOne2OneonNonPK() throws Exception {
        String query = "DELETE FROM address WHERE street = 'Highway 100'";
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        BasicDBObject address = new BasicDBObject();
        address.append("street", (Object)"123 Street").append("zip", (Object)"90210").append("_id", (Object)new DBRef(null, "customer", (Object)100));
        results.add((DBObject)new BasicDBObject("_id", (Object)100).append("address", (Object)address));
        DBObject match = QueryBuilder.start((String)"address.street").is((Object)"Highway 100").get();
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"customer"}, match, results);
        BasicDBObject details = new BasicDBObject("address", (Object)"");
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update(match, (DBObject)new BasicDBObject("$unset", (Object)details), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeDeleteOne2OneAllRows() throws Exception {
        String query = "DELETE FROM address";
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        BasicDBObject address = new BasicDBObject();
        address.append("street", (Object)"123 Street").append("zip", (Object)"90210").append("_id", (Object)new DBRef(null, "customer", (Object)100));
        results.add((DBObject)new BasicDBObject("_id", (Object)100).append("address", (Object)address));
        DBObject match = QueryBuilder.start((String)"address").exists((Object)true).get();
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"customer"}, match, results);
        BasicDBObject details = new BasicDBObject("address", (Object)"");
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update(match, (DBObject)new BasicDBObject("$unset", (Object)details), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test(expected=TranslatorException.class)
    public void testMergeDeleteOne2ManyWithORClause() throws Exception {
        String query = "DELETE FROM Notes WHERE CustomerId = 100 OR Comment IN ('Hello', 'Hola')";
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        BasicDBList row = new BasicDBList();
        row.add((Object)new BasicDBObject("Comment", (Object)"Hello").append("PostDate", (Object)"{ts '2014-07-15 09:06:04'}"));
        row.add((Object)new BasicDBObject("Comment", (Object)"Hola").append("PostDate", (Object)"{ts '2013-07-15 09:06:04'}"));
        results.add((DBObject)new BasicDBObject("_id", (Object)100).append("Notes", (Object)row));
        BasicDBList commentIN = new BasicDBList();
        commentIN.add((Object)"Hello");
        commentIN.add((Object)"Hola");
        BasicDBObject match = new BasicDBObject("_id", (Object)100);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"customer"}, (DBObject)match, results);
        BasicDBObject details = new BasicDBObject("Notes", (Object)QueryBuilder.start((String)"Comment").in((Object)commentIN).get());
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$pull", (Object)details), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeDeleteOne2ManyWithIN() throws Exception {
        String query = "DELETE FROM Notes WHERE Comment IN ('Hello', 'Hola')";
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        BasicDBList row = new BasicDBList();
        row.add((Object)new BasicDBObject("Comment", (Object)"Hello").append("PostDate", (Object)"{ts '2014-07-15 09:06:04'}"));
        row.add((Object)new BasicDBObject("Comment", (Object)"Hola").append("PostDate", (Object)"{ts '2013-07-15 09:06:04'}"));
        results.add((DBObject)new BasicDBObject("_id", (Object)100).append("Notes", (Object)row));
        BasicDBList commentIN = new BasicDBList();
        commentIN.add((Object)"Hello");
        commentIN.add((Object)"Hola");
        DBObject match = QueryBuilder.start((String)"Notes").exists((Object)true).get();
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"customer"}, match, results);
        BasicDBObject details = new BasicDBObject("Notes", (Object)QueryBuilder.start((String)"Comment").in((Object)commentIN).get());
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update(match, (DBObject)new BasicDBObject("$pull", (Object)details), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeDeleteOne2ManyNonFK() throws Exception {
        String query = "DELETE FROM Notes WHERE Comment = 'Hello'";
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        BasicDBList row = new BasicDBList();
        row.add((Object)new BasicDBObject("Comment", (Object)"Hello").append("PostDate", (Object)"{ts '2014-07-15 09:06:04'}"));
        row.add((Object)new BasicDBObject("Comment", (Object)"Hola").append("PostDate", (Object)"{ts '2013-07-15 09:06:04'}"));
        results.add((DBObject)new BasicDBObject("_id", (Object)100).append("Notes", (Object)row));
        DBObject match = QueryBuilder.start((String)"Notes").exists((Object)true).get();
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"customer"}, match, results);
        BasicDBObject details = new BasicDBObject("Notes", (Object)new BasicDBObject("Comment", (Object)"Hello"));
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update(match, (DBObject)new BasicDBObject("$pull", (Object)details), false, true, WriteConcern.ACKNOWLEDGED);
    }

    private DBCollection helpUpdate(String query, String[] expectedCollection, DBObject match_result, ArrayList<DBObject> results) throws TranslatorException {
        Command cmd = this.utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        CommandContext cc = (CommandContext)Mockito.mock(CommandContext.class);
        Mockito.stub((Object)context.getCommandContext()).toReturn((Object)cc);
        MongoDBConnection connection = (MongoDBConnection)Mockito.mock(MongoDBConnection.class);
        DB db = (DB)Mockito.mock(DB.class);
        DBCollection dbCollection = (DBCollection)Mockito.mock(DBCollection.class);
        for (String collection : expectedCollection) {
            Mockito.stub((Object)db.getCollection(collection)).toReturn((Object)dbCollection);
        }
        Mockito.stub((Object)db.collectionExists(Mockito.anyString())).toReturn((Object)true);
        Mockito.stub((Object)connection.getDatabase()).toReturn((Object)db);
        Mockito.stub((Object)db.getCollectionFromString(Mockito.anyString())).toReturn((Object)dbCollection);
        Mockito.stub((Object)dbCollection.findOne((DBObject)Mockito.any(BasicDBObject.class))).toReturn((Object)match_result);
        WriteResult result = (WriteResult)Mockito.mock(WriteResult.class);
        Mockito.stub((Object)result.getN()).toReturn((Object)1);
        Mockito.stub((Object)dbCollection.insert((DBObject)Mockito.any(BasicDBObject.class), (WriteConcern)Mockito.any(WriteConcern.class))).toReturn((Object)result);
        Mockito.stub((Object)dbCollection.update((DBObject)Mockito.any(BasicDBObject.class), (DBObject)Mockito.any(BasicDBObject.class), Mockito.eq((boolean)false), Mockito.eq((boolean)true), (WriteConcern)Mockito.any(WriteConcern.class))).toReturn((Object)result);
        if (results != null) {
            ResultsCursor out = new ResultsCursor(results);
            for (DBObject obj : results) {
                Mockito.stub((Object)dbCollection.aggregate(Mockito.anyList(), (AggregationOptions)Mockito.any(AggregationOptions.class))).toReturn((Object)out);
                Mockito.stub((Object)dbCollection.aggregate(Mockito.anyList(), (AggregationOptions)Mockito.any(AggregationOptions.class))).toReturn((Object)out);
            }
        }
        UpdateExecution execution = this.translator.createUpdateExecution(cmd, context, this.utility.createRuntimeMetadata(), connection);
        execution.execute();
        return dbCollection;
    }

    @Test
    public void testUpdateEmbeddable() throws Exception {
        String query = "UPDATE Categories SET CategoryName='JBOSS' WHERE CategoryID = 11";
        BasicDBObject match = new BasicDBObject("_id", (Object)11);
        BasicDBObject details = new BasicDBObject();
        details.append("CategoryName", (Object)"JBOSS");
        details = new BasicDBObject("$set", (Object)details);
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        results.add((DBObject)new BasicDBObject("_id", (Object)11).append("key", (Object)"value"));
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"Categories", "Products"}, (DBObject)match, results);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)details, false, true, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)new BasicDBObject("CategoryID", (Object)11), (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject("Categories", (Object)new BasicDBObject("key", (Object)"value"))), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Ignore
    @Test
    public void testDeleteMergeOneToManyOnPK() throws Exception {
        String query = "DELETE FROM OrderDetails WHERE ProductID = 14 and odID = 1";
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"Orders"}, (DBObject)new BasicDBObject("oid", (Object)1), null);
        DBObject match = QueryBuilder.start().and(new DBObject[]{new BasicDBObject("_id.ProductID", (Object)14), new BasicDBObject("_id.odID", (Object)1)}).get();
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.times((int)1))).update((DBObject)new BasicDBObject("_id", (Object)1), (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("OrderDetails", (Object)match)), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Ignore
    @Test
    public void testDeleteMergeOneToManyOnPKANDColumn() throws Exception {
        String query = "DELETE FROM OrderDetails WHERE ProductID = 14 and UnitPrice > 23.89";
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"Orders"}, QueryBuilder.start().exists((Object)"OrderDetails").get(), null);
        QueryBuilder qb = QueryBuilder.start((String)"OrderDetails").exists((Object)true);
        QueryBuilder pullQuery = new QueryBuilder();
        pullQuery.and(new DBObject[]{new BasicDBObject("_id.ProductID", (Object)14), QueryBuilder.start((String)"UnitPrice").greaterThan((Object)23.89).get()});
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.times((int)1))).update(qb.get(), (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("OrderDetails", (Object)pullQuery.get())), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    @Ignore
    public void testMergeOne2ManyUpdateComplexKey() throws Exception {
        String query = "UPDATE OrderDetails SET UnitPrice = 12.50 WHERE ProductID = 14 and odID = 1";
        BasicDBObject pk = new BasicDBObject("ProductID", (Object)14);
        BasicDBObject pk2 = new BasicDBObject("ProductID", (Object)15);
        BasicDBList result = new BasicDBList();
        result.add((Object)new BasicDBObject().append("_id", (Object)pk).append("UnitPrice", (Object)99.0).append("Quantity", (Object)11));
        result.add((Object)new BasicDBObject().append("_id", (Object)pk2).append("UnitPrice", (Object)0.99).append("Quantity", (Object)12));
        BasicDBObject row = new BasicDBObject("OrderDetails", (Object)result).append("_id", (Object)1);
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        results.add((DBObject)row);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"Orders"}, (DBObject)new BasicDBObject("oid", (Object)1), results);
        BasicDBList expected = new BasicDBList();
        expected.add((Object)new BasicDBObject("_id", (Object)pk).append("UnitPrice", (Object)12.5).append("Quantity", (Object)11));
        expected.add((Object)new BasicDBObject().append("_id", (Object)pk2).append("UnitPrice", (Object)0.99).append("Quantity", (Object)12));
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.times((int)1))).update((DBObject)new BasicDBObject("_id", (Object)1), (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject("OrderDetails", (Object)expected)), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void tesNestedEmbeddingInsert() throws Exception {
        String query = "insert into T1 (e1, e2, e3) VALUES (1, 2, 3)";
        BasicDBObject match = new BasicDBObject();
        match.append("_id", (Object)2);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"T1", "T2"}, (DBObject)match, null);
        BasicDBObject row = new BasicDBObject();
        row.append("e1", (Object)1);
        row.append("e3", (Object)3);
        row.append("_id", (Object)2);
        row.append("T2", (Object)match);
        ((DBCollection)Mockito.verify((Object)dbCollection)).insert((DBObject)row, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).update((DBObject)match, (DBObject)row, false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    @Ignore
    public void tesNestedEmbeddingUpdate() throws Exception {
        String query = "UPDATE T3 SET e2 = 2, e3 = 3 WHERE e1 = 1";
        BasicDBObject t3_match = new BasicDBObject();
        t3_match.append("_id", (Object)1);
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        results.add((DBObject)new BasicDBObject("_id", (Object)1).append("key", (Object)"value"));
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"T3", "T2", "T1"}, (DBObject)t3_match, results);
        BasicDBObject t3_row = new BasicDBObject();
        t3_row.append("e2", (Object)2);
        t3_row.append("e3", (Object)3);
        BasicDBObject t2_match = new BasicDBObject();
        t2_match.append("e1", (Object)1);
        BasicDBObject t1row = new BasicDBObject("T2", (Object)results.get(0));
        BasicDBObject t2row = new BasicDBObject("T3", (Object)results.get(0));
        BasicDBObject t1_match = new BasicDBObject();
        t1_match.append("e1", (Object)1);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)t3_row, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)t3_match, (DBObject)new BasicDBObject("$set", (Object)t3_row), false, true, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)t2_match, (DBObject)new BasicDBObject("$set", (Object)t2row), false, true, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)t1_match, (DBObject)new BasicDBObject("$set", (Object)t1row), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    @Ignore
    public void tesNestedEmbeddingUpdateInMiddle() throws Exception {
        String query = "UPDATE T2 SET e2 = 2, e3 = 3 WHERE e1 = 1";
        BasicDBObject match = new BasicDBObject();
        match.append("_id", (Object)1);
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        results.add((DBObject)new BasicDBObject("_id", (Object)1).append("key", (Object)"value"));
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"T2", "T1", "T3"}, (DBObject)match, results);
        BasicDBObject row = new BasicDBObject();
        row.append("e2", (Object)2);
        row.append("e3", (Object)3);
        BasicDBObject t2_match = new BasicDBObject();
        t2_match.append("e1.$id", (Object)1);
        BasicDBObject t2row = new BasicDBObject("T2", (Object)results.get(0));
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)row, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$set", (Object)row), false, true, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)t2_match, (DBObject)new BasicDBObject("$set", (Object)t2row), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testNestedMergeInsert() throws Exception {
        String query = "INSERT INTO customer (customer_id, name) VALUES (1, 'jboss')";
        BasicDBObject customer_result = new BasicDBObject();
        customer_result.append("name", (Object)"jboss");
        customer_result.append("_id", (Object)1);
        BasicDBObject match = new BasicDBObject();
        match.append("_id", (Object)1);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"customer"}, null, null);
        ((DBCollection)Mockito.verify((Object)dbCollection)).insert((DBObject)customer_result, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).update((DBObject)new BasicDBObject(), (DBObject)match, false, true, WriteConcern.ACKNOWLEDGED);
        BasicDBObject rental = new BasicDBObject();
        rental.append("amount", (Object)3.99);
        rental.append("_id", (Object)2);
        BasicDBObject rentalresult = new BasicDBObject("rental", (Object)rental);
        query = "INSERT INTO rental (rental_id, amount, customer_id) VALUES (2, 3.99, 1)";
        dbCollection = this.helpUpdate(query, new String[]{"customer"}, (DBObject)customer_result, null);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)customer_result, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$push", (Object)rentalresult), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testArrayInsert() throws Exception {
        String query = "insert into ArrayTest(id,column1) VALUES (1, ('jboss', 'teiid', 'Mr.Lizard'))";
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"ArrayTest"}, null, null);
        BasicDBList col1 = new BasicDBList();
        col1.add((Object)"jboss");
        col1.add((Object)"teiid");
        col1.add((Object)"Mr.Lizard");
        BasicDBObject result = new BasicDBObject();
        result.append("id", (Object)1);
        result.append("column1", (Object)col1);
        ((DBCollection)Mockito.verify((Object)dbCollection)).insert((DBObject)result, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).update((DBObject)new BasicDBObject(), (DBObject)result, false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testArrayUpdate() throws Exception {
        String query = "UPDATE ArrayTest SET column1 = ('jboss', 'teiid', 'Mr.Lizard') WHERE id = 1";
        BasicDBObject match = new BasicDBObject("id", (Object)1);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"ArrayTest"}, (DBObject)match, null);
        BasicDBList col1 = new BasicDBList();
        col1.add((Object)"jboss");
        col1.add((Object)"teiid");
        col1.add((Object)"Mr.Lizard");
        BasicDBObject details = new BasicDBObject();
        details.append("column1", (Object)col1);
        details = new BasicDBObject("$set", (Object)details);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)details, false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeDelete_one_2_many_all() throws Exception {
        String query = "DELETE FROM N5";
        BasicDBObject N5ROW1 = new BasicDBObject().append("e1", (Object)3).append("e3", (Object)3);
        BasicDBObject N5ROW2 = new BasicDBObject().append("e1", (Object)3).append("e3", (Object)3);
        BasicDBList N5Rows = new BasicDBList();
        N5Rows.add((Object)N5ROW1);
        N5Rows.add((Object)N5ROW2);
        ArrayList<DBObject> N1ROWS = new ArrayList<DBObject>();
        N1ROWS.add((DBObject)new BasicDBObject("_id", (Object)1).append("N5", (Object)N5Rows));
        DBObject match = QueryBuilder.start((String)"N5").exists((Object)true).get();
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, match, N1ROWS);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update(match, (DBObject)new BasicDBObject("$pull", (Object)new BasicDBObject("N5", (Object)new BasicDBObject())), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeDelete_one_2_many_usingFK() throws Exception {
        String query = "DELETE FROM N5 WHERE e2 = 100";
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        BasicDBList row = new BasicDBList();
        row.add((Object)new BasicDBObject("e1", (Object)1).append("e3", (Object)5));
        row.add((Object)new BasicDBObject("e1", (Object)2).append("e3", (Object)5));
        results.add((DBObject)new BasicDBObject("_id", (Object)100).append("N5", (Object)row));
        BasicDBObject match = new BasicDBObject("_id", (Object)100);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, results);
        BasicDBObject details = new BasicDBObject("N5", (Object)new BasicDBList());
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$set", (Object)details), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeDelete_one_2_many_usingFK2() throws Exception {
        String query = "DELETE FROM N5 WHERE e2 = 100 and e1=1";
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        BasicDBList row = new BasicDBList();
        row.add((Object)new BasicDBObject("_id", (Object)1).append("e3", (Object)5));
        row.add((Object)new BasicDBObject("_id", (Object)2).append("e3", (Object)5));
        results.add((DBObject)new BasicDBObject("_id", (Object)100).append("N5", (Object)row));
        BasicDBObject match = new BasicDBObject("_id", (Object)100);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, results);
        BasicDBList expected = new BasicDBList();
        expected.add((Object)new BasicDBObject("_id", (Object)2).append("e3", (Object)5));
        BasicDBObject details = new BasicDBObject("N5", (Object)expected);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$set", (Object)details), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testNestedMergeDelete_one_2_many_many() throws Exception {
        String query = "DELETE FROM N7 WHERE e2 = 5 and e1=7";
        ArrayList<DBObject> N1ROWS = new ArrayList<DBObject>();
        BasicDBList N5ROW = new BasicDBList();
        N5ROW.add((Object)5);
        N5ROW.add((Object)51);
        BasicDBList N5ROW2 = new BasicDBList();
        N5ROW2.add((Object)50);
        N5ROW2.add((Object)5);
        BasicDBList N5_N7ROW = new BasicDBList();
        N5_N7ROW.add((Object)new BasicDBObject("_id", (Object)7).append("e3", (Object)7));
        BasicDBList N5_N7ROW_ARRAY1 = new BasicDBList();
        N5_N7ROW_ARRAY1.add((Object)N5_N7ROW);
        BasicDBList N5_N7ROW2 = new BasicDBList();
        N5_N7ROW2.add((Object)new BasicDBObject("_id", (Object)5).append("e3", (Object)7));
        N5_N7ROW2.add((Object)new BasicDBObject("_id", (Object)7).append("e3", (Object)7));
        BasicDBList N5_N7ROW_ARRAY2 = new BasicDBList();
        N5_N7ROW_ARRAY2.add((Object)new BasicDBList());
        N5_N7ROW_ARRAY2.add((Object)N5_N7ROW2);
        N1ROWS.add((DBObject)new BasicDBObject("_id", (Object)1).append("N5", (Object)N5ROW).append("N5_N7", (Object)N5_N7ROW_ARRAY1));
        N1ROWS.add((DBObject)new BasicDBObject("_id", (Object)2).append("N5", (Object)N5ROW2).append("N5_N7", (Object)N5_N7ROW_ARRAY2));
        BasicDBObject match = new BasicDBObject("_id", (Object)1);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, N1ROWS);
        ArgumentCaptor matchCaptor = ArgumentCaptor.forClass(BasicDBObject.class);
        ArgumentCaptor updateCaptor = ArgumentCaptor.forClass(BasicDBObject.class);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.times((int)2))).update((DBObject)matchCaptor.capture(), (DBObject)updateCaptor.capture(), Mockito.eq((boolean)false), Mockito.eq((boolean)true), (WriteConcern)Mockito.eq((Object)WriteConcern.ACKNOWLEDGED));
        Assert.assertEquals((Object)new BasicDBObject("_id", (Object)1), matchCaptor.getAllValues().get(0));
        Assert.assertEquals((Object)new BasicDBObject("_id", (Object)2), matchCaptor.getAllValues().get(1));
        BasicDBList EXPECTED_N5_N7ROW2 = new BasicDBList();
        EXPECTED_N5_N7ROW2.add((Object)new BasicDBObject("_id", (Object)5).append("e3", (Object)7));
        BasicDBList EXPECTED_N5_N7ROW2_ARRAY = new BasicDBList();
        EXPECTED_N5_N7ROW2_ARRAY.add((Object)EXPECTED_N5_N7ROW2);
        Assert.assertEquals((Object)new BasicDBObject("$set", (Object)new BasicDBObject("N5.0.N7", (Object)new BasicDBList())), updateCaptor.getAllValues().get(0));
        Assert.assertEquals((Object)new BasicDBObject("$set", (Object)new BasicDBObject("N5.1.N7", (Object)EXPECTED_N5_N7ROW2)), updateCaptor.getAllValues().get(1));
    }

    @Test
    public void testMergeDelete_one_2_one_2_many() throws Exception {
        String query = "DELETE FROM N4 WHERE e2 = 100 and e1=1";
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        BasicDBList row = new BasicDBList();
        row.add((Object)new BasicDBObject("_id", (Object)1).append("e3", (Object)5));
        row.add((Object)new BasicDBObject("_id", (Object)2).append("e3", (Object)5));
        results.add((DBObject)new BasicDBObject("_id", (Object)100).append("N2_N4", (Object)row));
        BasicDBObject match = new BasicDBObject("_id", (Object)100);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, results);
        BasicDBList expected = new BasicDBList();
        expected.add((Object)new BasicDBObject("_id", (Object)2).append("e3", (Object)5));
        BasicDBObject details = new BasicDBObject("N2.N4", (Object)expected);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$set", (Object)details), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeDelete_one_2_one_many_onFK() throws Exception {
        String query = "DELETE FROM N4 WHERE e2 = 100";
        ArrayList<DBObject> results = new ArrayList<DBObject>();
        BasicDBList row = new BasicDBList();
        row.add((Object)new BasicDBObject("e1", (Object)1).append("e3", (Object)5));
        row.add((Object)new BasicDBObject("e1", (Object)2).append("e3", (Object)5));
        results.add((DBObject)new BasicDBObject("_id", (Object)100).append("N2_N4", (Object)row));
        BasicDBObject match = new BasicDBObject("_id", (Object)100);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, results);
        BasicDBObject details = new BasicDBObject("N2.N4", (Object)new BasicDBList());
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$set", (Object)details), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testUpdate() throws Exception {
        String query = "UPDATE N1 SET e2 = 2, e3 = 3 WHERE e1 = 1";
        BasicDBObject match = new BasicDBObject("_id", (Object)1);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, null);
        BasicDBObject details = new BasicDBObject();
        details.append("e2", (Object)2);
        details.append("e3", (Object)3);
        details = new BasicDBObject("$set", (Object)details);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)details, false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeUpdate_one_2_one() throws Exception {
        String query = "UPDATE N2 SET e2 = 2 WHERE e2 = 3";
        BasicDBObject N2ROW = new BasicDBObject().append("e2", (Object)3).append("e3", (Object)2);
        ArrayList<DBObject> N1ROWS = new ArrayList<DBObject>();
        N1ROWS.add((DBObject)new BasicDBObject("_id", (Object)1).append("N2", (Object)N2ROW));
        BasicDBObject match = new BasicDBObject("_id", (Object)1);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, N1ROWS);
        BasicDBObject N2UPDATE = new BasicDBObject();
        N2UPDATE.append("N2", (Object)new BasicDBObject().append("e2", (Object)2).append("e3", (Object)2));
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$set", (Object)N2UPDATE), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testMergeUpdate_one_2_many() throws Exception {
        String query = "UPDATE N5 SET e3 = 5 WHERE e1 = 1";
        ArrayList<DBObject> N1ROWS = new ArrayList<DBObject>();
        BasicDBList N5ROW = new BasicDBList();
        N5ROW.add((Object)new BasicDBObject("_id", (Object)1).append("e2", (Object)1).append("e3", (Object)1));
        N5ROW.add((Object)new BasicDBObject("_id", (Object)2).append("e2", (Object)1).append("e3", (Object)2));
        N1ROWS.add((DBObject)new BasicDBObject("_id", (Object)1).append("e2", (Object)1).append("e3", (Object)1).append("N5", (Object)N5ROW));
        BasicDBObject match = new BasicDBObject("_id", (Object)1);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, N1ROWS);
        BasicDBList expected = new BasicDBList();
        expected.add((Object)new BasicDBObject("_id", (Object)1).append("e2", (Object)1).append("e3", (Object)5));
        expected.add((Object)new BasicDBObject("_id", (Object)2).append("e2", (Object)1).append("e3", (Object)2));
        BasicDBObject update = new BasicDBObject("N5", (Object)expected);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$set", (Object)update), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testNestedMergeInsert_one_2_one() throws Exception {
        DBObject n1_match = QueryBuilder.start().and(new DBObject[]{QueryBuilder.start((String)"N2").exists((Object)true).get(), new BasicDBObject("_id", (Object)1)}).get();
        BasicDBObject match = new BasicDBObject();
        match.append("_id", (Object)1);
        BasicDBObject n3 = new BasicDBObject();
        n3.append("e2", (Object)3);
        n3.append("e3", (Object)3);
        BasicDBObject result = new BasicDBObject("N2.N3", (Object)n3);
        String query = "INSERT INTO N3 (e1, e2, e3) VALUES (1,3,3)";
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, null);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert(n1_match, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update(n1_match, (DBObject)new BasicDBObject("$set", (Object)result), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testNestedMergeUpdate_one_2_one_2_one() throws Exception {
        String query = "UPDATE N3 SET e2 = 2 WHERE e1 = 1 and e2 = 3";
        BasicDBObject N3ROW = new BasicDBObject().append("e2", (Object)3).append("e3", (Object)3);
        ArrayList<DBObject> N1ROWS = new ArrayList<DBObject>();
        N1ROWS.add((DBObject)new BasicDBObject("_id", (Object)1).append("N2_N3", (Object)N3ROW));
        BasicDBObject match = new BasicDBObject("_id", (Object)1);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, N1ROWS);
        BasicDBObject N3UPDATE = new BasicDBObject();
        N3UPDATE.append("N2.N3", (Object)new BasicDBObject().append("e2", (Object)2).append("e3", (Object)3));
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$set", (Object)N3UPDATE), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testNestedMergeDelete_one_2_one_2_one() throws Exception {
        String query = "DELETE FROM N3 WHERE e1 = 1 and e2 = 3";
        BasicDBObject N3ROW = new BasicDBObject().append("e2", (Object)3).append("e3", (Object)3);
        ArrayList<DBObject> N1ROWS = new ArrayList<DBObject>();
        N1ROWS.add((DBObject)new BasicDBObject("_id", (Object)1).append("N2_N3", (Object)N3ROW));
        DBObject match = QueryBuilder.start().and(new DBObject[]{new BasicDBObject("_id", (Object)1), new BasicDBObject("N2.N3.e2", (Object)3)}).get();
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, match, N1ROWS);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update(match, (DBObject)new BasicDBObject("$unset", (Object)new BasicDBObject("N2.N3", (Object)"")), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testNestedMergeUpdate_one_2_one_2_many() throws Exception {
        String query = "UPDATE N4 SET e3 = 5 WHERE e1 = 1";
        BasicDBList N4ROW = new BasicDBList();
        N4ROW.add((Object)new BasicDBObject("_id", (Object)1).append("e3", (Object)1));
        N4ROW.add((Object)new BasicDBObject("_id", (Object)2).append("e3", (Object)2));
        ArrayList<DBObject> N1ROWS = new ArrayList<DBObject>();
        N1ROWS.add((DBObject)new BasicDBObject("_id", (Object)1).append("N2_N4", (Object)N4ROW));
        BasicDBObject match = new BasicDBObject("_id", (Object)1);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, N1ROWS);
        BasicDBList expected = new BasicDBList();
        expected.add((Object)new BasicDBObject("_id", (Object)1).append("e3", (Object)5));
        expected.add((Object)new BasicDBObject("_id", (Object)2).append("e3", (Object)2));
        BasicDBObject N4UPDATE = new BasicDBObject("N2.N4", (Object)expected);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update((DBObject)match, (DBObject)new BasicDBObject("$set", (Object)N4UPDATE), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testNestedMergeUpdate_one_2_many_2_one() throws Exception {
        String query = "UPDATE N6 SET e3 = 5 WHERE e1 = 5";
        ArrayList<DBObject> N1ROWS = new ArrayList<DBObject>();
        BasicDBList N5ROW = new BasicDBList();
        N5ROW.add((Object)5);
        N5ROW.add((Object)51);
        BasicDBList N5ROW2 = new BasicDBList();
        N5ROW2.add((Object)50);
        N5ROW2.add((Object)5);
        BasicDBList N5_N6ROW = new BasicDBList();
        N5_N6ROW.add((Object)new BasicDBObject("e2", (Object)6).append("e3", (Object)6));
        N5_N6ROW.add((Object)new BasicDBObject("e2", (Object)0).append("e3", (Object)6));
        BasicDBList N5_N6ROW2 = new BasicDBList();
        N5_N6ROW2.add((Object)new BasicDBObject("e2", (Object)1).append("e3", (Object)1));
        N5_N6ROW2.add((Object)new BasicDBObject("e2", (Object)2).append("e3", (Object)2));
        N1ROWS.add((DBObject)new BasicDBObject("_id", (Object)1).append("N5", (Object)N5ROW).append("N5_N6", (Object)N5_N6ROW));
        N1ROWS.add((DBObject)new BasicDBObject("_id", (Object)2).append("N5", (Object)N5ROW2).append("N5_N6", (Object)N5_N6ROW2));
        BasicDBObject match = new BasicDBObject("_id", (Object)1);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, N1ROWS);
        BasicDBObject expected1 = new BasicDBObject("e2", (Object)6).append("e3", (Object)5);
        BasicDBObject expected2 = new BasicDBObject("e2", (Object)2).append("e3", (Object)5);
        ArgumentCaptor matchCaptor = ArgumentCaptor.forClass(BasicDBObject.class);
        ArgumentCaptor updateCaptor = ArgumentCaptor.forClass(BasicDBObject.class);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.times((int)2))).update((DBObject)matchCaptor.capture(), (DBObject)updateCaptor.capture(), Mockito.eq((boolean)false), Mockito.eq((boolean)true), (WriteConcern)Mockito.eq((Object)WriteConcern.ACKNOWLEDGED));
        Assert.assertEquals((Object)new BasicDBObject("_id", (Object)1), matchCaptor.getAllValues().get(0));
        Assert.assertEquals((Object)new BasicDBObject("_id", (Object)2), matchCaptor.getAllValues().get(1));
        Assert.assertEquals((Object)new BasicDBObject("$set", (Object)new BasicDBObject("N5.0.N6", (Object)expected1)), updateCaptor.getAllValues().get(0));
        Assert.assertEquals((Object)new BasicDBObject("$set", (Object)new BasicDBObject("N5.1.N6", (Object)expected2)), updateCaptor.getAllValues().get(1));
    }

    @Test
    public void testNestedMergeUpdate_one_2_many_2_many() throws Exception {
        String query = "UPDATE N7 SET e3 = 5 WHERE e1 = 5";
        ArrayList<DBObject> N1ROWS = new ArrayList<DBObject>();
        BasicDBList N5ROW = new BasicDBList();
        N5ROW.add((Object)5);
        N5ROW.add((Object)51);
        BasicDBList N5ROW2 = new BasicDBList();
        N5ROW2.add((Object)50);
        N5ROW2.add((Object)5);
        BasicDBList N5_N7ROW = new BasicDBList();
        N5_N7ROW.add((Object)new BasicDBObject("_id", (Object)7).append("e3", (Object)7));
        BasicDBList N5_N7ROW_ARRAY1 = new BasicDBList();
        N5_N7ROW_ARRAY1.add((Object)N5_N7ROW);
        BasicDBList N5_N7ROW2 = new BasicDBList();
        N5_N7ROW2.add((Object)new BasicDBObject("_id", (Object)5).append("e3", (Object)7));
        N5_N7ROW2.add((Object)new BasicDBObject("_id", (Object)7).append("e3", (Object)7));
        BasicDBList N5_N7ROW_ARRAY2 = new BasicDBList();
        N5_N7ROW_ARRAY2.add((Object)new BasicDBList());
        N5_N7ROW_ARRAY2.add((Object)N5_N7ROW2);
        N1ROWS.add((DBObject)new BasicDBObject("_id", (Object)1).append("N5", (Object)N5ROW).append("N5_N7", (Object)N5_N7ROW_ARRAY1));
        N1ROWS.add((DBObject)new BasicDBObject("_id", (Object)2).append("N5", (Object)N5ROW2).append("N5_N7", (Object)N5_N7ROW_ARRAY2));
        BasicDBObject match = new BasicDBObject("_id", (Object)1);
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, N1ROWS);
        ArgumentCaptor matchCaptor = ArgumentCaptor.forClass(BasicDBObject.class);
        ArgumentCaptor updateCaptor = ArgumentCaptor.forClass(BasicDBObject.class);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert((DBObject)new BasicDBObject(), WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.times((int)1))).update((DBObject)matchCaptor.capture(), (DBObject)updateCaptor.capture(), Mockito.eq((boolean)false), Mockito.eq((boolean)true), (WriteConcern)Mockito.eq((Object)WriteConcern.ACKNOWLEDGED));
        Assert.assertEquals((Object)new BasicDBObject("_id", (Object)2), matchCaptor.getAllValues().get(0));
        BasicDBList EXPECTED_N5_N7ROW2 = new BasicDBList();
        EXPECTED_N5_N7ROW2.add((Object)new BasicDBObject("_id", (Object)5).append("e3", (Object)5));
        EXPECTED_N5_N7ROW2.add((Object)new BasicDBObject("_id", (Object)7).append("e3", (Object)7));
        BasicDBList EXPECTED_N5_N7ROW2_ARRAY = new BasicDBList();
        EXPECTED_N5_N7ROW2_ARRAY.add((Object)EXPECTED_N5_N7ROW2);
        Assert.assertEquals((Object)new BasicDBObject("$set", (Object)new BasicDBObject("N5.1.N7", (Object)EXPECTED_N5_N7ROW2)), updateCaptor.getAllValues().get(0));
    }

    @Test
    public void testNestedMergeInsert_One_2_One_Many() throws Exception {
        DBObject n1_match = QueryBuilder.start().and(new DBObject[]{QueryBuilder.start((String)"N2").exists((Object)true).get(), new BasicDBObject("_id", (Object)2)}).get();
        BasicDBObject match = new BasicDBObject();
        match.append("_id", (Object)3);
        BasicDBObject n4 = new BasicDBObject();
        n4.append("e3", (Object)3);
        n4.append("_id", (Object)1);
        BasicDBObject result = new BasicDBObject("N2.N4", (Object)n4);
        String query = "INSERT INTO N4 (e1, e2, e3) VALUES (1,2,3)";
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, null);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert(n1_match, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update(n1_match, (DBObject)new BasicDBObject("$push", (Object)result), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testNestedMergeInsert_One_2_Many_one() throws Exception {
        DBObject n1_match = QueryBuilder.start().and(new DBObject[]{QueryBuilder.start((String)"N5").exists((Object)true).get(), new BasicDBObject("N5._id", (Object)1)}).get();
        BasicDBObject match = new BasicDBObject();
        match.append("_id", (Object)3);
        BasicDBObject n6 = new BasicDBObject();
        n6.append("e2", (Object)2);
        n6.append("e3", (Object)3);
        BasicDBObject result = new BasicDBObject("N5.$.N6", (Object)n6);
        String query = "INSERT INTO N6 (e1, e2, e3) VALUES (1,2,3)";
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, null);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert(n1_match, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update(n1_match, (DBObject)new BasicDBObject("$set", (Object)result), false, true, WriteConcern.ACKNOWLEDGED);
    }

    @Test
    public void testNestedMergeInsert_One_2_Many_Many() throws Exception {
        DBObject n1_match = QueryBuilder.start().and(new DBObject[]{QueryBuilder.start((String)"N5").exists((Object)true).get(), new BasicDBObject("N5._id", (Object)2)}).get();
        BasicDBObject match = new BasicDBObject();
        match.append("_id", (Object)3);
        BasicDBObject n7 = new BasicDBObject();
        n7.append("e3", (Object)3);
        n7.append("_id", (Object)1);
        BasicDBObject result = new BasicDBObject("N5.$.N7", (Object)n7);
        String query = "INSERT INTO N7 (e1, e2, e3) VALUES (1,2,3)";
        DBCollection dbCollection = this.helpUpdate(query, new String[]{"N1"}, (DBObject)match, null);
        ((DBCollection)Mockito.verify((Object)dbCollection, (VerificationMode)Mockito.never())).insert(n1_match, WriteConcern.ACKNOWLEDGED);
        ((DBCollection)Mockito.verify((Object)dbCollection)).update(n1_match, (DBObject)new BasicDBObject("$push", (Object)result), false, true, WriteConcern.ACKNOWLEDGED);
    }

    private static class ResultsCursor
    implements Cursor {
        private Iterator<DBObject> rows;

        ResultsCursor(ArrayList<DBObject> rows) {
            this.rows = rows.iterator();
        }

        public void remove() {
            this.rows.remove();
        }

        public DBObject next() {
            return this.rows.next();
        }

        public boolean hasNext() {
            return this.rows.hasNext();
        }

        public ServerAddress getServerAddress() {
            return null;
        }

        public long getCursorId() {
            return 0L;
        }

        public void close() {
        }
    }
}

