/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.ExistsNode;
import org.teiid.translator.mongodb.ProcessingNode;
import org.teiid.translator.mongodb.ProjectionNode;
import org.teiid.translator.mongodb.UnwindNode;

public class MergePlanner {
    protected LinkedHashSet<ProcessingNode> mergeProcessing = new LinkedHashSet();

    public void addNode(ExistsNode node) throws TranslatorException {
        for (ProcessingNode pn : this.mergeProcessing) {
            if (!(pn instanceof UnwindNode) || !pn.getDocumentName().equals(node.getDocumentName())) continue;
            return;
        }
        this.mergeProcessing.add(node);
    }

    public void addNode(UnwindNode node) throws TranslatorException {
        Iterator iter = this.mergeProcessing.iterator();
        while (iter.hasNext()) {
            ProcessingNode pn = (ProcessingNode)iter.next();
            if (!(pn instanceof ExistsNode) || !pn.getDocumentName().equals(node.getDocumentName())) continue;
            iter.remove();
            break;
        }
        this.mergeProcessing.add(node);
    }

    public void addNode(ProjectionNode node, String alias) {
        for (ProcessingNode pn : this.mergeProcessing) {
            if (!(pn instanceof ProjectionNode)) continue;
            ProjectionNode projectionNode = (ProjectionNode)pn;
            projectionNode.append(alias, node);
            return;
        }
        this.mergeProcessing.add(node);
    }

    public Set<ProcessingNode> getNodes() {
        return this.mergeProcessing;
    }
}

