/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.QueryBuilder;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teiid.GeneratedKeys;
import org.teiid.core.BundleUtil;
import org.teiid.language.Command;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Update;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.mongodb.MergeDetails;
import org.teiid.translator.mongodb.MongoDBBaseExecution;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDBUpdateVisitor;
import org.teiid.translator.mongodb.MongoDocument;

public class MongoDBUpdateExecution
extends MongoDBBaseExecution
implements UpdateExecution {
    private Command command;
    private MongoDBUpdateVisitor visitor;
    private MongoDBExecutionFactory executionFactory;
    private int[] results = new int[]{0};

    public MongoDBUpdateExecution(MongoDBExecutionFactory executionFactory, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection) throws TranslatorException {
        super(executionContext, metadata, connection);
        this.command = command;
        this.executionFactory = executionFactory;
        this.visitor = new MongoDBUpdateVisitor(executionFactory, metadata, this.mongoDB);
        this.visitor.visitNode((LanguageObject)command);
        if (!this.visitor.exceptions.isEmpty()) {
            throw (TranslatorException)((Object)this.visitor.exceptions.get(0));
        }
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    public void execute() throws TranslatorException {
        try {
            this.executeInternal();
        }
        catch (MongoException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private void executeInternal() throws TranslatorException {
        BasicDBObject match;
        LinkedHashMap<String, DBObject> embeddedDocuments;
        DBCollection collection = this.getCollection(this.visitor.mongoDoc.getTargetTable());
        MongoDocument mongoDoc = this.visitor.mongoDoc;
        AggregationOptions options = this.executionFactory.getOptions(this.executionContext.getBatchSize());
        ArrayList<WriteResult> executionResults = new ArrayList<WriteResult>();
        if (this.command instanceof Insert) {
            embeddedDocuments = this.fetchEmbeddedDocuments();
            if (mongoDoc.isMerged()) {
                BasicDBObject insertDoc;
                match = this.getInsertMatch(mongoDoc, this.visitor.columnValues);
                BasicDBObject insert = this.visitor.getInsert(embeddedDocuments);
                if (mongoDoc.getMergeKey().getAssociation() == MergeDetails.Association.MANY) {
                    this.removeParentKey(mongoDoc, insert);
                    insertDoc = new BasicDBObject(mongoDoc.getQualifiedName(true), (Object)insert);
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("update - {\"$match\": {" + match + "}}"));
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("update - {\"$push\": {" + insertDoc + "}}"));
                    executionResults.add(collection.update((DBObject)match, (DBObject)new BasicDBObject("$push", (Object)insertDoc), false, true, WriteConcern.ACKNOWLEDGED));
                } else {
                    insert.remove((Object)"_id");
                    insertDoc = new BasicDBObject(mongoDoc.getQualifiedName(true), (Object)insert);
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("update - {\"$match\": {" + match + "}}"));
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("update - {\"$set\": {" + insertDoc + "}}"));
                    executionResults.add(collection.update((DBObject)match, (DBObject)new BasicDBObject("$set", (Object)insertDoc), false, true, WriteConcern.ACKNOWLEDGED));
                }
            } else {
                for (String docName : embeddedDocuments.keySet()) {
                    DBObject embeddedDoc = embeddedDocuments.get(docName);
                    embeddedDoc.removeField("_id");
                }
                BasicDBObject in = this.visitor.getInsert(embeddedDocuments);
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("{\"insert\": {" + in + "}}"));
                executionResults.add(collection.insert((DBObject)in, WriteConcern.ACKNOWLEDGED));
            }
        } else if (this.command instanceof Update) {
            embeddedDocuments = this.fetchEmbeddedDocuments();
            match = new BasicDBObject();
            if (this.visitor.match != null) {
                match = this.visitor.match;
            }
            if (mongoDoc.isMerged()) {
                List<String> parentKeyNames = this.parentKeyNames(mongoDoc);
                BasicDBObject documentMatch = new BasicDBObject("$match", (Object)match);
                BasicDBObject projection = new BasicDBObject("$project", (Object)this.buildProjectForUpdate(mongoDoc));
                Cursor output = collection.aggregate(Arrays.asList(documentMatch, projection), options);
                while (output.hasNext()) {
                    BasicDBObject row = (BasicDBObject)output.next();
                    this.buildUpdate(mongoDoc, collection, row, parentKeyNames, 0, null, executionResults, new UpdateOperationImpl());
                }
            } else {
                for (String docName : embeddedDocuments.keySet()) {
                    DBObject embeddedDoc = embeddedDocuments.get(docName);
                    embeddedDoc.removeField("_id");
                }
                BasicDBObject u = this.visitor.getUpdate(embeddedDocuments);
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("update - {\"$match\": {" + match + "}}"));
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("update - {\"$set\": {" + u + "}}"));
                executionResults.add(collection.update((DBObject)match, (DBObject)new BasicDBObject("$set", (Object)u), false, true, WriteConcern.ACKNOWLEDGED));
            }
            if (mongoDoc.isEmbeddable()) {
                this.updateReferenceTables(collection, mongoDoc, (DBObject)match, options);
            }
        } else {
            BasicDBObject match2 = new BasicDBObject();
            if (this.visitor.match != null) {
                match2 = this.visitor.match;
            }
            if (mongoDoc.isEmbeddable()) {
                BasicDBObject m = new BasicDBObject("$match", (Object)match2);
                Cursor output = collection.aggregate(Arrays.asList(m), options);
                while (output.hasNext()) {
                    DBObject row = (DBObject)output.next();
                    if (row == null) continue;
                    for (MergeDetails ref : mongoDoc.getEmbeddedIntoReferences()) {
                        DBObject parentMatch;
                        BasicDBObject refMatch;
                        DBCollection parent = this.getCollection(ref.getParentTable());
                        Cursor referenceOutput = parent.aggregate(Arrays.asList(refMatch = new BasicDBObject("$match", (Object)(parentMatch = this.buildParentMatch(row, ref)))), options);
                        if (!referenceOutput.hasNext()) continue;
                        throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18010, new Object[]{this.visitor.mongoDoc.getTargetTable().getName(), ref.getParentTable()}));
                    }
                }
            }
            if (mongoDoc.isMerged()) {
                List<String> parentKeyNames = this.parentKeyNames(mongoDoc);
                BasicDBObject documentMatch = new BasicDBObject("$match", (Object)match2);
                BasicDBObject projection = new BasicDBObject("$project", (Object)this.buildProjectForUpdate(mongoDoc));
                Cursor output = collection.aggregate(Arrays.asList(documentMatch, projection), options);
                while (output.hasNext()) {
                    BasicDBObject row = (BasicDBObject)output.next();
                    this.buildUpdate(mongoDoc, collection, row, parentKeyNames, 0, null, executionResults, new DeleteOperationImpl((DBObject)match2));
                }
            } else {
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("remove - {\"$match\": {" + match2 + "}}"));
                executionResults.add(collection.remove((DBObject)match2, WriteConcern.ACKNOWLEDGED));
            }
        }
        if (!executionResults.isEmpty()) {
            if (this.command instanceof Insert && this.executionContext.getCommandContext().isReturnAutoGeneratedKeys()) {
                this.addAutoGeneretedKeys((WriteResult)executionResults.get(0));
            }
            int updated = 0;
            for (WriteResult result : executionResults) {
                updated += result.getN();
            }
            this.results = new int[1];
            this.results[0] = updated;
        }
    }

    DBObject getInsertMatch(MongoDocument mongoDocument, Map<String, Object> values) throws TranslatorException {
        ArrayList<Object> matches = new ArrayList<Object>();
        HashMap<String, Object> matchValues = new HashMap<String, Object>();
        MongoDocument mergeDocument = mongoDocument.getMergeDocument();
        MongoDocument targetDocument = mongoDocument.getTargetDocument();
        if (mongoDocument.getMergeKey().getAssociation() == MergeDetails.Association.ONE) {
            while (mergeDocument.isMerged()) {
                matches.add(QueryBuilder.start((String)mergeDocument.getDocumentName()).exists((Object)true).get());
                if (mergeDocument.getMergeKey().getAssociation() != MergeDetails.Association.ONE) break;
                mergeDocument = mergeDocument.getMergeDocument();
            }
            if (mergeDocument.equals(targetDocument)) {
                matchValues.put("_id", values.get("_id"));
            } else {
                matchValues.put(mergeDocument + "._id", values.get("_id"));
            }
        } else {
            if (!mergeDocument.equals(targetDocument)) {
                matches.add(QueryBuilder.start((String)mergeDocument.getDocumentName()).exists((Object)true).get());
            }
            String columnName = mergeDocument.getColumnName(mongoDocument.getMergeKey().getReferenceColumns().get(0));
            Iterator value = values.get(mongoDocument.getMergeKey().getColumns().get(0));
            if (value instanceof MergeDetails) {
                value = ((MergeDetails)((Object)value)).getValue();
            }
            if (mergeDocument.equals(targetDocument)) {
                matchValues.put(columnName, value);
            } else {
                while (mergeDocument.isMerged() && mergeDocument.getMergeKey().getAssociation() == MergeDetails.Association.ONE) {
                    mergeDocument = mergeDocument.getMergeDocument();
                }
                matchValues.put(columnName, value);
            }
        }
        BasicDBObject match = new BasicDBObject();
        for (String key : matchValues.keySet()) {
            match.append(key, matchValues.get(key));
        }
        if (!matches.isEmpty()) {
            matches.add(match);
            QueryBuilder qb = QueryBuilder.start().and((DBObject[])matches.toArray(new BasicDBObject[matches.size()]));
            match = (BasicDBObject)qb.get();
        }
        return match;
    }

    private void buildUpdate(MongoDocument doc, DBCollection collection, BasicDBObject row, List<String> parentKeys, int level, RowInfo rowInfo, List<WriteResult> executionResults, UpdateOperation operation) throws TranslatorException {
        String parentKeyName = parentKeys.get(level);
        boolean top = parentKeyName.equals(doc.getTargetDocument().getQualifiedName(false));
        Object parentBlock = row.get(top ? "_id" : parentKeyName);
        if (parentBlock == null) {
            parentBlock = rowInfo.PK;
        }
        String mergeTableName = doc.getTable().getName();
        if (parentKeys.size() != level + 1) {
            mergeTableName = parentKeys.get(level + 1);
        }
        if (parentBlock instanceof BasicDBList) {
            BasicDBList parentRows = (BasicDBList)parentBlock;
            for (int i = 0; i < parentRows.size(); ++i) {
                RowInfo info = RowInfo.build(parentKeyName, mergeTableName, parentRows.get(i), i, rowInfo);
                if (parentKeys.size() == level + 1) {
                    String aliasDocumentName = doc.getQualifiedName(false).replace('.', '_');
                    BasicDBList dataRows = (BasicDBList)row.get(aliasDocumentName);
                    if (dataRows == null || dataRows.size() <= i) continue;
                    operation.execute(doc, collection, (DBObject)row, (DBObject)dataRows.get(i), info, executionResults);
                    continue;
                }
                this.buildUpdate(doc, collection, row, parentKeys, level + 1, info, executionResults, operation);
            }
        } else {
            RowInfo info = RowInfo.build(parentKeyName, mergeTableName, parentBlock, -1, rowInfo);
            if (parentKeys.size() == level + 1) {
                String aliasDocumentName = doc.getQualifiedName(false).replace('.', '_');
                DBObject dataRows = (DBObject)row.get(aliasDocumentName);
                if (dataRows != null) {
                    operation.execute(doc, collection, (DBObject)row, dataRows, info, executionResults);
                }
            } else {
                this.buildUpdate(doc, collection, row, parentKeys, level + 1, info, executionResults, operation);
            }
        }
    }

    private BasicDBObject buildProjectForUpdate(MongoDocument doc) throws TranslatorException {
        BasicDBObject project = new BasicDBObject();
        String aliasDocumentName = doc.getQualifiedName(false).replace('.', '_');
        project.append(aliasDocumentName, (Object)("$" + doc.getQualifiedName(false)));
        while (doc.isMerged()) {
            if (!(doc = doc.getMergeDocument()).isMerged()) continue;
            project.append(doc.getQualifiedName(false), (Object)("$" + doc.getQualifiedName(false) + "._id"));
        }
        project.append("_id", (Object)"$_id");
        return project;
    }

    private List<String> parentKeyNames(MongoDocument doc) throws TranslatorException {
        ArrayList<String> list = new ArrayList<String>();
        while (doc.isMerged()) {
            doc = doc.getMergeDocument();
            list.add(0, doc.getQualifiedName(false));
        }
        return list;
    }

    private void removeParentKey(MongoDocument document, BasicDBObject row) throws TranslatorException {
        Table source = document.getTable();
        Table target = document.getMergeTable();
        for (ForeignKey fk : source.getForeignKeys()) {
            if (!fk.getReferenceTableName().equals(target.getName())) continue;
            for (int i = 0; i < fk.getColumns().size(); ++i) {
                if (row == null) continue;
                row.remove((Object)((Column)fk.getColumns().get(i)).getName());
            }
        }
    }

    private void updateReferenceTables(DBCollection collection, MongoDocument mongoDoc, DBObject match, AggregationOptions options) throws TranslatorException {
        BasicDBObject m = new BasicDBObject("$match", (Object)match);
        Cursor output = collection.aggregate(Arrays.asList(m), options);
        while (output.hasNext()) {
            DBObject row = (DBObject)output.next();
            if (row == null) continue;
            for (MergeDetails ref : mongoDoc.getEmbeddedIntoReferences()) {
                DBCollection parent = this.getCollection(ref.getParentTable());
                DBObject parentmatch = this.buildParentMatch(row, ref);
                row.removeField("_id");
                parent.update(parentmatch, (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject(ref.getName(), (Object)row)), false, true, WriteConcern.ACKNOWLEDGED);
                Table parentTable = this.metadata.getTable(((Schema)mongoDoc.getTable().getParent()).getName(), ref.getParentTable());
                MongoDocument parentMongoDocument = new MongoDocument(parentTable, this.metadata);
                if (!parentMongoDocument.isEmbeddable()) continue;
                this.updateReferenceTables(parent, parentMongoDocument, parentmatch, options);
            }
        }
    }

    private DBObject buildParentMatch(DBObject row, MergeDetails ref) {
        BasicDBObject parentmatch = new BasicDBObject();
        Object rowid = row.get("_id");
        if (rowid instanceof BasicDBObject) {
            for (int i = 0; i < ref.getColumns().size(); ++i) {
                parentmatch.put(ref.getColumns().get(i), ((BasicDBObject)rowid).get(ref.getReferenceColumns().get(i)));
            }
        } else {
            parentmatch.put(ref.getColumns().get(0), rowid);
        }
        return parentmatch;
    }

    private LinkedHashMap<String, DBObject> fetchEmbeddedDocuments() {
        LinkedHashMap<String, DBObject> additionalDocuments = new LinkedHashMap<String, DBObject>();
        MongoDocument mongoDoc = this.visitor.mongoDoc;
        if (mongoDoc.hasEmbeddedDocuments()) {
            for (String docName : mongoDoc.getEmbeddedDocumentNames()) {
                DBObject document = mongoDoc.getEmbeddedDocument(this.mongoDB, docName);
                if (document == null) continue;
                additionalDocuments.put(docName, document);
            }
        }
        return additionalDocuments;
    }

    private DBCollection getCollection(String name) throws TranslatorException {
        return this.getCollection(this.metadata.getTable(((Schema)this.visitor.mongoDoc.getTable().getParent()).getName(), name));
    }

    private DBCollection getCollection(Table table) {
        DBCollection collection;
        if (!this.mongoDB.collectionExists(table.getName())) {
            collection = this.mongoDB.createCollection(table.getName(), null);
            for (ForeignKey record : table.getForeignKeys()) {
                this.createIndex(collection, (KeyRecord)record, false);
            }
            for (ForeignKey record : table.getUniqueKeys()) {
                this.createIndex(collection, (KeyRecord)record, true);
            }
            for (ForeignKey record : table.getIndexes()) {
                this.createIndex(collection, (KeyRecord)record, false);
            }
        } else {
            collection = this.mongoDB.getCollection(table.getName());
        }
        return collection;
    }

    private void createIndex(DBCollection collection, KeyRecord record, boolean unique) {
        BasicDBObject key = new BasicDBObject();
        for (Column c : record.getColumns()) {
            key.append(SQLStringVisitor.getRecordName((AbstractMetadataRecord)c), (Object)1);
        }
        BasicDBObject options = new BasicDBObject();
        options.put((Object)"name", (Object)record.getName());
        if (unique) {
            options.put((Object)"unique", (Object)Boolean.TRUE);
        }
        collection.createIndex((DBObject)key, (DBObject)options);
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return this.results;
    }

    private void addAutoGeneretedKeys(WriteResult result) throws TranslatorException {
        Table table = this.visitor.mongoDoc.getTargetTable();
        int cols = table.getPrimaryKey().getColumns().size();
        if (cols != 1) {
            return;
        }
        Class[] columnDataTypes = new Class[cols];
        String[] columnNames = new String[cols];
        for (int i = 0; i < cols; ++i) {
            columnDataTypes[i] = ((Column)table.getPrimaryKey().getColumns().get(i)).getJavaType();
            columnNames[i] = ((Column)table.getPrimaryKey().getColumns().get(i)).getName();
        }
        if (!columnNames[0].equals("_id")) {
            return;
        }
        GeneratedKeys generatedKeys = this.executionContext.getCommandContext().returnGeneratedKeys(columnNames, columnDataTypes);
        ArrayList<Object> vals = new ArrayList<Object>(columnDataTypes.length);
        for (int i = 0; i < columnDataTypes.length; ++i) {
            Object value = this.executionFactory.retrieveValue(result.getUpsertedId(), columnDataTypes[i], this.mongoDB, columnNames[i], columnNames[i]);
            vals.add(value);
        }
        generatedKeys.addKey(vals);
    }

    class DeleteOperationImpl
    implements UpdateOperation {
        private DBObject queryMatch;

        public DeleteOperationImpl(DBObject match) {
            this.queryMatch = match;
        }

        @Override
        public void execute(MongoDocument doc, DBCollection collection, DBObject row, DBObject dataRow, RowInfo rowInfo, List<WriteResult> executionResults) throws TranslatorException {
            if (dataRow instanceof BasicDBList) {
                BasicDBObject pull = (BasicDBObject)MongoDBUpdateExecution.this.visitor.getPullQuery().get(rowInfo.mergedTableName);
                if (this.queryMatch.keySet().isEmpty()) {
                    this.queryMatch = QueryBuilder.start((String)rowInfo.getId(doc)).exists((Object)true).get();
                    pull = new BasicDBObject(rowInfo.getId(doc), (Object)(pull != null ? pull : new BasicDBObject()));
                    LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)("update - {\"$match\": {" + this.queryMatch + "}}"));
                    LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)("update - {\"$pull\": {" + pull + "}}"));
                    WriteResult result = collection.update(this.queryMatch, (DBObject)new BasicDBObject("$pull", (Object)pull), false, true, WriteConcern.ACKNOWLEDGED);
                    executionResults.add(result);
                } else {
                    BasicDBList updatedDoc = new BasicDBList();
                    boolean update = MongoDBUpdateExecution.this.visitor.updateDelete((BasicDBList)dataRow, rowInfo, updatedDoc);
                    if (update) {
                        BasicDBObject m = new BasicDBObject("_id", row.get("_id"));
                        BasicDBObject u = new BasicDBObject(rowInfo.getId(doc), (Object)updatedDoc);
                        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("update - {\"$match\": {" + m + "}}"));
                        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("update - {\"$set\": {" + u + "}}"));
                        WriteResult result = collection.update((DBObject)m, (DBObject)new BasicDBObject("$set", (Object)u), false, true, WriteConcern.ACKNOWLEDGED);
                        executionResults.add(result);
                    }
                }
            } else {
                if (this.queryMatch.keySet().isEmpty()) {
                    this.queryMatch = QueryBuilder.start((String)rowInfo.getId(doc)).exists((Object)true).get();
                }
                BasicDBObject u = new BasicDBObject(rowInfo.getId(doc), (Object)"");
                LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)("update - {\"$match\": {" + this.queryMatch + "}}"));
                LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)("update - {\"$unset\": {" + u + "}}"));
                WriteResult result = collection.update(this.queryMatch, (DBObject)new BasicDBObject("$unset", (Object)u), false, true, WriteConcern.ACKNOWLEDGED);
                executionResults.add(result);
            }
        }
    }

    class UpdateOperationImpl
    implements UpdateOperation {
        UpdateOperationImpl() {
        }

        @Override
        public void execute(MongoDocument doc, DBCollection collection, DBObject row, DBObject dataRow, RowInfo rowInfo, List<WriteResult> executionResults) throws TranslatorException {
            if (dataRow instanceof BasicDBList) {
                BasicDBList updatedDoc = new BasicDBList();
                boolean update = MongoDBUpdateExecution.this.visitor.updateMerge((BasicDBList)dataRow, rowInfo, updatedDoc);
                if (update) {
                    BasicDBObject m = new BasicDBObject("_id", row.get("_id"));
                    BasicDBObject u = new BasicDBObject(rowInfo.getId(doc), (Object)updatedDoc);
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("update - {\"$match\": {" + m + "}}"));
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("update - {\"$set\": {" + u + "}}"));
                    WriteResult result = collection.update((DBObject)m, (DBObject)new BasicDBObject("$set", (Object)u), false, true, WriteConcern.ACKNOWLEDGED);
                    executionResults.add(result);
                }
            } else {
                BasicDBObject m = new BasicDBObject("_id", row.get("_id"));
                boolean update = MongoDBUpdateExecution.this.visitor.updateMerge((BasicDBObject)dataRow, rowInfo);
                if (update) {
                    BasicDBObject u = new BasicDBObject(rowInfo.getId(doc), (Object)dataRow);
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("update - {\"$match\": {" + m + "}}"));
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("update - {\"$set\": {" + u + "}}"));
                    WriteResult result = collection.update((DBObject)m, (DBObject)new BasicDBObject("$set", (Object)u), false, true, WriteConcern.ACKNOWLEDGED);
                    executionResults.add(result);
                }
            }
        }
    }

    private static interface UpdateOperation {
        public void execute(MongoDocument var1, DBCollection var2, DBObject var3, DBObject var4, RowInfo var5, List<WriteResult> var6) throws TranslatorException;
    }

    static class RowInfo {
        String tableName;
        String mergedTableName;
        Object PK;
        int rowNumber;
        RowInfo parent;
        boolean istop;

        RowInfo() {
        }

        static RowInfo build(String name, String mergeName, Object pk, int rowNumber, RowInfo parent) {
            RowInfo info = new RowInfo();
            info.tableName = name;
            info.mergedTableName = mergeName;
            info.PK = pk;
            info.rowNumber = rowNumber;
            if (parent != null) {
                info.parent = parent;
                info.istop = false;
            } else {
                info.istop = true;
            }
            return info;
        }

        public String getId(MongoDocument parent) {
            StringBuilder sb = new StringBuilder();
            sb.append(parent.getTable().getName());
            if (this.parent != null) {
                this.getId(sb);
            }
            return sb.toString();
        }

        private void getId(StringBuilder sb) {
            if (this.parent != null) {
                if (this.rowNumber != -1) {
                    sb.insert(0, ".");
                    sb.insert(0, this.rowNumber);
                }
                this.parent.getId(sb);
            }
            if (!this.istop) {
                sb.insert(0, ".");
                sb.insert(0, this.tableName);
            }
        }
    }
}

