/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.MergeDetails;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDBSelectVisitor;

class MongoDocument {
    private RuntimeMetadata metadata;
    private Table table;
    private MergeDetails mergeKey;
    private List<MergeDetails> embeddedKeys = new ArrayList<MergeDetails>();
    private LinkedHashMap<List<String>, MergeDetails> foreignKeys = new LinkedHashMap();
    private ArrayList<MergeDetails> copyto = new ArrayList();
    private MongoDocument mergeDocument;
    private HashMap<String, MongoDocument> relatedDocs = new HashMap();
    private String documentAlias;

    public MongoDocument(Table table, RuntimeMetadata metadata) throws TranslatorException {
        this.table = table;
        this.metadata = metadata;
        if (this.isEmbeddable() && this.isMerged()) {
            throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18013, new Object[]{table.getName()}));
        }
        this.build();
    }

    public Table getTable() {
        return this.table;
    }

    public Table getTargetTable() throws TranslatorException {
        if (this.isMerged()) {
            Table merge = this.getMergeTable();
            MongoDocument mergeDoc = this.getDocument(merge.getName());
            if (mergeDoc.isMerged()) {
                return mergeDoc.getTargetTable();
            }
            return merge;
        }
        return this.getTable();
    }

    public MongoDocument getTargetDocument() throws TranslatorException {
        if (this.isMerged()) {
            return this.getMergeDocument().getTargetDocument();
        }
        return this;
    }

    public boolean isEmbeddable() {
        return MongoDocument.isEmbeddable(this.table);
    }

    public static boolean isEmbeddable(Table tbl) {
        return Boolean.parseBoolean(tbl.getProperty("{http://www.teiid.org/translator/mongodb/2013}EMBEDDABLE", false));
    }

    public boolean isMerged() {
        return this.table.getProperty("{http://www.teiid.org/translator/mongodb/2013}MERGE", false) != null;
    }

    public Table getMergeTable() throws TranslatorException {
        String tblName = this.table.getProperty("{http://www.teiid.org/translator/mongodb/2013}MERGE", false);
        if (tblName == null) {
            return null;
        }
        Table mergeTable = this.metadata.getTable(((Schema)this.table.getParent()).getName(), tblName);
        return mergeTable;
    }

    public MongoDocument getMergeDocument() throws TranslatorException {
        if (this.mergeDocument != null) {
            return this.mergeDocument;
        }
        Table mergeTable = this.getMergeTable();
        if (mergeTable != null) {
            this.mergeDocument = new MongoDocument(mergeTable, this.metadata);
        }
        return this.mergeDocument;
    }

    public MergeDetails.Association getMergeAssociation() {
        return this.mergeKey.getAssociation();
    }

    public boolean hasEmbeddedDocuments() {
        return !this.embeddedKeys.isEmpty();
    }

    public List<String> getEmbeddedDocumentNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (MergeDetails ref : this.embeddedKeys) {
            names.add(ref.getName());
        }
        return names;
    }

    private void build() throws TranslatorException {
        this.buildForeignKeyReferences();
        this.buildEmbeddableIntoReferences();
        this.buildEmbeddedReferences();
        this.buildMergeKey();
    }

    private void buildEmbeddableIntoReferences() {
        if (this.isEmbeddable()) {
            for (Table t : ((Schema)this.table.getParent()).getTables().values()) {
                for (ForeignKey fk : t.getForeignKeys()) {
                    if (!((Table)fk.getReferenceKey().getParent()).equals((Object)this.table)) continue;
                    MergeDetails key = new MergeDetails(this);
                    key.setName(this.table.getName());
                    key.setParentTable(t.getName());
                    key.setEmbeddedTable(this.table.getName());
                    key.setColumns(MongoDBSelectVisitor.getColumnNames(fk.getColumns()));
                    key.setReferenceColumns(fk.getReferenceColumns());
                    key.setAssociation(MergeDetails.Association.ONE);
                    this.copyto.add(key);
                }
            }
        }
    }

    private void buildEmbeddedReferences() throws TranslatorException {
        for (ForeignKey fk : this.table.getForeignKeys()) {
            Table referenceTable = (Table)fk.getReferenceKey().getParent();
            MongoDocument refereceDoc = new MongoDocument(referenceTable, this.metadata);
            if (!refereceDoc.isEmbeddable() || this.isMerged() && this.getMergeTable().getName().equals(referenceTable.getName())) continue;
            MergeDetails key = new MergeDetails(this);
            key.setName(fk.getReferenceTableName());
            key.setParentTable(this.table.getName());
            key.setReferenceColumns(MongoDBSelectVisitor.getColumnNames(fk.getColumns()));
            key.setColumns(fk.getReferenceColumns());
            key.setEmbeddedTable(fk.getReferenceTableName());
            if (MongoDBSelectVisitor.isPartOfForeignKey(referenceTable, (String)fk.getReferenceColumns().get(0))) {
                key.setIdReference(MongoDBSelectVisitor.getForeignKeyRefTable(referenceTable, (String)fk.getReferenceColumns().get(0)));
            }
            this.embeddedKeys.add(key);
        }
    }

    private void buildForeignKeyReferences() throws TranslatorException {
        for (ForeignKey fk : this.table.getForeignKeys()) {
            MergeDetails key = new MergeDetails(this);
            key.setParentTable(fk.getReferenceTableName());
            key.setEmbeddedTable(this.table.getName());
            key.setName(fk.getName());
            key.setColumns(MongoDBSelectVisitor.getColumnNames(fk.getColumns()));
            key.setReferenceColumns(fk.getReferenceColumns());
            this.foreignKeys.put(MongoDBSelectVisitor.getColumnNames(fk.getColumns()), key);
        }
    }

    private void buildMergeKey() throws TranslatorException {
        if (!this.isMerged()) {
            return;
        }
        Table mergeTable = this.getMergeTable();
        for (ForeignKey fk : this.table.getForeignKeys()) {
            if (!((Table)fk.getReferenceKey().getParent()).equals((Object)mergeTable)) continue;
            MergeDetails key = new MergeDetails(this);
            key.setName(this.table.getName());
            key.setParentTable(mergeTable.getName());
            key.setColumns(MongoDBSelectVisitor.getColumnNames(fk.getColumns()));
            key.setReferenceColumns(fk.getReferenceColumns());
            key.setEmbeddedTable(this.table.getName());
            key.setAssociation(MergeDetails.Association.MANY);
            for (ForeignKey fk1 : mergeTable.getForeignKeys()) {
                if (!((Table)fk1.getReferenceKey().getParent()).equals((Object)this.table)) continue;
                key.setAssociation(MergeDetails.Association.ONE);
                break;
            }
            if (this.table.getPrimaryKey() != null && this.sameKeys(MongoDBSelectVisitor.getColumnNames(fk.getColumns()), MongoDBSelectVisitor.getColumnNames(this.table.getPrimaryKey().getColumns()))) {
                key.setAssociation(MergeDetails.Association.ONE);
            }
            this.mergeKey = key;
            break;
        }
    }

    private boolean sameKeys(List<String> columns1, List<String> columns2) {
        if (columns1.size() != columns2.size()) {
            return false;
        }
        for (String name : columns1) {
            if (columns2.contains(name)) continue;
            return false;
        }
        return true;
    }

    public void updateReferenceColumnValue(String tableName, String columnName, Object value) {
        for (Map.Entry<List<String>, MergeDetails> pairs : this.foreignKeys.entrySet()) {
            List<String> keys = pairs.getKey();
            MergeDetails ref = pairs.getValue();
            if (!keys.contains(columnName) || !ref.getEmbeddedTable().equals(tableName)) continue;
            ref.setId(columnName, value);
        }
        if (this.mergeKey != null && this.mergeKey.getColumns().contains(columnName) && this.mergeKey.getEmbeddedTable().equals(tableName)) {
            for (int i = 0; i < this.mergeKey.getColumns().size(); ++i) {
                String column = this.mergeKey.getColumns().get(i);
                if (!column.equals(columnName)) continue;
                String referenceColumn = this.mergeKey.getReferenceColumns().get(i);
                this.mergeKey.setId(referenceColumn, value);
            }
        }
        if (!this.embeddedKeys.isEmpty()) {
            for (MergeDetails ref : this.embeddedKeys) {
                if (!ref.getReferenceColumns().contains(columnName) || !ref.getParentTable().equals(tableName)) continue;
                for (int i = 0; i < ref.getReferenceColumns().size(); ++i) {
                    String column = ref.getReferenceColumns().get(i);
                    if (!column.equals(columnName)) continue;
                    String referenceColumn = ref.getColumns().get(i);
                    ref.setId(referenceColumn, value);
                }
            }
        }
    }

    public MergeDetails getFKReference(String columnName) {
        for (Map.Entry<List<String>, MergeDetails> pairs : this.foreignKeys.entrySet()) {
            List<String> keys = pairs.getKey();
            MergeDetails ref = pairs.getValue();
            if (!keys.contains(columnName)) continue;
            return ref;
        }
        return null;
    }

    public DBObject getEmbeddedDocument(DB mongoDB, String docName) {
        for (MergeDetails ref : this.embeddedKeys) {
            DBRef dbRef;
            if (!ref.getName().equals(docName) || (dbRef = ref.getDBRef(mongoDB, false)) == null) continue;
            return mongoDB.getCollection(dbRef.getCollectionName()).findOne((DBObject)new BasicDBObject("_id", dbRef.getId()));
        }
        return null;
    }

    public String getColumnName(String columnName) throws TranslatorException {
        String originalColumnName = columnName;
        boolean primaryKey = false;
        if (this.isPartOfPrimaryKey(originalColumnName)) {
            columnName = "_id";
            if (this.hasCompositePrimaryKey()) {
                columnName = "_id." + originalColumnName;
            }
            primaryKey = true;
        }
        if (this.isMerged()) {
            if (primaryKey && this.pkExistsInParent(this)) {
                if (this.documentAlias != null) {
                    return this.documentAlias + "." + columnName;
                }
                return columnName;
            }
            if (this.isPartOfForeignKey(originalColumnName)) {
                return this.getMergeDocument().getColumnName(this.mergeKey.getParentColumnName(originalColumnName));
            }
            return this.getDocumentName() + "." + columnName;
        }
        if (this.isEmbeddable()) {
            // empty if block
        }
        return columnName;
    }

    public String getDocumentName() throws TranslatorException {
        return this.documentAlias != null ? this.documentAlias : this.getQualifiedName(false);
    }

    public boolean pkExistsInParent(MongoDocument document) throws TranslatorException {
        while (document.isMerged()) {
            if (document.getMergeKey().getAssociation() == MergeDetails.Association.ONE) {
                document = document.getMergeDocument();
                continue;
            }
            return false;
        }
        return true;
    }

    public List<MergeDetails> getEmbeddedIntoReferences() {
        return this.copyto;
    }

    MergeDetails getMergeKey() {
        return this.mergeKey;
    }

    List<MergeDetails> getEmbeddedReferences() {
        return this.embeddedKeys;
    }

    public boolean embeds(MongoDocument right) throws TranslatorException {
        if (this.equals(right)) {
            return false;
        }
        for (MergeDetails ref : this.embeddedKeys) {
            if (!ref.getEmbeddedTable().equals(right.getTable().getName())) continue;
            return true;
        }
        for (MergeDetails ref : right.getEmbeddedIntoReferences()) {
            if (!ref.getParentTable().equals(this.getTable().getName())) continue;
            return true;
        }
        return this.nestedEmbedded(right);
    }

    public boolean merges(MongoDocument right) throws TranslatorException {
        if (this.equals(right)) {
            return false;
        }
        if (right.isMerged() && right.mergeKey.getParentTable().equals(this.getTable().getName())) {
            return true;
        }
        return this.nestedMerge(right);
    }

    public boolean contains(MongoDocument right) throws TranslatorException {
        return this.embeds(right) || this.merges(right);
    }

    private boolean nestedEmbedded(MongoDocument right) throws TranslatorException {
        MongoDocument parent;
        for (MergeDetails ref : this.embeddedKeys) {
            parent = this.getDocument(ref.getEmbeddedTable());
            if (!parent.embeds(right)) continue;
            return true;
        }
        for (MergeDetails ref : right.getEmbeddedIntoReferences()) {
            parent = this.getDocument(ref.getParentTable());
            if (!parent.embeds(right)) continue;
            return true;
        }
        return false;
    }

    private boolean nestedMerge(MongoDocument right) throws TranslatorException {
        MongoDocument parent;
        return right.isMerged() && (parent = this.getDocument(right.mergeKey.getParentTable())).merges(right);
    }

    public String getQualifiedName(boolean positional) throws TranslatorException {
        MongoDocument document = this;
        String tableName = this.getTable().getName();
        while (document.isMerged()) {
            if (!(document = document.getMergeDocument()).isMerged()) continue;
            if (positional) {
                if (document.mergeKey.getAssociation() == MergeDetails.Association.ONE) {
                    tableName = document.getTable().getName() + "." + tableName;
                    continue;
                }
                tableName = document.getTable().getName() + ".$." + tableName;
                continue;
            }
            tableName = document.getTable().getName() + "." + tableName;
        }
        return tableName;
    }

    private MongoDocument getDocument(String tblName) throws TranslatorException {
        if (this.relatedDocs.get(tblName) != null) {
            return this.relatedDocs.get(tblName);
        }
        Table tbl = this.metadata.getTable(((Schema)this.table.getParent()).getName(), tblName);
        MongoDocument doc = new MongoDocument(tbl, this.metadata);
        this.relatedDocs.put(tblName, doc);
        return doc;
    }

    public MergeDetails getEmbeddedDocumentReferenceKey(MongoDocument right) throws TranslatorException {
        if (this.equals(right)) {
            return null;
        }
        for (MergeDetails ref : this.embeddedKeys) {
            if (!ref.getEmbeddedTable().equals(right.getTable().getName())) continue;
            return ref.clone();
        }
        for (MergeDetails ref : right.getEmbeddedIntoReferences()) {
            if (!ref.getParentTable().equals(this.getTable().getName())) continue;
            return ref.clone();
        }
        return this.getNestedEmbeddedDocumentReferenceKey(right);
    }

    private MergeDetails getNestedEmbeddedDocumentReferenceKey(MongoDocument right) throws TranslatorException {
        MongoDocument parent;
        for (MergeDetails ref : this.embeddedKeys) {
            parent = this.getDocument(ref.getEmbeddedTable());
            if (!parent.contains(right)) continue;
            MergeDetails key = parent.getEmbeddedDocumentReferenceKey(right);
            key.setName(parent.getTable().getName() + "." + key.getName());
            key.setNested(true);
            return key;
        }
        for (MergeDetails ref : right.getEmbeddedIntoReferences()) {
            parent = this.getDocument(ref.getParentTable());
            if (!parent.contains(right)) continue;
            MergeDetails key = parent.getEmbeddedDocumentReferenceKey(right);
            key.setName(parent.getTable().getName() + "." + key.getName());
            key.setNested(true);
            return key;
        }
        return null;
    }

    public boolean isPartOfPrimaryKey(String columnName) {
        KeyRecord pk = this.table.getPrimaryKey();
        if (pk != null) {
            for (Column column : pk.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasCompositePrimaryKey() {
        KeyRecord pk = this.table.getPrimaryKey();
        return pk.getColumns().size() > 1;
    }

    boolean isPartOfForeignKey(String columnName) {
        for (ForeignKey fk : this.table.getForeignKeys()) {
            for (Column column : fk.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isCompositeForeignKey(String columnName) {
        for (ForeignKey fk : this.table.getForeignKeys()) {
            for (Column column : fk.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                return fk.getColumns().size() > 1;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MongoDocument)) {
            return false;
        }
        MongoDocument other = (MongoDocument)obj;
        return this.getTable().getName().equals(other.getTable().getName());
    }

    public String toString() {
        return this.getTable().getName();
    }

    public void setAlias(String alias) {
        this.documentAlias = alias;
    }

    public String getAlias() {
        return this.documentAlias;
    }
}

