/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.util.ArrayList;
import org.teiid.core.BundleUtil;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.ExistsNode;
import org.teiid.translator.mongodb.MergeDetails;
import org.teiid.translator.mongodb.MergePlanner;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDocument;
import org.teiid.translator.mongodb.ProjectionNode;

class JoinCriteriaVisitor
extends HierarchyVisitor {
    private Join.JoinType joinType;
    private MongoDocument left;
    private MongoDocument right;
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    protected MergePlanner mergePlanner;
    private String aliasName;

    public JoinCriteriaVisitor(Join.JoinType joinType, MongoDocument left, MongoDocument right, MergePlanner mergePlanner) {
        this.joinType = joinType;
        this.left = left;
        this.right = right;
        this.mergePlanner = mergePlanner;
    }

    public void process(Condition condition) throws TranslatorException {
        if (condition != null) {
            this.visitNode((LanguageObject)condition);
        }
        if (!this.exceptions.isEmpty()) {
            throw this.exceptions.get(0);
        }
    }

    public void visit(Comparison obj) {
        try {
            switch (obj.getOperator()) {
                case EQ: {
                    if (this.joinType.equals((Object)Join.JoinType.LEFT_OUTER_JOIN)) {
                        if (this.left.contains(this.right)) {
                            if (!this.right.isMerged() || !this.right.getMergeAssociation().equals((Object)MergeDetails.Association.MANY)) break;
                            this.mergePlanner.addNode(new ProjectionNode(this.left, this.buildIfNullBasedProjection(this.left, this.right)), this.aliasName);
                            break;
                        }
                        if (this.left.isMerged()) {
                            this.mergePlanner.addNode(new ExistsNode(this.left));
                            break;
                        }
                        throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18022, new Object[]{this.right.getTable().getName(), this.left.getTable().getName()}));
                    }
                    if (this.joinType.equals((Object)Join.JoinType.INNER_JOIN)) {
                        if (this.left.contains(this.right)) {
                            this.mergePlanner.addNode(new ExistsNode(this.right));
                            break;
                        }
                        this.mergePlanner.addNode(new ExistsNode(this.left));
                        break;
                    }
                    if (!this.joinType.equals((Object)Join.JoinType.CROSS_JOIN) && !this.joinType.equals((Object)Join.JoinType.FULL_OUTER_JOIN)) break;
                    throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18022, new Object[]{this.left.getTable().getName(), this.right.getTable().getName(), this.joinType}));
                }
                case NE: 
                case LT: 
                case LE: 
                case GT: 
                case GE: {
                    this.exceptions.add(new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18023, new Object[0])));
                }
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    private BasicDBObject buildIfNullBasedProjection(MongoDocument parent, MongoDocument child) throws TranslatorException {
        BasicDBObject columns = new BasicDBObject();
        Table table = parent.getTable();
        for (Column c : table.getColumns()) {
            if (parent.isMerged() || parent.isEmbeddable()) {
                columns.append(parent.getQualifiedName(false) + "." + c.getName(), (Object)1);
                continue;
            }
            columns.append(c.getName(), (Object)1);
        }
        BasicDBList exprs = new BasicDBList();
        exprs.add((Object)("$" + child.getQualifiedName(false)));
        BasicDBList list = new BasicDBList();
        list.add((Object)new BasicDBObject());
        exprs.add((Object)list);
        BasicDBObject ifnull = new BasicDBObject("$ifNull", (Object)exprs);
        this.aliasName = "__NN_" + child.getTable().getName();
        columns.append(this.aliasName, (Object)ifnull);
        child.setAlias(this.aliasName);
        child.getMergeKey().setAlias(this.aliasName);
        return columns;
    }
}

