/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.language.Literal;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.MongoDBBaseExecution;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;
import org.teiid.translator.mongodb.MongoDBPlugin;

public class MongoDBDirectQueryExecution
extends MongoDBBaseExecution
implements ProcedureExecution {
    private String query;
    private List<Argument> arguments;
    protected boolean returnsArray;
    private Cursor results;
    private MongoDBExecutionFactory executionFactory;

    public MongoDBDirectQueryExecution(List<Argument> arguments, Command cmd, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection, String nativeQuery, boolean returnsArray, MongoDBExecutionFactory ef) {
        super(executionContext, metadata, connection);
        this.arguments = arguments;
        this.returnsArray = returnsArray;
        this.query = nativeQuery;
        this.executionFactory = ef;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws TranslatorException {
        DBCollection collection;
        StringBuilder buffer = new StringBuilder();
        SQLStringVisitor.parseNativeQueryParts((String)this.query, this.arguments, (StringBuilder)buffer, (SQLStringVisitor.Substitutor)new SQLStringVisitor.Substitutor(){

            public void substitute(Argument arg, StringBuilder builder, int index) {
                Literal argumentValue = arg.getArgumentValue();
                builder.append(argumentValue.getValue());
            }
        });
        StringTokenizer st = new StringTokenizer(buffer.toString(), ";");
        String collectionName = st.nextToken();
        boolean shellOperation = collectionName.equalsIgnoreCase("$ShellCmd");
        String shellOperationName = null;
        if (shellOperation) {
            collectionName = st.nextToken();
            shellOperationName = st.nextToken();
        }
        if ((collection = this.mongoDB.getCollection(collectionName)) == null) {
            throw new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18020, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18020, new Object[]{collectionName}));
        }
        if (shellOperation) {
            ArrayList<Object> operations = new ArrayList<Object>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.startsWith("{")) {
                    operations.add(JSON.parse((String)token));
                    continue;
                }
                operations.add(token);
            }
            try {
                WriteResult wr;
                ReflectionHelper helper = new ReflectionHelper(DBCollection.class);
                Method method = helper.findBestMethodOnTarget(shellOperationName, operations.toArray(new Object[operations.size()]));
                Object result = method.invoke((Object)collection, operations.toArray(new Object[operations.size()]));
                if (result instanceof Cursor) {
                    this.results = (Cursor)result;
                    return;
                }
                if (!(result instanceof WriteResult) || (wr = (WriteResult)result).wasAcknowledged()) return;
                throw new TranslatorException(wr.toString());
            }
            catch (NoSuchMethodException e) {
                throw new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18034, (Throwable)e, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18034, new Object[]{buffer.toString()}));
            }
            catch (SecurityException e) {
                throw new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18034, (Throwable)e, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18034, new Object[]{buffer.toString()}));
            }
            catch (IllegalAccessException e) {
                throw new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18034, (Throwable)e, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18034, new Object[]{buffer.toString()}));
            }
            catch (IllegalArgumentException e) {
                throw new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18034, (Throwable)e, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18034, new Object[]{buffer.toString()}));
            }
            catch (InvocationTargetException e) {
                throw new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18034, e.getTargetException(), MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18034, new Object[]{buffer.toString()}));
            }
        } else {
            ArrayList<DBObject> operations = new ArrayList<DBObject>();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                operations.add((DBObject)JSON.parse((String)token));
            }
            if (operations.isEmpty()) {
                throw new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18021, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18021, new Object[]{collectionName}));
            }
            this.results = collection.aggregate(operations, this.executionFactory.getOptions(this.executionContext.getBatchSize()));
        }
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        final DBObject value = this.nextRow();
        if (value == null) {
            return null;
        }
        BlobType result = new BlobType((Blob)new BlobImpl(new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(JSON.serialize((Object)value).getBytes(Streamable.CHARSET));
            }
        }));
        if (this.returnsArray) {
            ArrayList<Object[]> row = new ArrayList<Object[]>(1);
            row.add(new Object[]{result});
            return row;
        }
        return Arrays.asList(result);
    }

    public DBObject nextRow() throws TranslatorException, DataNotAvailableException {
        if (this.results != null && this.results.hasNext()) {
            DBObject result = (DBObject)this.results.next();
            return result;
        }
        return null;
    }

    public void close() {
        if (this.results != null) {
            this.results.close();
            this.results = null;
        }
    }

    public void cancel() throws TranslatorException {
        this.close();
    }
}

