/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.core.util.StringUtil;

public class Version
implements Comparable<Version> {
    public static Version DEFAULT_VERSION = new Version(new Integer[]{0});
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(\\d+)");
    private Integer[] parts;

    public static Version getVersion(String version) {
        if (version == null) {
            return null;
        }
        String[] parts = version.split("\\.");
        ArrayList<Integer> versionParts = new ArrayList<Integer>();
        for (String part : parts) {
            Integer val = null;
            Matcher m = NUMBER_PATTERN.matcher(part);
            if (!m.find()) continue;
            String num = m.group(1);
            try {
                val = Integer.parseInt(num);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            versionParts.add(val == null ? 0 : val);
        }
        if (versionParts.isEmpty()) {
            return DEFAULT_VERSION;
        }
        return new Version(versionParts.toArray(new Integer[versionParts.size()]));
    }

    Version(Integer[] parts) {
        this.parts = parts;
    }

    public String toString() {
        return StringUtil.toString((Object[])this.parts, (String)".", (boolean)false);
    }

    public int getMajorVersion() {
        return this.parts[0];
    }

    @Override
    public int compareTo(Version o) {
        int length = Math.min(this.parts.length, o.parts.length);
        for (int i = 0; i < length; ++i) {
            int comp = this.parts[i].compareTo(o.parts[i]);
            if (comp == 0) continue;
            return comp;
        }
        if (this.parts.length > length) {
            return 1;
        }
        if (o.parts.length > length) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)obj) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode((Object[])this.parts);
    }
}

