/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.basic.ClobToStringTransform;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.Array;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.GroupBy;
import org.teiid.language.In;
import org.teiid.language.IsNull;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.OrderBy;
import org.teiid.language.Select;
import org.teiid.language.SortSpecification;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.query.function.GeometryUtils;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.ColumnDetail;
import org.teiid.translator.mongodb.ExistsNode;
import org.teiid.translator.mongodb.JoinCriteriaVisitor;
import org.teiid.translator.mongodb.MergeDetails;
import org.teiid.translator.mongodb.MergePlanner;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDocument;
import org.teiid.translator.mongodb.UnwindNode;

public class MongoDBSelectVisitor
extends HierarchyVisitor {
    private AtomicInteger aliasCount = new AtomicInteger();
    private AtomicInteger columnCount = new AtomicInteger();
    protected MongoDBExecutionFactory executionFactory;
    protected RuntimeMetadata metadata;
    private Select command;
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    protected Stack<Object> onGoingExpression = new Stack();
    protected ConcurrentHashMap<Object, ColumnDetail> expressionMap = new ConcurrentHashMap();
    private HashMap<String, BasicDBObject> groupByProjections = new HashMap();
    protected MongoDocument mongoDoc;
    protected BasicDBObject project = new BasicDBObject();
    protected Integer limit;
    protected Integer skip;
    protected DBObject sort;
    protected DBObject match;
    protected DBObject having;
    protected BasicDBObject group = new BasicDBObject();
    protected ArrayList<String> selectColumns = new ArrayList();
    protected ArrayList<String> selectColumnReferences = new ArrayList();
    protected boolean projectBeforeMatch = false;
    protected MergePlanner mergePlanner = new MergePlanner();
    protected ArrayList<Condition> pendingConditions = new ArrayList();
    protected LinkedList<MongoDocument> joinedDocuments = new LinkedList();
    private boolean processingDerivedColumn = false;

    public MongoDBSelectVisitor(MongoDBExecutionFactory executionFactory, RuntimeMetadata metadata) {
        this.executionFactory = executionFactory;
        this.metadata = metadata;
    }

    public void append(LanguageObject obj) {
        if (obj != null) {
            this.visitNode(obj);
        }
    }

    protected void append(List<? extends LanguageObject> items) {
        if (items != null && items.size() != 0) {
            this.append(items.get(0));
            for (int i = 1; i < items.size(); ++i) {
                this.append(items.get(i));
            }
        }
    }

    protected void append(LanguageObject[] items) {
        if (items != null && items.length != 0) {
            this.append(items[0]);
            for (int i = 1; i < items.length; ++i) {
                this.append(items[i]);
            }
        }
    }

    public String getColumnName(ColumnReference obj) {
        String elemShortName = null;
        Column elementID = obj.getMetadataObject();
        elemShortName = elementID != null ? SQLStringVisitor.getRecordName((AbstractMetadataRecord)elementID) : obj.getName();
        return elemShortName;
    }

    public void visit(DerivedColumn obj) {
        Expression teiidExpression = obj.getExpression();
        String alias = this.getAlias(obj.getAlias());
        this.processingDerivedColumn = true;
        this.append((LanguageObject)teiidExpression);
        Object mongoExpression = this.onGoingExpression.pop();
        ColumnDetail exprDetails = this.expressionMap.get(mongoExpression);
        if (exprDetails == null) {
            exprDetails = new ColumnDetail();
            exprDetails.addProjectedName(alias);
            this.expressionMap.put(mongoExpression, exprDetails);
        } else if (this.projectBeforeMatch || teiidExpression instanceof AggregateFunction) {
            alias = exprDetails.getProjectedName();
        }
        this.selectColumns.add(alias);
        if (exprDetails.partOfGroupBy) {
            BasicDBObject id = this.groupByProjections.get("_id");
            this.project.append(alias, id.get(exprDetails.getProjectedName()));
            exprDetails.addProjectedName(alias);
            this.selectColumnReferences.add(alias);
        } else {
            exprDetails.addProjectedName(alias);
            exprDetails.partOfProject = true;
            if (teiidExpression instanceof ColumnReference) {
                String elementName = this.getColumnName((ColumnReference)obj.getExpression());
                this.selectColumnReferences.add(elementName);
                if (this.command.isDistinct() || this.groupByProjections.get(alias) != null) {
                    this.project.append(alias, (Object)("$_id." + alias));
                    this.group.put((Object)alias, mongoExpression);
                } else {
                    this.project.append(alias, mongoExpression);
                }
            } else {
                this.implicitProject(teiidExpression, mongoExpression, exprDetails, alias);
                this.selectColumnReferences.add(alias);
            }
        }
        this.processingDerivedColumn = false;
    }

    private String getAlias(String alias) {
        if (alias == null) {
            return "_m" + this.aliasCount.getAndIncrement();
        }
        return alias;
    }

    private ColumnDetail buildAlias() {
        String alias = this.getAlias(null);
        ColumnDetail detail = new ColumnDetail();
        detail.addProjectedName(alias);
        return detail;
    }

    public void visit(ColumnReference obj) {
        block4: {
            try {
                if (obj.getMetadataObject() == null) {
                    for (Object expr : this.expressionMap.keySet()) {
                        ColumnDetail columnInfo = this.expressionMap.get(expr);
                        if (!columnInfo.hasProjectedName(this.getColumnName(obj))) continue;
                        this.onGoingExpression.push(expr);
                        break block4;
                    }
                    break block4;
                }
                ColumnDetail columnInfo = this.buildColumnDetail(obj);
                Object mongoExpr = columnInfo.expression;
                this.onGoingExpression.push(mongoExpr);
                this.expressionMap.putIfAbsent(mongoExpr, columnInfo);
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
                return;
            }
        }
    }

    ColumnDetail buildColumnDetail(ColumnReference obj) throws TranslatorException {
        MongoDocument columnDocument = this.getDocument(obj.getTable().getMetadataObject());
        MongoDocument targetDocument = this.mongoDoc.getTargetDocument();
        String columnName = obj.getMetadataObject().getName();
        String documentFieldName = obj.getMetadataObject().getName();
        if (columnDocument.equals(targetDocument)) {
            documentFieldName = columnDocument.getColumnName(columnName);
        } else if (targetDocument.embeds(columnDocument)) {
            MergeDetails ref = targetDocument.getEmbeddedDocumentReferenceKey(columnDocument);
            String parentColumnName = ref.getParentColumnName(columnName);
            if (parentColumnName != null) {
                while (ref.isNested()) {
                    columnDocument = ref.getDocument();
                    ref = targetDocument.getEmbeddedDocumentReferenceKey(columnDocument);
                    parentColumnName = ref.getParentColumnName(parentColumnName);
                }
                documentFieldName = targetDocument.getColumnName(parentColumnName);
            } else {
                documentFieldName = columnDocument.getDocumentName() + "." + columnDocument.getColumnName(columnName);
            }
        } else if (targetDocument.merges(columnDocument)) {
            documentFieldName = columnDocument.getColumnName(columnName);
        }
        ColumnDetail detail = new ColumnDetail();
        detail.addProjectedName(documentFieldName);
        detail.documentFieldName = documentFieldName;
        detail.expression = "$" + documentFieldName;
        return detail;
    }

    private MongoDocument getDocument(Table table) {
        if (this.mongoDoc != null && this.mongoDoc.getTable().getName().equals(table.getName())) {
            return this.mongoDoc;
        }
        for (MongoDocument doc : this.joinedDocuments) {
            if (!doc.getTable().getName().equals(table.getName())) continue;
            return doc;
        }
        return null;
    }

    public void visit(AggregateFunction obj) {
        if (!obj.getParameters().isEmpty()) {
            this.append(obj.getParameters());
        }
        BasicDBObject expr = null;
        if (obj.getName().equals("COUNT")) {
            try {
                Object param = this.onGoingExpression.pop();
                BasicDBList eq = new BasicDBList();
                eq.add(0, param);
                eq.add(1, null);
                BasicDBList values = new BasicDBList();
                values.add(0, (Object)new BasicDBObject("$eq", (Object)eq));
                values.add(1, (Object)0);
                values.add(2, (Object)1);
                expr = new BasicDBObject("$sum", (Object)new BasicDBObject("$cond", (Object)values));
            }
            catch (EmptyStackException e) {
                this.group.put((Object)"_id", null);
                expr = new BasicDBObject("$sum", (Object)new Integer(1));
            }
        } else if (obj.getName().equals("AVG")) {
            expr = new BasicDBObject("$avg", this.onGoingExpression.pop());
        } else if (obj.getName().equals("SUM")) {
            expr = new BasicDBObject("$sum", this.onGoingExpression.pop());
        } else if (obj.getName().equals("MIN")) {
            expr = new BasicDBObject("$min", this.onGoingExpression.pop());
        } else if (obj.getName().equals("MAX")) {
            expr = new BasicDBObject("$max", this.onGoingExpression.pop());
        } else {
            this.exceptions.add(new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18005, new Object[]{obj.getName()})));
        }
        if (expr != null) {
            this.onGoingExpression.push(expr);
        }
    }

    private ColumnDetail addToProject(Object expr, boolean addExprAsProject, ColumnDetail detail, boolean needsProjection, String projectedName) {
        if (detail == null) {
            if (needsProjection) {
                this.projectBeforeMatch = true;
            }
            detail = this.buildAlias();
            this.expressionMap.putIfAbsent(expr, detail);
            projectedName = detail.getProjectedName();
        }
        detail.expression = expr;
        if (needsProjection) {
            if (this.project.get(projectedName) == null && !this.project.values().contains(expr)) {
                this.project.append(projectedName, addExprAsProject ? expr : Integer.valueOf(1));
            }
            detail.partOfProject = true;
        } else {
            detail.partOfProject = false;
        }
        return detail;
    }

    public void visit(Function obj) {
        List parts;
        String functionName = obj.getName();
        if (functionName.indexOf(46) != -1) {
            functionName = functionName.substring(functionName.indexOf(46) + 1);
        }
        if (this.executionFactory.getFunctionModifiers().containsKey(functionName) && (parts = this.executionFactory.getFunctionModifiers().get(functionName).translate(obj)) != null) {
            obj = (Function)parts.get(0);
            if (parts.size() > 1) {
                throw new AssertionError((Object)"Not supported");
            }
        }
        BasicDBObject expr = null;
        if (this.isGeoSpatialFunction(functionName)) {
            try {
                expr = (BasicDBObject)this.handleGeoSpatialFunction(functionName, obj);
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
            }
        } else if (this.isStringFunction(functionName)) {
            expr = this.handleStringFunction(functionName, obj);
        } else {
            List args = obj.getParameters();
            if (args != null) {
                BasicDBList params = new BasicDBList();
                for (int i = 0; i < args.size(); ++i) {
                    this.append((LanguageObject)args.get(i));
                    Object param = this.onGoingExpression.pop();
                    params.add(param);
                }
                expr = new BasicDBObject(obj.getName(), (Object)params);
            }
        }
        if (expr != null) {
            if (obj.getParameters().size() == 1 && Date.class.isAssignableFrom(((Expression)obj.getParameters().get(0)).getType()) && this.isDateTimeFunction(functionName)) {
                BasicDBList newParams = new BasicDBList();
                newParams.addAll((Collection)((BasicDBList)expr.values().iterator().next()));
                newParams.add((Object)false);
                BasicDBObject nullCheck = new BasicDBObject("$ifNull", (Object)newParams);
                newParams = new BasicDBList();
                newParams.add((Object)nullCheck);
                newParams.add((Object)expr);
                newParams.add(null);
                expr = new BasicDBObject("$cond", (Object)newParams);
            }
            this.onGoingExpression.push(expr);
        }
    }

    private boolean isStringFunction(String functionName) {
        return functionName.equalsIgnoreCase("UCASE") || functionName.equalsIgnoreCase("LCASE") || functionName.equalsIgnoreCase("SUBSTRING");
    }

    private boolean isDateTimeFunction(String functionName) {
        return functionName.equalsIgnoreCase("dayofyear") || functionName.equalsIgnoreCase("dayofmonth") || functionName.equalsIgnoreCase("dayofweek") || functionName.equalsIgnoreCase("year") || functionName.equalsIgnoreCase("month") || functionName.equalsIgnoreCase("week") || functionName.equalsIgnoreCase("hour") || functionName.equalsIgnoreCase("minute") || functionName.equalsIgnoreCase("second");
    }

    private BasicDBObject handleStringFunction(String functionName, Function function) {
        List args = function.getParameters();
        BasicDBObject func = null;
        this.append((LanguageObject)args.get(0));
        Object column = this.onGoingExpression.pop();
        if (args.size() == 1) {
            func = new BasicDBObject(function.getName(), column);
        } else {
            BasicDBList params = new BasicDBList();
            params.add(column);
            for (int i = 1; i < args.size(); ++i) {
                this.append((LanguageObject)args.get(i));
                Object param = this.onGoingExpression.pop();
                params.add(param);
            }
            func = new BasicDBObject(function.getName(), (Object)params);
        }
        BasicDBObject ne = this.buildNE(column.toString(), null);
        return this.buildCondition(ne, func, null);
    }

    private BasicDBObject buildCondition(Object expr, Object trueExpr, Object falseExpr) {
        BasicDBList values = new BasicDBList();
        values.add(0, expr);
        values.add(1, trueExpr);
        values.add(2, falseExpr);
        return new BasicDBObject("$cond", (Object)values);
    }

    private BasicDBObject buildNE(Object leftExpr, Object rightExpr) {
        BasicDBList values = new BasicDBList();
        values.add(0, leftExpr);
        values.add(1, rightExpr);
        return new BasicDBObject("$ne", (Object)values);
    }

    private boolean isGeoSpatialFunction(String name) {
        for (String func : MongoDBExecutionFactory.GEOSPATIAL_FUNCTIONS) {
            if (!name.equalsIgnoreCase(func)) continue;
            return true;
        }
        return false;
    }

    public void visit(NamedTable obj) {
        try {
            this.mongoDoc = new MongoDocument(obj.getMetadataObject(), this.metadata);
            this.configureUnwind(this.mongoDoc);
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(Join obj) {
        try {
            if (obj.getLeftItem() instanceof Join) {
                this.append((LanguageObject)obj.getLeftItem());
                Table right = ((NamedTable)obj.getRightItem()).getMetadataObject();
                this.processJoin(this.mongoDoc, new MongoDocument(right, this.metadata), obj.getCondition(), obj.getJoinType());
            } else if (obj.getRightItem() instanceof Join) {
                Table left = ((NamedTable)obj.getLeftItem()).getMetadataObject();
                this.append((LanguageObject)obj.getRightItem());
                this.processJoin(this.mongoDoc, new MongoDocument(left, this.metadata), obj.getCondition(), obj.getJoinType());
            } else {
                Table left = ((NamedTable)obj.getLeftItem()).getMetadataObject();
                Table right = ((NamedTable)obj.getRightItem()).getMetadataObject();
                this.processJoin(new MongoDocument(left, this.metadata), new MongoDocument(right, this.metadata), obj.getCondition(), obj.getJoinType());
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    private void configureUnwind(MongoDocument document) throws TranslatorException {
        if (document.isMerged()) {
            MongoDocument mergeDocument = document.getMergeDocument();
            if (mergeDocument.isMerged()) {
                this.configureUnwind(mergeDocument);
            }
            if (document.getMergeAssociation() == MergeDetails.Association.MANY) {
                this.mergePlanner.addNode(new UnwindNode(document));
            } else {
                this.mergePlanner.addNode(new ExistsNode(document));
            }
        }
    }

    private void processJoin(MongoDocument left, MongoDocument right, Condition cond, Join.JoinType joinType) throws TranslatorException {
        JoinCriteriaVisitor jcv = new JoinCriteriaVisitor(joinType, left, right, this.mergePlanner);
        jcv.process(cond);
        if (left.contains(right)) {
            this.mongoDoc = left;
            this.joinedDocuments.add(right);
            this.configureUnwind(right);
        } else if (right.contains(left)) {
            this.mongoDoc = right;
            this.joinedDocuments.add(left);
            this.configureUnwind(left);
        } else {
            if (this.mongoDoc != null) {
                for (MongoDocument child : this.joinedDocuments) {
                    if (!child.contains(right)) continue;
                    this.joinedDocuments.add(right);
                    this.configureUnwind(right);
                    return;
                }
            }
            throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18012, new Object[]{left.getTable().getName(), right.getTable().getName()}));
        }
        if (cond != null) {
            this.pendingConditions.add(cond);
        }
    }

    public void visit(Select obj) {
        this.command = obj;
        if (obj.getFrom() != null && !obj.getFrom().isEmpty()) {
            this.append(obj.getFrom());
        }
        if (!this.exceptions.isEmpty()) {
            return;
        }
        this.append((LanguageObject)obj.getWhere());
        if (!this.onGoingExpression.isEmpty()) {
            if (this.match != null) {
                DBObject expr = (DBObject)this.onGoingExpression.pop();
                ArrayList exprs = (ArrayList)expr.get("$and");
                if (exprs != null) {
                    exprs.add(0, this.match);
                    this.match = expr;
                } else {
                    this.match = QueryBuilder.start().and(new DBObject[]{this.match, expr}).get();
                }
            } else {
                this.match = (DBObject)this.onGoingExpression.pop();
            }
        }
        this.append((LanguageObject)obj.getGroupBy());
        this.append((LanguageObject)obj.getHaving());
        if (!this.onGoingExpression.isEmpty()) {
            this.having = (DBObject)this.onGoingExpression.pop();
        }
        this.append(obj.getDerivedColumns());
        if (obj.getGroupBy() == null && obj.isDistinct() && !this.group.containsField("_id")) {
            BasicDBObject id = new BasicDBObject((Map)this.group);
            this.group.clear();
            this.group.put((Object)"_id", (Object)id);
        }
        if (!this.group.isEmpty()) {
            if (this.group.get("_id") == null) {
                this.group.put((Object)"_id", null);
            }
        } else {
            this.group = null;
        }
        this.append((LanguageObject)obj.getOrderBy());
        this.append((LanguageObject)obj.getLimit());
    }

    private ColumnDetail implicitProject(Expression teiidExpr, Object mongoExpr, ColumnDetail columnDetails, String projectedName) {
        if (teiidExpr instanceof ColumnReference) {
            return this.expressionMap.get(mongoExpr);
        }
        if (teiidExpr instanceof AggregateFunction) {
            boolean saved = this.projectBeforeMatch;
            ColumnDetail alias = this.addToProject(mongoExpr, false, columnDetails, true, projectedName);
            this.projectBeforeMatch = saved;
            if (projectedName == null) {
                projectedName = alias.getProjectedName();
            }
            if (!this.group.values().contains(mongoExpr)) {
                this.group.put((Object)projectedName, mongoExpr);
            }
            return alias;
        }
        if (teiidExpr instanceof Function) {
            Boolean avoidProjection = Boolean.valueOf(((Function)teiidExpr).getMetadataObject().getProperty("AVOID_PROJECTION", false));
            return this.addToProject(mongoExpr, true, columnDetails, this.processingDerivedColumn || avoidProjection == false, projectedName);
        }
        if (teiidExpr instanceof Condition) {
            BasicDBList values = new BasicDBList();
            values.add(0, mongoExpr);
            values.add(1, (Object)true);
            values.add(2, (Object)false);
            return this.addToProject(new BasicDBObject("$cond", (Object)values), true, columnDetails, true, projectedName);
        }
        if (teiidExpr instanceof Literal) {
            if (this.executionFactory.getVersion().compareTo(MongoDBExecutionFactory.TWO_6) >= 0) {
                return this.addToProject(new BasicDBObject("$literal", mongoExpr), true, columnDetails, true, projectedName);
            }
            this.exceptions.add(new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18026, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18026, new Object[0])));
        }
        return null;
    }

    public void visit(Comparison obj) {
        if (this.processingDerivedColumn) {
            this.visitDerivedExpression(obj);
            return;
        }
        ColumnDetail leftExprDetails = this.getExpressionAlias(obj.getLeftExpression());
        this.append((LanguageObject)obj.getRightExpression());
        Object rightExpr = this.onGoingExpression.pop();
        if (this.expressionMap.get(rightExpr) != null) {
            rightExpr = this.expressionMap.get(rightExpr).getProjectedName();
        }
        QueryBuilder query = leftExprDetails.getQueryBuilder();
        rightExpr = this.checkAndConvertToObjectId(obj.getLeftExpression(), obj.getRightExpression(), rightExpr);
        this.buildComparisionQuery(obj, rightExpr, query);
        if (leftExprDetails.partOfProject || obj.getLeftExpression() instanceof ColumnReference) {
            this.onGoingExpression.push(query.get());
        } else {
            this.onGoingExpression.push(this.buildFunctionQuery(obj, (BasicDBObject)leftExprDetails.expression, rightExpr));
        }
        if (obj.getLeftExpression() instanceof ColumnReference) {
            ColumnReference column = (ColumnReference)obj.getLeftExpression();
            this.mongoDoc.updateReferenceColumnValue(column.getTable().getName(), column.getName(), rightExpr);
        }
    }

    private Object checkAndConvertToObjectId(Expression left, Expression right, Object rightValue) {
        String navtiveType;
        if (left instanceof ColumnReference && right instanceof Literal && (navtiveType = ((ColumnReference)left).getMetadataObject().getNativeType()) != null && navtiveType.equals(ObjectId.class.getName())) {
            return new ObjectId((String)rightValue);
        }
        return rightValue;
    }

    protected BasicDBObject buildFunctionQuery(Comparison obj, BasicDBObject leftExpr, Object rightExpr) {
        switch (obj.getOperator()) {
            case EQ: {
                if (!(rightExpr instanceof Boolean) || !((Boolean)rightExpr).booleanValue()) break;
                return leftExpr;
            }
        }
        this.exceptions.add(new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18030, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18030, new Object[0])));
        return null;
    }

    protected void buildComparisionQuery(Comparison obj, Object rightExpr, QueryBuilder query) {
        switch (obj.getOperator()) {
            case EQ: {
                query.is(rightExpr);
                break;
            }
            case NE: {
                query.notEquals(rightExpr);
                break;
            }
            case LT: {
                query.lessThan(rightExpr);
                break;
            }
            case LE: {
                query.lessThanEquals(rightExpr);
                break;
            }
            case GT: {
                query.greaterThan(rightExpr);
                break;
            }
            case GE: {
                query.greaterThanEquals(rightExpr);
            }
        }
    }

    private void visitDerivedExpression(Comparison obj) {
        this.append((LanguageObject)obj.getLeftExpression());
        Object leftExpr = this.onGoingExpression.pop();
        this.append((LanguageObject)obj.getRightExpression());
        Object rightExpr = this.onGoingExpression.pop();
        BasicDBList values = new BasicDBList();
        values.add(0, leftExpr);
        values.add(1, rightExpr);
        switch (obj.getOperator()) {
            case EQ: {
                this.onGoingExpression.push(new BasicDBObject("$eq", (Object)values));
                break;
            }
            case NE: {
                this.onGoingExpression.push(new BasicDBObject("$ne", (Object)values));
                break;
            }
            case LT: {
                this.onGoingExpression.push(new BasicDBObject("$lt", (Object)values));
                break;
            }
            case LE: {
                this.onGoingExpression.push(new BasicDBObject("$lte", (Object)values));
                break;
            }
            case GT: {
                this.onGoingExpression.push(new BasicDBObject("$gt", (Object)values));
                break;
            }
            case GE: {
                this.onGoingExpression.push(new BasicDBObject("$gte", (Object)values));
            }
        }
    }

    public void visit(AndOr obj) {
        this.append((LanguageObject)obj.getLeftCondition());
        this.append((LanguageObject)obj.getRightCondition());
        DBObject right = (DBObject)this.onGoingExpression.pop();
        DBObject left = (DBObject)this.onGoingExpression.pop();
        switch (obj.getOperator()) {
            case AND: {
                this.onGoingExpression.push(QueryBuilder.start().and(new DBObject[]{left, right}).get());
                break;
            }
            case OR: {
                this.onGoingExpression.push(QueryBuilder.start().or(new DBObject[]{left, right}).get());
            }
        }
    }

    public void visit(Array array) {
        this.append(array.getExpressions());
        BasicDBList values = new BasicDBList();
        for (int i = 0; i < array.getExpressions().size(); ++i) {
            values.add(0, this.onGoingExpression.pop());
        }
        this.onGoingExpression.push(values);
    }

    public void visit(Literal obj) {
        try {
            this.onGoingExpression.push(this.executionFactory.convertToMongoType(obj.getValue(), null, null));
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(In obj) {
        this.append((LanguageObject)obj.getLeftExpression());
        Object expr = this.onGoingExpression.pop();
        ColumnDetail detail = this.expressionMap.get(expr);
        QueryBuilder query = QueryBuilder.start();
        if (detail == null) {
            this.exceptions.add(new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18031, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18031, new Object[0])));
        } else {
            query = detail.getQueryBuilder();
            this.onGoingExpression.push(this.buildInQuery(obj, query).get());
        }
    }

    protected QueryBuilder buildInQuery(In obj, QueryBuilder query) {
        this.append(obj.getRightExpressions());
        BasicDBList values = new BasicDBList();
        for (int i = 0; i < obj.getRightExpressions().size(); ++i) {
            Object rightExpr = this.onGoingExpression.pop();
            rightExpr = this.checkAndConvertToObjectId(obj.getLeftExpression(), (Expression)obj.getRightExpressions().get(i), rightExpr);
            values.add(0, rightExpr);
        }
        if (obj.isNegated()) {
            query.notIn((Object)values);
        } else {
            query.in((Object)values);
        }
        return query;
    }

    ColumnDetail getExpressionAlias(Expression obj) {
        this.append((LanguageObject)obj);
        Object expr = this.onGoingExpression.pop();
        ColumnDetail detail = this.expressionMap.get(expr);
        detail = this.implicitProject(obj, expr, detail, detail != null ? detail.getProjectedName() : null);
        return detail;
    }

    public void visit(IsNull obj) {
        this.append((LanguageObject)obj.getExpression());
        Object expr = this.onGoingExpression.pop();
        ColumnDetail detail = this.expressionMap.get(expr);
        QueryBuilder query = QueryBuilder.start();
        if (detail == null) {
            this.exceptions.add(new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18032, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18032, new Object[0])));
        } else {
            query = detail.getQueryBuilder();
            this.onGoingExpression.push(this.buildIsNullQuery(obj, query).get());
        }
    }

    protected QueryBuilder buildIsNullQuery(IsNull obj, QueryBuilder query) {
        if (obj.isNegated()) {
            query.notEquals(null);
        } else {
            query.is(null);
        }
        return query;
    }

    public void visit(Like obj) {
        this.append((LanguageObject)obj.getLeftExpression());
        Object expr = this.onGoingExpression.pop();
        ColumnDetail detail = this.expressionMap.get(expr);
        QueryBuilder query = QueryBuilder.start();
        if (detail == null) {
            this.exceptions.add(new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18033, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18033, new Object[0])));
        } else {
            query = detail.getQueryBuilder();
            this.buildLikeQuery(obj, query);
            this.onGoingExpression.push(query.get());
        }
    }

    protected QueryBuilder buildLikeQuery(Like obj, QueryBuilder query) {
        if (obj.isNegated()) {
            query.not();
        }
        this.append((LanguageObject)obj.getRightExpression());
        StringBuilder value = new StringBuilder((String)this.onGoingExpression.pop());
        int idx = -1;
        while (true) {
            if ((idx = value.indexOf("%", idx + 1)) != -1 && idx == 0 || idx != -1 && idx == value.length() - 1) {
                continue;
            }
            if (idx == -1) break;
            value.replace(idx, idx + 1, ".*");
        }
        if (value.charAt(0) != '%') {
            value.insert(0, '^');
        }
        if (value.charAt((idx = value.length()) - 1) != '%') {
            value.insert(idx, '$');
        }
        String regex = value.toString().replaceAll("%", "");
        query.is((Object)Pattern.compile(regex));
        return query;
    }

    public void visit(Limit obj) {
        if (obj.getRowLimit() != Integer.MAX_VALUE) {
            this.limit = new Integer(obj.getRowLimit());
        }
        this.skip = new Integer(obj.getRowOffset());
    }

    public void visit(OrderBy obj) {
        this.append(obj.getSortSpecifications());
    }

    public void visit(SortSpecification obj) {
        this.append((LanguageObject)obj.getExpression());
        Object expr = this.onGoingExpression.pop();
        ColumnDetail alias = this.expressionMap.get(expr);
        if (this.sort == null) {
            this.sort = new BasicDBObject(alias.getProjectedName(), (Object)(obj.getOrdering() == SortSpecification.Ordering.ASC ? 1 : -1));
        } else {
            this.sort.put(alias.getProjectedName(), (Object)(obj.getOrdering() == SortSpecification.Ordering.ASC ? 1 : -1));
        }
    }

    public void visit(GroupBy obj) {
        if (obj.getElements().size() == 1) {
            this.append((LanguageObject)obj.getElements().get(0));
            Object mongoExpr = this.onGoingExpression.pop();
            ColumnDetail exprDetails = this.expressionMap.get(mongoExpr);
            String projectedName = "_c" + this.columnCount.getAndIncrement();
            exprDetails.addProjectedName(projectedName);
            this.group.put((Object)"_id", (Object)new BasicDBObject(projectedName, mongoExpr));
            this.groupByProjections.put("_id", new BasicDBObject(projectedName, (Object)("$_id." + projectedName)));
            exprDetails.partOfGroupBy = true;
        } else {
            BasicDBObject fields = new BasicDBObject();
            BasicDBObject exprs = new BasicDBObject();
            for (Expression expr : obj.getElements()) {
                this.append((LanguageObject)expr);
                Object mongoExpr = this.onGoingExpression.pop();
                ColumnDetail exprDetails = this.expressionMap.get(mongoExpr);
                String projectedName = "_c" + this.columnCount.getAndIncrement();
                exprDetails.addProjectedName(projectedName);
                exprs.put((Object)projectedName, mongoExpr);
                fields.put((Object)projectedName, (Object)("$_id." + projectedName));
                exprDetails.partOfGroupBy = true;
            }
            this.group.put((Object)"_id", (Object)exprs);
            this.groupByProjections.put("_id", fields);
        }
    }

    static boolean isPartOfPrimaryKey(Table table, String columnName) {
        KeyRecord pk = table.getPrimaryKey();
        if (pk != null) {
            for (Column column : pk.getColumns()) {
                if (!SQLStringVisitor.getRecordName((AbstractMetadataRecord)column).equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasCompositePrimaryKey(Table table) {
        KeyRecord pk = table.getPrimaryKey();
        return pk.getColumns().size() > 1;
    }

    static boolean isPartOfForeignKey(Table table, String columnName) {
        for (ForeignKey fk : table.getForeignKeys()) {
            for (Column column : fk.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    static String getForeignKeyRefTable(Table table, String columnName) {
        for (ForeignKey fk : table.getForeignKeys()) {
            for (Column column : fk.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                return fk.getReferenceTableName();
            }
        }
        return null;
    }

    static List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (Column c : columns) {
            names.add(c.getName());
        }
        return names;
    }

    private DBObject handleGeoSpatialFunction(String functionName, Function function) throws TranslatorException {
        if (functionName.equalsIgnoreCase("geoNear") || functionName.equalsIgnoreCase("geoNearSphere")) {
            return this.buildGeoNearFunction(function);
        }
        return this.buildGeoFunction(function);
    }

    private DBObject buildGeoNearFunction(Function function) throws TranslatorException {
        List args = function.getParameters();
        int paramIndex = 0;
        ColumnDetail column = this.getExpressionAlias((Expression)args.get(paramIndex++));
        BasicDBObjectBuilder builder = BasicDBObjectBuilder.start();
        builder.push(column.documentFieldName);
        builder.push(function.getName());
        this.append((LanguageObject)args.get(paramIndex++));
        Object object = this.onGoingExpression.pop();
        if (object instanceof GeometryType) {
            this.convertGeometryToJson(builder, (GeometryType)object);
        } else {
            builder.push("$geometry");
            builder.add("type", (Object)SpatialType.Point.name());
            BasicDBList coordinates = new BasicDBList();
            coordinates.add(object);
            builder.add("coordinates", (Object)coordinates);
        }
        this.append((LanguageObject)args.get(paramIndex++));
        BasicDBObjectBuilder b = builder.pop();
        b.add("$maxDistance", this.onGoingExpression.pop());
        if (this.executionFactory.getVersion().compareTo(MongoDBExecutionFactory.TWO_6) >= 0) {
            this.append((LanguageObject)args.get(paramIndex++));
            b.add("$minDistance", this.onGoingExpression.pop());
        }
        return builder.get();
    }

    private DBObject buildGeoFunction(Function function) throws TranslatorException {
        List args = function.getParameters();
        int paramIndex = 0;
        ColumnDetail column = this.getExpressionAlias((Expression)args.get(paramIndex++));
        BasicDBObjectBuilder builder = BasicDBObjectBuilder.start();
        builder.push(column.documentFieldName);
        builder.push(function.getName());
        this.append((LanguageObject)args.get(paramIndex++));
        Object object = this.onGoingExpression.pop();
        if (object instanceof GeometryType) {
            this.convertGeometryToJson(builder, (GeometryType)object);
        } else {
            SpatialType type = SpatialType.valueOf((String)object);
            this.append((LanguageObject)args.get(paramIndex++));
            builder.push("$geometry");
            builder.add("type", (Object)type.name());
            BasicDBList coordinates = new BasicDBList();
            coordinates.add(this.onGoingExpression.pop());
            builder.add("coordinates", (Object)coordinates);
        }
        return builder.get();
    }

    private void convertGeometryToJson(BasicDBObjectBuilder builder, GeometryType object) throws TranslatorException {
        try {
            ClobType clob = GeometryUtils.geometryToGeoJson((GeometryType)object);
            ClobToStringTransform clob2str = new ClobToStringTransform();
            String geometry = (String)clob2str.transform((Object)clob, String.class);
            builder.add("$geometry", (Object)geometry);
        }
        catch (FunctionExecutionException | TransformationException e) {
            throw new TranslatorException(e);
        }
    }

    static enum SpatialType {
        Point,
        LineString,
        Polygon,
        MultiPoint,
        MultiLineString;

    }
}

