/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Command;
import org.teiid.language.Delete;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Update;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.MergeDetails;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;
import org.teiid.translator.mongodb.MongoDBUpdateVisitor;
import org.teiid.translator.mongodb.MongoDocument;

public class TestMongoDBUpdateVisitor {
    private MongoDBExecutionFactory translator;
    private TranslationUtility utility;
    private LinkedHashMap<String, DBObject> docs;

    @Before
    public void setUp() throws Exception {
        this.translator = new MongoDBExecutionFactory();
        this.translator.start();
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"northwind.ddl")), (String)"sakila", (String)"northwind");
        this.utility = new TranslationUtility((QueryMetadataInterface)metadata);
    }

    private MergeDetails buildKey(String name, String parentTable, String embeddedTable, String id) {
        MergeDetails key = new MergeDetails(null);
        key.setName(name);
        key.setParentTable(parentTable);
        key.setEmbeddedTable(embeddedTable);
        key.setId("id", (Object)id);
        return key;
    }

    private void helpExecute(String query, String collection, String expected, String match, MergeDetails pushKey, List<MergeDetails> pullKeys) throws Exception {
        MongoDocument doc;
        Command cmd = this.utility.parseCommand(query);
        MongoDBUpdateVisitor visitor = new MongoDBUpdateVisitor(this.translator, this.utility.createRuntimeMetadata(), (DB)Mockito.mock(DB.class));
        visitor.visitNode((LanguageObject)cmd);
        if (!visitor.exceptions.isEmpty()) {
            throw (TranslatorException)visitor.exceptions.get(0);
        }
        Assert.assertEquals((Object)collection, (Object)visitor.mongoDoc.getTargetTable().getName());
        if (cmd instanceof Insert) {
            Assert.assertEquals((String)"wrong insert", (Object)expected, (Object)visitor.getInsert(this.docs).toString());
        } else if (cmd instanceof Update) {
            Assert.assertEquals((String)"wrong update", (Object)expected, (Object)visitor.getUpdate(this.docs).toString());
        } else if (cmd instanceof Delete) {
            // empty if block
        }
        if (visitor.match != null) {
            Assert.assertEquals((String)"match wrong", (Object)match, (Object)visitor.match.toString());
        }
        if ((doc = visitor.mongoDoc).isMerged()) {
            Assert.assertEquals((String)"Wrong PushKey", (Object)pushKey.toString(), (Object)visitor.mongoDoc.getMergeKey().toString());
        }
        if (!visitor.mongoDoc.getEmbeddedReferences().isEmpty()) {
            Assert.assertEquals((String)"Wrong PullKeys", (Object)visitor.mongoDoc.getEmbeddedReferences().toString(), (Object)pullKeys.toString());
        }
        this.docs = null;
    }

    @Test
    public void testInsert() throws Exception {
        this.helpExecute("insert into users (id, user_id, age, status) values (1, 'johndoe', 34, 'A')", "users", "{ \"_id\" : 1, \"user_id\" : \"johndoe\", \"age\" : 34, \"status\" : \"A\" }", null, null, null);
    }

    @Test
    public void testInsertWithFKWithEmbeddable() throws Exception {
        this.docs = new LinkedHashMap();
        this.docs.put("Categories", (DBObject)new BasicDBObject("categoryK", (Object)"categoryV"));
        this.docs.put("Suppliers", (DBObject)new BasicDBObject("SuppliersK", (Object)"SuppliersV"));
        ArrayList<MergeDetails> pull = new ArrayList<MergeDetails>();
        pull.add(this.buildKey("Categories", "Products", "Categories", "24"));
        pull.add(this.buildKey("Suppliers", "Products", "Suppliers", "34"));
        this.helpExecute("insert into Products (ProductID, ProductName, SupplierID, CategoryID, QuantityPerUnit, UnitPrice, UnitsInStock, UnitsOnOrder, ReorderLevel, Discontinued) values (1, 'hammer', 34, 24, 12, 12.50, 3, 4, 2, 1)", "Products", "{ \"_id\" : 1, \"ProductName\" : \"hammer\", \"SupplierID\" : 34, \"CategoryID\" : 24, \"QuantityPerUnit\" : \"12\", \"UnitPrice\" : 12.5, \"UnitsInStock\" : 3, \"UnitsOnOrder\" : 4, \"ReorderLevel\" : 2, \"Discontinued\" : 1, \"Categories\" : { \"categoryK\" : \"categoryV\" }, \"Suppliers\" : { \"SuppliersK\" : \"SuppliersV\" } }", null, null, pull);
    }

    @Test
    public void testMergeInsert() throws Exception {
        this.helpExecute("insert into OrderDetails (odID, ProductID, UnitPrice, Quantity, Discount) values (2, 3, 1.50, 12, 1.0)", "Orders", "{ \"_id\" : { \"odID\" : 2, \"ProductID\" : 3 }, \"UnitPrice\" : 1.5, \"Quantity\" : 12, \"Discount\" : 1.0 }", null, this.buildKey("FK1", "Orders", "OrderDetails", "2"), null);
    }

    @Test
    public void testUpdate() throws Exception {
        this.helpExecute("update users set age = 48", "users", "{ \"age\" : 48 }", null, null, null);
    }

    @Test
    public void testUpdateFK() throws Exception {
        this.helpExecute("update users set user_id = 'billybob'", "users", "{ \"user_id\" : \"billybob\" }", null, null, null);
    }

    @Test
    public void testUpdateWithWhere() throws Exception {
        this.helpExecute("update users set user_id = 'billybob' WHERE age > 50", "users", "{ \"user_id\" : \"billybob\" }", "{ \"age\" : { \"$gt\" : 50 } }", null, null);
    }

    @Test
    public void testDeleteWithWhere() throws Exception {
        this.helpExecute("delete from users WHERE age > 50", "users", null, "{ \"age\" : { \"$gt\" : 50 } }", null, null);
    }

    @Test
    public void testUpdateEmbedddedInSimpleUpdate() throws Exception {
        this.helpExecute("UPDATE OrderDetails SET UnitPrice = 14.50", "Orders", "{ \"OrderDetails.$.UnitPrice\" : 14.5 }", null, this.buildKey("FK1", "Orders", "OrderDetails", null), null);
    }

    @Test(expected=TranslatorException.class)
    public void testUpdateMergeReferenceUpdate() throws Exception {
        this.helpExecute("UPDATE OrderDetails SET ProductID = 4", "Orders", "{ \"ProductID\" : 4 }", null, this.buildKey("FK1", "Orders", "OrderDetails", null), null);
    }

    @Test(expected=TranslatorException.class)
    public void testUpdateMergeParentUpdate() throws Exception {
        this.docs = new LinkedHashMap();
        this.docs.put("Products", (DBObject)new BasicDBObject("key", (Object)"value"));
        this.helpExecute("UPDATE OrderDetails SET odID = 4", "Orders", "{ \"Products.ProductID\" : { \"$ref\" : \"Products\" , \"$id\" : 4 } , \"Products\" : { \"key\" : \"value\" } }", null, this.buildKey("FK1", "Orders", "OrderDetails", null), null);
    }

    @Test
    public void testUpdateParentTableWithEmbeddable() throws Exception {
        this.docs = new LinkedHashMap();
        this.docs.put("Categories", (DBObject)new BasicDBObject("categoryK", (Object)"categoryV"));
        ArrayList<MergeDetails> pull = new ArrayList<MergeDetails>();
        pull.add(this.buildKey("Categories", "Products", "Categories", "4"));
        pull.add(this.buildKey("Suppliers", "Products", "Suppliers", null));
        this.helpExecute("UPDATE Products SET CategoryID = 4", "Products", "{ \"CategoryID\" : 4, \"Categories\" : { \"categoryK\" : \"categoryV\" } }", null, null, pull);
    }

    @Test
    public void testUpdateEmbeddableTable() throws Exception {
        this.docs = new LinkedHashMap();
        this.helpExecute("UPDATE Categories SET Description = 'change' WHERE CategoryID = 1", "Categories", "{ \"Description\" : \"change\" }", "{ \"_id\" : 1 }", null, null);
    }

    @Test
    public void testCompositeKeyInsert() throws Exception {
        this.helpExecute("insert into G1 (e1, e2, e3) values (1,2,3)", "G1", "{ \"_id\" : { \"e1\" : 1, \"e2\" : 2 }, \"e3\" : 3 }", null, null, null);
    }

    @Test
    @Ignore
    public void testCompositeKeyUpdate() throws Exception {
        this.helpExecute("update G1 set e2 = 48", "G1", "{ \"_id.e2\" : 48 }", null, null, null);
    }

    @Test
    public void testCompositeKeyDeleteWithWhere() throws Exception {
        this.helpExecute("delete from G1 WHERE e1 > 50", "G1", null, "{ \"_id.e1\" : { \"$gt\" : 50 } }", null, null);
    }

    @Test
    public void testCompositeFKKeyInsert() throws Exception {
        this.helpExecute("insert into G2 (e1, e2, e3) values (1,2,3)", "G2", "{ \"e1\" : 1, \"e2\" : 2, \"e3\" : 3 }", null, null, null);
    }

    @Test
    public void testCompositeFKUpdate() throws Exception {
        this.helpExecute("update G2 set e1=47, e2 = 48", "G2", "{ \"e1\" : 47, \"e2\" : 48 }", null, null, null);
    }

    @Test
    public void testCompositeFKUpdateNonKey() throws Exception {
        this.helpExecute("update G2 set e3=0 where e2 = 48", "G2", "{ \"e3\" : 0 }", "{ \"e2\" : 48 }", null, null);
    }
}

