/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.AggregationOptions;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.DBRef;
import com.mongodb.MongoException;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.GeometryType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.resource.api.ConnectionFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.mongodb.MongoDBDirectQueryExecution;
import org.teiid.translator.mongodb.MongoDBMetadataProcessor;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDBQueryExecution;
import org.teiid.translator.mongodb.MongoDBUpdateExecution;
import org.teiid.util.Version;

@Translator(name="mongodb", description="MongoDB Translator, reads and writes the data to MongoDB")
public class MongoDBExecutionFactory
extends ExecutionFactory<ConnectionFactory, MongoDBConnection> {
    private static final String MONGO = "mongo";
    public static final Version TWO_4 = Version.getVersion((String)"2.4");
    public static final Version TWO_6 = Version.getVersion((String)"2.6");
    public static final Version THREE_0 = Version.getVersion((String)"3.0");
    public static final Version FOUR_0 = Version.getVersion((String)"4.0");
    public static final String FUNC_GEO_WITHIN = "geoWithin";
    public static final String FUNC_GEO_INTERSECTS = "geoIntersects";
    public static final String FUNC_GEO_NEAR = "geoNear";
    public static final String FUNC_GEO_NEAR_SPHERE = "geoNearSphere";
    public static final String FUNC_GEO_POLYGON_WITHIN = "geoPolygonWithin";
    public static final String FUNC_GEO_POLYGON_INTERSECTS = "geoPolygonIntersects";
    public static final String[] GEOSPATIAL_FUNCTIONS = new String[]{"geoWithin", "geoIntersects", "geoNear", "geoNearSphere", "geoPolygonWithin", "geoPolygonIntersects"};
    public static final String AVOID_PROJECTION = "AVOID_PROJECTION";
    protected Map<String, FunctionModifier> functionModifiers = new TreeMap<String, FunctionModifier>(String.CASE_INSENSITIVE_ORDER);
    private Version version = TWO_6;
    private boolean useDisk = true;
    private boolean supportsAggregatesCount = true;

    public MongoDBExecutionFactory() {
        this.setSupportsOrderBy(true);
        this.setSupportsSelectDistinct(true);
        this.setSupportsDirectQueryProcedure(false);
        this.setSourceRequiredForMetadata(false);
        this.setSupportsInnerJoins(true);
        this.setSupportsOuterJoins(true);
        this.setSupportedJoinCriteria(ExecutionFactory.SupportedJoinCriteria.KEY);
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
    }

    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("+", (FunctionModifier)new AliasModifier("$add"));
        this.registerFunctionModifier("-", (FunctionModifier)new AliasModifier("$subtract"));
        this.registerFunctionModifier("*", (FunctionModifier)new AliasModifier("$multiply"));
        this.registerFunctionModifier("/", (FunctionModifier)new AliasModifier("$divide"));
        this.registerFunctionModifier("concat", (FunctionModifier)new AliasModifier("$concat"));
        this.registerFunctionModifier("substring", (FunctionModifier)new AliasModifier("$substr"));
        this.registerFunctionModifier("substring", new FunctionModifier(){

            public List<?> translate(Function function) {
                function.setName("$substr");
                ArrayList params = new ArrayList();
                params.add(function.getParameters().get(0));
                params.add(LanguageFactory.INSTANCE.createFunction("-", new Expression[]{(Expression)function.getParameters().get(1), LanguageFactory.INSTANCE.createLiteral((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER)}, TypeFacility.RUNTIME_TYPES.INTEGER));
                if (function.getParameters().size() == 2) {
                    function.getParameters().add(LanguageFactory.INSTANCE.createLiteral((Object)DataTypeManager.MAX_STRING_LENGTH, TypeFacility.RUNTIME_TYPES.INTEGER));
                }
                params.add(function.getParameters().get(2));
                function.getParameters().clear();
                function.getParameters().addAll(params);
                return null;
            }
        });
        this.registerFunctionModifier("lcase", (FunctionModifier)new AliasModifier("$toLower"));
        this.registerFunctionModifier("ucase", (FunctionModifier)new AliasModifier("$toUpper"));
        this.registerFunctionModifier("dayofyear", (FunctionModifier)new AliasModifier("$dayOfYear"));
        this.registerFunctionModifier("dayofmonth", (FunctionModifier)new AliasModifier("$dayOfMonth"));
        this.registerFunctionModifier("dayofweek", (FunctionModifier)new AliasModifier("$dayOfWeek"));
        this.registerFunctionModifier("year", (FunctionModifier)new AliasModifier("$year"));
        this.registerFunctionModifier("month", (FunctionModifier)new AliasModifier("$month"));
        this.registerFunctionModifier("week", (FunctionModifier)new AliasModifier("$week"));
        this.registerFunctionModifier("hour", (FunctionModifier)new AliasModifier("$hour"));
        this.registerFunctionModifier("minute", (FunctionModifier)new AliasModifier("$minute"));
        this.registerFunctionModifier("second", (FunctionModifier)new AliasModifier("$second"));
        this.registerFunctionModifier("ifnull", (FunctionModifier)new AliasModifier("$ifNull"));
        FunctionMethod method = null;
        method = this.addPushDownFunction(MONGO, FUNC_GEO_INTERSECTS, "boolean", new String[]{"string", "string", "double[][]"});
        method.setProperty(AVOID_PROJECTION, "true");
        method = this.addPushDownFunction(MONGO, FUNC_GEO_INTERSECTS, "boolean", new String[]{"geometry"});
        method.setProperty(AVOID_PROJECTION, "true");
        method = this.addPushDownFunction(MONGO, FUNC_GEO_WITHIN, "boolean", new String[]{"string", "string", "double[][]"});
        method.setProperty(AVOID_PROJECTION, "true");
        method = this.addPushDownFunction(MONGO, FUNC_GEO_WITHIN, "boolean", new String[]{"geometry"});
        method.setProperty(AVOID_PROJECTION, "true");
        if (this.getVersion().compareTo(TWO_6) >= 0) {
            method = this.addPushDownFunction(MONGO, FUNC_GEO_NEAR, "boolean", new String[]{"string", "double[]", "integer", "integer"});
            method.setProperty(AVOID_PROJECTION, "true");
            method = this.addPushDownFunction(MONGO, FUNC_GEO_NEAR, "boolean", new String[]{"geometry", "integer", "integer"});
            method.setProperty(AVOID_PROJECTION, "true");
            method = this.addPushDownFunction(MONGO, FUNC_GEO_NEAR_SPHERE, "boolean", new String[]{"string", "double[]", "integer", "integer"});
            method.setProperty(AVOID_PROJECTION, "true");
            method = this.addPushDownFunction(MONGO, FUNC_GEO_NEAR_SPHERE, "boolean", new String[]{"geometry", "integer", "integer"});
            method.setProperty(AVOID_PROJECTION, "true");
        } else {
            method = this.addPushDownFunction(MONGO, FUNC_GEO_NEAR, "boolean", new String[]{"string", "double[]", "integer"});
            method.setProperty(AVOID_PROJECTION, "true");
            method = this.addPushDownFunction(MONGO, FUNC_GEO_NEAR_SPHERE, "boolean", new String[]{"string", "double[]", "integer"});
            method.setProperty(AVOID_PROJECTION, "true");
        }
        method = this.addPushDownFunction(MONGO, FUNC_GEO_POLYGON_INTERSECTS, "boolean", new String[]{"string", "double", "double", "double", "double"});
        method.setProperty(AVOID_PROJECTION, "true");
        method = this.addPushDownFunction(MONGO, FUNC_GEO_POLYGON_INTERSECTS, "boolean", new String[]{"geometry"});
        method.setProperty(AVOID_PROJECTION, "true");
        method = this.addPushDownFunction(MONGO, FUNC_GEO_POLYGON_WITHIN, "boolean", new String[]{"string", "double", "double", "double", "double"});
        method.setProperty(AVOID_PROJECTION, "true");
        method = this.addPushDownFunction(MONGO, FUNC_GEO_POLYGON_WITHIN, "boolean", new String[]{"geometry"});
        method.setProperty(AVOID_PROJECTION, "true");
        this.registerFunctionModifier(FUNC_GEO_NEAR, (FunctionModifier)new AliasModifier("$near"));
        this.registerFunctionModifier(FUNC_GEO_NEAR_SPHERE, (FunctionModifier)new AliasModifier("$nearSphere"));
        this.registerFunctionModifier(FUNC_GEO_WITHIN, (FunctionModifier)new AliasModifier("$geoWithin"));
        this.registerFunctionModifier(FUNC_GEO_INTERSECTS, (FunctionModifier)new AliasModifier("$geoIntersects"));
        this.registerFunctionModifier(FUNC_GEO_POLYGON_INTERSECTS, new GeoPolygonFunctionModifier("$geoIntersects"));
        this.registerFunctionModifier(FUNC_GEO_POLYGON_WITHIN, new GeoPolygonFunctionModifier("$geoWithin"));
    }

    @TranslatorProperty(display="Database Version", description="Database Version")
    public String getDatabaseVersion() {
        return this.version.toString();
    }

    Version getVersion() {
        return this.version;
    }

    @TranslatorProperty(display="Use Disk", description="Use disk for aggregation processing in MongoDB", advanced=true)
    public boolean useDisk() {
        return this.useDisk;
    }

    public void setUseDisk(boolean useDisk) {
        this.useDisk = useDisk;
    }

    public void setDatabaseVersion(String version) {
        this.version = Version.getVersion((String)version);
    }

    public void setDatabaseVersion(Version version) {
        this.version = version;
    }

    public MetadataProcessor<MongoDBConnection> getMetadataProcessor() {
        return new MongoDBMetadataProcessor();
    }

    public void registerFunctionModifier(String name, FunctionModifier modifier) {
        this.functionModifiers.put(name, modifier);
    }

    public Map<String, FunctionModifier> getFunctionModifiers() {
        return this.functionModifiers;
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection) throws TranslatorException {
        return new MongoDBQueryExecution(this, command, executionContext, metadata, connection);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection) throws TranslatorException {
        String nativeQuery = command.getMetadataObject().getProperty("{http://www.teiid.org/ext/relational/2012}native-query", false);
        if (nativeQuery != null) {
            return new MongoDBDirectQueryExecution(command.getArguments(), (Command)command, executionContext, metadata, connection, nativeQuery, false, this);
        }
        throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18011, new Object[0]));
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection) throws TranslatorException {
        return new MongoDBUpdateExecution(this, command, executionContext, metadata, connection);
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection) throws TranslatorException {
        return new MongoDBDirectQueryExecution(arguments.subList(1, arguments.size()), command, executionContext, metadata, connection, (String)arguments.get(0).getArgumentValue().getValue(), true, this);
    }

    public boolean useAnsiJoin() {
        return true;
    }

    public boolean supportsSelfJoins() {
        return true;
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsLikeCriteria() {
        return true;
    }

    public boolean supportsOrCriteria() {
        return true;
    }

    public boolean supportsOrderByUnrelated() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsHaving() {
        return true;
    }

    public boolean supportsAggregatesSum() {
        return true;
    }

    public boolean supportsAggregatesAvg() {
        return true;
    }

    public boolean supportsAggregatesMin() {
        return true;
    }

    public boolean supportsAggregatesMax() {
        return true;
    }

    public void setSupportsAggregatesCount(boolean value) {
        this.supportsAggregatesCount = value;
    }

    @TranslatorProperty(display="Supports Count(expr)", description="Supports Aggregate function count with expression", advanced=true)
    public boolean supportsAggregatesCount() {
        return this.supportsAggregatesCount;
    }

    public boolean supportsAggregatesCountStar() {
        return true;
    }

    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(this.getDefaultSupportedFunctions());
        supportedFunctions.add("concat");
        supportedFunctions.add("substring");
        supportedFunctions.add("lcase");
        supportedFunctions.add("ucase");
        supportedFunctions.add("dayofyear");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("dayofweek");
        supportedFunctions.add("year");
        supportedFunctions.add("month");
        supportedFunctions.add("week");
        supportedFunctions.add("hour");
        supportedFunctions.add("minute");
        supportedFunctions.add("second");
        supportedFunctions.add("ifnull");
        return supportedFunctions;
    }

    public List<String> getDefaultSupportedFunctions() {
        return Arrays.asList("+", "-", "*", "/", "%");
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsNotCriteria() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsIsNullCriteria() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean supportsBulkUpdate() {
        return false;
    }

    public boolean supportsLikeRegex() {
        return true;
    }

    public boolean supportsSelectExpression() {
        return true;
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public Object retrieveValue(Object value, Class<?> expectedClass, DB mongoDB, String fqn, String colName) throws TranslatorException {
        if (value == null) {
            return null;
        }
        if (value.getClass().equals(expectedClass)) {
            return value;
        }
        if (value instanceof DBRef) {
            Object obj = ((DBRef)value).getId();
            if (obj instanceof BasicDBObject) {
                BasicDBObject bdb = (BasicDBObject)obj;
                return bdb.get(colName);
            }
            return obj;
        }
        if (value instanceof java.util.Date && expectedClass.equals(Date.class)) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (value instanceof java.util.Date && expectedClass.equals(Timestamp.class)) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        if (value instanceof java.util.Date && expectedClass.equals(Time.class)) {
            return new Time(((java.util.Date)value).getTime());
        }
        if (value instanceof String && expectedClass.equals(BigDecimal.class)) {
            return new BigDecimal((String)value);
        }
        if (value instanceof String && expectedClass.equals(BigInteger.class)) {
            return new BigInteger((String)value);
        }
        if (value instanceof String && expectedClass.equals(Character.class)) {
            return new Character(((String)value).charAt(0));
        }
        if (value instanceof String && expectedClass.equals(BinaryType.class)) {
            return new BinaryType(((String)value).getBytes());
        }
        if (value instanceof String && expectedClass.equals(Blob.class)) {
            GridFS gfs = new GridFS(mongoDB, fqn);
            final GridFSDBFile resource = gfs.findOne((String)value);
            if (resource == null) {
                return null;
            }
            return new BlobImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return resource.getInputStream();
                }
            });
        }
        if (value instanceof String && expectedClass.equals(Clob.class)) {
            GridFS gfs = new GridFS(mongoDB, fqn);
            final GridFSDBFile resource = gfs.findOne((String)value);
            if (resource == null) {
                return null;
            }
            return new ClobImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return resource.getInputStream();
                }
            }, -1L);
        }
        if (value instanceof String && expectedClass.equals(SQLXML.class)) {
            GridFS gfs = new GridFS(mongoDB, fqn);
            final GridFSDBFile resource = gfs.findOne((String)value);
            if (resource == null) {
                return null;
            }
            return new SQLXMLImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return resource.getInputStream();
                }
            });
        }
        if (value instanceof BasicDBList) {
            BasicDBList arrayValues = (BasicDBList)value;
            if (expectedClass.isArray()) {
                Class<?> arrayType = expectedClass.getComponentType();
                Object array = Array.newInstance(arrayType, arrayValues.size());
                for (int i = 0; i < arrayValues.size(); ++i) {
                    Object arrayItem = this.retrieveValue(arrayValues.get(i), arrayType, mongoDB, fqn, colName);
                    Array.set(array, i, arrayItem);
                }
                value = array;
            }
        } else if (value instanceof ObjectId) {
            ObjectId id = (ObjectId)value;
            value = id.toHexString();
        } else {
            Transform transform = DataTypeManager.getTransform(value.getClass(), expectedClass);
            if (transform != null) {
                try {
                    value = transform.transform(value, expectedClass);
                }
                catch (TransformationException e) {
                    throw new TranslatorException((Throwable)e);
                }
            }
        }
        return value;
    }

    public Object convertToMongoType(Object value, DB mongoDB, String fqn) throws TranslatorException {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).doubleValue();
            }
            if (value instanceof BigInteger) {
                return ((BigInteger)value).doubleValue();
            }
            if (value instanceof Character) {
                return ((Character)value).toString();
            }
            if (value instanceof Date) {
                return new java.util.Date(((Date)value).getTime());
            }
            if (value instanceof Time) {
                return new java.util.Date(((Time)value).getTime());
            }
            if (value instanceof Timestamp) {
                return new java.util.Date(((Timestamp)value).getTime());
            }
            if (value instanceof BinaryType) {
                return new Binary(((BinaryType)value).getBytes());
            }
            if (value instanceof byte[]) {
                return new Binary((byte[])value);
            }
            if (!(value instanceof GeometryType) && value instanceof Blob) {
                String uuid = UUID.randomUUID().toString();
                GridFS gfs = new GridFS(mongoDB, fqn);
                GridFSInputFile gfsFile = gfs.createFile(((Blob)value).getBinaryStream());
                gfsFile.setFilename(uuid);
                gfsFile.save();
                return uuid;
            }
            if (value instanceof Clob) {
                String uuid = UUID.randomUUID().toString();
                GridFS gfs = new GridFS(mongoDB, fqn);
                GridFSInputFile gfsFile = gfs.createFile(((Clob)value).getAsciiStream());
                gfsFile.setFilename(uuid);
                gfsFile.save();
                return uuid;
            }
            if (value instanceof SQLXML) {
                String uuid = UUID.randomUUID().toString();
                GridFS gfs = new GridFS(mongoDB, fqn);
                GridFSInputFile gfsFile = gfs.createFile(((SQLXML)value).getBinaryStream());
                gfsFile.setFilename(uuid);
                gfsFile.save();
                return uuid;
            }
            if (value instanceof Object[]) {
                BasicDBList list = new BasicDBList();
                for (Object obj : (Object[])value) {
                    list.add(obj);
                }
                return list;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public AggregationOptions getOptions(int batchSize) {
        if (this.version.compareTo(TWO_4) < 0) {
            return AggregationOptions.builder().batchSize(Integer.valueOf(batchSize)).outputMode(AggregationOptions.OutputMode.INLINE).build();
        }
        if (this.version.compareTo(TWO_6) < 0) {
            return AggregationOptions.builder().batchSize(Integer.valueOf(batchSize)).outputMode(AggregationOptions.OutputMode.CURSOR).allowDiskUse(Boolean.valueOf(this.useDisk())).build();
        }
        return AggregationOptions.builder().batchSize(Integer.valueOf(batchSize)).allowDiskUse(Boolean.valueOf(this.useDisk())).build();
    }

    public boolean isSourceRequiredForCapabilities() {
        return true;
    }

    public ExecutionFactory.TransactionSupport getTransactionSupport() {
        ExecutionFactory.TransactionSupport transactionSupport = super.getTransactionSupport();
        if (transactionSupport != ExecutionFactory.TransactionSupport.XA) {
            return transactionSupport;
        }
        if (this.version.compareTo(FOUR_0) < 0) {
            return ExecutionFactory.TransactionSupport.NONE;
        }
        return ExecutionFactory.TransactionSupport.LOCAL;
    }

    public void initCapabilities(MongoDBConnection connection) throws TranslatorException {
        super.initCapabilities((Object)connection);
        try {
            CommandResult result = connection.getDatabase().command((DBObject)new BasicDBObject("buildInfo", (Object)1));
            String stringVersion = (String)result.get("version");
            if (stringVersion != null) {
                this.version = Version.getVersion((String)stringVersion);
            }
        }
        catch (MongoException mongoException) {
            // empty catch block
        }
    }

    private static class GeoPolygonFunctionModifier
    extends FunctionModifier {
        private String functionName;

        public GeoPolygonFunctionModifier(String name) {
            this.functionName = name;
        }

        public List<?> translate(Function function) {
            List args = function.getParameters();
            Expression north = (Expression)args.get(1);
            Expression east = (Expression)args.get(2);
            Expression west = (Expression)args.get(3);
            Expression south = (Expression)args.get(4);
            ArrayList<org.teiid.language.Array> points = new ArrayList<org.teiid.language.Array>();
            points.add(new org.teiid.language.Array(TypeFacility.RUNTIME_TYPES.DOUBLE, Arrays.asList(west, north)));
            points.add(new org.teiid.language.Array(TypeFacility.RUNTIME_TYPES.DOUBLE, Arrays.asList(east, north)));
            points.add(new org.teiid.language.Array(TypeFacility.RUNTIME_TYPES.DOUBLE, Arrays.asList(east, south)));
            points.add(new org.teiid.language.Array(TypeFacility.RUNTIME_TYPES.DOUBLE, Arrays.asList(west, south)));
            points.add(new org.teiid.language.Array(TypeFacility.RUNTIME_TYPES.DOUBLE, Arrays.asList(west, north)));
            org.teiid.language.Array coordinates = new org.teiid.language.Array(TypeFacility.RUNTIME_TYPES.DOUBLE, points);
            Function func = LanguageFactory.INSTANCE.createFunction(this.functionName, Arrays.asList((Expression)args.get(0), LanguageFactory.INSTANCE.createLiteral((Object)"Polygon", TypeFacility.RUNTIME_TYPES.STRING), coordinates), Boolean.class);
            return Arrays.asList(func);
        }
    }
}

