/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBRef;
import java.sql.Date;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.MongoDBMetadataProcessor;

public class TestMongoDBMetadataProcessor {
    @Test
    public void testMetadata() throws TranslatorException {
        MongoDBMetadataProcessor mp = new MongoDBMetadataProcessor();
        mp.setFullEmbeddedNames(true);
        MetadataFactory mf = this.processExampleMetadata(mp);
        String metadataDDL = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        String expected = "CREATE FOREIGN TABLE \"table\" (\n    \"_id\" integer,\n    col2 double,\n    col3 long,\n    col5 boolean,\n    col6 string,\n    col7 string[] OPTIONS (SEARCHABLE 'Unsearchable'),\n    col8 varbinary OPTIONS (NATIVE_TYPE 'org.bson.types.Binary'),\n    CONSTRAINT PK0 PRIMARY KEY(\"_id\")\n) OPTIONS (UPDATABLE TRUE, \"teiid_rel:fqn\" 'collection=table');\n\nCREATE FOREIGN TABLE table_child (\n    col1 string,\n    col2 string,\n    \"_id\" integer OPTIONS (UPDATABLE FALSE),\n    CONSTRAINT PK0 PRIMARY KEY(\"_id\"),\n    FOREIGN KEY(\"_id\") REFERENCES \"table\" \n) OPTIONS (UPDATABLE TRUE, \"teiid_mongo:MERGE\" 'table', \"teiid_rel:fqn\" 'collection=table/embedded=child');\n\nCREATE FOREIGN TABLE table_embedded (\n    col1 integer,\n    col2 varbinary,\n    \"_id\" integer OPTIONS (UPDATABLE FALSE),\n    CONSTRAINT PK0 PRIMARY KEY(\"_id\"),\n    FOREIGN KEY(\"_id\") REFERENCES \"table\" \n) OPTIONS (UPDATABLE TRUE, \"teiid_mongo:MERGE\" 'table', \"teiid_rel:fqn\" 'collection=table/embedded=embedded');\n\nCREATE FOREIGN TABLE embedded (\n    col1 string,\n    col2 string\n) OPTIONS (UPDATABLE TRUE, \"teiid_rel:fqn\" 'collection=embedded');\n\nCREATE FOREIGN TABLE emptyFirst (\n    \"_id\" string AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'org.bson.types.ObjectId'),\n    col2 double,\n    col3 long,\n    CONSTRAINT PK0 PRIMARY KEY(\"_id\")\n) OPTIONS (UPDATABLE TRUE, \"teiid_rel:fqn\" 'collection=emptyFirst');";
        Assert.assertEquals((Object)expected, (Object)metadataDDL.replace("\t", "    "));
    }

    @Test
    public void testMetadataMoreSamples() throws TranslatorException {
        MongoDBMetadataProcessor mp = new MongoDBMetadataProcessor();
        mp.setSampleSize(2);
        MetadataFactory mf = this.processExampleMetadata(mp);
        String metadataDDL = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        String expected = "CREATE FOREIGN TABLE \"table\" (\n    \"_id\" integer,\n    col2 double,\n    col3 string OPTIONS (SEARCHABLE 'Unsearchable'),\n    col5 boolean,\n    col6 string,\n    col7 string[] OPTIONS (SEARCHABLE 'Unsearchable'),\n    col8 varbinary OPTIONS (NATIVE_TYPE 'org.bson.types.Binary'),\n    col9 string,\n    CONSTRAINT PK0 PRIMARY KEY(\"_id\")\n) OPTIONS (UPDATABLE TRUE, \"teiid_rel:fqn\" 'collection=table');\n\nCREATE FOREIGN TABLE child (\n    col1 string,\n    col2 string,\n    \"_id\" integer OPTIONS (UPDATABLE FALSE),\n    CONSTRAINT PK0 PRIMARY KEY(\"_id\"),\n    FOREIGN KEY(\"_id\") REFERENCES \"table\" \n) OPTIONS (UPDATABLE TRUE, \"teiid_mongo:MERGE\" 'table', \"teiid_rel:fqn\" 'collection=table/embedded=child');\n\nCREATE FOREIGN TABLE embedded (\n    col1 integer,\n    col2 varbinary,\n    \"_id\" integer OPTIONS (UPDATABLE FALSE),\n    CONSTRAINT PK0 PRIMARY KEY(\"_id\"),\n    FOREIGN KEY(\"_id\") REFERENCES \"table\" \n) OPTIONS (UPDATABLE TRUE, \"teiid_mongo:MERGE\" 'table', \"teiid_rel:fqn\" 'collection=table/embedded=embedded');\n\nCREATE FOREIGN TABLE embedded_1 (\n    col1 string,\n    col2 string\n) OPTIONS (UPDATABLE TRUE, \"teiid_rel:fqn\" 'collection=embedded');\n\nCREATE FOREIGN TABLE emptyFirst (\n    \"_id\" string AUTO_INCREMENT OPTIONS (NATIVE_TYPE 'org.bson.types.ObjectId'),\n    col2 double,\n    col3 long,\n    CONSTRAINT PK0 PRIMARY KEY(\"_id\")\n) OPTIONS (UPDATABLE TRUE, \"teiid_rel:fqn\" 'collection=emptyFirst');";
        Assert.assertEquals((Object)expected, (Object)metadataDDL.replace("\t", "    "));
    }

    @Test
    public void testTableWithoutColumns() throws TranslatorException {
        MongoDBMetadataProcessor mp = new MongoDBMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "mongodb", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        MongoDBConnection conn = (MongoDBConnection)Mockito.mock(MongoDBConnection.class);
        DBCollection tableDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        tables.add("table");
        DB db = (DB)Mockito.mock(DB.class);
        BasicDBObject row = new BasicDBObject();
        row.append("col", (Object)new BasicDBObject());
        Mockito.stub((Object)db.getCollectionNames()).toReturn(tables);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"table"))).toReturn((Object)tableDBCollection);
        DBCursor tableCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)tableCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)tableCursor.next()).thenReturn((Object)row);
        Mockito.when((Object)tableDBCollection.find()).thenReturn((Object)tableCursor);
        Mockito.stub((Object)conn.getDatabase()).toReturn((Object)db);
        mp.process(mf, conn);
        String metadataDDL = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        String expected = "";
        Assert.assertEquals((Object)expected, (Object)metadataDDL);
    }

    private MetadataFactory processExampleMetadata(MongoDBMetadataProcessor mp) throws TranslatorException {
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "mongodb", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        mf.setRenameAllDuplicates(true);
        MongoDBConnection conn = (MongoDBConnection)Mockito.mock(MongoDBConnection.class);
        DBCollection tableDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DBCollection embeddedDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DBCollection emptyDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DBCollection emptyFirstDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        tables.add("table");
        tables.add("embedded");
        tables.add("empty");
        tables.add("emptyFirst");
        DB db = (DB)Mockito.mock(DB.class);
        BasicDBList array = new BasicDBList();
        array.add((Object)"one");
        array.add((Object)"two");
        BasicDBObject row = new BasicDBObject();
        row.append("_id", (Object)new Integer(1));
        row.append("col2", (Object)new Double(2.0));
        row.append("col3", (Object)new Long(3L));
        row.append("col5", (Object)Boolean.TRUE);
        row.append("col6", (Object)new Date(0L));
        row.append("col6", (Object)new DBRef(db.getName(), "ns", (Object)"one"));
        row.append("col7", (Object)array);
        row.append("col8", (Object)new Binary("binary".getBytes()));
        row.append("col9", (Object)new BasicDBList());
        BasicDBObject child = new BasicDBObject();
        child.append("col1", (Object)"one");
        child.append("col2", (Object)"two");
        row.append("child", (Object)child);
        BasicDBObject emptyFirstRow = new BasicDBObject();
        emptyFirstRow.append("_id", (Object)new ObjectId("5835a598944716c40d2f26ae"));
        emptyFirstRow.append("col2", (Object)new Double(2.0));
        emptyFirstRow.append("col3", (Object)new Long(3L));
        BasicDBObject embedded = new BasicDBObject();
        embedded.append("col1", (Object)1);
        embedded.append("col2", (Object)new byte[0]);
        row.append("embedded", (Object)embedded);
        Mockito.stub((Object)db.getCollectionNames()).toReturn(tables);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"table"))).toReturn((Object)tableDBCollection);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"embedded"))).toReturn((Object)embeddedDBCollection);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"empty"))).toReturn((Object)emptyDBCollection);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"emptyFirst"))).toReturn((Object)emptyFirstDBCollection);
        BasicDBObject nextRow = new BasicDBObject();
        nextRow.append("_id", (Object)new Integer(2));
        nextRow.append("col2", (Object)new Double(3.0));
        nextRow.append("col3", (Object)"A");
        nextRow.append("col5", (Object)Boolean.TRUE);
        nextRow.append("col9", (Object)"another");
        DBCursor tableCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)tableCursor.numSeen()).thenReturn((Object)1).thenReturn((Object)2);
        Mockito.when((Object)tableCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)tableCursor.next()).thenReturn((Object)row).thenReturn((Object)nextRow);
        Mockito.when((Object)tableDBCollection.find()).thenReturn((Object)tableCursor);
        DBCursor embeddedCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)embeddedCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)embeddedCursor.next()).thenReturn((Object)child);
        Mockito.when((Object)embeddedDBCollection.find()).thenReturn((Object)embeddedCursor);
        DBCursor emptyFirstCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)emptyFirstCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)emptyFirstCursor.next()).thenReturn(null).thenReturn((Object)emptyFirstRow);
        Mockito.when((Object)emptyFirstDBCollection.find()).thenReturn((Object)emptyFirstCursor);
        DBCursor emptyCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)emptyCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)emptyCursor.next()).thenReturn(null);
        Mockito.when((Object)emptyDBCollection.find()).thenReturn((Object)emptyCursor);
        Mockito.stub((Object)conn.getDatabase()).toReturn((Object)db);
        mp.process(mf, conn);
        return mf;
    }

    @Test
    public void testExclusion() throws TranslatorException {
        MongoDBMetadataProcessor mp = new MongoDBMetadataProcessor();
        mp.setExcludeTables("e.*");
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "mongodb", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        MongoDBConnection conn = (MongoDBConnection)Mockito.mock(MongoDBConnection.class);
        DBCollection tableDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DBCollection embeddedDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DBCollection emptyDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        DBCollection emptyFirstDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        tables.add("table");
        tables.add("embedded");
        tables.add("empty");
        tables.add("emptyFirst");
        DB db = (DB)Mockito.mock(DB.class);
        BasicDBList array = new BasicDBList();
        array.add((Object)"one");
        array.add((Object)"two");
        BasicDBObject row = new BasicDBObject();
        row.append("_id", (Object)new Integer(1));
        row.append("col2", (Object)new Double(2.0));
        row.append("col3", (Object)new Long(3L));
        row.append("col5", (Object)Boolean.TRUE);
        row.append("col6", (Object)new Date(0L));
        row.append("col6", (Object)new DBRef(db.getName(), "ns", (Object)"one"));
        row.append("col7", (Object)array);
        row.append("col8", (Object)new Binary("binary".getBytes()));
        BasicDBObject child = new BasicDBObject();
        child.append("col1", (Object)"one");
        child.append("col2", (Object)"two");
        row.append("child", (Object)child);
        BasicDBObject emptyFirstRow = new BasicDBObject();
        emptyFirstRow.append("_id", (Object)new ObjectId("5835a598944716c40d2f26ae"));
        emptyFirstRow.append("col2", (Object)new Double(2.0));
        emptyFirstRow.append("col3", (Object)new Long(3L));
        BasicDBObject embedded = new BasicDBObject();
        embedded.append("col1", (Object)"one");
        embedded.append("col2", (Object)"two");
        row.append("embedded", (Object)embedded);
        Mockito.stub((Object)db.getCollectionNames()).toReturn(tables);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"table"))).toReturn((Object)tableDBCollection);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"embedded"))).toReturn((Object)embeddedDBCollection);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"empty"))).toReturn((Object)emptyDBCollection);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"emptyFirst"))).toReturn((Object)emptyFirstDBCollection);
        DBCursor tableCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)tableCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)tableCursor.next()).thenReturn((Object)row);
        Mockito.when((Object)tableDBCollection.find()).thenReturn((Object)tableCursor);
        DBCursor embeddedCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)embeddedCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)embeddedCursor.next()).thenReturn((Object)child);
        Mockito.when((Object)embeddedDBCollection.find()).thenReturn((Object)embeddedCursor);
        DBCursor emptyFirstCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)emptyFirstCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)emptyFirstCursor.next()).thenReturn(null).thenReturn((Object)emptyFirstRow);
        Mockito.when((Object)emptyFirstDBCollection.find()).thenReturn((Object)emptyFirstCursor);
        DBCursor emptyCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)emptyCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)emptyCursor.next()).thenReturn(null);
        Mockito.when((Object)emptyDBCollection.find()).thenReturn((Object)emptyCursor);
        Mockito.stub((Object)conn.getDatabase()).toReturn((Object)db);
        mp.process(mf, conn);
        String metadataDDL = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        String expected = "CREATE FOREIGN TABLE \"table\" (\n    \"_id\" integer,\n    col2 double,\n    col3 long,\n    col5 boolean,\n    col6 string,\n    col7 string[] OPTIONS (SEARCHABLE 'Unsearchable'),\n    col8 varbinary OPTIONS (NATIVE_TYPE 'org.bson.types.Binary'),\n    CONSTRAINT PK0 PRIMARY KEY(\"_id\")\n) OPTIONS (UPDATABLE TRUE, \"teiid_rel:fqn\" 'collection=table');\n\nCREATE FOREIGN TABLE child (\n    col1 string,\n    col2 string,\n    \"_id\" integer OPTIONS (UPDATABLE FALSE),\n    CONSTRAINT PK0 PRIMARY KEY(\"_id\"),\n    FOREIGN KEY(\"_id\") REFERENCES \"table\" \n) OPTIONS (UPDATABLE TRUE, \"teiid_mongo:MERGE\" 'table', \"teiid_rel:fqn\" 'collection=table/embedded=child');\n\nCREATE FOREIGN TABLE embedded (\n    col1 string,\n    col2 string,\n    \"_id\" integer OPTIONS (UPDATABLE FALSE),\n    CONSTRAINT PK0 PRIMARY KEY(\"_id\"),\n    FOREIGN KEY(\"_id\") REFERENCES \"table\" \n) OPTIONS (UPDATABLE TRUE, \"teiid_mongo:MERGE\" 'table', \"teiid_rel:fqn\" 'collection=table/embedded=embedded');";
        Assert.assertEquals((Object)expected, (Object)metadataDDL.replace("\t", "    "));
    }

    @Test
    public void testEmbeddedList() throws TranslatorException {
        MongoDBMetadataProcessor mp = new MongoDBMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "mongodb", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        MongoDBConnection conn = (MongoDBConnection)Mockito.mock(MongoDBConnection.class);
        DBCollection tableDBCollection = (DBCollection)Mockito.mock(DBCollection.class);
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        tables.add("table");
        DB db = (DB)Mockito.mock(DB.class);
        BasicDBList list = new BasicDBList();
        BasicDBObject child = new BasicDBObject();
        child.append("col1", (Object)"one");
        child.append("col2", (Object)"two");
        list.add((Object)child);
        BasicDBObject row = new BasicDBObject();
        row.append("_id", (Object)1);
        row.append("col1", (Object)list);
        Mockito.stub((Object)db.getCollectionNames()).toReturn(tables);
        Mockito.stub((Object)db.getCollection((String)Mockito.eq((Object)"table"))).toReturn((Object)tableDBCollection);
        DBCursor tableCursor = (DBCursor)Mockito.mock(DBCursor.class);
        Mockito.when((Object)tableCursor.hasNext()).thenReturn((Object)true).thenReturn((Object)false);
        Mockito.when((Object)tableCursor.next()).thenReturn((Object)row);
        Mockito.when((Object)tableDBCollection.find()).thenReturn((Object)tableCursor);
        Mockito.stub((Object)conn.getDatabase()).toReturn((Object)db);
        mp.process(mf, conn);
        String metadataDDL = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        String expected = "CREATE FOREIGN TABLE \"table\" (\n    \"_id\" integer,\n    CONSTRAINT PK0 PRIMARY KEY(\"_id\")\n) OPTIONS (UPDATABLE TRUE, \"teiid_rel:fqn\" 'collection=table');\n\nCREATE FOREIGN TABLE col1 (\n    col1 string,\n    col2 string,\n    table__id integer OPTIONS (UPDATABLE FALSE),\n    FOREIGN KEY(table__id) REFERENCES \"table\" \n) OPTIONS (UPDATABLE TRUE, \"teiid_mongo:MERGE\" 'table', \"teiid_rel:fqn\" 'collection=table/embedded=col1');";
        Assert.assertEquals((Object)expected, (Object)metadataDDL.replace("\t", "    "));
    }
}

