/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.ArrayList;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.language.LanguageObject;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.MongoDBBaseExecution;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDBSelectVisitor;
import org.teiid.translator.mongodb.ProcessingNode;

public class MongoDBQueryExecution
extends MongoDBBaseExecution
implements ResultSetExecution {
    private Select command;
    private MongoDBExecutionFactory executionFactory;
    private Cursor results;
    private MongoDBSelectVisitor visitor;
    private Class<?>[] expectedTypes;

    public MongoDBQueryExecution(MongoDBExecutionFactory executionFactory, QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection) {
        super(executionContext, metadata, connection);
        this.command = (Select)command;
        this.executionFactory = executionFactory;
        this.expectedTypes = command.getColumnTypes();
    }

    public void execute() throws TranslatorException {
        this.visitor = new MongoDBSelectVisitor(this.executionFactory, this.metadata);
        this.visitor.visitNode((LanguageObject)this.command);
        if (!this.visitor.exceptions.isEmpty()) {
            throw this.visitor.exceptions.get(0);
        }
        LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)this.command);
        DBCollection collection = this.mongoDB.getCollection(this.visitor.mongoDoc.getTargetTable().getName());
        if (collection != null) {
            ArrayList<DBObject> ops = new ArrayList<DBObject>();
            for (ProcessingNode ref : this.visitor.mergePlanner.getNodes()) {
                this.buildAggregate(ops, (DBObject)ref.getInstruction());
            }
            if (this.visitor.project.isEmpty()) {
                throw new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18025, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18025, new Object[0]));
            }
            assert (this.visitor.selectColumns.size() == this.visitor.selectColumnReferences.size());
            if (this.visitor.projectBeforeMatch) {
                this.buildAggregate(ops, "$project", this.visitor.project);
            }
            this.buildAggregate(ops, "$match", this.visitor.match);
            this.buildAggregate(ops, "$group", this.visitor.group);
            this.buildAggregate(ops, "$match", this.visitor.having);
            if (!this.visitor.projectBeforeMatch) {
                this.buildAggregate(ops, "$project", this.visitor.project);
            }
            this.buildAggregate(ops, "$sort", this.visitor.sort);
            this.buildAggregate(ops, "$skip", this.visitor.skip);
            this.buildAggregate(ops, "$limit", this.visitor.limit);
            try {
                this.results = collection.aggregate(ops, this.executionFactory.getOptions(this.executionContext.getBatchSize()));
            }
            catch (MongoException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
    }

    private void buildAggregate(List<DBObject> query, String type, Object object) {
        if (object != null) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)("{\"" + type + "\": {" + object.toString() + "}}"));
            query.add((DBObject)new BasicDBObject(type, object));
        }
    }

    private void buildAggregate(List<DBObject> query, DBObject dbObject) {
        if (dbObject != null) {
            query.add(dbObject);
        }
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        DBObject result;
        if (this.results != null && this.results.hasNext() && (result = (DBObject)this.results.next()) != null) {
            int cols = this.visitor.selectColumns.size();
            ArrayList<Object> row = new ArrayList<Object>(cols);
            for (int i = 0; i < cols; ++i) {
                row.add(this.executionFactory.retrieveValue(result.get(this.visitor.selectColumns.get(i)), this.expectedTypes[i], this.mongoDB, this.visitor.selectColumns.get(i), this.visitor.selectColumnReferences.get(i)));
            }
            return row;
        }
        return null;
    }

    public void close() {
        if (this.results != null) {
            this.results.close();
            this.results = null;
        }
    }

    public void cancel() throws TranslatorException {
        this.close();
    }
}

