/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.teiid.core.BundleUtil;
import org.teiid.language.AndOr;
import org.teiid.language.Array;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Delete;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Function;
import org.teiid.language.In;
import org.teiid.language.Insert;
import org.teiid.language.IsNull;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Literal;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.language.visitor.CollectorVisitor;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.ColumnDetail;
import org.teiid.translator.mongodb.ExpressionEvaluator;
import org.teiid.translator.mongodb.IDRef;
import org.teiid.translator.mongodb.MergeDetails;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDBSelectVisitor;
import org.teiid.translator.mongodb.MongoDBUpdateExecution;

public class MongoDBUpdateVisitor
extends MongoDBSelectVisitor {
    protected LinkedHashMap<String, Object> columnValues = new LinkedHashMap();
    private DB mongoDB;
    private BasicDBObject pull;
    private Condition condition;
    protected Stack<DBObject> onGoingPullCriteria = new Stack();
    protected TranslatorException pullException;

    public MongoDBUpdateVisitor(MongoDBExecutionFactory executionFactory, RuntimeMetadata metadata, DB mongoDB) {
        super(executionFactory, metadata);
        this.mongoDB = mongoDB;
    }

    public void visit(Insert obj) {
        this.append((LanguageObject)obj.getTable());
        List columns = obj.getColumns();
        List values = ((ExpressionValueSource)obj.getValueSource()).getValues();
        try {
            IDRef pk = null;
            for (int i = 0; i < columns.size(); ++i) {
                String colName = this.getColumnName((ColumnReference)columns.get(i));
                Expression expr = (Expression)values.get(i);
                Object value = this.resolveExpressionValue(colName, expr);
                if (this.mongoDoc.isPartOfPrimaryKey(colName)) {
                    if (pk == null) {
                        pk = new IDRef();
                    }
                    pk.addColumn(colName, value);
                } else {
                    this.columnValues.put(colName, value);
                }
                this.mongoDoc.updateReferenceColumnValue(obj.getTable().getName(), colName, value);
                if (!this.mongoDoc.isPartOfForeignKey(colName)) continue;
                MergeDetails ref = this.mongoDoc.getFKReference(colName);
                this.columnValues.put(colName, ref.clone());
            }
            if (pk != null) {
                this.columnValues.put("_id", pk.getValue());
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    private Object resolveExpressionValue(String colName, Expression expr) throws TranslatorException {
        Object value = null;
        if (expr instanceof Literal) {
            value = this.executionFactory.convertToMongoType(((Literal)expr).getValue(), this.mongoDB, colName);
        } else if (expr instanceof Array) {
            Array contents = (Array)expr;
            List arrayExprs = contents.getExpressions();
            value = new BasicDBList();
            for (Expression exp : arrayExprs) {
                if (exp instanceof Literal) {
                    ((BasicDBList)value).add(this.executionFactory.convertToMongoType(((Literal)exp).getValue(), this.mongoDB, colName));
                    continue;
                }
                this.exceptions.add(new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18001, new Object[0])));
            }
        } else {
            this.exceptions.add(new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18001, new Object[0])));
        }
        return value;
    }

    public void visit(Update obj) {
        this.condition = obj.getWhere();
        this.append((LanguageObject)obj.getTable());
        List changes = obj.getChanges();
        try {
            IDRef pk = null;
            for (SetClause clause : changes) {
                String colName = this.getColumnName(clause.getSymbol());
                if (this.mongoDoc.isMerged()) {
                    if (this.mongoDoc.getMergeKey().getAssociation() == MergeDetails.Association.ONE && this.mongoDoc.isPartOfPrimaryKey(colName)) {
                        throw new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18035, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18035, new Object[]{colName, obj.getTable().getName()}));
                    }
                    if (this.mongoDoc.getMergeKey().getAssociation() == MergeDetails.Association.MANY && this.mongoDoc.isPartOfForeignKey(colName)) {
                        throw new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18036, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18036, new Object[]{colName, obj.getTable().getName()}));
                    }
                }
                Expression expr = clause.getValue();
                Object value = this.resolveExpressionValue(colName, expr);
                if (this.mongoDoc.isPartOfPrimaryKey(colName)) {
                    if (pk == null) {
                        pk = new IDRef();
                    }
                    pk.addColumn(colName, value);
                } else {
                    this.columnValues.put(colName, value);
                }
                this.mongoDoc.updateReferenceColumnValue(obj.getTable().getName(), colName, value);
                if (!this.mongoDoc.isPartOfForeignKey(colName)) continue;
                MergeDetails ref = this.mongoDoc.getFKReference(colName);
                this.columnValues.put(colName, ref.clone());
            }
            if (pk != null) {
                this.columnValues.put("_id", pk.getValue());
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
        this.append((LanguageObject)obj.getWhere());
        if (!this.onGoingExpression.isEmpty()) {
            this.match = (DBObject)this.onGoingExpression.pop();
        }
    }

    public void visit(Delete obj) {
        this.condition = obj.getWhere();
        this.append((LanguageObject)obj.getTable());
        this.append((LanguageObject)obj.getWhere());
        if (!this.onGoingExpression.isEmpty()) {
            this.match = (DBObject)this.onGoingExpression.pop();
        }
    }

    public BasicDBObject getInsert(LinkedHashMap<String, DBObject> embeddedDocuments) {
        BasicDBObject insert = new BasicDBObject();
        for (String key : this.columnValues.keySet()) {
            Object obj = this.columnValues.get(key);
            if (obj instanceof MergeDetails) {
                obj = ((MergeDetails)obj).getValue();
            }
            if (key.equals("_id")) {
                insert.append("_id", obj);
            }
            if (this.mongoDoc.isPartOfPrimaryKey(key)) continue;
            if (this.mongoDoc.isPartOfForeignKey(key)) {
                if (obj instanceof BasicDBObject) {
                    insert.append(key, ((BasicDBObject)obj).get(key));
                    continue;
                }
                insert.append(key, obj);
                continue;
            }
            insert.append(key, obj);
        }
        if (this.mongoDoc.hasEmbeddedDocuments()) {
            for (String docName : this.mongoDoc.getEmbeddedDocumentNames()) {
                DBObject embedDoc = embeddedDocuments.get(docName);
                if (embedDoc == null) continue;
                insert.append(docName, (Object)embedDoc);
            }
        }
        return insert;
    }

    public BasicDBObject getUpdate(LinkedHashMap<String, DBObject> embeddedDocuments) throws TranslatorException {
        BasicDBObject update = new BasicDBObject();
        for (String key : this.columnValues.keySet()) {
            Object obj = this.columnValues.get(key);
            if (obj instanceof MergeDetails) {
                MergeDetails ref = (MergeDetails)obj;
                if (this.mongoDoc.isMerged() && ref.getParentTable().equals(this.mongoDoc.getMergeTable().getName())) {
                    throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18007, new Object[]{ref.getParentTable(), this.mongoDoc.getDocumentName()}));
                }
                if (this.mongoDoc.isPartOfForeignKey(key)) {
                    if (ref.getValue() instanceof BasicDBObject) {
                        update.append(key, ((BasicDBObject)ref.getValue()).get(key));
                    } else {
                        update.append(key, ref.getValue());
                    }
                } else {
                    update.append(key, ref.getValue());
                }
                if (!this.mongoDoc.hasEmbeddedDocuments()) continue;
                for (MergeDetails docKey : this.mongoDoc.getEmbeddedReferences()) {
                    if (!ref.getParentTable().equals(docKey.getEmbeddedTable())) continue;
                    DBObject embedDoc = embeddedDocuments.get(docKey.getName());
                    if (embedDoc == null || ref.getValue() == null) {
                        update.append(docKey.getName(), null);
                        continue;
                    }
                    update.append(docKey.getName(), (Object)embedDoc);
                }
                continue;
            }
            if (this.mongoDoc.isMerged()) {
                if (this.mongoDoc.getMergeAssociation() == MergeDetails.Association.MANY) {
                    update.append(this.mongoDoc.getDocumentName() + ".$." + key, obj);
                    continue;
                }
                update.append(this.mongoDoc.getDocumentName() + "." + key, obj);
                continue;
            }
            if (this.mongoDoc.isPartOfPrimaryKey(key)) {
                if (this.hasCompositePrimaryKey(this.mongoDoc.getTargetTable())) {
                    update.append("_id." + key, obj);
                    continue;
                }
                update.append("_id", obj);
                continue;
            }
            update.append(key, obj);
        }
        return update;
    }

    public BasicDBObject getPullQuery() throws TranslatorException {
        if (this.pullException != null) {
            throw this.pullException;
        }
        if (this.pull == null) {
            this.pull = this.onGoingPullCriteria.isEmpty() ? new BasicDBObject() : new BasicDBObject(this.mongoDoc.getTable().getName(), (Object)this.onGoingPullCriteria.pop());
        }
        return this.pull;
    }

    public boolean updateMerge(BasicDBList previousRows, MongoDBUpdateExecution.RowInfo parentKey, BasicDBList updated) throws TranslatorException {
        boolean update = false;
        for (int i = 0; i < previousRows.size(); ++i) {
            BasicDBObject row = (BasicDBObject)previousRows.get(i);
            if (this.match == null && this.getPullQuery() == null || ExpressionEvaluator.matches(this.executionFactory, this.mongoDB, this.condition, row, parentKey)) {
                update = true;
                for (String key : this.columnValues.keySet()) {
                    Object obj = this.columnValues.get(key);
                    if (obj instanceof MergeDetails) {
                        MergeDetails ref = (MergeDetails)obj;
                        row.put((Object)key, ref.getValue());
                        continue;
                    }
                    row.put((Object)key, obj);
                }
            }
            updated.add((Object)row);
        }
        return update;
    }

    public boolean updateDelete(BasicDBList previousRows, MongoDBUpdateExecution.RowInfo parentKey, BasicDBList updated) throws TranslatorException {
        for (int i = 0; i < previousRows.size(); ++i) {
            BasicDBObject row = (BasicDBObject)previousRows.get(i);
            if (this.match == null && this.getPullQuery() == null || ExpressionEvaluator.matches(this.executionFactory, this.mongoDB, this.condition, row, parentKey)) continue;
            updated.add((Object)row);
        }
        return updated.size() != previousRows.size();
    }

    public boolean updateMerge(BasicDBObject previousRow, MongoDBUpdateExecution.RowInfo parentKey) throws TranslatorException {
        boolean update = false;
        if (this.match == null || ExpressionEvaluator.matches(this.executionFactory, this.mongoDB, this.condition, previousRow, parentKey)) {
            for (String key : this.columnValues.keySet()) {
                Object obj = this.columnValues.get(key);
                update = true;
                if (obj instanceof MergeDetails) {
                    MergeDetails ref = (MergeDetails)obj;
                    previousRow.put((Object)key, ref.getValue());
                    continue;
                }
                previousRow.put((Object)key, obj);
            }
        }
        return update;
    }

    @Override
    public void visit(Comparison obj) {
        boolean buildPullQuery;
        if (!this.mongoDoc.isMerged() || this.mongoDoc.isMerged() && this.mongoDoc.getMergeAssociation() != MergeDetails.Association.MANY) {
            super.visit(obj);
            return;
        }
        ColumnDetail leftExpr = this.getExpressionAlias(obj.getLeftExpression());
        this.append((LanguageObject)obj.getRightExpression());
        Object rightExpr = this.onGoingExpression.pop();
        if (this.expressionMap.get(rightExpr) != null) {
            rightExpr = ((ColumnDetail)this.expressionMap.get(rightExpr)).getProjectedName();
        }
        boolean bl = buildPullQuery = this.includeInPullCriteria(obj.getLeftExpression()) && this.includeInPullCriteria(obj.getRightExpression());
        if (!buildPullQuery) {
            QueryBuilder query = leftExpr.getQueryBuilder();
            this.buildComparisionQuery(obj, rightExpr, query);
            this.onGoingExpression.push(query.get());
        } else {
            QueryBuilder pullQuery = leftExpr.getPullQueryBuilder();
            this.buildComparisionQuery(obj, rightExpr, pullQuery);
            this.onGoingPullCriteria.push(pullQuery.get());
        }
        if (obj.getLeftExpression() instanceof ColumnReference) {
            ColumnReference column = (ColumnReference)obj.getLeftExpression();
            this.mongoDoc.updateReferenceColumnValue(column.getTable().getName(), column.getName(), rightExpr);
        }
    }

    private boolean includeInPullCriteria(Expression expr) {
        if (!this.mongoDoc.isMerged()) {
            return false;
        }
        Collection columns = CollectorVisitor.collectElements((LanguageObject)expr);
        for (ColumnReference column : columns) {
            if (!this.mongoDoc.isPartOfForeignKey(column.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visit(AndOr obj) {
        if (!this.mongoDoc.isMerged() || this.mongoDoc.isMerged() && this.mongoDoc.getMergeAssociation() != MergeDetails.Association.MANY) {
            super.visit(obj);
            return;
        }
        this.append((LanguageObject)obj.getLeftCondition());
        this.append((LanguageObject)obj.getRightCondition());
        boolean valid = false;
        if (this.onGoingExpression.size() >= 2) {
            DBObject right = (DBObject)this.onGoingExpression.pop();
            DBObject left = (DBObject)this.onGoingExpression.pop();
            switch (obj.getOperator()) {
                case AND: {
                    this.onGoingExpression.push(QueryBuilder.start().and(new DBObject[]{left, right}).get());
                    break;
                }
                case OR: {
                    this.onGoingExpression.push(QueryBuilder.start().or(new DBObject[]{left, right}).get());
                }
            }
            valid = true;
        }
        if (this.onGoingPullCriteria.size() >= 2) {
            DBObject pullRight = this.onGoingPullCriteria.pop();
            DBObject pullLeft = this.onGoingPullCriteria.pop();
            switch (obj.getOperator()) {
                case AND: {
                    this.onGoingPullCriteria.push(QueryBuilder.start().and(new DBObject[]{pullLeft, pullRight}).get());
                    break;
                }
                case OR: {
                    this.onGoingPullCriteria.push(QueryBuilder.start().or(new DBObject[]{pullLeft, pullRight}).get());
                }
            }
            valid = true;
        }
        if (!valid && obj.getOperator() == AndOr.Operator.OR) {
            this.pullException = new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18029, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18029, new Object[0]));
        }
    }

    @Override
    public void visit(Function obj) {
        if (!this.mongoDoc.isMerged() || this.mongoDoc.isMerged() && this.mongoDoc.getMergeAssociation() != MergeDetails.Association.MANY) {
            super.visit(obj);
            return;
        }
        this.pullException = new TranslatorException((BundleUtil.Event)MongoDBPlugin.Event.TEIID18028, MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18028, new Object[0]));
    }

    @Override
    public void visit(In obj) {
        if (!this.mongoDoc.isMerged() || this.mongoDoc.isMerged() && this.mongoDoc.getMergeAssociation() != MergeDetails.Association.MANY) {
            super.visit(obj);
            return;
        }
        boolean buildPullQuery = this.includeInPullCriteria(obj.getLeftExpression());
        if (buildPullQuery) {
            ColumnDetail exprAlias = this.getExpressionAlias(obj.getLeftExpression());
            this.onGoingPullCriteria.push(this.buildInQuery(obj, exprAlias.getPullQueryBuilder()).get());
        } else {
            ColumnDetail exprAlias = this.getExpressionAlias(obj.getLeftExpression());
            this.onGoingExpression.push(this.buildInQuery(obj, exprAlias.getQueryBuilder()).get());
        }
    }

    @Override
    public void visit(IsNull obj) {
        if (!this.mongoDoc.isMerged() || this.mongoDoc.isMerged() && this.mongoDoc.getMergeAssociation() != MergeDetails.Association.MANY) {
            super.visit(obj);
            return;
        }
        boolean buildPullQuery = this.includeInPullCriteria(obj.getExpression());
        if (buildPullQuery) {
            ColumnDetail exprAlias = this.getExpressionAlias(obj.getExpression());
            this.onGoingPullCriteria.push(this.buildIsNullQuery(obj, exprAlias.getPullQueryBuilder()).get());
        } else {
            ColumnDetail exprAlias = this.getExpressionAlias(obj.getExpression());
            this.onGoingExpression.push(this.buildIsNullQuery(obj, exprAlias.getQueryBuilder()).get());
        }
    }

    @Override
    public void visit(Like obj) {
        if (!this.mongoDoc.isMerged() || this.mongoDoc.isMerged() && this.mongoDoc.getMergeAssociation() != MergeDetails.Association.MANY) {
            super.visit(obj);
            return;
        }
        boolean buildPullQuery = this.includeInPullCriteria(obj.getLeftExpression());
        if (buildPullQuery) {
            ColumnDetail exprAlias = this.getExpressionAlias(obj.getLeftExpression());
            this.onGoingPullCriteria.push(this.buildLikeQuery(obj, exprAlias.getPullQueryBuilder()).get());
        } else {
            ColumnDetail exprAlias = this.getExpressionAlias(obj.getLeftExpression());
            this.onGoingExpression.push(this.buildLikeQuery(obj, exprAlias.getQueryBuilder()).get());
        }
    }
}

