/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata.sap;

import java.util.HashMap;
import org.odata4j.core.NamespacedAnnotation;
import org.odata4j.core.PrefixedNamespace;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmProperty;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.odata.ODataMetadataProcessor;
import org.teiid.translator.odata.ODataTypeManager;

public class SAPMetadataProcessor
extends ODataMetadataProcessor {
    private static final String SAPURI = "http://www.sap.com/Protocols/SAPData";
    private HashMap<Table, KeyRecord> accessPatterns = new HashMap();

    @Override
    protected Table buildTable(MetadataFactory mf, EdmEntitySet entitySet) {
        boolean creatable = true;
        boolean updatable = true;
        boolean deletable = true;
        boolean pageable = true;
        boolean topable = true;
        Table t = mf.addTable(entitySet.getName());
        Iterable annotations = entitySet.getAnnotations();
        for (NamespacedAnnotation annotation : annotations) {
            PrefixedNamespace namespace = annotation.getNamespace();
            if (!namespace.getUri().equals(SAPURI)) continue;
            String name = annotation.getName();
            if (name.equalsIgnoreCase("label")) {
                t.setAnnotation((String)annotation.getValue());
                continue;
            }
            if (name.equalsIgnoreCase("creatable")) {
                creatable = Boolean.parseBoolean((String)annotation.getValue());
                continue;
            }
            if (name.equalsIgnoreCase("updatable")) {
                updatable = Boolean.parseBoolean((String)annotation.getValue());
                continue;
            }
            if (name.equalsIgnoreCase("pageable")) {
                pageable = Boolean.parseBoolean((String)annotation.getValue());
                continue;
            }
            if (name.equalsIgnoreCase("topable")) {
                topable = Boolean.parseBoolean((String)annotation.getValue());
                continue;
            }
            if (!name.equalsIgnoreCase("deletable")) continue;
            deletable = Boolean.parseBoolean((String)annotation.getValue());
        }
        t.setSupportsUpdate(creatable && updatable && deletable);
        if (!topable || !pageable) {
            // empty if block
        }
        return t;
    }

    String getProperty(EdmEntitySet entitySet, String key) {
        Iterable annotations = entitySet.getAnnotations();
        for (NamespacedAnnotation annotation : annotations) {
            PrefixedNamespace namespace = annotation.getNamespace();
            if (!namespace.getUri().equals(SAPURI) || !annotation.getName().equalsIgnoreCase(key)) continue;
            return (String)annotation.getValue();
        }
        return null;
    }

    @Override
    protected Column buildColumn(MetadataFactory mf, Table table, EdmProperty ep, EdmEntitySet entitySet, String prefix) {
        boolean requiresFilter;
        boolean creatable = true;
        boolean updatable = true;
        boolean filterable = true;
        boolean required_in_filter = false;
        String columnName = ep.getName();
        if (prefix != null) {
            columnName = prefix + "_" + columnName;
        }
        Column c = mf.addColumn(columnName, ODataTypeManager.teiidType(ep.getType().getFullyQualifiedTypeName()), (ColumnSet)table);
        c.setNameInSource(ep.getName());
        Iterable annotations = ep.getAnnotations();
        for (NamespacedAnnotation annotation : annotations) {
            PrefixedNamespace namespace = annotation.getNamespace();
            if (!namespace.getUri().equals(SAPURI)) continue;
            String name = annotation.getName();
            if (name.equalsIgnoreCase("label")) {
                c.setAnnotation((String)annotation.getValue());
            } else if (name.equalsIgnoreCase("creatable")) {
                creatable = Boolean.parseBoolean((String)annotation.getValue());
            }
            if (name.equalsIgnoreCase("visible")) {
                c.setSelectable(Boolean.parseBoolean((String)annotation.getValue()));
            }
            if (name.equalsIgnoreCase("updatable")) {
                updatable = Boolean.parseBoolean((String)annotation.getValue());
            }
            if (name.equalsIgnoreCase("sortable") && !Boolean.parseBoolean((String)annotation.getValue())) {
                c.setSearchType(Column.SearchType.Unsearchable);
            }
            if (name.equalsIgnoreCase("filterable")) {
                filterable = Boolean.parseBoolean((String)annotation.getValue());
            }
            if (name.equalsIgnoreCase("required-in-filter")) {
                required_in_filter = Boolean.parseBoolean((String)annotation.getValue());
            }
            if (!name.equalsIgnoreCase("filter-restriction")) continue;
        }
        c.setUpdatable(creatable && updatable);
        if (!filterable) {
            c.setSearchType(Column.SearchType.Unsearchable);
        }
        if (required_in_filter) {
            if (this.accessPatterns.get(table) == null) {
                KeyRecord record = new KeyRecord(KeyRecord.Type.AccessPattern);
                record.addColumn(c);
                this.accessPatterns.put(table, record);
            } else {
                this.accessPatterns.get(table).addColumn(c);
            }
        }
        if ((requiresFilter = Boolean.parseBoolean(this.getProperty(entitySet, "requires-filter"))) && filterable && !required_in_filter) {
            KeyRecord record = new KeyRecord(KeyRecord.Type.AccessPattern);
            record.addColumn(c);
            table.getAccessPatterns().add(record);
        }
        return c;
    }

    @Override
    protected Table addEntitySetAsTable(MetadataFactory mf, EdmEntitySet entitySet) throws TranslatorException {
        Table table = super.addEntitySetAsTable(mf, entitySet);
        KeyRecord accessPattern = this.accessPatterns.get(table);
        if (accessPattern != null) {
            table.getAccessPatterns().add(accessPattern);
        }
        return table;
    }
}

