/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Properties;
import javax.activation.DataSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.odata4j.core.OError;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.format.xml.EdmxFormatParser;
import org.odata4j.stax2.util.StaxUtil;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.WSConnection;
import org.teiid.translator.odata.AtomErrorFormatParser;
import org.teiid.translator.odata.ODataExecutionFactory;
import org.teiid.translator.odata.ODataMetadataProcessor;
import org.teiid.translator.odata.TestDataEntitySchemaBuilder;

public class TestODataQueryExecution {
    private ResultSetExecution helpExecute(String query, String resultXML, String expectedURL) throws Exception {
        TransformationMetadata metadata = TestDataEntitySchemaBuilder.getNorthwindMetadataFromODataXML();
        return this.helpExecute(query, resultXML, expectedURL, 200, metadata);
    }

    private ResultSetExecution helpExecute(String query, String resultXML, String expectedURL, int responseCode) throws Exception {
        TransformationMetadata metadata = TestDataEntitySchemaBuilder.getNorthwindMetadataFromODataXML();
        return this.helpExecute(query, resultXML, expectedURL, responseCode, metadata);
    }

    private ResultSetExecution helpExecute(String query, final String resultXML, String expectedURL, int responseCode, TransformationMetadata metadata) throws Exception {
        ODataExecutionFactory translator = new ODataExecutionFactory();
        translator.start();
        TranslationUtility utility = new TranslationUtility((QueryMetadataInterface)metadata);
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WSConnection connection = (WSConnection)Mockito.mock(WSConnection.class);
        HashMap<String, Serializable> headers = new HashMap<String, Serializable>();
        headers.put("javax.xml.ws.http.request.headers", new HashMap());
        headers.put("status-code", new Integer(responseCode));
        Dispatch dispatch = (Dispatch)Mockito.mock(Dispatch.class);
        Mockito.stub((Object)dispatch.getRequestContext()).toReturn(headers);
        Mockito.stub((Object)dispatch.getResponseContext()).toReturn(headers);
        Mockito.stub((Object)connection.createDispatch((String)Mockito.eq((Object)"http://www.w3.org/2004/08/wsdl/http"), Mockito.anyString(), (Class)Mockito.eq(DataSource.class), (Service.Mode)Mockito.eq((Object)Service.Mode.MESSAGE))).toReturn((Object)dispatch);
        DataSource ds = new DataSource(){

            public OutputStream getOutputStream() throws IOException {
                return new ByteArrayOutputStream();
            }

            public String getName() {
                return "result";
            }

            public InputStream getInputStream() throws IOException {
                ByteArrayInputStream in = new ByteArrayInputStream(resultXML.getBytes());
                return in;
            }

            public String getContentType() {
                return "application/xml";
            }
        };
        Mockito.stub((Object)dispatch.invoke(Mockito.any(DataSource.class))).toReturn((Object)ds);
        ResultSetExecution execution = translator.createResultSetExecution((QueryExpression)cmd, context, utility.createRuntimeMetadata(), connection);
        execution.execute();
        ArgumentCaptor endpoint = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor binding = ArgumentCaptor.forClass(String.class);
        ((WSConnection)Mockito.verify((Object)connection)).createDispatch((String)binding.capture(), (String)endpoint.capture(), (Class)Mockito.eq(DataSource.class), (Service.Mode)Mockito.eq((Object)Service.Mode.MESSAGE));
        Assert.assertEquals((Object)expectedURL, (Object)URLDecoder.decode((String)endpoint.getValue(), "utf-8"));
        return execution;
    }

    @Test
    public void testSimpleSelectNoAssosiations() throws Exception {
        String query = "SELECT CategoryID, CategoryName, Description FROM Categories";
        String expectedURL = "Categories?$select=CategoryID,CategoryName,Description";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"categories.xml"));
        ResultSetExecution excution = this.helpExecute(query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        Assert.assertArrayEquals((Object[])new Object[]{1, "Beverages", "Soft drinks, coffees, teas, beers, and ales"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{2, "Condiments", "Sweet and savory sauces, relishes, spreads, and seasonings"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{3, "Confections", "Desserts, candies, and sweet breads"}, (Object[])excution.next().toArray(new Object[3]));
        reader.close();
    }

    @Test
    public void testSimpleSelectStar() throws Exception {
        String query = "SELECT * FROM Categories";
        String expectedURL = "Categories?$select=CategoryID,CategoryName,Description,Picture";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"categories.xml"));
        ResultSetExecution excution = this.helpExecute(query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        reader.close();
    }

    @Test
    public void testSimpleSelectEmbedded() throws Exception {
        String query = "SELECT * FROM Customers";
        String expectedURL = "Customers?$select=CustomerID,CompanyName,ContactName,ContactTitle,Mailing,Shipping";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"customer.xml"));
        ResultSetExecution excution = this.helpExecute(query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        reader.close();
        Assert.assertEquals((long)18L, (long)excution.next().size());
    }

    @Test
    public void testSimplePKWhere() throws Exception {
        String query = "SELECT * FROM Categories Where CategoryId = 3";
        String expectedURL = "Categories(3)?$select=CategoryID,CategoryName,Description,Picture";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"categories.xml"));
        ResultSetExecution excution = this.helpExecute(query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        reader.close();
    }

    @Test
    public void testSimpleWhere() throws Exception {
        String query = "SELECT * FROM Categories Where CategoryName = 'Beverages'";
        String expectedURL = "Categories?$filter=CategoryName eq 'Beverages'&$select=CategoryID,CategoryName,Description,Picture";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"categories.xml"));
        ResultSetExecution excution = this.helpExecute(query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        reader.close();
    }

    @Test
    public void testArrayType() throws Exception {
        ModelMetaData model = new ModelMetaData();
        model.setName("nw");
        model.setModelType(Model.Type.PHYSICAL);
        MetadataFactory mf = new MetadataFactory("northwind", (Object)1, SystemMetadata.getInstance().getRuntimeTypeMap(), model);
        EdmDataServices edm = new EdmxFormatParser().parseMetadata(StaxUtil.newXMLEventReader((Reader)new FileReader(UnitTestUtil.getTestDataFile((String)"arraytest.xml"))));
        ODataMetadataProcessor metadataProcessor = new ODataMetadataProcessor();
        PropertiesUtils.setBeanProperties((Object)metadataProcessor, (Properties)mf.getModelProperties(), (String)"importer");
        metadataProcessor.getMetadata(mf, edm);
        Column c = mf.getSchema().getTable("G2").getColumnByName("e3");
        Assert.assertEquals((Object)"integer[]", (Object)c.getRuntimeType());
        Procedure p = mf.getSchema().getProcedure("ARRAYITERATE");
        Assert.assertEquals((Object)"varbinary[]", (Object)((ProcedureParameter)p.getParameters().get(0)).getRuntimeType());
        Assert.assertEquals((Object)"varbinary", (Object)((Column)p.getResultSet().getColumns().get(0)).getRuntimeType());
        String ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ddl, (String)"northwind", (String)"nw");
        String query = "SELECT * FROM G2";
        String expectedURL = "G2?$select=e1,e3";
        String result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<feed xmlns=\"http://www.w3.org/2005/Atom\" xmlns:d=\"http://schemas.microsoft.com/ado/2007/08/dataservices\" xmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\" xml:base=\"http://localhost:8080/odata/loopy/\">\n   <title type=\"text\">VM1.x</title>\n   <id>http://localhost:8080/odata/loopy/VM1.x</id>\n   <updated>2015-10-14T19:36:58Z</updated>\n   <link rel=\"self\" title=\"VM1.x\" href=\"VM1.x\" />\n   <entry>\n      <id>http://localhost:8080/odata/loopy/VM1.x('x')</id>\n      <title type=\"text\" />\n      <updated>2015-10-14T19:36:58Z</updated>\n      <author>\n         <name />\n      </author>\n      <link rel=\"edit\" title=\"x\" href=\"VM1.x('x')\" />\n      <category term=\"PM1.G2\" scheme=\"http://schemas.microsoft.com/ado/2007/08/dataservices/scheme\" />\n      <content type=\"application/xml\">\n         <m:properties>\n            <d:e1>32</d:e1>\n            <d:e3 m:type=\"Collection(Edm.Int32)\">\n               <d:element>1</d:element>\n               <d:element>2</d:element>\n               <d:element>3</d:element>\n            </d:e3>\n         </m:properties>\n      </content>\n   </entry>\n</feed>";
        ResultSetExecution excution = this.helpExecute(query, result, expectedURL, 200, metadata);
        Assert.assertArrayEquals((Object[])new Object[]{32, new Integer[]{1, 2, 3}}, (Object[])excution.next().toArray(new Object[2]));
    }

    @Test(expected=TranslatorException.class)
    public void testError() throws Exception {
        String query = "SELECT * FROM Categories Where CategoryName = 'Beverages'";
        String expectedURL = "Categories?$filter=CategoryName eq 'Beverages'&$select=Picture,Description,CategoryName,CategoryID";
        String error = "<error xmlns=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\">\n<code>005056A509B11EE1BB8AF4A65EC3CA20</code>\n<message xml:lang=\"en\">\nInvalid parametertype used at function '' (Position: 16)\n</message>\n</error>";
        ResultSetExecution excution = this.helpExecute(query, error, expectedURL, 400);
        excution.next();
    }

    @Test
    public void testNoResults() throws Exception {
        String query = "SELECT * FROM Categories Where CategoryName = 'Beverages'";
        String expectedURL = "Categories?$filter=CategoryName eq 'Beverages'&$select=CategoryID,CategoryName,Description,Picture";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"categories.xml"));
        ResultSetExecution excution = this.helpExecute(query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL, 404);
        excution.execute();
        Assert.assertNull((Object)excution.next());
        reader.close();
        reader = new FileReader(UnitTestUtil.getTestDataFile((String)"categories.xml"));
        excution = this.helpExecute(query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL, 204);
        excution.execute();
        Assert.assertNull((Object)excution.next());
        reader.close();
    }

    @Test
    public void testErrorParsing() {
        String innerError = "<innererror>\n      <transactionid>529E9BFBEDA868F2E1000000AC140C37</transactionid>\n      <errordetails>\n         <errordetail>\n             <code>/IWBEP/CX_MGW_TECH_EXCEPTION</code>\n             <message>Operation 'read feed' not supported for Entity Type 'Notification'.</message>\n              <propertyref></propertyref>\n              <severity>error</severity>\n        </errordetail>\n     </errordetails>\n   </innererror>";
        String error = "<error xmlns=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\">\n   <code>SY/530</code>\n   <message xml:lang=\"en\"> Operation 'read feed' not supported for Entity Type 'Notification'.</message>\n" + innerError + "</error>";
        AtomErrorFormatParser parser = new AtomErrorFormatParser();
        OError oerror = (OError)parser.parse((Reader)new StringReader(error));
        Assert.assertEquals((Object)innerError, (Object)oerror.getInnerError());
    }
}

