/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata.sap;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.odata4j.format.xml.EdmxFormatParser;
import org.odata4j.stax2.util.StaxUtil;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.UDFSource;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.odata.sap.SAPMetadataProcessor;
import org.teiid.translator.odata.sap.SAPODataExecutionFactory;

public class TestSAPODataMetadataProcessor {
    private SAPODataExecutionFactory translator;

    @Test
    public void testSchema() throws Exception {
        this.translator = new SAPODataExecutionFactory();
        this.translator.start();
        String csdl = ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"sap-metadata.xml"));
        SAPMetadataProcessor processor = new SAPMetadataProcessor();
        Properties props = new Properties();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "flight", SystemMetadata.getInstance().getRuntimeTypeMap(), props, null);
        processor.getMetadata(mf, new EdmxFormatParser().parseMetadata(StaxUtil.newXMLEventReader((Reader)new InputStreamReader(new ByteArrayInputStream(csdl.getBytes())))));
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"flight", (FunctionTree[])new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource((Collection)this.translator.getPushDownFunctions()))});
        ValidatorReport report = new MetadataValidator().validate(metadata.getVdbMetaData(), (MetadataStore)metadata.getMetadataStore());
        if (report.hasItems()) {
            throw new RuntimeException(report.getFailureMessage());
        }
        TranslationUtility utility = new TranslationUtility((QueryMetadataInterface)metadata);
        RuntimeMetadata rm = utility.createRuntimeMetadata();
        Table t = rm.getTable("flight", "SubscriptionCollection");
        Assert.assertNotNull((Object)t);
        Assert.assertNotNull((Object)t.getColumnByName("persistNotifications"));
        Assert.assertTrue((!t.getColumnByName("ID").isUpdatable() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Persist Notification", (Object)t.getColumnByName("persistNotifications").getAnnotation());
        Assert.assertEquals((Object)Column.SearchType.Unsearchable, (Object)t.getColumnByName("persistNotifications").getSearchType());
        Assert.assertEquals((Object)Column.SearchType.Unsearchable, (Object)t.getColumnByName("filter").getSearchType());
        Assert.assertEquals((Object)false, (Object)t.getColumnByName("filter").isSelectable());
        Assert.assertEquals((long)1L, (long)t.getAccessPatterns().size());
        Assert.assertEquals((long)2L, (long)((KeyRecord)t.getAccessPatterns().get(0)).getColumns().size());
    }
}

