/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.core4j.Enumerable;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmAssociationSet;
import org.odata4j.edm.EdmAssociationSetEnd;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmFunctionParameter;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmReferentialConstraint;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmType;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.translator.odata.ODataPlugin;
import org.teiid.translator.odata.ODataTypeManager;

public class ODataEntitySchemaBuilder {
    static EdmDataServices buildMetadata(MetadataStore metadataStore) {
        try {
            ArrayList<EdmSchema.Builder> edmSchemas = new ArrayList<EdmSchema.Builder>();
            for (Schema schema : metadataStore.getSchemaList()) {
                ODataEntitySchemaBuilder.buildEntityTypes(schema, edmSchemas, true);
                ODataEntitySchemaBuilder.buildFunctionImports(schema, edmSchemas, true);
                ODataEntitySchemaBuilder.buildAssosiationSets(schema, edmSchemas, true);
            }
            return EdmDataServices.newBuilder().addSchemas(edmSchemas).build();
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    static EdmDataServices buildMetadata(Schema schema) {
        try {
            ArrayList<EdmSchema.Builder> edmSchemas = new ArrayList<EdmSchema.Builder>();
            ODataEntitySchemaBuilder.buildEntityTypes(schema, edmSchemas, true);
            ODataEntitySchemaBuilder.buildFunctionImports(schema, edmSchemas, true);
            ODataEntitySchemaBuilder.buildAssosiationSets(schema, edmSchemas, true);
            return EdmDataServices.newBuilder().addSchemas(edmSchemas).build();
        }
        catch (Exception e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    static EdmEntitySet.Builder findEntitySet(List<EdmSchema.Builder> edmSchemas, String schemaName, String enitityName) {
        for (EdmSchema.Builder modelSchema : edmSchemas) {
            if (!modelSchema.getNamespace().equals(schemaName)) continue;
            for (EdmEntityContainer.Builder entityContainter : modelSchema.getEntityContainers()) {
                for (EdmEntitySet.Builder entitySet : entityContainter.getEntitySets()) {
                    if (!entitySet.getName().equals(enitityName)) continue;
                    return entitySet;
                }
            }
        }
        return null;
    }

    static EdmSchema.Builder findSchema(List<EdmSchema.Builder> edmSchemas, String schemaName) {
        for (EdmSchema.Builder modelSchema : edmSchemas) {
            if (!modelSchema.getNamespace().equals(schemaName)) continue;
            return modelSchema;
        }
        return null;
    }

    static EdmEntityType.Builder findEntityType(List<EdmSchema.Builder> edmSchemas, String schemaName, String enitityName) {
        for (EdmSchema.Builder modelSchema : edmSchemas) {
            if (!modelSchema.getNamespace().equals(schemaName)) continue;
            for (EdmEntityType.Builder type : modelSchema.getEntityTypes()) {
                if (!type.getName().equals(enitityName)) continue;
                return type;
            }
        }
        return null;
    }

    static EdmEntityContainer.Builder findEntityContainer(List<EdmSchema.Builder> edmSchemas, String schemaName) {
        for (EdmSchema.Builder modelSchema : edmSchemas) {
            Iterator iterator;
            if (!modelSchema.getNamespace().equals(schemaName) || !(iterator = modelSchema.getEntityContainers().iterator()).hasNext()) continue;
            EdmEntityContainer.Builder entityContainter = (EdmEntityContainer.Builder)iterator.next();
            return entityContainter;
        }
        return null;
    }

    public static void buildEntityTypes(Schema schema, List<EdmSchema.Builder> edmSchemas, boolean preserveEntityTypeName) {
        EdmProperty.Builder property;
        List uniques;
        KeyRecord primaryKey;
        ArrayList<EdmEntitySet.Builder> entitySets = new ArrayList<EdmEntitySet.Builder>();
        ArrayList<EdmEntityType.Builder> entityTypes = new ArrayList<EdmEntityType.Builder>();
        LinkedHashMap<String, EdmComplexType.Builder> complexTypes = new LinkedHashMap<String, EdmComplexType.Builder>();
        if (preserveEntityTypeName) {
            for (Table table : schema.getTables().values()) {
                primaryKey = table.getPrimaryKey();
                uniques = table.getUniqueKeys();
                if (primaryKey == null && uniques.isEmpty()) {
                    LogManager.logDetail((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17017, new Object[]{table.getFullName()}));
                    continue;
                }
                for (Column c : table.getColumns()) {
                    String complexType;
                    Iterator columnGroup = c.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}ColumnGroup", false);
                    String name = c.getName();
                    if (columnGroup != null) {
                        name = c.getSourceName();
                    }
                    if ((complexType = c.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}ComplexType", false)) == null) continue;
                    EdmComplexType.Builder complexTypeBuilder = (EdmComplexType.Builder)complexTypes.get(complexType);
                    if (complexTypeBuilder == null) {
                        complexTypeBuilder = EdmComplexType.newBuilder();
                        complexTypes.put(complexType, complexTypeBuilder);
                        complexTypeBuilder.setName(complexType);
                        complexTypeBuilder.setNamespace(schema.getName());
                    } else if (complexTypeBuilder.findProperty(name) != null) continue;
                    property = EdmProperty.newBuilder((String)name).setType(ODataTypeManager.odataType(c.getRuntimeType())).setNullable(ODataEntitySchemaBuilder.isPartOfPrimaryKey(table, c.getName()) ? false : c.getNullType() == BaseColumn.NullType.Nullable);
                    if (c.getRuntimeType().equals("string")) {
                        property.setFixedLength(Boolean.valueOf(c.isFixedLength())).setMaxLength(Integer.valueOf(c.getLength())).setUnicode(Boolean.valueOf(true));
                    }
                    complexTypeBuilder.addProperties(new EdmProperty.Builder[]{property});
                }
            }
        }
        for (Table table : schema.getTables().values()) {
            Object c2;
            primaryKey = table.getPrimaryKey();
            uniques = table.getUniqueKeys();
            if (primaryKey == null && uniques.isEmpty()) {
                LogManager.logDetail((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17017, new Object[]{table.getFullName()}));
                continue;
            }
            String entityTypeName = table.getName();
            if (preserveEntityTypeName && table.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}EntityType", false) != null) {
                entityTypeName = table.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}EntityType", false);
            }
            EdmEntityType.Builder entityType = (EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setName(entityTypeName)).setNamespace(schema.getName());
            if (primaryKey != null) {
                for (Object c2 : primaryKey.getColumns()) {
                    entityType.addKeys(new String[]{c2.getName()});
                }
            } else {
                for (Object c2 : ((KeyRecord)uniques.get(0)).getColumns()) {
                    entityType.addKeys(new String[]{c2.getName()});
                }
            }
            HashSet<String> columnGroups = new HashSet<String>();
            c2 = table.getColumns().iterator();
            while (c2.hasNext()) {
                Column c3 = (Column)c2.next();
                String complexType = c3.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}ComplexType", false);
                if (complexType != null && preserveEntityTypeName) {
                    String columnGroup = c3.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}ColumnGroup", false);
                    if (!columnGroups.add(columnGroup)) continue;
                    EdmProperty.Builder property2 = EdmProperty.newBuilder((String)columnGroup).setType((EdmType)((EdmComplexType.Builder)complexTypes.get(complexType)).build());
                    entityType.addProperties(new EdmProperty.Builder[]{property2});
                    continue;
                }
                property = EdmProperty.newBuilder((String)c3.getName()).setType(ODataTypeManager.odataType(c3.getRuntimeType())).setNullable(ODataEntitySchemaBuilder.isPartOfPrimaryKey(table, c3.getName()) ? false : c3.getNullType() == BaseColumn.NullType.Nullable);
                if (c3.getRuntimeType().equals("string")) {
                    property.setFixedLength(Boolean.valueOf(c3.isFixedLength())).setMaxLength(Integer.valueOf(c3.getLength())).setUnicode(Boolean.valueOf(true));
                }
                entityType.addProperties(new EdmProperty.Builder[]{property});
            }
            EdmEntitySet.Builder entitySet = EdmEntitySet.newBuilder().setName(table.getName()).setEntityType(entityType);
            entityType.setNamespace(schema.getName());
            entitySets.add(entitySet);
            entityTypes.add(entityType);
        }
        EdmEntityContainer.Builder entityContainer = EdmEntityContainer.newBuilder().setName(schema.getName()).setIsDefault(false).addEntitySets(entitySets);
        EdmSchema.Builder modelSchema = EdmSchema.newBuilder().setNamespace(schema.getName()).addEntityTypes(entityTypes).addEntityContainers(new EdmEntityContainer.Builder[]{entityContainer}).addComplexTypes(complexTypes.values());
        edmSchemas.add(modelSchema);
    }

    static boolean isPartOfPrimaryKey(Table table, String columnName) {
        KeyRecord pk = table.getPrimaryKey();
        if (ODataEntitySchemaBuilder.hasColumn(pk, columnName)) {
            return true;
        }
        for (KeyRecord key : table.getUniqueKeys()) {
            if (!ODataEntitySchemaBuilder.hasColumn(key, columnName)) continue;
            return true;
        }
        return false;
    }

    static boolean hasColumn(KeyRecord pk, String columnName) {
        if (pk != null) {
            return pk.getColumnByName(columnName) != null;
        }
        return false;
    }

    private static String getEntityTypeName(Table t, boolean preserveEntityTypeName) {
        String entityTypeName = t.getName();
        if (preserveEntityTypeName && t.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}EntityType", false) != null) {
            entityTypeName = t.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}EntityType", false);
        }
        return entityTypeName;
    }

    public static void buildAssosiationSets(Schema schema, List<EdmSchema.Builder> edmSchemas, boolean preserveEntityTypeName) {
        EdmSchema.Builder odataSchema = ODataEntitySchemaBuilder.findSchema(edmSchemas, schema.getName());
        EdmEntityContainer.Builder entityContainer = ODataEntitySchemaBuilder.findEntityContainer(edmSchemas, schema.getName());
        ArrayList<EdmAssociationSet.Builder> assosiationSets = new ArrayList<EdmAssociationSet.Builder>();
        ArrayList<EdmAssociation.Builder> assosiations = new ArrayList<EdmAssociation.Builder>();
        for (Table table : schema.getTables().values()) {
            KeyRecord primaryKey = table.getPrimaryKey();
            List uniques = table.getUniqueKeys();
            if (primaryKey == null && uniques.isEmpty()) continue;
            for (ForeignKey fk : table.getForeignKeys()) {
                String navigationName;
                EdmEntitySet.Builder entitySet = ODataEntitySchemaBuilder.findEntitySet(edmSchemas, schema.getName(), table.getName());
                EdmEntitySet.Builder refEntitySet = ODataEntitySchemaBuilder.findEntitySet(edmSchemas, schema.getName(), fk.getReferenceTableName());
                EdmEntityType.Builder entityType = ODataEntitySchemaBuilder.findEntityType(edmSchemas, schema.getName(), ODataEntitySchemaBuilder.getEntityTypeName(table, preserveEntityTypeName));
                EdmEntityType.Builder refEntityType = ODataEntitySchemaBuilder.findEntityType(edmSchemas, schema.getName(), ODataEntitySchemaBuilder.getEntityTypeName((Table)fk.getPrimaryKey().getParent(), preserveEntityTypeName));
                boolean onetoone = ODataEntitySchemaBuilder.sameColumnSet(table.getPrimaryKey(), (KeyRecord)fk);
                EdmAssociationEnd.Builder endSelf = EdmAssociationEnd.newBuilder().setRole(table.getName()).setType(entityType).setMultiplicity(onetoone ? EdmMultiplicity.ZERO_TO_ONE : EdmMultiplicity.MANY);
                EdmAssociationEnd.Builder endRef = EdmAssociationEnd.newBuilder().setRole(fk.getReferenceTableName()).setType(refEntityType).setMultiplicity(EdmMultiplicity.ZERO_TO_ONE);
                EdmAssociation.Builder association = EdmAssociation.newBuilder();
                association.setName(table.getName() + "_" + fk.getName());
                association.setEnds(endSelf, endRef);
                association.setNamespace(refEntityType.getFullyQualifiedTypeName().substring(0, refEntityType.getFullyQualifiedTypeName().indexOf(46)));
                assosiations.add(association);
                if (fk.getReferenceColumns() != null) {
                    EdmReferentialConstraint.Builder erc = EdmReferentialConstraint.newBuilder();
                    erc.setPrincipalRole(fk.getReferenceTableName());
                    erc.addPrincipalReferences(fk.getReferenceColumns());
                    erc.setDependentRole(table.getName());
                    erc.addDependentReferences(ODataEntitySchemaBuilder.getColumnNames(fk.getColumns()));
                    association.setRefConstraint(erc);
                }
                if (!fk.getReferenceTableName().equalsIgnoreCase(table.getName())) {
                    navigationName = ODataEntitySchemaBuilder.getNavigationName(entityType, fk.getReferenceTableName());
                    EdmNavigationProperty.Builder nav = EdmNavigationProperty.newBuilder((String)navigationName);
                    nav.setRelationshipName(fk.getName());
                    nav.setFromToName(table.getName(), fk.getReferenceTableName());
                    nav.setRelationship(association);
                    nav.setFromTo(endSelf, endRef);
                    entityType.addNavigationProperties(new EdmNavigationProperty.Builder[]{nav});
                }
                navigationName = ODataEntitySchemaBuilder.getNavigationName(refEntityType, table.getName());
                EdmNavigationProperty.Builder refNav = EdmNavigationProperty.newBuilder((String)navigationName);
                refNav.setRelationshipName(fk.getName());
                refNav.setFromToName(fk.getReferenceTableName(), table.getName());
                refNav.setRelationship(association);
                refNav.setFromTo(endRef, endSelf);
                refEntityType.addNavigationProperties(new EdmNavigationProperty.Builder[]{refNav});
                EdmAssociationSet.Builder assosiationSet = EdmAssociationSet.newBuilder().setName(table.getName() + "_" + fk.getName()).setAssociationName(fk.getName());
                EdmAssociationSetEnd.Builder endOne = EdmAssociationSetEnd.newBuilder().setEntitySet(entitySet).setRoleName(table.getName()).setRole(EdmAssociationEnd.newBuilder().setType(entityType).setRole(entityType.getName()));
                EdmAssociationSetEnd.Builder endTwo = EdmAssociationSetEnd.newBuilder().setEntitySet(refEntitySet).setRoleName(fk.getReferenceTableName()).setRole(EdmAssociationEnd.newBuilder().setType(refEntityType).setRole(refEntityType.getName()));
                assosiationSet.setEnds(endOne, endTwo);
                assosiationSet.setAssociation(association);
                assosiationSets.add(assosiationSet);
            }
        }
        entityContainer.addAssociationSets(assosiationSets);
        odataSchema.addAssociations(assosiations);
    }

    private static String getNavigationName(EdmEntityType.Builder entityType, String tableName) {
        String navigationName = tableName;
        int i = 1;
        while (true) {
            for (EdmNavigationProperty.Builder b : entityType.getNavigationProperties()) {
                if (!b.getName().equals(navigationName)) continue;
                navigationName = null;
                break;
            }
            if (navigationName != null) {
                return navigationName;
            }
            navigationName = tableName + i++;
        }
    }

    public static void buildFunctionImports(Schema schema, List<EdmSchema.Builder> edmSchemas, boolean preserveEntityTypeName) {
        EdmSchema.Builder odataSchema = ODataEntitySchemaBuilder.findSchema(edmSchemas, schema.getName());
        EdmEntityContainer.Builder entityContainer = ODataEntitySchemaBuilder.findEntityContainer(edmSchemas, schema.getName());
        for (Procedure proc : schema.getProcedures().values()) {
            EdmFunctionImport.Builder edmProcedure = EdmFunctionImport.newBuilder();
            edmProcedure.setName(proc.getName());
            String httpMethod = "POST";
            for (ProcedureParameter pp : proc.getParameters()) {
                if (pp.getName().equals("return")) {
                    httpMethod = "GET";
                    edmProcedure.setReturnType(ODataTypeManager.odataType(pp.getRuntimeType()));
                    continue;
                }
                EdmFunctionParameter.Builder param = EdmFunctionParameter.newBuilder();
                param.setName(pp.getName());
                param.setType(ODataTypeManager.odataType(pp.getRuntimeType()));
                if (pp.getType() == ProcedureParameter.Type.In) {
                    param.setMode(EdmFunctionParameter.Mode.In);
                } else if (pp.getType() == ProcedureParameter.Type.InOut) {
                    param.setMode(EdmFunctionParameter.Mode.InOut);
                } else if (pp.getType() == ProcedureParameter.Type.Out) {
                    param.setMode(EdmFunctionParameter.Mode.Out);
                }
                param.setNullable(Boolean.valueOf(pp.getNullType() == BaseColumn.NullType.Nullable));
                edmProcedure.addParameters(new EdmFunctionParameter.Builder[]{param});
            }
            ColumnSet returnColumns = proc.getResultSet();
            if (returnColumns != null) {
                httpMethod = "GET";
                EdmComplexType.Builder complexType = EdmComplexType.newBuilder();
                String entityTypeName = proc.getName() + "_" + returnColumns.getName();
                if (preserveEntityTypeName && proc.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}EntityType", false) != null) {
                    entityTypeName = proc.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}EntityType", false);
                }
                complexType.setName(entityTypeName);
                complexType.setNamespace(schema.getName());
                for (Column c : returnColumns.getColumns()) {
                    EdmProperty.Builder property = EdmProperty.newBuilder((String)c.getName()).setType(ODataTypeManager.odataType(c.getRuntimeType())).setNullable(c.getNullType() == BaseColumn.NullType.Nullable);
                    if (c.getRuntimeType().equals("string")) {
                        property.setFixedLength(Boolean.valueOf(c.isFixedLength())).setMaxLength(Integer.valueOf(c.getLength())).setUnicode(Boolean.valueOf(true));
                    }
                    complexType.addProperties(new EdmProperty.Builder[]{property});
                }
                odataSchema.addComplexTypes(new EdmComplexType.Builder[]{complexType});
                edmProcedure.setIsCollection(true);
                edmProcedure.setReturnType((EdmType.Builder)EdmCollectionType.newBuilder().setCollectionType((EdmType.Builder)complexType).setKind(EdmProperty.CollectionKind.Collection));
            }
            edmProcedure.setHttpMethod(httpMethod);
            entityContainer.addFunctionImports(new EdmFunctionImport.Builder[]{edmProcedure});
        }
    }

    static List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (Column c : columns) {
            names.add(c.getName());
        }
        return names;
    }

    static boolean sameColumnSet(KeyRecord recordOne, KeyRecord recordTwo) {
        if (recordOne == null || recordTwo == null) {
            return false;
        }
        List setOne = recordOne.getColumns();
        List setTwo = recordTwo.getColumns();
        if (setOne.size() != setTwo.size()) {
            return false;
        }
        for (int i = 0; i < setOne.size(); ++i) {
            Column one = (Column)setOne.get(i);
            Column two = (Column)setTwo.get(i);
            if (one.getName().equals(two.getName())) continue;
            return false;
        }
        return true;
    }

    static EdmEntitySet removeModelName(EdmEntitySet src) {
        EdmEntityType srcType = src.getType();
        String schemaName = srcType.getName().substring(0, srcType.getName().indexOf(46));
        String name = srcType.getName().substring(srcType.getName().indexOf(46) + 1);
        EdmEntityType.Builder targetType = (EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().setName(name)).setNamespace(schemaName);
        targetType.addKeys(srcType.getKeys());
        Enumerable properties = srcType.getProperties();
        for (EdmProperty srcProperty : properties.toList()) {
            EdmProperty.Builder tgtProperty = EdmProperty.newBuilder((String)srcProperty.getName()).setType(srcProperty.getType()).setNullable(srcProperty.isNullable()).setFixedLength(srcProperty.getFixedLength()).setMaxLength(srcProperty.getMaxLength()).setUnicode(Boolean.valueOf(true));
            targetType.addProperties(new EdmProperty.Builder[]{tgtProperty});
        }
        EdmEntitySet.Builder target = EdmEntitySet.newBuilder().setName(src.getName()).setEntityType(targetType);
        return target.build();
    }
}

