/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.lang.reflect.Array;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.resource.cci.ConnectionFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.odata4j.core.OCollection;
import org.odata4j.core.OSimpleObject;
import org.odata4j.core.UnsignedByte;
import org.odata4j.internal.InternalUtil;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.StringUtil;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.Literal;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.WSConnection;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.odata.ODataMetadataProcessor;
import org.teiid.translator.odata.ODataPlugin;
import org.teiid.translator.odata.ODataProcedureExecution;
import org.teiid.translator.odata.ODataQueryExecution;
import org.teiid.translator.odata.ODataUpdateExecution;

@Translator(name="odata", description="A translator for making OData data service calls")
public class ODataExecutionFactory
extends ExecutionFactory<ConnectionFactory, WSConnection> {
    public static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    static final String INVOKE_HTTP = "invokeHttp";
    protected Map<String, FunctionModifier> functionModifiers = new TreeMap<String, FunctionModifier>(String.CASE_INSENSITIVE_ORDER);
    private String databaseTimeZone;
    private TimeZone timeZone = DEFAULT_TIME_ZONE;
    private boolean supportsOdataFilter;
    private boolean supportsOdataOrderBy;
    private boolean supportsOdataCount;
    private boolean supportsOdataSkip;
    private boolean supportsOdataTop;
    private boolean supportsOdataBooleanFunctionsWithComparison;

    public ODataExecutionFactory() {
        this.setSourceRequiredForMetadata(true);
        this.setSupportsOrderBy(true);
        this.setSupportsOdataCount(true);
        this.setSupportsOdataFilter(true);
        this.setSupportsOdataOrderBy(true);
        this.setSupportsOdataSkip(true);
        this.setSupportsOdataTop(true);
        this.setSupportsOdataBooleanFunctionsWithComparison(true);
        this.setTransactionSupport(ExecutionFactory.TransactionSupport.NONE);
        this.registerFunctionModifier("convert", (FunctionModifier)new AliasModifier("cast"));
        this.registerFunctionModifier("locate", new FunctionModifier(){

            public List<?> translate(Function function) {
                function.setName("+");
                Expression param1 = (Expression)function.getParameters().get(0);
                Expression param2 = (Expression)function.getParameters().get(1);
                Function indexOf = new Function("indexof", Arrays.asList(param2, param1), TypeFacility.RUNTIME_TYPES.INTEGER);
                indexOf.setMetadataObject(function.getMetadataObject());
                function.getParameters().set(0, indexOf);
                function.getParameters().set(1, new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER));
                return null;
            }
        });
        this.registerFunctionModifier("substring", new FunctionModifier(){

            public List<?> translate(Function function) {
                if (function.getParameters().size() != 3) {
                    return null;
                }
                Expression param2 = (Expression)function.getParameters().get(1);
                param2 = new Function("+", Arrays.asList(param2, new Literal((Object)1, TypeFacility.RUNTIME_TYPES.INTEGER)), TypeFacility.RUNTIME_TYPES.INTEGER);
                function.getParameters().set(1, param2);
                return null;
            }
        });
        this.registerFunctionModifier("lcase", (FunctionModifier)new AliasModifier("tolower"));
        this.registerFunctionModifier("ucase", (FunctionModifier)new AliasModifier("toupper"));
        this.registerFunctionModifier("dayofmonth", (FunctionModifier)new AliasModifier("day"));
        this.addPushDownFunction("odata", "startswith", "boolean", new String[]{"string", "string"});
        this.addPushDownFunction("odata", "substringof", "boolean", new String[]{"string", "string"});
    }

    public void start() throws TranslatorException {
        TimeZone tz;
        super.start();
        if (this.databaseTimeZone != null && this.databaseTimeZone.trim().length() > 0 && !DEFAULT_TIME_ZONE.hasSameRules(tz = TimeZone.getTimeZone(this.databaseTimeZone))) {
            this.timeZone = tz;
        }
    }

    @TranslatorProperty(display="Database time zone", description="Time zone of the database, if different than Integration Server", advanced=true)
    public String getDatabaseTimeZone() {
        return this.databaseTimeZone;
    }

    public void setDatabaseTimeZone(String databaseTimeZone) {
        this.databaseTimeZone = databaseTimeZone;
    }

    public void getMetadata(MetadataFactory metadataFactory, WSConnection conn) throws TranslatorException {
        ODataMetadataProcessor metadataProcessor = (ODataMetadataProcessor)this.getMetadataProcessor();
        PropertiesUtils.setBeanProperties((Object)metadataProcessor, (Properties)metadataFactory.getModelProperties(), (String)"importer");
        metadataProcessor.setExecutionfactory(this);
        metadataProcessor.process(metadataFactory, conn);
    }

    public MetadataProcessor<WSConnection> getMetadataProcessor() {
        return new ODataMetadataProcessor();
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        return new ODataQueryExecution(this, command, executionContext, metadata, connection);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        String nativeQuery = command.getMetadataObject().getProperty("{http://www.teiid.org/ext/relational/2012}native-query", false);
        if (nativeQuery != null) {
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17014, new Object[0]));
        }
        return new ODataProcedureExecution(command, this, executionContext, metadata, connection);
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        return new ODataUpdateExecution(command, this, executionContext, metadata, connection);
    }

    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(this.getDefaultSupportedFunctions());
        supportedFunctions.add("endswith");
        supportedFunctions.add("replace");
        supportedFunctions.add("trim");
        supportedFunctions.add("substring");
        supportedFunctions.add("concat");
        supportedFunctions.add("length");
        supportedFunctions.add("year");
        supportedFunctions.add("month");
        supportedFunctions.add("hour");
        supportedFunctions.add("minute");
        supportedFunctions.add("second");
        supportedFunctions.add("round");
        supportedFunctions.add("floor");
        supportedFunctions.add("ceiling");
        return supportedFunctions;
    }

    public Map<String, FunctionModifier> getFunctionModifiers() {
        return this.functionModifiers;
    }

    public void registerFunctionModifier(String name, FunctionModifier modifier) {
        this.functionModifiers.put(name, modifier);
    }

    public List<String> getDefaultSupportedFunctions() {
        return Arrays.asList("+", "-", "*", "/");
    }

    @TranslatorProperty(display="Supports $Filter", description="True, $filter is supported", advanced=true)
    public boolean supportsOdataFilter() {
        return this.supportsOdataFilter;
    }

    public void setSupportsOdataFilter(boolean supports) {
        this.supportsOdataFilter = supports;
    }

    @TranslatorProperty(display="Supports $OrderBy", description="True, $orderby is supported", advanced=true)
    public boolean supportsOdataOrderBy() {
        return this.supportsOdataOrderBy;
    }

    public void setSupportsOdataOrderBy(boolean supports) {
        this.supportsOdataOrderBy = supports;
    }

    @TranslatorProperty(display="Supports $count", description="True, $count is supported", advanced=true)
    public boolean supportsOdataCount() {
        return this.supportsOdataCount;
    }

    public void setSupportsOdataCount(boolean supports) {
        this.supportsOdataCount = supports;
    }

    @TranslatorProperty(display="Supports $skip", description="True, $skip is supported", advanced=true)
    public boolean supportsOdataSkip() {
        return this.supportsOdataSkip;
    }

    public void setSupportsOdataSkip(boolean supports) {
        this.supportsOdataSkip = supports;
    }

    @TranslatorProperty(display="Supports $top", description="True, $top is supported", advanced=true)
    public boolean supportsOdataTop() {
        return this.supportsOdataTop;
    }

    public void setSupportsOdataTop(boolean supports) {
        this.supportsOdataTop = supports;
    }

    @TranslatorProperty(display="Supports boolean functions with comparison", description="True, you can use 'substringsof(a, b) eq true' for instance", advanced=true)
    public boolean supportsOdataBooleanFunctionsWithComparison() {
        return this.supportsOdataBooleanFunctionsWithComparison;
    }

    public void setSupportsOdataBooleanFunctionsWithComparison(boolean supports) {
        this.supportsOdataBooleanFunctionsWithComparison = supports;
    }

    public boolean supportsCompareCriteriaEquals() {
        return this.supportsOdataFilter;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return this.supportsOdataFilter;
    }

    public boolean supportsIsNullCriteria() {
        return this.supportsOdataFilter;
    }

    public boolean supportsOrCriteria() {
        return this.supportsOdataFilter;
    }

    public boolean supportsNotCriteria() {
        return this.supportsOdataFilter;
    }

    public boolean supportsQuantifiedCompareCriteriaSome() {
        return false;
    }

    public boolean supportsQuantifiedCompareCriteriaAll() {
        return false;
    }

    @TranslatorProperty(display="Supports ORDER BY", description="True, if this connector supports ORDER BY", advanced=true)
    public boolean supportsOrderBy() {
        return this.supportsOdataOrderBy;
    }

    public boolean supportsOrderByUnrelated() {
        return this.supportsOdataOrderBy;
    }

    public boolean supportsAggregatesCount() {
        return this.supportsOdataCount;
    }

    public boolean supportsAggregatesCountStar() {
        return this.supportsOdataCount;
    }

    public boolean supportsRowLimit() {
        return this.supportsOdataTop;
    }

    public boolean supportsRowOffset() {
        return this.supportsOdataSkip;
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public boolean useAnsiJoin() {
        return true;
    }

    public Object retrieveValue(Object value, Class<?> expectedType) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDateTime) {
            DateTime dateTime = ((LocalDateTime)value).toDateTime(DateTimeZone.forTimeZone((TimeZone)this.timeZone));
            return new Timestamp(dateTime.getMillis());
        }
        if (value instanceof LocalTime) {
            return new Timestamp(((LocalTime)value).toDateTimeToday().getMillis());
        }
        if (value instanceof UnsignedByte) {
            return ((UnsignedByte)value).shortValue();
        }
        if (expectedType.isArray() && value instanceof OCollection) {
            ArrayList<Object> result = new ArrayList<Object>();
            OCollection arrayValues = (OCollection)value;
            for (OSimpleObject item : arrayValues) {
                result.add(this.retrieveValue(item.getValue(), expectedType.getComponentType()));
            }
            Object target = Array.newInstance(expectedType.getComponentType(), result.size());
            System.arraycopy(result.toArray(), 0, target, 0, result.size());
            value = target;
        }
        return value;
    }

    public void convertToODataInput(Literal obj, StringBuilder sb) {
        if (obj.getValue() == null) {
            sb.append("NULL");
        } else {
            Class type = obj.getType();
            Object val = obj.getValue();
            if (Number.class.isAssignableFrom(type)) {
                sb.append(val);
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
                sb.append(obj.getValue().equals(Boolean.TRUE));
            } else if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
                LocalDateTime date = new LocalDateTime(val);
                sb.append("datetime'").append(InternalUtil.formatDateTimeForXml((LocalDateTime)date)).append("'");
            } else if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
                LocalTime time = new LocalTime(((Time)val).getTime());
                sb.append("time'").append(InternalUtil.formatTimeForXml((LocalTime)time)).append("'");
            } else if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
                sb.append("date'").append(val).append("'");
            } else if (type.equals(DataTypeManager.DefaultDataClasses.VARBINARY)) {
                sb.append("X'").append(val).append("'");
            } else {
                sb.append("'").append(this.escapeString(val.toString(), "'")).append("'");
            }
        }
    }

    protected String escapeString(String str, String quote) {
        return StringUtil.replaceAll((String)str, (String)quote, (String)(quote + quote));
    }
}

