/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.ws.rs.core.Response;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmFunctionParameter;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmReferentialConstraint;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.format.xml.EdmxFormatParser;
import org.odata4j.stax2.util.StaxUtil;
import org.teiid.core.BundleUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.WSConnection;
import org.teiid.translator.odata.BaseQueryExecution;
import org.teiid.translator.odata.ODataExecutionFactory;
import org.teiid.translator.odata.ODataPlugin;
import org.teiid.translator.odata.ODataTypeManager;
import org.teiid.translator.ws.BinaryWSProcedureExecution;

public class ODataMetadataProcessor
implements MetadataProcessor<WSConnection> {
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=String.class, display="Link Tables", description="Used to define navigation relationship in many to many case")
    public static final String LINK_TABLES = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}LinkTables";
    @ExtensionMetadataProperty(applicable={Procedure.class}, datatype=String.class, display="Http Method", description="Http method used for procedure invocation", required=true)
    public static final String HTTP_METHOD = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}HttpMethod";
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=Boolean.class, display="Join Column", description="On Link tables this property defines the join column")
    public static final String JOIN_COLUMN = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}JoinColumn";
    @ExtensionMetadataProperty(applicable={Table.class, Procedure.class}, datatype=String.class, display="Entity Type Name", description="Name of the Entity Type in EDM", required=true)
    public static final String ENTITY_TYPE = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}EntityType";
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=String.class, display="Complex Type Name", description="Name of the Complex Type in EDM")
    public static final String COMPLEX_TYPE = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}ComplexType";
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=String.class, display="Column Group", description="Name of the Column Group")
    public static final String COLUMN_GROUP = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}ColumnGroup";
    private String entityContainer;
    private String schemaNamespace;
    private ODataExecutionFactory ef;

    public void setExecutionfactory(ODataExecutionFactory ef) {
        this.ef = ef;
    }

    private EdmDataServices getEds(WSConnection conn) throws TranslatorException {
        try {
            BaseQueryExecution execution = new BaseQueryExecution(this.ef, null, null, conn);
            BinaryWSProcedureExecution call = execution.executeDirect("GET", "$metadata", null, execution.getDefaultHeaders());
            if (call.getResponseCode() != Response.Status.OK.getStatusCode()) {
                throw execution.buildError(call);
            }
            Blob out = (Blob)call.getOutputParameterValues().get(0);
            EdmDataServices eds = new EdmxFormatParser().parseMetadata(StaxUtil.newXMLEventReader((Reader)new InputStreamReader(out.getBinaryStream())));
            return eds;
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (Exception e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public void process(MetadataFactory mf, WSConnection conn) throws TranslatorException {
        EdmDataServices eds = this.getEds(conn);
        this.getMetadata(mf, eds);
    }

    public void getMetadata(MetadataFactory mf, EdmDataServices eds) throws TranslatorException {
        for (EdmSchema schema : eds.getSchemas()) {
            if (this.schemaNamespace != null && !this.schemaNamespace.equalsIgnoreCase(schema.getNamespace())) continue;
            for (EdmEntityContainer container : schema.getEntityContainers()) {
                if ((this.entityContainer == null || !this.entityContainer.equalsIgnoreCase(container.getName())) && !container.isDefault()) continue;
                for (EdmEntitySet entitySet : container.getEntitySets()) {
                    this.addEntitySetAsTable(mf, entitySet);
                }
                for (EdmEntitySet entitySet : container.getEntitySets()) {
                    this.addNavigationRelations(mf, entitySet.getName(), entitySet.getType());
                }
                for (EdmFunctionImport function : container.getFunctionImports()) {
                    this.addFunctionImportAsProcedure(mf, function);
                }
            }
        }
    }

    protected Table buildTable(MetadataFactory mf, EdmEntitySet entitySet) {
        Table table = mf.addTable(entitySet.getName());
        table.setSupportsUpdate(true);
        return table;
    }

    protected Table addEntitySetAsTable(MetadataFactory mf, EdmEntitySet entitySet) throws TranslatorException {
        Table table = this.buildTable(mf, entitySet);
        table.setProperty(ENTITY_TYPE, entitySet.getType().getFullyQualifiedTypeName());
        for (EdmProperty ep : entitySet.getType().getProperties().toList()) {
            if (ep.getType().isSimple() || ep.getType() instanceof EdmCollectionType && ((EdmCollectionType)ep.getType()).getItemType().isSimple()) {
                this.addPropertyAsColumn(mf, table, ep, entitySet);
                continue;
            }
            EdmComplexType embedded = (EdmComplexType)ep.getType();
            for (EdmProperty property : embedded.getProperties().toList()) {
                if (property.getType().isSimple() || property.getType() instanceof EdmCollectionType && ((EdmCollectionType)property.getType()).getItemType().isSimple()) {
                    Column column = this.addPropertyAsColumn(mf, table, property, entitySet, ep.getName());
                    column.setProperty(COMPLEX_TYPE, embedded.getFullyQualifiedTypeName());
                    column.setProperty(COLUMN_GROUP, ep.getName());
                    continue;
                }
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17002, new Object[]{entitySet.getName(), ep.getName()}));
            }
        }
        mf.addPrimaryKey("PK", entitySet.getType().getKeys(), table);
        return table;
    }

    void addNavigationRelations(MetadataFactory mf, String tableName, EdmEntityType fromEntity) throws TranslatorException {
        Table fromTable = mf.getSchema().getTable(tableName);
        for (EdmNavigationProperty nav : fromEntity.getNavigationProperties()) {
            EdmAssociation association = nav.getRelationship();
            EdmAssociationEnd fromEnd = nav.getFromRole();
            EdmAssociationEnd toEnd = nav.getToRole();
            EdmEntityType toEntity = toEnd.getType();
            if (this.same(fromEntity, toEntity)) continue;
            Table toTable = mf.getSchema().getTable(nav.getName());
            if (toTable == null) {
                toTable = this.getEntityTable(mf, toEntity);
            }
            if (this.isMultiplicityMany(fromEnd) && this.isMultiplicityMany(toEnd)) {
                if (mf.getSchema().getTable(association.getName()) != null) continue;
                Table linkTable = mf.addTable(association.getName());
                linkTable.setProperty(ENTITY_TYPE, "LinkTable");
                linkTable.setProperty(LINK_TABLES, fromTable.getName() + "," + toTable.getName());
                List<String> leftNames = null;
                if (association.getRefConstraint() != null) {
                    leftNames = association.getRefConstraint().getPrincipalReferences();
                }
                leftNames = this.addLinkTableColumns(mf, fromTable, leftNames, linkTable);
                List<String> rightNames = null;
                if (association.getRefConstraint() != null) {
                    rightNames = association.getRefConstraint().getDependentReferences();
                }
                rightNames = this.addLinkTableColumns(mf, toTable, rightNames, linkTable);
                ArrayList<String> allKeys = new ArrayList<String>();
                for (Column c : linkTable.getColumns()) {
                    allKeys.add(c.getName());
                }
                mf.addPrimaryKey("PK", allKeys, linkTable);
                mf.addForeignKey(fromTable.getName() + "_FK", leftNames, fromTable.getName(), linkTable);
                mf.addForeignKey(toTable.getName() + "_FK", rightNames, toTable.getName(), linkTable);
                continue;
            }
            if (!this.isMultiplicityOne(fromEnd)) continue;
            this.addRelation(mf, fromTable, toTable, association, fromEnd.getRole());
        }
    }

    private List<String> addLinkTableColumns(MetadataFactory mf, Table table, List<String> columnNames, Table linkTable) throws TranslatorException {
        if (columnNames != null) {
            for (String columnName : columnNames) {
                Column column = table.getColumnByName(columnName);
                if (column == null) {
                    throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17003, new Object[]{columnName, table.getName()}));
                }
                column = mf.addColumn(column.getName(), column.getRuntimeType(), (ColumnSet)linkTable);
                column.setProperty(JOIN_COLUMN, String.valueOf(true));
            }
        } else {
            columnNames = new ArrayList<String>();
            for (Column column : table.getPrimaryKey().getColumns()) {
                columnNames.add(column.getName());
                if (linkTable.getColumnByName(column.getName()) == null) {
                    column = mf.addColumn(column.getName(), column.getRuntimeType(), (ColumnSet)linkTable);
                }
                column.setProperty(JOIN_COLUMN, String.valueOf(true));
            }
        }
        return columnNames;
    }

    private boolean isMultiplicityOne(EdmAssociationEnd end) {
        return end.getMultiplicity().equals((Object)EdmMultiplicity.ONE) || end.getMultiplicity().equals((Object)EdmMultiplicity.ZERO_TO_ONE);
    }

    private boolean isMultiplicityMany(EdmAssociationEnd end) {
        return end.getMultiplicity().equals((Object)EdmMultiplicity.MANY);
    }

    private Table getEntityTable(MetadataFactory mf, EdmEntityType toEntity) throws TranslatorException {
        for (Table t : mf.getSchema().getTables().values()) {
            if (!t.getProperty(ENTITY_TYPE, false).equals(toEntity.getFullyQualifiedTypeName())) continue;
            return t;
        }
        throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17004, new Object[]{toEntity.getFullyQualifiedTypeName()}));
    }

    boolean same(EdmEntityType x, EdmEntityType y) {
        return x.getFullyQualifiedTypeName().equalsIgnoreCase(y.getFullyQualifiedTypeName());
    }

    private void addRelation(MetadataFactory mf, Table fromTable, Table toTable, EdmAssociation association, String primaryRole) {
        EdmReferentialConstraint refConstaint = association.getRefConstraint();
        if (refConstaint != null) {
            List fromKeys = null;
            List toKeys = null;
            if (refConstaint.getPrincipalRole().equals(primaryRole)) {
                fromKeys = refConstaint.getPrincipalReferences();
                toKeys = refConstaint.getDependentReferences();
            } else {
                fromKeys = refConstaint.getDependentReferences();
                toKeys = refConstaint.getPrincipalReferences();
            }
            if (this.matchesWithPkOrUnique(fromKeys, fromTable)) {
                mf.addForeignKey(association.getName(), toKeys, fromKeys, fromTable.getName(), toTable);
            } else {
                LogManager.logWarning((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17015, new Object[]{association.getName(), toTable.getName(), fromTable.getName()}));
            }
        } else {
            ArrayList<String> fromKeys = new ArrayList<String>();
            for (Column column : fromTable.getPrimaryKey().getColumns()) {
                fromKeys.add(column.getName());
            }
            if (this.hasColumns(fromKeys, toTable)) {
                mf.addForeignKey(association.getName(), fromKeys, fromTable.getName(), toTable);
            } else {
                LogManager.logWarning((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17015, new Object[]{association.getName(), toTable.getName(), fromTable.getName()}));
            }
        }
    }

    private boolean hasColumns(List<String> columnNames, Table table) {
        for (String columnName : columnNames) {
            if (table.getColumnByName(columnName) != null) continue;
            return false;
        }
        return true;
    }

    boolean keyMatches(List<String> names, KeyRecord record) {
        if (names.size() != record.getColumns().size()) {
            return false;
        }
        TreeSet<String> keyNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Column c : record.getColumns()) {
            keyNames.add(c.getName());
        }
        for (int i = 0; i < names.size(); ++i) {
            if (keyNames.contains(names.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matchesWithPkOrUnique(List<String> names, Table table) {
        if (this.keyMatches(names, table.getPrimaryKey())) {
            return true;
        }
        for (KeyRecord record : table.getUniqueKeys()) {
            if (!this.keyMatches(names, record)) continue;
            return true;
        }
        return false;
    }

    private Column addPropertyAsColumn(MetadataFactory mf, Table table, EdmProperty ep, EdmEntitySet entitySet) {
        return this.addPropertyAsColumn(mf, table, ep, entitySet, null);
    }

    private Column addPropertyAsColumn(MetadataFactory mf, Table table, EdmProperty ep, EdmEntitySet entitySet, String prefix) {
        Column c = this.buildColumn(mf, table, ep, entitySet, prefix);
        if (ep.getFixedLength() != null) {
            c.setFixedLength(ep.getFixedLength().booleanValue());
        }
        c.setNullType(ep.isNullable() ? BaseColumn.NullType.Nullable : BaseColumn.NullType.No_Nulls);
        if (ep.getMaxLength() != null) {
            c.setLength(ep.getMaxLength().intValue());
        }
        return c;
    }

    protected Column buildColumn(MetadataFactory mf, Table table, EdmProperty ep, EdmEntitySet entitySet, String prefix) {
        String columnName = ep.getName();
        if (prefix != null) {
            columnName = prefix + "_" + columnName;
        }
        Column c = mf.addColumn(columnName, ODataTypeManager.teiidType(ep.getType().getFullyQualifiedTypeName()), (ColumnSet)table);
        c.setNameInSource(ep.getName());
        c.setUpdatable(true);
        return c;
    }

    void addFunctionImportAsProcedure(MetadataFactory mf, EdmFunctionImport function) throws TranslatorException {
        Procedure procedure = mf.addProcedure(function.getName());
        procedure.setProperty(HTTP_METHOD, function.getHttpMethod());
        for (EdmFunctionParameter fp : function.getParameters()) {
            ProcedureParameter.Type type = ProcedureParameter.Type.In;
            if (fp.getMode().equals((Object)EdmFunctionParameter.Mode.InOut)) {
                type = ProcedureParameter.Type.InOut;
            } else if (fp.getMode().equals((Object)EdmFunctionParameter.Mode.Out)) {
                type = ProcedureParameter.Type.Out;
            }
            mf.addProcedureParameter(fp.getName(), ODataTypeManager.teiidType(fp.getType().getFullyQualifiedTypeName()), type, procedure);
        }
        EdmType returnType = function.getReturnType();
        if (returnType != null) {
            if (returnType.isSimple()) {
                mf.addProcedureParameter("return", ODataTypeManager.teiidType(((EdmSimpleType)returnType).getFullyQualifiedTypeName()), ProcedureParameter.Type.ReturnValue, procedure);
            } else if (returnType instanceof EdmComplexType) {
                procedure.setProperty(ENTITY_TYPE, function.getReturnType().getFullyQualifiedTypeName());
                this.addProcedureTableReturn(mf, procedure, returnType);
            } else if (returnType instanceof EdmEntityType) {
                procedure.setProperty(ENTITY_TYPE, function.getReturnType().getFullyQualifiedTypeName());
                this.addProcedureTableReturn(mf, procedure, returnType);
            } else if (returnType instanceof EdmCollectionType) {
                procedure.setProperty(ENTITY_TYPE, ((EdmCollectionType)returnType).getItemType().getFullyQualifiedTypeName());
                this.addProcedureTableReturn(mf, procedure, ((EdmCollectionType)returnType).getItemType());
            } else {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17005, new Object[]{function.getName(), returnType.getFullyQualifiedTypeName()}));
            }
        }
    }

    private void addProcedureTableReturn(MetadataFactory mf, Procedure procedure, EdmType type) throws TranslatorException {
        if (type.isSimple()) {
            mf.addProcedureResultSetColumn("return", ODataTypeManager.teiidType(((EdmSimpleType)type).getFullyQualifiedTypeName()), procedure);
        } else if (type instanceof EdmComplexType) {
            EdmComplexType complexType = (EdmComplexType)type;
            for (EdmProperty ep : complexType.getProperties()) {
                if (ep.getType().isSimple()) {
                    mf.addProcedureResultSetColumn(ep.getName(), ODataTypeManager.teiidType(ep.getType().getFullyQualifiedTypeName()), procedure);
                    continue;
                }
                this.addProcedureTableReturn(mf, procedure, ep.getType());
            }
        } else if (type instanceof EdmEntityType) {
            Table table = this.getEntityTable(mf, (EdmEntityType)type);
            for (Column column : table.getColumns()) {
                mf.addProcedureResultSetColumn(column.getName(), column.getRuntimeType(), procedure);
            }
        } else {
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17005, new Object[]{procedure.getName(), type.getFullyQualifiedTypeName()}));
        }
    }

    public void setEntityContainer(String entityContainer) {
        this.entityContainer = entityContainer;
    }

    public void setSchemaNamespace(String namespace) {
        this.schemaNamespace = namespace;
    }

    List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (Column c : columns) {
            names.add(c.getName());
        }
        return names;
    }

    @TranslatorProperty(display="Entity Container Name", category=TranslatorProperty.PropertyType.IMPORT, description="Entity Container Name to import")
    public String getEntityContainer() {
        return this.entityContainer;
    }

    @TranslatorProperty(display="Schema Namespace", category=TranslatorProperty.PropertyType.IMPORT, description="Namespace of the schema to import")
    public String getSchemaNamespace() {
        return this.schemaNamespace;
    }
}

