/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.core4j.Enumerable;
import org.junit.Assert;
import org.junit.Test;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmAssociationSet;
import org.odata4j.edm.EdmAssociationSetEnd;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSchema;
import org.odata4j.format.xml.EdmxFormatParser;
import org.odata4j.format.xml.EdmxFormatWriter;
import org.odata4j.stax2.util.StaxUtil;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.odata.ODataEntitySchemaBuilder;
import org.teiid.translator.odata.ODataMetadataProcessor;
import org.teiid.translator.odata.TeiidEdmMetadata;

public class TestDataEntitySchemaBuilder {
    @Test
    public void testMetadata() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"northwind.ddl")), (String)"northwind", (String)"nw");
        StringWriter sw = new StringWriter();
        EdmDataServices eds = ODataEntitySchemaBuilder.buildMetadata((MetadataStore)metadata.getMetadataStore());
        EdmxFormatWriter.write((EdmDataServices)eds, (Writer)sw);
        EdmDataServices pds = new EdmxFormatParser().parseMetadata(StaxUtil.newXMLEventReader((Reader)new StringReader(sw.toString())));
        Assert.assertEquals((long)eds.getSchemas().size(), (long)pds.getSchemas().size());
        for (int i = 0; i < eds.getSchemas().size(); ++i) {
            EdmSchema expected = (EdmSchema)eds.getSchemas().get(i);
            EdmSchema actual = (EdmSchema)pds.getSchemas().get(i);
            this.assertEdmSchema(expected, actual);
        }
    }

    @Test
    public void testArrayIterateMetadata() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"northwind.ddl")), (String)"northwind", (String)"nw");
        StringWriter sw = new StringWriter();
        EdmDataServices eds = ODataEntitySchemaBuilder.buildMetadata((MetadataStore)metadata.getMetadataStore());
        EdmxFormatWriter.write((EdmDataServices)eds, (Writer)sw);
    }

    @Test
    public void testMetadataWithSelfJoin() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"categories.ddl")), (String)"northwind", (String)"nw");
        StringWriter sw = new StringWriter();
        EdmDataServices eds = ODataEntitySchemaBuilder.buildMetadata((MetadataStore)metadata.getMetadataStore());
        EdmxFormatWriter.write((EdmDataServices)eds, (Writer)sw);
        String expectedXML = "<?xml version=\"1.0\" encoding=\"utf-8\"?><edmx:Edmx Version=\"1.0\" xmlns:edmx=\"http://schemas.microsoft.com/ado/2007/06/edmx\"><edmx:DataServices m:DataServiceVersion=\"2.0\" xmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"><Schema Namespace=\"nw\" xmlns=\"http://schemas.microsoft.com/ado/2008/09/edm\"><EntityType Name=\"Category\"><Key><PropertyRef Name=\"CategoryID\"></PropertyRef></Key><Property Name=\"CategoryID\" Type=\"Edm.Int32\" Nullable=\"false\"></Property><Property Name=\"Name\" Type=\"Edm.String\" Nullable=\"false\" MaxLength=\"25\" FixedLength=\"false\" Unicode=\"true\"></Property><Property Name=\"ParentCategoryID\" Type=\"Edm.Int32\" Nullable=\"false\"></Property><NavigationProperty Name=\"Category\" Relationship=\"nw.Category_FK_CATEGORY_ID\" FromRole=\"Category\" ToRole=\"Category\"></NavigationProperty></EntityType><Association Name=\"Category_FK_CATEGORY_ID\"><End Type=\"nw.Category\" Multiplicity=\"*\" Role=\"Category\"></End><End Type=\"nw.Category\" Multiplicity=\"0..1\" Role=\"Category\"></End><ReferentialConstraint><Principal Role=\"Category\"><PropertyRef Name=\"CategoryID\"></PropertyRef></Principal><Dependent Role=\"Category\"><PropertyRef Name=\"ParentCategoryID\"></PropertyRef></Dependent></ReferentialConstraint></Association><EntityContainer Name=\"nw\" m:IsDefaultEntityContainer=\"false\"><EntitySet Name=\"Category\" EntityType=\"nw.Category\"></EntitySet><AssociationSet Name=\"Category_FK_CATEGORY_ID\" Association=\"nw.Category_FK_CATEGORY_ID\"><End EntitySet=\"Category\" Role=\"Category\"></End><End EntitySet=\"Category\" Role=\"Category\"></End></AssociationSet></EntityContainer></Schema></edmx:DataServices></edmx:Edmx>\n";
        EdmDataServices pds = new EdmxFormatParser().parseMetadata(StaxUtil.newXMLEventReader((Reader)new StringReader(expectedXML)));
        Assert.assertEquals((long)eds.getSchemas().size(), (long)pds.getSchemas().size());
        for (int i = 0; i < eds.getSchemas().size(); ++i) {
            EdmSchema expected = (EdmSchema)eds.getSchemas().get(i);
            EdmSchema actual = (EdmSchema)pds.getSchemas().get(i);
            this.assertEdmSchema(expected, actual);
        }
    }

    private void assertEdmSchema(EdmSchema expected, EdmSchema actual) {
        int i;
        Assert.assertEquals((long)expected.getEntityTypes().size(), (long)actual.getEntityTypes().size());
        Assert.assertEquals((long)expected.getEntityContainers().size(), (long)actual.getEntityContainers().size());
        Assert.assertEquals((long)expected.getAssociations().size(), (long)actual.getAssociations().size());
        for (i = 0; i < expected.getEntityTypes().size(); ++i) {
            this.assertEntityType((EdmEntityType)expected.getEntityTypes().get(i), (EdmEntityType)actual.getEntityTypes().get(i));
        }
        for (i = 0; i < expected.getAssociations().size(); ++i) {
            this.assertEdmAssosiation((EdmAssociation)expected.getAssociations().get(i), (EdmAssociation)actual.getAssociations().get(i));
        }
        for (i = 0; i < expected.getEntityContainers().size(); ++i) {
            this.assertEntityContainer((EdmEntityContainer)expected.getEntityContainers().get(i), (EdmEntityContainer)actual.getEntityContainers().get(i));
        }
    }

    private void assertEntityType(EdmEntityType expected, EdmEntityType actual) {
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getNamespace(), (Object)actual.getNamespace());
        Assert.assertArrayEquals((Object[])expected.getKeys().toArray(new String[expected.getKeys().size()]), (Object[])actual.getKeys().toArray(new String[actual.getKeys().size()]));
        ArrayList<EdmProperty> propertiesExpected = new ArrayList<EdmProperty>();
        ArrayList<EdmProperty> propertiesActual = new ArrayList<EdmProperty>();
        Iterator it = expected.getProperties().iterator();
        while (it.hasNext()) {
            propertiesExpected.add((EdmProperty)it.next());
        }
        it = actual.getProperties().iterator();
        while (it.hasNext()) {
            propertiesActual.add((EdmProperty)it.next());
        }
        Assert.assertEquals((long)propertiesExpected.size(), (long)propertiesActual.size());
        for (int i = 0; i < propertiesExpected.size(); ++i) {
            this.assertEdmProperty((EdmProperty)propertiesExpected.get(i), (EdmProperty)propertiesActual.get(i));
        }
        ArrayList<EdmNavigationProperty> navExpected = new ArrayList<EdmNavigationProperty>();
        ArrayList<EdmNavigationProperty> navActual = new ArrayList<EdmNavigationProperty>();
        Iterator enpIt = expected.getDeclaredNavigationProperties().iterator();
        while (enpIt.hasNext()) {
            navExpected.add((EdmNavigationProperty)enpIt.next());
        }
        enpIt = actual.getDeclaredNavigationProperties().iterator();
        while (enpIt.hasNext()) {
            navActual.add((EdmNavigationProperty)enpIt.next());
        }
        Assert.assertEquals((long)navExpected.size(), (long)navActual.size());
        for (int i = 0; i < navExpected.size(); ++i) {
            this.assertEdmNavigationProperty((EdmNavigationProperty)navExpected.get(i), (EdmNavigationProperty)navActual.get(i));
        }
        Assert.assertArrayEquals((Object[])expected.getKeys().toArray(), (Object[])actual.getKeys().toArray());
    }

    private void assertEdmNavigationProperty(EdmNavigationProperty expected, EdmNavigationProperty actual) {
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        this.assertEdmAssosiation(expected.getRelationship(), actual.getRelationship());
        this.assertEdmAssociationEnd(expected.getFromRole(), actual.getFromRole());
        this.assertEdmAssociationEnd(expected.getToRole(), actual.getToRole());
    }

    private void assertEdmAssociationEnd(EdmAssociationEnd expected, EdmAssociationEnd actual) {
        Assert.assertEquals((Object)expected.getRole(), (Object)actual.getRole());
    }

    private void assertEdmAssosiation(EdmAssociation expected, EdmAssociation actual) {
        Assert.assertEquals((Object)expected.getNamespace(), (Object)actual.getNamespace());
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        this.assertEdmAssociationEnd(expected.getEnd1(), actual.getEnd1());
        this.assertEdmAssociationEnd(expected.getEnd2(), actual.getEnd2());
    }

    private void assertEdmProperty(EdmProperty expected, EdmProperty actual) {
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getType(), (Object)actual.getType());
    }

    private void assertEntityContainer(EdmEntityContainer expected, EdmEntityContainer actual) {
        int i;
        Assert.assertEquals((long)expected.getEntitySets().size(), (long)actual.getEntitySets().size());
        Assert.assertEquals((long)expected.getAssociationSets().size(), (long)actual.getAssociationSets().size());
        for (i = 0; i < expected.getEntitySets().size(); ++i) {
            this.assertEnititySet((EdmEntitySet)expected.getEntitySets().get(i), (EdmEntitySet)actual.getEntitySets().get(i));
        }
        for (i = 0; i < expected.getAssociationSets().size(); ++i) {
            this.assertAssosiationSet((EdmAssociationSet)expected.getAssociationSets().get(i), (EdmAssociationSet)actual.getAssociationSets().get(i));
        }
    }

    private void assertAssosiationSet(EdmAssociationSet expected, EdmAssociationSet actual) {
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        this.assertEdmAssosiation(expected.getAssociation(), actual.getAssociation());
        this.assertEdmAssociationSetEnd(expected.getEnd1(), actual.getEnd1());
        this.assertEdmAssociationSetEnd(expected.getEnd1(), actual.getEnd1());
    }

    private void assertEdmAssociationSetEnd(EdmAssociationSetEnd expected, EdmAssociationSetEnd actual) {
        this.assertEdmAssociationEnd(expected.getRole(), actual.getRole());
    }

    private void assertEnititySet(EdmEntitySet expected, EdmEntitySet actual) {
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        this.assertEntityType(expected.getType(), actual.getType());
    }

    @Test
    public void testUnquieTreatedAsKey() {
    }

    @Test
    public void testEdmPropertyPrimaryKey() throws Exception {
        String ddl = "CREATE FOREIGN TABLE Sales (\n\tid integer PRIMARY KEY OPTIONS(NAMEINSOURCE 'myid'),\n   name string(5));";
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ddl, (String)"sales", (String)"sl");
        EdmDataServices edm = ODataEntitySchemaBuilder.buildMetadata((MetadataStore)metadata.getMetadataStore());
        Assert.assertFalse((String)"Primary key is nullable.", (boolean)((EdmProperty)edm.findEdmProperty("id")).isNullable());
        Assert.assertTrue((boolean)((EdmProperty)edm.findEdmProperty("name")).isNullable());
    }

    @Test
    public void testEntityTypeName() throws Exception {
        String ddl = "CREATE FOREIGN TABLE BookingCollection (\n\tcarrid bigdecimal NOT NULL,\n\tconnid string(5) NOT NULL,\n\tbookid bigdecimal NOT NULL,\n\tLOCCURKEY string(5) NOT NULL,\n\tfldate timestamp NOT NULL,\n\tPRIMARY KEY(carrid, connid, fldate, bookid)\n) OPTIONS (UPDATABLE TRUE,  \"teiid_odata:EntityType\" 'RMTSAMPLEFLIGHT.Booking');";
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ddl, (String)"northwind", (String)"nw");
        EdmDataServices edm = ODataEntitySchemaBuilder.buildMetadata((MetadataStore)metadata.getMetadataStore());
        Assert.assertTrue((edm.findEdmEntitySet("nw.BookingCollection") != null ? 1 : 0) != 0);
        Assert.assertTrue((edm.findEdmEntityType("nw.RMTSAMPLEFLIGHT.Booking") != null ? 1 : 0) != 0);
    }

    @Test
    public void testEntityPropertyName() throws Exception {
        String ddl = "CREATE FOREIGN TABLE BookingCollection (\n   carrid bigdecimal NOT NULL OPTIONS(NAMEINSOURCE '\"carrageid\"'),\n   connid string(5) NOT NULL  OPTIONS(NAMEINSOURCE '\"connectionid\"'),\n   PRIMARY KEY(carrid)\n) OPTIONS (UPDATABLE TRUE,  \"teiid_odata:EntityType\" 'RMTSAMPLEFLIGHT.Booking');";
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ddl, (String)"northwind", (String)"nw");
        EdmDataServices edm = ODataEntitySchemaBuilder.buildMetadata((MetadataStore)metadata.getMetadataStore());
        Assert.assertTrue((edm.findEdmEntitySet("nw.BookingCollection") != null ? 1 : 0) != 0);
        Enumerable properties = edm.getEdmEntitySet("nw.BookingCollection").getType().getProperties();
        Assert.assertEquals((long)2L, (long)properties.count());
        for (EdmProperty property : properties) {
            if (property.getName().equals("carrid") || property.getName().equals("connid")) continue;
            Assert.fail();
        }
    }

    @Test
    public void testEntityTypeName2() throws Exception {
        TransformationMetadata metadata = TestDataEntitySchemaBuilder.getNorthwindMetadataFromODataXML();
        EdmDataServices edm = ODataEntitySchemaBuilder.buildMetadata((Schema)metadata.getMetadataStore().getSchema("nw"));
        Assert.assertTrue((edm.findEdmEntitySet("nw.Categories") != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"NorthwindModel.Category", (Object)edm.findEdmEntitySet("nw.Categories").getType().getName());
        Assert.assertTrue((edm.findEdmEntityType("nw.NorthwindModel.Category") != null ? 1 : 0) != 0);
        Assert.assertTrue((edm.findEdmFunctionImport("nw.TopCustomers") != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Collection(nw.NorthwindModel.Customer)", (Object)edm.findEdmFunctionImport("nw.TopCustomers").getReturnType().getFullyQualifiedTypeName());
        Assert.assertTrue((edm.findEdmEntityType("nw.NorthwindModel.Category") != null ? 1 : 0) != 0);
        EdmComplexType complexType = edm.findEdmComplexType("nw.NorthwindModel.Address");
        Assert.assertEquals((Object)"Address", (Object)((EdmProperty)complexType.getProperties().first()).getName());
        edm = new TeiidEdmMetadata("nw", edm);
        Assert.assertTrue((edm.findEdmEntitySet("Categories") != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"NorthwindModel.Category", (Object)edm.findEdmEntitySet("Categories").getType().getName());
        Assert.assertTrue((edm.findEdmEntityType("NorthwindModel.Category") != null ? 1 : 0) != 0);
        Assert.assertTrue((edm.findEdmFunctionImport("TopCustomers") != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Collection(nw.NorthwindModel.Customer)", (Object)edm.findEdmFunctionImport("TopCustomers").getReturnType().getFullyQualifiedTypeName());
        Assert.assertTrue((edm.findEdmEntityType("NorthwindModel.Category") != null ? 1 : 0) != 0);
    }

    static TransformationMetadata getNorthwindMetadataFromODataXML() throws Exception {
        ModelMetaData model = new ModelMetaData();
        model.setName("nw");
        model.setModelType(Model.Type.PHYSICAL);
        MetadataFactory mf = new MetadataFactory("northwind", (Object)1, SystemMetadata.getInstance().getRuntimeTypeMap(), model);
        EdmDataServices edm = new EdmxFormatParser().parseMetadata(StaxUtil.newXMLEventReader((Reader)new FileReader(UnitTestUtil.getTestDataFile((String)"northwind.xml"))));
        ODataMetadataProcessor metadataProcessor = new ODataMetadataProcessor();
        PropertiesUtils.setBeanProperties((Object)metadataProcessor, (Properties)mf.getModelProperties(), (String)"importer");
        metadataProcessor.getMetadata(mf, edm);
        String ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ddl, (String)"northwind", (String)"nw");
        ValidatorReport report = new MetadataValidator().validate(metadata.getVdbMetaData(), (MetadataStore)metadata.getMetadataStore());
        if (report.hasItems()) {
            throw new RuntimeException(report.getFailureMessage());
        }
        return metadata;
    }

    @Test
    public void testArrayType() throws Exception {
        ModelMetaData model = new ModelMetaData();
        model.setName("nw");
        model.setModelType(Model.Type.PHYSICAL);
        MetadataFactory mf = new MetadataFactory("northwind", (Object)1, SystemMetadata.getInstance().getRuntimeTypeMap(), model);
        EdmDataServices edm = new EdmxFormatParser().parseMetadata(StaxUtil.newXMLEventReader((Reader)new FileReader(UnitTestUtil.getTestDataFile((String)"arraytest.xml"))));
        ODataMetadataProcessor metadataProcessor = new ODataMetadataProcessor();
        PropertiesUtils.setBeanProperties((Object)metadataProcessor, (Properties)mf.getModelProperties(), (String)"importer");
        metadataProcessor.getMetadata(mf, edm);
        Column c = mf.getSchema().getTable("G2").getColumnByName("e3");
        Assert.assertEquals((Object)"integer[]", (Object)c.getRuntimeType());
        Procedure p = mf.getSchema().getProcedure("ARRAYITERATE");
        Assert.assertEquals((Object)"varbinary[]", (Object)((ProcedureParameter)p.getParameters().get(0)).getRuntimeType());
        Assert.assertEquals((Object)"varbinary", (Object)((Column)p.getResultSet().getColumns().get(0)).getRuntimeType());
    }
}

