/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.odata4j.edm.EdmAssociation;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmReferentialConstraint;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmType;
import org.odata4j.format.xml.EdmxFormatParser;
import org.odata4j.stax2.util.StaxUtil;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.UDFSource;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.odata.ODataExecutionFactory;
import org.teiid.translator.odata.ODataMetadataProcessor;

public class TestODataMetadataProcessor {
    private ODataExecutionFactory translator;

    @Test
    public void testSchema() throws Exception {
        this.translator = new ODataExecutionFactory();
        this.translator.start();
        String csdl = ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"northwind.xml"));
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        Properties props = new Properties();
        props.setProperty("schemaNamespace", "ODataWeb.Northwind.Model");
        props.setProperty("entityContainer", "NorthwindEntities");
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), props, null);
        processor.getMetadata(mf, new EdmxFormatParser().parseMetadata(StaxUtil.newXMLEventReader((Reader)new InputStreamReader(new ByteArrayInputStream(csdl.getBytes())))));
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"northwind", (FunctionTree[])new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource((Collection)this.translator.getPushDownFunctions()))});
        ValidatorReport report = new MetadataValidator().validate(metadata.getVdbMetaData(), (MetadataStore)metadata.getMetadataStore());
        if (report.hasItems()) {
            throw new RuntimeException(report.getFailureMessage());
        }
        String ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        MetadataFactory mf2 = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        QueryParser.getQueryParser().parseDDL(mf2, ddl);
        Procedure p = mf.getSchema().getProcedure("executeVoid");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)1L, (long)p.getParameters().size());
    }

    @Test
    public void testEnititySet() throws Exception {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        ArrayList<EdmProperty.Builder> props = new ArrayList<EdmProperty.Builder>();
        props.add(EdmProperty.newBuilder((String)"name").setType((EdmType)EdmSimpleType.STRING).setMaxLength(Integer.valueOf(25)));
        props.add(EdmProperty.newBuilder((String)"dob").setType((EdmType)EdmSimpleType.DATETIME).setNullable(true).setPrecision(Integer.valueOf(9)));
        props.add(EdmProperty.newBuilder((String)"ssn").setType((EdmType)EdmSimpleType.INT64).setNullable(false).setPrecision(Integer.valueOf(2)).setScale(Integer.valueOf(3)));
        EdmEntityType.Builder entity = ((EdmEntityType.Builder)EdmEntityType.newBuilder().addProperties(props)).addKeys(new String[]{"ssn"});
        EdmEntitySet es = EdmEntitySet.newBuilder().setName("Person").setEntityType(entity).build();
        processor.addEntitySetAsTable(mf, es);
        Assert.assertNotNull((Object)mf.getSchema().getTable("Person"));
        Table person = mf.getSchema().getTable("Person");
        Assert.assertEquals((long)3L, (long)person.getColumns().size());
        Assert.assertNotNull((Object)person.getColumnByName("name"));
        Assert.assertNotNull((Object)person.getColumnByName("dob"));
        Assert.assertNotNull((Object)person.getColumnByName("ssn"));
        Column name = person.getColumnByName("name");
        Column dob = person.getColumnByName("dob");
        Column ssn = person.getColumnByName("ssn");
        Assert.assertEquals((Object)"string", (Object)name.getDatatype().getRuntimeTypeName());
        Assert.assertEquals((Object)"timestamp", (Object)dob.getDatatype().getRuntimeTypeName());
        Assert.assertEquals((Object)"long", (Object)ssn.getDatatype().getRuntimeTypeName());
        Assert.assertTrue((name.getNullType() == BaseColumn.NullType.No_Nulls ? 1 : 0) != 0);
        Assert.assertTrue((dob.getNullType() == BaseColumn.NullType.Nullable ? 1 : 0) != 0);
        Assert.assertTrue((ssn.getNullType() == BaseColumn.NullType.No_Nulls ? 1 : 0) != 0);
        Assert.assertEquals((long)25L, (long)name.getLength());
        Assert.assertNotNull((Object)person.getPrimaryKey());
        Assert.assertEquals((long)2L, (long)ssn.getPrecision());
        Assert.assertEquals((long)3L, (long)ssn.getScale());
        Assert.assertEquals((long)9L, (long)dob.getScale());
        Assert.assertEquals((long)1L, (long)person.getPrimaryKey().getColumns().size());
        Assert.assertEquals((Object)"ssn", (Object)((Column)person.getPrimaryKey().getColumns().get(0)).getName());
        Assert.assertTrue((boolean)person.getForeignKeys().isEmpty());
    }

    @Test
    public void testEnititySetWithComplexType() throws Exception {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        EdmEntitySet es = EdmEntitySet.newBuilder().setName("Person").setEntityType(this.buildPersonEntity(this.buildAddressEntity().build())).build();
        processor.addEntitySetAsTable(mf, es);
        Assert.assertEquals((long)1L, (long)mf.getSchema().getTables().size());
        Assert.assertNotNull((Object)mf.getSchema().getTable("Person"));
        Table personTable = mf.getSchema().getTable("Person");
        Assert.assertEquals((long)5L, (long)personTable.getColumns().size());
        Assert.assertNotNull((Object)personTable.getColumnByName("address_street"));
    }

    @Test
    public void testMultipleEnititySetWithSameComplexType() throws Exception {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        EdmEntitySet es = EdmEntitySet.newBuilder().setName("Person").setEntityType(this.buildPersonEntity(this.buildAddressEntity().build())).build();
        processor.addEntitySetAsTable(mf, es);
        es = EdmEntitySet.newBuilder().setName("Business").setEntityType(this.buildBusinessEntity(this.buildAddressEntity().build())).build();
        processor.addEntitySetAsTable(mf, es);
        Assert.assertEquals((long)2L, (long)mf.getSchema().getTables().size());
        Assert.assertNotNull((Object)mf.getSchema().getTable("Person"));
        Assert.assertNotNull((Object)mf.getSchema().getTable("Business"));
        Table personTable = mf.getSchema().getTable("Person");
        Assert.assertEquals((long)5L, (long)personTable.getColumns().size());
        Table businessTable = mf.getSchema().getTable("Business");
        Assert.assertEquals((long)4L, (long)businessTable.getColumns().size());
        Assert.assertNotNull((Object)personTable.getColumnByName("address_street"));
        Assert.assertNotNull((Object)businessTable.getColumnByName("address_street"));
    }

    @Test
    public void testOneToOneAssosiation() throws Exception {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        EdmEntityType.Builder g1Entity = this.entityType("g1");
        EdmEntityType.Builder g2Entity = this.entityType("g2");
        EdmAssociationEnd.Builder aend1 = EdmAssociationEnd.newBuilder().setRole("source").setType(g1Entity).setMultiplicity(EdmMultiplicity.ONE);
        EdmAssociationEnd.Builder aend2 = EdmAssociationEnd.newBuilder().setRole("target").setType(g2Entity).setMultiplicity(EdmMultiplicity.ONE);
        EdmAssociation.Builder assocition = EdmAssociation.newBuilder().setNamespace("namspace").setName("one_2_one").setEnds(aend2, aend1);
        EdmNavigationProperty.Builder navigation = EdmNavigationProperty.newBuilder((String)"g1").setFromTo(aend2, aend1).setFromToName("source", "target").setRelationship(assocition);
        g2Entity.addNavigationProperties(new EdmNavigationProperty.Builder[]{navigation});
        EdmEntitySet g1Set = EdmEntitySet.newBuilder().setName("G1").setEntityType(g1Entity).build();
        processor.addEntitySetAsTable(mf, g1Set);
        EdmEntitySet g2Set = EdmEntitySet.newBuilder().setName("G2").setEntityType(g2Entity).build();
        processor.addEntitySetAsTable(mf, g2Set);
        processor.addNavigationRelations(mf, "G2", g2Entity.build());
        Table g1 = mf.getSchema().getTable("G1");
        Table g2 = mf.getSchema().getTable("G2");
        ForeignKey fk = (ForeignKey)g1.getForeignKeys().get(0);
        Assert.assertEquals((Object)"one_2_one", (Object)fk.getName());
        Assert.assertNotNull((Object)fk.getColumnByName("e1"));
    }

    @Test
    public void testAssosiationWithReferentialContriant() throws Exception {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        EdmEntityType.Builder g1Entity = this.entityType("g1");
        g1Entity.addProperties(new EdmProperty.Builder[]{EdmProperty.newBuilder((String)"g2e2").setType((EdmType)EdmSimpleType.STRING).setNullable(false)});
        EdmEntityType.Builder g2Entity = this.entityType("g2");
        EdmAssociationEnd.Builder aend1 = EdmAssociationEnd.newBuilder().setRole("source").setType(g1Entity).setMultiplicity(EdmMultiplicity.ONE);
        EdmAssociationEnd.Builder aend2 = EdmAssociationEnd.newBuilder().setRole("target").setType(g2Entity).setMultiplicity(EdmMultiplicity.ONE);
        EdmReferentialConstraint.Builder refContraint = EdmReferentialConstraint.newBuilder().addPrincipalReferences(new String[]{"g2e2"}).setPrincipalRole("source").addDependentReferences(new String[]{"e1"}).setDependentRole("target");
        EdmAssociation.Builder assocition = EdmAssociation.newBuilder().setNamespace("namspace").setName("one_2_one").setEnds(aend2, aend1).setRefConstraint(refContraint);
        EdmNavigationProperty.Builder navigation = EdmNavigationProperty.newBuilder((String)"g1").setFromTo(aend2, aend1).setFromToName("source", "target").setRelationship(assocition);
        g2Entity.addNavigationProperties(new EdmNavigationProperty.Builder[]{navigation});
        EdmEntitySet g1Set = EdmEntitySet.newBuilder().setName("G1").setEntityType(g1Entity).build();
        EdmEntitySet g2Set = EdmEntitySet.newBuilder().setName("G2").setEntityType(g2Entity).build();
        Table t1 = processor.addEntitySetAsTable(mf, g1Set);
        Table t2 = processor.addEntitySetAsTable(mf, g2Set);
        KeyRecord record = new KeyRecord(KeyRecord.Type.Unique);
        record.addColumn(t1.getColumnByName("g2e2"));
        t1.setUniqueKeys(Arrays.asList(record));
        processor.addNavigationRelations(mf, "G2", g2Entity.build());
        Table g1 = mf.getSchema().getTable("G1");
        Table g2 = mf.getSchema().getTable("G2");
        Assert.assertNotNull((Object)g1);
        Assert.assertNotNull((Object)g2);
        ForeignKey fk = (ForeignKey)g1.getForeignKeys().get(0);
        Assert.assertEquals((Object)"one_2_one", (Object)fk.getName());
        Assert.assertNotNull((Object)fk.getColumnByName("g2e2"));
        Assert.assertEquals((Object)"e1", fk.getReferenceColumns().get(0));
    }

    @Test
    public void testManytoManyAssosiation() throws Exception {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        EdmEntityType.Builder g1Entity = this.entityType("g1");
        EdmEntityType.Builder g2Entity = this.entityType("g2");
        EdmAssociationEnd.Builder aend1 = EdmAssociationEnd.newBuilder().setRole("source").setType(g1Entity).setMultiplicity(EdmMultiplicity.MANY);
        EdmAssociationEnd.Builder aend2 = EdmAssociationEnd.newBuilder().setRole("target").setType(g2Entity).setMultiplicity(EdmMultiplicity.MANY);
        EdmAssociation.Builder assocition = EdmAssociation.newBuilder().setNamespace("namspace").setName("m_2_m").setEnds(aend2, aend1);
        EdmNavigationProperty.Builder navigation = EdmNavigationProperty.newBuilder((String)"g1").setFromTo(aend2, aend1).setFromToName("source", "target").setRelationship(assocition);
        g2Entity.addNavigationProperties(new EdmNavigationProperty.Builder[]{navigation});
        EdmEntitySet g1Set = EdmEntitySet.newBuilder().setName("G1").setEntityType(g1Entity).build();
        EdmEntitySet g2Set = EdmEntitySet.newBuilder().setName("G2").setEntityType(g2Entity).build();
        processor.addEntitySetAsTable(mf, g1Set);
        processor.addEntitySetAsTable(mf, g2Set);
        processor.addNavigationRelations(mf, "G2", g2Entity.build());
        Table g1 = mf.getSchema().getTable("G1");
        Table g2 = mf.getSchema().getTable("G2");
        Table linkTable = mf.getSchema().getTable("m_2_m");
        Assert.assertEquals((long)1L, (long)linkTable.getColumns().size());
        Assert.assertEquals((Object)"e1", (Object)((Column)linkTable.getColumns().get(0)).getName());
        Assert.assertNotNull((Object)linkTable);
        Assert.assertEquals((Object)"G2,G1", (Object)linkTable.getProperty("teiid_odata:LinkTables", false));
        ForeignKey fk1 = (ForeignKey)linkTable.getForeignKeys().get(0);
        Assert.assertEquals((Object)"G2_FK", (Object)fk1.getName());
        Assert.assertNotNull((Object)fk1.getColumnByName("e1"));
        ForeignKey fk2 = (ForeignKey)linkTable.getForeignKeys().get(1);
        Assert.assertEquals((Object)"G1_FK", (Object)fk2.getName());
        Assert.assertNotNull((Object)fk2.getColumnByName("e1"));
    }

    @Test
    public void testManytoManyAssosiationWithReferntialConstraint() throws Exception {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        EdmEntityType.Builder g1Entity = this.entityType("g1");
        g1Entity.addProperties(new EdmProperty.Builder[]{EdmProperty.newBuilder((String)"g2e2").setType((EdmType)EdmSimpleType.STRING).setNullable(false)});
        EdmEntityType.Builder g2Entity = this.entityType("g2");
        EdmAssociationEnd.Builder aend1 = EdmAssociationEnd.newBuilder().setRole("source").setType(g1Entity).setMultiplicity(EdmMultiplicity.MANY);
        EdmAssociationEnd.Builder aend2 = EdmAssociationEnd.newBuilder().setRole("target").setType(g2Entity).setMultiplicity(EdmMultiplicity.MANY);
        EdmReferentialConstraint.Builder refContraint = EdmReferentialConstraint.newBuilder().addPrincipalReferences(new String[]{"e1"}).addDependentReferences(new String[]{"g2e2"});
        EdmAssociation.Builder assocition = EdmAssociation.newBuilder().setNamespace("namspace").setName("m_2_m").setEnds(aend2, aend1).setRefConstraint(refContraint);
        EdmNavigationProperty.Builder navigation = EdmNavigationProperty.newBuilder((String)"g1").setFromTo(aend2, aend1).setFromToName("source", "target").setRelationship(assocition);
        g2Entity.addNavigationProperties(new EdmNavigationProperty.Builder[]{navigation});
        EdmEntitySet g1Set = EdmEntitySet.newBuilder().setName("G1").setEntityType(g1Entity).build();
        EdmEntitySet g2Set = EdmEntitySet.newBuilder().setName("G2").setEntityType(g2Entity).build();
        processor.addEntitySetAsTable(mf, g1Set);
        processor.addEntitySetAsTable(mf, g2Set);
        processor.addNavigationRelations(mf, "G2", g2Entity.build());
        Table g1 = mf.getSchema().getTable("G1");
        Table g2 = mf.getSchema().getTable("G2");
        Table linkTable = mf.getSchema().getTable("m_2_m");
        Assert.assertEquals((long)2L, (long)linkTable.getColumns().size());
        Assert.assertEquals((Object)"e1", (Object)((Column)linkTable.getColumns().get(0)).getName());
        Assert.assertEquals((Object)"g2e2", (Object)((Column)linkTable.getColumns().get(1)).getName());
        Assert.assertNotNull((Object)linkTable);
        Assert.assertEquals((Object)"G2,G1", (Object)linkTable.getProperty("teiid_odata:LinkTables", false));
        ForeignKey fk = (ForeignKey)linkTable.getForeignKeys().get(0);
        Assert.assertEquals((Object)"G2_FK", (Object)fk.getName());
        Assert.assertNotNull((Object)fk.getColumnByName("e1"));
        ForeignKey fk2 = (ForeignKey)linkTable.getForeignKeys().get(1);
        Assert.assertEquals((Object)"G1_FK", (Object)fk2.getName());
        Assert.assertNotNull((Object)fk2.getColumnByName("g2e2"));
    }

    private EdmEntityType.Builder entityType(String name) {
        ArrayList<EdmProperty.Builder> props = new ArrayList<EdmProperty.Builder>();
        props.add(EdmProperty.newBuilder((String)"e1").setType((EdmType)EdmSimpleType.INT32));
        props.add(EdmProperty.newBuilder((String)"e2").setType((EdmType)EdmSimpleType.STRING).setNullable(false));
        return (EdmEntityType.Builder)((EdmEntityType.Builder)((EdmEntityType.Builder)EdmEntityType.newBuilder().addProperties(props)).addKeys(new String[]{"e1"}).setName(name)).setNamespace("namespace");
    }

    private EdmEntityType.Builder buildBusinessEntity(EdmComplexType address) {
        ArrayList<EdmProperty.Builder> businessProperties = new ArrayList<EdmProperty.Builder>();
        businessProperties.add(EdmProperty.newBuilder((String)"name").setType((EdmType)EdmSimpleType.STRING).setMaxLength(Integer.valueOf(25)));
        businessProperties.add(EdmProperty.newBuilder((String)"address").setType((EdmType)address).setNullable(true));
        return ((EdmEntityType.Builder)EdmEntityType.newBuilder().addProperties(businessProperties)).addKeys(new String[]{"name"});
    }

    private EdmEntityType.Builder buildPersonEntity(EdmComplexType address) {
        ArrayList<EdmProperty.Builder> personProperties = new ArrayList<EdmProperty.Builder>();
        personProperties.add(EdmProperty.newBuilder((String)"name").setType((EdmType)EdmSimpleType.STRING).setMaxLength(Integer.valueOf(25)));
        personProperties.add(EdmProperty.newBuilder((String)"ssn").setType((EdmType)EdmSimpleType.INT64).setNullable(false));
        personProperties.add(EdmProperty.newBuilder((String)"address").setType((EdmType)address).setNullable(true));
        return ((EdmEntityType.Builder)EdmEntityType.newBuilder().addProperties(personProperties)).addKeys(new String[]{"ssn"});
    }

    private EdmComplexType.Builder buildAddressEntity() {
        ArrayList<EdmProperty.Builder> addressProperties = new ArrayList<EdmProperty.Builder>();
        addressProperties.add(EdmProperty.newBuilder((String)"street").setType((EdmType)EdmSimpleType.STRING));
        addressProperties.add(EdmProperty.newBuilder((String)"city").setType((EdmType)EdmSimpleType.STRING));
        addressProperties.add(EdmProperty.newBuilder((String)"state").setType((EdmType)EdmSimpleType.STRING));
        return (EdmComplexType.Builder)((EdmComplexType.Builder)((EdmComplexType.Builder)EdmComplexType.newBuilder().setName("Address")).setNamespace("namespace")).addProperties(addressProperties);
    }

    @Test
    public void testKeyMaytches() {
        Column c1 = new Column();
        c1.setName("one");
        Column c2 = new Column();
        c2.setName("two");
        KeyRecord record = new KeyRecord(KeyRecord.Type.Primary);
        record.addColumn(c1);
        record.addColumn(c2);
        ODataMetadataProcessor p = new ODataMetadataProcessor();
        Assert.assertTrue((boolean)p.keyMatches(Arrays.asList("one", "one"), record));
        Assert.assertTrue((boolean)p.keyMatches(Arrays.asList("two", "one"), record));
    }
}

