/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.activation.DataSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.format.xml.EdmxFormatParser;
import org.odata4j.stax2.util.StaxUtil;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Command;
import org.teiid.metadata.Column;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.odata.ODataExecutionFactory;
import org.teiid.translator.odata.ODataMetadataProcessor;
import org.teiid.translator.odata.TestDataEntitySchemaBuilder;
import org.teiid.translator.ws.WSConnection;

public class TestODataUpdateExecution {
    private String helpExecute(String query, String resultXML, String expectedURL, int[] responseCode, int times) throws Exception {
        TransformationMetadata metadata = TestDataEntitySchemaBuilder.getNorthwindMetadataFromODataXML();
        return this.helpExecute(query, resultXML, expectedURL, responseCode, metadata, times);
    }

    private String helpExecute(String query, final String resultXML, String expectedURL, int[] responseCode, TransformationMetadata metadata, int times) throws Exception {
        ODataExecutionFactory translator = new ODataExecutionFactory();
        translator.start();
        TranslationUtility utility = new TranslationUtility((QueryMetadataInterface)metadata);
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WSConnection connection = (WSConnection)Mockito.mock(WSConnection.class);
        HashMap<String, Serializable> headers = new HashMap<String, Serializable>();
        headers.put("javax.xml.ws.http.request.headers", new HashMap());
        headers.put("status-code", new Integer(responseCode[0]));
        Dispatch dispatch = (Dispatch)Mockito.mock(Dispatch.class);
        Mockito.stub((Object)dispatch.getRequestContext()).toReturn(headers);
        Mockito.stub((Object)dispatch.getResponseContext()).toReturn(headers);
        Mockito.stub((Object)connection.createDispatch((String)Mockito.eq((Object)"http://www.w3.org/2004/08/wsdl/http"), Mockito.anyString(), (Class)Mockito.eq(DataSource.class), (Service.Mode)Mockito.eq((Object)Service.Mode.MESSAGE))).toReturn((Object)dispatch);
        DataSource ds = new DataSource(){

            public OutputStream getOutputStream() throws IOException {
                return new ByteArrayOutputStream();
            }

            public String getName() {
                return "result";
            }

            public InputStream getInputStream() throws IOException {
                ByteArrayInputStream in = new ByteArrayInputStream(resultXML.getBytes());
                return in;
            }

            public String getContentType() {
                return "application/xml";
            }
        };
        ArgumentCaptor payload = ArgumentCaptor.forClass(DataSource.class);
        Mockito.stub((Object)((DataSource)dispatch.invoke((Object)((DataSource)payload.capture())))).toReturn((Object)ds);
        UpdateExecution execution = translator.createUpdateExecution(cmd, context, utility.createRuntimeMetadata(), connection);
        execution.execute();
        ArgumentCaptor endpoint = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor binding = ArgumentCaptor.forClass(String.class);
        ((WSConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)times))).createDispatch((String)binding.capture(), (String)endpoint.capture(), (Class)Mockito.eq(DataSource.class), (Service.Mode)Mockito.eq((Object)Service.Mode.MESSAGE));
        ((Dispatch)Mockito.verify((Object)dispatch, (VerificationMode)Mockito.times((int)times))).invoke((Object)((DataSource)payload.capture()));
        Assert.assertEquals((Object)expectedURL, (Object)URLDecoder.decode((String)endpoint.getValue(), "utf-8"));
        if (payload.getAllValues() != null) {
            List listDS = payload.getAllValues();
            InputStream in = null;
            in = times > 1 ? ((DataSource)listDS.get(1)).getInputStream() : ((DataSource)listDS.get(0)).getInputStream();
            return new String(ObjectConverterUtil.convertToByteArray((InputStream)in));
        }
        return "";
    }

    @Test
    public void testSimpleInsert() throws Exception {
        String query = "INSERT INTO Categories(CategoryID, CategoryName, Description) values(1, 'catname', 'desc')";
        String expectedURL = "Categories";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"categories.xml"));
        String payload = this.helpExecute(query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL, new int[]{201, 201}, 1);
        reader.close();
        String expected = "<category term=\"NorthwindModel.Category\" scheme=\"http://schemas.microsoft.com/ado/2007/08/dataservices/scheme\"></category><content type=\"application/xml\"><m:properties><d:CategoryID m:type=\"Edm.Int32\">1</d:CategoryID><d:CategoryName>catname</d:CategoryName><d:Description>desc</d:Description></m:properties></content></entry>";
        Assert.assertTrue((String)expected, (boolean)payload.endsWith(expected));
    }

    @Test
    public void testSimpleUpdate() throws Exception {
        String query = "Update Categories set CategoryName = 'catname' where CategoryID=1";
        String expectedURL = "Categories(1)";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"categories.xml"));
        String payload = this.helpExecute(query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL, new int[]{200, 204}, 2);
        reader.close();
        String expected = "<category term=\"NorthwindModel.Category\" scheme=\"http://schemas.microsoft.com/ado/2007/08/dataservices/scheme\"></category><content type=\"application/xml\"><m:properties><d:CategoryName>catname</d:CategoryName></m:properties></content></entry>";
        Assert.assertTrue((String)expected, (boolean)payload.endsWith(expected));
    }

    @Test
    public void testArrayInsert() throws Exception {
        ModelMetaData model = new ModelMetaData();
        model.setName("nw");
        model.setModelType(Model.Type.PHYSICAL);
        MetadataFactory mf = new MetadataFactory("northwind", (Object)1, SystemMetadata.getInstance().getRuntimeTypeMap(), model);
        EdmDataServices edm = new EdmxFormatParser().parseMetadata(StaxUtil.newXMLEventReader((Reader)new FileReader(UnitTestUtil.getTestDataFile((String)"arraytest.xml"))));
        ODataMetadataProcessor metadataProcessor = new ODataMetadataProcessor();
        PropertiesUtils.setBeanProperties((Object)metadataProcessor, (Properties)mf.getModelProperties(), (String)"importer");
        metadataProcessor.getMetadata(mf, edm);
        Column c = mf.getSchema().getTable("G2").getColumnByName("e3");
        Assert.assertEquals((Object)"integer[]", (Object)c.getRuntimeType());
        String ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ddl, (String)"northwind", (String)"nw");
        String query = "insert into G2 (e1, e3) values(1, (1,2,3))";
        String expectedURL = "G2";
        String result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<feed xmlns=\"http://www.w3.org/2005/Atom\" xmlns:d=\"http://schemas.microsoft.com/ado/2007/08/dataservices\" xmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\" xml:base=\"http://localhost:8080/odata/loopy/\">\n   <title type=\"text\">VM1.x</title>\n   <id>http://localhost:8080/odata/loopy/VM1.x</id>\n   <updated>2015-10-14T19:36:58Z</updated>\n   <link rel=\"self\" title=\"VM1.x\" href=\"VM1.x\" />\n   <entry>\n      <id>http://localhost:8080/odata/loopy/VM1.x('x')</id>\n      <title type=\"text\" />\n      <updated>2015-10-14T19:36:58Z</updated>\n      <author>\n         <name />\n      </author>\n      <link rel=\"edit\" title=\"x\" href=\"VM1.x('x')\" />\n      <category term=\"PM1.G2\" scheme=\"http://schemas.microsoft.com/ado/2007/08/dataservices/scheme\" />\n      <content type=\"application/xml\">\n         <m:properties>\n            <d:e1>32</d:e1>\n            <d:e3 m:type=\"Collection(Edm.Int32)\">\n               <d:element>1</d:element>\n               <d:element>2</d:element>\n               <d:element>3</d:element>\n            </d:e3>\n         </m:properties>\n      </content>\n   </entry>\n</feed>";
        String payload = this.helpExecute(query, result, expectedURL, new int[]{201, 201}, metadata, 1);
        String expected = "<category term=\"PM1.G2\" scheme=\"http://schemas.microsoft.com/ado/2007/08/dataservices/scheme\"></category><content type=\"application/xml\"><m:properties><d:e1 m:type=\"Edm.Int32\">1</d:e1><d:e3 m:type=\"Collection(Edm.Int32)\"><d:element>1</d:element><d:element>2</d:element><d:element>3</d:element></d:e3></m:properties></content></entry>";
        Assert.assertTrue((String)expected, (boolean)payload.endsWith(expected));
    }

    @Test
    public void testArrayUpdate() throws Exception {
        ModelMetaData model = new ModelMetaData();
        model.setName("nw");
        model.setModelType(Model.Type.PHYSICAL);
        MetadataFactory mf = new MetadataFactory("northwind", (Object)1, SystemMetadata.getInstance().getRuntimeTypeMap(), model);
        EdmDataServices edm = new EdmxFormatParser().parseMetadata(StaxUtil.newXMLEventReader((Reader)new FileReader(UnitTestUtil.getTestDataFile((String)"arraytest.xml"))));
        ODataMetadataProcessor metadataProcessor = new ODataMetadataProcessor();
        PropertiesUtils.setBeanProperties((Object)metadataProcessor, (Properties)mf.getModelProperties(), (String)"importer");
        metadataProcessor.getMetadata(mf, edm);
        Column c = mf.getSchema().getTable("G2").getColumnByName("e3");
        Assert.assertEquals((Object)"integer[]", (Object)c.getRuntimeType());
        String ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        TransformationMetadata metadata = RealMetadataFactory.fromDDL((String)ddl, (String)"northwind", (String)"nw");
        String query = "Update G2 set e3 = (1,2,3) where e1 = 1";
        String expectedURL = "G2(1)";
        String result = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<feed xmlns=\"http://www.w3.org/2005/Atom\" xmlns:d=\"http://schemas.microsoft.com/ado/2007/08/dataservices\" xmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\" xml:base=\"http://localhost:8080/odata/loopy/\">\n   <title type=\"text\">VM1.x</title>\n   <id>http://localhost:8080/odata/loopy/VM1.x</id>\n   <updated>2015-10-14T19:36:58Z</updated>\n   <link rel=\"self\" title=\"VM1.x\" href=\"VM1.x\" />\n   <entry>\n      <id>http://localhost:8080/odata/loopy/VM1.x('x')</id>\n      <title type=\"text\" />\n      <updated>2015-10-14T19:36:58Z</updated>\n      <author>\n         <name />\n      </author>\n      <link rel=\"edit\" title=\"x\" href=\"VM1.x('x')\" />\n      <category term=\"PM1.G2\" scheme=\"http://schemas.microsoft.com/ado/2007/08/dataservices/scheme\" />\n      <content type=\"application/xml\">\n         <m:properties>\n            <d:e1>32</d:e1>\n            <d:e3 m:type=\"Collection(Edm.Int32)\">\n               <d:element>1</d:element>\n               <d:element>2</d:element>\n               <d:element>3</d:element>\n            </d:e3>\n         </m:properties>\n      </content>\n   </entry>\n</feed>";
        String payload = this.helpExecute(query, result, expectedURL, new int[]{200, 204}, metadata, 2);
        String expected = "<category term=\"PM1.G2\" scheme=\"http://schemas.microsoft.com/ado/2007/08/dataservices/scheme\"></category><content type=\"application/xml\"><m:properties><d:e3 m:type=\"Collection(Edm.Int32)\"><d:element>1</d:element><d:element>2</d:element><d:element>3</d:element></d:e3></m:properties></content></entry>";
        Assert.assertTrue((String)expected, (boolean)payload.endsWith(expected));
    }
}

