/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.core.serialization.AtomDeserializer;
import org.apache.olingo.client.core.serialization.JsonDeserializer;
import org.apache.olingo.commons.api.ex.ODataError;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Literal;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.olingo.common.ODataTypeManager;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.WSConnection;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.ODataMetadataProcessor;
import org.teiid.translator.odata4.ODataPlugin;
import org.teiid.translator.ws.BinaryWSProcedureExecution;

public class BaseQueryExecution {
    protected WSConnection connection;
    protected ODataExecutionFactory translator;
    protected RuntimeMetadata metadata;
    protected ExecutionContext executionContext;

    public BaseQueryExecution(ODataExecutionFactory translator, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) {
        this.metadata = metadata;
        this.executionContext = executionContext;
        this.translator = translator;
        this.connection = connection;
    }

    protected InputStream executeQuery(String method, String uri, String payload, String eTag, HttpStatusCode[] expectedStatus) throws TranslatorException {
        BinaryWSProcedureExecution execution;
        Map<String, List<String>> headers = this.getDefaultHeaders();
        if (eTag != null) {
            headers.put("If-Match", Arrays.asList(eTag));
        }
        if (payload != null) {
            headers.put("Content-Type", Arrays.asList(ContentType.APPLICATION_JSON.toContentTypeString()));
        }
        try {
            execution = this.invokeHTTP(method, uri, payload, headers);
            for (HttpStatusCode status : expectedStatus) {
                if (status.getStatusCode() != execution.getResponseCode()) continue;
                if (execution.getResponseCode() != HttpStatusCode.NO_CONTENT.getStatusCode() && execution.getResponseCode() != HttpStatusCode.NOT_FOUND.getStatusCode()) {
                    Blob blob = (Blob)execution.getOutputParameterValues().get(0);
                    return blob.getBinaryStream();
                }
                return null;
            }
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
        throw this.buildError(execution);
    }

    String getHeader(BinaryWSProcedureExecution execution, String header) {
        Object value = execution.getResponseHeader(header);
        if (value instanceof List) {
            return (String)((List)value).get(0);
        }
        return (String)value;
    }

    protected TranslatorException buildError(BinaryWSProcedureExecution execution) {
        try {
            Blob blob = (Blob)execution.getOutputParameterValues().get(0);
            if (blob != null) {
                ContentType contentType;
                boolean json = false;
                String contentTypeString = this.getHeader(execution, "Content-Type");
                if (contentTypeString != null && (contentType = ContentType.parse((String)contentTypeString)) != null && ContentType.APPLICATION_JSON.isCompatible(contentType)) {
                    json = true;
                }
                Object parser = null;
                parser = json ? new JsonDeserializer(false) : new AtomDeserializer();
                ODataError error = parser.toError(blob.getBinaryStream());
                return new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17013, new Object[]{execution.getResponseCode(), error.getCode(), error.getMessage(), error.getInnerError()}));
            }
            return new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17031, new Object[]{execution.getResponseCode()}));
        }
        catch (Throwable t) {
            return new TranslatorException(t);
        }
    }

    protected BinaryWSProcedureExecution invokeHTTP(String method, String uri, String payload, Map<String, List<String>> headers) throws TranslatorException {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.ODATA", (int)5)) {
            try {
                LogManager.logDetail((String)"org.teiid.ODATA", (Object)"Source-URL=", (Object)URLDecoder.decode(uri, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        ArrayList<Argument> parameters = new ArrayList<Argument>();
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)method, TypeFacility.RUNTIME_TYPES.STRING), null));
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)payload, TypeFacility.RUNTIME_TYPES.STRING), null));
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)uri, TypeFacility.RUNTIME_TYPES.STRING), null));
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)true, TypeFacility.RUNTIME_TYPES.BOOLEAN), null));
        parameters.add(new Argument(Argument.Direction.OUT, TypeFacility.RUNTIME_TYPES.STRING, null));
        Call call = this.translator.getLanguageFactory().createCall("invokeHttp", parameters, null);
        BinaryWSProcedureExecution execution = new BinaryWSProcedureExecution(call, this.metadata, this.executionContext, null, this.connection);
        execution.setUseResponseContext(true);
        execution.setCustomHeaders(headers);
        execution.execute();
        return execution;
    }

    protected Map<String, List<String>> getDefaultHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Accept", Arrays.asList(ContentType.JSON.toContentTypeString()));
        headers.put("Content-Type", Arrays.asList(ContentType.APPLICATION_JSON.toContentTypeString()));
        if (this.executionContext != null) {
            headers.put("Prefer", Arrays.asList("odata.maxpagesize=" + this.executionContext.getBatchSize()));
        }
        return headers;
    }

    protected InputStream executeSkipToken(URI nextURL, String baseURL, HttpStatusCode[] accepeted) throws TranslatorException {
        String next = nextURL.toString();
        int idx = next.indexOf("$skiptoken=");
        if (next.toLowerCase().startsWith("http")) {
            return this.executeQuery("GET", nextURL.toString(), null, null, accepeted);
        }
        if (idx != -1) {
            String skip = null;
            try {
                skip = next.substring(idx + 11);
                skip = URLDecoder.decode(skip, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new TranslatorException((Throwable)e);
            }
            String nextUri = baseURL;
            nextUri = baseURL.indexOf(63) == -1 ? baseURL + "?$skiptoken=" + skip : baseURL + "&$skiptoken=" + skip;
            return this.executeQuery("GET", nextUri, null, null, accepeted);
        }
        throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17001, new Object[]{next}));
    }

    <T extends AbstractMetadataRecord> List<?> buildRow(T record, List<Column> columns, Class<?>[] expectedType, Map<String, Object> values) throws TranslatorException {
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < columns.size(); ++i) {
            Object value;
            Column column = columns.get(i);
            ColumnSet columnParent = column.getParent();
            String colName = column.getName();
            if (!columnParent.equals(record)) {
                colName = this.getName((AbstractMetadataRecord)columnParent) + "/" + column.getName();
            }
            try {
                value = ODataTypeManager.convertToTeiidRuntimeType(expectedType[i], (Object)values.get(colName), (String)ODataMetadataProcessor.getNativeType(column));
            }
            catch (TeiidException e) {
                throw new TranslatorException((Throwable)e);
            }
            results.add(value);
        }
        return results;
    }

    public String getName(AbstractMetadataRecord table) {
        if (table.getNameInSource() != null) {
            return table.getNameInSource();
        }
        return table.getName();
    }
}

