/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.teiid.core.BundleUtil;
import org.teiid.language.AndOr;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.In;
import org.teiid.language.IsNull;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.Not;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.olingo.common.ODataTypeManager;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.odata4.ODataDocumentNode;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.ODataMetadataProcessor;
import org.teiid.translator.odata4.ODataPlugin;
import org.teiid.translator.odata4.ODataQuery;

public class ODataFilterVisitor
extends HierarchyVisitor {
    private static Map<String, String> infixFunctions = new HashMap<String, String>();
    protected StringBuilder filter = new StringBuilder();
    private ODataExecutionFactory ef;
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    private ODataQuery query;
    private RuntimeMetadata metadata;
    private ODataDocumentNode filterOnElement;
    private BaseColumn currentExpression;

    public ODataFilterVisitor(ODataExecutionFactory ef, RuntimeMetadata metadata, ODataQuery query) {
        this.ef = ef;
        this.query = query;
        this.metadata = metadata;
    }

    public void appendFilter(Condition condition) throws TranslatorException {
        this.append((LanguageObject)condition);
        if (!this.exceptions.isEmpty()) {
            throw this.exceptions.get(0);
        }
        if (this.filter.length() > 0) {
            this.filterOnElement.addFilter(this.filter.toString());
        }
    }

    public void visit(Comparison obj) {
        this.append((LanguageObject)obj.getLeftExpression());
        this.filter.append(" ");
        switch (obj.getOperator()) {
            case EQ: {
                this.filter.append("eq");
                break;
            }
            case NE: {
                this.filter.append("ne");
                break;
            }
            case LT: {
                this.filter.append("lt");
                break;
            }
            case LE: {
                this.filter.append("le");
                break;
            }
            case GT: {
                this.filter.append("gt");
                break;
            }
            case GE: {
                this.filter.append("ge");
            }
        }
        this.filter.append(" ");
        BaseColumn old = this.setCurrentExpression(obj.getLeftExpression());
        this.appendRightComparison(obj);
        this.currentExpression = old;
    }

    private BaseColumn setCurrentExpression(Expression leftExpression) {
        BaseColumn old = this.currentExpression;
        if (leftExpression instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)leftExpression;
            this.currentExpression = cr.getMetadataObject();
        } else if (leftExpression instanceof Function) {
            Function function = (Function)leftExpression;
            this.currentExpression = function.getMetadataObject().getOutputParameter();
        } else {
            this.currentExpression = null;
        }
        return old;
    }

    protected void appendRightComparison(Comparison obj) {
        this.append((LanguageObject)obj.getRightExpression());
    }

    public void visit(IsNull obj) {
        if (obj.isNegated()) {
            this.filter.append("NOT".toLowerCase()).append("(");
        }
        this.appendNested(obj.getExpression());
        this.filter.append(" ");
        this.filter.append("eq").append(" ");
        this.filter.append("NULL".toLowerCase());
        if (obj.isNegated()) {
            this.filter.append(")");
        }
    }

    private void appendNested(Expression ex) {
        boolean useParens = ex instanceof Condition;
        if (useParens) {
            this.filter.append("(");
        }
        this.append((LanguageObject)ex);
        if (useParens) {
            this.filter.append(")");
        }
    }

    public void visit(AndOr obj) {
        String opString = obj.getOperator().name().toLowerCase();
        this.appendNestedCondition(obj, obj.getLeftCondition());
        this.filter.append(" ").append(opString).append(" ");
        this.appendNestedCondition(obj, obj.getRightCondition());
    }

    protected void appendNestedCondition(AndOr parent, Condition condition) {
        AndOr nested;
        if (condition instanceof AndOr && (nested = (AndOr)condition).getOperator() != parent.getOperator()) {
            this.filter.append("(");
            this.append((LanguageObject)condition);
            this.filter.append(")");
            return;
        }
        this.append((LanguageObject)condition);
    }

    private String odataType(String type, String runtimeType) {
        if (type == null) {
            type = ODataTypeManager.odataType((String)runtimeType).getFullQualifiedName().getFullQualifiedNameAsString();
        }
        return type;
    }

    public void visit(ColumnReference obj) {
        Column column = obj.getMetadataObject();
        String pseudo = ODataMetadataProcessor.getPseudo(column);
        ODataDocumentNode schemaElement = this.query.getSchemaElement((Table)column.getParent());
        if (pseudo != null) {
            try {
                Table columnParent = (Table)column.getParent();
                Table pseudoColumnParent = this.metadata.getTable(ODataMetadataProcessor.getMerge(columnParent));
                schemaElement = this.query.getSchemaElement(pseudoColumnParent);
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
            }
        }
        if (this.filterOnElement == null) {
            this.filterOnElement = schemaElement;
        } else if (schemaElement.isExpandType() && !this.filterOnElement.isExpandType()) {
            this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17026, new Object[0])));
        }
        if (this.filterOnElement.isComplexType()) {
            if (pseudo == null) {
                this.filter.append(this.filterOnElement.getName()).append("/").append(column.getName());
            } else {
                this.filter.append(pseudo);
            }
        } else if (pseudo == null) {
            this.filter.append(column.getName());
        } else {
            this.filter.append(pseudo);
        }
    }

    protected boolean isInfixFunction(String function) {
        return infixFunctions.containsKey(function);
    }

    public void visit(Function obj) {
        if (this.ef.getFunctionModifiers().containsKey(obj.getName())) {
            this.ef.getFunctionModifiers().get(obj.getName()).translate(obj);
        }
        String name = obj.getName();
        List args = obj.getParameters();
        if (this.isInfixFunction(name)) {
            this.filter.append("(");
            if (args != null) {
                for (int i = 0; i < args.size(); ++i) {
                    this.append((LanguageObject)args.get(i));
                    if (i >= args.size() - 1) continue;
                    this.filter.append(" ");
                    this.filter.append(infixFunctions.get(name));
                    this.filter.append(" ");
                }
            }
            this.filter.append(")");
        } else {
            FunctionMethod method = obj.getMetadataObject();
            if (name.startsWith(method.getCategory())) {
                name = name.substring(method.getCategory().length() + 1);
            }
            this.filter.append(name).append("(");
            if (name.equals("cast")) {
                this.append((LanguageObject)args.get(0));
                this.filter.append(",");
                Literal literal = (Literal)args.get(1);
                String type = ODataTypeManager.odataType((String)((String)literal.getValue())).getFullQualifiedName().getFullQualifiedNameAsString();
                this.filter.append(type);
            } else if (args != null && args.size() != 0) {
                if ("endswith".equalsIgnoreCase(name)) {
                    this.append((LanguageObject)args.get(1));
                    this.filter.append(",");
                    this.append((LanguageObject)args.get(0));
                } else {
                    BaseColumn old = this.currentExpression;
                    for (int i = 0; i < args.size(); ++i) {
                        this.currentExpression = (BaseColumn)method.getInputParameters().get(Math.min(i, method.getInputParameters().size() - 1));
                        this.append((LanguageObject)args.get(i));
                        if (i >= args.size() - 1) continue;
                        this.filter.append(",");
                    }
                    this.currentExpression = old;
                }
            }
            this.filter.append(")");
        }
    }

    public void visit(In obj) {
        for (int i = 0; i < obj.getRightExpressions().size(); ++i) {
            Expression expr = (Expression)obj.getRightExpressions().get(i);
            if (i != 0) {
                this.filter.append(" or ");
            }
            this.visitNode((LanguageObject)obj.getLeftExpression());
            this.filter.append(" eq ");
            BaseColumn old = this.setCurrentExpression(obj.getLeftExpression());
            this.visitNode((LanguageObject)expr);
            this.currentExpression = old;
        }
    }

    public void visit(Literal obj) {
        try {
            String odataType = ODataTypeManager.odataType((Class)obj.getType()).toString();
            if (this.currentExpression != null) {
                odataType = this.odataType(this.currentExpression.getNativeType(), this.currentExpression.getRuntimeType());
            }
            this.filter.append(ODataTypeManager.convertToODataURIValue((Object)obj.getValue(), (String)odataType));
        }
        catch (EdmPrimitiveTypeException e) {
            this.exceptions.add(new TranslatorException((Throwable)e));
        }
    }

    public void visit(Not obj) {
        this.filter.append("NOT").append(" ").append("(");
        this.append((LanguageObject)obj.getCriteria());
        this.filter.append(")");
    }

    public void append(LanguageObject obj) {
        this.visitNode(obj);
    }

    protected void append(List<? extends LanguageObject> items) {
        if (items != null && items.size() != 0) {
            for (int i = 0; i < items.size(); ++i) {
                this.append(items.get(i));
            }
        }
    }

    protected void append(LanguageObject[] items) {
        if (items != null && items.length != 0) {
            for (int i = 0; i < items.length; ++i) {
                this.append(items[i]);
            }
        }
    }

    static {
        infixFunctions.put("%", "mod");
        infixFunctions.put("+", "add");
        infixFunctions.put("-", "sub");
        infixFunctions.put("*", "mul");
        infixFunctions.put("/", "div");
    }
}

