/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.serialization.JsonDeserializer;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.olingo.common.ODataTypeManager;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.WSConnection;
import org.teiid.translator.document.DocumentNode;
import org.teiid.translator.odata4.BaseQueryExecution;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.ODataMetadataProcessor;
import org.teiid.translator.odata4.ODataResponse;

public class ODataProcedureExecution
extends BaseQueryExecution
implements ProcedureExecution {
    private Object returnValue;
    private ODataResponse response;
    private Class<?>[] expectedColumnTypes;
    private Call command;

    public ODataProcedureExecution(Call command, ODataExecutionFactory translator, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        super(translator, executionContext, metadata, connection);
        this.command = command;
        this.expectedColumnTypes = command.getResultSetColumnTypes();
    }

    private boolean isFunction(Procedure proc) {
        ODataMetadataProcessor.ODataType type = ODataMetadataProcessor.ODataType.valueOf(proc.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}Type", false));
        return type == ODataMetadataProcessor.ODataType.FUNCTION;
    }

    private ProcedureParameter getReturnParameter() {
        for (ProcedureParameter pp : this.command.getMetadataObject().getParameters()) {
            if (pp.getType() != ProcedureParameter.Type.ReturnValue) continue;
            return pp;
        }
        return null;
    }

    static String getQueryParameters(Call obj) throws EdmPrimitiveTypeException {
        StringBuilder sb = new StringBuilder();
        List params = obj.getArguments();
        if (params != null && params.size() != 0) {
            Argument param = null;
            for (int i = 0; i < params.size(); ++i) {
                param = (Argument)params.get(i);
                if (param.getDirection() != Argument.Direction.IN && param.getDirection() != Argument.Direction.INOUT) continue;
                if (i != 0) {
                    sb.append("&");
                }
                sb.append(WSConnection.Util.httpURLEncode((String)param.getMetadataObject().getName()));
                sb.append("=");
                sb.append(WSConnection.Util.httpURLEncode((String)ODataTypeManager.convertToODataURIValue((Object)param.getArgumentValue().getValue(), (String)ODataTypeManager.odataType((Class)param.getType()).getFullQualifiedName().getFullQualifiedNameAsString())));
            }
        }
        return sb.toString();
    }

    private String buildFunctionURL(Call obj, String parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj.getProcedureName());
        if (parameters != null && !parameters.isEmpty()) {
            sb.append("?");
            sb.append(parameters);
        }
        return sb.toString();
    }

    public void execute() throws TranslatorException {
        try {
            String parameters = ODataProcedureExecution.getQueryParameters(this.command);
            InputStream response = null;
            Procedure procedure = this.command.getMetadataObject();
            if (this.isFunction(procedure)) {
                String URI2 = this.buildFunctionURL(this.command, parameters);
                response = this.executeQuery("GET", URI2, null, null, new HttpStatusCode[]{HttpStatusCode.OK});
                this.handleResponse(procedure, URI2, response);
            } else {
                String URI3 = this.command.getProcedureName();
                response = this.executeQuery("POST", URI3, parameters, null, new HttpStatusCode[]{HttpStatusCode.OK});
                this.handleResponse(procedure, URI3, response);
            }
        }
        catch (ODataDeserializerException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (EdmPrimitiveTypeException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private void handleResponse(Procedure procedure, final String baseUri, InputStream payload) throws TranslatorException, ODataDeserializerException {
        if (procedure.getResultSet() != null) {
            ODataMetadataProcessor.ODataType type = ODataMetadataProcessor.ODataType.valueOf(procedure.getResultSet().getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}Type", false));
            this.response = new ODataResponse(payload, type, new DocumentNode()){

                @Override
                public InputStream nextBatch(URI uri) throws TranslatorException {
                    return ODataProcedureExecution.this.executeSkipToken(uri, baseUri, new HttpStatusCode[]{HttpStatusCode.OK});
                }
            };
        } else if (this.getReturnParameter() != null) {
            JsonDeserializer parser = new JsonDeserializer(false);
            Property property = (Property)parser.toProperty(payload).getPayload();
            this.returnValue = property.isCollection() ? property.asCollection() : property.asPrimitive();
        }
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        Map<String, Object> row;
        Procedure procedure = this.command.getMetadataObject();
        if (this.response != null && (row = this.response.getNext()) != null) {
            return this.buildRow(procedure.getResultSet(), procedure.getResultSet().getColumns(), this.expectedColumnTypes, row);
        }
        return null;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return Arrays.asList(this.returnValue);
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

