/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.io.InputStream;
import java.net.URI;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.olingo.client.api.serialization.ODataDeserializer;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.serialization.AtomDeserializer;
import org.apache.olingo.client.core.serialization.JsonDeserializer;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.teiid.GeneratedKeys;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.olingo.common.ODataTypeManager;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.WSConnection;
import org.teiid.translator.odata4.BaseQueryExecution;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.ODataMetadataProcessor;
import org.teiid.translator.odata4.ODataPlugin;
import org.teiid.translator.odata4.ODataUpdateQuery;
import org.teiid.translator.odata4.ODataUpdateVisitor;
import org.teiid.translator.ws.BinaryWSProcedureExecution;

public class ODataUpdateExecution
extends BaseQueryExecution
implements UpdateExecution {
    private ODataUpdateVisitor visitor;
    private Entity createdEntity;
    private AtomicInteger updateCount = new AtomicInteger();

    public ODataUpdateExecution(Command command, ODataExecutionFactory translator, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) throws TranslatorException {
        super(translator, executionContext, metadata, connection);
        this.visitor = new ODataUpdateVisitor(translator, metadata);
        this.visitor.visitNode((LanguageObject)command);
        if (!this.visitor.exceptions.isEmpty()) {
            throw this.visitor.exceptions.get(0);
        }
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    public void execute() throws TranslatorException {
        ODataUpdateQuery odataQuery = this.visitor.getODataQuery();
        if (this.visitor.getOperationType() == ODataUpdateVisitor.OperationType.DELETE) {
            EntityCollectionIterator ecv = new JsonEntityCollectionIterator(odataQuery, "DELETE");
            try {
                ecv.performUpdateQuery();
            }
            catch (EntityCollectionIterator.NotSupportedAccepts e) {
                ecv = new XMLEntityCollectionIterator(odataQuery, "DELETE");
                try {
                    ecv.performUpdateQuery();
                }
                catch (EntityCollectionIterator.NotSupportedAccepts e1) {
                    throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17032, new Object[0]));
                }
            }
        } else if (this.visitor.getOperationType() == ODataUpdateVisitor.OperationType.UPDATE) {
            EntityCollectionIterator ecv = new JsonEntityCollectionIterator(odataQuery, odataQuery.getUpdateMethod());
            try {
                ecv.performUpdateQuery();
            }
            catch (EntityCollectionIterator.NotSupportedAccepts e) {
                ecv = new XMLEntityCollectionIterator(odataQuery, odataQuery.getUpdateMethod());
                try {
                    ecv.performUpdateQuery();
                }
                catch (EntityCollectionIterator.NotSupportedAccepts e1) {
                    throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17032, new Object[0]));
                }
            }
        } else if (this.visitor.getOperationType() == ODataUpdateVisitor.OperationType.INSERT) {
            this.handleInsert(odataQuery);
        }
    }

    private Map<String, List<String>> getDefaultUpdateHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Accept", Arrays.asList(ContentType.APPLICATION_JSON.toContentTypeString()));
        headers.put("Content-Type", Arrays.asList(ContentType.APPLICATION_JSON.toContentTypeString()));
        return headers;
    }

    private void handleInsert(ODataUpdateQuery odataQuery) throws TranslatorException {
        try {
            Map<String, List<String>> headers = this.getDefaultUpdateHeaders();
            headers.put("Prefer", Arrays.asList("return=representation"));
            String uri = odataQuery.buildInsertURL("");
            InputStream response = null;
            BinaryWSProcedureExecution execution = this.invokeHTTP(odataQuery.getInsertMethod(), uri, odataQuery.getPayload(null), headers);
            if (HttpStatusCode.CREATED.getStatusCode() == execution.getResponseCode()) {
                Blob blob = (Blob)execution.getOutputParameterValues().get(0);
                response = blob.getBinaryStream();
            } else if (HttpStatusCode.NO_CONTENT.getStatusCode() == execution.getResponseCode()) {
                String entityUri = (String)execution.getResponseHeader("Location");
                if (entityUri != null) {
                    response = this.executeQuery("GET", entityUri, null, null, new HttpStatusCode[]{HttpStatusCode.OK});
                }
            } else {
                throw this.buildError(execution);
            }
            if (response != null) {
                JsonDeserializer serializer = new JsonDeserializer(false);
                this.createdEntity = (Entity)serializer.toEntity(response).getPayload();
            }
        }
        catch (ODataDeserializerException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        if (this.visitor.getOperationType() == ODataUpdateVisitor.OperationType.DELETE) {
            return new int[]{this.updateCount.get()};
        }
        if (this.visitor.getOperationType() == ODataUpdateVisitor.OperationType.UPDATE) {
            return new int[]{this.updateCount.get()};
        }
        if (this.visitor.getOperationType() == ODataUpdateVisitor.OperationType.INSERT) {
            if (this.createdEntity != null && this.executionContext.getCommandContext().isReturnAutoGeneratedKeys()) {
                this.addAutoGeneretedKeys(this.visitor.getODataQuery().getRootDocument().getTable(), this.createdEntity);
            }
            return new int[]{1};
        }
        return new int[]{0};
    }

    private void addAutoGeneretedKeys(Table table, Entity entity) throws TranslatorException {
        int cols = table.getPrimaryKey().getColumns().size();
        Class[] columnDataTypes = new Class[cols];
        String[] columnNames = new String[cols];
        String[] odataTypes = new String[cols];
        for (int i = 0; i < cols; ++i) {
            columnDataTypes[i] = ((Column)table.getPrimaryKey().getColumns().get(i)).getJavaType();
            columnNames[i] = ((Column)table.getPrimaryKey().getColumns().get(i)).getName();
            odataTypes[i] = ODataMetadataProcessor.getNativeType((Column)table.getPrimaryKey().getColumns().get(i));
        }
        GeneratedKeys generatedKeys = this.executionContext.getCommandContext().returnGeneratedKeys(columnNames, columnDataTypes);
        ArrayList<Object> vals = new ArrayList<Object>(columnDataTypes.length);
        for (int i = 0; i < columnDataTypes.length; ++i) {
            Object value;
            Property prop = entity.getProperty(columnNames[i]);
            try {
                value = ODataTypeManager.convertToTeiidRuntimeType((Class)columnDataTypes[i], (Object)prop.getValue(), (String)odataTypes[i]);
            }
            catch (TeiidException e) {
                throw new TranslatorException((Throwable)e);
            }
            vals.add(value);
        }
        generatedKeys.addKey(vals);
    }

    class XMLEntityCollectionIterator
    extends EntityCollectionIterator {
        public XMLEntityCollectionIterator(ODataUpdateQuery odataQuery, String method) throws TranslatorException {
            super(odataQuery, method);
        }

        @Override
        public Map<String, List<String>> headers() {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            headers.put("Accept", Arrays.asList(ContentType.APPLICATION_ATOM_XML.toContentTypeString()));
            return headers;
        }

        @Override
        public ODataDeserializer getDeSerializer() {
            return new AtomDeserializer();
        }
    }

    class JsonEntityCollectionIterator
    extends EntityCollectionIterator {
        public JsonEntityCollectionIterator(ODataUpdateQuery odataQuery, String method) throws TranslatorException {
            super(odataQuery, method);
        }

        @Override
        public Map<String, List<String>> headers() {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            headers.put("Accept", Arrays.asList(ContentType.JSON_FULL_METADATA.toContentTypeString()));
            return headers;
        }

        @Override
        public ODataDeserializer getDeSerializer() {
            return new JsonDeserializer(false);
        }
    }

    abstract class EntityCollectionIterator {
        private ODataUpdateQuery odataQuery;
        private String method;
        private String uri;

        public EntityCollectionIterator(ODataUpdateQuery odataQuery, String method) throws TranslatorException {
            this.odataQuery = odataQuery;
            this.method = method;
            this.uri = odataQuery.buildUpdateSelectionURL("");
        }

        public void performUpdateQuery() throws TranslatorException, NotSupportedAccepts {
            while (this.uri != null) {
                BinaryWSProcedureExecution execution = ODataUpdateExecution.this.invokeHTTP("GET", this.uri, null, this.headers());
                if (execution.getResponseCode() == HttpStatusCode.OK.getStatusCode()) {
                    EntityCollection entities = null;
                    Blob blob = (Blob)execution.getOutputParameterValues().get(0);
                    try {
                        InputStream response = blob.getBinaryStream();
                        if (response != null) {
                            ODataDeserializer serializer = this.getDeSerializer();
                            entities = (EntityCollection)serializer.toEntitySet(response).getPayload();
                            URI nextUri = entities.getNext();
                            this.uri = nextUri != null ? nextUri.toString() : null;
                        }
                    }
                    catch (ODataDeserializerException e) {
                        throw new TranslatorException((Throwable)e);
                    }
                    catch (SQLException e) {
                        throw new TranslatorException((Throwable)e);
                    }
                    if (entities == null || entities.getEntities().isEmpty()) continue;
                    for (Entity entity : entities.getEntities()) {
                        this.onEntity(entity, this.method);
                    }
                    continue;
                }
                throw new NotSupportedAccepts();
            }
        }

        public void onEntity(Entity entity, String method) throws TranslatorException {
            Link editLink = entity.getEditLink();
            Map updateHeaders = ODataUpdateExecution.this.getDefaultUpdateHeaders();
            if (entity.getETag() != null) {
                updateHeaders.put("If-Match", Arrays.asList(entity.getETag()));
            }
            BinaryWSProcedureExecution update = ODataUpdateExecution.this.invokeHTTP(method, editLink.getHref(), method.equals("DELETE") ? null : this.odataQuery.getPayload(entity), updateHeaders);
            if (HttpStatusCode.NO_CONTENT.getStatusCode() != update.getResponseCode()) {
                throw ODataUpdateExecution.this.buildError(update);
            }
            ODataUpdateExecution.this.updateCount.incrementAndGet();
        }

        public abstract Map<String, List<String>> headers();

        public abstract ODataDeserializer getDeSerializer();

        class NotSupportedAccepts
        extends Exception {
            NotSupportedAccepts() {
            }
        }
    }
}

