/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.language.Array;
import org.teiid.language.ColumnReference;
import org.teiid.language.Delete;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.SetClause;
import org.teiid.language.Update;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.olingo.common.ODataTypeManager;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.ODataMetadataProcessor;
import org.teiid.translator.odata4.ODataPlugin;
import org.teiid.translator.odata4.ODataUpdateQuery;

public class ODataUpdateVisitor
extends HierarchyVisitor {
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    private ODataUpdateQuery odataQuery;
    private RuntimeMetadata metadata;
    private OperationType operationType;

    public ODataUpdateVisitor(ODataExecutionFactory ef, RuntimeMetadata metadata) {
        this.odataQuery = new ODataUpdateQuery(ef, metadata);
        this.metadata = metadata;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public ODataUpdateQuery getODataQuery() {
        return this.odataQuery;
    }

    public void visit(Insert obj) {
        this.operationType = OperationType.INSERT;
        this.visitNode((LanguageObject)obj.getTable());
        try {
            int elementCount = obj.getColumns().size();
            for (int i = 0; i < elementCount; ++i) {
                Column column = ((ColumnReference)obj.getColumns().get(i)).getMetadataObject();
                List values = ((ExpressionValueSource)obj.getValueSource()).getValues();
                Expression expr = (Expression)values.get(i);
                Object value = this.resolveExpressionValue(expr);
                this.odataQuery.addInsertProperty(column, ODataMetadataProcessor.getNativeType(column), value);
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    private Object resolveExpressionValue(Expression expr) throws TranslatorException {
        ArrayList<Object> value = null;
        if (expr instanceof Literal) {
            value = ((Literal)expr).getValue();
        } else if (expr instanceof Array) {
            Array contents = (Array)expr;
            List arrayExprs = contents.getExpressions();
            ArrayList<Object> values = new ArrayList<Object>();
            for (Expression exp : arrayExprs) {
                if (exp instanceof Literal) {
                    values.add(((Literal)exp).getValue());
                    continue;
                }
                this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17029, new Object[0])));
            }
            value = values;
        } else {
            this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17029, new Object[0])));
        }
        return value;
    }

    public void visit(Update obj) {
        this.operationType = OperationType.UPDATE;
        this.visitNode((LanguageObject)obj.getTable());
        this.odataQuery.setCondition(obj.getWhere());
        try {
            int elementCount = obj.getChanges().size();
            for (int i = 0; i < elementCount; ++i) {
                Column column = ((SetClause)obj.getChanges().get(i)).getSymbol().getMetadataObject();
                String type = ODataTypeManager.odataType((String)column.getRuntimeType()).getFullQualifiedName().getFullQualifiedNameAsString();
                Expression expr = ((SetClause)obj.getChanges().get(i)).getValue();
                Object value = this.resolveExpressionValue(expr);
                this.odataQuery.addUpdateProperty(column, type, value);
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(Delete obj) {
        this.operationType = OperationType.DELETE;
        this.visitNode((LanguageObject)obj.getTable());
        this.odataQuery.setCondition(obj.getWhere());
    }

    public void visit(NamedTable obj) {
        try {
            this.odataQuery.addRootDocument(obj.getMetadataObject());
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    protected static enum OperationType {
        INSERT,
        UPDATE,
        DELETE;

    }
}

