/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlBindingTarget;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlEnumType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlOperation;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlReferentialConstraint;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;
import org.teiid.core.BundleUtil;
import org.teiid.logging.LogManager;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;
import org.teiid.olingo.common.ODataTypeManager;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.WSConnection;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.ODataPlugin;

public class ODataMetadataProcessor
implements MetadataProcessor<WSConnection> {
    private static final String EDM_GEOMETRY = "Edm.Geometry";
    private static final String PARENT_TABLE = "PARENT_TABLE";
    private static final String CONSTRAINT_PROPERTY = "CONSTRAINT_PROPERTY";
    private static final String CONSTRAINT_REF_PROPERTY = "CONSTRAINT_REF_PROPERTY";
    private static final String FK_NAME = "FK_NAME";
    private static final String NAME_SEPARATOR = "_";
    @ExtensionMetadataProperty(applicable={Table.class, Procedure.class}, datatype=String.class, display="Name in OData Schema", description="Name in OData Schema", required=true)
    public static final String NAME_IN_SCHEMA = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}NameInSchema";
    @ExtensionMetadataProperty(applicable={Table.class, Procedure.class}, datatype=String.class, display="OData Type", description="Type of OData Schema Item", allowed="COMPLEX, NAVIGATION, ENTITY, ENTITY_COLLECTION, ACTION, FUNCTION, COMPLEX_COLLECTION, NAVIGATION_COLLECTION", required=true)
    public static final String ODATA_TYPE = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}Type";
    @ExtensionMetadataProperty(applicable={Table.class}, datatype=String.class, display="Merge Into Table", description="Declare the name of table that this table needs to be merged into.")
    public static final String MERGE = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}MERGE";
    @ExtensionMetadataProperty(applicable={Column.class}, datatype=String.class, display="Pseudo Column", description="Pseudo column for join purposes")
    public static final String PSEUDO = "{http://www.jboss.org/teiiddesigner/ext/odata/2012}PSEUDO";
    private String schemaNamespace;
    private ODataExecutionFactory ef;

    void setExecutionfactory(ODataExecutionFactory ef) {
        this.ef = ef;
    }

    public void process(MetadataFactory mf, WSConnection conn) throws TranslatorException {
        XMLMetadata serviceMetadata = this.getSchema(conn);
        try {
            this.getMetadata(mf, serviceMetadata);
        }
        catch (NullPointerException e) {
            throw new TranslatorException((Throwable)e, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17034, new Object[0]));
        }
    }

    protected XMLMetadata getSchema(WSConnection conn) throws TranslatorException {
        if (this.ef != null) {
            return this.ef.getSchema(conn);
        }
        return null;
    }

    void getMetadata(MetadataFactory mf, XMLMetadata metadata) throws TranslatorException {
        String parentTable;
        CsdlSchema csdlSchema = this.getDefaultSchema(metadata);
        CsdlEntityContainer container = csdlSchema.getEntityContainer();
        for (CsdlEntitySet entitySet : container.getEntitySets()) {
            this.addTable(mf, entitySet.getName(), entitySet.getType(), ODataType.ENTITY_COLLECTION, metadata);
        }
        for (CsdlSingleton singleton : container.getSingletons()) {
            this.addTable(mf, singleton.getName(), singleton.getType(), ODataType.ENTITY_COLLECTION, metadata);
        }
        for (CsdlEntitySet entitySet : container.getEntitySets()) {
            this.addNavigationProperties(mf, entitySet.getName(), (CsdlBindingTarget)entitySet, metadata);
        }
        for (CsdlSingleton singleton : container.getSingletons()) {
            this.addNavigationProperties(mf, singleton.getName(), (CsdlBindingTarget)singleton, metadata);
        }
        for (Table table : mf.getSchema().getTables().values()) {
            parentTable = table.getProperty(PARENT_TABLE, false);
            if (parentTable == null) continue;
            this.addPrimaryKeyToComplexTables(mf, table, mf.getSchema().getTable(parentTable));
        }
        for (Table table : mf.getSchema().getTables().values()) {
            parentTable = table.getProperty(PARENT_TABLE, false);
            if (parentTable == null) continue;
            table.setProperty(PARENT_TABLE, null);
            this.addForeignKey(mf, table, mf.getSchema().getTable(parentTable));
        }
        for (CsdlFunctionImport function : container.getFunctionImports()) {
            this.addFunctionImportAsProcedure(mf, function, ODataType.FUNCTION, metadata);
        }
        for (CsdlActionImport action : container.getActionImports()) {
            this.addActionImportAsProcedure(mf, action, ODataType.ACTION, metadata);
        }
    }

    private CsdlSchema getDefaultSchema(XMLMetadata metadata) throws TranslatorException {
        CsdlSchema csdlSchema = null;
        if (this.schemaNamespace != null) {
            csdlSchema = metadata.getSchema(this.schemaNamespace);
        } else if (!metadata.getSchemas().isEmpty()) {
            csdlSchema = (CsdlSchema)metadata.getSchemas().get(0);
        }
        if (csdlSchema == null) {
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17019, new Object[0]));
        }
        return csdlSchema;
    }

    private Table buildTable(MetadataFactory mf, String name) {
        Table table = mf.addTable(name);
        table.setSupportsUpdate(true);
        return table;
    }

    private boolean isSimple(String type) {
        return type.startsWith("Edm");
    }

    private boolean isEnum(XMLMetadata metadata, String type) throws TranslatorException {
        return this.getEnumType(metadata, type) != null;
    }

    private boolean isComplexType(XMLMetadata metadata, String type) throws TranslatorException {
        return this.getComplexType(metadata, type) != null;
    }

    private boolean isEntityType(XMLMetadata metadata, String type) throws TranslatorException {
        return this.getEntityType(metadata, type) != null;
    }

    private Table addTable(MetadataFactory mf, String tableName, String entityType, ODataType odataType, XMLMetadata metadata) throws TranslatorException {
        Table table = this.buildTable(mf, tableName);
        table.setProperty(ODATA_TYPE, odataType.name());
        table.setProperty(NAME_IN_SCHEMA, entityType);
        CsdlEntityType type = this.getEntityType(metadata, entityType);
        this.addEntityTypeProperties(mf, metadata, table, type);
        return table;
    }

    private void addEntityTypeProperties(MetadataFactory mf, XMLMetadata metadata, Table table, CsdlEntityType entityType) throws TranslatorException {
        for (CsdlProperty property : entityType.getProperties()) {
            this.addProperty(mf, metadata, table, property);
        }
        String baseType = entityType.getBaseType();
        while (baseType != null) {
            CsdlEntityType baseEntityType = this.getEntityType(metadata, baseType);
            for (CsdlProperty property : baseEntityType.getProperties()) {
                this.addProperty(mf, metadata, table, property);
            }
            baseType = baseEntityType.getBaseType();
        }
        this.addPrimaryKey(mf, table, entityType.getKey());
    }

    private void addProperty(MetadataFactory mf, XMLMetadata metadata, Table table, CsdlProperty property) throws TranslatorException {
        if (this.isSimple(property.getType()) || this.isEnum(metadata, property.getType())) {
            this.addPropertyAsColumn(mf, table, property);
        } else {
            CsdlComplexType childType = this.getComplexType(metadata, property.getType());
            this.addComplexPropertyAsTable(mf, property, childType, metadata, table);
        }
    }

    static String getPseudo(Column column) {
        return column.getProperty(PSEUDO, false);
    }

    static String getMerge(Table table) {
        return table.getProperty(MERGE, false);
    }

    static boolean isComplexType(Table table) {
        ODataType type = ODataType.valueOf(table.getProperty(ODATA_TYPE, false));
        return type == ODataType.COMPLEX || type == ODataType.COMPLEX_COLLECTION;
    }

    static boolean isNavigationType(Table table) {
        ODataType type = ODataType.valueOf(table.getProperty(ODATA_TYPE, false));
        return type == ODataType.NAVIGATION || type == ODataType.NAVIGATION_COLLECTION;
    }

    static boolean isCollection(Table table) {
        ODataType type = ODataType.valueOf(table.getProperty(ODATA_TYPE, false));
        return type == ODataType.ENTITY_COLLECTION || type == ODataType.COMPLEX_COLLECTION || type == ODataType.NAVIGATION_COLLECTION;
    }

    static boolean isEntitySet(Table table) {
        ODataType type = ODataType.valueOf(table.getProperty(ODATA_TYPE, false));
        return type == ODataType.ENTITY_COLLECTION;
    }

    static String getNativeType(Column column) {
        String nativeType = column.getNativeType();
        if (nativeType == null) {
            nativeType = "Edm.String";
        }
        return nativeType;
    }

    private void addComplexPropertyAsTable(MetadataFactory mf, CsdlProperty parentProperty, CsdlComplexType complexType, XMLMetadata metadata, Table parentTable) throws TranslatorException {
        String tableName = parentTable.getName() + NAME_SEPARATOR + parentProperty.getName();
        Table childTable = this.buildTable(mf, tableName);
        childTable.setProperty(NAME_IN_SCHEMA, parentProperty.getType());
        childTable.setProperty(ODATA_TYPE, parentProperty.isCollection() ? ODataType.COMPLEX_COLLECTION.name() : ODataType.COMPLEX.name());
        childTable.setProperty(PARENT_TABLE, parentTable.getName());
        childTable.setProperty(MERGE, parentTable.getFullName());
        if (ODataMetadataProcessor.isComplexType(parentTable)) {
            childTable.setNameInSource(parentTable.getNameInSource() + "/" + parentProperty.getName());
        } else {
            childTable.setNameInSource(parentProperty.getName());
        }
        for (CsdlProperty property : complexType.getProperties()) {
            this.addProperty(mf, metadata, childTable, property);
        }
        String baseType = complexType.getBaseType();
        while (baseType != null) {
            CsdlComplexType baseComplexType = this.getComplexType(metadata, baseType);
            for (CsdlProperty property : baseComplexType.getProperties()) {
                this.addProperty(mf, metadata, childTable, property);
            }
            baseType = baseComplexType.getBaseType();
        }
    }

    void addPrimaryKey(MetadataFactory mf, Table table, List<CsdlPropertyRef> keys) throws TranslatorException {
        ArrayList<String> pkNames = new ArrayList<String>();
        for (CsdlPropertyRef ref : keys) {
            pkNames.add(ref.getName());
            if (ref.getAlias() == null) continue;
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17018, new Object[]{table.getName(), ref.getName()}));
        }
        mf.addPrimaryKey("PK", pkNames, table);
    }

    private CsdlNavigationPropertyBinding getNavigationPropertyBinding(CsdlBindingTarget entitySet, String name) {
        List bindings = entitySet.getNavigationPropertyBindings();
        for (CsdlNavigationPropertyBinding binding : bindings) {
            String path = binding.getPath();
            int index = path.lastIndexOf(47);
            if (index != -1) {
                path = path.substring(index + 1);
            }
            if (!path.equals(name)) continue;
            return binding;
        }
        return null;
    }

    private CsdlEntityType getEntityType(XMLMetadata metadata, String name) throws TranslatorException {
        if (name == null) {
            return null;
        }
        if (name.contains(".")) {
            int idx = name.lastIndexOf(46);
            String schemaName = name.substring(0, idx);
            CsdlSchema schema = metadata.getSchema(schemaName);
            if (schema == null) {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17021, new Object[]{schemaName}));
            }
            return schema.getEntityType(name.substring(idx + 1));
        }
        return this.getDefaultSchema(metadata).getEntityType(name);
    }

    private List<CsdlFunction> getFunctions(XMLMetadata metadata, String name) throws TranslatorException {
        if (name.contains(".")) {
            int idx = name.lastIndexOf(46);
            CsdlSchema schema = metadata.getSchema(name.substring(0, idx));
            if (schema == null) {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17021, new Object[]{name}));
            }
            return schema.getFunctions(name.substring(idx + 1));
        }
        return this.getDefaultSchema(metadata).getFunctions(name);
    }

    private List<CsdlAction> getActions(XMLMetadata metadata, String name) throws TranslatorException {
        if (name.contains(".")) {
            int idx = name.lastIndexOf(46);
            CsdlSchema schema = metadata.getSchema(name.substring(0, idx));
            if (schema == null) {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17021, new Object[]{name}));
            }
            return schema.getActions(name.substring(idx + 1));
        }
        return this.getDefaultSchema(metadata).getActions(name);
    }

    private CsdlComplexType getComplexType(XMLMetadata metadata, String name) throws TranslatorException {
        if (name.contains(".")) {
            int idx = name.lastIndexOf(46);
            CsdlSchema schema = metadata.getSchema(name.substring(0, idx));
            if (schema == null) {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17021, new Object[]{name}));
            }
            return schema.getComplexType(name.substring(idx + 1));
        }
        return this.getDefaultSchema(metadata).getComplexType(name);
    }

    private CsdlEnumType getEnumType(XMLMetadata metadata, String name) throws TranslatorException {
        if (name.contains(".")) {
            int idx = name.lastIndexOf(46);
            CsdlSchema schema = metadata.getSchema(name.substring(0, idx));
            if (schema == null) {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17021, new Object[]{name}));
            }
            return schema.getEnumType(name.substring(idx + 1));
        }
        return this.getDefaultSchema(metadata).getEnumType(name);
    }

    void addNavigationProperties(MetadataFactory mf, String tableName, CsdlBindingTarget entitySet, XMLMetadata metadata) throws TranslatorException {
        Table fromTable = mf.getSchema().getTable(tableName);
        CsdlEntityType fromEntityType = this.getEntityType(metadata, entitySet.getType());
        Table toTable = null;
        for (CsdlNavigationProperty property : fromEntityType.getNavigationProperties()) {
            StringBuilder name;
            CsdlNavigationPropertyBinding binding = this.getNavigationPropertyBinding(entitySet, property.getName());
            if (binding != null) {
                String target = binding.getTarget();
                int index = target.lastIndexOf(47);
                if (index != -1) {
                    target = target.substring(index + 1);
                }
                toTable = mf.getSchema().getTable(target);
                if (index != -1) {
                    toTable.setNameInSource(binding.getTarget());
                }
            } else {
                name = new StringBuilder().append(fromTable.getName()).append(NAME_SEPARATOR).append(property.getName());
                toTable = this.addTable(mf, name.toString(), property.getType(), property.isCollection() ? ODataType.NAVIGATION_COLLECTION : ODataType.NAVIGATION, metadata);
                toTable.setNameInSource(property.getName());
            }
            if (this.same(fromTable, toTable)) {
                name = new StringBuilder().append(fromTable.getName()).append(NAME_SEPARATOR).append(property.getName());
                toTable = this.addTable(mf, name.toString(), toTable.getProperty(NAME_IN_SCHEMA, false), property.isCollection() ? ODataType.NAVIGATION_COLLECTION : ODataType.NAVIGATION, metadata);
                toTable.setNameInSource(property.getName());
            }
            toTable.setProperty(PARENT_TABLE, fromTable.getName());
            toTable.setProperty(MERGE, fromTable.getFullName());
            toTable.setProperty(FK_NAME, property.getName());
            int i = 0;
            for (CsdlReferentialConstraint constraint : property.getReferentialConstraints()) {
                toTable.setProperty(CONSTRAINT_PROPERTY + i, constraint.getReferencedProperty());
                toTable.setProperty(CONSTRAINT_REF_PROPERTY + i, constraint.getProperty());
                ++i;
            }
        }
    }

    private KeyRecord getPK(MetadataFactory mf, Table table) throws TranslatorException {
        KeyRecord record = table.getPrimaryKey();
        if (record == null) {
            String parentTable = table.getProperty(PARENT_TABLE, false);
            if (parentTable == null) {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17024, new Object[]{table.getName()}));
            }
            return this.getPK(mf, mf.getSchema().getTable(parentTable));
        }
        return record;
    }

    private void addPrimaryKeyToComplexTables(MetadataFactory mf, Table childTable, Table parentTable) throws TranslatorException {
        KeyRecord record = null;
        record = ODataMetadataProcessor.isComplexType(childTable) ? this.getPK(mf, parentTable) : parentTable.getPrimaryKey();
        if (record == null) {
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17025, new Object[]{parentTable.getName()}));
        }
        int i = 0;
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column column : record.getColumns()) {
            Column c;
            String targetColumnName;
            String string = targetColumnName = ODataMetadataProcessor.isCollection(childTable) ? parentTable.getName() + NAME_SEPARATOR + column.getName() : column.getName();
            if (ODataMetadataProcessor.isNavigationType(childTable)) {
                c = mf.getSchema().getTable(childTable.getName()).getColumnByName(targetColumnName);
                if (c == null) {
                    c = this.addColumn(mf, childTable, column, targetColumnName);
                    c.setProperty(PSEUDO, column.getName());
                } else {
                    targetColumnName = column.getName();
                }
            } else {
                c = mf.getSchema().getTable(childTable.getName()).getColumnByName(column.getName());
                if (c == null) {
                    c = this.addColumn(mf, childTable, column, targetColumnName);
                    c.setProperty(PSEUDO, column.getName());
                } else {
                    targetColumnName = column.getName();
                }
            }
            columnNames.add(targetColumnName);
            if (childTable.getProperty(CONSTRAINT_PROPERTY + i, false) == null) {
                childTable.setProperty(CONSTRAINT_PROPERTY + i, targetColumnName);
                childTable.setProperty(CONSTRAINT_REF_PROPERTY + i, column.getName());
            }
            ++i;
        }
        if (ODataMetadataProcessor.isComplexType(childTable)) {
            mf.addPrimaryKey("PK0", columnNames, childTable);
        }
    }

    private void addForeignKey(MetadataFactory mf, Table childTable, Table parentTable) throws TranslatorException {
        String fkName = childTable.getProperty(FK_NAME, false);
        childTable.setProperty(FK_NAME, null);
        if (fkName == null) {
            fkName = "FK0";
        }
        int i = 0;
        ArrayList<String> keyColumns = new ArrayList<String>();
        ArrayList<String> refColumns = new ArrayList<String>();
        while (childTable.getProperty(CONSTRAINT_PROPERTY + i, false) != null) {
            keyColumns.add(childTable.getProperty(CONSTRAINT_PROPERTY + i, false));
            refColumns.add(childTable.getProperty(CONSTRAINT_REF_PROPERTY + i, false));
            childTable.setProperty(CONSTRAINT_PROPERTY + i, null);
            childTable.setProperty(CONSTRAINT_REF_PROPERTY + i, null);
            ++i;
        }
        mf.addForiegnKey(fkName, keyColumns, refColumns, parentTable.getName(), childTable);
    }

    boolean same(Table x, Table y) {
        return x.getFullName().equalsIgnoreCase(y.getFullName());
    }

    boolean keyMatches(List<String> names, KeyRecord record) {
        if (names.size() != record.getColumns().size()) {
            return false;
        }
        TreeSet<String> keyNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Column c : record.getColumns()) {
            keyNames.add(c.getName());
        }
        for (int i = 0; i < names.size(); ++i) {
            if (keyNames.contains(names.get(i))) continue;
            return false;
        }
        return true;
    }

    private Column addPropertyAsColumn(MetadataFactory mf, Table table, CsdlProperty property) {
        Column c = this.buildColumn(mf, table, property);
        c.setNullType(property.isNullable() ? BaseColumn.NullType.Nullable : BaseColumn.NullType.No_Nulls);
        if (property.getMaxLength() != null) {
            c.setLength(property.getMaxLength().intValue());
        }
        if (property.getPrecision() != null) {
            c.setPrecision(property.getPrecision().intValue());
        }
        if (property.getScale() != null) {
            c.setScale(property.getScale().intValue());
        }
        if (property.getDefaultValue() != null) {
            c.setDefaultValue(property.getDefaultValue());
        }
        if (property.getMimeType() != null) {
            c.setProperty("MIME-TYPE", property.getMimeType());
        }
        if (property.getSrid() != null) {
            c.setProperty("{http://www.teiid.org/translator/spatial/2015}srid", property.getSrid().toString());
        }
        if (!property.getType().equals("Edm.String")) {
            if (property.isCollection()) {
                c.setNativeType("Collection(" + property.getType() + ")");
            } else {
                c.setNativeType(property.getType());
            }
        }
        if (property.getType().equals("Edm.String") && property.isCollection()) {
            c.setNativeType("Collection(" + property.getType() + ")");
        }
        return c;
    }

    private Column addColumn(MetadataFactory mf, Table table, Column property, String newName) {
        Column c = mf.addColumn(newName, property.getRuntimeType(), (ColumnSet)table);
        c.setUpdatable(true);
        c.setNullType(property.getNullType());
        c.setLength(property.getLength());
        c.setPrecision(property.getPrecision());
        c.setScale(property.getScale());
        c.setDefaultValue(property.getDefaultValue());
        c.setProperty("MIME-TYPE", c.getProperty("MIME-TYPE", false));
        c.setProperty("{http://www.teiid.org/translator/spatial/2015}srid", property.getProperty("{http://www.teiid.org/translator/spatial/2015}srid", false));
        c.setProperty("NATIVE_TYPE", property.getProperty("NATIVE_TYPE", false));
        return c;
    }

    private ProcedureParameter addParameterAsColumn(MetadataFactory mf, Procedure procedure, CsdlParameter parameter) {
        ProcedureParameter p = mf.addProcedureParameter(parameter.getName(), ODataTypeManager.teiidType((String)parameter.getType(), (boolean)parameter.isCollection()), ProcedureParameter.Type.In, procedure);
        p.setNullType(parameter.isNullable() ? BaseColumn.NullType.Nullable : BaseColumn.NullType.No_Nulls);
        if (parameter.getMaxLength() != null) {
            p.setLength(parameter.getMaxLength().intValue());
        }
        if (parameter.getPrecision() != null) {
            p.setPrecision(parameter.getPrecision().intValue());
        }
        if (parameter.getScale() != null) {
            p.setScale(parameter.getScale().intValue());
        }
        if (parameter.getSrid() != null) {
            p.setProperty("{http://www.teiid.org/translator/spatial/2015}srid", parameter.getSrid().toString());
        }
        return p;
    }

    private Column buildColumn(MetadataFactory mf, Table table, CsdlProperty property) {
        String type;
        String columnName = property.getName();
        Column c = mf.addColumn(columnName, ODataTypeManager.teiidType((String)property.getType(), (boolean)property.isCollection()), (ColumnSet)table);
        if ("geometry".equals(c.getDatatype().getName()) && (type = property.getType()).startsWith(EDM_GEOMETRY) && type.length() > EDM_GEOMETRY.length()) {
            c.setProperty("{http://www.teiid.org/translator/spatial/2015}type", type.substring(EDM_GEOMETRY.length()).toUpperCase());
        }
        if (property.isCollection()) {
            c.setSearchType(Column.SearchType.Unsearchable);
        }
        c.setUpdatable(true);
        return c;
    }

    private void addParameter(MetadataFactory mf, XMLMetadata metadata, Procedure procedure, CsdlParameter parameter) throws TranslatorException {
        if (!this.isSimple(parameter.getType())) {
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17022, new Object[]{parameter.getName()}));
        }
        this.addParameterAsColumn(mf, procedure, parameter);
    }

    void addFunctionImportAsProcedure(MetadataFactory mf, CsdlFunctionImport functionImport, ODataType odataType, XMLMetadata metadata) throws TranslatorException {
        List<CsdlFunction> functions = this.getFunctions(metadata, functionImport.getFunction());
        for (CsdlFunction function : functions) {
            Procedure procedure = mf.addProcedure(function.getName());
            this.addOperation(mf, metadata, odataType, (CsdlOperation)function, procedure);
        }
    }

    private void addProcedureTableReturn(MetadataFactory mf, XMLMetadata metadata, Procedure procedure, CsdlComplexType type, String namePrefix) throws TranslatorException {
        for (CsdlProperty property : type.getProperties()) {
            if (this.isSimple(property.getType()) || this.isEnum(metadata, property.getType())) {
                mf.addProcedureResultSetColumn(namePrefix == null ? property.getName() : namePrefix + NAME_SEPARATOR + property.getName(), ODataTypeManager.teiidType((String)property.getType(), (boolean)property.isCollection()), procedure);
                continue;
            }
            if (this.isComplexType(metadata, property.getType())) {
                CsdlComplexType childType = this.getComplexType(metadata, property.getType());
                this.addProcedureTableReturn(mf, metadata, procedure, childType, property.getName());
                continue;
            }
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17023, new Object[]{procedure.getName()}));
        }
    }

    private void addProcedureTableReturn(MetadataFactory mf, XMLMetadata metadata, Procedure procedure, CsdlEntityType type, String namePrefix) throws TranslatorException {
        for (CsdlProperty property : type.getProperties()) {
            if (this.isSimple(property.getType()) || this.isEnum(metadata, property.getType())) {
                mf.addProcedureResultSetColumn(namePrefix == null ? property.getName() : namePrefix + NAME_SEPARATOR + property.getName(), ODataTypeManager.teiidType((String)property.getType(), (boolean)property.isCollection()), procedure);
                continue;
            }
            if (this.isComplexType(metadata, property.getType())) {
                CsdlComplexType childType = this.getComplexType(metadata, property.getType());
                this.addProcedureTableReturn(mf, metadata, procedure, childType, property.getName());
                continue;
            }
            throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17023, new Object[]{procedure.getName()}));
        }
    }

    private void addActionImportAsProcedure(MetadataFactory mf, CsdlActionImport actionImport, ODataType odataType, XMLMetadata metadata) throws TranslatorException {
        List<CsdlAction> actions = this.getActions(metadata, actionImport.getAction());
        for (CsdlAction action : actions) {
            if (!this.hasComplexParameters(action.getParameters())) {
                Procedure procedure = mf.addProcedure(action.getName());
                this.addOperation(mf, metadata, odataType, (CsdlOperation)action, procedure);
                continue;
            }
            LogManager.logInfo((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17033, new Object[]{action.getName()}));
        }
    }

    private boolean hasComplexParameters(List<CsdlParameter> parameters) {
        for (CsdlParameter parameter : parameters) {
            if (this.isSimple(parameter.getType())) continue;
            return false;
        }
        return false;
    }

    private void addOperation(MetadataFactory mf, XMLMetadata metadata, ODataType odataType, CsdlOperation function, Procedure procedure) throws TranslatorException {
        procedure.setProperty(ODATA_TYPE, odataType.name());
        for (CsdlParameter parameter : function.getParameters()) {
            this.addParameter(mf, metadata, procedure, parameter);
        }
        CsdlReturnType returnType = function.getReturnType();
        if (returnType != null) {
            if (this.isSimple(returnType.getType())) {
                mf.addProcedureParameter("return", ODataTypeManager.teiidType((String)returnType.getType(), (boolean)returnType.isCollection()), ProcedureParameter.Type.ReturnValue, procedure);
            } else if (this.isComplexType(metadata, returnType.getType())) {
                this.addProcedureTableReturn(mf, metadata, procedure, this.getComplexType(metadata, returnType.getType()), null);
                procedure.getResultSet().setProperty(ODATA_TYPE, returnType.isCollection() ? ODataType.COMPLEX_COLLECTION.name() : ODataType.COMPLEX.name());
            } else if (this.isEntityType(metadata, returnType.getType())) {
                this.addProcedureTableReturn(mf, metadata, procedure, this.getEntityType(metadata, returnType.getType()), null);
                procedure.getResultSet().setProperty(ODATA_TYPE, returnType.isCollection() ? ODataType.ENTITY_COLLECTION.name() : ODataType.ENTITY.name());
            } else {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17005, new Object[]{function.getName(), returnType.getType()}));
            }
        }
    }

    public void setSchemaNamespace(String namespace) {
        this.schemaNamespace = namespace;
    }

    List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (Column c : columns) {
            names.add(c.getName());
        }
        return names;
    }

    @TranslatorProperty(display="Schema Namespace", category=TranslatorProperty.PropertyType.IMPORT, description="Namespace of the schema to import")
    public String getSchemaNamespace() {
        return this.schemaNamespace;
    }

    public static enum ODataType {
        COMPLEX,
        NAVIGATION,
        ENTITY,
        ENTITY_COLLECTION,
        ACTION,
        FUNCTION,
        COMPLEX_COLLECTION,
        NAVIGATION_COLLECTION;

    }
}

