/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.client.core.uri.URIBuilderImpl;
import org.teiid.core.BundleUtil;
import org.teiid.language.AggregateFunction;
import org.teiid.language.ColumnReference;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.LanguageUtil;
import org.teiid.language.Limit;
import org.teiid.language.NamedTable;
import org.teiid.language.OrderBy;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.SortSpecification;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.ODataMetadataProcessor;
import org.teiid.translator.odata4.ODataPlugin;
import org.teiid.translator.odata4.ODataSelectQuery;

public class ODataSQLVisitor
extends HierarchyVisitor {
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    protected QueryExpression command;
    protected ODataExecutionFactory executionFactory;
    protected RuntimeMetadata metadata;
    protected ArrayList<Column> projectedColumns = new ArrayList();
    private ODataSelectQuery odataQuery;
    private StringBuilder orderBy = new StringBuilder();
    private boolean count = false;
    private ArrayList<Condition> conditionFragments = new ArrayList();

    public ODataSQLVisitor(ODataExecutionFactory executionFactory, RuntimeMetadata metadata) {
        this.executionFactory = executionFactory;
        this.metadata = metadata;
        this.odataQuery = new ODataSelectQuery(executionFactory, metadata);
    }

    public List<Column> getProjectedColumns() {
        return this.projectedColumns;
    }

    public ODataSelectQuery getODataQuery() {
        return this.odataQuery;
    }

    public boolean isCount() {
        return this.count;
    }

    public String buildURL(String serviceRoot) throws TranslatorException {
        URIBuilderImpl uriBuilder = this.odataQuery.buildURL(serviceRoot, this.projectedColumns, LanguageUtil.combineCriteria(this.conditionFragments));
        if (this.orderBy.length() > 0) {
            uriBuilder.orderBy(this.orderBy.toString());
        }
        URI uri = uriBuilder.build();
        return uri.toString();
    }

    List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (Column c : columns) {
            names.add(c.getName());
        }
        return names;
    }

    public void visit(NamedTable obj) {
        try {
            this.odataQuery.addRootDocument(obj.getMetadataObject());
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(Join obj) {
        if (obj.getLeftItem() instanceof Join) {
            Condition updated = obj.getCondition();
            this.append((LanguageObject)obj.getLeftItem());
            Table right = ((NamedTable)obj.getRightItem()).getMetadataObject();
            try {
                updated = this.odataQuery.addNavigation(obj.getCondition(), obj.getJoinType(), right);
                obj.setCondition(updated);
                if (updated != null) {
                    this.conditionFragments.add(obj.getCondition());
                }
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
            }
        } else if (obj.getRightItem() instanceof Join) {
            Condition updated = obj.getCondition();
            this.append((LanguageObject)obj.getRightItem());
            Table left = ((NamedTable)obj.getLeftItem()).getMetadataObject();
            try {
                updated = this.odataQuery.addNavigation(obj.getCondition(), obj.getJoinType(), left);
                obj.setCondition(updated);
                if (updated != null) {
                    this.conditionFragments.add(obj.getCondition());
                }
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
            }
        } else {
            Condition updated = obj.getCondition();
            Table left = ((NamedTable)obj.getLeftItem()).getMetadataObject();
            Table right = ((NamedTable)obj.getRightItem()).getMetadataObject();
            try {
                if (ODataMetadataProcessor.isComplexType(left) || ODataMetadataProcessor.isNavigationType(left)) {
                    throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17027, new Object[]{left.getName()}));
                }
                updated = this.odataQuery.addNavigation(obj.getCondition(), obj.getJoinType(), left, right);
                obj.setCondition(updated);
                if (updated != null) {
                    this.conditionFragments.add(obj.getCondition());
                }
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
            }
        }
    }

    public void visit(Limit obj) {
        if (obj.getRowOffset() != 0) {
            this.odataQuery.setSkip(new Integer(obj.getRowOffset()));
        }
        if (obj.getRowLimit() != 0) {
            this.odataQuery.setTop(new Integer(obj.getRowLimit()));
        }
    }

    public void visit(OrderBy obj) {
        this.append(obj.getSortSpecifications());
    }

    public void visit(SortSpecification obj) {
        if (this.orderBy.length() > 0) {
            this.orderBy.append(",");
        }
        ColumnReference column = (ColumnReference)obj.getExpression();
        try {
            Column c = this.normalizePseudoColumn(column.getMetadataObject());
            this.orderBy.append(c.getName());
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
        if (obj.getOrdering() == SortSpecification.Ordering.DESC) {
            this.orderBy.append(" ").append("DESC".toLowerCase());
        }
    }

    public void visit(Select obj) {
        this.visitNodes(obj.getFrom());
        this.conditionFragments.add(obj.getWhere());
        this.visitNode((LanguageObject)obj.getOrderBy());
        this.visitNode((LanguageObject)obj.getLimit());
        this.visitNodes(obj.getDerivedColumns());
    }

    public void visit(DerivedColumn obj) {
        if (obj.getExpression() instanceof ColumnReference) {
            Column column = ((ColumnReference)obj.getExpression()).getMetadataObject();
            if (!column.isSelectable()) {
                this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17006, new Object[]{column.getName()})));
            }
            try {
                this.projectedColumns.add(this.normalizePseudoColumn(column));
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
            }
        } else if (obj.getExpression() instanceof AggregateFunction) {
            AggregateFunction func = (AggregateFunction)obj.getExpression();
            if (func.getName().equalsIgnoreCase("COUNT")) {
                this.odataQuery.setAsCount();
            } else {
                this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17007, new Object[]{func.getName()})));
            }
        } else {
            this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17008, new Object[0])));
        }
    }

    private Column normalizePseudoColumn(Column column) throws TranslatorException {
        String pseudo = ODataMetadataProcessor.getPseudo(column);
        if (pseudo != null) {
            try {
                Table columnParent = (Table)column.getParent();
                Table pseudoColumnParent = this.metadata.getTable(ODataMetadataProcessor.getMerge(columnParent));
                return pseudoColumnParent.getColumnByName(pseudo);
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
            }
        }
        return column;
    }

    public void append(LanguageObject obj) {
        this.visitNode(obj);
    }

    protected void append(List<? extends LanguageObject> items) {
        if (items != null && items.size() != 0) {
            for (int i = 0; i < items.size(); ++i) {
                this.append(items.get(i));
            }
        }
    }

    protected void append(LanguageObject[] items) {
        if (items != null && items.length != 0) {
            for (int i = 0; i < items.length; ++i) {
                this.append(items[i]);
            }
        }
    }
}

