/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.olingo.client.api.edm.xml.DataServices;
import org.apache.olingo.client.api.edm.xml.Edmx;
import org.apache.olingo.client.api.edm.xml.XMLMetadata;
import org.apache.olingo.client.core.edm.ClientCsdlXMLMetadata;
import org.apache.olingo.client.core.edm.xml.ClientCsdlEdmx;
import org.apache.olingo.client.core.serialization.ClientODataDeserializerImpl;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.provider.CsdlAction;
import org.apache.olingo.commons.api.edm.provider.CsdlActionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityContainer;
import org.apache.olingo.commons.api.edm.provider.CsdlEntitySet;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlFunction;
import org.apache.olingo.commons.api.edm.provider.CsdlFunctionImport;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlParameter;
import org.apache.olingo.commons.api.edm.provider.CsdlProperty;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlReferentialConstraint;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;
import org.apache.olingo.commons.api.edm.provider.CsdlSchema;
import org.apache.olingo.commons.api.format.ContentType;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.UDFSource;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.ODataMetadataProcessor;
import org.teiid.translator.ws.WSConnection;

public class TestODataMetadataProcessor {
    private ODataExecutionFactory translator;

    public static TransformationMetadata getTransformationMetadata(MetadataFactory mf, ODataExecutionFactory ef) throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"trippin", (FunctionTree[])new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource((Collection)ef.getPushDownFunctions()))});
        ValidatorReport report = new MetadataValidator().validate(metadata.getVdbMetaData(), (MetadataStore)metadata.getMetadataStore());
        if (report.hasItems()) {
            throw new RuntimeException(report.getFailureMessage());
        }
        return metadata;
    }

    static MetadataFactory tripPinMetadata() throws TranslatorException {
        String file = "trippin.xml";
        String schema = "trippin";
        String schemaNamespace = "Microsoft.OData.SampleService.Models.TripPin";
        return TestODataMetadataProcessor.createMetadata(file, schema, schemaNamespace);
    }

    private static MetadataFactory createMetadata(final String file, String schema, String schemaNamespace) throws TranslatorException {
        ODataMetadataProcessor processor = new ODataMetadataProcessor(){

            protected XMLMetadata getSchema(WSConnection conn) throws TranslatorException {
                try {
                    ClientODataDeserializerImpl deserializer = new ClientODataDeserializerImpl(false, ContentType.APPLICATION_XML);
                    XMLMetadata metadata = deserializer.toMetadata((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)file)));
                    return metadata;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Properties props = new Properties();
        props.setProperty("schemaNamespace", schemaNamespace);
        processor.setSchemaNamespace(schemaNamespace);
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, schema, SystemMetadata.getInstance().getRuntimeTypeMap(), props, null);
        processor.process(mf, null);
        return mf;
    }

    @Test(expected=TranslatorException.class)
    public void testOlderSchema() throws Exception {
        this.translator = new ODataExecutionFactory();
        this.translator.start();
        MetadataFactory mf = TestODataMetadataProcessor.createMetadata("northwind_v2.xml", "northwind", "NorthwindModel");
        TestODataMetadataProcessor.getTransformationMetadata(mf, this.translator);
    }

    @Test
    public void testSchema() throws Exception {
        this.translator = new ODataExecutionFactory();
        this.translator.start();
        MetadataFactory mf = TestODataMetadataProcessor.tripPinMetadata();
        TransformationMetadata metadata = TestODataMetadataProcessor.getTransformationMetadata(mf, this.translator);
        String ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        MetadataFactory mf2 = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        QueryParser.getQueryParser().parseDDL(mf2, ddl);
        Procedure p = mf.getSchema().getProcedure("ResetDataSource");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)0L, (long)p.getParameters().size());
    }

    static CsdlProperty createProperty(String name, EdmPrimitiveTypeKind type) {
        return new CsdlProperty().setName(name).setType(type.getFullQualifiedName());
    }

    static CsdlParameter createParameter(String name, EdmPrimitiveTypeKind type) {
        return new CsdlParameter().setName(name).setType(type.getFullQualifiedName());
    }

    static XMLMetadata buildXmlMetadata(Object ... schemaElements) {
        final CsdlSchema schema = new CsdlSchema();
        schema.setNamespace("namespace");
        schema.setEntityContainer(new CsdlEntityContainer());
        ArrayList<CsdlEntitySet> entitySets = new ArrayList<CsdlEntitySet>();
        ArrayList<CsdlEntityType> entityTypes = new ArrayList<CsdlEntityType>();
        ArrayList<CsdlComplexType> complexTypes = new ArrayList<CsdlComplexType>();
        ArrayList<CsdlFunctionImport> functionImports = new ArrayList<CsdlFunctionImport>();
        ArrayList<CsdlFunction> functions = new ArrayList<CsdlFunction>();
        ArrayList<CsdlActionImport> actionImports = new ArrayList<CsdlActionImport>();
        ArrayList<CsdlAction> actions = new ArrayList<CsdlAction>();
        for (Object obj : schemaElements) {
            if (obj instanceof CsdlEntitySet) {
                entitySets.add((CsdlEntitySet)obj);
                continue;
            }
            if (obj instanceof CsdlEntityType) {
                entityTypes.add((CsdlEntityType)obj);
                continue;
            }
            if (obj instanceof CsdlComplexType) {
                complexTypes.add((CsdlComplexType)obj);
                continue;
            }
            if (obj instanceof CsdlFunctionImport) {
                functionImports.add((CsdlFunctionImport)obj);
                continue;
            }
            if (obj instanceof CsdlFunction) {
                functions.add((CsdlFunction)obj);
                continue;
            }
            if (obj instanceof CsdlActionImport) {
                actionImports.add((CsdlActionImport)obj);
                continue;
            }
            if (!(obj instanceof CsdlAction)) continue;
            actions.add((CsdlAction)obj);
        }
        schema.setEntityTypes(entityTypes);
        schema.setComplexTypes(complexTypes);
        schema.setActions(actions);
        schema.setFunctions(functions);
        schema.getEntityContainer().setEntitySets(entitySets);
        schema.getEntityContainer().setFunctionImports(functionImports);
        schema.getEntityContainer().setActionImports(actionImports);
        ClientCsdlEdmx edmx = new ClientCsdlEdmx();
        edmx.setVersion("1.0");
        edmx.setDataServices(new DataServices(){

            public List<CsdlSchema> getSchemas() {
                return Arrays.asList(schema);
            }

            public String getMaxDataServiceVersion() {
                return "4.0";
            }

            public String getDataServiceVersion() {
                return "4.0";
            }
        });
        return new ClientCsdlXMLMetadata((Edmx)edmx);
    }

    static CsdlEntitySet createES(String name, String entityType) {
        CsdlEntitySet es = new CsdlEntitySet();
        es.setName(name);
        es.setType(new FullQualifiedName(entityType));
        return es;
    }

    @Test
    public void testEnititySet() throws Exception {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "trippin", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        ArrayList<CsdlProperty> properties = new ArrayList<CsdlProperty>();
        properties.add(TestODataMetadataProcessor.createProperty("name", EdmPrimitiveTypeKind.String).setMaxLength(Integer.valueOf(25)).setNullable(false));
        properties.add(TestODataMetadataProcessor.createProperty("dob", EdmPrimitiveTypeKind.DateTimeOffset).setNullable(true));
        properties.add(TestODataMetadataProcessor.createProperty("ssn", EdmPrimitiveTypeKind.Int64).setNullable(false));
        CsdlEntityType entityType = new CsdlEntityType();
        entityType.setName("Person");
        entityType.setProperties(properties);
        entityType.setKey(Arrays.asList(new CsdlPropertyRef().setName("ssn")));
        CsdlEntitySet es = TestODataMetadataProcessor.createES("Persons", "namespace.Person");
        XMLMetadata metadata = TestODataMetadataProcessor.buildXmlMetadata(es, entityType);
        processor.getMetadata(mf, metadata);
        Assert.assertNotNull((Object)mf.getSchema().getTable("Persons"));
        Table person = mf.getSchema().getTable("Persons");
        Assert.assertEquals((long)3L, (long)person.getColumns().size());
        Assert.assertNotNull((Object)person.getColumnByName("name"));
        Assert.assertNotNull((Object)person.getColumnByName("dob"));
        Assert.assertNotNull((Object)person.getColumnByName("ssn"));
        Column name = person.getColumnByName("name");
        Column dob = person.getColumnByName("dob");
        Column ssn = person.getColumnByName("ssn");
        Assert.assertEquals((Object)"string", (Object)name.getDatatype().getRuntimeTypeName());
        Assert.assertEquals((Object)"timestamp", (Object)dob.getDatatype().getRuntimeTypeName());
        Assert.assertEquals((Object)"long", (Object)ssn.getDatatype().getRuntimeTypeName());
        Assert.assertTrue((name.getNullType() == BaseColumn.NullType.No_Nulls ? 1 : 0) != 0);
        Assert.assertTrue((dob.getNullType() == BaseColumn.NullType.Nullable ? 1 : 0) != 0);
        Assert.assertTrue((ssn.getNullType() == BaseColumn.NullType.No_Nulls ? 1 : 0) != 0);
        Assert.assertEquals((long)25L, (long)name.getLength());
        Assert.assertNotNull((Object)person.getPrimaryKey());
        Assert.assertEquals((long)1L, (long)person.getPrimaryKey().getColumns().size());
        Assert.assertEquals((Object)"ssn", (Object)((Column)person.getPrimaryKey().getColumns().get(0)).getName());
        Assert.assertTrue((boolean)person.getForeignKeys().isEmpty());
    }

    @Test
    public void testEnititySetWithComplexType() throws Exception {
        MetadataFactory mf = TestODataMetadataProcessor.getEntityWithComplexProperty();
        Assert.assertEquals((long)3L, (long)mf.getSchema().getTables().size());
        Assert.assertNotNull((Object)mf.getSchema().getTable("Persons"));
        Assert.assertNotNull((Object)mf.getSchema().getTable("Persons_address"));
        Assert.assertNotNull((Object)mf.getSchema().getTable("Persons_secondaddress"));
        Table personTable = mf.getSchema().getTable("Persons");
        Assert.assertEquals((long)2L, (long)personTable.getColumns().size());
        Assert.assertNotNull((Object)personTable.getPrimaryKey());
        Table addressTable = mf.getSchema().getTable("Persons_address");
        Assert.assertEquals((long)4L, (long)addressTable.getColumns().size());
        Assert.assertNotNull((Object)addressTable.getColumnByName("Persons_ssn"));
        Assert.assertTrue((boolean)ODataMetadataProcessor.isPseudo((Column)addressTable.getColumnByName("Persons_ssn")));
        Assert.assertTrue((boolean)addressTable.getColumnByName("Persons_ssn").isSelectable());
        Assert.assertEquals((long)1L, (long)addressTable.getForeignKeys().size());
        Assert.assertEquals((Object)"northwind.Persons", (Object)((ForeignKey)addressTable.getForeignKeys().get(0)).getReferenceTableName());
    }

    static MetadataFactory getEntityWithComplexProperty() throws TranslatorException {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        CsdlComplexType address = TestODataMetadataProcessor.complexType("Address");
        XMLMetadata metadata = TestODataMetadataProcessor.buildXmlMetadata(TestODataMetadataProcessor.createES("Persons", "namespace.Person"), TestODataMetadataProcessor.buildPersonEntity(address), address);
        processor.getMetadata(mf, metadata);
        return mf;
    }

    @Test
    public void testMultipleEnititySetWithSameComplexType() throws Exception {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        CsdlComplexType address = TestODataMetadataProcessor.complexType("Address");
        XMLMetadata metadata = TestODataMetadataProcessor.buildXmlMetadata(TestODataMetadataProcessor.createES("Persons", "namespace.Person"), TestODataMetadataProcessor.buildPersonEntity(address), address, TestODataMetadataProcessor.createES("Corporate", "namespace.Business"), this.buildBusinessEntity(address));
        processor.getMetadata(mf, metadata);
        Assert.assertEquals((long)5L, (long)mf.getSchema().getTables().size());
        Assert.assertNotNull((Object)mf.getSchema().getTable("Persons"));
        Assert.assertNotNull((Object)mf.getSchema().getTable("Corporate"));
        Assert.assertNotNull((Object)mf.getSchema().getTable("Persons_address"));
        Assert.assertNotNull((Object)mf.getSchema().getTable("Corporate_address"));
        Table personTable = mf.getSchema().getTable("Persons");
        Assert.assertEquals((long)2L, (long)personTable.getColumns().size());
        Table personAddress = mf.getSchema().getTable("Persons_address");
        Assert.assertEquals((long)4L, (long)personAddress.getColumns().size());
        ForeignKey fk = (ForeignKey)personAddress.getForeignKeys().get(0);
        Assert.assertNotNull((Object)fk.getColumnByName("Persons_ssn"));
        Table businessTable = mf.getSchema().getTable("Corporate");
        Assert.assertEquals((long)1L, (long)businessTable.getColumns().size());
        Table corporateAddress = mf.getSchema().getTable("Corporate_address");
        Assert.assertEquals((long)4L, (long)corporateAddress.getColumns().size());
        fk = (ForeignKey)corporateAddress.getForeignKeys().get(0);
        Assert.assertNotNull((Object)fk.getColumnByName("Corporate_name"));
    }

    @Test
    public void testOneToOneAssosiation() throws Exception {
        MetadataFactory mf = TestODataMetadataProcessor.oneToOneRelationMetadata(true);
        Table g1 = mf.getSchema().getTable("G1");
        Table g2 = mf.getSchema().getTable("G2");
        ForeignKey fk = (ForeignKey)g1.getForeignKeys().get(0);
        Assert.assertEquals((Object)"G2_one_2_one", (Object)fk.getName());
        Assert.assertNotNull((Object)fk.getColumnByName("e1"));
        fk = (ForeignKey)g2.getForeignKeys().get(0);
        Assert.assertEquals((Object)"G1_one_2_one", (Object)fk.getName());
        Assert.assertNotNull((Object)fk.getColumnByName("e1"));
        mf = TestODataMetadataProcessor.oneToOneRelationMetadata(false);
        g1 = mf.getSchema().getTable("G1");
        g2 = mf.getSchema().getTable("G2");
        fk = (ForeignKey)g1.getForeignKeys().get(0);
        Assert.assertEquals((Object)"G2_one_2_one", (Object)fk.getName());
        Assert.assertNotNull((Object)fk.getColumnByName("e1"));
        Assert.assertTrue((boolean)g2.getForeignKeys().isEmpty());
    }

    @Test
    public void testFunction() throws Exception {
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType("Edm.String");
        MetadataFactory mf = TestODataMetadataProcessor.functionMetadata("invoke", returnType, null);
        Procedure p = mf.getSchema().getProcedure("invoke");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)3L, (long)p.getParameters().size());
        Assert.assertNull((Object)p.getResultSet());
        Assert.assertNotNull((Object)this.getReturnParameter(p));
        ProcedureParameter pp = this.getReturnParameter(p);
        Assert.assertEquals((Object)"string", (Object)pp.getRuntimeType());
        ODataMetadataProcessor.ODataType type = ODataMetadataProcessor.ODataType.valueOf((String)p.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}Type", false));
        Assert.assertEquals((Object)ODataMetadataProcessor.ODataType.FUNCTION, (Object)type);
    }

    @Test
    public void testAction() throws Exception {
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType("Edm.String");
        MetadataFactory mf = TestODataMetadataProcessor.actionMetadata("invoke", returnType, null);
        Procedure p = mf.getSchema().getProcedure("invoke");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)3L, (long)p.getParameters().size());
        Assert.assertNull((Object)p.getResultSet());
        Assert.assertNotNull((Object)this.getReturnParameter(p));
        ProcedureParameter pp = this.getReturnParameter(p);
        Assert.assertEquals((Object)"string", (Object)pp.getRuntimeType());
        ODataMetadataProcessor.ODataType type = ODataMetadataProcessor.ODataType.valueOf((String)p.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}Type", false));
        Assert.assertEquals((Object)ODataMetadataProcessor.ODataType.ACTION, (Object)type);
    }

    @Test
    public void testFunctionReturnPrimitiveCollection() throws Exception {
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType("Edm.String");
        returnType.setCollection(true);
        MetadataFactory mf = TestODataMetadataProcessor.functionMetadata("invoke", returnType, null);
        Procedure p = mf.getSchema().getProcedure("invoke");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)3L, (long)p.getParameters().size());
        Assert.assertNull((Object)p.getResultSet());
        Assert.assertNotNull((Object)this.getReturnParameter(p));
        ProcedureParameter pp = this.getReturnParameter(p);
        Assert.assertEquals((Object)"string[]", (Object)pp.getRuntimeType());
        ODataMetadataProcessor.ODataType type = ODataMetadataProcessor.ODataType.valueOf((String)p.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}Type", false));
        Assert.assertEquals((Object)ODataMetadataProcessor.ODataType.FUNCTION, (Object)type);
    }

    @Test
    public void testFunctionReturnComplex() throws Exception {
        CsdlComplexType complex = TestODataMetadataProcessor.complexType("Address");
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType("namespace.Address");
        MetadataFactory mf = TestODataMetadataProcessor.functionMetadata("invoke", returnType, complex);
        Procedure p = mf.getSchema().getProcedure("invoke");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)2L, (long)p.getParameters().size());
        Assert.assertNotNull((Object)p.getResultSet());
        Assert.assertNull((Object)this.getReturnParameter(p));
        ColumnSet table = p.getResultSet();
        ODataMetadataProcessor.ODataType type = ODataMetadataProcessor.ODataType.valueOf((String)p.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}Type", false));
        Assert.assertEquals((Object)ODataMetadataProcessor.ODataType.FUNCTION, (Object)type);
        type = ODataMetadataProcessor.ODataType.valueOf((String)table.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}Type", false));
        Assert.assertEquals((Object)ODataMetadataProcessor.ODataType.COMPLEX, (Object)type);
    }

    @Test
    public void testFunctionReturnComplexCollection() throws Exception {
        CsdlComplexType complex = TestODataMetadataProcessor.complexType("Address");
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType("namespace.Address");
        returnType.setCollection(true);
        MetadataFactory mf = TestODataMetadataProcessor.functionMetadata("invoke", returnType, complex);
        Procedure p = mf.getSchema().getProcedure("invoke");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((long)2L, (long)p.getParameters().size());
        Assert.assertNotNull((Object)p.getResultSet());
        Assert.assertNull((Object)this.getReturnParameter(p));
        ColumnSet table = p.getResultSet();
        ODataMetadataProcessor.ODataType type = ODataMetadataProcessor.ODataType.valueOf((String)p.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}Type", false));
        Assert.assertEquals((Object)ODataMetadataProcessor.ODataType.FUNCTION, (Object)type);
        type = ODataMetadataProcessor.ODataType.valueOf((String)table.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}Type", false));
        Assert.assertEquals((Object)ODataMetadataProcessor.ODataType.COMPLEX_COLLECTION, (Object)type);
    }

    @Test
    public void testNorthwind() throws Exception {
        String file = "northwind_v4.xml";
        String schema = "northwind";
        String schemaNamespace = "ODataWebExperimental.Northwind.Model";
        MetadataFactory mf = TestODataMetadataProcessor.createMetadata(file, schema, schemaNamespace);
        String metadataDDL = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        Assert.assertEquals((Object)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"northwind_v4.ddl")), (Object)metadataDDL);
    }

    @Test
    public void testTeiidImplicitFk() throws Exception {
        String file = "teiid-implicit.xml";
        String schema = "teiid";
        String schemaNamespace = "teiid5221data.1.data";
        MetadataFactory mf = TestODataMetadataProcessor.createMetadata(file, schema, schemaNamespace);
        String metadataDDL = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        Assert.assertEquals((Object)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"teiid-implicit.ddl")), (Object)metadataDDL);
    }

    private ProcedureParameter getReturnParameter(Procedure procedure) {
        for (ProcedureParameter pp : procedure.getParameters()) {
            if (pp.getType() != ProcedureParameter.Type.ReturnValue) continue;
            return pp;
        }
        return null;
    }

    static MetadataFactory oneToOneRelationMetadata(boolean bothDirections) throws TranslatorException {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        CsdlEntityType g1Entity = TestODataMetadataProcessor.entityType("g1");
        CsdlEntityType g2Entity = TestODataMetadataProcessor.entityType("g2");
        CsdlNavigationProperty navProperty = new CsdlNavigationProperty();
        navProperty.setName("one_2_one");
        navProperty.setType("namespace.g2");
        navProperty.setNullable(Boolean.valueOf(false));
        navProperty.setPartner("PartnerPath");
        g1Entity.setNavigationProperties(Arrays.asList(navProperty));
        if (bothDirections) {
            CsdlNavigationProperty nav2Property = new CsdlNavigationProperty();
            nav2Property.setName("one_2_one");
            nav2Property.setType("namespace.g1");
            nav2Property.setNullable(Boolean.valueOf(false));
            nav2Property.setPartner("PartnerPath");
            g2Entity.setNavigationProperties(Arrays.asList(nav2Property));
        }
        CsdlEntitySet g1Set = TestODataMetadataProcessor.createES("G1", "namespace.g1");
        CsdlEntitySet g2Set = TestODataMetadataProcessor.createES("G2", "namespace.g2");
        CsdlNavigationPropertyBinding navBinding = new CsdlNavigationPropertyBinding();
        navBinding.setPath("one_2_one");
        navBinding.setTarget("G2");
        g1Set.setNavigationPropertyBindings(Arrays.asList(navBinding));
        if (bothDirections) {
            CsdlNavigationPropertyBinding nav2Binding = new CsdlNavigationPropertyBinding();
            nav2Binding.setPath("one_2_one");
            nav2Binding.setTarget("G1");
            g2Set.setNavigationPropertyBindings(Arrays.asList(nav2Binding));
        }
        XMLMetadata metadata = TestODataMetadataProcessor.buildXmlMetadata(g1Entity, g1Set, g2Entity, g2Set);
        processor.getMetadata(mf, metadata);
        return mf;
    }

    static MetadataFactory functionMetadata(String name, CsdlReturnType returnType, Object other) throws TranslatorException {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        CsdlFunction func = TestODataMetadataProcessor.function(name, returnType);
        CsdlFunctionImport funcImport = new CsdlFunctionImport();
        funcImport.setFunction(new FullQualifiedName("namespace." + name));
        funcImport.setName(name);
        XMLMetadata metadata = TestODataMetadataProcessor.buildXmlMetadata(funcImport, func, other);
        processor.getMetadata(mf, metadata);
        return mf;
    }

    static MetadataFactory actionMetadata(String name, CsdlReturnType returnType, Object other) throws TranslatorException {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        CsdlAction func = TestODataMetadataProcessor.action(name, returnType);
        CsdlActionImport funcImport = new CsdlActionImport();
        funcImport.setAction(new FullQualifiedName("namespace." + name));
        funcImport.setName(name);
        XMLMetadata metadata = TestODataMetadataProcessor.buildXmlMetadata(funcImport, func, other);
        processor.getMetadata(mf, metadata);
        return mf;
    }

    @Test
    public void testSelfJoin() throws Exception {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        CsdlEntityType g1Entity = TestODataMetadataProcessor.entityType("g1");
        CsdlNavigationProperty navProperty = new CsdlNavigationProperty();
        navProperty.setName("self");
        navProperty.setType("Collection(namespace.g1)");
        navProperty.setNullable(Boolean.valueOf(false));
        navProperty.setPartner("PartnerPath");
        navProperty.setCollection(true);
        g1Entity.setNavigationProperties(Arrays.asList(navProperty));
        CsdlEntitySet g1Set = TestODataMetadataProcessor.createES("G1", "namespace.g1");
        CsdlNavigationPropertyBinding navBinding = new CsdlNavigationPropertyBinding();
        navBinding.setPath("self");
        navBinding.setTarget("G1");
        g1Set.setNavigationPropertyBindings(Arrays.asList(navBinding));
        XMLMetadata metadata = TestODataMetadataProcessor.buildXmlMetadata(g1Entity, g1Set);
        processor.getMetadata(mf, metadata);
        Table g1 = mf.getSchema().getTable("G1_self");
        Assert.assertNotNull((Object)g1);
        Assert.assertEquals((Object)"FK0", (Object)((ForeignKey)g1.getForeignKeys().get(0)).getName());
        Assert.assertNotNull((Object)((ForeignKey)g1.getForeignKeys().get(0)).getColumnByName("G1_e1"));
        Assert.assertEquals((Object)"self", (Object)g1.getNameInSource());
    }

    @Test
    public void testOneToManyAssosiation() throws Exception {
        MetadataFactory mf = TestODataMetadataProcessor.oneToManyRelationMetadata();
        Table g1 = mf.getSchema().getTable("G1");
        Table g2 = mf.getSchema().getTable("G2");
        ForeignKey fk = (ForeignKey)g2.getForeignKeys().get(0);
        Assert.assertEquals((Object)"G1_one_2_many", (Object)fk.getName());
        Assert.assertNotNull((Object)fk.getColumnByName("e1"));
    }

    @Test
    public void testMultipleNavigationProperties() throws Exception {
        MetadataFactory mf = TestODataMetadataProcessor.multipleNavigationProperties();
        String metadataDDL = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        Table g1 = mf.getSchema().getTable("G1");
        Table g2 = mf.getSchema().getTable("G2");
        ForeignKey fk = (ForeignKey)g2.getForeignKeys().get(0);
        Assert.assertEquals((Object)"G1_one_2_many", (Object)fk.getName());
        Assert.assertNotNull((Object)fk.getColumnByName("e1"));
    }

    static MetadataFactory oneToManyRelationMetadata() throws TranslatorException {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        CsdlEntityType g1Entity = TestODataMetadataProcessor.entityType("g1");
        CsdlEntityType g2Entity = TestODataMetadataProcessor.multipleKeyEntityType("g2");
        CsdlNavigationProperty navProperty = new CsdlNavigationProperty();
        navProperty.setName("one_2_many");
        navProperty.setType("Collection(namespace.g2)");
        navProperty.setNullable(Boolean.valueOf(false));
        navProperty.setPartner("PartnerPath");
        navProperty.setCollection(true);
        g1Entity.setNavigationProperties(Arrays.asList(navProperty));
        CsdlEntitySet g1Set = TestODataMetadataProcessor.createES("G1", "namespace.g1");
        CsdlEntitySet g2Set = TestODataMetadataProcessor.createES("G2", "namespace.g2");
        CsdlNavigationPropertyBinding navBinding = new CsdlNavigationPropertyBinding();
        navBinding.setPath("one_2_many");
        navBinding.setTarget("G2");
        g1Set.setNavigationPropertyBindings(Arrays.asList(navBinding));
        XMLMetadata metadata = TestODataMetadataProcessor.buildXmlMetadata(g1Entity, g1Set, g2Entity, g2Set);
        processor.getMetadata(mf, metadata);
        return mf;
    }

    static MetadataFactory multipleNavigationProperties() throws TranslatorException {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        CsdlEntityType g1Entity = TestODataMetadataProcessor.entityType("g1");
        CsdlEntityType g2Entity = TestODataMetadataProcessor.entityType("g2");
        CsdlEntityType g3Entity = TestODataMetadataProcessor.entityType("g3");
        CsdlNavigationProperty navProperty = new CsdlNavigationProperty();
        navProperty.setName("one_2_many");
        navProperty.setType("Collection(namespace.g2)");
        navProperty.setNullable(Boolean.valueOf(false));
        navProperty.setPartner("PartnerPath");
        navProperty.setCollection(true);
        CsdlNavigationProperty navProperty2 = new CsdlNavigationProperty();
        navProperty2.setName("one_2_g3");
        navProperty2.setType("namespace.g3");
        navProperty2.setNullable(Boolean.valueOf(true));
        g1Entity.setNavigationProperties(Arrays.asList(navProperty, navProperty2));
        CsdlEntitySet g1Set = TestODataMetadataProcessor.createES("G1", "namespace.g1");
        CsdlEntitySet g2Set = TestODataMetadataProcessor.createES("G2", "namespace.g2");
        CsdlEntitySet g3Set = TestODataMetadataProcessor.createES("G3", "namespace.g3");
        CsdlNavigationPropertyBinding navBinding = new CsdlNavigationPropertyBinding();
        navBinding.setPath("one_2_many");
        navBinding.setTarget("G2");
        CsdlNavigationPropertyBinding navBinding2 = new CsdlNavigationPropertyBinding();
        navBinding2.setPath("one_2_g3");
        navBinding2.setTarget("G3");
        g1Set.setNavigationPropertyBindings(Arrays.asList(navBinding, navBinding2));
        XMLMetadata metadata = TestODataMetadataProcessor.buildXmlMetadata(g1Entity, g1Set, g2Entity, g2Set, g3Entity, g3Set);
        processor.getMetadata(mf, metadata);
        return mf;
    }

    static MetadataFactory multiplePKMetadata() throws TranslatorException {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        CsdlEntityType entityType = TestODataMetadataProcessor.multipleKeyEntityType("g1");
        CsdlEntitySet entitySet = TestODataMetadataProcessor.createES("G1", "namespace.g1");
        XMLMetadata metadata = TestODataMetadataProcessor.buildXmlMetadata(entityType, entitySet);
        processor.getMetadata(mf, metadata);
        return mf;
    }

    private static CsdlEntityType multipleKeyEntityType(String name) {
        ArrayList<CsdlProperty> properties = new ArrayList<CsdlProperty>();
        properties.add(TestODataMetadataProcessor.createProperty("e1", EdmPrimitiveTypeKind.Int32));
        properties.add(TestODataMetadataProcessor.createProperty("e2", EdmPrimitiveTypeKind.String).setNullable(false));
        properties.add(TestODataMetadataProcessor.createProperty("e3", EdmPrimitiveTypeKind.String).setNullable(false));
        CsdlEntityType entityType = new CsdlEntityType();
        entityType.setName(name);
        entityType.setProperties(properties);
        entityType.setKey(Arrays.asList(new CsdlPropertyRef().setName("e1"), new CsdlPropertyRef().setName("e2")));
        return entityType;
    }

    @Test
    public void testMultikeyPK() throws Exception {
        MetadataFactory mf = TestODataMetadataProcessor.multiplePKMetadata();
        Table g1 = mf.getSchema().getTable("G1");
        Assert.assertNotNull((Object)g1.getPrimaryKey().getColumnByName("e1"));
        Assert.assertNotNull((Object)g1.getPrimaryKey().getColumnByName("e2"));
        Assert.assertNull((Object)g1.getPrimaryKey().getColumnByName("e3"));
    }

    @Test
    public void testAssosiationWithReferentialContriant() throws Exception {
        ODataMetadataProcessor processor = new ODataMetadataProcessor();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "northwind", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        CsdlEntityType g1Entity = TestODataMetadataProcessor.entityType("g1");
        g1Entity.getProperties().add(TestODataMetadataProcessor.createProperty("g2e2", EdmPrimitiveTypeKind.String));
        g1Entity.setKey(Arrays.asList(new CsdlPropertyRef().setName("g2e2")));
        CsdlEntityType g2Entity = TestODataMetadataProcessor.entityType("g2");
        CsdlNavigationProperty navProperty = new CsdlNavigationProperty();
        navProperty.setName("one_2_one");
        navProperty.setType("namespace.g2");
        navProperty.setNullable(Boolean.valueOf(false));
        navProperty.setPartner("PartnerPath");
        navProperty.setReferentialConstraints(Arrays.asList(new CsdlReferentialConstraint().setProperty("g2e2").setReferencedProperty("e2")));
        g1Entity.setNavigationProperties(Arrays.asList(navProperty));
        CsdlEntitySet g1Set = TestODataMetadataProcessor.createES("G1", "namespace.g1");
        CsdlEntitySet g2Set = TestODataMetadataProcessor.createES("G2", "namespace.g2");
        CsdlNavigationPropertyBinding navBinding = new CsdlNavigationPropertyBinding();
        navBinding.setPath("one_2_one");
        navBinding.setTarget("G2");
        g1Set.setNavigationPropertyBindings(Arrays.asList(navBinding));
        XMLMetadata metadata = TestODataMetadataProcessor.buildXmlMetadata(g1Entity, g1Set, g2Entity, g2Set);
        processor.getMetadata(mf, metadata);
        Table g1 = mf.getSchema().getTable("G1");
        Table g2 = mf.getSchema().getTable("G2");
        Assert.assertNotNull((Object)g1);
        Assert.assertNotNull((Object)g2);
        ForeignKey fk = (ForeignKey)g1.getForeignKeys().get(0);
        Assert.assertEquals((Object)"G1_one_2_one", (Object)fk.getName());
        Assert.assertNotNull((Object)fk.getColumnByName("g2e2"));
        Assert.assertEquals((Object)"e2", fk.getReferenceColumns().get(0));
    }

    static CsdlEntityType entityType(String name) {
        ArrayList<CsdlProperty> properties = new ArrayList<CsdlProperty>();
        properties.add(TestODataMetadataProcessor.createProperty("e1", EdmPrimitiveTypeKind.Int32));
        properties.add(TestODataMetadataProcessor.createProperty("e2", EdmPrimitiveTypeKind.String).setNullable(false));
        CsdlEntityType entityType = new CsdlEntityType();
        entityType.setName(name);
        entityType.setProperties(properties);
        entityType.setKey(Arrays.asList(new CsdlPropertyRef().setName("e1")));
        return entityType;
    }

    static CsdlFunction function(String name, CsdlReturnType returnType) {
        ArrayList<CsdlParameter> parameters = new ArrayList<CsdlParameter>();
        parameters.add(TestODataMetadataProcessor.createParameter("e1", EdmPrimitiveTypeKind.Int32));
        parameters.add(TestODataMetadataProcessor.createParameter("e2", EdmPrimitiveTypeKind.String).setNullable(false));
        CsdlFunction function = new CsdlFunction();
        function.setName(name);
        function.setParameters(parameters);
        function.setReturnType(returnType);
        return function;
    }

    static CsdlAction action(String name, CsdlReturnType returnType) {
        ArrayList<CsdlParameter> parameters = new ArrayList<CsdlParameter>();
        parameters.add(TestODataMetadataProcessor.createParameter("e1", EdmPrimitiveTypeKind.Int32));
        parameters.add(TestODataMetadataProcessor.createParameter("e2", EdmPrimitiveTypeKind.String).setNullable(false));
        CsdlAction action = new CsdlAction();
        action.setName(name);
        action.setParameters(parameters);
        action.setReturnType(returnType);
        return action;
    }

    private CsdlEntityType buildBusinessEntity(CsdlComplexType address) {
        ArrayList<CsdlProperty> properties = new ArrayList<CsdlProperty>();
        properties.add(TestODataMetadataProcessor.createProperty("name", EdmPrimitiveTypeKind.String).setMaxLength(Integer.valueOf(25)));
        properties.add(new CsdlProperty().setName("address").setType(address.getName()));
        CsdlEntityType entityType = new CsdlEntityType();
        entityType.setName("Business");
        entityType.setProperties(properties);
        entityType.setKey(Arrays.asList(new CsdlPropertyRef().setName("name")));
        return entityType;
    }

    static CsdlEntityType buildPersonEntity(CsdlComplexType address) {
        ArrayList<CsdlProperty> properties = new ArrayList<CsdlProperty>();
        properties.add(TestODataMetadataProcessor.createProperty("name", EdmPrimitiveTypeKind.String).setMaxLength(Integer.valueOf(25)));
        properties.add(TestODataMetadataProcessor.createProperty("ssn", EdmPrimitiveTypeKind.Int64).setNullable(false));
        properties.add(new CsdlProperty().setName("address").setType(address.getName()));
        properties.add(new CsdlProperty().setName("secondaddress").setType(address.getName()));
        CsdlEntityType entityType = new CsdlEntityType();
        entityType.setName("Person");
        entityType.setProperties(properties);
        entityType.setKey(Arrays.asList(new CsdlPropertyRef().setName("ssn")));
        return entityType;
    }

    static CsdlComplexType complexType(String name) {
        ArrayList<CsdlProperty> properties = new ArrayList<CsdlProperty>();
        properties.add(TestODataMetadataProcessor.createProperty("street", EdmPrimitiveTypeKind.String));
        properties.add(TestODataMetadataProcessor.createProperty("city", EdmPrimitiveTypeKind.String));
        properties.add(TestODataMetadataProcessor.createProperty("state", EdmPrimitiveTypeKind.String));
        CsdlComplexType type = new CsdlComplexType();
        type.setName(name).setProperties(properties);
        return type;
    }
}

