/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URLDecoder;
import java.sql.Clob;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.activation.DataSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.apache.olingo.commons.api.edm.geo.Point;
import org.apache.olingo.commons.api.edm.provider.CsdlComplexType;
import org.apache.olingo.commons.api.edm.provider.CsdlReturnType;
import org.apache.olingo.commons.core.edm.primitivetype.EdmGeometryPoint;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.types.AbstractGeospatialType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.MetadataFactory;
import org.teiid.query.function.GeometryUtils;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.TestODataMetadataProcessor;
import org.teiid.translator.ws.WSConnection;

public class TestODataQueryExecution {
    private ResultSetExecution helpExecute(MetadataFactory mf, String query, String resultJson, String expectedURL) throws Exception {
        return this.helpExecute(mf, query, resultJson, expectedURL, 200);
    }

    private ResultSetExecution helpExecute(MetadataFactory mf, String query, final String resultJson, String expectedURL, int responseCode) throws Exception {
        ODataExecutionFactory translator = new ODataExecutionFactory();
        translator.start();
        TranslationUtility utility = new TranslationUtility((QueryMetadataInterface)TestODataMetadataProcessor.getTransformationMetadata(mf, translator));
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WSConnection connection = (WSConnection)Mockito.mock(WSConnection.class);
        HashMap<String, Serializable> headers = new HashMap<String, Serializable>();
        headers.put("javax.xml.ws.http.request.headers", new HashMap());
        headers.put("status-code", new Integer(responseCode));
        Dispatch dispatch = (Dispatch)Mockito.mock(Dispatch.class);
        Mockito.stub((Object)dispatch.getRequestContext()).toReturn(headers);
        Mockito.stub((Object)dispatch.getResponseContext()).toReturn(headers);
        Mockito.stub((Object)connection.createDispatch((String)Mockito.eq((Object)"http://www.w3.org/2004/08/wsdl/http"), Mockito.anyString(), (Class)Mockito.eq(DataSource.class), (Service.Mode)Mockito.eq((Object)Service.Mode.MESSAGE))).toReturn((Object)dispatch);
        DataSource ds = new DataSource(){

            public OutputStream getOutputStream() throws IOException {
                return new ByteArrayOutputStream();
            }

            public String getName() {
                return "result";
            }

            public InputStream getInputStream() throws IOException {
                ByteArrayInputStream in = new ByteArrayInputStream(resultJson.getBytes());
                return in;
            }

            public String getContentType() {
                return "application/xml";
            }
        };
        Mockito.stub((Object)dispatch.invoke(Mockito.any(DataSource.class))).toReturn((Object)ds);
        ResultSetExecution execution = translator.createResultSetExecution((QueryExpression)cmd, context, utility.createRuntimeMetadata(), connection);
        execution.execute();
        ArgumentCaptor endpoint = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor binding = ArgumentCaptor.forClass(String.class);
        ((WSConnection)Mockito.verify((Object)connection)).createDispatch((String)binding.capture(), (String)endpoint.capture(), (Class)Mockito.eq(DataSource.class), (Service.Mode)Mockito.eq((Object)Service.Mode.MESSAGE));
        Assert.assertEquals((Object)expectedURL, (Object)URLDecoder.decode((String)endpoint.getValue(), "utf-8"));
        return execution;
    }

    private ProcedureExecution helpProcedureExecute(MetadataFactory mf, String query, String resultJson, String expectedURL, int responseCode) throws Exception {
        return this.helpProcedureExecute(mf, query, resultJson, expectedURL, responseCode, true);
    }

    private ProcedureExecution helpProcedureExecute(MetadataFactory mf, String query, final String resultJson, String expectedURL, int responseCode, boolean decode) throws Exception {
        ODataExecutionFactory translator = new ODataExecutionFactory();
        translator.start();
        TranslationUtility utility = new TranslationUtility((QueryMetadataInterface)TestODataMetadataProcessor.getTransformationMetadata(mf, translator));
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WSConnection connection = (WSConnection)Mockito.mock(WSConnection.class);
        HashMap<String, Serializable> headers = new HashMap<String, Serializable>();
        headers.put("javax.xml.ws.http.request.headers", new HashMap());
        headers.put("status-code", new Integer(responseCode));
        Dispatch dispatch = (Dispatch)Mockito.mock(Dispatch.class);
        Mockito.stub((Object)dispatch.getRequestContext()).toReturn(headers);
        Mockito.stub((Object)dispatch.getResponseContext()).toReturn(headers);
        Mockito.stub((Object)connection.createDispatch((String)Mockito.eq((Object)"http://www.w3.org/2004/08/wsdl/http"), Mockito.anyString(), (Class)Mockito.eq(DataSource.class), (Service.Mode)Mockito.eq((Object)Service.Mode.MESSAGE))).toReturn((Object)dispatch);
        DataSource ds = new DataSource(){

            public OutputStream getOutputStream() throws IOException {
                return new ByteArrayOutputStream();
            }

            public String getName() {
                return "result";
            }

            public InputStream getInputStream() throws IOException {
                ByteArrayInputStream in = new ByteArrayInputStream(resultJson.getBytes());
                return in;
            }

            public String getContentType() {
                return "application/xml";
            }
        };
        Mockito.stub((Object)dispatch.invoke(Mockito.any(DataSource.class))).toReturn((Object)ds);
        ProcedureExecution execution = translator.createProcedureExecution((Call)cmd, context, utility.createRuntimeMetadata(), connection);
        execution.execute();
        ArgumentCaptor endpoint = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor binding = ArgumentCaptor.forClass(String.class);
        ((WSConnection)Mockito.verify((Object)connection)).createDispatch((String)binding.capture(), (String)endpoint.capture(), (Class)Mockito.eq(DataSource.class), (Service.Mode)Mockito.eq((Object)Service.Mode.MESSAGE));
        Assert.assertEquals((Object)expectedURL, (Object)(decode ? URLDecoder.decode((String)endpoint.getValue(), "utf-8") : endpoint.getValue()));
        return execution;
    }

    @Test
    public void testSimpleSelectNoAssosiations() throws Exception {
        String query = "SELECT UserName,FirstName,LastName FROM People";
        String expectedURL = "People?$select=UserName,FirstName,LastName";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"people.json"));
        ResultSetExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "Russell", "Whyte"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"scottketchum", "Scott", "Ketchum"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"ronaldmundy", "Ronald", "Mundy"}, (Object[])excution.next().toArray(new Object[3]));
        reader.close();
    }

    @Test
    public void testReadArray() throws Exception {
        String query = "SELECT Emails FROM People";
        String expectedURL = "People?$select=Emails";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"people.json"));
        ResultSetExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        Assert.assertArrayEquals((Object[])new String[]{"Russell@example.com", "Russell@contoso.com"}, (Object[])((String[])excution.next().get(0)));
        Assert.assertArrayEquals((Object[])new String[]{"Scott@example.com"}, (Object[])((String[])excution.next().get(0)));
        Assert.assertArrayEquals((Object[])new String[]{"Ronald@example.com", "Ronald@contoso.com"}, (Object[])((String[])excution.next().get(0)));
        reader.close();
    }

    @Test
    public void testComplexType_InnerJoin() throws Exception {
        String query = "select p.UserName, pa.Address from People p JOIN People_AddressInfo pa ON p.UserName = pa.People_UserName";
        String expectedURL = "People?$select=UserName,AddressInfo";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"people.json"));
        ResultSetExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        reader.close();
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln."}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"scottketchum", "2817 Milton Dr."}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"javieralfred", "89 Jefferson Way Suite 2"}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"vincentcalabrese", "55 Grizzly Peak Rd."}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertNull((Object)excution.next());
    }

    @Test
    public void testComplexType_LeftOuterJoin() throws Exception {
        String query = "select p.UserName, pa.Address from People p LEFT JOIN People_AddressInfo pa ON p.UserName = pa.People_UserName";
        String expectedURL = "People?$select=UserName,AddressInfo";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"people.json"));
        ResultSetExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        reader.close();
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln."}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"scottketchum", "2817 Milton Dr."}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"ronaldmundy", null}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"javieralfred", "89 Jefferson Way Suite 2"}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"willieashmore", null}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"vincentcalabrese", "55 Grizzly Peak Rd."}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"clydeguess", null}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"keithpinckney", null}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertNull((Object)excution.next());
    }

    @Test
    public void testComplexType_InnerJoin_3way_decendentChildren() throws Exception {
        String query = "select p.UserName, pa.Address, pc.Name from People p JOIN People_AddressInfo pa ON p.UserName = pa.People_UserName JOIN People_AddressInfo_City pc ON p.UserName = pc.People_UserName";
        String expectedURL = "People?$select=UserName,AddressInfo,AddressInfo/City";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"people.json"));
        ResultSetExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        reader.close();
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln.", "Boise"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"scottketchum", "2817 Milton Dr.", "Albuquerque"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"javieralfred", "89 Jefferson Way Suite 2", "Portland"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"vincentcalabrese", "55 Grizzly Peak Rd.", "Butte"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertNull((Object)excution.next());
    }

    @Test
    public void testComplexType_InnerJoin_3way_Sibiling() throws Exception {
        String query = "select p.UserName, pa.Address, pf.UserName from People p JOIN People_AddressInfo pa ON p.UserName = pa.People_UserName JOIN People_Friends pf ON p.UserName = pf.People_UserName";
        String expectedURL = "People?$select=UserName,AddressInfo&$expand=Friends($select=UserName)";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"people-friends.json"));
        ResultSetExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        reader.close();
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln.", "scottketchum"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln.", "ronaldmundy"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln.", "javieralfred"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln.", "angelhuffman"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"scottketchum", "2817 Milton Dr.", "russellwhyte"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"scottketchum", "2817 Milton Dr.", "ronaldmundy"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"javieralfred", "89 Jefferson Way Suite 2", "willieashmore"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"javieralfred", "89 Jefferson Way Suite 2", "vincentcalabrese"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"javieralfred", "89 Jefferson Way Suite 2", "georginabarlow"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertNull((Object)excution.next());
    }

    @Test
    public void testComplexType_3Way_MIXEDJoin_Sibiling() throws Exception {
        String query = "select p.UserName, pa.Address, pf.UserName from People p LEFT OUTER JOIN People_AddressInfo pa ON p.UserName = pa.People_UserName INNER JOIN People_Friends pf ON p.UserName = pf.People_UserName";
        String expectedURL = "People?$select=UserName,AddressInfo&$expand=Friends($select=UserName)";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"people-friends.json"));
        ResultSetExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        reader.close();
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln.", "scottketchum"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln.", "ronaldmundy"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln.", "javieralfred"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln.", "angelhuffman"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"scottketchum", "2817 Milton Dr.", "russellwhyte"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"scottketchum", "2817 Milton Dr.", "ronaldmundy"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"ronaldmundy", null, "russellwhyte"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"ronaldmundy", null, "scottketchum"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"javieralfred", "89 Jefferson Way Suite 2", "willieashmore"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"javieralfred", "89 Jefferson Way Suite 2", "vincentcalabrese"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"javieralfred", "89 Jefferson Way Suite 2", "georginabarlow"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"willieashmore", null, "javieralfred"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"willieashmore", null, "vincentcalabrese"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"clydeguess", null, "keithpinckney"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"clydeguess", null, "ursulabright"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"keithpinckney", null, "clydeguess"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"keithpinckney", null, "marshallgaray"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertNull((Object)excution.next());
        Assert.assertNull((Object)excution.next());
    }

    @Test
    public void testComplexType_3Way_LeftOuterJoin() throws Exception {
        String query = "select p.UserName, pa.Address, pf.UserName from People p LEFT OUTER JOIN People_AddressInfo pa ON p.UserName = pa.People_UserName LEFT OUTER JOIN People_Friends pf ON p.UserName = pf.People_UserName";
        String expectedURL = "People?$select=UserName,AddressInfo&$expand=Friends($select=UserName)";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"people-friends.json"));
        ResultSetExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        reader.close();
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln.", "scottketchum"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln.", "ronaldmundy"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln.", "javieralfred"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln.", "angelhuffman"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"scottketchum", "2817 Milton Dr.", "russellwhyte"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"scottketchum", "2817 Milton Dr.", "ronaldmundy"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"ronaldmundy", null, "russellwhyte"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"ronaldmundy", null, "scottketchum"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"javieralfred", "89 Jefferson Way Suite 2", "willieashmore"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"javieralfred", "89 Jefferson Way Suite 2", "vincentcalabrese"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"javieralfred", "89 Jefferson Way Suite 2", "georginabarlow"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"willieashmore", null, "javieralfred"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"willieashmore", null, "vincentcalabrese"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"vincentcalabrese", "55 Grizzly Peak Rd.", null}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"clydeguess", null, "keithpinckney"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"clydeguess", null, "ursulabright"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"keithpinckney", null, "clydeguess"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"keithpinckney", null, "marshallgaray"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertNull((Object)excution.next());
    }

    @Test
    public void testExpandBasedInnerJoin() throws Exception {
        String query = "select p.UserName, pf.UserName from People p JOIN People_Friends pf ON p.UserName = pf.People_UserName WHERE p.UserName= 'russellwhyte'";
        String expectedURL = "People?$select=UserName&$filter=UserName eq 'russellwhyte'&$expand=Friends($select=UserName)";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"russel-friends.json"));
        ResultSetExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        reader.close();
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "scottketchum"}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "ronaldmundy"}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "javieralfred"}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "angelhuffman"}, (Object[])excution.next().toArray(new Object[2]));
    }

    @Test
    public void testFunctionReturnsPrimitive() throws Exception {
        String query = "exec invoke(1, 'foo')";
        String expectedURL = "invoke?e1=1&e2='foo'";
        String response = "{\"value\":\"returnX\"}";
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType("Edm.String");
        MetadataFactory mf = TestODataMetadataProcessor.functionMetadata("invoke", returnType, null);
        ProcedureExecution excution = this.helpProcedureExecute(mf, query, response, expectedURL, 200);
        Assert.assertArrayEquals((Object[])new Object[]{"returnX"}, (Object[])excution.getOutputParameterValues().toArray(new Object[1]));
    }

    @Test
    public void testFunctionReturnsPrimitiveEncoded() throws Exception {
        String query = "exec invoke(1, 'foo bar')";
        String expectedURL = "invoke?e1=1&e2=%27foo%20bar%27";
        String response = "{\"value\":\"returnX\"}";
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType("Edm.String");
        MetadataFactory mf = TestODataMetadataProcessor.functionMetadata("invoke", returnType, null);
        ProcedureExecution excution = this.helpProcedureExecute(mf, query, response, expectedURL, 200, false);
        Assert.assertArrayEquals((Object[])new Object[]{"returnX"}, (Object[])excution.getOutputParameterValues().toArray(new Object[1]));
    }

    @Test
    public void testFunctionReturnsPrimitiveCollection() throws Exception {
        String query = "exec invoke(1, 'foo')";
        String expectedURL = "invoke?e1=1&e2='foo'";
        String response = "{\"value\": [\"returnX\", \"returnY\"]}";
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType("Edm.String");
        returnType.setCollection(true);
        MetadataFactory mf = TestODataMetadataProcessor.functionMetadata("invoke", returnType, null);
        ProcedureExecution excution = this.helpProcedureExecute(mf, query, response, expectedURL, 200);
        Assert.assertArrayEquals((Object[])new Object[]{"returnX", "returnY"}, (Object[])((List)excution.getOutputParameterValues().get(0)).toArray());
    }

    @Test
    public void testFunctionReturnsComplex() throws Exception {
        String query = "exec invoke(1, 'foo')";
        String expectedURL = "invoke?e1=1&e2='foo'";
        String response = "{\"value\":{\n            \"street\":\"United States\",\n            \"city\":\"Boise\",\n            \"state\":\"ID\"\n         }}";
        CsdlComplexType complex = TestODataMetadataProcessor.complexType("Address");
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType("namespace.Address");
        MetadataFactory mf = TestODataMetadataProcessor.functionMetadata("invoke", returnType, complex);
        ProcedureExecution excution = this.helpProcedureExecute(mf, query, response, expectedURL, 200);
        Assert.assertArrayEquals((Object[])new Object[]{"United States", "Boise", "ID"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertNull((Object)excution.next());
    }

    @Test
    public void testFunctionReturnsComplexCollection() throws Exception {
        String query = "exec invoke(1, 'foo')";
        String expectedURL = "invoke?e1=1&e2='foo'";
        String response = "{\"value\":[{\n            \"street\":\"United States\",\n            \"city\":\"Boise\",\n            \"state\":\"ID\"\n           },           {            \"street\":\"China\",\n            \"city\":\"Newyork\",\n            \"state\":\"NY\"\n         }]}";
        CsdlComplexType complex = TestODataMetadataProcessor.complexType("Address");
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType("namespace.Address");
        MetadataFactory mf = TestODataMetadataProcessor.functionMetadata("invoke", returnType, complex);
        ProcedureExecution excution = this.helpProcedureExecute(mf, query, response, expectedURL, 200);
        Assert.assertArrayEquals((Object[])new Object[]{"United States", "Boise", "ID"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"China", "Newyork", "NY"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertNull((Object)excution.next());
    }

    @Test
    public void testActionReturnsComplexCollection() throws Exception {
        String query = "exec invoke(1, 'foo')";
        String expectedURL = "invoke";
        String response = "{\"value\":[{\n            \"street\":\"United States\",\n            \"city\":\"Boise\",\n            \"state\":\"ID\"\n           },           {            \"street\":\"China\",\n            \"city\":\"Newyork\",\n            \"state\":\"NY\"\n         }]}";
        CsdlComplexType complex = TestODataMetadataProcessor.complexType("Address");
        CsdlReturnType returnType = new CsdlReturnType();
        returnType.setType("namespace.Address");
        MetadataFactory mf = TestODataMetadataProcessor.actionMetadata("invoke", returnType, complex);
        ProcedureExecution excution = this.helpProcedureExecute(mf, query, response, expectedURL, 200);
        Assert.assertArrayEquals((Object[])new Object[]{"United States", "Boise", "ID"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertArrayEquals((Object[])new Object[]{"China", "Newyork", "NY"}, (Object[])excution.next().toArray(new Object[3]));
        Assert.assertNull((Object)excution.next());
    }

    @Test
    public void testReadComplexType() throws Exception {
        String query = "select pa.People_UserName, pa.Address from People_AddressInfo pa ";
        String expectedURL = "People?$select=UserName,AddressInfo";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"people.json"));
        ResultSetExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        reader.close();
        Assert.assertArrayEquals((Object[])new Object[]{"russellwhyte", "187 Suffolk Ln."}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"scottketchum", "2817 Milton Dr."}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"javieralfred", "89 Jefferson Way Suite 2"}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertArrayEquals((Object[])new Object[]{"vincentcalabrese", "55 Grizzly Peak Rd."}, (Object[])excution.next().toArray(new Object[2]));
        Assert.assertNull((Object)excution.next());
    }

    @Test
    public void testGeometry() throws Exception {
        String query = "SELECT * FROM Airports_Location";
        String expectedURL = "Airports?$select=IcaoCode,Location";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"airport-locations.json"));
        MetadataFactory mf = TestODataMetadataProcessor.tripPinMetadata();
        ResultSetExecution execution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        List row = execution.next();
        Assert.assertEquals((Object)"187 Suffolk Ln.", row.get(2));
        Assert.assertEquals((Object)"xyz", row.get(0));
        GeometryType gis = (GeometryType)row.get(1);
        Assert.assertEquals((Object)"SRID=4326;POINT (-48.23456 20.12345)", (Object)ClobType.getString((Clob)GeometryUtils.geometryToClob((AbstractGeospatialType)gis, (boolean)true)));
        row = execution.next();
        Assert.assertEquals((Object)"gso", row.get(0));
        gis = (GeometryType)row.get(1);
        Assert.assertEquals((Object)"SRID=4326;POINT (1 2)", (Object)ClobType.getString((Clob)GeometryUtils.geometryToClob((AbstractGeospatialType)gis, (boolean)true)));
        Assert.assertNull((Object)execution.next());
        reader.close();
    }

    @Test
    public void testGeometryFilter() throws Exception {
        String query = "SELECT Loc FROM Airports_Location where st_distance(Loc, st_geomfromtext('point(1 2)')) < 2";
        String expectedURL = "Airports?$select=Location&$filter=geo.distance(Location/Loc,geometry'SRID=0;Point(1.0 2.0)') lt 2.0";
        FileReader reader = new FileReader(UnitTestUtil.getTestDataFile((String)"airport-locations.json"));
        ResultSetExecution execution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, ObjectConverterUtil.convertToString((Reader)reader), expectedURL);
        EdmGeometryPoint.getInstance().valueOfString("geometry'SRID=0;Point(1.0 2.0)'", Boolean.valueOf(false), Integer.valueOf(4000), Integer.valueOf(0), Integer.valueOf(0), Boolean.valueOf(true), Point.class);
    }

    @Test
    public void testSimpleAggregate() throws Exception {
        String query = "SELECT Count(*) FROM People";
        String expectedURL = "People/$count";
        ResultSetExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, "19", expectedURL);
        Assert.assertEquals(Arrays.asList(19), (Object)excution.next());
    }
}

