/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.activation.DataSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.teiid.cdk.api.TranslationUtility;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.language.Command;
import org.teiid.metadata.MetadataFactory;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.odata4.ODataExecutionFactory;
import org.teiid.translator.odata4.TestODataMetadataProcessor;
import org.teiid.translator.ws.WSConnection;

public class TestODataUpdateExecution {
    private UpdateExecution helpExecute(MetadataFactory mf, String query, String expectedPayload, final String resultJson, String expectedURL, String expectedMethod, int responseCode) throws Exception {
        ODataExecutionFactory translator = new ODataExecutionFactory();
        translator.start();
        TranslationUtility utility = new TranslationUtility((QueryMetadataInterface)TestODataMetadataProcessor.getTransformationMetadata(mf, translator));
        Command cmd = utility.parseCommand(query);
        ExecutionContext context = (ExecutionContext)Mockito.mock(ExecutionContext.class);
        WSConnection connection = (WSConnection)Mockito.mock(WSConnection.class);
        HashMap<String, Serializable> headers = new HashMap<String, Serializable>();
        headers.put("javax.xml.ws.http.request.headers", new HashMap());
        headers.put("status-code", new Integer(responseCode));
        Dispatch dispatch = (Dispatch)Mockito.mock(Dispatch.class);
        Mockito.stub((Object)dispatch.getRequestContext()).toReturn(headers);
        Mockito.stub((Object)dispatch.getResponseContext()).toReturn(headers);
        Mockito.stub((Object)connection.createDispatch((String)Mockito.eq((Object)"http://www.w3.org/2004/08/wsdl/http"), Mockito.anyString(), (Class)Mockito.eq(DataSource.class), (Service.Mode)Mockito.eq((Object)Service.Mode.MESSAGE))).toReturn((Object)dispatch);
        DataSource ds = new DataSource(){

            public OutputStream getOutputStream() throws IOException {
                return new ByteArrayOutputStream();
            }

            public String getName() {
                return "result";
            }

            public InputStream getInputStream() throws IOException {
                ByteArrayInputStream in = new ByteArrayInputStream(resultJson.getBytes());
                return in;
            }

            public String getContentType() {
                return "application/json";
            }
        };
        ArgumentCaptor data = ArgumentCaptor.forClass(DataSource.class);
        Mockito.stub((Object)((DataSource)dispatch.invoke((Object)((DataSource)data.capture())))).toReturn((Object)ds);
        UpdateExecution execution = translator.createUpdateExecution(cmd, context, utility.createRuntimeMetadata(), connection);
        execution.execute();
        ArgumentCaptor endpoint = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor binding = ArgumentCaptor.forClass(String.class);
        ((WSConnection)Mockito.verify((Object)connection)).createDispatch((String)binding.capture(), (String)endpoint.capture(), (Class)Mockito.eq(DataSource.class), (Service.Mode)Mockito.eq((Object)Service.Mode.MESSAGE));
        Assert.assertEquals((Object)expectedURL, (Object)URLDecoder.decode((String)endpoint.getValue(), "utf-8"));
        String payload = new String(ObjectConverterUtil.convertToByteArray((InputStream)((InputStreamFactory.ClobInputStreamFactory)data.getValue()).getInputStream()));
        Assert.assertEquals((Object)expectedPayload, (Object)payload);
        Assert.assertEquals((Object)expectedMethod, dispatch.getRequestContext().get("javax.xml.ws.http.request.method"));
        return execution;
    }

    @Test
    public void testInsertEntitySet() throws Exception {
        String query = "INSERT INTO People(UserName,FirstName,LastName, EMails, Gender, Concurrency) values ('jdoe', 'John', 'Doe', ('jdoe@cantfind.ws',), 'Male', 1234)";
        String expectedURL = "People";
        String returnResponse = "{\n   \"UserName\":\"russellwhyte\",\n   \"FirstName\":\"Russell\",\n   \"LastName\":\"Whyte\"\n}";
        String expectedPayload = "{\"@odata.type\":\"#Microsoft.OData.SampleService.Models.TripPin.Person\",\"UserName@odata.type\":\"String\",\"UserName\":\"jdoe\",\"FirstName@odata.type\":\"String\",\"FirstName\":\"John\",\"LastName@odata.type\":\"String\",\"LastName\":\"Doe\",\"Emails@odata.type\":\"#Collection(String)\",\"Emails\":[\"jdoe@cantfind.ws\"],\"Gender@odata.type\":\"#Microsoft.OData.SampleService.Models.TripPin.PersonGender\",\"Gender\":\"Male\",\"Concurrency@odata.type\":\"Int64\",\"Concurrency\":1234}";
        UpdateExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, expectedPayload, returnResponse, expectedURL, "POST", 201);
    }

    @Test
    public void testInsertComplexType() throws Exception {
        String query = "INSERT INTO Persons_address(street, city, state, Persons_ssn) VALUES('sesame street', 'Newyork', 'NY', 1234)";
        String expectedURL = "Persons(1234)/address";
        String returnResponse = "{\n   \"UserName\":\"russellwhyte\",\n   \"FirstName\":\"Russell\",\n   \"LastName\":\"Whyte\"\n}";
        String expectedPayload = "{\"@odata.type\":\"#Edm.Address\",\"street@odata.type\":\"String\",\"street\":\"sesame street\",\"city@odata.type\":\"String\",\"city\":\"Newyork\",\"state@odata.type\":\"String\",\"state\":\"NY\"}";
        UpdateExecution excution = this.helpExecute(TestODataMetadataProcessor.getEntityWithComplexProperty(), query, expectedPayload, returnResponse, expectedURL, "PATCH", 201);
    }

    @Test
    public void testInsertComplexTypeTripPin() throws Exception {
        String query = "INSERT INTO People_AddressInfo(Address, People_UserName) VALUES('sesame street', 'russel')";
        String expectedURL = "People('russel')/AddressInfo";
        String returnResponse = "{\n   \"Address\":\"russellwhyte\",\n   \"FirstName\":\"Russell\",\n   \"LastName\":\"Whyte\"\n}";
        String expectedPayload = "{\"@odata.type\":\"#Microsoft.OData.SampleService.Models.TripPin.Location\",\"value\":[{\"@odata.type\":\"#Microsoft.OData.SampleService.Models.TripPin.Location\",\"Address@odata.type\":\"String\",\"Address\":\"sesame street\"}]}";
        UpdateExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, expectedPayload, returnResponse, expectedURL, "PUT", 201);
    }

    @Test
    public void testInsertNavigation() throws Exception {
        String query = "INSERT INTO People_Friends(UserName, FirstName, LastName, People_UserName) VALUES('jdoe', 'John', 'Doe', 'russel')";
        String expectedURL = "People('russel')/Friends";
        String returnResponse = "{\n   \"UserName\":\"jdoe\",\n   \"FirstName\":\"John\",\n   \"LastName\":\"Doe\"\n}";
        String expectedPayload = "{\"@odata.type\":\"#Microsoft.OData.SampleService.Models.TripPin.Person\",\"UserName@odata.type\":\"String\",\"UserName\":\"jdoe\",\"FirstName@odata.type\":\"String\",\"FirstName\":\"John\",\"LastName@odata.type\":\"String\",\"LastName\":\"Doe\"}";
        UpdateExecution excution = this.helpExecute(TestODataMetadataProcessor.tripPinMetadata(), query, expectedPayload, returnResponse, expectedURL, "POST", 201);
    }
}

