/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.olap;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.olap4j.Axis;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapStatement;
import org.olap4j.Position;
import org.olap4j.metadata.Member;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.language.Literal;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.logging.LogManager;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.olap.OlapExecutionFactory;

public class OlapQueryExecution
implements ProcedureExecution {
    protected Command command;
    protected OlapConnection connection;
    protected ExecutionContext context;
    protected OlapExecutionFactory executionFactory;
    private OlapStatement stmt;
    private CellSet cellSet;
    private CellSetAxis columnsAxis;
    private int colWidth;
    private ListIterator<Position> rowPositionIterator;
    private String mdxQuery;
    private boolean returnsArray;

    public OlapQueryExecution(List<Argument> arguments, Command command, OlapConnection connection, ExecutionContext context, OlapExecutionFactory executionFactory, String mdxQuery, boolean returnsArray) {
        this.mdxQuery = mdxQuery;
        if (arguments.size() > 0 || !returnsArray) {
            StringBuilder buffer = new StringBuilder();
            SQLStringVisitor.parseNativeQueryParts((String)mdxQuery, arguments, (StringBuilder)buffer, (SQLStringVisitor.Substitutor)new SQLStringVisitor.Substitutor(){

                public void substitute(Argument arg, StringBuilder builder, int index) {
                    Literal argumentValue = arg.getArgumentValue();
                    Object value = argumentValue.getValue();
                    if (value == null || value instanceof Number || value instanceof Boolean || value instanceof String) {
                        builder.append(argumentValue);
                    } else if (value instanceof Date) {
                        builder.append(new Literal((Object)value.toString(), String.class));
                    } else {
                        builder.append(new Literal((Object)argumentValue.toString(), String.class));
                    }
                }
            });
            this.mdxQuery = buffer.toString();
        }
        this.command = command;
        this.connection = connection;
        this.context = context;
        this.executionFactory = executionFactory;
        this.returnsArray = returnsArray;
    }

    public void execute() throws TranslatorException {
        try {
            this.stmt = this.connection.createStatement();
            this.cellSet = this.stmt.executeOlapQuery(this.mdxQuery);
            CellSetAxis rowAxis = (CellSetAxis)this.cellSet.getAxes().get(Axis.ROWS.axisOrdinal());
            this.rowPositionIterator = rowAxis.iterator();
            this.columnsAxis = (CellSetAxis)this.cellSet.getAxes().get(Axis.COLUMNS.axisOrdinal());
            this.colWidth = rowAxis.getAxisMetaData().getHierarchies().size() + this.columnsAxis.getPositions().size();
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public void cancel() throws TranslatorException {
        try {
            OlapStatement olapStatement = this.stmt;
            if (olapStatement != null) {
                olapStatement.cancel();
            }
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public void close() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
        }
        catch (SQLException e) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)e, (Object)"Exception closing");
        }
    }

    public List<?> next() throws TranslatorException {
        if (!this.rowPositionIterator.hasNext()) {
            return null;
        }
        Position rowPosition = this.rowPositionIterator.next();
        Object[] result = new Object[this.colWidth];
        int i = 0;
        List members = rowPosition.getMembers();
        for (Member member : members) {
            String columnName = member.getName();
            result[i++] = columnName;
        }
        for (Position colPos : this.columnsAxis) {
            Cell cell = this.cellSet.getCell(new Position[]{colPos, rowPosition});
            result[i++] = cell.getValue();
        }
        if (this.returnsArray) {
            ArrayList<Object[]> results = new ArrayList<Object[]>(1);
            results.add(result);
            return results;
        }
        return Arrays.asList(result);
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }
}

