/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.olap;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.olap4j.OlapConnection;
import org.olap4j.OlapWrapper;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.olap.OlapQueryExecution;

@Translator(name="olap", description="A translator for OLAP Cubes")
public class OlapExecutionFactory
extends ExecutionFactory<DataSource, Connection> {
    private static final String INVOKE_MDX = "invokeMdx";

    public OlapExecutionFactory() {
        this.setSourceRequiredForMetadata(false);
        this.setSupportsDirectQueryProcedure(true);
        this.setDirectQueryProcedureName(INVOKE_MDX);
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection connection) throws TranslatorException {
        return new OlapQueryExecution(arguments.subList(1, arguments.size()), command, this.unwrap(connection), executionContext, this, (String)arguments.get(0).getArgumentValue().getValue(), true);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, Connection connection) throws TranslatorException {
        String nativeQuery = command.getMetadataObject().getProperty("teiid_rel:native-query", false);
        if (nativeQuery != null) {
            return new OlapQueryExecution(command.getArguments(), (Command)command, this.unwrap(connection), executionContext, this, nativeQuery, false);
        }
        throw new TranslatorException("Missing native-query extension metadata.");
    }

    private OlapConnection unwrap(Connection conn) throws TranslatorException {
        try {
            OlapWrapper wrapper = conn.unwrap(OlapWrapper.class);
            OlapConnection olapConn = (OlapConnection)wrapper.unwrap(OlapConnection.class);
            return olapConn;
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public Connection getConnection(DataSource ds) throws TranslatorException {
        try {
            return ds.getConnection();
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public void closeConnection(Connection connection, DataSource factory) {
        if (connection == null) {
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException e) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)e, (Object)"Error closing");
        }
    }
}

