/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.swagger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.RestMetadataExtension;
import org.teiid.metadata.Schema;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.UDFSource;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.swagger.SwaggerExecutionFactory;
import org.teiid.translator.swagger.SwaggerMetadataProcessor;
import org.teiid.translator.ws.WSConnection;

public class TestSwaggerMetadataProcessor {
    public static TransformationMetadata getTransformationMetadata(MetadataFactory mf, SwaggerExecutionFactory ef) throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata((MetadataStore)mf.asMetadataStore(), (String)"swagger", (FunctionTree[])new FunctionTree[]{new FunctionTree("foo", (FunctionMetadataSource)new UDFSource((Collection)ef.getPushDownFunctions()))});
        ValidatorReport report = new MetadataValidator().validate(metadata.getVdbMetaData(), (MetadataStore)metadata.getMetadataStore());
        if (report.hasItems()) {
            throw new RuntimeException(report.getFailureMessage());
        }
        return metadata;
    }

    static MetadataFactory swaggerMetadata(SwaggerExecutionFactory ef) throws TranslatorException {
        return TestSwaggerMetadataProcessor.getMetadata(ef, UnitTestUtil.getTestDataPath() + "/swagger.json");
    }

    static MetadataFactory petstoreMetadata(SwaggerExecutionFactory ef) throws TranslatorException {
        return TestSwaggerMetadataProcessor.getMetadata(ef, UnitTestUtil.getTestDataPath() + "/petstore.json");
    }

    private static MetadataFactory getMetadata(SwaggerExecutionFactory ef, final String file) throws TranslatorException {
        SwaggerMetadataProcessor processor = new SwaggerMetadataProcessor(ef){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Swagger getSchema(WSConnection conn) throws TranslatorException {
                File f = new File(file);
                ObjectMapper objectMapper = new ObjectMapper();
                try (FileInputStream fis = new FileInputStream(f);){
                    JsonNode rootNode = objectMapper.readTree((InputStream)fis);
                    Swagger swagger = new SwaggerParser().read(rootNode, true);
                    return swagger;
                }
                catch (IOException e) {
                    throw new TranslatorException((Throwable)e);
                }
            }
        };
        processor.setPreferredProduces("application/json");
        processor.setPreferredConsumes("application/json");
        processor.setPreferredScheme("http");
        Properties props = new Properties();
        MetadataFactory mf = new MetadataFactory("vdb", (Object)1, "swagger", SystemMetadata.getInstance().getRuntimeTypeMap(), props, null);
        processor.process(mf, null);
        return mf;
    }

    @Test
    public void testSchema() throws Exception {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.swaggerMetadata(translator);
        String ddl = DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null);
        MetadataFactory mf2 = new MetadataFactory("vdb", (Object)1, "x", SystemMetadata.getInstance().getRuntimeTypeMap(), new Properties(), null);
        QueryParser.getQueryParser().parseDDL(mf2, ddl);
        HashSet<String> procSet = new HashSet<String>();
        for (Procedure p : mf.getSchema().getProcedures().values()) {
            procSet.add(p.getName());
        }
        Assert.assertEquals((long)29L, (long)procSet.size());
        Assert.assertTrue((boolean)procSet.contains("addCustomer"));
        Assert.assertTrue((boolean)procSet.contains("addOneCustomer"));
        Assert.assertTrue((boolean)procSet.contains("addCustomerList"));
        Assert.assertTrue((boolean)procSet.contains("getCustomers"));
        Assert.assertTrue((boolean)procSet.contains("getCustomerList"));
        Assert.assertTrue((boolean)procSet.contains("getCustomerByCity"));
        Assert.assertTrue((boolean)procSet.contains("getCustomerByCountry"));
        Assert.assertTrue((boolean)procSet.contains("getCustomerByName"));
        Assert.assertTrue((boolean)procSet.contains("getCustomerByNumber"));
        Assert.assertTrue((boolean)procSet.contains("getByNumCityCountry"));
        Assert.assertTrue((boolean)procSet.contains("size"));
        Assert.assertTrue((boolean)procSet.contains("removeCustomer"));
        Assert.assertTrue((boolean)procSet.contains("removeCustomerByCity"));
        Assert.assertTrue((boolean)procSet.contains("removeCustomerByCountry"));
        Assert.assertTrue((boolean)procSet.contains("removeCustomerByName"));
        Assert.assertTrue((boolean)procSet.contains("removeCustomerByNumber"));
        Assert.assertTrue((boolean)procSet.contains("removeCustomerByNumCityCountry"));
        Assert.assertTrue((boolean)procSet.contains("updateCustomer"));
        Assert.assertTrue((boolean)procSet.contains("updateCustomerByCity"));
        Assert.assertTrue((boolean)procSet.contains("updateCustomerByCountry"));
        Assert.assertTrue((boolean)procSet.contains("updateCustomerByName"));
        Assert.assertTrue((boolean)procSet.contains("updateCustomerByNumber"));
        Assert.assertTrue((boolean)procSet.contains("updateCustomerByNumCityCountry"));
        Procedure p = (Procedure)mf.getSchema().getProcedures().get("updateCustomer");
        Assert.assertEquals((Object)"application/json", (Object)p.getProperty("teiid_rest:PRODUCES", false));
    }

    @Test
    public void testSwaggerINParameterTypes() throws TranslatorException {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.swaggerMetadata(translator);
        for (Procedure p : mf.getSchema().getProcedures().values()) {
            Object params;
            if (p.getName().equals("getByNumCityCountry")) {
                params = p.getParameters();
                Iterator iterator = params.iterator();
                while (iterator.hasNext()) {
                    ProcedureParameter param = (ProcedureParameter)iterator.next();
                    Assert.assertEquals((Object)RestMetadataExtension.ParameterType.QUERY.name(), (Object)param.getProperty("teiid_rest:PARAMETER_TYPE", false).toUpperCase());
                }
                Assert.assertEquals((long)3L, (long)params.size());
                Assert.assertTrue((boolean)((ProcedureParameter)params.get(0)).getName().equalsIgnoreCase("customernumber"));
                Assert.assertTrue((boolean)((ProcedureParameter)params.get(1)).getName().equalsIgnoreCase("city"));
                Assert.assertTrue((boolean)((ProcedureParameter)params.get(2)).getName().equalsIgnoreCase("country"));
            } else if (p.getName().equals("getCustomerByCity") || p.getName().equals("getCustomerByCountry") && p.getName().equals("getByNumCityCountry")) {
                for (ProcedureParameter param : p.getParameters()) {
                    Assert.assertEquals((Object)RestMetadataExtension.ParameterType.QUERY.name(), (Object)param.getProperty("teiid_rest:PARAMETER_TYPE", false).toUpperCase());
                }
            } else if (p.getName().equals("getCustomerByNumber") || p.getName().equals("getCustomerByName")) {
                for (ProcedureParameter param : p.getParameters()) {
                    Assert.assertEquals((Object)RestMetadataExtension.ParameterType.PATH.name(), (Object)param.getProperty("teiid_rest:PARAMETER_TYPE", false).toUpperCase());
                }
            } else if (p.getName().equals("addCustomer") || p.getName().equals("addOneCustomer") || p.getName().equals("addCustomerList")) {
                ProcedureParameter param = (ProcedureParameter)p.getParameters().get(0);
                Assert.assertEquals((Object)RestMetadataExtension.ParameterType.BODY.name(), (Object)param.getProperty("teiid_rest:PARAMETER_TYPE", false).toUpperCase());
            }
            if (!p.getName().equals("addCustomer")) continue;
            params = p.getParameters();
            Assert.assertEquals((long)13L, (long)params.size());
            Assert.assertEquals((Object)"customernumber", (Object)((ProcedureParameter)params.get(0)).getName());
            Assert.assertEquals((Object)"creditlimit", (Object)((ProcedureParameter)params.get(12)).getName());
        }
    }

    @Test
    public void testAnnotation() throws TranslatorException {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.swaggerMetadata(translator);
        for (Procedure p : mf.getSchema().getProcedures().values()) {
            if (p.getName().equals("addCustomer")) {
                Assert.assertEquals((Object)"Add a Customer", (Object)p.getAnnotation());
                continue;
            }
            if (!p.getName().equals("getByNumCityCountry")) continue;
            Assert.assertEquals((Object)"get customer by Number, City, Country as return xml/json", (Object)p.getAnnotation());
        }
    }

    @Test
    public void testURI() throws TranslatorException {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.swaggerMetadata(translator);
        Procedure p = mf.getSchema().getProcedure("addCustomer");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"POST", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"http://localhost:8080/customer", (Object)p.getProperty("teiid_rest:URI", false));
        Assert.assertNull((Object)p.getResultSet());
        p = mf.getSchema().getProcedure("getCustomers");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"GET", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"http://localhost:8080/customer/customerList", (Object)p.getProperty("teiid_rest:URI", false));
        Assert.assertEquals((Object)"application/xml", (Object)p.getProperty("teiid_rest:PRODUCES", false));
        Assert.assertNull((Object)p.getResultSet());
        Assert.assertEquals((Object)"return", (Object)((ProcedureParameter)p.getParameters().get(0)).getName());
        Assert.assertEquals((Object)"string", (Object)((ProcedureParameter)p.getParameters().get(0)).getRuntimeType());
        p = mf.getSchema().getProcedure("removeCustomer");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"DELETE", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"http://localhost:8080/customer/delete/{id}", (Object)p.getProperty("teiid_rest:URI", false));
        Assert.assertEquals((Object)"application/json", (Object)p.getProperty("teiid_rest:PRODUCES", false));
        Assert.assertNull((Object)p.getResultSet());
        Assert.assertEquals((Object)"id", (Object)((ProcedureParameter)p.getParameters().get(0)).getName());
        Assert.assertEquals((long)1L, (long)p.getParameters().size());
    }

    @Test
    public void testResultSets() throws TranslatorException {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.swaggerMetadata(translator);
        Procedure p = mf.getSchema().getProcedure("getCustomerList");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"GET", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"http://localhost:8080/customer/getAll", (Object)p.getProperty("teiid_rest:URI", false));
        Assert.assertNotNull((Object)p.getResultSet());
        ColumnSet results = p.getResultSet();
        Assert.assertEquals((long)13L, (long)results.getColumns().size());
        Column c = results.getColumnByName("customernumber");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)"string", (Object)c.getRuntimeType());
        c = results.getColumnByName("postalcode");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)"string", (Object)c.getRuntimeType());
    }

    @Test
    public void testTypes() throws TranslatorException {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.swaggerMetadata(translator);
        Procedure p = mf.getSchema().getProcedure("testReturnTypes");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"GET", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"http://localhost:8080/test/testReturnTypes", (Object)p.getProperty("teiid_rest:URI", false));
        Assert.assertNotNull((Object)p.getResultSet());
        ColumnSet results = p.getResultSet();
        Assert.assertEquals((Object)"byte", (Object)results.getColumnByName("a").getRuntimeType());
        Assert.assertEquals((Object)"integer", (Object)results.getColumnByName("b").getRuntimeType());
        Assert.assertEquals((Object)"integer", (Object)results.getColumnByName("c").getRuntimeType());
        Assert.assertEquals((Object)"long", (Object)results.getColumnByName("d").getRuntimeType());
        Assert.assertEquals((Object)"float", (Object)results.getColumnByName("e").getRuntimeType());
        Assert.assertEquals((Object)"double", (Object)results.getColumnByName("f").getRuntimeType());
        Assert.assertEquals((Object)"boolean", (Object)results.getColumnByName("g").getRuntimeType());
        Assert.assertEquals((Object)"string", (Object)results.getColumnByName("h").getRuntimeType());
        Assert.assertEquals((Object)"byte[]", (Object)results.getColumnByName("i").getRuntimeType());
        Assert.assertEquals((Object)"timestamp", (Object)results.getColumnByName("l").getRuntimeType());
        p = mf.getSchema().getProcedure("testTimeTypes");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"GET", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"http://localhost:8080/test/testTimeTypes", (Object)p.getProperty("teiid_rest:URI", false));
        Assert.assertNotNull((Object)p.getResultSet());
        results = p.getResultSet();
        Assert.assertEquals((Object)"timestamp", (Object)results.getColumnByName("date").getRuntimeType());
        Assert.assertEquals((Object)"timestamp", (Object)results.getColumnByName("sqlDate").getRuntimeType());
        p = mf.getSchema().getProcedure("testTypes");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"GET", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"http://localhost:8080/test/testTypes", (Object)p.getProperty("teiid_rest:URI", false));
        Assert.assertNotNull((Object)p.getResultSet());
        List pp = p.getParameters();
        Assert.assertEquals((Object)"integer", (Object)((ProcedureParameter)pp.get(0)).getRuntimeType());
        Assert.assertEquals((Object)"long", (Object)((ProcedureParameter)pp.get(1)).getRuntimeType());
        Assert.assertEquals((Object)"float", (Object)((ProcedureParameter)pp.get(2)).getRuntimeType());
        Assert.assertEquals((Object)"double", (Object)((ProcedureParameter)pp.get(3)).getRuntimeType());
        Assert.assertEquals((Object)"string", (Object)((ProcedureParameter)pp.get(4)).getRuntimeType());
        Assert.assertEquals((Object)"byte", (Object)((ProcedureParameter)pp.get(5)).getRuntimeType());
        Assert.assertEquals((Object)"string[]", (Object)((ProcedureParameter)pp.get(6)).getRuntimeType());
        Assert.assertEquals((Object)"boolean", (Object)((ProcedureParameter)pp.get(7)).getRuntimeType());
        Assert.assertEquals((Object)"timestamp", (Object)((ProcedureParameter)pp.get(8)).getRuntimeType());
    }

    @Test
    public void testOnetoOneEmbeddedReturn() throws TranslatorException {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.swaggerMetadata(translator);
        Procedure p = mf.getSchema().getProcedure("size");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"GET", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"http://localhost:8080/customer/status", (Object)p.getProperty("teiid_rest:URI", false));
        Assert.assertNotNull((Object)p.getResultSet());
        ColumnSet results = p.getResultSet();
        Assert.assertNotNull((Object)results.getColumnByName("size"));
        Assert.assertNotNull((Object)results.getColumnByName("heap_maxMemory"));
        Assert.assertNotNull((Object)results.getColumnByName("heap_freeMemory"));
    }

    @Test
    public void testDateTime() throws TranslatorException {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.swaggerMetadata(translator);
        Procedure p = mf.getSchema().getProcedure("testTimeTypes");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"GET", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"http://localhost:8080/test/testTimeTypes", (Object)p.getProperty("teiid_rest:URI", false));
        Assert.assertNotNull((Object)p.getResultSet());
        List columns = p.getResultSet().getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            Class type = column.getJavaType();
            Assert.assertEquals(Timestamp.class, (Object)type);
        }
    }

    @Test
    public void testRefToProcedureParam() throws TranslatorException {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.petstoreMetadata(translator);
        Procedure p = mf.getSchema().getProcedure("addPet");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"POST", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"http://petstore.swagger.io/v2/pet", (Object)p.getProperty("teiid_rest:URI", false));
        ProcedureParameter pa = p.getParameterByName("id");
        Assert.assertNull((Object)pa.getNameInSource());
        Assert.assertEquals((Object)"body", (Object)pa.getProperty("teiid_rest:PARAMETER_TYPE", false));
        pa = p.getParameterByName("category_id");
        Assert.assertEquals((Object)"category/id", (Object)pa.getNameInSource());
        Assert.assertEquals((Object)"body", (Object)pa.getProperty("teiid_rest:PARAMETER_TYPE", false));
        pa = p.getParameterByName("tags_Tag_id");
        Assert.assertEquals((Object)"tags[]/Tag/id", (Object)pa.getNameInSource());
        Assert.assertEquals((Object)"body", (Object)pa.getProperty("teiid_rest:PARAMETER_TYPE", false));
        Assert.assertEquals((Object)"long", (Object)pa.getRuntimeType());
    }

    @Test
    public void testReftoResponse() throws TranslatorException {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.petstoreMetadata(translator);
        Procedure p = mf.getSchema().getProcedure("findPetsByTags");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"GET", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"http://petstore.swagger.io/v2/pet/findByTags", (Object)p.getProperty("teiid_rest:URI", false));
        Assert.assertNotNull((Object)p.getResultSet());
        List columns = p.getResultSet().getColumns();
        Assert.assertEquals((long)8L, (long)columns.size());
        Column pa = p.getResultSet().getColumnByName("id");
        Assert.assertNull((Object)pa.getNameInSource());
        pa = p.getResultSet().getColumnByName("category_id");
        Assert.assertEquals((Object)"category/id", (Object)pa.getNameInSource());
        pa = p.getResultSet().getColumnByName("tags_Tag_id");
        Assert.assertEquals((Object)"tags[]/Tag/id", (Object)pa.getNameInSource());
    }

    @Test
    public void testBodyandPathProcedure() throws Exception {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.swaggerMetadata(translator);
        Procedure p = mf.getSchema().getProcedure("executeOperation");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"PUT", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"http://localhost:8080/operation/{operationId}", (Object)p.getProperty("teiid_rest:URI", false));
        Assert.assertNotNull((Object)p.getResultSet());
        Assert.assertNotNull((Object)p.getParameterByName("operationId"));
        Assert.assertNotNull((Object)p.getParameterByName("id"));
        Assert.assertNotNull((Object)p.getParameterByName("name"));
        Assert.assertNotNull((Object)p.getParameterByName("resourceId"));
        Assert.assertNotNull((Object)p.getParameterByName("definitionId"));
        Assert.assertNotNull((Object)p.getParameterByName("readyToSubmit"));
        Assert.assertNotNull((Object)p.getParameterByName("params_arguments"));
        List columns = p.getResultSet().getColumns();
        Assert.assertEquals((long)2L, (long)columns.size());
    }

    @Test
    public void testRefParameter() throws Exception {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.getMetadata(translator, UnitTestUtil.getTestDataPath() + "/redis-swagger.json");
        Procedure p = mf.getSchema().getProcedure("Operations_List");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"GET", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"https://management.azure.com/providers/Microsoft.Cache/operations", (Object)p.getProperty("teiid_rest:URI", false));
        Assert.assertNotNull((Object)p.getResultSet());
        Assert.assertNotNull((Object)p.getParameterByName("api-version"));
    }

    @Test
    public void testEndpointAsName() throws Exception {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.getMetadata(translator, UnitTestUtil.getTestDataPath() + "/fahrplan-swagger.json");
        Procedure p = mf.getSchema().getProcedure("arrivalBoard/id");
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)"GET", (Object)p.getProperty("teiid_rest:METHOD", false).toUpperCase());
        Assert.assertEquals((Object)"http://api.deutschebahn.com/freeplan/v1/arrivalBoard/{id}", (Object)p.getProperty("teiid_rest:URI", false));
        Assert.assertNotNull((Object)p.getResultSet());
    }

    @Test
    public void testObjectArrayTypes() throws Exception {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.getMetadata(translator, UnitTestUtil.getTestDataPath() + "/doubleclick-swagger.json");
        Procedure p = mf.getSchema().getProcedure("doubleclicksearch.reports.request");
        ProcedureParameter param = p.getParameterByName("filters_values");
        Assert.assertEquals((Object)"string[]", (Object)param.getRuntimeType());
    }

    @Test
    public void testRecursiveProperty() throws Exception {
        SwaggerExecutionFactory translator = new SwaggerExecutionFactory();
        translator.start();
        MetadataFactory mf = TestSwaggerMetadataProcessor.getMetadata(translator, UnitTestUtil.getTestDataPath() + "/magento-swagger.json");
        Assert.assertEquals((Object)ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"magento.ddl")), (Object)DDLStringVisitor.getDDLString((Schema)mf.getSchema(), null, null));
    }
}

