/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.swagger;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teiid.core.TeiidException;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Literal;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.swagger.SwaggerTypeManager;
import org.teiid.translator.ws.BinaryWSProcedureExecution;
import org.teiid.translator.ws.WSConnection;

public class BaseQueryExecution {
    protected WSConnection connection;
    protected ExecutionFactory translator;
    protected RuntimeMetadata metadata;
    protected ExecutionContext executionContext;

    public BaseQueryExecution(ExecutionFactory translator, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) {
        this.metadata = metadata;
        this.executionContext = executionContext;
        this.translator = translator;
        this.connection = connection;
    }

    String getHeader(BinaryWSProcedureExecution execution, String header) {
        Object value = execution.getResponseHeader(header);
        if (value instanceof List) {
            return (String)((List)value).get(0);
        }
        return (String)value;
    }

    public BinaryWSProcedureExecution buildInvokeHTTP(String method, String uri, Object payload, Map<String, List<String>> headers) throws TranslatorException {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.CONNECTOR", (int)5)) {
            try {
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"Source-URL=", (Object)URLDecoder.decode(uri, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        ArrayList<Argument> parameters = new ArrayList<Argument>();
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)method, TypeFacility.RUNTIME_TYPES.STRING), null));
        parameters.add(new Argument(Argument.Direction.IN, new Literal(payload, TypeFacility.RUNTIME_TYPES.STRING), null));
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)uri, TypeFacility.RUNTIME_TYPES.STRING), null));
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)true, TypeFacility.RUNTIME_TYPES.BOOLEAN), null));
        parameters.add(new Argument(Argument.Direction.OUT, TypeFacility.RUNTIME_TYPES.STRING, null));
        Call call = this.translator.getLanguageFactory().createCall("invokeHttp", parameters, null);
        BinaryWSProcedureExecution execution = new BinaryWSProcedureExecution(call, this.metadata, this.executionContext, null, this.connection);
        execution.setUseResponseContext(true);
        execution.setCustomHeaders(headers);
        return execution;
    }

    List<?> buildRow(List<Column> columns, boolean isMapResponse, Class<?>[] expectedType, Map<String, Object> values) throws TranslatorException {
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < columns.size(); ++i) {
            Object value;
            int arrayIndex;
            Column column = columns.get(i);
            String colName = column.getName();
            if (column.getNameInSource() != null) {
                colName = column.getNameInSource();
            }
            if ((arrayIndex = colName.indexOf("[]/")) != -1) {
                colName = colName.substring(0, arrayIndex) + colName.substring(colName.indexOf("/", arrayIndex + 3));
            }
            try {
                value = isMapResponse ? (colName.equals("key_name") ? values.keySet().iterator().next() : (colName.equals("key_value") ? values.values().iterator().next() : values.get(colName))) : values.get(colName);
                value = SwaggerTypeManager.convertTeiidRuntimeType(value, expectedType[i]);
            }
            catch (TeiidException e) {
                throw new TranslatorException((Throwable)e);
            }
            results.add(value);
        }
        return results;
    }
}

