CREATE FOREIGN PROCEDURE customerAddressRepositoryV1DeleteByIdDelete(OUT "return" boolean RESULT, IN addressId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Delete customer address by ID.', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/addresses/{addressId}');

CREATE FOREIGN PROCEDURE customerCustomerMetadataV1GetAllAttributesMetadataGet() RETURNS TABLE (attribute_code string, backend_type string, data_model string, frontend_class string, frontend_input string, frontend_label string, input_filter string, is_filterable_in_grid boolean, is_searchable_in_grid boolean, is_used_in_grid boolean, is_visible_in_grid boolean, multiline_count string, note string, "options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/value'), "options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/value'), required boolean, sort_order string, store_label string, "system" boolean, user_defined boolean, "validation_rules_customer-data-validation-rule-interface_name" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/name'), "validation_rules_customer-data-validation-rule-interface_value" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/value'), visible boolean)
OPTIONS (ANNOTATION 'Get all attribute metadata.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/attributeMetadata/customer');

CREATE FOREIGN PROCEDURE customerCustomerMetadataV1GetAttributeMetadataGet(IN attributeCode string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (attribute_code string, backend_type string, data_model string, frontend_class string, frontend_input string, frontend_label string, input_filter string, is_filterable_in_grid boolean, is_searchable_in_grid boolean, is_used_in_grid boolean, is_visible_in_grid boolean, multiline_count string, note string, "options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/value'), "options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/value'), required boolean, sort_order string, store_label string, "system" boolean, user_defined boolean, "validation_rules_customer-data-validation-rule-interface_name" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/name'), "validation_rules_customer-data-validation-rule-interface_value" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/value'), visible boolean)
OPTIONS (ANNOTATION 'Retrieve attribute metadata.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/attributeMetadata/customer/attribute/{attributeCode}');

CREATE FOREIGN PROCEDURE customerCustomerMetadataV1GetCustomAttributesMetadataGet(IN dataInterfaceName string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (attribute_code string, backend_type string, data_model string, frontend_class string, frontend_input string, frontend_label string, input_filter string, is_filterable_in_grid boolean, is_searchable_in_grid boolean, is_used_in_grid boolean, is_visible_in_grid boolean, multiline_count string, note string, "options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/value'), "options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/value'), required boolean, sort_order string, store_label string, "system" boolean, user_defined boolean, "validation_rules_customer-data-validation-rule-interface_name" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/name'), "validation_rules_customer-data-validation-rule-interface_value" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/value'), visible boolean)
OPTIONS (ANNOTATION 'Get custom attributes metadata for the given data interface.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/attributeMetadata/customer/custom');

CREATE FOREIGN PROCEDURE customerCustomerMetadataV1GetAttributesGet(IN formCode string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (attribute_code string, backend_type string, data_model string, frontend_class string, frontend_input string, frontend_label string, input_filter string, is_filterable_in_grid boolean, is_searchable_in_grid boolean, is_used_in_grid boolean, is_visible_in_grid boolean, multiline_count string, note string, "options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/value'), "options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/value'), required boolean, sort_order string, store_label string, "system" boolean, user_defined boolean, "validation_rules_customer-data-validation-rule-interface_name" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/name'), "validation_rules_customer-data-validation-rule-interface_value" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/value'), visible boolean)
OPTIONS (ANNOTATION 'Retrieve all attributes filtered by form code', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/attributeMetadata/customer/form/{formCode}');

CREATE FOREIGN PROCEDURE customerAddressMetadataV1GetAllAttributesMetadataGet() RETURNS TABLE (attribute_code string, backend_type string, data_model string, frontend_class string, frontend_input string, frontend_label string, input_filter string, is_filterable_in_grid boolean, is_searchable_in_grid boolean, is_used_in_grid boolean, is_visible_in_grid boolean, multiline_count string, note string, "options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/value'), "options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/value'), required boolean, sort_order string, store_label string, "system" boolean, user_defined boolean, "validation_rules_customer-data-validation-rule-interface_name" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/name'), "validation_rules_customer-data-validation-rule-interface_value" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/value'), visible boolean)
OPTIONS (ANNOTATION 'Get all attribute metadata.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/attributeMetadata/customerAddress');

CREATE FOREIGN PROCEDURE customerAddressMetadataV1GetAttributeMetadataGet(IN attributeCode string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (attribute_code string, backend_type string, data_model string, frontend_class string, frontend_input string, frontend_label string, input_filter string, is_filterable_in_grid boolean, is_searchable_in_grid boolean, is_used_in_grid boolean, is_visible_in_grid boolean, multiline_count string, note string, "options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/value'), "options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/value'), required boolean, sort_order string, store_label string, "system" boolean, user_defined boolean, "validation_rules_customer-data-validation-rule-interface_name" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/name'), "validation_rules_customer-data-validation-rule-interface_value" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/value'), visible boolean)
OPTIONS (ANNOTATION 'Retrieve attribute metadata.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/attributeMetadata/customerAddress/attribute/{attributeCode}');

CREATE FOREIGN PROCEDURE customerAddressMetadataV1GetCustomAttributesMetadataGet(IN dataInterfaceName string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (attribute_code string, backend_type string, data_model string, frontend_class string, frontend_input string, frontend_label string, input_filter string, is_filterable_in_grid boolean, is_searchable_in_grid boolean, is_used_in_grid boolean, is_visible_in_grid boolean, multiline_count string, note string, "options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/value'), "options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/value'), required boolean, sort_order string, store_label string, "system" boolean, user_defined boolean, "validation_rules_customer-data-validation-rule-interface_name" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/name'), "validation_rules_customer-data-validation-rule-interface_value" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/value'), visible boolean)
OPTIONS (ANNOTATION 'Get custom attributes metadata for the given data interface.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/attributeMetadata/customerAddress/custom');

CREATE FOREIGN PROCEDURE customerAddressMetadataV1GetAttributesGet(IN formCode string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (attribute_code string, backend_type string, data_model string, frontend_class string, frontend_input string, frontend_label string, input_filter string, is_filterable_in_grid boolean, is_searchable_in_grid boolean, is_used_in_grid boolean, is_visible_in_grid boolean, multiline_count string, note string, "options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/label'), "options_customer-data-option-interface_options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/options[]/customer-data-option-interface/value'), "options_customer-data-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/customer-data-option-interface/value'), required boolean, sort_order string, store_label string, "system" boolean, user_defined boolean, "validation_rules_customer-data-validation-rule-interface_name" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/name'), "validation_rules_customer-data-validation-rule-interface_value" string OPTIONS (NAMEINSOURCE 'validation_rules[]/customer-data-validation-rule-interface/value'), visible boolean)
OPTIONS (ANNOTATION 'Retrieve all attributes filtered by form code', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/attributeMetadata/customerAddress/form/{formCode}');

CREATE FOREIGN PROCEDURE bundleProductOptionManagementV1SavePost(OUT "return" string RESULT, IN option_option_id string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'option/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_position string NOT NULL OPTIONS (ANNOTATION 'Option position', NAMEINSOURCE 'option/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_can_change_quantity" string NOT NULL OPTIONS (ANNOTATION 'Whether quantity could be changed', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/can_change_quantity', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_id" string NOT NULL OPTIONS (ANNOTATION 'The identifier', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_is_default" boolean NOT NULL OPTIONS (ANNOTATION 'Is default', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/is_default', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_position" string NOT NULL OPTIONS (ANNOTATION 'Position', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_price" string NOT NULL OPTIONS (ANNOTATION 'Price', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_price_type" string NOT NULL OPTIONS (ANNOTATION 'Price type', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/price_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_qty" string NOT NULL OPTIONS (ANNOTATION 'Qty', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_sku" string NOT NULL OPTIONS (ANNOTATION 'Linked product sku', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_required boolean NOT NULL OPTIONS (ANNOTATION 'Is required option', NAMEINSOURCE 'option/required', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_sku string NOT NULL OPTIONS (ANNOTATION 'Product sku', NAMEINSOURCE 'option/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_title string NOT NULL OPTIONS (ANNOTATION 'Option title', NAMEINSOURCE 'option/title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_type string NOT NULL OPTIONS (ANNOTATION 'Input type', NAMEINSOURCE 'option/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Add new option for bundle product', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/bundle-products/options/add');

CREATE FOREIGN PROCEDURE bundleProductOptionTypeListV1GetItemsGet() RETURNS TABLE (code string, label string)
OPTIONS (ANNOTATION 'Get all types for options for bundle products', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/bundle-products/options/types');

CREATE FOREIGN PROCEDURE bundleProductOptionManagementV1SavePut(OUT "return" string RESULT, IN optionId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN option_option_id string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'option/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_position string NOT NULL OPTIONS (ANNOTATION 'Option position', NAMEINSOURCE 'option/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_can_change_quantity" string NOT NULL OPTIONS (ANNOTATION 'Whether quantity could be changed', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/can_change_quantity', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_id" string NOT NULL OPTIONS (ANNOTATION 'The identifier', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_is_default" boolean NOT NULL OPTIONS (ANNOTATION 'Is default', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/is_default', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_position" string NOT NULL OPTIONS (ANNOTATION 'Position', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_price" string NOT NULL OPTIONS (ANNOTATION 'Price', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_price_type" string NOT NULL OPTIONS (ANNOTATION 'Price type', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/price_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_qty" string NOT NULL OPTIONS (ANNOTATION 'Qty', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_product_links_bundle-data-link-interface_sku" string NOT NULL OPTIONS (ANNOTATION 'Linked product sku', NAMEINSOURCE 'option/product_links[]/bundle-data-link-interface/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_required boolean NOT NULL OPTIONS (ANNOTATION 'Is required option', NAMEINSOURCE 'option/required', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_sku string NOT NULL OPTIONS (ANNOTATION 'Product sku', NAMEINSOURCE 'option/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_title string NOT NULL OPTIONS (ANNOTATION 'Option title', NAMEINSOURCE 'option/title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_type string NOT NULL OPTIONS (ANNOTATION 'Input type', NAMEINSOURCE 'option/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Add new option for bundle product', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/bundle-products/options/{optionId}');

CREATE FOREIGN PROCEDURE bundleProductLinkManagementV1GetChildrenGet(IN productSku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN optionId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (can_change_quantity string, id string, is_default boolean, option_id string, position string, price string, price_type string, qty string, sku string)
OPTIONS (ANNOTATION 'Get all children for Bundle product', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/bundle-products/{productSku}/children');

CREATE FOREIGN PROCEDURE bundleProductLinkManagementV1SaveChildPut(OUT "return" boolean RESULT, IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN linkedProduct_can_change_quantity string NOT NULL OPTIONS (ANNOTATION 'Whether quantity could be changed', NAMEINSOURCE 'linkedProduct/can_change_quantity', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_id string NOT NULL OPTIONS (ANNOTATION 'The identifier', NAMEINSOURCE 'linkedProduct/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_is_default boolean NOT NULL OPTIONS (ANNOTATION 'Is default', NAMEINSOURCE 'linkedProduct/is_default', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_option_id string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'linkedProduct/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_position string NOT NULL OPTIONS (ANNOTATION 'Position', NAMEINSOURCE 'linkedProduct/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_price string NOT NULL OPTIONS (ANNOTATION 'Price', NAMEINSOURCE 'linkedProduct/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_price_type string NOT NULL OPTIONS (ANNOTATION 'Price type', NAMEINSOURCE 'linkedProduct/price_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_qty string NOT NULL OPTIONS (ANNOTATION 'Qty', NAMEINSOURCE 'linkedProduct/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_sku string NOT NULL OPTIONS (ANNOTATION 'Linked product sku', NAMEINSOURCE 'linkedProduct/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS ("teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/bundle-products/{sku}/links/{id}');

CREATE FOREIGN PROCEDURE bundleProductLinkManagementV1AddChildByProductSkuPost(OUT "return" string RESULT, IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN optionId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN linkedProduct_can_change_quantity string NOT NULL OPTIONS (ANNOTATION 'Whether quantity could be changed', NAMEINSOURCE 'linkedProduct/can_change_quantity', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_id string NOT NULL OPTIONS (ANNOTATION 'The identifier', NAMEINSOURCE 'linkedProduct/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_is_default boolean NOT NULL OPTIONS (ANNOTATION 'Is default', NAMEINSOURCE 'linkedProduct/is_default', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_option_id string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'linkedProduct/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_position string NOT NULL OPTIONS (ANNOTATION 'Position', NAMEINSOURCE 'linkedProduct/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_price string NOT NULL OPTIONS (ANNOTATION 'Price', NAMEINSOURCE 'linkedProduct/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_price_type string NOT NULL OPTIONS (ANNOTATION 'Price type', NAMEINSOURCE 'linkedProduct/price_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_qty string NOT NULL OPTIONS (ANNOTATION 'Qty', NAMEINSOURCE 'linkedProduct/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN linkedProduct_sku string NOT NULL OPTIONS (ANNOTATION 'Linked product sku', NAMEINSOURCE 'linkedProduct/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Add child product to specified Bundle option by product sku', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/bundle-products/{sku}/links/{optionId}');

CREATE FOREIGN PROCEDURE bundleProductOptionRepositoryV1GetListGet(IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (option_id string, position string, "product_links_bundle-data-link-interface_can_change_quantity" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/can_change_quantity'), "product_links_bundle-data-link-interface_id" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/id'), "product_links_bundle-data-link-interface_is_default" boolean OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/is_default'), "product_links_bundle-data-link-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/option_id'), "product_links_bundle-data-link-interface_position" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/position'), "product_links_bundle-data-link-interface_price" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/price'), "product_links_bundle-data-link-interface_price_type" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/price_type'), "product_links_bundle-data-link-interface_qty" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/qty'), "product_links_bundle-data-link-interface_sku" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/sku'), required boolean, sku string, title string, type string)
OPTIONS (ANNOTATION 'Get all options for bundle product', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/bundle-products/{sku}/options/all');

CREATE FOREIGN PROCEDURE bundleProductOptionRepositoryV1GetGet(IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN optionId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (option_id string, position string, "product_links_bundle-data-link-interface_can_change_quantity" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/can_change_quantity'), "product_links_bundle-data-link-interface_id" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/id'), "product_links_bundle-data-link-interface_is_default" boolean OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/is_default'), "product_links_bundle-data-link-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/option_id'), "product_links_bundle-data-link-interface_position" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/position'), "product_links_bundle-data-link-interface_price" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/price'), "product_links_bundle-data-link-interface_price_type" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/price_type'), "product_links_bundle-data-link-interface_qty" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/qty'), "product_links_bundle-data-link-interface_sku" string OPTIONS (NAMEINSOURCE 'product_links[]/bundle-data-link-interface/sku'), required boolean, sku string, title string, type string)
OPTIONS (ANNOTATION 'Get option for bundle product', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/bundle-products/{sku}/options/{optionId}');

CREATE FOREIGN PROCEDURE bundleProductOptionRepositoryV1DeleteByIdDelete(OUT "return" boolean RESULT, IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN optionId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Remove bundle option', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/bundle-products/{sku}/options/{optionId}');

CREATE FOREIGN PROCEDURE bundleProductLinkManagementV1RemoveChildDelete(OUT "return" boolean RESULT, IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN optionId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN childSku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Remove product from Bundle product option', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/bundle-products/{sku}/options/{optionId}/children/{childSku}');

CREATE FOREIGN PROCEDURE quoteCartManagementV1CreateEmptyCartPost(OUT "return" string RESULT) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Creates an empty cart and quote for a guest.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/');

CREATE FOREIGN PROCEDURE giftCardAccountGuestGiftCardAccountManagementV1CheckGiftCardGet(OUT "return" string RESULT, IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN giftCardCode string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS ("teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/guest-carts/{cartId}/checkGiftCard/{giftCardCode}');

CREATE FOREIGN PROCEDURE giftCardAccountGuestGiftCardAccountManagementV1AddGiftCardPost(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN giftCardAccountData_base_gift_cards_amount string NOT NULL OPTIONS (ANNOTATION 'Cards amount in base currency', NAMEINSOURCE 'giftCardAccountData/base_gift_cards_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftCardAccountData_base_gift_cards_amount_used string NOT NULL OPTIONS (ANNOTATION 'Cards amount used in base currency', NAMEINSOURCE 'giftCardAccountData/base_gift_cards_amount_used', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftCardAccountData_gift_cards string[] NOT NULL OPTIONS (NAMEINSOURCE 'giftCardAccountData/gift_cards', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftCardAccountData_gift_cards_amount string NOT NULL OPTIONS (ANNOTATION 'Cards amount in quote currency', NAMEINSOURCE 'giftCardAccountData/gift_cards_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftCardAccountData_gift_cards_amount_used string NOT NULL OPTIONS (ANNOTATION 'Cards amount used in quote currency', NAMEINSOURCE 'giftCardAccountData/gift_cards_amount_used', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS ("teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/guest-carts/{cartId}/giftCards');

CREATE FOREIGN PROCEDURE giftCardAccountGuestGiftCardAccountManagementV1DeleteByQuoteIdDelete(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN giftCardCode string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Remove GiftCard Account entity', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/guest-carts/{cartId}/giftCards/{giftCardCode}');

CREATE FOREIGN PROCEDURE checkoutAgreementsCheckoutAgreementsRepositoryV1GetListGet() RETURNS TABLE (agreement_id string, checkbox_text string, content string, content_height string, is_active boolean, is_html boolean, mode string, name string)
OPTIONS (ANNOTATION 'Lists active checkout agreements.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/licence');

CREATE FOREIGN PROCEDURE quoteCartManagementV1GetCartForCustomerGet() RETURNS TABLE (billing_address_city string OPTIONS (NAMEINSOURCE 'billing_address/city'), billing_address_company string OPTIONS (NAMEINSOURCE 'billing_address/company'), billing_address_country_id string OPTIONS (NAMEINSOURCE 'billing_address/country_id'), "billing_address_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'billing_address/custom_attributes[]/framework-attribute-interface/attribute_code'), "billing_address_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'billing_address/custom_attributes[]/framework-attribute-interface/value'), billing_address_customer_address_id string OPTIONS (NAMEINSOURCE 'billing_address/customer_address_id'), billing_address_customer_id string OPTIONS (NAMEINSOURCE 'billing_address/customer_id'), billing_address_email string OPTIONS (NAMEINSOURCE 'billing_address/email'), billing_address_extension_attributes_gift_registry_id string OPTIONS (NAMEINSOURCE 'billing_address/extension_attributes/gift_registry_id'), billing_address_fax string OPTIONS (NAMEINSOURCE 'billing_address/fax'), billing_address_firstname string OPTIONS (NAMEINSOURCE 'billing_address/firstname'), billing_address_id string OPTIONS (NAMEINSOURCE 'billing_address/id'), billing_address_lastname string OPTIONS (NAMEINSOURCE 'billing_address/lastname'), billing_address_middlename string OPTIONS (NAMEINSOURCE 'billing_address/middlename'), billing_address_postcode string OPTIONS (NAMEINSOURCE 'billing_address/postcode'), billing_address_prefix string OPTIONS (NAMEINSOURCE 'billing_address/prefix'), billing_address_region string OPTIONS (NAMEINSOURCE 'billing_address/region'), billing_address_region_code string OPTIONS (NAMEINSOURCE 'billing_address/region_code'), billing_address_region_id string OPTIONS (NAMEINSOURCE 'billing_address/region_id'), billing_address_same_as_billing string OPTIONS (NAMEINSOURCE 'billing_address/same_as_billing'), billing_address_save_in_address_book string OPTIONS (NAMEINSOURCE 'billing_address/save_in_address_book'), billing_address_street string[] OPTIONS (NAMEINSOURCE 'billing_address/street'), billing_address_suffix string OPTIONS (NAMEINSOURCE 'billing_address/suffix'), billing_address_telephone string OPTIONS (NAMEINSOURCE 'billing_address/telephone'), billing_address_vat_id string OPTIONS (NAMEINSOURCE 'billing_address/vat_id'), converted_at string, created_at string, currency_base_currency_code string OPTIONS (NAMEINSOURCE 'currency/base_currency_code'), currency_base_to_global_rate string OPTIONS (NAMEINSOURCE 'currency/base_to_global_rate'), currency_base_to_quote_rate string OPTIONS (NAMEINSOURCE 'currency/base_to_quote_rate'), currency_global_currency_code string OPTIONS (NAMEINSOURCE 'currency/global_currency_code'), currency_quote_currency_code string OPTIONS (NAMEINSOURCE 'currency/quote_currency_code'), currency_store_currency_code string OPTIONS (NAMEINSOURCE 'currency/store_currency_code'), currency_store_to_base_rate string OPTIONS (NAMEINSOURCE 'currency/store_to_base_rate'), currency_store_to_quote_rate string OPTIONS (NAMEINSOURCE 'currency/store_to_quote_rate'), "customer_addresses_customer-data-address-interface_city" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/city'), "customer_addresses_customer-data-address-interface_company" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/company'), "customer_addresses_customer-data-address-interface_country_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/country_id'), "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value'), "customer_addresses_customer-data-address-interface_customer_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/customer_id'), "customer_addresses_customer-data-address-interface_default_billing" boolean OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_billing'), "customer_addresses_customer-data-address-interface_default_shipping" boolean OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_shipping'), "customer_addresses_customer-data-address-interface_fax" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/fax'), "customer_addresses_customer-data-address-interface_firstname" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/firstname'), "customer_addresses_customer-data-address-interface_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/id'), "customer_addresses_customer-data-address-interface_lastname" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/lastname'), "customer_addresses_customer-data-address-interface_middlename" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/middlename'), "customer_addresses_customer-data-address-interface_postcode" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/postcode'), "customer_addresses_customer-data-address-interface_prefix" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/prefix'), "customer_addresses_customer-data-address-interface_region_region" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region'), "customer_addresses_customer-data-address-interface_region_region_code" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_code'), "customer_addresses_customer-data-address-interface_region_region_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_id'), "customer_addresses_customer-data-address-interface_region_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region_id'), "customer_addresses_customer-data-address-interface_street" string[] OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/street'), "customer_addresses_customer-data-address-interface_suffix" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/suffix'), "customer_addresses_customer-data-address-interface_telephone" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/telephone'), "customer_addresses_customer-data-address-interface_vat_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/vat_id'), customer_confirmation string OPTIONS (NAMEINSOURCE 'customer/confirmation'), customer_created_at string OPTIONS (NAMEINSOURCE 'customer/created_at'), customer_created_in string OPTIONS (NAMEINSOURCE 'customer/created_in'), "customer_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/attribute_code'), "customer_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/value'), customer_default_billing string OPTIONS (NAMEINSOURCE 'customer/default_billing'), customer_default_shipping string OPTIONS (NAMEINSOURCE 'customer/default_shipping'), customer_disable_auto_group_change string OPTIONS (NAMEINSOURCE 'customer/disable_auto_group_change'), customer_dob string OPTIONS (NAMEINSOURCE 'customer/dob'), customer_email string OPTIONS (NAMEINSOURCE 'customer/email'), customer_extension_attributes_is_subscribed boolean OPTIONS (NAMEINSOURCE 'customer/extension_attributes/is_subscribed'), customer_firstname string OPTIONS (NAMEINSOURCE 'customer/firstname'), customer_gender string OPTIONS (NAMEINSOURCE 'customer/gender'), customer_group_id string OPTIONS (NAMEINSOURCE 'customer/group_id'), customer_id string OPTIONS (NAMEINSOURCE 'customer/id'), customer_lastname string OPTIONS (NAMEINSOURCE 'customer/lastname'), customer_middlename string OPTIONS (NAMEINSOURCE 'customer/middlename'), customer_prefix string OPTIONS (NAMEINSOURCE 'customer/prefix'), customer_store_id string OPTIONS (NAMEINSOURCE 'customer/store_id'), customer_suffix string OPTIONS (NAMEINSOURCE 'customer/suffix'), customer_taxvat string OPTIONS (NAMEINSOURCE 'customer/taxvat'), customer_updated_at string OPTIONS (NAMEINSOURCE 'customer/updated_at'), customer_website_id string OPTIONS (NAMEINSOURCE 'customer/website_id'), customer_is_guest boolean, customer_note string, customer_note_notify boolean, customer_tax_class_id string, "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/item_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/name'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_price" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/price'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_downloadable_option_downloadable_links" string[] OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/downloadable_option/downloadable_links'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_amount" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_amount'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_message" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_message'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_type'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_qty" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/qty'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_quote_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/quote_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_sku" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/sku'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_city" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/city'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_company" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/company'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_country_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/country_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/custom_attributes[]/framework-attribute-interface/attribute_code'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/custom_attributes[]/framework-attribute-interface/value'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_customer_address_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/customer_address_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_customer_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/customer_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_email" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/email'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_extension_attributes_gift_registry_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/extension_attributes/gift_registry_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_fax" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/fax'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_firstname" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/firstname'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_lastname" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/lastname'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_middlename" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/middlename'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_postcode" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/postcode'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_prefix" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/prefix'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region_code" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region_code'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_same_as_billing" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/same_as_billing'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_save_in_address_book" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/save_in_address_book'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_street" string[] OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/street'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_suffix" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/suffix'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_telephone" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/telephone'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_vat_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/vat_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_method" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/method'), id string, is_active boolean, is_virtual boolean, "items_quote-data-cart-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/item_id'), "items_quote-data-cart-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/name'), "items_quote-data-cart-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/price'), "items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), "items_quote-data-cart-item-interface_product_option_extension_attributes_downloadable_option_downloadable_links" string[] OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/downloadable_option/downloadable_links'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_amount'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_message" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_message'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), "items_quote-data-cart-item-interface_product_type" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_type'), "items_quote-data-cart-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/qty'), "items_quote-data-cart-item-interface_quote_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/quote_id'), "items_quote-data-cart-item-interface_sku" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/sku'), items_count string, items_qty string, orig_order_id string, reserved_order_id string, store_id string, updated_at string)
OPTIONS (ANNOTATION 'Returns information for the cart for a specified customer.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine');

CREATE FOREIGN PROCEDURE quoteCartRepositoryV1SavePut(IN quote_billing_address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'quote/billing_address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'quote/billing_address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'quote/billing_address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_billing_address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'quote/billing_address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_billing_address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'quote/billing_address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'quote/billing_address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'quote/billing_address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'quote/billing_address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'quote/billing_address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'quote/billing_address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'quote/billing_address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'quote/billing_address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'quote/billing_address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'quote/billing_address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'quote/billing_address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'quote/billing_address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'quote/billing_address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'quote/billing_address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'quote/billing_address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'quote/billing_address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'quote/billing_address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'quote/billing_address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'quote/billing_address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'quote/billing_address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_billing_address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'quote/billing_address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_converted_at string NOT NULL OPTIONS (ANNOTATION 'Cart conversion date and time. Otherwise, null.', NAMEINSOURCE 'quote/converted_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_created_at string NOT NULL OPTIONS (ANNOTATION 'Cart creation date and time. Otherwise, null.', NAMEINSOURCE 'quote/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_currency_base_currency_code string NOT NULL OPTIONS (ANNOTATION 'Base currency code', NAMEINSOURCE 'quote/currency/base_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_currency_base_to_global_rate string NOT NULL OPTIONS (ANNOTATION 'Base currency to global currency rate', NAMEINSOURCE 'quote/currency/base_to_global_rate', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_currency_base_to_quote_rate string NOT NULL OPTIONS (ANNOTATION 'Base currency to quote currency rate', NAMEINSOURCE 'quote/currency/base_to_quote_rate', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_currency_global_currency_code string NOT NULL OPTIONS (ANNOTATION 'Global currency code', NAMEINSOURCE 'quote/currency/global_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_currency_quote_currency_code string NOT NULL OPTIONS (ANNOTATION 'Quote currency code', NAMEINSOURCE 'quote/currency/quote_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_currency_store_currency_code string NOT NULL OPTIONS (ANNOTATION 'Store currency code', NAMEINSOURCE 'quote/currency/store_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_currency_store_to_base_rate string NOT NULL OPTIONS (ANNOTATION 'Store currency to base currency rate', NAMEINSOURCE 'quote/currency/store_to_base_rate', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_currency_store_to_quote_rate string NOT NULL OPTIONS (ANNOTATION 'Store currency to quote currency rate', NAMEINSOURCE 'quote/currency/store_to_quote_rate', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_city" string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_company" string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_country_id" string NOT NULL OPTIONS (ANNOTATION 'Country code in ISO_3166-2 format', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_customer_id" string NOT NULL OPTIONS (ANNOTATION 'Customer ID', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_default_billing" boolean NOT NULL OPTIONS (ANNOTATION 'If this address is default billing address', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/default_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_default_shipping" boolean NOT NULL OPTIONS (ANNOTATION 'If this address is default shipping address.', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/default_shipping', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_fax" string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_firstname" string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_id" string NOT NULL OPTIONS (ANNOTATION 'ID', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_lastname" string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_middlename" string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_postcode" string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_prefix" string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_region_region" string NOT NULL OPTIONS (ANNOTATION 'Region', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/region/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_region_region_code" string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/region/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_region_region_id" string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/region/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_region_id" string NOT NULL OPTIONS (ANNOTATION 'Region ID', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_street" string[] NOT NULL OPTIONS (NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_suffix" string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_telephone" string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_addresses_customer-data-address-interface_vat_id" string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'quote/customer/addresses[]/customer-data-address-interface/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_confirmation string NOT NULL OPTIONS (ANNOTATION 'Confirmation', NAMEINSOURCE 'quote/customer/confirmation', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_created_at string NOT NULL OPTIONS (ANNOTATION 'Created at time', NAMEINSOURCE 'quote/customer/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_created_in string NOT NULL OPTIONS (ANNOTATION 'Created in area', NAMEINSOURCE 'quote/customer/created_in', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'quote/customer/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_customer_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'quote/customer/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_default_billing string NOT NULL OPTIONS (ANNOTATION 'Default billing address id', NAMEINSOURCE 'quote/customer/default_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_default_shipping string NOT NULL OPTIONS (ANNOTATION 'Default shipping address id', NAMEINSOURCE 'quote/customer/default_shipping', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_disable_auto_group_change string NOT NULL OPTIONS (ANNOTATION 'Disable auto group change flag.', NAMEINSOURCE 'quote/customer/disable_auto_group_change', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_dob string NOT NULL OPTIONS (ANNOTATION 'Date of birth', NAMEINSOURCE 'quote/customer/dob', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_email string NOT NULL OPTIONS (ANNOTATION 'Email address', NAMEINSOURCE 'quote/customer/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_extension_attributes_is_subscribed boolean NOT NULL OPTIONS (NAMEINSOURCE 'quote/customer/extension_attributes/is_subscribed', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'quote/customer/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_gender string NOT NULL OPTIONS (ANNOTATION 'Gender', NAMEINSOURCE 'quote/customer/gender', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_group_id string NOT NULL OPTIONS (ANNOTATION 'Group id', NAMEINSOURCE 'quote/customer/group_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'quote/customer/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'quote/customer/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'quote/customer/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'quote/customer/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_store_id string NOT NULL OPTIONS (ANNOTATION 'Store id', NAMEINSOURCE 'quote/customer/store_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'quote/customer/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_taxvat string NOT NULL OPTIONS (ANNOTATION 'Tax Vat', NAMEINSOURCE 'quote/customer/taxvat', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_updated_at string NOT NULL OPTIONS (ANNOTATION 'Updated at time', NAMEINSOURCE 'quote/customer/updated_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_website_id string NOT NULL OPTIONS (ANNOTATION 'Website id', NAMEINSOURCE 'quote/customer/website_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_is_guest boolean NOT NULL OPTIONS (ANNOTATION 'For guest customers, false for logged in customers', NAMEINSOURCE 'quote/customer_is_guest', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_note string NOT NULL OPTIONS (ANNOTATION 'Notice text', NAMEINSOURCE 'quote/customer_note', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_note_notify boolean NOT NULL OPTIONS (ANNOTATION 'Customer notification flag', NAMEINSOURCE 'quote/customer_note_notify', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_customer_tax_class_id string NOT NULL OPTIONS (ANNOTATION 'Customer tax class ID.', NAMEINSOURCE 'quote/customer_tax_class_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_item_id" string NOT NULL OPTIONS (ANNOTATION 'Item ID. Otherwise, null.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/item_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_name" string NOT NULL OPTIONS (ANNOTATION 'Product name. Otherwise, null.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_price" string NOT NULL OPTIONS (ANNOTATION 'Product price. Otherwise, null.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Bundle option id.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string NOT NULL OPTIONS (ANNOTATION 'Bundle option quantity.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] NOT NULL OPTIONS (NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option SKU', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Item id', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string NOT NULL OPTIONS (ANNOTATION 'Media data (base64 encoded content)', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string NOT NULL OPTIONS (ANNOTATION 'Image name', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string NOT NULL OPTIONS (ANNOTATION 'MIME type', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Option value', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_downloadable_option_downloadable_links" string[] NOT NULL OPTIONS (NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/downloadable_option/downloadable_links', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount" string NOT NULL OPTIONS (ANNOTATION 'Gift card open amount value.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_amount" string NOT NULL OPTIONS (ANNOTATION 'Gift card amount.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_message" string NOT NULL OPTIONS (ANNOTATION 'Giftcard message.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email" string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient email.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name" string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient name.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email" string NOT NULL OPTIONS (ANNOTATION 'Gift card sender email.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name" string NOT NULL OPTIONS (ANNOTATION 'Gift card sender name.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_type" string NOT NULL OPTIONS (ANNOTATION 'Product type. Otherwise, null.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_qty" string NOT NULL OPTIONS (ANNOTATION 'Product quantity.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_quote_id" string NOT NULL OPTIONS (ANNOTATION 'Quote id.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/quote_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_sku" string NOT NULL OPTIONS (ANNOTATION 'Product SKU. Otherwise, null.', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_city" string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_company" string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_country_id" string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_customer_address_id" string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_customer_id" string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_email" string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_extension_attributes_gift_registry_id" string NOT NULL OPTIONS (NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_fax" string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_firstname" string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_id" string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_lastname" string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_middlename" string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_postcode" string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_prefix" string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region" string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region_code" string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region_id" string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_same_as_billing" string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_save_in_address_book" string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_street" string[] NOT NULL OPTIONS (NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_suffix" string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_telephone" string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_vat_id" string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_method" string NOT NULL OPTIONS (ANNOTATION 'Shipping method', NAMEINSOURCE 'quote/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/method', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_id string NOT NULL OPTIONS (ANNOTATION 'Cart/quote ID.', NAMEINSOURCE 'quote/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_is_active boolean NOT NULL OPTIONS (ANNOTATION 'Active status flag value. Otherwise, null.', NAMEINSOURCE 'quote/is_active', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_is_virtual boolean NOT NULL OPTIONS (ANNOTATION 'Virtual flag value. Otherwise, null.', NAMEINSOURCE 'quote/is_virtual', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_item_id" string NOT NULL OPTIONS (ANNOTATION 'Item ID. Otherwise, null.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/item_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_name" string NOT NULL OPTIONS (ANNOTATION 'Product name. Otherwise, null.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_price" string NOT NULL OPTIONS (ANNOTATION 'Product price. Otherwise, null.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Bundle option id.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string NOT NULL OPTIONS (ANNOTATION 'Bundle option quantity.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] NOT NULL OPTIONS (NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option SKU', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Item id', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string NOT NULL OPTIONS (ANNOTATION 'Media data (base64 encoded content)', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string NOT NULL OPTIONS (ANNOTATION 'Image name', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string NOT NULL OPTIONS (ANNOTATION 'MIME type', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Option value', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_downloadable_option_downloadable_links" string[] NOT NULL OPTIONS (NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/downloadable_option/downloadable_links', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount" string NOT NULL OPTIONS (ANNOTATION 'Gift card open amount value.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_amount" string NOT NULL OPTIONS (ANNOTATION 'Gift card amount.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_message" string NOT NULL OPTIONS (ANNOTATION 'Giftcard message.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email" string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient email.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name" string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient name.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email" string NOT NULL OPTIONS (ANNOTATION 'Gift card sender email.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name" string NOT NULL OPTIONS (ANNOTATION 'Gift card sender name.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_product_type" string NOT NULL OPTIONS (ANNOTATION 'Product type. Otherwise, null.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/product_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_qty" string NOT NULL OPTIONS (ANNOTATION 'Product quantity.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_quote_id" string NOT NULL OPTIONS (ANNOTATION 'Quote id.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/quote_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "quote_items_quote-data-cart-item-interface_sku" string NOT NULL OPTIONS (ANNOTATION 'Product SKU. Otherwise, null.', NAMEINSOURCE 'quote/items[]/quote-data-cart-item-interface/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_items_count string NOT NULL OPTIONS (ANNOTATION 'Number of different items or products in the cart. Otherwise, null.', NAMEINSOURCE 'quote/items_count', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_items_qty string NOT NULL OPTIONS (ANNOTATION 'Total quantity of all cart items. Otherwise, null.', NAMEINSOURCE 'quote/items_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_orig_order_id string NOT NULL OPTIONS (ANNOTATION 'Original order ID. Otherwise, null.', NAMEINSOURCE 'quote/orig_order_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_reserved_order_id string NOT NULL OPTIONS (ANNOTATION 'Reserved order ID. Otherwise, null.', NAMEINSOURCE 'quote/reserved_order_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_store_id string NOT NULL OPTIONS (ANNOTATION 'Store identifier', NAMEINSOURCE 'quote/store_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN quote_updated_at string NOT NULL OPTIONS (ANNOTATION 'Cart last update date and time. Otherwise, null.', NAMEINSOURCE 'quote/updated_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Save quote', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine');

CREATE FOREIGN PROCEDURE "V1/carts/mine_POST"(OUT "return" string RESULT) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Creates an empty cart and quote for a specified customer.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine');

CREATE FOREIGN PROCEDURE customerBalanceBalanceManagementV1ApplyPost(OUT "return" boolean RESULT) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Apply store credit', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/balance/apply');

CREATE FOREIGN PROCEDURE "V1/carts/mine/billing-address_GET"() RETURNS TABLE (city string, company string, country_id string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), customer_address_id string, customer_id string, email string, extension_attributes_gift_registry_id string OPTIONS (NAMEINSOURCE 'extension_attributes/gift_registry_id'), fax string, firstname string, id string, lastname string, middlename string, postcode string, prefix string, region string, region_code string, region_id string, same_as_billing string, save_in_address_book string, street string[], suffix string, telephone string, vat_id string)
OPTIONS (ANNOTATION 'Returns the billing address for a specified quote.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/billing-address');

CREATE FOREIGN PROCEDURE "V1/carts/mine/billing-address_POST"(OUT "return" string RESULT, IN address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN useForShipping boolean NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Assigns a specified billing address to a specified cart.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/billing-address');

CREATE FOREIGN PROCEDURE giftCardAccountGiftCardAccountManagementV1CheckGiftCardGet(OUT "return" string RESULT, IN giftCardCode string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS ("teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/checkGiftCard/{giftCardCode}');

CREATE FOREIGN PROCEDURE quoteCartTotalManagementV1CollectTotalsPut(IN "additionalData_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'additionalData/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'additionalData/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_customer_id" string NOT NULL OPTIONS (ANNOTATION 'Customer ID. Otherwise, null.', NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_extension_attributes_entity_id" string NOT NULL OPTIONS (NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/extension_attributes/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_extension_attributes_entity_type" string NOT NULL OPTIONS (NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/extension_attributes/entity_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_extension_attributes_wrapping_add_printed_card" boolean NOT NULL OPTIONS (NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/extension_attributes/wrapping_add_printed_card', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_extension_attributes_wrapping_allow_gift_receipt" boolean NOT NULL OPTIONS (NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/extension_attributes/wrapping_allow_gift_receipt', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_extension_attributes_wrapping_id" string NOT NULL OPTIONS (NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/extension_attributes/wrapping_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_gift_message_id" string NOT NULL OPTIONS (ANNOTATION 'Gift message ID. Otherwise, null.', NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/gift_message_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_message" string NOT NULL OPTIONS (ANNOTATION 'Message text.', NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_recipient" string NOT NULL OPTIONS (ANNOTATION 'Recipient name.', NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/recipient', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_sender" string NOT NULL OPTIONS (ANNOTATION 'Sender name.', NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/sender', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_additional_data string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_extension_attributes_agreement_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/extension_attributes/agreement_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_method string NOT NULL OPTIONS (ANNOTATION 'Payment method code', NAMEINSOURCE 'paymentMethod/method', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_po_number string NOT NULL OPTIONS (ANNOTATION 'Purchase order number', NAMEINSOURCE 'paymentMethod/po_number', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN shippingCarrierCode string NOT NULL OPTIONS (ANNOTATION 'The carrier code.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN shippingMethodCode string NOT NULL OPTIONS (ANNOTATION 'The shipping method code.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (base_currency_code string, base_discount_amount string, base_grand_total string, base_shipping_amount string, base_shipping_discount_amount string, base_shipping_incl_tax string, base_shipping_tax_amount string, base_subtotal string, base_subtotal_incl_tax string, base_subtotal_with_discount string, base_tax_amount string, coupon_code string, discount_amount string, extension_attributes_base_customer_balance_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/base_customer_balance_amount'), extension_attributes_base_reward_currency_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/base_reward_currency_amount'), extension_attributes_customer_balance_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/customer_balance_amount'), extension_attributes_reward_currency_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/reward_currency_amount'), extension_attributes_reward_points_balance string OPTIONS (NAMEINSOURCE 'extension_attributes/reward_points_balance'), grand_total string, "items_quote-data-totals-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_discount_amount'), "items_quote-data-totals-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_price'), "items_quote-data-totals-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_price_incl_tax'), "items_quote-data-totals-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_row_total'), "items_quote-data-totals-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_row_total_incl_tax'), "items_quote-data-totals-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_tax_amount'), "items_quote-data-totals-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/discount_amount'), "items_quote-data-totals-item-interface_discount_percent" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/discount_percent'), "items_quote-data-totals-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/item_id'), "items_quote-data-totals-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/name'), "items_quote-data-totals-item-interface_options" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/options'), "items_quote-data-totals-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/price'), "items_quote-data-totals-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/price_incl_tax'), "items_quote-data-totals-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/qty'), "items_quote-data-totals-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total'), "items_quote-data-totals-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total_incl_tax'), "items_quote-data-totals-item-interface_row_total_with_discount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total_with_discount'), "items_quote-data-totals-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/tax_amount'), "items_quote-data-totals-item-interface_tax_percent" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/tax_percent'), "items_quote-data-totals-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/weee_tax_applied'), "items_quote-data-totals-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/weee_tax_applied_amount'), items_qty string, quote_currency_code string, shipping_amount string, shipping_discount_amount string, shipping_incl_tax string, shipping_tax_amount string, subtotal string, subtotal_incl_tax string, subtotal_with_discount string, tax_amount string, "total_segments_quote-data-total-segment-interface_area" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/area'), "total_segments_quote-data-total-segment-interface_code" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/code'), "total_segments_quote-data-total-segment-interface_extension_attributes_gift_cards" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gift_cards'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_add_card" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_add_card'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_allow_gift_receipt" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_allow_gift_receipt'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_item_ids" string[] OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_item_ids'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_order_id" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_order_id'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_group_id" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/group_id'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_percent" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/percent'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_title" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/title'), "total_segments_quote-data-total-segment-interface_title" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/title'), "total_segments_quote-data-total-segment-interface_value" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/value'), weee_tax_applied_amount string)
OPTIONS (ANNOTATION 'Set shipping/billing methods and additional data for cart and collect totals.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/collect-totals');

CREATE FOREIGN PROCEDURE "V1/carts/mine/coupons_GET"(OUT "return" string RESULT) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Returns information for a coupon in a specified cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/coupons');

CREATE FOREIGN PROCEDURE "V1/carts/mine/coupons_DELETE"(OUT "return" boolean RESULT) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Deletes a coupon from a specified cart.', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/coupons');

CREATE FOREIGN PROCEDURE "V1/carts/mine/coupons/couponCode"(OUT "return" boolean RESULT, IN couponCode string NOT NULL OPTIONS (ANNOTATION 'The coupon code data.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Adds a coupon by code to a specified cart.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/coupons/{couponCode}');

CREATE FOREIGN PROCEDURE "V1/carts/mine/estimate-shipping-methods"(IN address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (amount string, available boolean, base_amount string, carrier_code string, carrier_title string, error_message string, method_code string, method_title string, price_excl_tax string, price_incl_tax string)
OPTIONS (ANNOTATION 'Estimate shipping by address and return list of available shipping methods', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/estimate-shipping-methods');

CREATE FOREIGN PROCEDURE "V1/carts/mine/estimate-shipping-methods-by-address-id"(IN addressId string NOT NULL OPTIONS (ANNOTATION 'The estimate address id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (amount string, available boolean, base_amount string, carrier_code string, carrier_title string, error_message string, method_code string, method_title string, price_excl_tax string, price_incl_tax string)
OPTIONS (ANNOTATION 'Estimate shipping', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/estimate-shipping-methods-by-address-id');

CREATE FOREIGN PROCEDURE "V1/carts/mine/gift-message_GET"() RETURNS TABLE (customer_id string, extension_attributes_entity_id string OPTIONS (NAMEINSOURCE 'extension_attributes/entity_id'), extension_attributes_entity_type string OPTIONS (NAMEINSOURCE 'extension_attributes/entity_type'), extension_attributes_wrapping_add_printed_card boolean OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_add_printed_card'), extension_attributes_wrapping_allow_gift_receipt boolean OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_allow_gift_receipt'), extension_attributes_wrapping_id string OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_id'), gift_message_id string, message string, recipient string, sender string)
OPTIONS (ANNOTATION 'Return the gift message for a specified order.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/gift-message');

CREATE FOREIGN PROCEDURE "V1/carts/mine/gift-message_POST"(OUT "return" boolean RESULT, IN giftMessage_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer ID. Otherwise, null.', NAMEINSOURCE 'giftMessage/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_entity_id string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_entity_type string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/entity_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_add_printed_card boolean NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_add_printed_card', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_allow_gift_receipt boolean NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_allow_gift_receipt', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_id string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_gift_message_id string NOT NULL OPTIONS (ANNOTATION 'Gift message ID. Otherwise, null.', NAMEINSOURCE 'giftMessage/gift_message_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_message string NOT NULL OPTIONS (ANNOTATION 'Message text.', NAMEINSOURCE 'giftMessage/message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_recipient string NOT NULL OPTIONS (ANNOTATION 'Recipient name.', NAMEINSOURCE 'giftMessage/recipient', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_sender string NOT NULL OPTIONS (ANNOTATION 'Sender name.', NAMEINSOURCE 'giftMessage/sender', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Set the gift message for an entire order.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/gift-message');

CREATE FOREIGN PROCEDURE "V1/carts/mine/gift-message/itemId_GET"(IN itemId string NOT NULL OPTIONS (ANNOTATION 'The item ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (customer_id string, extension_attributes_entity_id string OPTIONS (NAMEINSOURCE 'extension_attributes/entity_id'), extension_attributes_entity_type string OPTIONS (NAMEINSOURCE 'extension_attributes/entity_type'), extension_attributes_wrapping_add_printed_card boolean OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_add_printed_card'), extension_attributes_wrapping_allow_gift_receipt boolean OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_allow_gift_receipt'), extension_attributes_wrapping_id string OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_id'), gift_message_id string, message string, recipient string, sender string)
OPTIONS (ANNOTATION 'Return the gift message for a specified item in a specified shopping cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/gift-message/{itemId}');

CREATE FOREIGN PROCEDURE "V1/carts/mine/gift-message/itemId_POST"(OUT "return" boolean RESULT, IN itemId string NOT NULL OPTIONS (ANNOTATION 'The item ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN giftMessage_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer ID. Otherwise, null.', NAMEINSOURCE 'giftMessage/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_entity_id string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_entity_type string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/entity_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_add_printed_card boolean NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_add_printed_card', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_allow_gift_receipt boolean NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_allow_gift_receipt', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_id string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_gift_message_id string NOT NULL OPTIONS (ANNOTATION 'Gift message ID. Otherwise, null.', NAMEINSOURCE 'giftMessage/gift_message_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_message string NOT NULL OPTIONS (ANNOTATION 'Message text.', NAMEINSOURCE 'giftMessage/message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_recipient string NOT NULL OPTIONS (ANNOTATION 'Recipient name.', NAMEINSOURCE 'giftMessage/recipient', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_sender string NOT NULL OPTIONS (ANNOTATION 'Sender name.', NAMEINSOURCE 'giftMessage/sender', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Set the gift message for a specified item in a specified shopping cart.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/gift-message/{itemId}');

CREATE FOREIGN PROCEDURE giftCardAccountGiftCardAccountManagementV1SaveByQuoteIdPost(OUT "return" boolean RESULT, IN giftCardAccountData_base_gift_cards_amount string NOT NULL OPTIONS (ANNOTATION 'Cards amount in base currency', NAMEINSOURCE 'giftCardAccountData/base_gift_cards_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftCardAccountData_base_gift_cards_amount_used string NOT NULL OPTIONS (ANNOTATION 'Cards amount used in base currency', NAMEINSOURCE 'giftCardAccountData/base_gift_cards_amount_used', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftCardAccountData_gift_cards string[] NOT NULL OPTIONS (NAMEINSOURCE 'giftCardAccountData/gift_cards', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftCardAccountData_gift_cards_amount string NOT NULL OPTIONS (ANNOTATION 'Cards amount in quote currency', NAMEINSOURCE 'giftCardAccountData/gift_cards_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftCardAccountData_gift_cards_amount_used string NOT NULL OPTIONS (ANNOTATION 'Cards amount used in quote currency', NAMEINSOURCE 'giftCardAccountData/gift_cards_amount_used', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS ("teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/giftCards');

CREATE FOREIGN PROCEDURE "V1/carts/mine/giftCards/giftCardCode"(OUT "return" boolean RESULT, IN giftCardCode string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Remove GiftCard Account entity', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/giftCards/{giftCardCode}');

CREATE FOREIGN PROCEDURE "V1/carts/mine/items_GET"() RETURNS TABLE (item_id string, name string, price string, "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), product_option_extension_attributes_downloadable_option_downloadable_links string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/downloadable_option/downloadable_links'), product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_message string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_message'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), product_type string, qty string, quote_id string, sku string)
OPTIONS (ANNOTATION 'Lists items that are assigned to a specified cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/items');

CREATE FOREIGN PROCEDURE "V1/carts/mine/items_POST"(IN cartItem_item_id string NOT NULL OPTIONS (ANNOTATION 'Item ID. Otherwise, null.', NAMEINSOURCE 'cartItem/item_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_name string NOT NULL OPTIONS (ANNOTATION 'Product name. Otherwise, null.', NAMEINSOURCE 'cartItem/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_price string NOT NULL OPTIONS (ANNOTATION 'Product price. Otherwise, null.', NAMEINSOURCE 'cartItem/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Bundle option id.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string NOT NULL OPTIONS (ANNOTATION 'Bundle option quantity.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] NOT NULL OPTIONS (NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option SKU', NAMEINSOURCE 'cartItem/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Item id', NAMEINSOURCE 'cartItem/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string NOT NULL OPTIONS (ANNOTATION 'Media data (base64 encoded content)', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string NOT NULL OPTIONS (ANNOTATION 'Image name', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string NOT NULL OPTIONS (ANNOTATION 'MIME type', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Option value', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_downloadable_option_downloadable_links string[] NOT NULL OPTIONS (NAMEINSOURCE 'cartItem/product_option/extension_attributes/downloadable_option/downloadable_links', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string NOT NULL OPTIONS (ANNOTATION 'Gift card open amount value.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_amount string NOT NULL OPTIONS (ANNOTATION 'Gift card amount.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_message string NOT NULL OPTIONS (ANNOTATION 'Giftcard message.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient email.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient name.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string NOT NULL OPTIONS (ANNOTATION 'Gift card sender email.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string NOT NULL OPTIONS (ANNOTATION 'Gift card sender name.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_type string NOT NULL OPTIONS (ANNOTATION 'Product type. Otherwise, null.', NAMEINSOURCE 'cartItem/product_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_qty string NOT NULL OPTIONS (ANNOTATION 'Product quantity.', NAMEINSOURCE 'cartItem/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_quote_id string NOT NULL OPTIONS (ANNOTATION 'Quote id.', NAMEINSOURCE 'cartItem/quote_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_sku string NOT NULL OPTIONS (ANNOTATION 'Product SKU. Otherwise, null.', NAMEINSOURCE 'cartItem/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (item_id string, name string, price string, "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), product_option_extension_attributes_downloadable_option_downloadable_links string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/downloadable_option/downloadable_links'), product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_message string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_message'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), product_type string, qty string, quote_id string, sku string)
OPTIONS (ANNOTATION 'Add/update the specified cart item.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/items');

CREATE FOREIGN PROCEDURE "V1/carts/mine/items/itemId_PUT"(IN itemId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN cartItem_item_id string NOT NULL OPTIONS (ANNOTATION 'Item ID. Otherwise, null.', NAMEINSOURCE 'cartItem/item_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_name string NOT NULL OPTIONS (ANNOTATION 'Product name. Otherwise, null.', NAMEINSOURCE 'cartItem/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_price string NOT NULL OPTIONS (ANNOTATION 'Product price. Otherwise, null.', NAMEINSOURCE 'cartItem/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Bundle option id.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string NOT NULL OPTIONS (ANNOTATION 'Bundle option quantity.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] NOT NULL OPTIONS (NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option SKU', NAMEINSOURCE 'cartItem/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Item id', NAMEINSOURCE 'cartItem/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string NOT NULL OPTIONS (ANNOTATION 'Media data (base64 encoded content)', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string NOT NULL OPTIONS (ANNOTATION 'Image name', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string NOT NULL OPTIONS (ANNOTATION 'MIME type', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Option value', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_downloadable_option_downloadable_links string[] NOT NULL OPTIONS (NAMEINSOURCE 'cartItem/product_option/extension_attributes/downloadable_option/downloadable_links', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string NOT NULL OPTIONS (ANNOTATION 'Gift card open amount value.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_amount string NOT NULL OPTIONS (ANNOTATION 'Gift card amount.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_message string NOT NULL OPTIONS (ANNOTATION 'Giftcard message.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient email.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient name.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string NOT NULL OPTIONS (ANNOTATION 'Gift card sender email.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string NOT NULL OPTIONS (ANNOTATION 'Gift card sender name.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_type string NOT NULL OPTIONS (ANNOTATION 'Product type. Otherwise, null.', NAMEINSOURCE 'cartItem/product_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_qty string NOT NULL OPTIONS (ANNOTATION 'Product quantity.', NAMEINSOURCE 'cartItem/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_quote_id string NOT NULL OPTIONS (ANNOTATION 'Quote id.', NAMEINSOURCE 'cartItem/quote_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_sku string NOT NULL OPTIONS (ANNOTATION 'Product SKU. Otherwise, null.', NAMEINSOURCE 'cartItem/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (item_id string, name string, price string, "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), product_option_extension_attributes_downloadable_option_downloadable_links string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/downloadable_option/downloadable_links'), product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_message string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_message'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), product_type string, qty string, quote_id string, sku string)
OPTIONS (ANNOTATION 'Add/update the specified cart item.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/items/{itemId}');

CREATE FOREIGN PROCEDURE "V1/carts/mine/items/itemId_DELETE"(OUT "return" boolean RESULT, IN itemId string NOT NULL OPTIONS (ANNOTATION 'The item ID of the item to be removed.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Removes the specified item from the specified cart.', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/items/{itemId}');

CREATE FOREIGN PROCEDURE "V1/carts/mine/order"(OUT "return" string RESULT, IN paymentMethod_additional_data string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_extension_attributes_agreement_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/extension_attributes/agreement_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_method string NOT NULL OPTIONS (ANNOTATION 'Payment method code', NAMEINSOURCE 'paymentMethod/method', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_po_number string NOT NULL OPTIONS (ANNOTATION 'Purchase order number', NAMEINSOURCE 'paymentMethod/po_number', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Places an order for a specified cart.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/order');

CREATE FOREIGN PROCEDURE checkoutPaymentInformationManagementV1GetPaymentInformationGet() RETURNS TABLE ("payment_methods_quote-data-payment-method-interface_code" string OPTIONS (NAMEINSOURCE 'payment_methods[]/quote-data-payment-method-interface/code'), "payment_methods_quote-data-payment-method-interface_title" string OPTIONS (NAMEINSOURCE 'payment_methods[]/quote-data-payment-method-interface/title'), totals_base_currency_code string OPTIONS (NAMEINSOURCE 'totals/base_currency_code'), totals_base_discount_amount string OPTIONS (NAMEINSOURCE 'totals/base_discount_amount'), totals_base_grand_total string OPTIONS (NAMEINSOURCE 'totals/base_grand_total'), totals_base_shipping_amount string OPTIONS (NAMEINSOURCE 'totals/base_shipping_amount'), totals_base_shipping_discount_amount string OPTIONS (NAMEINSOURCE 'totals/base_shipping_discount_amount'), totals_base_shipping_incl_tax string OPTIONS (NAMEINSOURCE 'totals/base_shipping_incl_tax'), totals_base_shipping_tax_amount string OPTIONS (NAMEINSOURCE 'totals/base_shipping_tax_amount'), totals_base_subtotal string OPTIONS (NAMEINSOURCE 'totals/base_subtotal'), totals_base_subtotal_incl_tax string OPTIONS (NAMEINSOURCE 'totals/base_subtotal_incl_tax'), totals_base_subtotal_with_discount string OPTIONS (NAMEINSOURCE 'totals/base_subtotal_with_discount'), totals_base_tax_amount string OPTIONS (NAMEINSOURCE 'totals/base_tax_amount'), totals_coupon_code string OPTIONS (NAMEINSOURCE 'totals/coupon_code'), totals_discount_amount string OPTIONS (NAMEINSOURCE 'totals/discount_amount'), totals_extension_attributes_base_customer_balance_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/base_customer_balance_amount'), totals_extension_attributes_base_reward_currency_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/base_reward_currency_amount'), totals_extension_attributes_customer_balance_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/customer_balance_amount'), totals_extension_attributes_reward_currency_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/reward_currency_amount'), totals_extension_attributes_reward_points_balance string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/reward_points_balance'), totals_grand_total string OPTIONS (NAMEINSOURCE 'totals/grand_total'), "totals_items_quote-data-totals-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_discount_amount'), "totals_items_quote-data-totals-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_price'), "totals_items_quote-data-totals-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_price_incl_tax'), "totals_items_quote-data-totals-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_row_total'), "totals_items_quote-data-totals-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_row_total_incl_tax'), "totals_items_quote-data-totals-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_tax_amount'), "totals_items_quote-data-totals-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/discount_amount'), "totals_items_quote-data-totals-item-interface_discount_percent" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/discount_percent'), "totals_items_quote-data-totals-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/item_id'), "totals_items_quote-data-totals-item-interface_name" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/name'), "totals_items_quote-data-totals-item-interface_options" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/options'), "totals_items_quote-data-totals-item-interface_price" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/price'), "totals_items_quote-data-totals-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/price_incl_tax'), "totals_items_quote-data-totals-item-interface_qty" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/qty'), "totals_items_quote-data-totals-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/row_total'), "totals_items_quote-data-totals-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/row_total_incl_tax'), "totals_items_quote-data-totals-item-interface_row_total_with_discount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/row_total_with_discount'), "totals_items_quote-data-totals-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/tax_amount'), "totals_items_quote-data-totals-item-interface_tax_percent" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/tax_percent'), "totals_items_quote-data-totals-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/weee_tax_applied'), "totals_items_quote-data-totals-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/weee_tax_applied_amount'), totals_items_qty string OPTIONS (NAMEINSOURCE 'totals/items_qty'), totals_quote_currency_code string OPTIONS (NAMEINSOURCE 'totals/quote_currency_code'), totals_shipping_amount string OPTIONS (NAMEINSOURCE 'totals/shipping_amount'), totals_shipping_discount_amount string OPTIONS (NAMEINSOURCE 'totals/shipping_discount_amount'), totals_shipping_incl_tax string OPTIONS (NAMEINSOURCE 'totals/shipping_incl_tax'), totals_shipping_tax_amount string OPTIONS (NAMEINSOURCE 'totals/shipping_tax_amount'), totals_subtotal string OPTIONS (NAMEINSOURCE 'totals/subtotal'), totals_subtotal_incl_tax string OPTIONS (NAMEINSOURCE 'totals/subtotal_incl_tax'), totals_subtotal_with_discount string OPTIONS (NAMEINSOURCE 'totals/subtotal_with_discount'), totals_tax_amount string OPTIONS (NAMEINSOURCE 'totals/tax_amount'), "totals_total_segments_quote-data-total-segment-interface_area" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/area'), "totals_total_segments_quote-data-total-segment-interface_code" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/code'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gift_cards" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gift_cards'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_add_card" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_add_card'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_allow_gift_receipt" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_allow_gift_receipt'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_item_ids" string[] OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_item_ids'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_order_id" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_order_id'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_group_id" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/group_id'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_percent" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/percent'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_title" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/title'), "totals_total_segments_quote-data-total-segment-interface_title" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/title'), "totals_total_segments_quote-data-total-segment-interface_value" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/value'), totals_weee_tax_applied_amount string OPTIONS (NAMEINSOURCE 'totals/weee_tax_applied_amount'))
OPTIONS (ANNOTATION 'Get payment information', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/payment-information');

CREATE FOREIGN PROCEDURE checkoutPaymentInformationManagementV1SavePaymentInformationAndPlaceOrderPost(OUT "return" string RESULT, IN billingAddress_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'billingAddress/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'billingAddress/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'billingAddress/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "billingAddress_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'billingAddress/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "billingAddress_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'billingAddress/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'billingAddress/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'billingAddress/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'billingAddress/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'billingAddress/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'billingAddress/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'billingAddress/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'billingAddress/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'billingAddress/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'billingAddress/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'billingAddress/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'billingAddress/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'billingAddress/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'billingAddress/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'billingAddress/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'billingAddress/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'billingAddress/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'billingAddress/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'billingAddress/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'billingAddress/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'billingAddress/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_additional_data string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_extension_attributes_agreement_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/extension_attributes/agreement_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_method string NOT NULL OPTIONS (ANNOTATION 'Payment method code', NAMEINSOURCE 'paymentMethod/method', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_po_number string NOT NULL OPTIONS (ANNOTATION 'Purchase order number', NAMEINSOURCE 'paymentMethod/po_number', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Set payment information and place order for a specified cart.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/payment-information');

CREATE FOREIGN PROCEDURE "V1/carts/mine/payment-methods"() RETURNS TABLE (code string, title string)
OPTIONS (ANNOTATION 'Lists available payment methods for a specified shopping cart. This call returns an array of objects, but detailed information about each object’s attributes might not be included.  See http://devdocs.magento.com/codelinks/attributes.html#PaymentMethodManagementInterface to determine which call to use to get detailed information about all attributes for an object.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/payment-methods');

CREATE FOREIGN PROCEDURE "V1/carts/mine/selected-payment-method_GET"() RETURNS TABLE (additional_data string[], extension_attributes_agreement_ids string[] OPTIONS (NAMEINSOURCE 'extension_attributes/agreement_ids'), "method" string, po_number string)
OPTIONS (ANNOTATION 'Returns the payment method for a specified shopping cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/selected-payment-method');

CREATE FOREIGN PROCEDURE "V1/carts/mine/selected-payment-method_PUT"(OUT "return" string RESULT, IN method_additional_data string[] NOT NULL OPTIONS (NAMEINSOURCE 'method/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN method_extension_attributes_agreement_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'method/extension_attributes/agreement_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN method_method string NOT NULL OPTIONS (ANNOTATION 'Payment method code', NAMEINSOURCE 'method/method', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN method_po_number string NOT NULL OPTIONS (ANNOTATION 'Purchase order number', NAMEINSOURCE 'method/po_number', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Adds a specified payment method to a specified shopping cart.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/selected-payment-method');

CREATE FOREIGN PROCEDURE checkoutPaymentInformationManagementV1SavePaymentInformationPost(OUT "return" string RESULT, IN billingAddress_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'billingAddress/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'billingAddress/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'billingAddress/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "billingAddress_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'billingAddress/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "billingAddress_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'billingAddress/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'billingAddress/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'billingAddress/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'billingAddress/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'billingAddress/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'billingAddress/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'billingAddress/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'billingAddress/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'billingAddress/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'billingAddress/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'billingAddress/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'billingAddress/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'billingAddress/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'billingAddress/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'billingAddress/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'billingAddress/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'billingAddress/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'billingAddress/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'billingAddress/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'billingAddress/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'billingAddress/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_additional_data string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_extension_attributes_agreement_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/extension_attributes/agreement_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_method string NOT NULL OPTIONS (ANNOTATION 'Payment method code', NAMEINSOURCE 'paymentMethod/method', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_po_number string NOT NULL OPTIONS (ANNOTATION 'Purchase order number', NAMEINSOURCE 'paymentMethod/po_number', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Set payment information for a specified cart.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/set-payment-information');

CREATE FOREIGN PROCEDURE "V1/carts/mine/shipping-information"(IN addressInformation_billing_address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'addressInformation/billing_address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'addressInformation/billing_address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'addressInformation/billing_address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_billing_address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'addressInformation/billing_address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_billing_address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'addressInformation/billing_address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'addressInformation/billing_address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'addressInformation/billing_address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'addressInformation/billing_address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/billing_address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'addressInformation/billing_address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'addressInformation/billing_address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'addressInformation/billing_address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'addressInformation/billing_address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'addressInformation/billing_address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'addressInformation/billing_address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'addressInformation/billing_address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'addressInformation/billing_address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'addressInformation/billing_address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'addressInformation/billing_address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'addressInformation/billing_address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'addressInformation/billing_address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/billing_address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'addressInformation/billing_address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'addressInformation/billing_address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'addressInformation/billing_address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'addressInformation/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'addressInformation/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'addressInformation/shipping_address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'addressInformation/shipping_address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'addressInformation/shipping_address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_shipping_address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'addressInformation/shipping_address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_shipping_address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'addressInformation/shipping_address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'addressInformation/shipping_address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'addressInformation/shipping_address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'addressInformation/shipping_address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/shipping_address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'addressInformation/shipping_address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'addressInformation/shipping_address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'addressInformation/shipping_address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'addressInformation/shipping_address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'addressInformation/shipping_address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'addressInformation/shipping_address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'addressInformation/shipping_address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'addressInformation/shipping_address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'addressInformation/shipping_address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'addressInformation/shipping_address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'addressInformation/shipping_address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'addressInformation/shipping_address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/shipping_address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'addressInformation/shipping_address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'addressInformation/shipping_address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'addressInformation/shipping_address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_carrier_code string NOT NULL OPTIONS (ANNOTATION 'Carrier code', NAMEINSOURCE 'addressInformation/shipping_carrier_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_method_code string NOT NULL OPTIONS (ANNOTATION 'Shipping method code', NAMEINSOURCE 'addressInformation/shipping_method_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE ("payment_methods_quote-data-payment-method-interface_code" string OPTIONS (NAMEINSOURCE 'payment_methods[]/quote-data-payment-method-interface/code'), "payment_methods_quote-data-payment-method-interface_title" string OPTIONS (NAMEINSOURCE 'payment_methods[]/quote-data-payment-method-interface/title'), totals_base_currency_code string OPTIONS (NAMEINSOURCE 'totals/base_currency_code'), totals_base_discount_amount string OPTIONS (NAMEINSOURCE 'totals/base_discount_amount'), totals_base_grand_total string OPTIONS (NAMEINSOURCE 'totals/base_grand_total'), totals_base_shipping_amount string OPTIONS (NAMEINSOURCE 'totals/base_shipping_amount'), totals_base_shipping_discount_amount string OPTIONS (NAMEINSOURCE 'totals/base_shipping_discount_amount'), totals_base_shipping_incl_tax string OPTIONS (NAMEINSOURCE 'totals/base_shipping_incl_tax'), totals_base_shipping_tax_amount string OPTIONS (NAMEINSOURCE 'totals/base_shipping_tax_amount'), totals_base_subtotal string OPTIONS (NAMEINSOURCE 'totals/base_subtotal'), totals_base_subtotal_incl_tax string OPTIONS (NAMEINSOURCE 'totals/base_subtotal_incl_tax'), totals_base_subtotal_with_discount string OPTIONS (NAMEINSOURCE 'totals/base_subtotal_with_discount'), totals_base_tax_amount string OPTIONS (NAMEINSOURCE 'totals/base_tax_amount'), totals_coupon_code string OPTIONS (NAMEINSOURCE 'totals/coupon_code'), totals_discount_amount string OPTIONS (NAMEINSOURCE 'totals/discount_amount'), totals_extension_attributes_base_customer_balance_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/base_customer_balance_amount'), totals_extension_attributes_base_reward_currency_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/base_reward_currency_amount'), totals_extension_attributes_customer_balance_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/customer_balance_amount'), totals_extension_attributes_reward_currency_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/reward_currency_amount'), totals_extension_attributes_reward_points_balance string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/reward_points_balance'), totals_grand_total string OPTIONS (NAMEINSOURCE 'totals/grand_total'), "totals_items_quote-data-totals-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_discount_amount'), "totals_items_quote-data-totals-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_price'), "totals_items_quote-data-totals-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_price_incl_tax'), "totals_items_quote-data-totals-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_row_total'), "totals_items_quote-data-totals-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_row_total_incl_tax'), "totals_items_quote-data-totals-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_tax_amount'), "totals_items_quote-data-totals-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/discount_amount'), "totals_items_quote-data-totals-item-interface_discount_percent" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/discount_percent'), "totals_items_quote-data-totals-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/item_id'), "totals_items_quote-data-totals-item-interface_name" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/name'), "totals_items_quote-data-totals-item-interface_options" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/options'), "totals_items_quote-data-totals-item-interface_price" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/price'), "totals_items_quote-data-totals-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/price_incl_tax'), "totals_items_quote-data-totals-item-interface_qty" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/qty'), "totals_items_quote-data-totals-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/row_total'), "totals_items_quote-data-totals-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/row_total_incl_tax'), "totals_items_quote-data-totals-item-interface_row_total_with_discount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/row_total_with_discount'), "totals_items_quote-data-totals-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/tax_amount'), "totals_items_quote-data-totals-item-interface_tax_percent" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/tax_percent'), "totals_items_quote-data-totals-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/weee_tax_applied'), "totals_items_quote-data-totals-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/weee_tax_applied_amount'), totals_items_qty string OPTIONS (NAMEINSOURCE 'totals/items_qty'), totals_quote_currency_code string OPTIONS (NAMEINSOURCE 'totals/quote_currency_code'), totals_shipping_amount string OPTIONS (NAMEINSOURCE 'totals/shipping_amount'), totals_shipping_discount_amount string OPTIONS (NAMEINSOURCE 'totals/shipping_discount_amount'), totals_shipping_incl_tax string OPTIONS (NAMEINSOURCE 'totals/shipping_incl_tax'), totals_shipping_tax_amount string OPTIONS (NAMEINSOURCE 'totals/shipping_tax_amount'), totals_subtotal string OPTIONS (NAMEINSOURCE 'totals/subtotal'), totals_subtotal_incl_tax string OPTIONS (NAMEINSOURCE 'totals/subtotal_incl_tax'), totals_subtotal_with_discount string OPTIONS (NAMEINSOURCE 'totals/subtotal_with_discount'), totals_tax_amount string OPTIONS (NAMEINSOURCE 'totals/tax_amount'), "totals_total_segments_quote-data-total-segment-interface_area" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/area'), "totals_total_segments_quote-data-total-segment-interface_code" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/code'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gift_cards" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gift_cards'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_add_card" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_add_card'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_allow_gift_receipt" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_allow_gift_receipt'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_item_ids" string[] OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_item_ids'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_order_id" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_order_id'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_group_id" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/group_id'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_percent" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/percent'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_title" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/title'), "totals_total_segments_quote-data-total-segment-interface_title" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/title'), "totals_total_segments_quote-data-total-segment-interface_value" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/value'), totals_weee_tax_applied_amount string OPTIONS (NAMEINSOURCE 'totals/weee_tax_applied_amount'))
OPTIONS ("teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/shipping-information');

CREATE FOREIGN PROCEDURE "V1/carts/mine/shipping-methods"() RETURNS TABLE (amount string, available boolean, base_amount string, carrier_code string, carrier_title string, error_message string, method_code string, method_title string, price_excl_tax string, price_incl_tax string)
OPTIONS (ANNOTATION 'Lists applicable shipping methods for a specified quote.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/shipping-methods');

CREATE FOREIGN PROCEDURE "V1/carts/mine/totals"() RETURNS TABLE (base_currency_code string, base_discount_amount string, base_grand_total string, base_shipping_amount string, base_shipping_discount_amount string, base_shipping_incl_tax string, base_shipping_tax_amount string, base_subtotal string, base_subtotal_incl_tax string, base_subtotal_with_discount string, base_tax_amount string, coupon_code string, discount_amount string, extension_attributes_base_customer_balance_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/base_customer_balance_amount'), extension_attributes_base_reward_currency_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/base_reward_currency_amount'), extension_attributes_customer_balance_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/customer_balance_amount'), extension_attributes_reward_currency_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/reward_currency_amount'), extension_attributes_reward_points_balance string OPTIONS (NAMEINSOURCE 'extension_attributes/reward_points_balance'), grand_total string, "items_quote-data-totals-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_discount_amount'), "items_quote-data-totals-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_price'), "items_quote-data-totals-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_price_incl_tax'), "items_quote-data-totals-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_row_total'), "items_quote-data-totals-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_row_total_incl_tax'), "items_quote-data-totals-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_tax_amount'), "items_quote-data-totals-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/discount_amount'), "items_quote-data-totals-item-interface_discount_percent" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/discount_percent'), "items_quote-data-totals-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/item_id'), "items_quote-data-totals-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/name'), "items_quote-data-totals-item-interface_options" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/options'), "items_quote-data-totals-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/price'), "items_quote-data-totals-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/price_incl_tax'), "items_quote-data-totals-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/qty'), "items_quote-data-totals-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total'), "items_quote-data-totals-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total_incl_tax'), "items_quote-data-totals-item-interface_row_total_with_discount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total_with_discount'), "items_quote-data-totals-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/tax_amount'), "items_quote-data-totals-item-interface_tax_percent" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/tax_percent'), "items_quote-data-totals-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/weee_tax_applied'), "items_quote-data-totals-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/weee_tax_applied_amount'), items_qty string, quote_currency_code string, shipping_amount string, shipping_discount_amount string, shipping_incl_tax string, shipping_tax_amount string, subtotal string, subtotal_incl_tax string, subtotal_with_discount string, tax_amount string, "total_segments_quote-data-total-segment-interface_area" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/area'), "total_segments_quote-data-total-segment-interface_code" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/code'), "total_segments_quote-data-total-segment-interface_extension_attributes_gift_cards" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gift_cards'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_add_card" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_add_card'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_allow_gift_receipt" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_allow_gift_receipt'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_item_ids" string[] OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_item_ids'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_order_id" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_order_id'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_group_id" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/group_id'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_percent" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/percent'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_title" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/title'), "total_segments_quote-data-total-segment-interface_title" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/title'), "total_segments_quote-data-total-segment-interface_value" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/value'), weee_tax_applied_amount string)
OPTIONS (ANNOTATION 'Returns quote totals data for a specified cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/totals');

CREATE FOREIGN PROCEDURE "V1/carts/mine/totals-information"(IN addressInformation_address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'addressInformation/address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'addressInformation/address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'addressInformation/address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'addressInformation/address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'addressInformation/address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'addressInformation/address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'addressInformation/address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'addressInformation/address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'addressInformation/address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'addressInformation/address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'addressInformation/address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'addressInformation/address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'addressInformation/address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'addressInformation/address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'addressInformation/address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'addressInformation/address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'addressInformation/address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'addressInformation/address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'addressInformation/address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'addressInformation/address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'addressInformation/address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'addressInformation/address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'addressInformation/address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'addressInformation/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'addressInformation/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_carrier_code string NOT NULL OPTIONS (ANNOTATION 'Carrier code', NAMEINSOURCE 'addressInformation/shipping_carrier_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_method_code string NOT NULL OPTIONS (ANNOTATION 'Shipping method code', NAMEINSOURCE 'addressInformation/shipping_method_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (base_currency_code string, base_discount_amount string, base_grand_total string, base_shipping_amount string, base_shipping_discount_amount string, base_shipping_incl_tax string, base_shipping_tax_amount string, base_subtotal string, base_subtotal_incl_tax string, base_subtotal_with_discount string, base_tax_amount string, coupon_code string, discount_amount string, extension_attributes_base_customer_balance_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/base_customer_balance_amount'), extension_attributes_base_reward_currency_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/base_reward_currency_amount'), extension_attributes_customer_balance_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/customer_balance_amount'), extension_attributes_reward_currency_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/reward_currency_amount'), extension_attributes_reward_points_balance string OPTIONS (NAMEINSOURCE 'extension_attributes/reward_points_balance'), grand_total string, "items_quote-data-totals-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_discount_amount'), "items_quote-data-totals-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_price'), "items_quote-data-totals-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_price_incl_tax'), "items_quote-data-totals-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_row_total'), "items_quote-data-totals-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_row_total_incl_tax'), "items_quote-data-totals-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_tax_amount'), "items_quote-data-totals-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/discount_amount'), "items_quote-data-totals-item-interface_discount_percent" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/discount_percent'), "items_quote-data-totals-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/item_id'), "items_quote-data-totals-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/name'), "items_quote-data-totals-item-interface_options" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/options'), "items_quote-data-totals-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/price'), "items_quote-data-totals-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/price_incl_tax'), "items_quote-data-totals-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/qty'), "items_quote-data-totals-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total'), "items_quote-data-totals-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total_incl_tax'), "items_quote-data-totals-item-interface_row_total_with_discount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total_with_discount'), "items_quote-data-totals-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/tax_amount'), "items_quote-data-totals-item-interface_tax_percent" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/tax_percent'), "items_quote-data-totals-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/weee_tax_applied'), "items_quote-data-totals-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/weee_tax_applied_amount'), items_qty string, quote_currency_code string, shipping_amount string, shipping_discount_amount string, shipping_incl_tax string, shipping_tax_amount string, subtotal string, subtotal_incl_tax string, subtotal_with_discount string, tax_amount string, "total_segments_quote-data-total-segment-interface_area" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/area'), "total_segments_quote-data-total-segment-interface_code" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/code'), "total_segments_quote-data-total-segment-interface_extension_attributes_gift_cards" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gift_cards'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_add_card" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_add_card'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_allow_gift_receipt" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_allow_gift_receipt'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_item_ids" string[] OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_item_ids'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_order_id" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_order_id'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_group_id" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/group_id'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_percent" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/percent'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_title" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/title'), "total_segments_quote-data-total-segment-interface_title" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/title'), "total_segments_quote-data-total-segment-interface_value" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/value'), weee_tax_applied_amount string)
OPTIONS (ANNOTATION 'Calculate quote totals based on address and shipping method.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/mine/totals-information');

CREATE FOREIGN PROCEDURE quoteCartRepositoryV1GetListGet(IN "searchCriteria[filterGroups][][filters][][field]" string NOT NULL OPTIONS (ANNOTATION 'Field', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][value]" string NOT NULL OPTIONS (ANNOTATION 'Value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][conditionType]" string NOT NULL OPTIONS (ANNOTATION 'Condition type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][field]" string NOT NULL OPTIONS (ANNOTATION 'Sorting field.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][direction]" string NOT NULL OPTIONS (ANNOTATION 'Sorting direction.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[pageSize]" string NOT NULL OPTIONS (ANNOTATION 'Page size.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[currentPage]" string NOT NULL OPTIONS (ANNOTATION 'Current page.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE ("items_quote-data-cart-interface_billing_address_city" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/city'), "items_quote-data-cart-interface_billing_address_company" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/company'), "items_quote-data-cart-interface_billing_address_country_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/country_id'), "items_quote-data-cart-interface_billing_address_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/custom_attributes[]/framework-attribute-interface/attribute_code'), "items_quote-data-cart-interface_billing_address_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/custom_attributes[]/framework-attribute-interface/value'), "items_quote-data-cart-interface_billing_address_customer_address_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/customer_address_id'), "items_quote-data-cart-interface_billing_address_customer_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/customer_id'), "items_quote-data-cart-interface_billing_address_email" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/email'), "items_quote-data-cart-interface_billing_address_extension_attributes_gift_registry_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/extension_attributes/gift_registry_id'), "items_quote-data-cart-interface_billing_address_fax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/fax'), "items_quote-data-cart-interface_billing_address_firstname" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/firstname'), "items_quote-data-cart-interface_billing_address_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/id'), "items_quote-data-cart-interface_billing_address_lastname" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/lastname'), "items_quote-data-cart-interface_billing_address_middlename" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/middlename'), "items_quote-data-cart-interface_billing_address_postcode" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/postcode'), "items_quote-data-cart-interface_billing_address_prefix" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/prefix'), "items_quote-data-cart-interface_billing_address_region" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/region'), "items_quote-data-cart-interface_billing_address_region_code" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/region_code'), "items_quote-data-cart-interface_billing_address_region_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/region_id'), "items_quote-data-cart-interface_billing_address_same_as_billing" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/same_as_billing'), "items_quote-data-cart-interface_billing_address_save_in_address_book" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/save_in_address_book'), "items_quote-data-cart-interface_billing_address_street" string[] OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/street'), "items_quote-data-cart-interface_billing_address_suffix" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/suffix'), "items_quote-data-cart-interface_billing_address_telephone" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/telephone'), "items_quote-data-cart-interface_billing_address_vat_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/billing_address/vat_id'), "items_quote-data-cart-interface_converted_at" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/converted_at'), "items_quote-data-cart-interface_created_at" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/created_at'), "items_quote-data-cart-interface_currency_base_currency_code" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/currency/base_currency_code'), "items_quote-data-cart-interface_currency_base_to_global_rate" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/currency/base_to_global_rate'), "items_quote-data-cart-interface_currency_base_to_quote_rate" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/currency/base_to_quote_rate'), "items_quote-data-cart-interface_currency_global_currency_code" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/currency/global_currency_code'), "items_quote-data-cart-interface_currency_quote_currency_code" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/currency/quote_currency_code'), "items_quote-data-cart-interface_currency_store_currency_code" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/currency/store_currency_code'), "items_quote-data-cart-interface_currency_store_to_base_rate" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/currency/store_to_base_rate'), "items_quote-data-cart-interface_currency_store_to_quote_rate" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/currency/store_to_quote_rate'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_city" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/city'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_company" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/company'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_country_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/country_id'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_customer_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/customer_id'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_default_billing" boolean OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/default_billing'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_default_shipping" boolean OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/default_shipping'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_fax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/fax'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_firstname" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/firstname'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/id'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_lastname" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/lastname'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_middlename" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/middlename'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_postcode" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/postcode'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_prefix" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/prefix'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_region_region" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/region/region'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_region_region_code" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/region/region_code'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_region_region_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/region/region_id'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_region_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/region_id'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_street" string[] OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/street'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_suffix" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/suffix'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_telephone" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/telephone'), "items_quote-data-cart-interface_customer_addresses_customer-data-address-interface_vat_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/addresses[]/customer-data-address-interface/vat_id'), "items_quote-data-cart-interface_customer_confirmation" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/confirmation'), "items_quote-data-cart-interface_customer_created_at" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/created_at'), "items_quote-data-cart-interface_customer_created_in" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/created_in'), "items_quote-data-cart-interface_customer_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/custom_attributes[]/framework-attribute-interface/attribute_code'), "items_quote-data-cart-interface_customer_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/custom_attributes[]/framework-attribute-interface/value'), "items_quote-data-cart-interface_customer_default_billing" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/default_billing'), "items_quote-data-cart-interface_customer_default_shipping" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/default_shipping'), "items_quote-data-cart-interface_customer_disable_auto_group_change" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/disable_auto_group_change'), "items_quote-data-cart-interface_customer_dob" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/dob'), "items_quote-data-cart-interface_customer_email" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/email'), "items_quote-data-cart-interface_customer_extension_attributes_is_subscribed" boolean OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/extension_attributes/is_subscribed'), "items_quote-data-cart-interface_customer_firstname" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/firstname'), "items_quote-data-cart-interface_customer_gender" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/gender'), "items_quote-data-cart-interface_customer_group_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/group_id'), "items_quote-data-cart-interface_customer_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/id'), "items_quote-data-cart-interface_customer_lastname" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/lastname'), "items_quote-data-cart-interface_customer_middlename" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/middlename'), "items_quote-data-cart-interface_customer_prefix" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/prefix'), "items_quote-data-cart-interface_customer_store_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/store_id'), "items_quote-data-cart-interface_customer_suffix" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/suffix'), "items_quote-data-cart-interface_customer_taxvat" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/taxvat'), "items_quote-data-cart-interface_customer_updated_at" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/updated_at'), "items_quote-data-cart-interface_customer_website_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer/website_id'), "items_quote-data-cart-interface_customer_is_guest" boolean OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer_is_guest'), "items_quote-data-cart-interface_customer_note" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer_note'), "items_quote-data-cart-interface_customer_note_notify" boolean OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer_note_notify'), "items_quote-data-cart-interface_customer_tax_class_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/customer_tax_class_id'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/item_id'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/name'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/price'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_downloadable_option_downloadable_links" string[] OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/downloadable_option/downloadable_links'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_amount'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_message" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_message'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_type" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_type'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/qty'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_quote_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/quote_id'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_sku" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/sku'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_city" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/city'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_company" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/company'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_country_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/country_id'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/custom_attributes[]/framework-attribute-interface/attribute_code'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/custom_attributes[]/framework-attribute-interface/value'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_customer_address_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/customer_address_id'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_customer_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/customer_id'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_email" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/email'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_extension_attributes_gift_registry_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/extension_attributes/gift_registry_id'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_fax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/fax'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_firstname" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/firstname'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/id'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_lastname" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/lastname'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_middlename" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/middlename'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_postcode" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/postcode'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_prefix" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/prefix'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region_code" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region_code'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region_id'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_same_as_billing" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/same_as_billing'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_save_in_address_book" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/save_in_address_book'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_street" string[] OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/street'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_suffix" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/suffix'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_telephone" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/telephone'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_vat_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/vat_id'), "items_quote-data-cart-interface_extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_method" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/method'), "items_quote-data-cart-interface_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/id'), "items_quote-data-cart-interface_is_active" boolean OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/is_active'), "items_quote-data-cart-interface_is_virtual" boolean OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/is_virtual'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/item_id'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/name'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/price'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_downloadable_option_downloadable_links" string[] OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/downloadable_option/downloadable_links'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_amount'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_message" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_message'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_product_type" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/product_type'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/qty'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_quote_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/quote_id'), "items_quote-data-cart-interface_items_quote-data-cart-item-interface_sku" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items[]/quote-data-cart-item-interface/sku'), "items_quote-data-cart-interface_items_count" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items_count'), "items_quote-data-cart-interface_items_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/items_qty'), "items_quote-data-cart-interface_orig_order_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/orig_order_id'), "items_quote-data-cart-interface_reserved_order_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/reserved_order_id'), "items_quote-data-cart-interface_store_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/store_id'), "items_quote-data-cart-interface_updated_at" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-interface/updated_at'), search_criteria_current_page string OPTIONS (NAMEINSOURCE 'search_criteria/current_page'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_condition_type" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/condition_type'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_field" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/field'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_value" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/value'), search_criteria_page_size string OPTIONS (NAMEINSOURCE 'search_criteria/page_size'), "search_criteria_sort_orders_framework-sort-order_direction" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/direction'), "search_criteria_sort_orders_framework-sort-order_field" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/field'), total_count string)
OPTIONS (ANNOTATION 'Enables administrative users to list carts that match specified search criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included.  See http://devdocs.magento.com/codelinks/attributes.html#CartRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/search');

CREATE FOREIGN PROCEDURE quoteCartRepositoryV1GetGet(IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (billing_address_city string OPTIONS (NAMEINSOURCE 'billing_address/city'), billing_address_company string OPTIONS (NAMEINSOURCE 'billing_address/company'), billing_address_country_id string OPTIONS (NAMEINSOURCE 'billing_address/country_id'), "billing_address_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'billing_address/custom_attributes[]/framework-attribute-interface/attribute_code'), "billing_address_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'billing_address/custom_attributes[]/framework-attribute-interface/value'), billing_address_customer_address_id string OPTIONS (NAMEINSOURCE 'billing_address/customer_address_id'), billing_address_customer_id string OPTIONS (NAMEINSOURCE 'billing_address/customer_id'), billing_address_email string OPTIONS (NAMEINSOURCE 'billing_address/email'), billing_address_extension_attributes_gift_registry_id string OPTIONS (NAMEINSOURCE 'billing_address/extension_attributes/gift_registry_id'), billing_address_fax string OPTIONS (NAMEINSOURCE 'billing_address/fax'), billing_address_firstname string OPTIONS (NAMEINSOURCE 'billing_address/firstname'), billing_address_id string OPTIONS (NAMEINSOURCE 'billing_address/id'), billing_address_lastname string OPTIONS (NAMEINSOURCE 'billing_address/lastname'), billing_address_middlename string OPTIONS (NAMEINSOURCE 'billing_address/middlename'), billing_address_postcode string OPTIONS (NAMEINSOURCE 'billing_address/postcode'), billing_address_prefix string OPTIONS (NAMEINSOURCE 'billing_address/prefix'), billing_address_region string OPTIONS (NAMEINSOURCE 'billing_address/region'), billing_address_region_code string OPTIONS (NAMEINSOURCE 'billing_address/region_code'), billing_address_region_id string OPTIONS (NAMEINSOURCE 'billing_address/region_id'), billing_address_same_as_billing string OPTIONS (NAMEINSOURCE 'billing_address/same_as_billing'), billing_address_save_in_address_book string OPTIONS (NAMEINSOURCE 'billing_address/save_in_address_book'), billing_address_street string[] OPTIONS (NAMEINSOURCE 'billing_address/street'), billing_address_suffix string OPTIONS (NAMEINSOURCE 'billing_address/suffix'), billing_address_telephone string OPTIONS (NAMEINSOURCE 'billing_address/telephone'), billing_address_vat_id string OPTIONS (NAMEINSOURCE 'billing_address/vat_id'), converted_at string, created_at string, currency_base_currency_code string OPTIONS (NAMEINSOURCE 'currency/base_currency_code'), currency_base_to_global_rate string OPTIONS (NAMEINSOURCE 'currency/base_to_global_rate'), currency_base_to_quote_rate string OPTIONS (NAMEINSOURCE 'currency/base_to_quote_rate'), currency_global_currency_code string OPTIONS (NAMEINSOURCE 'currency/global_currency_code'), currency_quote_currency_code string OPTIONS (NAMEINSOURCE 'currency/quote_currency_code'), currency_store_currency_code string OPTIONS (NAMEINSOURCE 'currency/store_currency_code'), currency_store_to_base_rate string OPTIONS (NAMEINSOURCE 'currency/store_to_base_rate'), currency_store_to_quote_rate string OPTIONS (NAMEINSOURCE 'currency/store_to_quote_rate'), "customer_addresses_customer-data-address-interface_city" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/city'), "customer_addresses_customer-data-address-interface_company" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/company'), "customer_addresses_customer-data-address-interface_country_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/country_id'), "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value'), "customer_addresses_customer-data-address-interface_customer_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/customer_id'), "customer_addresses_customer-data-address-interface_default_billing" boolean OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_billing'), "customer_addresses_customer-data-address-interface_default_shipping" boolean OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_shipping'), "customer_addresses_customer-data-address-interface_fax" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/fax'), "customer_addresses_customer-data-address-interface_firstname" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/firstname'), "customer_addresses_customer-data-address-interface_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/id'), "customer_addresses_customer-data-address-interface_lastname" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/lastname'), "customer_addresses_customer-data-address-interface_middlename" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/middlename'), "customer_addresses_customer-data-address-interface_postcode" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/postcode'), "customer_addresses_customer-data-address-interface_prefix" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/prefix'), "customer_addresses_customer-data-address-interface_region_region" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region'), "customer_addresses_customer-data-address-interface_region_region_code" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_code'), "customer_addresses_customer-data-address-interface_region_region_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_id'), "customer_addresses_customer-data-address-interface_region_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region_id'), "customer_addresses_customer-data-address-interface_street" string[] OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/street'), "customer_addresses_customer-data-address-interface_suffix" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/suffix'), "customer_addresses_customer-data-address-interface_telephone" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/telephone'), "customer_addresses_customer-data-address-interface_vat_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/vat_id'), customer_confirmation string OPTIONS (NAMEINSOURCE 'customer/confirmation'), customer_created_at string OPTIONS (NAMEINSOURCE 'customer/created_at'), customer_created_in string OPTIONS (NAMEINSOURCE 'customer/created_in'), "customer_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/attribute_code'), "customer_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/value'), customer_default_billing string OPTIONS (NAMEINSOURCE 'customer/default_billing'), customer_default_shipping string OPTIONS (NAMEINSOURCE 'customer/default_shipping'), customer_disable_auto_group_change string OPTIONS (NAMEINSOURCE 'customer/disable_auto_group_change'), customer_dob string OPTIONS (NAMEINSOURCE 'customer/dob'), customer_email string OPTIONS (NAMEINSOURCE 'customer/email'), customer_extension_attributes_is_subscribed boolean OPTIONS (NAMEINSOURCE 'customer/extension_attributes/is_subscribed'), customer_firstname string OPTIONS (NAMEINSOURCE 'customer/firstname'), customer_gender string OPTIONS (NAMEINSOURCE 'customer/gender'), customer_group_id string OPTIONS (NAMEINSOURCE 'customer/group_id'), customer_id string OPTIONS (NAMEINSOURCE 'customer/id'), customer_lastname string OPTIONS (NAMEINSOURCE 'customer/lastname'), customer_middlename string OPTIONS (NAMEINSOURCE 'customer/middlename'), customer_prefix string OPTIONS (NAMEINSOURCE 'customer/prefix'), customer_store_id string OPTIONS (NAMEINSOURCE 'customer/store_id'), customer_suffix string OPTIONS (NAMEINSOURCE 'customer/suffix'), customer_taxvat string OPTIONS (NAMEINSOURCE 'customer/taxvat'), customer_updated_at string OPTIONS (NAMEINSOURCE 'customer/updated_at'), customer_website_id string OPTIONS (NAMEINSOURCE 'customer/website_id'), customer_is_guest boolean, customer_note string, customer_note_notify boolean, customer_tax_class_id string, "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/item_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/name'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_price" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/price'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_downloadable_option_downloadable_links" string[] OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/downloadable_option/downloadable_links'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_amount" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_amount'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_message" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_message'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_type'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_qty" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/qty'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_quote_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/quote_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_sku" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/sku'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_city" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/city'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_company" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/company'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_country_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/country_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/custom_attributes[]/framework-attribute-interface/attribute_code'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/custom_attributes[]/framework-attribute-interface/value'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_customer_address_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/customer_address_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_customer_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/customer_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_email" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/email'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_extension_attributes_gift_registry_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/extension_attributes/gift_registry_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_fax" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/fax'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_firstname" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/firstname'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_lastname" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/lastname'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_middlename" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/middlename'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_postcode" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/postcode'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_prefix" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/prefix'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region_code" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region_code'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_same_as_billing" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/same_as_billing'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_save_in_address_book" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/save_in_address_book'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_street" string[] OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/street'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_suffix" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/suffix'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_telephone" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/telephone'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_vat_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/vat_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_method" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/method'), id string, is_active boolean, is_virtual boolean, "items_quote-data-cart-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/item_id'), "items_quote-data-cart-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/name'), "items_quote-data-cart-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/price'), "items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), "items_quote-data-cart-item-interface_product_option_extension_attributes_downloadable_option_downloadable_links" string[] OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/downloadable_option/downloadable_links'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_amount'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_message" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_message'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), "items_quote-data-cart-item-interface_product_type" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_type'), "items_quote-data-cart-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/qty'), "items_quote-data-cart-item-interface_quote_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/quote_id'), "items_quote-data-cart-item-interface_sku" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/sku'), items_count string, items_qty string, orig_order_id string, reserved_order_id string, store_id string, updated_at string)
OPTIONS (ANNOTATION 'Enables an administrative user to return information for a specified cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}');

CREATE FOREIGN PROCEDURE quoteCartManagementV1AssignCustomerPut(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN customerId string NOT NULL OPTIONS (ANNOTATION 'The customer ID.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN storeId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Assigns a specified customer to a specified shopping cart.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/billing-address_GET"(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (city string, company string, country_id string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), customer_address_id string, customer_id string, email string, extension_attributes_gift_registry_id string OPTIONS (NAMEINSOURCE 'extension_attributes/gift_registry_id'), fax string, firstname string, id string, lastname string, middlename string, postcode string, prefix string, region string, region_code string, region_id string, same_as_billing string, save_in_address_book string, street string[], suffix string, telephone string, vat_id string)
OPTIONS (ANNOTATION 'Returns the billing address for a specified quote.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/billing-address');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/billing-address_POST"(OUT "return" string RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN useForShipping boolean NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Assigns a specified billing address to a specified cart.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/billing-address');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/coupons_GET"(OUT "return" string RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Returns information for a coupon in a specified cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/coupons');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/coupons_DELETE"(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Deletes a coupon from a specified cart.', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/coupons');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/coupons/couponCode"(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN couponCode string NOT NULL OPTIONS (ANNOTATION 'The coupon code data.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Adds a coupon by code to a specified cart.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/coupons/{couponCode}');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/estimate-shipping-methods"(IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (amount string, available boolean, base_amount string, carrier_code string, carrier_title string, error_message string, method_code string, method_title string, price_excl_tax string, price_incl_tax string)
OPTIONS (ANNOTATION 'Estimate shipping by address and return list of available shipping methods', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/estimate-shipping-methods');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/estimate-shipping-methods-by-address-id"(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The shopping cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN addressId string NOT NULL OPTIONS (ANNOTATION 'The estimate address id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (amount string, available boolean, base_amount string, carrier_code string, carrier_title string, error_message string, method_code string, method_title string, price_excl_tax string, price_incl_tax string)
OPTIONS (ANNOTATION 'Estimate shipping', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/estimate-shipping-methods-by-address-id');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/gift-message_GET"(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The shopping cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (customer_id string, extension_attributes_entity_id string OPTIONS (NAMEINSOURCE 'extension_attributes/entity_id'), extension_attributes_entity_type string OPTIONS (NAMEINSOURCE 'extension_attributes/entity_type'), extension_attributes_wrapping_add_printed_card boolean OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_add_printed_card'), extension_attributes_wrapping_allow_gift_receipt boolean OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_allow_gift_receipt'), extension_attributes_wrapping_id string OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_id'), gift_message_id string, message string, recipient string, sender string)
OPTIONS (ANNOTATION 'Return the gift message for a specified order.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/gift-message');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/gift-message_POST"(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN giftMessage_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer ID. Otherwise, null.', NAMEINSOURCE 'giftMessage/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_entity_id string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_entity_type string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/entity_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_add_printed_card boolean NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_add_printed_card', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_allow_gift_receipt boolean NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_allow_gift_receipt', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_id string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_gift_message_id string NOT NULL OPTIONS (ANNOTATION 'Gift message ID. Otherwise, null.', NAMEINSOURCE 'giftMessage/gift_message_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_message string NOT NULL OPTIONS (ANNOTATION 'Message text.', NAMEINSOURCE 'giftMessage/message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_recipient string NOT NULL OPTIONS (ANNOTATION 'Recipient name.', NAMEINSOURCE 'giftMessage/recipient', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_sender string NOT NULL OPTIONS (ANNOTATION 'Sender name.', NAMEINSOURCE 'giftMessage/sender', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Set the gift message for an entire order.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/gift-message');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/gift-message/itemId_GET"(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The shopping cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN itemId string NOT NULL OPTIONS (ANNOTATION 'The item ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (customer_id string, extension_attributes_entity_id string OPTIONS (NAMEINSOURCE 'extension_attributes/entity_id'), extension_attributes_entity_type string OPTIONS (NAMEINSOURCE 'extension_attributes/entity_type'), extension_attributes_wrapping_add_printed_card boolean OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_add_printed_card'), extension_attributes_wrapping_allow_gift_receipt boolean OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_allow_gift_receipt'), extension_attributes_wrapping_id string OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_id'), gift_message_id string, message string, recipient string, sender string)
OPTIONS (ANNOTATION 'Return the gift message for a specified item in a specified shopping cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/gift-message/{itemId}');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/gift-message/itemId_POST"(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN itemId string NOT NULL OPTIONS (ANNOTATION 'The item ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN giftMessage_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer ID. Otherwise, null.', NAMEINSOURCE 'giftMessage/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_entity_id string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_entity_type string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/entity_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_add_printed_card boolean NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_add_printed_card', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_allow_gift_receipt boolean NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_allow_gift_receipt', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_id string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_gift_message_id string NOT NULL OPTIONS (ANNOTATION 'Gift message ID. Otherwise, null.', NAMEINSOURCE 'giftMessage/gift_message_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_message string NOT NULL OPTIONS (ANNOTATION 'Message text.', NAMEINSOURCE 'giftMessage/message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_recipient string NOT NULL OPTIONS (ANNOTATION 'Recipient name.', NAMEINSOURCE 'giftMessage/recipient', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_sender string NOT NULL OPTIONS (ANNOTATION 'Sender name.', NAMEINSOURCE 'giftMessage/sender', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Set the gift message for a specified item in a specified shopping cart.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/gift-message/{itemId}');

CREATE FOREIGN PROCEDURE giftCardAccountGiftCardAccountManagementV1SaveByQuoteIdPut(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN giftCardAccountData_base_gift_cards_amount string NOT NULL OPTIONS (ANNOTATION 'Cards amount in base currency', NAMEINSOURCE 'giftCardAccountData/base_gift_cards_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftCardAccountData_base_gift_cards_amount_used string NOT NULL OPTIONS (ANNOTATION 'Cards amount used in base currency', NAMEINSOURCE 'giftCardAccountData/base_gift_cards_amount_used', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftCardAccountData_gift_cards string[] NOT NULL OPTIONS (NAMEINSOURCE 'giftCardAccountData/gift_cards', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftCardAccountData_gift_cards_amount string NOT NULL OPTIONS (ANNOTATION 'Cards amount in quote currency', NAMEINSOURCE 'giftCardAccountData/gift_cards_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftCardAccountData_gift_cards_amount_used string NOT NULL OPTIONS (ANNOTATION 'Cards amount used in quote currency', NAMEINSOURCE 'giftCardAccountData/gift_cards_amount_used', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS ("teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/giftCards');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/giftCards/giftCardCode"(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN giftCardCode string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Remove GiftCard Account entity', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/giftCards/{giftCardCode}');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/items"(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (item_id string, name string, price string, "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), product_option_extension_attributes_downloadable_option_downloadable_links string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/downloadable_option/downloadable_links'), product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_message string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_message'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), product_type string, qty string, quote_id string, sku string)
OPTIONS (ANNOTATION 'Lists items that are assigned to a specified cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/items');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/items/itemId_PUT"(IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN itemId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN cartItem_item_id string NOT NULL OPTIONS (ANNOTATION 'Item ID. Otherwise, null.', NAMEINSOURCE 'cartItem/item_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_name string NOT NULL OPTIONS (ANNOTATION 'Product name. Otherwise, null.', NAMEINSOURCE 'cartItem/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_price string NOT NULL OPTIONS (ANNOTATION 'Product price. Otherwise, null.', NAMEINSOURCE 'cartItem/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Bundle option id.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string NOT NULL OPTIONS (ANNOTATION 'Bundle option quantity.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] NOT NULL OPTIONS (NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option SKU', NAMEINSOURCE 'cartItem/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Item id', NAMEINSOURCE 'cartItem/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string NOT NULL OPTIONS (ANNOTATION 'Media data (base64 encoded content)', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string NOT NULL OPTIONS (ANNOTATION 'Image name', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string NOT NULL OPTIONS (ANNOTATION 'MIME type', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Option value', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_downloadable_option_downloadable_links string[] NOT NULL OPTIONS (NAMEINSOURCE 'cartItem/product_option/extension_attributes/downloadable_option/downloadable_links', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string NOT NULL OPTIONS (ANNOTATION 'Gift card open amount value.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_amount string NOT NULL OPTIONS (ANNOTATION 'Gift card amount.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_message string NOT NULL OPTIONS (ANNOTATION 'Giftcard message.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient email.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient name.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string NOT NULL OPTIONS (ANNOTATION 'Gift card sender email.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string NOT NULL OPTIONS (ANNOTATION 'Gift card sender name.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_type string NOT NULL OPTIONS (ANNOTATION 'Product type. Otherwise, null.', NAMEINSOURCE 'cartItem/product_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_qty string NOT NULL OPTIONS (ANNOTATION 'Product quantity.', NAMEINSOURCE 'cartItem/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_quote_id string NOT NULL OPTIONS (ANNOTATION 'Quote id.', NAMEINSOURCE 'cartItem/quote_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_sku string NOT NULL OPTIONS (ANNOTATION 'Product SKU. Otherwise, null.', NAMEINSOURCE 'cartItem/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (item_id string, name string, price string, "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), product_option_extension_attributes_downloadable_option_downloadable_links string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/downloadable_option/downloadable_links'), product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_message string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_message'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), product_type string, qty string, quote_id string, sku string)
OPTIONS (ANNOTATION 'Add/update the specified cart item.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/items/{itemId}');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/items/itemId_DELETE"(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN itemId string NOT NULL OPTIONS (ANNOTATION 'The item ID of the item to be removed.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Removes the specified item from the specified cart.', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/items/{itemId}');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/order"(OUT "return" string RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN paymentMethod_additional_data string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_extension_attributes_agreement_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/extension_attributes/agreement_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_method string NOT NULL OPTIONS (ANNOTATION 'Payment method code', NAMEINSOURCE 'paymentMethod/method', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_po_number string NOT NULL OPTIONS (ANNOTATION 'Purchase order number', NAMEINSOURCE 'paymentMethod/po_number', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Places an order for a specified cart.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/order');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/payment-methods"(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, title string)
OPTIONS (ANNOTATION 'Lists available payment methods for a specified shopping cart. This call returns an array of objects, but detailed information about each object’s attributes might not be included.  See http://devdocs.magento.com/codelinks/attributes.html#PaymentMethodManagementInterface to determine which call to use to get detailed information about all attributes for an object.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/payment-methods');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/selected-payment-method_GET"(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (additional_data string[], extension_attributes_agreement_ids string[] OPTIONS (NAMEINSOURCE 'extension_attributes/agreement_ids'), "method" string, po_number string)
OPTIONS (ANNOTATION 'Returns the payment method for a specified shopping cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/selected-payment-method');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/selected-payment-method_PUT"(OUT "return" string RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN method_additional_data string[] NOT NULL OPTIONS (NAMEINSOURCE 'method/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN method_extension_attributes_agreement_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'method/extension_attributes/agreement_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN method_method string NOT NULL OPTIONS (ANNOTATION 'Payment method code', NAMEINSOURCE 'method/method', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN method_po_number string NOT NULL OPTIONS (ANNOTATION 'Purchase order number', NAMEINSOURCE 'method/po_number', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Adds a specified payment method to a specified shopping cart.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/selected-payment-method');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/shipping-information"(IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN addressInformation_billing_address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'addressInformation/billing_address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'addressInformation/billing_address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'addressInformation/billing_address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_billing_address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'addressInformation/billing_address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_billing_address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'addressInformation/billing_address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'addressInformation/billing_address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'addressInformation/billing_address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'addressInformation/billing_address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/billing_address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'addressInformation/billing_address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'addressInformation/billing_address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'addressInformation/billing_address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'addressInformation/billing_address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'addressInformation/billing_address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'addressInformation/billing_address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'addressInformation/billing_address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'addressInformation/billing_address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'addressInformation/billing_address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'addressInformation/billing_address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'addressInformation/billing_address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'addressInformation/billing_address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/billing_address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'addressInformation/billing_address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'addressInformation/billing_address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'addressInformation/billing_address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'addressInformation/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'addressInformation/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'addressInformation/shipping_address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'addressInformation/shipping_address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'addressInformation/shipping_address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_shipping_address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'addressInformation/shipping_address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_shipping_address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'addressInformation/shipping_address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'addressInformation/shipping_address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'addressInformation/shipping_address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'addressInformation/shipping_address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/shipping_address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'addressInformation/shipping_address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'addressInformation/shipping_address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'addressInformation/shipping_address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'addressInformation/shipping_address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'addressInformation/shipping_address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'addressInformation/shipping_address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'addressInformation/shipping_address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'addressInformation/shipping_address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'addressInformation/shipping_address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'addressInformation/shipping_address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'addressInformation/shipping_address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'addressInformation/shipping_address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/shipping_address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'addressInformation/shipping_address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'addressInformation/shipping_address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'addressInformation/shipping_address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_carrier_code string NOT NULL OPTIONS (ANNOTATION 'Carrier code', NAMEINSOURCE 'addressInformation/shipping_carrier_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_method_code string NOT NULL OPTIONS (ANNOTATION 'Shipping method code', NAMEINSOURCE 'addressInformation/shipping_method_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE ("payment_methods_quote-data-payment-method-interface_code" string OPTIONS (NAMEINSOURCE 'payment_methods[]/quote-data-payment-method-interface/code'), "payment_methods_quote-data-payment-method-interface_title" string OPTIONS (NAMEINSOURCE 'payment_methods[]/quote-data-payment-method-interface/title'), totals_base_currency_code string OPTIONS (NAMEINSOURCE 'totals/base_currency_code'), totals_base_discount_amount string OPTIONS (NAMEINSOURCE 'totals/base_discount_amount'), totals_base_grand_total string OPTIONS (NAMEINSOURCE 'totals/base_grand_total'), totals_base_shipping_amount string OPTIONS (NAMEINSOURCE 'totals/base_shipping_amount'), totals_base_shipping_discount_amount string OPTIONS (NAMEINSOURCE 'totals/base_shipping_discount_amount'), totals_base_shipping_incl_tax string OPTIONS (NAMEINSOURCE 'totals/base_shipping_incl_tax'), totals_base_shipping_tax_amount string OPTIONS (NAMEINSOURCE 'totals/base_shipping_tax_amount'), totals_base_subtotal string OPTIONS (NAMEINSOURCE 'totals/base_subtotal'), totals_base_subtotal_incl_tax string OPTIONS (NAMEINSOURCE 'totals/base_subtotal_incl_tax'), totals_base_subtotal_with_discount string OPTIONS (NAMEINSOURCE 'totals/base_subtotal_with_discount'), totals_base_tax_amount string OPTIONS (NAMEINSOURCE 'totals/base_tax_amount'), totals_coupon_code string OPTIONS (NAMEINSOURCE 'totals/coupon_code'), totals_discount_amount string OPTIONS (NAMEINSOURCE 'totals/discount_amount'), totals_extension_attributes_base_customer_balance_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/base_customer_balance_amount'), totals_extension_attributes_base_reward_currency_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/base_reward_currency_amount'), totals_extension_attributes_customer_balance_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/customer_balance_amount'), totals_extension_attributes_reward_currency_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/reward_currency_amount'), totals_extension_attributes_reward_points_balance string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/reward_points_balance'), totals_grand_total string OPTIONS (NAMEINSOURCE 'totals/grand_total'), "totals_items_quote-data-totals-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_discount_amount'), "totals_items_quote-data-totals-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_price'), "totals_items_quote-data-totals-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_price_incl_tax'), "totals_items_quote-data-totals-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_row_total'), "totals_items_quote-data-totals-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_row_total_incl_tax'), "totals_items_quote-data-totals-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_tax_amount'), "totals_items_quote-data-totals-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/discount_amount'), "totals_items_quote-data-totals-item-interface_discount_percent" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/discount_percent'), "totals_items_quote-data-totals-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/item_id'), "totals_items_quote-data-totals-item-interface_name" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/name'), "totals_items_quote-data-totals-item-interface_options" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/options'), "totals_items_quote-data-totals-item-interface_price" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/price'), "totals_items_quote-data-totals-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/price_incl_tax'), "totals_items_quote-data-totals-item-interface_qty" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/qty'), "totals_items_quote-data-totals-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/row_total'), "totals_items_quote-data-totals-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/row_total_incl_tax'), "totals_items_quote-data-totals-item-interface_row_total_with_discount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/row_total_with_discount'), "totals_items_quote-data-totals-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/tax_amount'), "totals_items_quote-data-totals-item-interface_tax_percent" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/tax_percent'), "totals_items_quote-data-totals-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/weee_tax_applied'), "totals_items_quote-data-totals-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/weee_tax_applied_amount'), totals_items_qty string OPTIONS (NAMEINSOURCE 'totals/items_qty'), totals_quote_currency_code string OPTIONS (NAMEINSOURCE 'totals/quote_currency_code'), totals_shipping_amount string OPTIONS (NAMEINSOURCE 'totals/shipping_amount'), totals_shipping_discount_amount string OPTIONS (NAMEINSOURCE 'totals/shipping_discount_amount'), totals_shipping_incl_tax string OPTIONS (NAMEINSOURCE 'totals/shipping_incl_tax'), totals_shipping_tax_amount string OPTIONS (NAMEINSOURCE 'totals/shipping_tax_amount'), totals_subtotal string OPTIONS (NAMEINSOURCE 'totals/subtotal'), totals_subtotal_incl_tax string OPTIONS (NAMEINSOURCE 'totals/subtotal_incl_tax'), totals_subtotal_with_discount string OPTIONS (NAMEINSOURCE 'totals/subtotal_with_discount'), totals_tax_amount string OPTIONS (NAMEINSOURCE 'totals/tax_amount'), "totals_total_segments_quote-data-total-segment-interface_area" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/area'), "totals_total_segments_quote-data-total-segment-interface_code" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/code'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gift_cards" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gift_cards'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_add_card" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_add_card'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_allow_gift_receipt" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_allow_gift_receipt'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_item_ids" string[] OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_item_ids'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_order_id" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_order_id'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_group_id" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/group_id'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_percent" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/percent'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_title" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/title'), "totals_total_segments_quote-data-total-segment-interface_title" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/title'), "totals_total_segments_quote-data-total-segment-interface_value" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/value'), totals_weee_tax_applied_amount string OPTIONS (NAMEINSOURCE 'totals/weee_tax_applied_amount'))
OPTIONS ("teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/shipping-information');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/shipping-methods"(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The shopping cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (amount string, available boolean, base_amount string, carrier_code string, carrier_title string, error_message string, method_code string, method_title string, price_excl_tax string, price_incl_tax string)
OPTIONS (ANNOTATION 'Lists applicable shipping methods for a specified quote.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/shipping-methods');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/totals"(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (base_currency_code string, base_discount_amount string, base_grand_total string, base_shipping_amount string, base_shipping_discount_amount string, base_shipping_incl_tax string, base_shipping_tax_amount string, base_subtotal string, base_subtotal_incl_tax string, base_subtotal_with_discount string, base_tax_amount string, coupon_code string, discount_amount string, extension_attributes_base_customer_balance_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/base_customer_balance_amount'), extension_attributes_base_reward_currency_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/base_reward_currency_amount'), extension_attributes_customer_balance_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/customer_balance_amount'), extension_attributes_reward_currency_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/reward_currency_amount'), extension_attributes_reward_points_balance string OPTIONS (NAMEINSOURCE 'extension_attributes/reward_points_balance'), grand_total string, "items_quote-data-totals-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_discount_amount'), "items_quote-data-totals-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_price'), "items_quote-data-totals-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_price_incl_tax'), "items_quote-data-totals-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_row_total'), "items_quote-data-totals-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_row_total_incl_tax'), "items_quote-data-totals-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_tax_amount'), "items_quote-data-totals-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/discount_amount'), "items_quote-data-totals-item-interface_discount_percent" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/discount_percent'), "items_quote-data-totals-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/item_id'), "items_quote-data-totals-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/name'), "items_quote-data-totals-item-interface_options" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/options'), "items_quote-data-totals-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/price'), "items_quote-data-totals-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/price_incl_tax'), "items_quote-data-totals-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/qty'), "items_quote-data-totals-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total'), "items_quote-data-totals-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total_incl_tax'), "items_quote-data-totals-item-interface_row_total_with_discount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total_with_discount'), "items_quote-data-totals-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/tax_amount'), "items_quote-data-totals-item-interface_tax_percent" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/tax_percent'), "items_quote-data-totals-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/weee_tax_applied'), "items_quote-data-totals-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/weee_tax_applied_amount'), items_qty string, quote_currency_code string, shipping_amount string, shipping_discount_amount string, shipping_incl_tax string, shipping_tax_amount string, subtotal string, subtotal_incl_tax string, subtotal_with_discount string, tax_amount string, "total_segments_quote-data-total-segment-interface_area" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/area'), "total_segments_quote-data-total-segment-interface_code" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/code'), "total_segments_quote-data-total-segment-interface_extension_attributes_gift_cards" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gift_cards'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_add_card" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_add_card'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_allow_gift_receipt" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_allow_gift_receipt'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_item_ids" string[] OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_item_ids'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_order_id" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_order_id'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_group_id" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/group_id'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_percent" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/percent'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_title" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/title'), "total_segments_quote-data-total-segment-interface_title" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/title'), "total_segments_quote-data-total-segment-interface_value" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/value'), weee_tax_applied_amount string)
OPTIONS (ANNOTATION 'Returns quote totals data for a specified cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/totals');

CREATE FOREIGN PROCEDURE "V1/carts/cartId/totals-information"(IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN addressInformation_address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'addressInformation/address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'addressInformation/address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'addressInformation/address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'addressInformation/address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'addressInformation/address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'addressInformation/address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'addressInformation/address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'addressInformation/address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'addressInformation/address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'addressInformation/address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'addressInformation/address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'addressInformation/address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'addressInformation/address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'addressInformation/address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'addressInformation/address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'addressInformation/address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'addressInformation/address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'addressInformation/address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'addressInformation/address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'addressInformation/address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'addressInformation/address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'addressInformation/address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'addressInformation/address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'addressInformation/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'addressInformation/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_carrier_code string NOT NULL OPTIONS (ANNOTATION 'Carrier code', NAMEINSOURCE 'addressInformation/shipping_carrier_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_shipping_method_code string NOT NULL OPTIONS (ANNOTATION 'Shipping method code', NAMEINSOURCE 'addressInformation/shipping_method_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (base_currency_code string, base_discount_amount string, base_grand_total string, base_shipping_amount string, base_shipping_discount_amount string, base_shipping_incl_tax string, base_shipping_tax_amount string, base_subtotal string, base_subtotal_incl_tax string, base_subtotal_with_discount string, base_tax_amount string, coupon_code string, discount_amount string, extension_attributes_base_customer_balance_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/base_customer_balance_amount'), extension_attributes_base_reward_currency_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/base_reward_currency_amount'), extension_attributes_customer_balance_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/customer_balance_amount'), extension_attributes_reward_currency_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/reward_currency_amount'), extension_attributes_reward_points_balance string OPTIONS (NAMEINSOURCE 'extension_attributes/reward_points_balance'), grand_total string, "items_quote-data-totals-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_discount_amount'), "items_quote-data-totals-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_price'), "items_quote-data-totals-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_price_incl_tax'), "items_quote-data-totals-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_row_total'), "items_quote-data-totals-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_row_total_incl_tax'), "items_quote-data-totals-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_tax_amount'), "items_quote-data-totals-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/discount_amount'), "items_quote-data-totals-item-interface_discount_percent" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/discount_percent'), "items_quote-data-totals-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/item_id'), "items_quote-data-totals-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/name'), "items_quote-data-totals-item-interface_options" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/options'), "items_quote-data-totals-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/price'), "items_quote-data-totals-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/price_incl_tax'), "items_quote-data-totals-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/qty'), "items_quote-data-totals-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total'), "items_quote-data-totals-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total_incl_tax'), "items_quote-data-totals-item-interface_row_total_with_discount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total_with_discount'), "items_quote-data-totals-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/tax_amount'), "items_quote-data-totals-item-interface_tax_percent" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/tax_percent'), "items_quote-data-totals-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/weee_tax_applied'), "items_quote-data-totals-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/weee_tax_applied_amount'), items_qty string, quote_currency_code string, shipping_amount string, shipping_discount_amount string, shipping_incl_tax string, shipping_tax_amount string, subtotal string, subtotal_incl_tax string, subtotal_with_discount string, tax_amount string, "total_segments_quote-data-total-segment-interface_area" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/area'), "total_segments_quote-data-total-segment-interface_code" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/code'), "total_segments_quote-data-total-segment-interface_extension_attributes_gift_cards" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gift_cards'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_add_card" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_add_card'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_allow_gift_receipt" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_allow_gift_receipt'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_item_ids" string[] OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_item_ids'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_order_id" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_order_id'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_group_id" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/group_id'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_percent" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/percent'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_title" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/title'), "total_segments_quote-data-total-segment-interface_title" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/title'), "total_segments_quote-data-total-segment-interface_value" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/value'), weee_tax_applied_amount string)
OPTIONS (ANNOTATION 'Calculate quote totals based on address and shipping method.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{cartId}/totals-information');

CREATE FOREIGN PROCEDURE giftCardAccountGiftCardAccountManagementV1GetListByQuoteIdGet(IN quoteId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (base_gift_cards_amount string, base_gift_cards_amount_used string, gift_cards string[], gift_cards_amount string, gift_cards_amount_used string)
OPTIONS (ANNOTATION 'Return GiftCard Account cards', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{quoteId}/giftCards');

CREATE FOREIGN PROCEDURE "V1/carts/quoteId/items"(IN quoteId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN cartItem_item_id string NOT NULL OPTIONS (ANNOTATION 'Item ID. Otherwise, null.', NAMEINSOURCE 'cartItem/item_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_name string NOT NULL OPTIONS (ANNOTATION 'Product name. Otherwise, null.', NAMEINSOURCE 'cartItem/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_price string NOT NULL OPTIONS (ANNOTATION 'Product price. Otherwise, null.', NAMEINSOURCE 'cartItem/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Bundle option id.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string NOT NULL OPTIONS (ANNOTATION 'Bundle option quantity.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] NOT NULL OPTIONS (NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option SKU', NAMEINSOURCE 'cartItem/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Item id', NAMEINSOURCE 'cartItem/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string NOT NULL OPTIONS (ANNOTATION 'Media data (base64 encoded content)', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string NOT NULL OPTIONS (ANNOTATION 'Image name', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string NOT NULL OPTIONS (ANNOTATION 'MIME type', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Option value', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_downloadable_option_downloadable_links string[] NOT NULL OPTIONS (NAMEINSOURCE 'cartItem/product_option/extension_attributes/downloadable_option/downloadable_links', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string NOT NULL OPTIONS (ANNOTATION 'Gift card open amount value.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_amount string NOT NULL OPTIONS (ANNOTATION 'Gift card amount.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_message string NOT NULL OPTIONS (ANNOTATION 'Giftcard message.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient email.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient name.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string NOT NULL OPTIONS (ANNOTATION 'Gift card sender email.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string NOT NULL OPTIONS (ANNOTATION 'Gift card sender name.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_type string NOT NULL OPTIONS (ANNOTATION 'Product type. Otherwise, null.', NAMEINSOURCE 'cartItem/product_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_qty string NOT NULL OPTIONS (ANNOTATION 'Product quantity.', NAMEINSOURCE 'cartItem/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_quote_id string NOT NULL OPTIONS (ANNOTATION 'Quote id.', NAMEINSOURCE 'cartItem/quote_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_sku string NOT NULL OPTIONS (ANNOTATION 'Product SKU. Otherwise, null.', NAMEINSOURCE 'cartItem/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (item_id string, name string, price string, "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), product_option_extension_attributes_downloadable_option_downloadable_links string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/downloadable_option/downloadable_links'), product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_message string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_message'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), product_type string, qty string, quote_id string, sku string)
OPTIONS (ANNOTATION 'Add/update the specified cart item.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/carts/{quoteId}/items');

CREATE FOREIGN PROCEDURE catalogCategoryManagementV1GetTreeGet(IN rootCategoryId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN depth string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE ("children_data_catalog-data-category-tree-interface_id" string OPTIONS (NAMEINSOURCE 'children_data[]/catalog-data-category-tree-interface/id'), "children_data_catalog-data-category-tree-interface_is_active" boolean OPTIONS (NAMEINSOURCE 'children_data[]/catalog-data-category-tree-interface/is_active'), "children_data_catalog-data-category-tree-interface_level" string OPTIONS (NAMEINSOURCE 'children_data[]/catalog-data-category-tree-interface/level'), "children_data_catalog-data-category-tree-interface_name" string OPTIONS (NAMEINSOURCE 'children_data[]/catalog-data-category-tree-interface/name'), "children_data_catalog-data-category-tree-interface_parent_id" string OPTIONS (NAMEINSOURCE 'children_data[]/catalog-data-category-tree-interface/parent_id'), "children_data_catalog-data-category-tree-interface_position" string OPTIONS (NAMEINSOURCE 'children_data[]/catalog-data-category-tree-interface/position'), "children_data_catalog-data-category-tree-interface_product_count" string OPTIONS (NAMEINSOURCE 'children_data[]/catalog-data-category-tree-interface/product_count'), id string, is_active boolean, level string, name string, parent_id string, position string, product_count string)
OPTIONS (ANNOTATION 'Retrieve list of categories', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/categories');

CREATE FOREIGN PROCEDURE catalogCategoryRepositoryV1SavePost(IN category_available_sort_by string[] NOT NULL OPTIONS (NAMEINSOURCE 'category/available_sort_by', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_children string NOT NULL OPTIONS (NAMEINSOURCE 'category/children', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_created_at string NOT NULL OPTIONS (NAMEINSOURCE 'category/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "category_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'category/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "category_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'category/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_id string NOT NULL OPTIONS (NAMEINSOURCE 'category/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_include_in_menu boolean NOT NULL OPTIONS (NAMEINSOURCE 'category/include_in_menu', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_is_active boolean NOT NULL OPTIONS (ANNOTATION 'Whether category is active', NAMEINSOURCE 'category/is_active', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_level string NOT NULL OPTIONS (ANNOTATION 'Category level', NAMEINSOURCE 'category/level', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_name string NOT NULL OPTIONS (ANNOTATION 'Category name', NAMEINSOURCE 'category/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_parent_id string NOT NULL OPTIONS (ANNOTATION 'Parent category ID', NAMEINSOURCE 'category/parent_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_path string NOT NULL OPTIONS (NAMEINSOURCE 'category/path', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_position string NOT NULL OPTIONS (ANNOTATION 'Category position', NAMEINSOURCE 'category/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_updated_at string NOT NULL OPTIONS (NAMEINSOURCE 'category/updated_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (available_sort_by string[], children string, created_at string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), id string, include_in_menu boolean, is_active boolean, level string, name string, parent_id string, path string, position string, updated_at string)
OPTIONS (ANNOTATION 'Create category service', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/categories');

CREATE FOREIGN PROCEDURE catalogCategoryAttributeRepositoryV1GetListGet(IN "searchCriteria[filterGroups][][filters][][field]" string NOT NULL OPTIONS (ANNOTATION 'Field', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][value]" string NOT NULL OPTIONS (ANNOTATION 'Value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][conditionType]" string NOT NULL OPTIONS (ANNOTATION 'Condition type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][field]" string NOT NULL OPTIONS (ANNOTATION 'Sorting field.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][direction]" string NOT NULL OPTIONS (ANNOTATION 'Sorting direction.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[pageSize]" string NOT NULL OPTIONS (ANNOTATION 'Page size.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[currentPage]" string NOT NULL OPTIONS (ANNOTATION 'Current page.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE ("items_catalog-data-category-attribute-interface_apply_to" string[] OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/apply_to'), "items_catalog-data-category-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/attribute_code'), "items_catalog-data-category-attribute-interface_attribute_id" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/attribute_id'), "items_catalog-data-category-attribute-interface_backend_model" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/backend_model'), "items_catalog-data-category-attribute-interface_backend_type" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/backend_type'), "items_catalog-data-category-attribute-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "items_catalog-data-category-attribute-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/custom_attributes[]/framework-attribute-interface/value'), "items_catalog-data-category-attribute-interface_default_frontend_label" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/default_frontend_label'), "items_catalog-data-category-attribute-interface_default_value" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/default_value'), "items_catalog-data-category-attribute-interface_entity_type_id" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/entity_type_id'), "items_catalog-data-category-attribute-interface_frontend_class" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/frontend_class'), "items_catalog-data-category-attribute-interface_frontend_input" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/frontend_input'), "items_catalog-data-category-attribute-interface_frontend_labels_eav-data-attribute-frontend-label-interface_label" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/frontend_labels[]/eav-data-attribute-frontend-label-interface/label'), "items_catalog-data-category-attribute-interface_frontend_labels_eav-data-attribute-frontend-label-interface_store_id" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/frontend_labels[]/eav-data-attribute-frontend-label-interface/store_id'), "items_catalog-data-category-attribute-interface_is_comparable" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_comparable'), "items_catalog-data-category-attribute-interface_is_filterable" boolean OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_filterable'), "items_catalog-data-category-attribute-interface_is_filterable_in_grid" boolean OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_filterable_in_grid'), "items_catalog-data-category-attribute-interface_is_filterable_in_search" boolean OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_filterable_in_search'), "items_catalog-data-category-attribute-interface_is_html_allowed_on_front" boolean OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_html_allowed_on_front'), "items_catalog-data-category-attribute-interface_is_required" boolean OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_required'), "items_catalog-data-category-attribute-interface_is_searchable" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_searchable'), "items_catalog-data-category-attribute-interface_is_unique" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_unique'), "items_catalog-data-category-attribute-interface_is_used_for_promo_rules" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_used_for_promo_rules'), "items_catalog-data-category-attribute-interface_is_used_in_grid" boolean OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_used_in_grid'), "items_catalog-data-category-attribute-interface_is_user_defined" boolean OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_user_defined'), "items_catalog-data-category-attribute-interface_is_visible" boolean OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_visible'), "items_catalog-data-category-attribute-interface_is_visible_in_advanced_search" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_visible_in_advanced_search'), "items_catalog-data-category-attribute-interface_is_visible_in_grid" boolean OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_visible_in_grid'), "items_catalog-data-category-attribute-interface_is_visible_on_front" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_visible_on_front'), "items_catalog-data-category-attribute-interface_is_wysiwyg_enabled" boolean OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/is_wysiwyg_enabled'), "items_catalog-data-category-attribute-interface_note" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/note'), "items_catalog-data-category-attribute-interface_options_eav-data-attribute-option-interface_is_default" boolean OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/options[]/eav-data-attribute-option-interface/is_default'), "items_catalog-data-category-attribute-interface_options_eav-data-attribute-option-interface_label" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/options[]/eav-data-attribute-option-interface/label'), "items_catalog-data-category-attribute-interface_options_eav-data-attribute-option-interface_sort_order" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/options[]/eav-data-attribute-option-interface/sort_order'), "items_catalog-data-category-attribute-interface_options_eav-data-attribute-option-interface_store_labels_eav-data-attribute-option-label-interface_label" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/options[]/eav-data-attribute-option-interface/store_labels[]/eav-data-attribute-option-label-interface/label'), "items_catalog-data-category-attribute-interface_options_eav-data-attribute-option-interface_store_labels_eav-data-attribute-option-label-interface_store_id" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/options[]/eav-data-attribute-option-interface/store_labels[]/eav-data-attribute-option-label-interface/store_id'), "items_catalog-data-category-attribute-interface_options_eav-data-attribute-option-interface_value" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/options[]/eav-data-attribute-option-interface/value'), "items_catalog-data-category-attribute-interface_position" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/position'), "items_catalog-data-category-attribute-interface_scope" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/scope'), "items_catalog-data-category-attribute-interface_source_model" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/source_model'), "items_catalog-data-category-attribute-interface_used_for_sort_by" boolean OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/used_for_sort_by'), "items_catalog-data-category-attribute-interface_used_in_product_listing" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/used_in_product_listing'), "items_catalog-data-category-attribute-interface_validation_rules_eav-data-attribute-validation-rule-interface_key" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/validation_rules[]/eav-data-attribute-validation-rule-interface/key'), "items_catalog-data-category-attribute-interface_validation_rules_eav-data-attribute-validation-rule-interface_value" string OPTIONS (NAMEINSOURCE 'items[]/catalog-data-category-attribute-interface/validation_rules[]/eav-data-attribute-validation-rule-interface/value'), search_criteria_current_page string OPTIONS (NAMEINSOURCE 'search_criteria/current_page'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_condition_type" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/condition_type'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_field" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/field'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_value" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/value'), search_criteria_page_size string OPTIONS (NAMEINSOURCE 'search_criteria/page_size'), "search_criteria_sort_orders_framework-sort-order_direction" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/direction'), "search_criteria_sort_orders_framework-sort-order_field" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/field'), total_count string)
OPTIONS (ANNOTATION 'Retrieve all attributes for entity type', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/categories/attributes');

CREATE FOREIGN PROCEDURE catalogCategoryAttributeRepositoryV1GetGet(IN attributeCode string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (apply_to string[], attribute_code string, attribute_id string, backend_model string, backend_type string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), default_frontend_label string, default_value string, entity_type_id string, frontend_class string, frontend_input string, "frontend_labels_eav-data-attribute-frontend-label-interface_label" string OPTIONS (NAMEINSOURCE 'frontend_labels[]/eav-data-attribute-frontend-label-interface/label'), "frontend_labels_eav-data-attribute-frontend-label-interface_store_id" string OPTIONS (NAMEINSOURCE 'frontend_labels[]/eav-data-attribute-frontend-label-interface/store_id'), is_comparable string, is_filterable boolean, is_filterable_in_grid boolean, is_filterable_in_search boolean, is_html_allowed_on_front boolean, is_required boolean, is_searchable string, is_unique string, is_used_for_promo_rules string, is_used_in_grid boolean, is_user_defined boolean, is_visible boolean, is_visible_in_advanced_search string, is_visible_in_grid boolean, is_visible_on_front string, is_wysiwyg_enabled boolean, note string, "options_eav-data-attribute-option-interface_is_default" boolean OPTIONS (NAMEINSOURCE 'options[]/eav-data-attribute-option-interface/is_default'), "options_eav-data-attribute-option-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/eav-data-attribute-option-interface/label'), "options_eav-data-attribute-option-interface_sort_order" string OPTIONS (NAMEINSOURCE 'options[]/eav-data-attribute-option-interface/sort_order'), "options_eav-data-attribute-option-interface_store_labels_eav-data-attribute-option-label-interface_label" string OPTIONS (NAMEINSOURCE 'options[]/eav-data-attribute-option-interface/store_labels[]/eav-data-attribute-option-label-interface/label'), "options_eav-data-attribute-option-interface_store_labels_eav-data-attribute-option-label-interface_store_id" string OPTIONS (NAMEINSOURCE 'options[]/eav-data-attribute-option-interface/store_labels[]/eav-data-attribute-option-label-interface/store_id'), "options_eav-data-attribute-option-interface_value" string OPTIONS (NAMEINSOURCE 'options[]/eav-data-attribute-option-interface/value'), position string, scope string, source_model string, used_for_sort_by boolean, used_in_product_listing string, "validation_rules_eav-data-attribute-validation-rule-interface_key" string OPTIONS (NAMEINSOURCE 'validation_rules[]/eav-data-attribute-validation-rule-interface/key'), "validation_rules_eav-data-attribute-validation-rule-interface_value" string OPTIONS (NAMEINSOURCE 'validation_rules[]/eav-data-attribute-validation-rule-interface/value'))
OPTIONS (ANNOTATION 'Retrieve specific attribute', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/categories/attributes/{attributeCode}');

CREATE FOREIGN PROCEDURE catalogCategoryAttributeOptionManagementV1GetItemsGet(IN attributeCode string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (is_default boolean, label string, sort_order string, "store_labels_eav-data-attribute-option-label-interface_label" string OPTIONS (NAMEINSOURCE 'store_labels[]/eav-data-attribute-option-label-interface/label'), "store_labels_eav-data-attribute-option-label-interface_store_id" string OPTIONS (NAMEINSOURCE 'store_labels[]/eav-data-attribute-option-label-interface/store_id'), "value" string)
OPTIONS (ANNOTATION 'Retrieve list of attribute options', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/categories/attributes/{attributeCode}/options');

CREATE FOREIGN PROCEDURE catalogCategoryRepositoryV1GetGet(IN categoryId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN storeId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (available_sort_by string[], children string, created_at string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), id string, include_in_menu boolean, is_active boolean, level string, name string, parent_id string, path string, position string, updated_at string)
OPTIONS (ANNOTATION 'Get info about category by category id', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/categories/{categoryId}');

CREATE FOREIGN PROCEDURE catalogCategoryRepositoryV1DeleteByIdentifierDelete(OUT "return" boolean RESULT, IN categoryId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Delete category by identifier', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/categories/{categoryId}');

CREATE FOREIGN PROCEDURE catalogCategoryManagementV1MovePut(OUT "return" boolean RESULT, IN categoryId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN afterId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN parentId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Move category', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/categories/{categoryId}/move');

CREATE FOREIGN PROCEDURE catalogCategoryLinkManagementV1GetAssignedProductsGet(IN categoryId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (category_id string, position string, sku string)
OPTIONS (ANNOTATION 'Get products assigned to category', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/categories/{categoryId}/products');

CREATE FOREIGN PROCEDURE catalogCategoryLinkRepositoryV1SavePut(OUT "return" boolean RESULT, IN categoryId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN productLink_category_id string NOT NULL OPTIONS (ANNOTATION 'Category id', NAMEINSOURCE 'productLink/category_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN productLink_position string NOT NULL OPTIONS (NAMEINSOURCE 'productLink/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN productLink_sku string NOT NULL OPTIONS (NAMEINSOURCE 'productLink/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Assign a product to the required category', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/categories/{categoryId}/products');

CREATE FOREIGN PROCEDURE catalogCategoryLinkRepositoryV1SavePost(OUT "return" boolean RESULT, IN categoryId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN productLink_category_id string NOT NULL OPTIONS (ANNOTATION 'Category id', NAMEINSOURCE 'productLink/category_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN productLink_position string NOT NULL OPTIONS (NAMEINSOURCE 'productLink/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN productLink_sku string NOT NULL OPTIONS (NAMEINSOURCE 'productLink/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Assign a product to the required category', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/categories/{categoryId}/products');

CREATE FOREIGN PROCEDURE catalogCategoryLinkRepositoryV1DeleteByIdsDelete(OUT "return" boolean RESULT, IN categoryId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Remove the product assignment from the category by category id and sku', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/categories/{categoryId}/products/{sku}');

CREATE FOREIGN PROCEDURE catalogCategoryRepositoryV1SavePut(IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN category_available_sort_by string[] NOT NULL OPTIONS (NAMEINSOURCE 'category/available_sort_by', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_children string NOT NULL OPTIONS (NAMEINSOURCE 'category/children', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_created_at string NOT NULL OPTIONS (NAMEINSOURCE 'category/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "category_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'category/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "category_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'category/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_id string NOT NULL OPTIONS (NAMEINSOURCE 'category/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_include_in_menu boolean NOT NULL OPTIONS (NAMEINSOURCE 'category/include_in_menu', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_is_active boolean NOT NULL OPTIONS (ANNOTATION 'Whether category is active', NAMEINSOURCE 'category/is_active', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_level string NOT NULL OPTIONS (ANNOTATION 'Category level', NAMEINSOURCE 'category/level', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_name string NOT NULL OPTIONS (ANNOTATION 'Category name', NAMEINSOURCE 'category/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_parent_id string NOT NULL OPTIONS (ANNOTATION 'Parent category ID', NAMEINSOURCE 'category/parent_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_path string NOT NULL OPTIONS (NAMEINSOURCE 'category/path', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_position string NOT NULL OPTIONS (ANNOTATION 'Category position', NAMEINSOURCE 'category/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN category_updated_at string NOT NULL OPTIONS (NAMEINSOURCE 'category/updated_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (available_sort_by string[], children string, created_at string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), id string, include_in_menu boolean, is_active boolean, level string, name string, parent_id string, path string, position string, updated_at string)
OPTIONS (ANNOTATION 'Create category service', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/categories/{id}');

CREATE FOREIGN PROCEDURE cmsBlockRepositoryV1SavePost(IN block_active boolean NOT NULL OPTIONS (ANNOTATION 'Active', NAMEINSOURCE 'block/active', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN block_content string NOT NULL OPTIONS (ANNOTATION 'Content', NAMEINSOURCE 'block/content', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN block_creation_time string NOT NULL OPTIONS (ANNOTATION 'Creation time', NAMEINSOURCE 'block/creation_time', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN block_id string NOT NULL OPTIONS (ANNOTATION 'ID', NAMEINSOURCE 'block/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN block_identifier string NOT NULL OPTIONS (ANNOTATION 'Identifier', NAMEINSOURCE 'block/identifier', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN block_title string NOT NULL OPTIONS (ANNOTATION 'Title', NAMEINSOURCE 'block/title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN block_update_time string NOT NULL OPTIONS (ANNOTATION 'Update time', NAMEINSOURCE 'block/update_time', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (active boolean, content string, creation_time string, id string, identifier string, title string, update_time string)
OPTIONS (ANNOTATION 'Save block.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/cmsBlock');

CREATE FOREIGN PROCEDURE cmsBlockRepositoryV1GetListGet(IN "searchCriteria[filterGroups][][filters][][field]" string NOT NULL OPTIONS (ANNOTATION 'Field', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][value]" string NOT NULL OPTIONS (ANNOTATION 'Value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][conditionType]" string NOT NULL OPTIONS (ANNOTATION 'Condition type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][field]" string NOT NULL OPTIONS (ANNOTATION 'Sorting field.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][direction]" string NOT NULL OPTIONS (ANNOTATION 'Sorting direction.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[pageSize]" string NOT NULL OPTIONS (ANNOTATION 'Page size.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[currentPage]" string NOT NULL OPTIONS (ANNOTATION 'Current page.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE ("items_cms-data-block-interface_active" boolean OPTIONS (NAMEINSOURCE 'items[]/cms-data-block-interface/active'), "items_cms-data-block-interface_content" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-block-interface/content'), "items_cms-data-block-interface_creation_time" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-block-interface/creation_time'), "items_cms-data-block-interface_id" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-block-interface/id'), "items_cms-data-block-interface_identifier" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-block-interface/identifier'), "items_cms-data-block-interface_title" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-block-interface/title'), "items_cms-data-block-interface_update_time" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-block-interface/update_time'), search_criteria_current_page string OPTIONS (NAMEINSOURCE 'search_criteria/current_page'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_condition_type" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/condition_type'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_field" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/field'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_value" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/value'), search_criteria_page_size string OPTIONS (NAMEINSOURCE 'search_criteria/page_size'), "search_criteria_sort_orders_framework-sort-order_direction" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/direction'), "search_criteria_sort_orders_framework-sort-order_field" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/field'), total_count string)
OPTIONS (ANNOTATION 'Retrieve blocks matching the specified criteria.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/cmsBlock/search');

CREATE FOREIGN PROCEDURE cmsBlockRepositoryV1GetByIdGet(IN blockId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (active boolean, content string, creation_time string, id string, identifier string, title string, update_time string)
OPTIONS (ANNOTATION 'Retrieve block.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/cmsBlock/{blockId}');

CREATE FOREIGN PROCEDURE cmsBlockRepositoryV1DeleteByIdDelete(OUT "return" boolean RESULT, IN blockId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Delete block by ID.', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/cmsBlock/{blockId}');

CREATE FOREIGN PROCEDURE cmsBlockRepositoryV1SavePut(IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN block_active boolean NOT NULL OPTIONS (ANNOTATION 'Active', NAMEINSOURCE 'block/active', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN block_content string NOT NULL OPTIONS (ANNOTATION 'Content', NAMEINSOURCE 'block/content', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN block_creation_time string NOT NULL OPTIONS (ANNOTATION 'Creation time', NAMEINSOURCE 'block/creation_time', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN block_id string NOT NULL OPTIONS (ANNOTATION 'ID', NAMEINSOURCE 'block/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN block_identifier string NOT NULL OPTIONS (ANNOTATION 'Identifier', NAMEINSOURCE 'block/identifier', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN block_title string NOT NULL OPTIONS (ANNOTATION 'Title', NAMEINSOURCE 'block/title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN block_update_time string NOT NULL OPTIONS (ANNOTATION 'Update time', NAMEINSOURCE 'block/update_time', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (active boolean, content string, creation_time string, id string, identifier string, title string, update_time string)
OPTIONS (ANNOTATION 'Save block.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/cmsBlock/{id}');

CREATE FOREIGN PROCEDURE cmsPageRepositoryV1SavePost(IN page_active boolean NOT NULL OPTIONS (ANNOTATION 'Active', NAMEINSOURCE 'page/active', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_content string NOT NULL OPTIONS (ANNOTATION 'Content', NAMEINSOURCE 'page/content', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_content_heading string NOT NULL OPTIONS (ANNOTATION 'Content heading', NAMEINSOURCE 'page/content_heading', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_creation_time string NOT NULL OPTIONS (ANNOTATION 'Creation time', NAMEINSOURCE 'page/creation_time', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_custom_layout_update_xml string NOT NULL OPTIONS (ANNOTATION 'Custom layout update xml', NAMEINSOURCE 'page/custom_layout_update_xml', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_custom_root_template string NOT NULL OPTIONS (ANNOTATION 'Custom root template', NAMEINSOURCE 'page/custom_root_template', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_custom_theme string NOT NULL OPTIONS (ANNOTATION 'Custom theme', NAMEINSOURCE 'page/custom_theme', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_custom_theme_from string NOT NULL OPTIONS (ANNOTATION 'Custom theme from', NAMEINSOURCE 'page/custom_theme_from', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_custom_theme_to string NOT NULL OPTIONS (ANNOTATION 'Custom theme to', NAMEINSOURCE 'page/custom_theme_to', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_id string NOT NULL OPTIONS (ANNOTATION 'ID', NAMEINSOURCE 'page/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_identifier string NOT NULL OPTIONS (ANNOTATION 'Identifier', NAMEINSOURCE 'page/identifier', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_layout_update_xml string NOT NULL OPTIONS (ANNOTATION 'Layout update xml', NAMEINSOURCE 'page/layout_update_xml', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_meta_description string NOT NULL OPTIONS (ANNOTATION 'Meta description', NAMEINSOURCE 'page/meta_description', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_meta_keywords string NOT NULL OPTIONS (ANNOTATION 'Meta keywords', NAMEINSOURCE 'page/meta_keywords', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_meta_title string NOT NULL OPTIONS (ANNOTATION 'Meta title', NAMEINSOURCE 'page/meta_title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_page_layout string NOT NULL OPTIONS (ANNOTATION 'Page layout', NAMEINSOURCE 'page/page_layout', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_sort_order string NOT NULL OPTIONS (ANNOTATION 'Sort order', NAMEINSOURCE 'page/sort_order', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_title string NOT NULL OPTIONS (ANNOTATION 'Title', NAMEINSOURCE 'page/title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_update_time string NOT NULL OPTIONS (ANNOTATION 'Update time', NAMEINSOURCE 'page/update_time', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (active boolean, content string, content_heading string, creation_time string, custom_layout_update_xml string, custom_root_template string, custom_theme string, custom_theme_from string, custom_theme_to string, id string, identifier string, layout_update_xml string, meta_description string, meta_keywords string, meta_title string, page_layout string, sort_order string, title string, update_time string)
OPTIONS (ANNOTATION 'Save page.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/cmsPage');

CREATE FOREIGN PROCEDURE cmsPageRepositoryV1GetListGet(IN "searchCriteria[filterGroups][][filters][][field]" string NOT NULL OPTIONS (ANNOTATION 'Field', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][value]" string NOT NULL OPTIONS (ANNOTATION 'Value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][conditionType]" string NOT NULL OPTIONS (ANNOTATION 'Condition type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][field]" string NOT NULL OPTIONS (ANNOTATION 'Sorting field.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][direction]" string NOT NULL OPTIONS (ANNOTATION 'Sorting direction.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[pageSize]" string NOT NULL OPTIONS (ANNOTATION 'Page size.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[currentPage]" string NOT NULL OPTIONS (ANNOTATION 'Current page.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE ("items_cms-data-page-interface_active" boolean OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/active'), "items_cms-data-page-interface_content" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/content'), "items_cms-data-page-interface_content_heading" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/content_heading'), "items_cms-data-page-interface_creation_time" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/creation_time'), "items_cms-data-page-interface_custom_layout_update_xml" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/custom_layout_update_xml'), "items_cms-data-page-interface_custom_root_template" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/custom_root_template'), "items_cms-data-page-interface_custom_theme" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/custom_theme'), "items_cms-data-page-interface_custom_theme_from" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/custom_theme_from'), "items_cms-data-page-interface_custom_theme_to" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/custom_theme_to'), "items_cms-data-page-interface_id" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/id'), "items_cms-data-page-interface_identifier" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/identifier'), "items_cms-data-page-interface_layout_update_xml" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/layout_update_xml'), "items_cms-data-page-interface_meta_description" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/meta_description'), "items_cms-data-page-interface_meta_keywords" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/meta_keywords'), "items_cms-data-page-interface_meta_title" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/meta_title'), "items_cms-data-page-interface_page_layout" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/page_layout'), "items_cms-data-page-interface_sort_order" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/sort_order'), "items_cms-data-page-interface_title" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/title'), "items_cms-data-page-interface_update_time" string OPTIONS (NAMEINSOURCE 'items[]/cms-data-page-interface/update_time'), search_criteria_current_page string OPTIONS (NAMEINSOURCE 'search_criteria/current_page'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_condition_type" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/condition_type'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_field" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/field'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_value" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/value'), search_criteria_page_size string OPTIONS (NAMEINSOURCE 'search_criteria/page_size'), "search_criteria_sort_orders_framework-sort-order_direction" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/direction'), "search_criteria_sort_orders_framework-sort-order_field" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/field'), total_count string)
OPTIONS (ANNOTATION 'Retrieve pages matching the specified criteria.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/cmsPage/search');

CREATE FOREIGN PROCEDURE cmsPageRepositoryV1SavePut(IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN page_active boolean NOT NULL OPTIONS (ANNOTATION 'Active', NAMEINSOURCE 'page/active', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_content string NOT NULL OPTIONS (ANNOTATION 'Content', NAMEINSOURCE 'page/content', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_content_heading string NOT NULL OPTIONS (ANNOTATION 'Content heading', NAMEINSOURCE 'page/content_heading', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_creation_time string NOT NULL OPTIONS (ANNOTATION 'Creation time', NAMEINSOURCE 'page/creation_time', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_custom_layout_update_xml string NOT NULL OPTIONS (ANNOTATION 'Custom layout update xml', NAMEINSOURCE 'page/custom_layout_update_xml', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_custom_root_template string NOT NULL OPTIONS (ANNOTATION 'Custom root template', NAMEINSOURCE 'page/custom_root_template', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_custom_theme string NOT NULL OPTIONS (ANNOTATION 'Custom theme', NAMEINSOURCE 'page/custom_theme', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_custom_theme_from string NOT NULL OPTIONS (ANNOTATION 'Custom theme from', NAMEINSOURCE 'page/custom_theme_from', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_custom_theme_to string NOT NULL OPTIONS (ANNOTATION 'Custom theme to', NAMEINSOURCE 'page/custom_theme_to', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_id string NOT NULL OPTIONS (ANNOTATION 'ID', NAMEINSOURCE 'page/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_identifier string NOT NULL OPTIONS (ANNOTATION 'Identifier', NAMEINSOURCE 'page/identifier', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_layout_update_xml string NOT NULL OPTIONS (ANNOTATION 'Layout update xml', NAMEINSOURCE 'page/layout_update_xml', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_meta_description string NOT NULL OPTIONS (ANNOTATION 'Meta description', NAMEINSOURCE 'page/meta_description', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_meta_keywords string NOT NULL OPTIONS (ANNOTATION 'Meta keywords', NAMEINSOURCE 'page/meta_keywords', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_meta_title string NOT NULL OPTIONS (ANNOTATION 'Meta title', NAMEINSOURCE 'page/meta_title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_page_layout string NOT NULL OPTIONS (ANNOTATION 'Page layout', NAMEINSOURCE 'page/page_layout', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_sort_order string NOT NULL OPTIONS (ANNOTATION 'Sort order', NAMEINSOURCE 'page/sort_order', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_title string NOT NULL OPTIONS (ANNOTATION 'Title', NAMEINSOURCE 'page/title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN page_update_time string NOT NULL OPTIONS (ANNOTATION 'Update time', NAMEINSOURCE 'page/update_time', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (active boolean, content string, content_heading string, creation_time string, custom_layout_update_xml string, custom_root_template string, custom_theme string, custom_theme_from string, custom_theme_to string, id string, identifier string, layout_update_xml string, meta_description string, meta_keywords string, meta_title string, page_layout string, sort_order string, title string, update_time string)
OPTIONS (ANNOTATION 'Save page.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/cmsPage/{id}');

CREATE FOREIGN PROCEDURE cmsPageRepositoryV1GetByIdGet(IN pageId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (active boolean, content string, content_heading string, creation_time string, custom_layout_update_xml string, custom_root_template string, custom_theme string, custom_theme_from string, custom_theme_to string, id string, identifier string, layout_update_xml string, meta_description string, meta_keywords string, meta_title string, page_layout string, sort_order string, title string, update_time string)
OPTIONS (ANNOTATION 'Retrieve page.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/cmsPage/{pageId}');

CREATE FOREIGN PROCEDURE cmsPageRepositoryV1DeleteByIdDelete(OUT "return" boolean RESULT, IN pageId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Delete page by ID.', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/cmsPage/{pageId}');

CREATE FOREIGN PROCEDURE configurableProductConfigurableProductManagementV1GenerateVariationPut(IN "options_configurable-product-data-option-interface_attribute_id" string NOT NULL OPTIONS (NAMEINSOURCE 'options[]/configurable-product-data-option-interface/attribute_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "options_configurable-product-data-option-interface_id" string NOT NULL OPTIONS (NAMEINSOURCE 'options[]/configurable-product-data-option-interface/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "options_configurable-product-data-option-interface_is_use_default" boolean NOT NULL OPTIONS (NAMEINSOURCE 'options[]/configurable-product-data-option-interface/is_use_default', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "options_configurable-product-data-option-interface_label" string NOT NULL OPTIONS (NAMEINSOURCE 'options[]/configurable-product-data-option-interface/label', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "options_configurable-product-data-option-interface_position" string NOT NULL OPTIONS (NAMEINSOURCE 'options[]/configurable-product-data-option-interface/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "options_configurable-product-data-option-interface_product_id" string NOT NULL OPTIONS (NAMEINSOURCE 'options[]/configurable-product-data-option-interface/product_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "options_configurable-product-data-option-interface_values_configurable-product-data-option-value-interface_value_index" string NOT NULL OPTIONS (NAMEINSOURCE 'options[]/configurable-product-data-option-interface/values[]/configurable-product-data-option-value-interface/value_index', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_attribute_set_id string NOT NULL OPTIONS (ANNOTATION 'Attribute set id', NAMEINSOURCE 'product/attribute_set_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_created_at string NOT NULL OPTIONS (ANNOTATION 'Created date', NAMEINSOURCE 'product/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'product/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'product/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_position" string NOT NULL OPTIONS (ANNOTATION 'Option position', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_can_change_quantity" string NOT NULL OPTIONS (ANNOTATION 'Whether quantity could be changed', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/can_change_quantity', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_id" string NOT NULL OPTIONS (ANNOTATION 'The identifier', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_is_default" boolean NOT NULL OPTIONS (ANNOTATION 'Is default', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/is_default', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_position" string NOT NULL OPTIONS (ANNOTATION 'Position', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_price" string NOT NULL OPTIONS (ANNOTATION 'Price', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_price_type" string NOT NULL OPTIONS (ANNOTATION 'Price type', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/price_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_qty" string NOT NULL OPTIONS (ANNOTATION 'Qty', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_sku" string NOT NULL OPTIONS (ANNOTATION 'Linked product sku', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_required" boolean NOT NULL OPTIONS (ANNOTATION 'Is required option', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/required', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_sku" string NOT NULL OPTIONS (ANNOTATION 'Product sku', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_title" string NOT NULL OPTIONS (ANNOTATION 'Option title', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_bundle_product_options_bundle-data-option-interface_type" string NOT NULL OPTIONS (ANNOTATION 'Input type', NAMEINSOURCE 'product/extension_attributes/bundle_product_options[]/bundle-data-option-interface/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_configurable_product_links string[] NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/configurable_product_links', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_configurable_product_options_configurable-product-data-option-interface_attribute_id" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/attribute_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_configurable_product_options_configurable-product-data-option-interface_id" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_configurable_product_options_configurable-product-data-option-interface_is_use_default" boolean NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/is_use_default', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_configurable_product_options_configurable-product-data-option-interface_label" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/label', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_configurable_product_options_configurable-product-data-option-interface_position" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_configurable_product_options_configurable-product-data-option-interface_product_id" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/product_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_configurable_product_options_configurable-product-data-option-interface_values_configurable-product-data-option-value-interface_value_index" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/values[]/configurable-product-data-option-value-interface/value_index', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_id" string NOT NULL OPTIONS (ANNOTATION 'Sample(or link) id', NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_is_shareable" string NOT NULL OPTIONS (ANNOTATION 'Shareable status', NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/is_shareable', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_file" string NOT NULL OPTIONS (ANNOTATION 'relative file path', NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_file', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_file_content_file_data" string NOT NULL OPTIONS (ANNOTATION 'Data (base64 encoded content)', NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_file_content/file_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_file_content_name" string NOT NULL OPTIONS (ANNOTATION 'File name', NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_file_content/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_type" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_url" string NOT NULL OPTIONS (ANNOTATION 'Link url or null when type is ''file''', NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_url', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_number_of_downloads" string NOT NULL OPTIONS (ANNOTATION 'Of downloads per user', NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/number_of_downloads', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_price" string NOT NULL OPTIONS (ANNOTATION 'Price', NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_file" string NOT NULL OPTIONS (ANNOTATION 'relative file path', NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_file', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_file_content_file_data" string NOT NULL OPTIONS (ANNOTATION 'Data (base64 encoded content)', NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_file_content/file_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_file_content_name" string NOT NULL OPTIONS (ANNOTATION 'File name', NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_file_content/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_type" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_url" string NOT NULL OPTIONS (ANNOTATION 'file URL', NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_url', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_sort_order" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sort_order', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_links_downloadable-data-link-interface_title" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_id" string NOT NULL OPTIONS (ANNOTATION 'Sample(or link) id', NAMEINSOURCE 'product/extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_file" string NOT NULL OPTIONS (ANNOTATION 'relative file path', NAMEINSOURCE 'product/extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_file', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_file_content_file_data" string NOT NULL OPTIONS (ANNOTATION 'Data (base64 encoded content)', NAMEINSOURCE 'product/extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_file_content/file_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_file_content_name" string NOT NULL OPTIONS (ANNOTATION 'File name', NAMEINSOURCE 'product/extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_file_content/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_type" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_url" string NOT NULL OPTIONS (ANNOTATION 'file URL', NAMEINSOURCE 'product/extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_url', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sort_order" string NOT NULL OPTIONS (ANNOTATION 'Order index for sample', NAMEINSOURCE 'product/extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sort_order', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_title" string NOT NULL OPTIONS (ANNOTATION 'Title', NAMEINSOURCE 'product/extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_giftcard_amounts_gift-card-data-giftcard-amount-interface_attribute_id" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/giftcard_amounts[]/gift-card-data-giftcard-amount-interface/attribute_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_giftcard_amounts_gift-card-data-giftcard-amount-interface_value" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/giftcard_amounts[]/gift-card-data-giftcard-amount-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_giftcard_amounts_gift-card-data-giftcard-amount-interface_website_id" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/giftcard_amounts[]/gift-card-data-giftcard-amount-interface/website_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_extension_attributes_giftcard_amounts_gift-card-data-giftcard-amount-interface_website_value" string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/giftcard_amounts[]/gift-card-data-giftcard-amount-interface/website_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_backorders string NOT NULL OPTIONS (ANNOTATION 'Backorders status', NAMEINSOURCE 'product/extension_attributes/stock_item/backorders', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_enable_qty_increments boolean NOT NULL OPTIONS (ANNOTATION 'Whether Quantity Increments is enabled', NAMEINSOURCE 'product/extension_attributes/stock_item/enable_qty_increments', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_is_decimal_divided boolean NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/is_decimal_divided', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_is_in_stock boolean NOT NULL OPTIONS (ANNOTATION 'Stock Availability', NAMEINSOURCE 'product/extension_attributes/stock_item/is_in_stock', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_is_qty_decimal boolean NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/is_qty_decimal', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_item_id string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/item_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_low_stock_date string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/low_stock_date', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_manage_stock boolean NOT NULL OPTIONS (ANNOTATION 'Can Manage Stock', NAMEINSOURCE 'product/extension_attributes/stock_item/manage_stock', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_max_sale_qty string NOT NULL OPTIONS (ANNOTATION 'Maximum Qty Allowed in Shopping Cart data wrapper', NAMEINSOURCE 'product/extension_attributes/stock_item/max_sale_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_min_qty string NOT NULL OPTIONS (ANNOTATION 'Minimal quantity available for item status in stock', NAMEINSOURCE 'product/extension_attributes/stock_item/min_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_min_sale_qty string NOT NULL OPTIONS (ANNOTATION 'Minimum Qty Allowed in Shopping Cart or NULL when there is no limitation', NAMEINSOURCE 'product/extension_attributes/stock_item/min_sale_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_notify_stock_qty string NOT NULL OPTIONS (ANNOTATION 'Notify for Quantity Below data wrapper', NAMEINSOURCE 'product/extension_attributes/stock_item/notify_stock_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_product_id string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/product_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_qty string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_qty_increments string NOT NULL OPTIONS (ANNOTATION 'Quantity Increments data wrapper', NAMEINSOURCE 'product/extension_attributes/stock_item/qty_increments', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_show_default_notification_message boolean NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/show_default_notification_message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_stock_id string NOT NULL OPTIONS (ANNOTATION 'Stock identifier', NAMEINSOURCE 'product/extension_attributes/stock_item/stock_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_stock_status_changed_auto string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/stock_status_changed_auto', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_use_config_backorders boolean NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/use_config_backorders', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_use_config_enable_qty_inc boolean NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/use_config_enable_qty_inc', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_use_config_manage_stock boolean NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/use_config_manage_stock', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_use_config_max_sale_qty boolean NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/use_config_max_sale_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_use_config_min_qty boolean NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/use_config_min_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_use_config_min_sale_qty string NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/use_config_min_sale_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_use_config_notify_stock_qty boolean NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/use_config_notify_stock_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_extension_attributes_stock_item_use_config_qty_increments boolean NOT NULL OPTIONS (NAMEINSOURCE 'product/extension_attributes/stock_item/use_config_qty_increments', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'product/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_content_base64_encoded_data" string NOT NULL OPTIONS (ANNOTATION 'Media data (base64 encoded content)', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/content/base64_encoded_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_content_name" string NOT NULL OPTIONS (ANNOTATION 'Image name', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/content/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_content_type" string NOT NULL OPTIONS (ANNOTATION 'MIME type', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/content/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_disabled" boolean NOT NULL OPTIONS (ANNOTATION 'If gallery entry is hidden from product page', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/disabled', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_media_type" string NOT NULL OPTIONS (ANNOTATION 'MIME type', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/media_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_description" string NOT NULL OPTIONS (ANNOTATION 'Video Description', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_description', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_metadata" string NOT NULL OPTIONS (ANNOTATION 'Metadata', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_metadata', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_provider" string NOT NULL OPTIONS (ANNOTATION 'Provider', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_provider', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_title" string NOT NULL OPTIONS (ANNOTATION 'Title', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_url" string NOT NULL OPTIONS (ANNOTATION 'Video URL', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_url', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_file" string NOT NULL OPTIONS (ANNOTATION 'File path', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/file', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_id" string NOT NULL OPTIONS (ANNOTATION 'Gallery entry ID', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_label" string NOT NULL OPTIONS (ANNOTATION 'Gallery entry alternative text', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/label', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_media_type" string NOT NULL OPTIONS (ANNOTATION 'Media type', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/media_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_position" string NOT NULL OPTIONS (ANNOTATION 'Gallery entry position (sort order)', NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_types" string[] NOT NULL OPTIONS (NAMEINSOURCE 'product/media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/types', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_name string NOT NULL OPTIONS (ANNOTATION 'Name', NAMEINSOURCE 'product/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_file_extension" string NOT NULL OPTIONS (NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/file_extension', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_image_size_x" string NOT NULL OPTIONS (NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/image_size_x', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_image_size_y" string NOT NULL OPTIONS (NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/image_size_y', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_is_require" boolean NOT NULL OPTIONS (ANNOTATION 'Is require', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/is_require', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_max_characters" string NOT NULL OPTIONS (NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/max_characters', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_price" string NOT NULL OPTIONS (ANNOTATION 'Price', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_price_type" string NOT NULL OPTIONS (ANNOTATION 'Price type', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/price_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_product_sku" string NOT NULL OPTIONS (ANNOTATION 'Product SKU', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/product_sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_sku" string NOT NULL OPTIONS (ANNOTATION 'Sku', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_sort_order" string NOT NULL OPTIONS (ANNOTATION 'Sort order', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/sort_order', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_title" string NOT NULL OPTIONS (ANNOTATION 'Option title', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_type" string NOT NULL OPTIONS (ANNOTATION 'Option type', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_option_type_id" string NOT NULL OPTIONS (ANNOTATION 'Option type id', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/option_type_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_price" string NOT NULL OPTIONS (ANNOTATION 'Price', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_price_type" string NOT NULL OPTIONS (ANNOTATION 'Price type', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/price_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_sku" string NOT NULL OPTIONS (ANNOTATION 'Sku', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_sort_order" string NOT NULL OPTIONS (ANNOTATION 'Sort order', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/sort_order', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_title" string NOT NULL OPTIONS (ANNOTATION 'Option title', NAMEINSOURCE 'product/options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/title', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_price string NOT NULL OPTIONS (ANNOTATION 'Price', NAMEINSOURCE 'product/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_product_links_catalog-data-product-link-interface_extension_attributes_qty" string NOT NULL OPTIONS (NAMEINSOURCE 'product/product_links[]/catalog-data-product-link-interface/extension_attributes/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_product_links_catalog-data-product-link-interface_link_type" string NOT NULL OPTIONS (ANNOTATION 'Link type', NAMEINSOURCE 'product/product_links[]/catalog-data-product-link-interface/link_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_product_links_catalog-data-product-link-interface_linked_product_sku" string NOT NULL OPTIONS (ANNOTATION 'Linked product sku', NAMEINSOURCE 'product/product_links[]/catalog-data-product-link-interface/linked_product_sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_product_links_catalog-data-product-link-interface_linked_product_type" string NOT NULL OPTIONS (ANNOTATION 'Linked product type (simple, virtual, etc)', NAMEINSOURCE 'product/product_links[]/catalog-data-product-link-interface/linked_product_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_product_links_catalog-data-product-link-interface_position" string NOT NULL OPTIONS (ANNOTATION 'Linked item position', NAMEINSOURCE 'product/product_links[]/catalog-data-product-link-interface/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_product_links_catalog-data-product-link-interface_sku" string NOT NULL OPTIONS (ANNOTATION 'SKU', NAMEINSOURCE 'product/product_links[]/catalog-data-product-link-interface/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_sku string NOT NULL OPTIONS (ANNOTATION 'Sku', NAMEINSOURCE 'product/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_status string NOT NULL OPTIONS (ANNOTATION 'Status', NAMEINSOURCE 'product/status', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_tier_prices_catalog-data-product-tier-price-interface_customer_group_id" string NOT NULL OPTIONS (ANNOTATION 'Customer group id', NAMEINSOURCE 'product/tier_prices[]/catalog-data-product-tier-price-interface/customer_group_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_tier_prices_catalog-data-product-tier-price-interface_qty" string NOT NULL OPTIONS (ANNOTATION 'Tier qty', NAMEINSOURCE 'product/tier_prices[]/catalog-data-product-tier-price-interface/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "product_tier_prices_catalog-data-product-tier-price-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Price value', NAMEINSOURCE 'product/tier_prices[]/catalog-data-product-tier-price-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_type_id string NOT NULL OPTIONS (ANNOTATION 'Type id', NAMEINSOURCE 'product/type_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_updated_at string NOT NULL OPTIONS (ANNOTATION 'Updated date', NAMEINSOURCE 'product/updated_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_visibility string NOT NULL OPTIONS (ANNOTATION 'Visibility', NAMEINSOURCE 'product/visibility', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN product_weight string NOT NULL OPTIONS (ANNOTATION 'Weight', NAMEINSOURCE 'product/weight', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (attribute_set_id string, created_at string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), "extension_attributes_bundle_product_options_bundle-data-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/option_id'), "extension_attributes_bundle_product_options_bundle-data-option-interface_position" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/position'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_can_change_quantity" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/can_change_quantity'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/id'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_is_default" boolean OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/is_default'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_option_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/option_id'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_position" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/position'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_price" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/price'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_price_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/price_type'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_qty" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/qty'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_sku" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/sku'), "extension_attributes_bundle_product_options_bundle-data-option-interface_required" boolean OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/required'), "extension_attributes_bundle_product_options_bundle-data-option-interface_sku" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/sku'), "extension_attributes_bundle_product_options_bundle-data-option-interface_title" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/title'), "extension_attributes_bundle_product_options_bundle-data-option-interface_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/type'), extension_attributes_configurable_product_links string[] OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_links'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_attribute_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/attribute_id'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/id'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_is_use_default" boolean OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/is_use_default'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/label'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_position" string OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/position'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_product_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/product_id'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_values_configurable-product-data-option-value-interface_value_index" string OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/values[]/configurable-product-data-option-value-interface/value_index'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/id'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_is_shareable" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/is_shareable'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_file" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_file'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_file_content_file_data" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_file_content/file_data'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_file_content_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_file_content/name'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_type'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_url" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_url'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_number_of_downloads" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/number_of_downloads'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_price" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/price'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_file" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_file'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_file_content_file_data" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_file_content/file_data'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_file_content_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_file_content/name'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_type'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_url" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_url'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_sort_order" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sort_order'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_title" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/title'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/id'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_file" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_file'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_file_content_file_data" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_file_content/file_data'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_file_content_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_file_content/name'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_type'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_url" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_url'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sort_order" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sort_order'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_title" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/title'), "extension_attributes_giftcard_amounts_gift-card-data-giftcard-amount-interface_attribute_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/giftcard_amounts[]/gift-card-data-giftcard-amount-interface/attribute_id'), "extension_attributes_giftcard_amounts_gift-card-data-giftcard-amount-interface_value" string OPTIONS (NAMEINSOURCE 'extension_attributes/giftcard_amounts[]/gift-card-data-giftcard-amount-interface/value'), "extension_attributes_giftcard_amounts_gift-card-data-giftcard-amount-interface_website_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/giftcard_amounts[]/gift-card-data-giftcard-amount-interface/website_id'), "extension_attributes_giftcard_amounts_gift-card-data-giftcard-amount-interface_website_value" string OPTIONS (NAMEINSOURCE 'extension_attributes/giftcard_amounts[]/gift-card-data-giftcard-amount-interface/website_value'), extension_attributes_stock_item_backorders string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/backorders'), extension_attributes_stock_item_enable_qty_increments boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/enable_qty_increments'), extension_attributes_stock_item_is_decimal_divided boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/is_decimal_divided'), extension_attributes_stock_item_is_in_stock boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/is_in_stock'), extension_attributes_stock_item_is_qty_decimal boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/is_qty_decimal'), extension_attributes_stock_item_item_id string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/item_id'), extension_attributes_stock_item_low_stock_date string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/low_stock_date'), extension_attributes_stock_item_manage_stock boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/manage_stock'), extension_attributes_stock_item_max_sale_qty string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/max_sale_qty'), extension_attributes_stock_item_min_qty string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/min_qty'), extension_attributes_stock_item_min_sale_qty string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/min_sale_qty'), extension_attributes_stock_item_notify_stock_qty string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/notify_stock_qty'), extension_attributes_stock_item_product_id string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/product_id'), extension_attributes_stock_item_qty string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/qty'), extension_attributes_stock_item_qty_increments string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/qty_increments'), extension_attributes_stock_item_show_default_notification_message boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/show_default_notification_message'), extension_attributes_stock_item_stock_id string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/stock_id'), extension_attributes_stock_item_stock_status_changed_auto string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/stock_status_changed_auto'), extension_attributes_stock_item_use_config_backorders boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_backorders'), extension_attributes_stock_item_use_config_enable_qty_inc boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_enable_qty_inc'), extension_attributes_stock_item_use_config_manage_stock boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_manage_stock'), extension_attributes_stock_item_use_config_max_sale_qty boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_max_sale_qty'), extension_attributes_stock_item_use_config_min_qty boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_min_qty'), extension_attributes_stock_item_use_config_min_sale_qty string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_min_sale_qty'), extension_attributes_stock_item_use_config_notify_stock_qty boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_notify_stock_qty'), extension_attributes_stock_item_use_config_qty_increments boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_qty_increments'), id string, "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_content_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/content/base64_encoded_data'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_content_name" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/content/name'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_content_type" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/content/type'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_disabled" boolean OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/disabled'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_media_type" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/media_type'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_description" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_description'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_metadata" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_metadata'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_provider" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_provider'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_title" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_title'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_url" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_url'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_file" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/file'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_id" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/id'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_label" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/label'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_media_type" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/media_type'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_position" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/position'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_types" string[] OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/types'), name string, "options_catalog-data-product-custom-option-interface_file_extension" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/file_extension'), "options_catalog-data-product-custom-option-interface_image_size_x" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/image_size_x'), "options_catalog-data-product-custom-option-interface_image_size_y" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/image_size_y'), "options_catalog-data-product-custom-option-interface_is_require" boolean OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/is_require'), "options_catalog-data-product-custom-option-interface_max_characters" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/max_characters'), "options_catalog-data-product-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/option_id'), "options_catalog-data-product-custom-option-interface_price" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/price'), "options_catalog-data-product-custom-option-interface_price_type" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/price_type'), "options_catalog-data-product-custom-option-interface_product_sku" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/product_sku'), "options_catalog-data-product-custom-option-interface_sku" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/sku'), "options_catalog-data-product-custom-option-interface_sort_order" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/sort_order'), "options_catalog-data-product-custom-option-interface_title" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/title'), "options_catalog-data-product-custom-option-interface_type" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/type'), "options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_option_type_id" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/option_type_id'), "options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_price" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/price'), "options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_price_type" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/price_type'), "options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_sku" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/sku'), "options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_sort_order" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/sort_order'), "options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_title" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/title'), price string, "product_links_catalog-data-product-link-interface_extension_attributes_qty" string OPTIONS (NAMEINSOURCE 'product_links[]/catalog-data-product-link-interface/extension_attributes/qty'), "product_links_catalog-data-product-link-interface_link_type" string OPTIONS (NAMEINSOURCE 'product_links[]/catalog-data-product-link-interface/link_type'), "product_links_catalog-data-product-link-interface_linked_product_sku" string OPTIONS (NAMEINSOURCE 'product_links[]/catalog-data-product-link-interface/linked_product_sku'), "product_links_catalog-data-product-link-interface_linked_product_type" string OPTIONS (NAMEINSOURCE 'product_links[]/catalog-data-product-link-interface/linked_product_type'), "product_links_catalog-data-product-link-interface_position" string OPTIONS (NAMEINSOURCE 'product_links[]/catalog-data-product-link-interface/position'), "product_links_catalog-data-product-link-interface_sku" string OPTIONS (NAMEINSOURCE 'product_links[]/catalog-data-product-link-interface/sku'), sku string, status string, "tier_prices_catalog-data-product-tier-price-interface_customer_group_id" string OPTIONS (NAMEINSOURCE 'tier_prices[]/catalog-data-product-tier-price-interface/customer_group_id'), "tier_prices_catalog-data-product-tier-price-interface_qty" string OPTIONS (NAMEINSOURCE 'tier_prices[]/catalog-data-product-tier-price-interface/qty'), "tier_prices_catalog-data-product-tier-price-interface_value" string OPTIONS (NAMEINSOURCE 'tier_prices[]/catalog-data-product-tier-price-interface/value'), type_id string, updated_at string, visibility string, weight string)
OPTIONS (ANNOTATION 'Generate variation based on same product', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/configurable-products/variation');

CREATE FOREIGN PROCEDURE configurableProductLinkManagementV1AddChildPost(OUT "return" boolean RESULT, IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN childSku string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS ("teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/configurable-products/{sku}/child');

CREATE FOREIGN PROCEDURE configurableProductLinkManagementV1GetChildrenGet(IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (attribute_set_id string, created_at string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), "extension_attributes_bundle_product_options_bundle-data-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/option_id'), "extension_attributes_bundle_product_options_bundle-data-option-interface_position" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/position'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_can_change_quantity" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/can_change_quantity'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/id'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_is_default" boolean OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/is_default'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_option_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/option_id'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_position" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/position'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_price" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/price'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_price_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/price_type'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_qty" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/qty'), "extension_attributes_bundle_product_options_bundle-data-option-interface_product_links_bundle-data-link-interface_sku" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/product_links[]/bundle-data-link-interface/sku'), "extension_attributes_bundle_product_options_bundle-data-option-interface_required" boolean OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/required'), "extension_attributes_bundle_product_options_bundle-data-option-interface_sku" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/sku'), "extension_attributes_bundle_product_options_bundle-data-option-interface_title" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/title'), "extension_attributes_bundle_product_options_bundle-data-option-interface_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/bundle_product_options[]/bundle-data-option-interface/type'), extension_attributes_configurable_product_links string[] OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_links'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_attribute_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/attribute_id'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/id'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_is_use_default" boolean OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/is_use_default'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_label" string OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/label'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_position" string OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/position'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_product_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/product_id'), "extension_attributes_configurable_product_options_configurable-product-data-option-interface_values_configurable-product-data-option-value-interface_value_index" string OPTIONS (NAMEINSOURCE 'extension_attributes/configurable_product_options[]/configurable-product-data-option-interface/values[]/configurable-product-data-option-value-interface/value_index'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/id'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_is_shareable" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/is_shareable'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_file" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_file'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_file_content_file_data" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_file_content/file_data'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_file_content_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_file_content/name'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_type'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_link_url" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/link_url'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_number_of_downloads" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/number_of_downloads'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_price" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/price'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_file" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_file'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_file_content_file_data" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_file_content/file_data'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_file_content_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_file_content/name'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_type'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_sample_url" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sample_url'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_sort_order" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/sort_order'), "extension_attributes_downloadable_product_links_downloadable-data-link-interface_title" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_links[]/downloadable-data-link-interface/title'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/id'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_file" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_file'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_file_content_file_data" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_file_content/file_data'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_file_content_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_file_content/name'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_type'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sample_url" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sample_url'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_sort_order" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/sort_order'), "extension_attributes_downloadable_product_samples_downloadable-data-sample-interface_title" string OPTIONS (NAMEINSOURCE 'extension_attributes/downloadable_product_samples[]/downloadable-data-sample-interface/title'), "extension_attributes_giftcard_amounts_gift-card-data-giftcard-amount-interface_attribute_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/giftcard_amounts[]/gift-card-data-giftcard-amount-interface/attribute_id'), "extension_attributes_giftcard_amounts_gift-card-data-giftcard-amount-interface_value" string OPTIONS (NAMEINSOURCE 'extension_attributes/giftcard_amounts[]/gift-card-data-giftcard-amount-interface/value'), "extension_attributes_giftcard_amounts_gift-card-data-giftcard-amount-interface_website_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/giftcard_amounts[]/gift-card-data-giftcard-amount-interface/website_id'), "extension_attributes_giftcard_amounts_gift-card-data-giftcard-amount-interface_website_value" string OPTIONS (NAMEINSOURCE 'extension_attributes/giftcard_amounts[]/gift-card-data-giftcard-amount-interface/website_value'), extension_attributes_stock_item_backorders string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/backorders'), extension_attributes_stock_item_enable_qty_increments boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/enable_qty_increments'), extension_attributes_stock_item_is_decimal_divided boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/is_decimal_divided'), extension_attributes_stock_item_is_in_stock boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/is_in_stock'), extension_attributes_stock_item_is_qty_decimal boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/is_qty_decimal'), extension_attributes_stock_item_item_id string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/item_id'), extension_attributes_stock_item_low_stock_date string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/low_stock_date'), extension_attributes_stock_item_manage_stock boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/manage_stock'), extension_attributes_stock_item_max_sale_qty string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/max_sale_qty'), extension_attributes_stock_item_min_qty string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/min_qty'), extension_attributes_stock_item_min_sale_qty string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/min_sale_qty'), extension_attributes_stock_item_notify_stock_qty string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/notify_stock_qty'), extension_attributes_stock_item_product_id string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/product_id'), extension_attributes_stock_item_qty string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/qty'), extension_attributes_stock_item_qty_increments string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/qty_increments'), extension_attributes_stock_item_show_default_notification_message boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/show_default_notification_message'), extension_attributes_stock_item_stock_id string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/stock_id'), extension_attributes_stock_item_stock_status_changed_auto string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/stock_status_changed_auto'), extension_attributes_stock_item_use_config_backorders boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_backorders'), extension_attributes_stock_item_use_config_enable_qty_inc boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_enable_qty_inc'), extension_attributes_stock_item_use_config_manage_stock boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_manage_stock'), extension_attributes_stock_item_use_config_max_sale_qty boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_max_sale_qty'), extension_attributes_stock_item_use_config_min_qty boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_min_qty'), extension_attributes_stock_item_use_config_min_sale_qty string OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_min_sale_qty'), extension_attributes_stock_item_use_config_notify_stock_qty boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_notify_stock_qty'), extension_attributes_stock_item_use_config_qty_increments boolean OPTIONS (NAMEINSOURCE 'extension_attributes/stock_item/use_config_qty_increments'), id string, "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_content_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/content/base64_encoded_data'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_content_name" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/content/name'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_content_type" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/content/type'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_disabled" boolean OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/disabled'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_media_type" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/media_type'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_description" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_description'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_metadata" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_metadata'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_provider" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_provider'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_title" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_title'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_extension_attributes_video_content_video_url" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/extension_attributes/video_content/video_url'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_file" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/file'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_id" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/id'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_label" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/label'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_media_type" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/media_type'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_position" string OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/position'), "media_gallery_entries_catalog-data-product-attribute-media-gallery-entry-interface_types" string[] OPTIONS (NAMEINSOURCE 'media_gallery_entries[]/catalog-data-product-attribute-media-gallery-entry-interface/types'), name string, "options_catalog-data-product-custom-option-interface_file_extension" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/file_extension'), "options_catalog-data-product-custom-option-interface_image_size_x" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/image_size_x'), "options_catalog-data-product-custom-option-interface_image_size_y" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/image_size_y'), "options_catalog-data-product-custom-option-interface_is_require" boolean OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/is_require'), "options_catalog-data-product-custom-option-interface_max_characters" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/max_characters'), "options_catalog-data-product-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/option_id'), "options_catalog-data-product-custom-option-interface_price" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/price'), "options_catalog-data-product-custom-option-interface_price_type" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/price_type'), "options_catalog-data-product-custom-option-interface_product_sku" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/product_sku'), "options_catalog-data-product-custom-option-interface_sku" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/sku'), "options_catalog-data-product-custom-option-interface_sort_order" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/sort_order'), "options_catalog-data-product-custom-option-interface_title" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/title'), "options_catalog-data-product-custom-option-interface_type" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/type'), "options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_option_type_id" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/option_type_id'), "options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_price" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/price'), "options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_price_type" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/price_type'), "options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_sku" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/sku'), "options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_sort_order" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/sort_order'), "options_catalog-data-product-custom-option-interface_values_catalog-data-product-custom-option-values-interface_title" string OPTIONS (NAMEINSOURCE 'options[]/catalog-data-product-custom-option-interface/values[]/catalog-data-product-custom-option-values-interface/title'), price string, "product_links_catalog-data-product-link-interface_extension_attributes_qty" string OPTIONS (NAMEINSOURCE 'product_links[]/catalog-data-product-link-interface/extension_attributes/qty'), "product_links_catalog-data-product-link-interface_link_type" string OPTIONS (NAMEINSOURCE 'product_links[]/catalog-data-product-link-interface/link_type'), "product_links_catalog-data-product-link-interface_linked_product_sku" string OPTIONS (NAMEINSOURCE 'product_links[]/catalog-data-product-link-interface/linked_product_sku'), "product_links_catalog-data-product-link-interface_linked_product_type" string OPTIONS (NAMEINSOURCE 'product_links[]/catalog-data-product-link-interface/linked_product_type'), "product_links_catalog-data-product-link-interface_position" string OPTIONS (NAMEINSOURCE 'product_links[]/catalog-data-product-link-interface/position'), "product_links_catalog-data-product-link-interface_sku" string OPTIONS (NAMEINSOURCE 'product_links[]/catalog-data-product-link-interface/sku'), sku string, status string, "tier_prices_catalog-data-product-tier-price-interface_customer_group_id" string OPTIONS (NAMEINSOURCE 'tier_prices[]/catalog-data-product-tier-price-interface/customer_group_id'), "tier_prices_catalog-data-product-tier-price-interface_qty" string OPTIONS (NAMEINSOURCE 'tier_prices[]/catalog-data-product-tier-price-interface/qty'), "tier_prices_catalog-data-product-tier-price-interface_value" string OPTIONS (NAMEINSOURCE 'tier_prices[]/catalog-data-product-tier-price-interface/value'), type_id string, updated_at string, visibility string, weight string)
OPTIONS (ANNOTATION 'Get all children for Configurable product', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/configurable-products/{sku}/children');

CREATE FOREIGN PROCEDURE configurableProductLinkManagementV1RemoveChildDelete(OUT "return" boolean RESULT, IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN childSku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Remove configurable product option', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/configurable-products/{sku}/children/{childSku}');

CREATE FOREIGN PROCEDURE configurableProductOptionRepositoryV1SavePost(OUT "return" string RESULT, IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN option_attribute_id string NOT NULL OPTIONS (NAMEINSOURCE 'option/attribute_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_id string NOT NULL OPTIONS (NAMEINSOURCE 'option/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_is_use_default boolean NOT NULL OPTIONS (NAMEINSOURCE 'option/is_use_default', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_label string NOT NULL OPTIONS (NAMEINSOURCE 'option/label', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_position string NOT NULL OPTIONS (NAMEINSOURCE 'option/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_product_id string NOT NULL OPTIONS (NAMEINSOURCE 'option/product_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_values_configurable-product-data-option-value-interface_value_index" string NOT NULL OPTIONS (NAMEINSOURCE 'option/values[]/configurable-product-data-option-value-interface/value_index', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Save option', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/configurable-products/{sku}/options');

CREATE FOREIGN PROCEDURE configurableProductOptionRepositoryV1GetListGet(IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (attribute_id string, id string, is_use_default boolean, label string, position string, product_id string, "values_configurable-product-data-option-value-interface_value_index" string OPTIONS (NAMEINSOURCE 'values[]/configurable-product-data-option-value-interface/value_index'))
OPTIONS (ANNOTATION 'Get all options for configurable product', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/configurable-products/{sku}/options/all');

CREATE FOREIGN PROCEDURE configurableProductOptionRepositoryV1GetGet(IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (attribute_id string, id string, is_use_default boolean, label string, position string, product_id string, "values_configurable-product-data-option-value-interface_value_index" string OPTIONS (NAMEINSOURCE 'values[]/configurable-product-data-option-value-interface/value_index'))
OPTIONS (ANNOTATION 'Get option for configurable product', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/configurable-products/{sku}/options/{id}');

CREATE FOREIGN PROCEDURE configurableProductOptionRepositoryV1SavePut(OUT "return" string RESULT, IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN option_attribute_id string NOT NULL OPTIONS (NAMEINSOURCE 'option/attribute_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_id string NOT NULL OPTIONS (NAMEINSOURCE 'option/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_is_use_default boolean NOT NULL OPTIONS (NAMEINSOURCE 'option/is_use_default', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_label string NOT NULL OPTIONS (NAMEINSOURCE 'option/label', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_position string NOT NULL OPTIONS (NAMEINSOURCE 'option/position', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN option_product_id string NOT NULL OPTIONS (NAMEINSOURCE 'option/product_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "option_values_configurable-product-data-option-value-interface_value_index" string NOT NULL OPTIONS (NAMEINSOURCE 'option/values[]/configurable-product-data-option-value-interface/value_index', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Save option', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/configurable-products/{sku}/options/{id}');

CREATE FOREIGN PROCEDURE configurableProductOptionRepositoryV1DeleteByIdDelete(OUT "return" boolean RESULT, IN sku string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Remove option from configurable product', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/configurable-products/{sku}/options/{id}');

CREATE FOREIGN PROCEDURE salesRuleCouponRepositoryV1SavePost(IN coupon_code string NOT NULL OPTIONS (ANNOTATION 'Coupon code', NAMEINSOURCE 'coupon/code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_coupon_id string NOT NULL OPTIONS (ANNOTATION 'Coupon id', NAMEINSOURCE 'coupon/coupon_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_created_at string NOT NULL OPTIONS (ANNOTATION 'When the coupon is created', NAMEINSOURCE 'coupon/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_expiration_date string NOT NULL OPTIONS (ANNOTATION 'Expiration date', NAMEINSOURCE 'coupon/expiration_date', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_is_primary boolean NOT NULL OPTIONS (ANNOTATION 'The coupon is primary coupon for the rule that it''s associated with', NAMEINSOURCE 'coupon/is_primary', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_rule_id string NOT NULL OPTIONS (ANNOTATION 'The id of the rule associated with the coupon', NAMEINSOURCE 'coupon/rule_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_times_used string NOT NULL OPTIONS (ANNOTATION 'The number of times the coupon has been used', NAMEINSOURCE 'coupon/times_used', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_type string NOT NULL OPTIONS (ANNOTATION 'Of coupon', NAMEINSOURCE 'coupon/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_usage_limit string NOT NULL OPTIONS (ANNOTATION 'Usage limit', NAMEINSOURCE 'coupon/usage_limit', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_usage_per_customer string NOT NULL OPTIONS (ANNOTATION 'Usage limit per customer', NAMEINSOURCE 'coupon/usage_per_customer', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, coupon_id string, created_at string, expiration_date string, is_primary boolean, rule_id string, times_used string, type string, usage_limit string, usage_per_customer string)
OPTIONS (ANNOTATION 'Save a coupon.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/coupons');

CREATE FOREIGN PROCEDURE salesRuleCouponManagementV1DeleteByCodesPost(IN codes string[] NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN ignoreInvalidCoupons boolean NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (failed_items string[], missing_items string[])
OPTIONS (ANNOTATION 'Delete coupon by coupon codes.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/coupons/deleteByCodes');

CREATE FOREIGN PROCEDURE salesRuleCouponManagementV1DeleteByIdsPost(IN ids string[] NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN ignoreInvalidCoupons boolean NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (failed_items string[], missing_items string[])
OPTIONS (ANNOTATION 'Delete coupon by coupon ids.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/coupons/deleteByIds');

CREATE FOREIGN PROCEDURE salesRuleCouponManagementV1GeneratePost(OUT "return" string[] RESULT, IN couponSpec_delimiter string NOT NULL OPTIONS (ANNOTATION 'The delimiter', NAMEINSOURCE 'couponSpec/delimiter', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN couponSpec_delimiter_at_every string NOT NULL OPTIONS (ANNOTATION 'The spacing where the delimiter should exist', NAMEINSOURCE 'couponSpec/delimiter_at_every', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN couponSpec_format string NOT NULL OPTIONS (ANNOTATION 'Format of generated coupon code', NAMEINSOURCE 'couponSpec/format', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN couponSpec_length string NOT NULL OPTIONS (ANNOTATION 'Length of coupon code', NAMEINSOURCE 'couponSpec/length', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN couponSpec_prefix string NOT NULL OPTIONS (ANNOTATION 'The prefix', NAMEINSOURCE 'couponSpec/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN couponSpec_quantity string NOT NULL OPTIONS (ANNOTATION 'Of coupons to generate', NAMEINSOURCE 'couponSpec/quantity', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN couponSpec_rule_id string NOT NULL OPTIONS (ANNOTATION 'The id of the rule associated with the coupon', NAMEINSOURCE 'couponSpec/rule_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN couponSpec_suffix string NOT NULL OPTIONS (ANNOTATION 'The suffix', NAMEINSOURCE 'couponSpec/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Generate coupon for a rule', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/coupons/generate');

CREATE FOREIGN PROCEDURE salesRuleCouponRepositoryV1GetListGet(IN "searchCriteria[filterGroups][][filters][][field]" string NOT NULL OPTIONS (ANNOTATION 'Field', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][value]" string NOT NULL OPTIONS (ANNOTATION 'Value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][conditionType]" string NOT NULL OPTIONS (ANNOTATION 'Condition type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][field]" string NOT NULL OPTIONS (ANNOTATION 'Sorting field.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][direction]" string NOT NULL OPTIONS (ANNOTATION 'Sorting direction.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[pageSize]" string NOT NULL OPTIONS (ANNOTATION 'Page size.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[currentPage]" string NOT NULL OPTIONS (ANNOTATION 'Current page.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE ("items_sales-rule-data-coupon-interface_code" string OPTIONS (NAMEINSOURCE 'items[]/sales-rule-data-coupon-interface/code'), "items_sales-rule-data-coupon-interface_coupon_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-rule-data-coupon-interface/coupon_id'), "items_sales-rule-data-coupon-interface_created_at" string OPTIONS (NAMEINSOURCE 'items[]/sales-rule-data-coupon-interface/created_at'), "items_sales-rule-data-coupon-interface_expiration_date" string OPTIONS (NAMEINSOURCE 'items[]/sales-rule-data-coupon-interface/expiration_date'), "items_sales-rule-data-coupon-interface_is_primary" boolean OPTIONS (NAMEINSOURCE 'items[]/sales-rule-data-coupon-interface/is_primary'), "items_sales-rule-data-coupon-interface_rule_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-rule-data-coupon-interface/rule_id'), "items_sales-rule-data-coupon-interface_times_used" string OPTIONS (NAMEINSOURCE 'items[]/sales-rule-data-coupon-interface/times_used'), "items_sales-rule-data-coupon-interface_type" string OPTIONS (NAMEINSOURCE 'items[]/sales-rule-data-coupon-interface/type'), "items_sales-rule-data-coupon-interface_usage_limit" string OPTIONS (NAMEINSOURCE 'items[]/sales-rule-data-coupon-interface/usage_limit'), "items_sales-rule-data-coupon-interface_usage_per_customer" string OPTIONS (NAMEINSOURCE 'items[]/sales-rule-data-coupon-interface/usage_per_customer'), search_criteria_current_page string OPTIONS (NAMEINSOURCE 'search_criteria/current_page'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_condition_type" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/condition_type'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_field" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/field'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_value" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/value'), search_criteria_page_size string OPTIONS (NAMEINSOURCE 'search_criteria/page_size'), "search_criteria_sort_orders_framework-sort-order_direction" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/direction'), "search_criteria_sort_orders_framework-sort-order_field" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/field'), total_count string)
OPTIONS (ANNOTATION 'Retrieve a coupon using the specified search criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#CouponRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/coupons/search');

CREATE FOREIGN PROCEDURE salesRuleCouponRepositoryV1GetByIdGet(IN couponId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, coupon_id string, created_at string, expiration_date string, is_primary boolean, rule_id string, times_used string, type string, usage_limit string, usage_per_customer string)
OPTIONS (ANNOTATION 'Get coupon by coupon id.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/coupons/{couponId}');

CREATE FOREIGN PROCEDURE salesRuleCouponRepositoryV1SavePut(IN couponId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN coupon_code string NOT NULL OPTIONS (ANNOTATION 'Coupon code', NAMEINSOURCE 'coupon/code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_coupon_id string NOT NULL OPTIONS (ANNOTATION 'Coupon id', NAMEINSOURCE 'coupon/coupon_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_created_at string NOT NULL OPTIONS (ANNOTATION 'When the coupon is created', NAMEINSOURCE 'coupon/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_expiration_date string NOT NULL OPTIONS (ANNOTATION 'Expiration date', NAMEINSOURCE 'coupon/expiration_date', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_is_primary boolean NOT NULL OPTIONS (ANNOTATION 'The coupon is primary coupon for the rule that it''s associated with', NAMEINSOURCE 'coupon/is_primary', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_rule_id string NOT NULL OPTIONS (ANNOTATION 'The id of the rule associated with the coupon', NAMEINSOURCE 'coupon/rule_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_times_used string NOT NULL OPTIONS (ANNOTATION 'The number of times the coupon has been used', NAMEINSOURCE 'coupon/times_used', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_type string NOT NULL OPTIONS (ANNOTATION 'Of coupon', NAMEINSOURCE 'coupon/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_usage_limit string NOT NULL OPTIONS (ANNOTATION 'Usage limit', NAMEINSOURCE 'coupon/usage_limit', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN coupon_usage_per_customer string NOT NULL OPTIONS (ANNOTATION 'Usage limit per customer', NAMEINSOURCE 'coupon/usage_per_customer', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, coupon_id string, created_at string, expiration_date string, is_primary boolean, rule_id string, times_used string, type string, usage_limit string, usage_per_customer string)
OPTIONS (ANNOTATION 'Save a coupon.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/coupons/{couponId}');

CREATE FOREIGN PROCEDURE salesRuleCouponRepositoryV1DeleteByIdDelete(OUT "return" boolean RESULT, IN couponId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Delete coupon by coupon id.', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/coupons/{couponId}');

CREATE FOREIGN PROCEDURE salesCreditmemoRepositoryV1SavePost(IN entity_adjustment string NOT NULL OPTIONS (ANNOTATION 'Credit memo adjustment.', NAMEINSOURCE 'entity/adjustment', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_adjustment_negative string NOT NULL OPTIONS (ANNOTATION 'Credit memo negative adjustment.', NAMEINSOURCE 'entity/adjustment_negative', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_adjustment_positive string NOT NULL OPTIONS (ANNOTATION 'Credit memo positive adjustment.', NAMEINSOURCE 'entity/adjustment_positive', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_adjustment string NOT NULL OPTIONS (ANNOTATION 'Credit memo base adjustment.', NAMEINSOURCE 'entity/base_adjustment', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_adjustment_negative string NOT NULL OPTIONS (ANNOTATION 'Credit memo negative base adjustment.', NAMEINSOURCE 'entity/base_adjustment_negative', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_adjustment_positive string NOT NULL OPTIONS (ANNOTATION 'Credit memo positive base adjustment.', NAMEINSOURCE 'entity/base_adjustment_positive', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_currency_code string NOT NULL OPTIONS (ANNOTATION 'Credit memo base currency code.', NAMEINSOURCE 'entity/base_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_discount_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo base discount amount.', NAMEINSOURCE 'entity/base_discount_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_discount_tax_compensation_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo base discount tax compensation amount.', NAMEINSOURCE 'entity/base_discount_tax_compensation_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_grand_total string NOT NULL OPTIONS (ANNOTATION 'Credit memo base grand total.', NAMEINSOURCE 'entity/base_grand_total', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_shipping_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo base shipping amount.', NAMEINSOURCE 'entity/base_shipping_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_shipping_discount_tax_compensation_amnt string NOT NULL OPTIONS (ANNOTATION 'Credit memo base shipping discount tax compensation amount.', NAMEINSOURCE 'entity/base_shipping_discount_tax_compensation_amnt', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_shipping_incl_tax string NOT NULL OPTIONS (ANNOTATION 'Credit memo base shipping including tax.', NAMEINSOURCE 'entity/base_shipping_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_shipping_tax_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo base shipping tax amount.', NAMEINSOURCE 'entity/base_shipping_tax_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_subtotal string NOT NULL OPTIONS (ANNOTATION 'Credit memo base subtotal.', NAMEINSOURCE 'entity/base_subtotal', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_subtotal_incl_tax string NOT NULL OPTIONS (ANNOTATION 'Credit memo base subtotal including tax.', NAMEINSOURCE 'entity/base_subtotal_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_tax_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo base tax amount.', NAMEINSOURCE 'entity/base_tax_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_to_global_rate string NOT NULL OPTIONS (ANNOTATION 'Credit memo base-to-global rate.', NAMEINSOURCE 'entity/base_to_global_rate', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_base_to_order_rate string NOT NULL OPTIONS (ANNOTATION 'Credit memo base-to-order rate.', NAMEINSOURCE 'entity/base_to_order_rate', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_billing_address_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo billing address ID.', NAMEINSOURCE 'entity/billing_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_comments_sales-data-creditmemo-comment-interface_comment" string NOT NULL OPTIONS (ANNOTATION 'Comment.', NAMEINSOURCE 'entity/comments[]/sales-data-creditmemo-comment-interface/comment', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_comments_sales-data-creditmemo-comment-interface_created_at" string NOT NULL OPTIONS (ANNOTATION 'Created-at timestamp.', NAMEINSOURCE 'entity/comments[]/sales-data-creditmemo-comment-interface/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_comments_sales-data-creditmemo-comment-interface_entity_id" string NOT NULL OPTIONS (ANNOTATION 'Credit memo ID.', NAMEINSOURCE 'entity/comments[]/sales-data-creditmemo-comment-interface/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_comments_sales-data-creditmemo-comment-interface_is_customer_notified" string NOT NULL OPTIONS (ANNOTATION 'Is-customer-notified flag value.', NAMEINSOURCE 'entity/comments[]/sales-data-creditmemo-comment-interface/is_customer_notified', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_comments_sales-data-creditmemo-comment-interface_is_visible_on_front" string NOT NULL OPTIONS (ANNOTATION 'Is-visible-on-storefront flag value.', NAMEINSOURCE 'entity/comments[]/sales-data-creditmemo-comment-interface/is_visible_on_front', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_comments_sales-data-creditmemo-comment-interface_parent_id" string NOT NULL OPTIONS (ANNOTATION 'Parent ID.', NAMEINSOURCE 'entity/comments[]/sales-data-creditmemo-comment-interface/parent_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_created_at string NOT NULL OPTIONS (ANNOTATION 'Credit memo created-at timestamp.', NAMEINSOURCE 'entity/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_creditmemo_status string NOT NULL OPTIONS (ANNOTATION 'Credit memo status.', NAMEINSOURCE 'entity/creditmemo_status', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_discount_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo discount amount.', NAMEINSOURCE 'entity/discount_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_discount_description string NOT NULL OPTIONS (ANNOTATION 'Credit memo discount description.', NAMEINSOURCE 'entity/discount_description', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_discount_tax_compensation_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo discount tax compensation amount.', NAMEINSOURCE 'entity/discount_tax_compensation_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_email_sent string NOT NULL OPTIONS (ANNOTATION 'Credit memo email sent flag value.', NAMEINSOURCE 'entity/email_sent', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_entity_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo ID.', NAMEINSOURCE 'entity/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_global_currency_code string NOT NULL OPTIONS (ANNOTATION 'Credit memo global currency code.', NAMEINSOURCE 'entity/global_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_grand_total string NOT NULL OPTIONS (ANNOTATION 'Credit memo grand total.', NAMEINSOURCE 'entity/grand_total', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_increment_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo increment ID.', NAMEINSOURCE 'entity/increment_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_invoice_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo invoice ID.', NAMEINSOURCE 'entity/invoice_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_additional_data" string NOT NULL OPTIONS (ANNOTATION 'Additional data.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_base_cost" string NOT NULL OPTIONS (ANNOTATION 'The base cost for a credit memo item.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/base_cost', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_base_discount_amount" string NOT NULL OPTIONS (ANNOTATION 'The base discount amount for a credit memo item.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/base_discount_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_base_discount_tax_compensation_amount" string NOT NULL OPTIONS (ANNOTATION 'The base discount tax compensation amount for a credit memo item.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/base_discount_tax_compensation_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_base_price" string NOT NULL OPTIONS (ANNOTATION 'The base price for a credit memo item.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/base_price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_base_price_incl_tax" string NOT NULL OPTIONS (ANNOTATION 'Base price including tax.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/base_price_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_base_row_total" string NOT NULL OPTIONS (ANNOTATION 'Base row total.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/base_row_total', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_base_row_total_incl_tax" string NOT NULL OPTIONS (ANNOTATION 'Base row total including tax.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/base_row_total_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_base_tax_amount" string NOT NULL OPTIONS (ANNOTATION 'Base tax amount.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/base_tax_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_base_weee_tax_applied_amount" string NOT NULL OPTIONS (ANNOTATION 'Base WEEE tax applied amount.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/base_weee_tax_applied_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_base_weee_tax_applied_row_amnt" string NOT NULL OPTIONS (ANNOTATION 'Base WEEE tax applied row amount.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/base_weee_tax_applied_row_amnt', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_base_weee_tax_disposition" string NOT NULL OPTIONS (ANNOTATION 'Base WEEE tax disposition.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/base_weee_tax_disposition', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_base_weee_tax_row_disposition" string NOT NULL OPTIONS (ANNOTATION 'Base WEEE tax row disposition.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/base_weee_tax_row_disposition', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_description" string NOT NULL OPTIONS (ANNOTATION 'Description.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/description', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_discount_amount" string NOT NULL OPTIONS (ANNOTATION 'Discount amount.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/discount_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_discount_tax_compensation_amount" string NOT NULL OPTIONS (ANNOTATION 'Discount tax compensation amount.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/discount_tax_compensation_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_entity_id" string NOT NULL OPTIONS (ANNOTATION 'Credit memo item ID.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_name" string NOT NULL OPTIONS (ANNOTATION 'Name.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_order_item_id" string NOT NULL OPTIONS (ANNOTATION 'Order item ID.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/order_item_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_parent_id" string NOT NULL OPTIONS (ANNOTATION 'Parent ID.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/parent_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_price" string NOT NULL OPTIONS (ANNOTATION 'Price.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_price_incl_tax" string NOT NULL OPTIONS (ANNOTATION 'Price including tax.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/price_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_product_id" string NOT NULL OPTIONS (ANNOTATION 'Product ID.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/product_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_qty" string NOT NULL OPTIONS (ANNOTATION 'Quantity.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_row_total" string NOT NULL OPTIONS (ANNOTATION 'Row total.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/row_total', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_row_total_incl_tax" string NOT NULL OPTIONS (ANNOTATION 'Row total including tax.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/row_total_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_sku" string NOT NULL OPTIONS (ANNOTATION 'SKU.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_tax_amount" string NOT NULL OPTIONS (ANNOTATION 'Tax amount.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/tax_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_weee_tax_applied" string NOT NULL OPTIONS (ANNOTATION 'WEEE tax applied.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/weee_tax_applied', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_weee_tax_applied_amount" string NOT NULL OPTIONS (ANNOTATION 'WEEE tax applied amount.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/weee_tax_applied_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_weee_tax_applied_row_amount" string NOT NULL OPTIONS (ANNOTATION 'WEEE tax applied row amount.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/weee_tax_applied_row_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_weee_tax_disposition" string NOT NULL OPTIONS (ANNOTATION 'WEEE tax disposition.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/weee_tax_disposition', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "entity_items_sales-data-creditmemo-item-interface_weee_tax_row_disposition" string NOT NULL OPTIONS (ANNOTATION 'WEEE tax row disposition.', NAMEINSOURCE 'entity/items[]/sales-data-creditmemo-item-interface/weee_tax_row_disposition', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_order_currency_code string NOT NULL OPTIONS (ANNOTATION 'Credit memo order currency code.', NAMEINSOURCE 'entity/order_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_order_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo order ID.', NAMEINSOURCE 'entity/order_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_shipping_address_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo shipping address ID.', NAMEINSOURCE 'entity/shipping_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_shipping_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo shipping amount.', NAMEINSOURCE 'entity/shipping_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_shipping_discount_tax_compensation_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo shipping discount tax compensation amount.', NAMEINSOURCE 'entity/shipping_discount_tax_compensation_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_shipping_incl_tax string NOT NULL OPTIONS (ANNOTATION 'Credit memo shipping including tax.', NAMEINSOURCE 'entity/shipping_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_shipping_tax_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo shipping tax amount.', NAMEINSOURCE 'entity/shipping_tax_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_state string NOT NULL OPTIONS (ANNOTATION 'Credit memo state.', NAMEINSOURCE 'entity/state', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_store_currency_code string NOT NULL OPTIONS (ANNOTATION 'Credit memo store currency code.', NAMEINSOURCE 'entity/store_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_store_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo store ID.', NAMEINSOURCE 'entity/store_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_store_to_base_rate string NOT NULL OPTIONS (ANNOTATION 'Credit memo store-to-base rate.', NAMEINSOURCE 'entity/store_to_base_rate', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_store_to_order_rate string NOT NULL OPTIONS (ANNOTATION 'Credit memo store-to-order rate.', NAMEINSOURCE 'entity/store_to_order_rate', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_subtotal string NOT NULL OPTIONS (ANNOTATION 'Credit memo subtotal.', NAMEINSOURCE 'entity/subtotal', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_subtotal_incl_tax string NOT NULL OPTIONS (ANNOTATION 'Credit memo subtotal including tax.', NAMEINSOURCE 'entity/subtotal_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_tax_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo tax amount.', NAMEINSOURCE 'entity/tax_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_transaction_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo transaction ID.', NAMEINSOURCE 'entity/transaction_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_updated_at string NOT NULL OPTIONS (ANNOTATION 'Credit memo updated-at timestamp.', NAMEINSOURCE 'entity/updated_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (adjustment string, adjustment_negative string, adjustment_positive string, base_adjustment string, base_adjustment_negative string, base_adjustment_positive string, base_currency_code string, base_discount_amount string, base_discount_tax_compensation_amount string, base_grand_total string, base_shipping_amount string, base_shipping_discount_tax_compensation_amnt string, base_shipping_incl_tax string, base_shipping_tax_amount string, base_subtotal string, base_subtotal_incl_tax string, base_tax_amount string, base_to_global_rate string, base_to_order_rate string, billing_address_id string, "comments_sales-data-creditmemo-comment-interface_comment" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/comment'), "comments_sales-data-creditmemo-comment-interface_created_at" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/created_at'), "comments_sales-data-creditmemo-comment-interface_entity_id" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/entity_id'), "comments_sales-data-creditmemo-comment-interface_is_customer_notified" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/is_customer_notified'), "comments_sales-data-creditmemo-comment-interface_is_visible_on_front" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/is_visible_on_front'), "comments_sales-data-creditmemo-comment-interface_parent_id" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/parent_id'), created_at string, creditmemo_status string, discount_amount string, discount_description string, discount_tax_compensation_amount string, email_sent string, entity_id string, global_currency_code string, grand_total string, increment_id string, invoice_id string, "items_sales-data-creditmemo-item-interface_additional_data" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/additional_data'), "items_sales-data-creditmemo-item-interface_base_cost" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_cost'), "items_sales-data-creditmemo-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_discount_amount'), "items_sales-data-creditmemo-item-interface_base_discount_tax_compensation_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_discount_tax_compensation_amount'), "items_sales-data-creditmemo-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_price'), "items_sales-data-creditmemo-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_price_incl_tax'), "items_sales-data-creditmemo-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_row_total'), "items_sales-data-creditmemo-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_row_total_incl_tax'), "items_sales-data-creditmemo-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_tax_amount'), "items_sales-data-creditmemo-item-interface_base_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_weee_tax_applied_amount'), "items_sales-data-creditmemo-item-interface_base_weee_tax_applied_row_amnt" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_weee_tax_applied_row_amnt'), "items_sales-data-creditmemo-item-interface_base_weee_tax_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_weee_tax_disposition'), "items_sales-data-creditmemo-item-interface_base_weee_tax_row_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_weee_tax_row_disposition'), "items_sales-data-creditmemo-item-interface_description" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/description'), "items_sales-data-creditmemo-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/discount_amount'), "items_sales-data-creditmemo-item-interface_discount_tax_compensation_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/discount_tax_compensation_amount'), "items_sales-data-creditmemo-item-interface_entity_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/entity_id'), "items_sales-data-creditmemo-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/name'), "items_sales-data-creditmemo-item-interface_order_item_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/order_item_id'), "items_sales-data-creditmemo-item-interface_parent_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/parent_id'), "items_sales-data-creditmemo-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/price'), "items_sales-data-creditmemo-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/price_incl_tax'), "items_sales-data-creditmemo-item-interface_product_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/product_id'), "items_sales-data-creditmemo-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/qty'), "items_sales-data-creditmemo-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/row_total'), "items_sales-data-creditmemo-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/row_total_incl_tax'), "items_sales-data-creditmemo-item-interface_sku" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/sku'), "items_sales-data-creditmemo-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/tax_amount'), "items_sales-data-creditmemo-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_applied'), "items_sales-data-creditmemo-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_applied_amount'), "items_sales-data-creditmemo-item-interface_weee_tax_applied_row_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_applied_row_amount'), "items_sales-data-creditmemo-item-interface_weee_tax_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_disposition'), "items_sales-data-creditmemo-item-interface_weee_tax_row_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_row_disposition'), order_currency_code string, order_id string, shipping_address_id string, shipping_amount string, shipping_discount_tax_compensation_amount string, shipping_incl_tax string, shipping_tax_amount string, state string, store_currency_code string, store_id string, store_to_base_rate string, store_to_order_rate string, subtotal string, subtotal_incl_tax string, tax_amount string, transaction_id string, updated_at string)
OPTIONS (ANNOTATION 'Performs persist operations for a specified credit memo.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/creditmemo');

CREATE FOREIGN PROCEDURE salesCreditmemoManagementV1RefundPost(IN creditmemo_adjustment string NOT NULL OPTIONS (ANNOTATION 'Credit memo adjustment.', NAMEINSOURCE 'creditmemo/adjustment', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_adjustment_negative string NOT NULL OPTIONS (ANNOTATION 'Credit memo negative adjustment.', NAMEINSOURCE 'creditmemo/adjustment_negative', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_adjustment_positive string NOT NULL OPTIONS (ANNOTATION 'Credit memo positive adjustment.', NAMEINSOURCE 'creditmemo/adjustment_positive', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_adjustment string NOT NULL OPTIONS (ANNOTATION 'Credit memo base adjustment.', NAMEINSOURCE 'creditmemo/base_adjustment', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_adjustment_negative string NOT NULL OPTIONS (ANNOTATION 'Credit memo negative base adjustment.', NAMEINSOURCE 'creditmemo/base_adjustment_negative', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_adjustment_positive string NOT NULL OPTIONS (ANNOTATION 'Credit memo positive base adjustment.', NAMEINSOURCE 'creditmemo/base_adjustment_positive', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_currency_code string NOT NULL OPTIONS (ANNOTATION 'Credit memo base currency code.', NAMEINSOURCE 'creditmemo/base_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_discount_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo base discount amount.', NAMEINSOURCE 'creditmemo/base_discount_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_discount_tax_compensation_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo base discount tax compensation amount.', NAMEINSOURCE 'creditmemo/base_discount_tax_compensation_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_grand_total string NOT NULL OPTIONS (ANNOTATION 'Credit memo base grand total.', NAMEINSOURCE 'creditmemo/base_grand_total', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_shipping_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo base shipping amount.', NAMEINSOURCE 'creditmemo/base_shipping_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_shipping_discount_tax_compensation_amnt string NOT NULL OPTIONS (ANNOTATION 'Credit memo base shipping discount tax compensation amount.', NAMEINSOURCE 'creditmemo/base_shipping_discount_tax_compensation_amnt', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_shipping_incl_tax string NOT NULL OPTIONS (ANNOTATION 'Credit memo base shipping including tax.', NAMEINSOURCE 'creditmemo/base_shipping_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_shipping_tax_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo base shipping tax amount.', NAMEINSOURCE 'creditmemo/base_shipping_tax_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_subtotal string NOT NULL OPTIONS (ANNOTATION 'Credit memo base subtotal.', NAMEINSOURCE 'creditmemo/base_subtotal', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_subtotal_incl_tax string NOT NULL OPTIONS (ANNOTATION 'Credit memo base subtotal including tax.', NAMEINSOURCE 'creditmemo/base_subtotal_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_tax_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo base tax amount.', NAMEINSOURCE 'creditmemo/base_tax_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_to_global_rate string NOT NULL OPTIONS (ANNOTATION 'Credit memo base-to-global rate.', NAMEINSOURCE 'creditmemo/base_to_global_rate', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_base_to_order_rate string NOT NULL OPTIONS (ANNOTATION 'Credit memo base-to-order rate.', NAMEINSOURCE 'creditmemo/base_to_order_rate', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_billing_address_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo billing address ID.', NAMEINSOURCE 'creditmemo/billing_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_comments_sales-data-creditmemo-comment-interface_comment" string NOT NULL OPTIONS (ANNOTATION 'Comment.', NAMEINSOURCE 'creditmemo/comments[]/sales-data-creditmemo-comment-interface/comment', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_comments_sales-data-creditmemo-comment-interface_created_at" string NOT NULL OPTIONS (ANNOTATION 'Created-at timestamp.', NAMEINSOURCE 'creditmemo/comments[]/sales-data-creditmemo-comment-interface/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_comments_sales-data-creditmemo-comment-interface_entity_id" string NOT NULL OPTIONS (ANNOTATION 'Credit memo ID.', NAMEINSOURCE 'creditmemo/comments[]/sales-data-creditmemo-comment-interface/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_comments_sales-data-creditmemo-comment-interface_is_customer_notified" string NOT NULL OPTIONS (ANNOTATION 'Is-customer-notified flag value.', NAMEINSOURCE 'creditmemo/comments[]/sales-data-creditmemo-comment-interface/is_customer_notified', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_comments_sales-data-creditmemo-comment-interface_is_visible_on_front" string NOT NULL OPTIONS (ANNOTATION 'Is-visible-on-storefront flag value.', NAMEINSOURCE 'creditmemo/comments[]/sales-data-creditmemo-comment-interface/is_visible_on_front', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_comments_sales-data-creditmemo-comment-interface_parent_id" string NOT NULL OPTIONS (ANNOTATION 'Parent ID.', NAMEINSOURCE 'creditmemo/comments[]/sales-data-creditmemo-comment-interface/parent_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_created_at string NOT NULL OPTIONS (ANNOTATION 'Credit memo created-at timestamp.', NAMEINSOURCE 'creditmemo/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_creditmemo_status string NOT NULL OPTIONS (ANNOTATION 'Credit memo status.', NAMEINSOURCE 'creditmemo/creditmemo_status', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_discount_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo discount amount.', NAMEINSOURCE 'creditmemo/discount_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_discount_description string NOT NULL OPTIONS (ANNOTATION 'Credit memo discount description.', NAMEINSOURCE 'creditmemo/discount_description', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_discount_tax_compensation_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo discount tax compensation amount.', NAMEINSOURCE 'creditmemo/discount_tax_compensation_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_email_sent string NOT NULL OPTIONS (ANNOTATION 'Credit memo email sent flag value.', NAMEINSOURCE 'creditmemo/email_sent', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_entity_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo ID.', NAMEINSOURCE 'creditmemo/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_global_currency_code string NOT NULL OPTIONS (ANNOTATION 'Credit memo global currency code.', NAMEINSOURCE 'creditmemo/global_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_grand_total string NOT NULL OPTIONS (ANNOTATION 'Credit memo grand total.', NAMEINSOURCE 'creditmemo/grand_total', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_increment_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo increment ID.', NAMEINSOURCE 'creditmemo/increment_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_invoice_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo invoice ID.', NAMEINSOURCE 'creditmemo/invoice_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_additional_data" string NOT NULL OPTIONS (ANNOTATION 'Additional data.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_base_cost" string NOT NULL OPTIONS (ANNOTATION 'The base cost for a credit memo item.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/base_cost', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_base_discount_amount" string NOT NULL OPTIONS (ANNOTATION 'The base discount amount for a credit memo item.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/base_discount_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_base_discount_tax_compensation_amount" string NOT NULL OPTIONS (ANNOTATION 'The base discount tax compensation amount for a credit memo item.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/base_discount_tax_compensation_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_base_price" string NOT NULL OPTIONS (ANNOTATION 'The base price for a credit memo item.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/base_price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_base_price_incl_tax" string NOT NULL OPTIONS (ANNOTATION 'Base price including tax.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/base_price_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_base_row_total" string NOT NULL OPTIONS (ANNOTATION 'Base row total.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/base_row_total', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_base_row_total_incl_tax" string NOT NULL OPTIONS (ANNOTATION 'Base row total including tax.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/base_row_total_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_base_tax_amount" string NOT NULL OPTIONS (ANNOTATION 'Base tax amount.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/base_tax_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_base_weee_tax_applied_amount" string NOT NULL OPTIONS (ANNOTATION 'Base WEEE tax applied amount.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/base_weee_tax_applied_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_base_weee_tax_applied_row_amnt" string NOT NULL OPTIONS (ANNOTATION 'Base WEEE tax applied row amount.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/base_weee_tax_applied_row_amnt', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_base_weee_tax_disposition" string NOT NULL OPTIONS (ANNOTATION 'Base WEEE tax disposition.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/base_weee_tax_disposition', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_base_weee_tax_row_disposition" string NOT NULL OPTIONS (ANNOTATION 'Base WEEE tax row disposition.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/base_weee_tax_row_disposition', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_description" string NOT NULL OPTIONS (ANNOTATION 'Description.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/description', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_discount_amount" string NOT NULL OPTIONS (ANNOTATION 'Discount amount.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/discount_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_discount_tax_compensation_amount" string NOT NULL OPTIONS (ANNOTATION 'Discount tax compensation amount.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/discount_tax_compensation_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_entity_id" string NOT NULL OPTIONS (ANNOTATION 'Credit memo item ID.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_name" string NOT NULL OPTIONS (ANNOTATION 'Name.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_order_item_id" string NOT NULL OPTIONS (ANNOTATION 'Order item ID.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/order_item_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_parent_id" string NOT NULL OPTIONS (ANNOTATION 'Parent ID.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/parent_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_price" string NOT NULL OPTIONS (ANNOTATION 'Price.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_price_incl_tax" string NOT NULL OPTIONS (ANNOTATION 'Price including tax.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/price_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_product_id" string NOT NULL OPTIONS (ANNOTATION 'Product ID.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/product_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_qty" string NOT NULL OPTIONS (ANNOTATION 'Quantity.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_row_total" string NOT NULL OPTIONS (ANNOTATION 'Row total.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/row_total', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_row_total_incl_tax" string NOT NULL OPTIONS (ANNOTATION 'Row total including tax.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/row_total_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_sku" string NOT NULL OPTIONS (ANNOTATION 'SKU.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_tax_amount" string NOT NULL OPTIONS (ANNOTATION 'Tax amount.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/tax_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_weee_tax_applied" string NOT NULL OPTIONS (ANNOTATION 'WEEE tax applied.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/weee_tax_applied', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_weee_tax_applied_amount" string NOT NULL OPTIONS (ANNOTATION 'WEEE tax applied amount.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/weee_tax_applied_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_weee_tax_applied_row_amount" string NOT NULL OPTIONS (ANNOTATION 'WEEE tax applied row amount.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/weee_tax_applied_row_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_weee_tax_disposition" string NOT NULL OPTIONS (ANNOTATION 'WEEE tax disposition.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/weee_tax_disposition', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "creditmemo_items_sales-data-creditmemo-item-interface_weee_tax_row_disposition" string NOT NULL OPTIONS (ANNOTATION 'WEEE tax row disposition.', NAMEINSOURCE 'creditmemo/items[]/sales-data-creditmemo-item-interface/weee_tax_row_disposition', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_order_currency_code string NOT NULL OPTIONS (ANNOTATION 'Credit memo order currency code.', NAMEINSOURCE 'creditmemo/order_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_order_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo order ID.', NAMEINSOURCE 'creditmemo/order_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_shipping_address_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo shipping address ID.', NAMEINSOURCE 'creditmemo/shipping_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_shipping_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo shipping amount.', NAMEINSOURCE 'creditmemo/shipping_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_shipping_discount_tax_compensation_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo shipping discount tax compensation amount.', NAMEINSOURCE 'creditmemo/shipping_discount_tax_compensation_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_shipping_incl_tax string NOT NULL OPTIONS (ANNOTATION 'Credit memo shipping including tax.', NAMEINSOURCE 'creditmemo/shipping_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_shipping_tax_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo shipping tax amount.', NAMEINSOURCE 'creditmemo/shipping_tax_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_state string NOT NULL OPTIONS (ANNOTATION 'Credit memo state.', NAMEINSOURCE 'creditmemo/state', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_store_currency_code string NOT NULL OPTIONS (ANNOTATION 'Credit memo store currency code.', NAMEINSOURCE 'creditmemo/store_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_store_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo store ID.', NAMEINSOURCE 'creditmemo/store_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_store_to_base_rate string NOT NULL OPTIONS (ANNOTATION 'Credit memo store-to-base rate.', NAMEINSOURCE 'creditmemo/store_to_base_rate', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_store_to_order_rate string NOT NULL OPTIONS (ANNOTATION 'Credit memo store-to-order rate.', NAMEINSOURCE 'creditmemo/store_to_order_rate', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_subtotal string NOT NULL OPTIONS (ANNOTATION 'Credit memo subtotal.', NAMEINSOURCE 'creditmemo/subtotal', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_subtotal_incl_tax string NOT NULL OPTIONS (ANNOTATION 'Credit memo subtotal including tax.', NAMEINSOURCE 'creditmemo/subtotal_incl_tax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_tax_amount string NOT NULL OPTIONS (ANNOTATION 'Credit memo tax amount.', NAMEINSOURCE 'creditmemo/tax_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_transaction_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo transaction ID.', NAMEINSOURCE 'creditmemo/transaction_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN creditmemo_updated_at string NOT NULL OPTIONS (ANNOTATION 'Credit memo updated-at timestamp.', NAMEINSOURCE 'creditmemo/updated_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN offlineRequested boolean NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (adjustment string, adjustment_negative string, adjustment_positive string, base_adjustment string, base_adjustment_negative string, base_adjustment_positive string, base_currency_code string, base_discount_amount string, base_discount_tax_compensation_amount string, base_grand_total string, base_shipping_amount string, base_shipping_discount_tax_compensation_amnt string, base_shipping_incl_tax string, base_shipping_tax_amount string, base_subtotal string, base_subtotal_incl_tax string, base_tax_amount string, base_to_global_rate string, base_to_order_rate string, billing_address_id string, "comments_sales-data-creditmemo-comment-interface_comment" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/comment'), "comments_sales-data-creditmemo-comment-interface_created_at" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/created_at'), "comments_sales-data-creditmemo-comment-interface_entity_id" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/entity_id'), "comments_sales-data-creditmemo-comment-interface_is_customer_notified" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/is_customer_notified'), "comments_sales-data-creditmemo-comment-interface_is_visible_on_front" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/is_visible_on_front'), "comments_sales-data-creditmemo-comment-interface_parent_id" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/parent_id'), created_at string, creditmemo_status string, discount_amount string, discount_description string, discount_tax_compensation_amount string, email_sent string, entity_id string, global_currency_code string, grand_total string, increment_id string, invoice_id string, "items_sales-data-creditmemo-item-interface_additional_data" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/additional_data'), "items_sales-data-creditmemo-item-interface_base_cost" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_cost'), "items_sales-data-creditmemo-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_discount_amount'), "items_sales-data-creditmemo-item-interface_base_discount_tax_compensation_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_discount_tax_compensation_amount'), "items_sales-data-creditmemo-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_price'), "items_sales-data-creditmemo-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_price_incl_tax'), "items_sales-data-creditmemo-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_row_total'), "items_sales-data-creditmemo-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_row_total_incl_tax'), "items_sales-data-creditmemo-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_tax_amount'), "items_sales-data-creditmemo-item-interface_base_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_weee_tax_applied_amount'), "items_sales-data-creditmemo-item-interface_base_weee_tax_applied_row_amnt" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_weee_tax_applied_row_amnt'), "items_sales-data-creditmemo-item-interface_base_weee_tax_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_weee_tax_disposition'), "items_sales-data-creditmemo-item-interface_base_weee_tax_row_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_weee_tax_row_disposition'), "items_sales-data-creditmemo-item-interface_description" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/description'), "items_sales-data-creditmemo-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/discount_amount'), "items_sales-data-creditmemo-item-interface_discount_tax_compensation_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/discount_tax_compensation_amount'), "items_sales-data-creditmemo-item-interface_entity_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/entity_id'), "items_sales-data-creditmemo-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/name'), "items_sales-data-creditmemo-item-interface_order_item_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/order_item_id'), "items_sales-data-creditmemo-item-interface_parent_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/parent_id'), "items_sales-data-creditmemo-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/price'), "items_sales-data-creditmemo-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/price_incl_tax'), "items_sales-data-creditmemo-item-interface_product_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/product_id'), "items_sales-data-creditmemo-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/qty'), "items_sales-data-creditmemo-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/row_total'), "items_sales-data-creditmemo-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/row_total_incl_tax'), "items_sales-data-creditmemo-item-interface_sku" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/sku'), "items_sales-data-creditmemo-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/tax_amount'), "items_sales-data-creditmemo-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_applied'), "items_sales-data-creditmemo-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_applied_amount'), "items_sales-data-creditmemo-item-interface_weee_tax_applied_row_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_applied_row_amount'), "items_sales-data-creditmemo-item-interface_weee_tax_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_disposition'), "items_sales-data-creditmemo-item-interface_weee_tax_row_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_row_disposition'), order_currency_code string, order_id string, shipping_address_id string, shipping_amount string, shipping_discount_tax_compensation_amount string, shipping_incl_tax string, shipping_tax_amount string, state string, store_currency_code string, store_id string, store_to_base_rate string, store_to_order_rate string, subtotal string, subtotal_incl_tax string, tax_amount string, transaction_id string, updated_at string)
OPTIONS (ANNOTATION 'Prepare creditmemo to refund and save it.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/creditmemo/refund');

CREATE FOREIGN PROCEDURE salesCreditmemoRepositoryV1GetGet(IN id string NOT NULL OPTIONS (ANNOTATION 'The credit memo ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (adjustment string, adjustment_negative string, adjustment_positive string, base_adjustment string, base_adjustment_negative string, base_adjustment_positive string, base_currency_code string, base_discount_amount string, base_discount_tax_compensation_amount string, base_grand_total string, base_shipping_amount string, base_shipping_discount_tax_compensation_amnt string, base_shipping_incl_tax string, base_shipping_tax_amount string, base_subtotal string, base_subtotal_incl_tax string, base_tax_amount string, base_to_global_rate string, base_to_order_rate string, billing_address_id string, "comments_sales-data-creditmemo-comment-interface_comment" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/comment'), "comments_sales-data-creditmemo-comment-interface_created_at" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/created_at'), "comments_sales-data-creditmemo-comment-interface_entity_id" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/entity_id'), "comments_sales-data-creditmemo-comment-interface_is_customer_notified" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/is_customer_notified'), "comments_sales-data-creditmemo-comment-interface_is_visible_on_front" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/is_visible_on_front'), "comments_sales-data-creditmemo-comment-interface_parent_id" string OPTIONS (NAMEINSOURCE 'comments[]/sales-data-creditmemo-comment-interface/parent_id'), created_at string, creditmemo_status string, discount_amount string, discount_description string, discount_tax_compensation_amount string, email_sent string, entity_id string, global_currency_code string, grand_total string, increment_id string, invoice_id string, "items_sales-data-creditmemo-item-interface_additional_data" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/additional_data'), "items_sales-data-creditmemo-item-interface_base_cost" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_cost'), "items_sales-data-creditmemo-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_discount_amount'), "items_sales-data-creditmemo-item-interface_base_discount_tax_compensation_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_discount_tax_compensation_amount'), "items_sales-data-creditmemo-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_price'), "items_sales-data-creditmemo-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_price_incl_tax'), "items_sales-data-creditmemo-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_row_total'), "items_sales-data-creditmemo-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_row_total_incl_tax'), "items_sales-data-creditmemo-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_tax_amount'), "items_sales-data-creditmemo-item-interface_base_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_weee_tax_applied_amount'), "items_sales-data-creditmemo-item-interface_base_weee_tax_applied_row_amnt" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_weee_tax_applied_row_amnt'), "items_sales-data-creditmemo-item-interface_base_weee_tax_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_weee_tax_disposition'), "items_sales-data-creditmemo-item-interface_base_weee_tax_row_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/base_weee_tax_row_disposition'), "items_sales-data-creditmemo-item-interface_description" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/description'), "items_sales-data-creditmemo-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/discount_amount'), "items_sales-data-creditmemo-item-interface_discount_tax_compensation_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/discount_tax_compensation_amount'), "items_sales-data-creditmemo-item-interface_entity_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/entity_id'), "items_sales-data-creditmemo-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/name'), "items_sales-data-creditmemo-item-interface_order_item_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/order_item_id'), "items_sales-data-creditmemo-item-interface_parent_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/parent_id'), "items_sales-data-creditmemo-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/price'), "items_sales-data-creditmemo-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/price_incl_tax'), "items_sales-data-creditmemo-item-interface_product_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/product_id'), "items_sales-data-creditmemo-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/qty'), "items_sales-data-creditmemo-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/row_total'), "items_sales-data-creditmemo-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/row_total_incl_tax'), "items_sales-data-creditmemo-item-interface_sku" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/sku'), "items_sales-data-creditmemo-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/tax_amount'), "items_sales-data-creditmemo-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_applied'), "items_sales-data-creditmemo-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_applied_amount'), "items_sales-data-creditmemo-item-interface_weee_tax_applied_row_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_applied_row_amount'), "items_sales-data-creditmemo-item-interface_weee_tax_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_disposition'), "items_sales-data-creditmemo-item-interface_weee_tax_row_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-item-interface/weee_tax_row_disposition'), order_currency_code string, order_id string, shipping_address_id string, shipping_amount string, shipping_discount_tax_compensation_amount string, shipping_incl_tax string, shipping_tax_amount string, state string, store_currency_code string, store_id string, store_to_base_rate string, store_to_order_rate string, subtotal string, subtotal_incl_tax string, tax_amount string, transaction_id string, updated_at string)
OPTIONS (ANNOTATION 'Loads a specified credit memo.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/creditmemo/{id}');

CREATE FOREIGN PROCEDURE salesCreditmemoManagementV1CancelPut(OUT "return" boolean RESULT, IN id string NOT NULL OPTIONS (ANNOTATION 'The credit memo ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Cancels a specified credit memo.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/creditmemo/{id}');

CREATE FOREIGN PROCEDURE salesCreditmemoManagementV1GetCommentsListGet(IN id string NOT NULL OPTIONS (ANNOTATION 'The credit memo ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE ("items_sales-data-creditmemo-comment-interface_comment" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-comment-interface/comment'), "items_sales-data-creditmemo-comment-interface_created_at" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-comment-interface/created_at'), "items_sales-data-creditmemo-comment-interface_entity_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-comment-interface/entity_id'), "items_sales-data-creditmemo-comment-interface_is_customer_notified" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-comment-interface/is_customer_notified'), "items_sales-data-creditmemo-comment-interface_is_visible_on_front" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-comment-interface/is_visible_on_front'), "items_sales-data-creditmemo-comment-interface_parent_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-comment-interface/parent_id'), search_criteria_current_page string OPTIONS (NAMEINSOURCE 'search_criteria/current_page'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_condition_type" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/condition_type'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_field" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/field'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_value" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/value'), search_criteria_page_size string OPTIONS (NAMEINSOURCE 'search_criteria/page_size'), "search_criteria_sort_orders_framework-sort-order_direction" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/direction'), "search_criteria_sort_orders_framework-sort-order_field" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/field'), total_count string)
OPTIONS (ANNOTATION 'Lists comments for a specified credit memo.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/creditmemo/{id}/comments');

CREATE FOREIGN PROCEDURE salesCreditmemoCommentRepositoryV1SavePost(IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN entity_comment string NOT NULL OPTIONS (ANNOTATION 'Comment.', NAMEINSOURCE 'entity/comment', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_created_at string NOT NULL OPTIONS (ANNOTATION 'Created-at timestamp.', NAMEINSOURCE 'entity/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_entity_id string NOT NULL OPTIONS (ANNOTATION 'Credit memo ID.', NAMEINSOURCE 'entity/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_is_customer_notified string NOT NULL OPTIONS (ANNOTATION 'Is-customer-notified flag value.', NAMEINSOURCE 'entity/is_customer_notified', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_is_visible_on_front string NOT NULL OPTIONS (ANNOTATION 'Is-visible-on-storefront flag value.', NAMEINSOURCE 'entity/is_visible_on_front', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entity_parent_id string NOT NULL OPTIONS (ANNOTATION 'Parent ID.', NAMEINSOURCE 'entity/parent_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (comment string, created_at string, entity_id string, is_customer_notified string, is_visible_on_front string, parent_id string)
OPTIONS (ANNOTATION 'Performs persist operations for a specified entity.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/creditmemo/{id}/comments');

CREATE FOREIGN PROCEDURE salesCreditmemoManagementV1NotifyPost(OUT "return" boolean RESULT, IN id string NOT NULL OPTIONS (ANNOTATION 'The credit memo ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Emails a user a specified credit memo.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/creditmemo/{id}/emails');

CREATE FOREIGN PROCEDURE salesCreditmemoRepositoryV1GetListGet(IN "searchCriteria[filterGroups][][filters][][field]" string NOT NULL OPTIONS (ANNOTATION 'Field', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][value]" string NOT NULL OPTIONS (ANNOTATION 'Value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][conditionType]" string NOT NULL OPTIONS (ANNOTATION 'Condition type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][field]" string NOT NULL OPTIONS (ANNOTATION 'Sorting field.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][direction]" string NOT NULL OPTIONS (ANNOTATION 'Sorting direction.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[pageSize]" string NOT NULL OPTIONS (ANNOTATION 'Page size.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[currentPage]" string NOT NULL OPTIONS (ANNOTATION 'Current page.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE ("items_sales-data-creditmemo-interface_adjustment" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/adjustment'), "items_sales-data-creditmemo-interface_adjustment_negative" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/adjustment_negative'), "items_sales-data-creditmemo-interface_adjustment_positive" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/adjustment_positive'), "items_sales-data-creditmemo-interface_base_adjustment" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_adjustment'), "items_sales-data-creditmemo-interface_base_adjustment_negative" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_adjustment_negative'), "items_sales-data-creditmemo-interface_base_adjustment_positive" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_adjustment_positive'), "items_sales-data-creditmemo-interface_base_currency_code" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_currency_code'), "items_sales-data-creditmemo-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_discount_amount'), "items_sales-data-creditmemo-interface_base_discount_tax_compensation_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_discount_tax_compensation_amount'), "items_sales-data-creditmemo-interface_base_grand_total" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_grand_total'), "items_sales-data-creditmemo-interface_base_shipping_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_shipping_amount'), "items_sales-data-creditmemo-interface_base_shipping_discount_tax_compensation_amnt" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_shipping_discount_tax_compensation_amnt'), "items_sales-data-creditmemo-interface_base_shipping_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_shipping_incl_tax'), "items_sales-data-creditmemo-interface_base_shipping_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_shipping_tax_amount'), "items_sales-data-creditmemo-interface_base_subtotal" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_subtotal'), "items_sales-data-creditmemo-interface_base_subtotal_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_subtotal_incl_tax'), "items_sales-data-creditmemo-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_tax_amount'), "items_sales-data-creditmemo-interface_base_to_global_rate" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_to_global_rate'), "items_sales-data-creditmemo-interface_base_to_order_rate" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/base_to_order_rate'), "items_sales-data-creditmemo-interface_billing_address_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/billing_address_id'), "items_sales-data-creditmemo-interface_comments_sales-data-creditmemo-comment-interface_comment" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/comments[]/sales-data-creditmemo-comment-interface/comment'), "items_sales-data-creditmemo-interface_comments_sales-data-creditmemo-comment-interface_created_at" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/comments[]/sales-data-creditmemo-comment-interface/created_at'), "items_sales-data-creditmemo-interface_comments_sales-data-creditmemo-comment-interface_entity_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/comments[]/sales-data-creditmemo-comment-interface/entity_id'), "items_sales-data-creditmemo-interface_comments_sales-data-creditmemo-comment-interface_is_customer_notified" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/comments[]/sales-data-creditmemo-comment-interface/is_customer_notified'), "items_sales-data-creditmemo-interface_comments_sales-data-creditmemo-comment-interface_is_visible_on_front" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/comments[]/sales-data-creditmemo-comment-interface/is_visible_on_front'), "items_sales-data-creditmemo-interface_comments_sales-data-creditmemo-comment-interface_parent_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/comments[]/sales-data-creditmemo-comment-interface/parent_id'), "items_sales-data-creditmemo-interface_created_at" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/created_at'), "items_sales-data-creditmemo-interface_creditmemo_status" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/creditmemo_status'), "items_sales-data-creditmemo-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/discount_amount'), "items_sales-data-creditmemo-interface_discount_description" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/discount_description'), "items_sales-data-creditmemo-interface_discount_tax_compensation_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/discount_tax_compensation_amount'), "items_sales-data-creditmemo-interface_email_sent" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/email_sent'), "items_sales-data-creditmemo-interface_entity_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/entity_id'), "items_sales-data-creditmemo-interface_global_currency_code" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/global_currency_code'), "items_sales-data-creditmemo-interface_grand_total" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/grand_total'), "items_sales-data-creditmemo-interface_increment_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/increment_id'), "items_sales-data-creditmemo-interface_invoice_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/invoice_id'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_additional_data" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/additional_data'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_base_cost" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/base_cost'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/base_discount_amount'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_base_discount_tax_compensation_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/base_discount_tax_compensation_amount'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/base_price'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/base_price_incl_tax'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/base_row_total'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/base_row_total_incl_tax'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/base_tax_amount'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_base_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/base_weee_tax_applied_amount'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_base_weee_tax_applied_row_amnt" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/base_weee_tax_applied_row_amnt'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_base_weee_tax_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/base_weee_tax_disposition'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_base_weee_tax_row_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/base_weee_tax_row_disposition'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_description" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/description'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/discount_amount'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_discount_tax_compensation_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/discount_tax_compensation_amount'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_entity_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/entity_id'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/name'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_order_item_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/order_item_id'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_parent_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/parent_id'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/price'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/price_incl_tax'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_product_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/product_id'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/qty'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/row_total'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/row_total_incl_tax'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_sku" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/sku'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/tax_amount'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/weee_tax_applied'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/weee_tax_applied_amount'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_weee_tax_applied_row_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/weee_tax_applied_row_amount'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_weee_tax_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/weee_tax_disposition'), "items_sales-data-creditmemo-interface_items_sales-data-creditmemo-item-interface_weee_tax_row_disposition" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/items[]/sales-data-creditmemo-item-interface/weee_tax_row_disposition'), "items_sales-data-creditmemo-interface_order_currency_code" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/order_currency_code'), "items_sales-data-creditmemo-interface_order_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/order_id'), "items_sales-data-creditmemo-interface_shipping_address_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/shipping_address_id'), "items_sales-data-creditmemo-interface_shipping_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/shipping_amount'), "items_sales-data-creditmemo-interface_shipping_discount_tax_compensation_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/shipping_discount_tax_compensation_amount'), "items_sales-data-creditmemo-interface_shipping_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/shipping_incl_tax'), "items_sales-data-creditmemo-interface_shipping_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/shipping_tax_amount'), "items_sales-data-creditmemo-interface_state" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/state'), "items_sales-data-creditmemo-interface_store_currency_code" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/store_currency_code'), "items_sales-data-creditmemo-interface_store_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/store_id'), "items_sales-data-creditmemo-interface_store_to_base_rate" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/store_to_base_rate'), "items_sales-data-creditmemo-interface_store_to_order_rate" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/store_to_order_rate'), "items_sales-data-creditmemo-interface_subtotal" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/subtotal'), "items_sales-data-creditmemo-interface_subtotal_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/subtotal_incl_tax'), "items_sales-data-creditmemo-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/tax_amount'), "items_sales-data-creditmemo-interface_transaction_id" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/transaction_id'), "items_sales-data-creditmemo-interface_updated_at" string OPTIONS (NAMEINSOURCE 'items[]/sales-data-creditmemo-interface/updated_at'), search_criteria_current_page string OPTIONS (NAMEINSOURCE 'search_criteria/current_page'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_condition_type" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/condition_type'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_field" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/field'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_value" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/value'), search_criteria_page_size string OPTIONS (NAMEINSOURCE 'search_criteria/page_size'), "search_criteria_sort_orders_framework-sort-order_direction" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/direction'), "search_criteria_sort_orders_framework-sort-order_field" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/field'), total_count string)
OPTIONS (ANNOTATION 'Lists credit memos that match specified search criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#CreditmemoRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/creditmemos');

CREATE FOREIGN PROCEDURE customerGroupRepositoryV1SavePost(IN group_code string NOT NULL OPTIONS (ANNOTATION 'Code', NAMEINSOURCE 'group/code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN group_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'group/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN group_tax_class_id string NOT NULL OPTIONS (ANNOTATION 'Tax class id', NAMEINSOURCE 'group/tax_class_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN group_tax_class_name string NOT NULL OPTIONS (ANNOTATION 'Tax class name', NAMEINSOURCE 'group/tax_class_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, id string, tax_class_id string, tax_class_name string)
OPTIONS (ANNOTATION 'Save customer group.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customerGroups');

CREATE FOREIGN PROCEDURE "V1/customerGroups/default"(IN storeId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (code string, id string, tax_class_id string, tax_class_name string)
OPTIONS (ANNOTATION 'Get default customer group.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customerGroups/default');

CREATE FOREIGN PROCEDURE "V1/customerGroups/default/storeId"(IN storeId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, id string, tax_class_id string, tax_class_name string)
OPTIONS (ANNOTATION 'Get default customer group.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customerGroups/default/{storeId}');

CREATE FOREIGN PROCEDURE customerGroupRepositoryV1GetListGet(IN "searchCriteria[filterGroups][][filters][][field]" string NOT NULL OPTIONS (ANNOTATION 'Field', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][value]" string NOT NULL OPTIONS (ANNOTATION 'Value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][conditionType]" string NOT NULL OPTIONS (ANNOTATION 'Condition type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][field]" string NOT NULL OPTIONS (ANNOTATION 'Sorting field.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][direction]" string NOT NULL OPTIONS (ANNOTATION 'Sorting direction.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[pageSize]" string NOT NULL OPTIONS (ANNOTATION 'Page size.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[currentPage]" string NOT NULL OPTIONS (ANNOTATION 'Current page.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE ("items_customer-data-group-interface_code" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-group-interface/code'), "items_customer-data-group-interface_id" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-group-interface/id'), "items_customer-data-group-interface_tax_class_id" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-group-interface/tax_class_id'), "items_customer-data-group-interface_tax_class_name" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-group-interface/tax_class_name'), search_criteria_current_page string OPTIONS (NAMEINSOURCE 'search_criteria/current_page'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_condition_type" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/condition_type'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_field" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/field'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_value" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/value'), search_criteria_page_size string OPTIONS (NAMEINSOURCE 'search_criteria/page_size'), "search_criteria_sort_orders_framework-sort-order_direction" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/direction'), "search_criteria_sort_orders_framework-sort-order_field" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/field'), total_count string)
OPTIONS (ANNOTATION 'Retrieve customer groups. The list of groups can be filtered to exclude the NOT_LOGGED_IN group using the first parameter and/or it can be filtered by tax class. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#GroupRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customerGroups/search');

CREATE FOREIGN PROCEDURE customerGroupRepositoryV1GetByIdGet(IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, id string, tax_class_id string, tax_class_name string)
OPTIONS (ANNOTATION 'Get customer group by group ID.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customerGroups/{id}');

CREATE FOREIGN PROCEDURE customerGroupRepositoryV1SavePut(IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN group_code string NOT NULL OPTIONS (ANNOTATION 'Code', NAMEINSOURCE 'group/code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN group_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'group/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN group_tax_class_id string NOT NULL OPTIONS (ANNOTATION 'Tax class id', NAMEINSOURCE 'group/tax_class_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN group_tax_class_name string NOT NULL OPTIONS (ANNOTATION 'Tax class name', NAMEINSOURCE 'group/tax_class_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, id string, tax_class_id string, tax_class_name string)
OPTIONS (ANNOTATION 'Save customer group.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customerGroups/{id}');

CREATE FOREIGN PROCEDURE customerGroupRepositoryV1DeleteByIdDelete(OUT "return" boolean RESULT, IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Delete customer group by ID.', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customerGroups/{id}');

CREATE FOREIGN PROCEDURE customerGroupManagementV1IsReadonlyGet(OUT "return" boolean RESULT, IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Check if customer group can be deleted.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customerGroups/{id}/permissions');

CREATE FOREIGN PROCEDURE customerAccountManagementV1CreateAccountPost(IN "customer_addresses_customer-data-address-interface_city" string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_company" string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_country_id" string NOT NULL OPTIONS (ANNOTATION 'Country code in ISO_3166-2 format', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_customer_id" string NOT NULL OPTIONS (ANNOTATION 'Customer ID', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_default_billing" boolean NOT NULL OPTIONS (ANNOTATION 'If this address is default billing address', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_default_shipping" boolean NOT NULL OPTIONS (ANNOTATION 'If this address is default shipping address.', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_shipping', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_fax" string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_firstname" string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_id" string NOT NULL OPTIONS (ANNOTATION 'ID', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_lastname" string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_middlename" string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_postcode" string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_prefix" string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_region" string NOT NULL OPTIONS (ANNOTATION 'Region', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_region_code" string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_region_id" string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_id" string NOT NULL OPTIONS (ANNOTATION 'Region ID', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_street" string[] NOT NULL OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_suffix" string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_telephone" string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_vat_id" string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_confirmation string NOT NULL OPTIONS (ANNOTATION 'Confirmation', NAMEINSOURCE 'customer/confirmation', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_created_at string NOT NULL OPTIONS (ANNOTATION 'Created at time', NAMEINSOURCE 'customer/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_created_in string NOT NULL OPTIONS (ANNOTATION 'Created in area', NAMEINSOURCE 'customer/created_in', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_default_billing string NOT NULL OPTIONS (ANNOTATION 'Default billing address id', NAMEINSOURCE 'customer/default_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_default_shipping string NOT NULL OPTIONS (ANNOTATION 'Default shipping address id', NAMEINSOURCE 'customer/default_shipping', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_disable_auto_group_change string NOT NULL OPTIONS (ANNOTATION 'Disable auto group change flag.', NAMEINSOURCE 'customer/disable_auto_group_change', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_dob string NOT NULL OPTIONS (ANNOTATION 'Date of birth', NAMEINSOURCE 'customer/dob', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_email string NOT NULL OPTIONS (ANNOTATION 'Email address', NAMEINSOURCE 'customer/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_extension_attributes_is_subscribed boolean NOT NULL OPTIONS (NAMEINSOURCE 'customer/extension_attributes/is_subscribed', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'customer/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_gender string NOT NULL OPTIONS (ANNOTATION 'Gender', NAMEINSOURCE 'customer/gender', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_group_id string NOT NULL OPTIONS (ANNOTATION 'Group id', NAMEINSOURCE 'customer/group_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'customer/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'customer/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'customer/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'customer/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_store_id string NOT NULL OPTIONS (ANNOTATION 'Store id', NAMEINSOURCE 'customer/store_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'customer/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_taxvat string NOT NULL OPTIONS (ANNOTATION 'Tax Vat', NAMEINSOURCE 'customer/taxvat', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_updated_at string NOT NULL OPTIONS (ANNOTATION 'Updated at time', NAMEINSOURCE 'customer/updated_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_website_id string NOT NULL OPTIONS (ANNOTATION 'Website id', NAMEINSOURCE 'customer/website_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN password string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN redirectUrl string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE ("addresses_customer-data-address-interface_city" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/city'), "addresses_customer-data-address-interface_company" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/company'), "addresses_customer-data-address-interface_country_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/country_id'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value'), "addresses_customer-data-address-interface_customer_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/customer_id'), "addresses_customer-data-address-interface_default_billing" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_billing'), "addresses_customer-data-address-interface_default_shipping" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_shipping'), "addresses_customer-data-address-interface_fax" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/fax'), "addresses_customer-data-address-interface_firstname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/firstname'), "addresses_customer-data-address-interface_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/id'), "addresses_customer-data-address-interface_lastname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/lastname'), "addresses_customer-data-address-interface_middlename" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/middlename'), "addresses_customer-data-address-interface_postcode" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/postcode'), "addresses_customer-data-address-interface_prefix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/prefix'), "addresses_customer-data-address-interface_region_region" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region'), "addresses_customer-data-address-interface_region_region_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_code'), "addresses_customer-data-address-interface_region_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_id'), "addresses_customer-data-address-interface_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region_id'), "addresses_customer-data-address-interface_street" string[] OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/street'), "addresses_customer-data-address-interface_suffix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/suffix'), "addresses_customer-data-address-interface_telephone" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/telephone'), "addresses_customer-data-address-interface_vat_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/vat_id'), confirmation string, created_at string, created_in string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), default_billing string, default_shipping string, disable_auto_group_change string, dob string, email string, extension_attributes_is_subscribed boolean OPTIONS (NAMEINSOURCE 'extension_attributes/is_subscribed'), firstname string, gender string, group_id string, id string, lastname string, middlename string, prefix string, store_id string, suffix string, taxvat string, updated_at string, website_id string)
OPTIONS (ANNOTATION 'Create customer account. Perform necessary business operations like sending email.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers');

CREATE FOREIGN PROCEDURE customerAddressRepositoryV1GetByIdGet(IN addressId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (city string, company string, country_id string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), customer_id string, default_billing boolean, default_shipping boolean, fax string, firstname string, id string, lastname string, middlename string, postcode string, prefix string, region_region string OPTIONS (NAMEINSOURCE 'region/region'), region_region_code string OPTIONS (NAMEINSOURCE 'region/region_code'), region_region_id string OPTIONS (NAMEINSOURCE 'region/region_id'), region_id string, street string[], suffix string, telephone string, vat_id string)
OPTIONS (ANNOTATION 'Retrieve customer address.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/addresses/{addressId}');

CREATE FOREIGN PROCEDURE customerAccountManagementV1ResendConfirmationPost(OUT "return" boolean RESULT, IN email string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN redirectUrl string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN websiteId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Resend confirmation email.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/confirm');

CREATE FOREIGN PROCEDURE customerAccountManagementV1IsEmailAvailablePost(OUT "return" boolean RESULT, IN customerEmail string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN websiteId string NOT NULL OPTIONS (ANNOTATION 'If not set, will use the current websiteId', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Check if given email is associated with a customer account in given website.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/isEmailAvailable');

CREATE FOREIGN PROCEDURE "V1/customers/me_GET"() RETURNS TABLE ("addresses_customer-data-address-interface_city" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/city'), "addresses_customer-data-address-interface_company" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/company'), "addresses_customer-data-address-interface_country_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/country_id'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value'), "addresses_customer-data-address-interface_customer_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/customer_id'), "addresses_customer-data-address-interface_default_billing" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_billing'), "addresses_customer-data-address-interface_default_shipping" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_shipping'), "addresses_customer-data-address-interface_fax" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/fax'), "addresses_customer-data-address-interface_firstname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/firstname'), "addresses_customer-data-address-interface_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/id'), "addresses_customer-data-address-interface_lastname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/lastname'), "addresses_customer-data-address-interface_middlename" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/middlename'), "addresses_customer-data-address-interface_postcode" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/postcode'), "addresses_customer-data-address-interface_prefix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/prefix'), "addresses_customer-data-address-interface_region_region" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region'), "addresses_customer-data-address-interface_region_region_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_code'), "addresses_customer-data-address-interface_region_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_id'), "addresses_customer-data-address-interface_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region_id'), "addresses_customer-data-address-interface_street" string[] OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/street'), "addresses_customer-data-address-interface_suffix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/suffix'), "addresses_customer-data-address-interface_telephone" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/telephone'), "addresses_customer-data-address-interface_vat_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/vat_id'), confirmation string, created_at string, created_in string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), default_billing string, default_shipping string, disable_auto_group_change string, dob string, email string, extension_attributes_is_subscribed boolean OPTIONS (NAMEINSOURCE 'extension_attributes/is_subscribed'), firstname string, gender string, group_id string, id string, lastname string, middlename string, prefix string, store_id string, suffix string, taxvat string, updated_at string, website_id string)
OPTIONS (ANNOTATION 'Get customer by customer ID.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/me');

CREATE FOREIGN PROCEDURE "V1/customers/me_PUT"(IN "customer_addresses_customer-data-address-interface_city" string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_company" string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_country_id" string NOT NULL OPTIONS (ANNOTATION 'Country code in ISO_3166-2 format', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_customer_id" string NOT NULL OPTIONS (ANNOTATION 'Customer ID', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_default_billing" boolean NOT NULL OPTIONS (ANNOTATION 'If this address is default billing address', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_default_shipping" boolean NOT NULL OPTIONS (ANNOTATION 'If this address is default shipping address.', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_shipping', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_fax" string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_firstname" string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_id" string NOT NULL OPTIONS (ANNOTATION 'ID', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_lastname" string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_middlename" string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_postcode" string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_prefix" string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_region" string NOT NULL OPTIONS (ANNOTATION 'Region', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_region_code" string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_region_id" string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_id" string NOT NULL OPTIONS (ANNOTATION 'Region ID', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_street" string[] NOT NULL OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_suffix" string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_telephone" string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_vat_id" string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_confirmation string NOT NULL OPTIONS (ANNOTATION 'Confirmation', NAMEINSOURCE 'customer/confirmation', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_created_at string NOT NULL OPTIONS (ANNOTATION 'Created at time', NAMEINSOURCE 'customer/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_created_in string NOT NULL OPTIONS (ANNOTATION 'Created in area', NAMEINSOURCE 'customer/created_in', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_default_billing string NOT NULL OPTIONS (ANNOTATION 'Default billing address id', NAMEINSOURCE 'customer/default_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_default_shipping string NOT NULL OPTIONS (ANNOTATION 'Default shipping address id', NAMEINSOURCE 'customer/default_shipping', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_disable_auto_group_change string NOT NULL OPTIONS (ANNOTATION 'Disable auto group change flag.', NAMEINSOURCE 'customer/disable_auto_group_change', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_dob string NOT NULL OPTIONS (ANNOTATION 'Date of birth', NAMEINSOURCE 'customer/dob', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_email string NOT NULL OPTIONS (ANNOTATION 'Email address', NAMEINSOURCE 'customer/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_extension_attributes_is_subscribed boolean NOT NULL OPTIONS (NAMEINSOURCE 'customer/extension_attributes/is_subscribed', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'customer/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_gender string NOT NULL OPTIONS (ANNOTATION 'Gender', NAMEINSOURCE 'customer/gender', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_group_id string NOT NULL OPTIONS (ANNOTATION 'Group id', NAMEINSOURCE 'customer/group_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'customer/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'customer/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'customer/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'customer/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_store_id string NOT NULL OPTIONS (ANNOTATION 'Store id', NAMEINSOURCE 'customer/store_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'customer/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_taxvat string NOT NULL OPTIONS (ANNOTATION 'Tax Vat', NAMEINSOURCE 'customer/taxvat', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_updated_at string NOT NULL OPTIONS (ANNOTATION 'Updated at time', NAMEINSOURCE 'customer/updated_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_website_id string NOT NULL OPTIONS (ANNOTATION 'Website id', NAMEINSOURCE 'customer/website_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN passwordHash string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE ("addresses_customer-data-address-interface_city" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/city'), "addresses_customer-data-address-interface_company" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/company'), "addresses_customer-data-address-interface_country_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/country_id'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value'), "addresses_customer-data-address-interface_customer_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/customer_id'), "addresses_customer-data-address-interface_default_billing" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_billing'), "addresses_customer-data-address-interface_default_shipping" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_shipping'), "addresses_customer-data-address-interface_fax" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/fax'), "addresses_customer-data-address-interface_firstname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/firstname'), "addresses_customer-data-address-interface_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/id'), "addresses_customer-data-address-interface_lastname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/lastname'), "addresses_customer-data-address-interface_middlename" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/middlename'), "addresses_customer-data-address-interface_postcode" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/postcode'), "addresses_customer-data-address-interface_prefix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/prefix'), "addresses_customer-data-address-interface_region_region" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region'), "addresses_customer-data-address-interface_region_region_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_code'), "addresses_customer-data-address-interface_region_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_id'), "addresses_customer-data-address-interface_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region_id'), "addresses_customer-data-address-interface_street" string[] OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/street'), "addresses_customer-data-address-interface_suffix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/suffix'), "addresses_customer-data-address-interface_telephone" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/telephone'), "addresses_customer-data-address-interface_vat_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/vat_id'), confirmation string, created_at string, created_in string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), default_billing string, default_shipping string, disable_auto_group_change string, dob string, email string, extension_attributes_is_subscribed boolean OPTIONS (NAMEINSOURCE 'extension_attributes/is_subscribed'), firstname string, gender string, group_id string, id string, lastname string, middlename string, prefix string, store_id string, suffix string, taxvat string, updated_at string, website_id string)
OPTIONS (ANNOTATION 'Create or update a customer.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/me');

CREATE FOREIGN PROCEDURE customerAccountManagementV1ActivateByIdPut(IN confirmationKey string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE ("addresses_customer-data-address-interface_city" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/city'), "addresses_customer-data-address-interface_company" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/company'), "addresses_customer-data-address-interface_country_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/country_id'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value'), "addresses_customer-data-address-interface_customer_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/customer_id'), "addresses_customer-data-address-interface_default_billing" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_billing'), "addresses_customer-data-address-interface_default_shipping" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_shipping'), "addresses_customer-data-address-interface_fax" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/fax'), "addresses_customer-data-address-interface_firstname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/firstname'), "addresses_customer-data-address-interface_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/id'), "addresses_customer-data-address-interface_lastname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/lastname'), "addresses_customer-data-address-interface_middlename" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/middlename'), "addresses_customer-data-address-interface_postcode" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/postcode'), "addresses_customer-data-address-interface_prefix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/prefix'), "addresses_customer-data-address-interface_region_region" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region'), "addresses_customer-data-address-interface_region_region_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_code'), "addresses_customer-data-address-interface_region_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_id'), "addresses_customer-data-address-interface_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region_id'), "addresses_customer-data-address-interface_street" string[] OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/street'), "addresses_customer-data-address-interface_suffix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/suffix'), "addresses_customer-data-address-interface_telephone" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/telephone'), "addresses_customer-data-address-interface_vat_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/vat_id'), confirmation string, created_at string, created_in string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), default_billing string, default_shipping string, disable_auto_group_change string, dob string, email string, extension_attributes_is_subscribed boolean OPTIONS (NAMEINSOURCE 'extension_attributes/is_subscribed'), firstname string, gender string, group_id string, id string, lastname string, middlename string, prefix string, store_id string, suffix string, taxvat string, updated_at string, website_id string)
OPTIONS (ANNOTATION 'Activate a customer account using a key that was sent in a confirmation email.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/me/activate');

CREATE FOREIGN PROCEDURE "V1/customers/me/billingAddress"() RETURNS TABLE (city string, company string, country_id string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), customer_id string, default_billing boolean, default_shipping boolean, fax string, firstname string, id string, lastname string, middlename string, postcode string, prefix string, region_region string OPTIONS (NAMEINSOURCE 'region/region'), region_region_code string OPTIONS (NAMEINSOURCE 'region/region_code'), region_region_id string OPTIONS (NAMEINSOURCE 'region/region_id'), region_id string, street string[], suffix string, telephone string, vat_id string)
OPTIONS (ANNOTATION 'Retrieve default billing address for the given customerId.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/me/billingAddress');

CREATE FOREIGN PROCEDURE customerAccountManagementV1ChangePasswordByIdPut(OUT "return" boolean RESULT, IN currentPassword string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN newPassword string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Change customer password.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/me/password');

CREATE FOREIGN PROCEDURE "V1/customers/me/shippingAddress"() RETURNS TABLE (city string, company string, country_id string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), customer_id string, default_billing boolean, default_shipping boolean, fax string, firstname string, id string, lastname string, middlename string, postcode string, prefix string, region_region string OPTIONS (NAMEINSOURCE 'region/region'), region_region_code string OPTIONS (NAMEINSOURCE 'region/region_code'), region_region_id string OPTIONS (NAMEINSOURCE 'region/region_id'), region_id string, street string[], suffix string, telephone string, vat_id string)
OPTIONS (ANNOTATION 'Retrieve default shipping address for the given customerId.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/me/shippingAddress');

CREATE FOREIGN PROCEDURE customerAccountManagementV1InitiatePasswordResetPut(OUT "return" boolean RESULT, IN email string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN template string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN websiteId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Send an email to the customer with a password reset link.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/password');

CREATE FOREIGN PROCEDURE customerCustomerRepositoryV1GetListGet(IN "searchCriteria[filterGroups][][filters][][field]" string NOT NULL OPTIONS (ANNOTATION 'Field', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][value]" string NOT NULL OPTIONS (ANNOTATION 'Value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][conditionType]" string NOT NULL OPTIONS (ANNOTATION 'Condition type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][field]" string NOT NULL OPTIONS (ANNOTATION 'Sorting field.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][direction]" string NOT NULL OPTIONS (ANNOTATION 'Sorting direction.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[pageSize]" string NOT NULL OPTIONS (ANNOTATION 'Page size.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[currentPage]" string NOT NULL OPTIONS (ANNOTATION 'Current page.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE ("items_customer-data-customer-interface_addresses_customer-data-address-interface_city" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/city'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_company" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/company'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_country_id" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/country_id'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_customer_id" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/customer_id'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_default_billing" boolean OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/default_billing'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_default_shipping" boolean OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/default_shipping'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_fax" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/fax'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_firstname" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/firstname'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_id" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/id'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_lastname" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/lastname'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_middlename" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/middlename'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_postcode" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/postcode'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_prefix" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/prefix'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_region_region" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/region/region'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_region_region_code" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/region/region_code'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_region_region_id" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/region/region_id'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_region_id" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/region_id'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_street" string[] OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/street'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_suffix" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/suffix'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_telephone" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/telephone'), "items_customer-data-customer-interface_addresses_customer-data-address-interface_vat_id" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/addresses[]/customer-data-address-interface/vat_id'), "items_customer-data-customer-interface_confirmation" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/confirmation'), "items_customer-data-customer-interface_created_at" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/created_at'), "items_customer-data-customer-interface_created_in" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/created_in'), "items_customer-data-customer-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "items_customer-data-customer-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/custom_attributes[]/framework-attribute-interface/value'), "items_customer-data-customer-interface_default_billing" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/default_billing'), "items_customer-data-customer-interface_default_shipping" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/default_shipping'), "items_customer-data-customer-interface_disable_auto_group_change" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/disable_auto_group_change'), "items_customer-data-customer-interface_dob" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/dob'), "items_customer-data-customer-interface_email" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/email'), "items_customer-data-customer-interface_extension_attributes_is_subscribed" boolean OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/extension_attributes/is_subscribed'), "items_customer-data-customer-interface_firstname" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/firstname'), "items_customer-data-customer-interface_gender" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/gender'), "items_customer-data-customer-interface_group_id" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/group_id'), "items_customer-data-customer-interface_id" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/id'), "items_customer-data-customer-interface_lastname" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/lastname'), "items_customer-data-customer-interface_middlename" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/middlename'), "items_customer-data-customer-interface_prefix" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/prefix'), "items_customer-data-customer-interface_store_id" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/store_id'), "items_customer-data-customer-interface_suffix" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/suffix'), "items_customer-data-customer-interface_taxvat" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/taxvat'), "items_customer-data-customer-interface_updated_at" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/updated_at'), "items_customer-data-customer-interface_website_id" string OPTIONS (NAMEINSOURCE 'items[]/customer-data-customer-interface/website_id'), search_criteria_current_page string OPTIONS (NAMEINSOURCE 'search_criteria/current_page'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_condition_type" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/condition_type'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_field" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/field'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_value" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/value'), search_criteria_page_size string OPTIONS (NAMEINSOURCE 'search_criteria/page_size'), "search_criteria_sort_orders_framework-sort-order_direction" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/direction'), "search_criteria_sort_orders_framework-sort-order_field" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/field'), total_count string)
OPTIONS (ANNOTATION 'Retrieve customers which match a specified criteria. This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#CustomerRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/search');

CREATE FOREIGN PROCEDURE customerAccountManagementV1ValidatePut(IN "customer_addresses_customer-data-address-interface_city" string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_company" string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_country_id" string NOT NULL OPTIONS (ANNOTATION 'Country code in ISO_3166-2 format', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_customer_id" string NOT NULL OPTIONS (ANNOTATION 'Customer ID', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_default_billing" boolean NOT NULL OPTIONS (ANNOTATION 'If this address is default billing address', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_default_shipping" boolean NOT NULL OPTIONS (ANNOTATION 'If this address is default shipping address.', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_shipping', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_fax" string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_firstname" string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_id" string NOT NULL OPTIONS (ANNOTATION 'ID', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_lastname" string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_middlename" string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_postcode" string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_prefix" string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_region" string NOT NULL OPTIONS (ANNOTATION 'Region', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_region_code" string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_region_id" string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_id" string NOT NULL OPTIONS (ANNOTATION 'Region ID', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_street" string[] NOT NULL OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_suffix" string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_telephone" string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_vat_id" string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_confirmation string NOT NULL OPTIONS (ANNOTATION 'Confirmation', NAMEINSOURCE 'customer/confirmation', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_created_at string NOT NULL OPTIONS (ANNOTATION 'Created at time', NAMEINSOURCE 'customer/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_created_in string NOT NULL OPTIONS (ANNOTATION 'Created in area', NAMEINSOURCE 'customer/created_in', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_default_billing string NOT NULL OPTIONS (ANNOTATION 'Default billing address id', NAMEINSOURCE 'customer/default_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_default_shipping string NOT NULL OPTIONS (ANNOTATION 'Default shipping address id', NAMEINSOURCE 'customer/default_shipping', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_disable_auto_group_change string NOT NULL OPTIONS (ANNOTATION 'Disable auto group change flag.', NAMEINSOURCE 'customer/disable_auto_group_change', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_dob string NOT NULL OPTIONS (ANNOTATION 'Date of birth', NAMEINSOURCE 'customer/dob', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_email string NOT NULL OPTIONS (ANNOTATION 'Email address', NAMEINSOURCE 'customer/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_extension_attributes_is_subscribed boolean NOT NULL OPTIONS (NAMEINSOURCE 'customer/extension_attributes/is_subscribed', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'customer/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_gender string NOT NULL OPTIONS (ANNOTATION 'Gender', NAMEINSOURCE 'customer/gender', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_group_id string NOT NULL OPTIONS (ANNOTATION 'Group id', NAMEINSOURCE 'customer/group_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'customer/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'customer/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'customer/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'customer/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_store_id string NOT NULL OPTIONS (ANNOTATION 'Store id', NAMEINSOURCE 'customer/store_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'customer/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_taxvat string NOT NULL OPTIONS (ANNOTATION 'Tax Vat', NAMEINSOURCE 'customer/taxvat', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_updated_at string NOT NULL OPTIONS (ANNOTATION 'Updated at time', NAMEINSOURCE 'customer/updated_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_website_id string NOT NULL OPTIONS (ANNOTATION 'Website id', NAMEINSOURCE 'customer/website_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (messages string[], valid boolean)
OPTIONS (ANNOTATION 'Validate customer data.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/validate');

CREATE FOREIGN PROCEDURE "V1/customers/customerId_GET"(IN customerId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE ("addresses_customer-data-address-interface_city" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/city'), "addresses_customer-data-address-interface_company" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/company'), "addresses_customer-data-address-interface_country_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/country_id'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value'), "addresses_customer-data-address-interface_customer_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/customer_id'), "addresses_customer-data-address-interface_default_billing" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_billing'), "addresses_customer-data-address-interface_default_shipping" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_shipping'), "addresses_customer-data-address-interface_fax" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/fax'), "addresses_customer-data-address-interface_firstname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/firstname'), "addresses_customer-data-address-interface_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/id'), "addresses_customer-data-address-interface_lastname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/lastname'), "addresses_customer-data-address-interface_middlename" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/middlename'), "addresses_customer-data-address-interface_postcode" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/postcode'), "addresses_customer-data-address-interface_prefix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/prefix'), "addresses_customer-data-address-interface_region_region" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region'), "addresses_customer-data-address-interface_region_region_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_code'), "addresses_customer-data-address-interface_region_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_id'), "addresses_customer-data-address-interface_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region_id'), "addresses_customer-data-address-interface_street" string[] OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/street'), "addresses_customer-data-address-interface_suffix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/suffix'), "addresses_customer-data-address-interface_telephone" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/telephone'), "addresses_customer-data-address-interface_vat_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/vat_id'), confirmation string, created_at string, created_in string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), default_billing string, default_shipping string, disable_auto_group_change string, dob string, email string, extension_attributes_is_subscribed boolean OPTIONS (NAMEINSOURCE 'extension_attributes/is_subscribed'), firstname string, gender string, group_id string, id string, lastname string, middlename string, prefix string, store_id string, suffix string, taxvat string, updated_at string, website_id string)
OPTIONS (ANNOTATION 'Get customer by customer ID.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/{customerId}');

CREATE FOREIGN PROCEDURE customerCustomerRepositoryV1DeleteByIdDelete(OUT "return" boolean RESULT, IN customerId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Delete customer by ID.', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/{customerId}');

CREATE FOREIGN PROCEDURE "V1/customers/customerId/billingAddress"(IN customerId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (city string, company string, country_id string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), customer_id string, default_billing boolean, default_shipping boolean, fax string, firstname string, id string, lastname string, middlename string, postcode string, prefix string, region_region string OPTIONS (NAMEINSOURCE 'region/region'), region_region_code string OPTIONS (NAMEINSOURCE 'region/region_code'), region_region_id string OPTIONS (NAMEINSOURCE 'region/region_id'), region_id string, street string[], suffix string, telephone string, vat_id string)
OPTIONS (ANNOTATION 'Retrieve default billing address for the given customerId.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/{customerId}/billingAddress');

CREATE FOREIGN PROCEDURE "V1/customers/customerId/carts"(OUT "return" string RESULT, IN customerId string NOT NULL OPTIONS (ANNOTATION 'The customer ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Creates an empty cart and quote for a specified customer.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/{customerId}/carts');

CREATE FOREIGN PROCEDURE customerAccountManagementV1GetConfirmationStatusGet(OUT "return" string RESULT, IN customerId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Gets the account confirmation status.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/{customerId}/confirm');

CREATE FOREIGN PROCEDURE customerAccountManagementV1ValidateResetPasswordLinkTokenGet(OUT "return" boolean RESULT, IN customerId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN resetPasswordLinkToken string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Check if password reset token is valid.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/{customerId}/password/resetLinkToken/{resetPasswordLinkToken}');

CREATE FOREIGN PROCEDURE customerAccountManagementV1IsReadonlyGet(OUT "return" boolean RESULT, IN customerId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Check if customer can be deleted.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/{customerId}/permissions/readonly');

CREATE FOREIGN PROCEDURE "V1/customers/customerId/shippingAddress"(IN customerId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (city string, company string, country_id string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), customer_id string, default_billing boolean, default_shipping boolean, fax string, firstname string, id string, lastname string, middlename string, postcode string, prefix string, region_region string OPTIONS (NAMEINSOURCE 'region/region'), region_region_code string OPTIONS (NAMEINSOURCE 'region/region_code'), region_region_id string OPTIONS (NAMEINSOURCE 'region/region_id'), region_id string, street string[], suffix string, telephone string, vat_id string)
OPTIONS (ANNOTATION 'Retrieve default shipping address for the given customerId.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/{customerId}/shippingAddress');

CREATE FOREIGN PROCEDURE customerAccountManagementV1ActivatePut(IN email string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN confirmationKey string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE ("addresses_customer-data-address-interface_city" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/city'), "addresses_customer-data-address-interface_company" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/company'), "addresses_customer-data-address-interface_country_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/country_id'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value'), "addresses_customer-data-address-interface_customer_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/customer_id'), "addresses_customer-data-address-interface_default_billing" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_billing'), "addresses_customer-data-address-interface_default_shipping" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_shipping'), "addresses_customer-data-address-interface_fax" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/fax'), "addresses_customer-data-address-interface_firstname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/firstname'), "addresses_customer-data-address-interface_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/id'), "addresses_customer-data-address-interface_lastname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/lastname'), "addresses_customer-data-address-interface_middlename" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/middlename'), "addresses_customer-data-address-interface_postcode" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/postcode'), "addresses_customer-data-address-interface_prefix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/prefix'), "addresses_customer-data-address-interface_region_region" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region'), "addresses_customer-data-address-interface_region_region_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_code'), "addresses_customer-data-address-interface_region_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_id'), "addresses_customer-data-address-interface_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region_id'), "addresses_customer-data-address-interface_street" string[] OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/street'), "addresses_customer-data-address-interface_suffix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/suffix'), "addresses_customer-data-address-interface_telephone" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/telephone'), "addresses_customer-data-address-interface_vat_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/vat_id'), confirmation string, created_at string, created_in string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), default_billing string, default_shipping string, disable_auto_group_change string, dob string, email string, extension_attributes_is_subscribed boolean OPTIONS (NAMEINSOURCE 'extension_attributes/is_subscribed'), firstname string, gender string, group_id string, id string, lastname string, middlename string, prefix string, store_id string, suffix string, taxvat string, updated_at string, website_id string)
OPTIONS (ANNOTATION 'Activate a customer account using a key that was sent in a confirmation email.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/{email}/activate');

CREATE FOREIGN PROCEDURE "V1/customers/id"(IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN "customer_addresses_customer-data-address-interface_city" string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_company" string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_country_id" string NOT NULL OPTIONS (ANNOTATION 'Country code in ISO_3166-2 format', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_customer_id" string NOT NULL OPTIONS (ANNOTATION 'Customer ID', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_default_billing" boolean NOT NULL OPTIONS (ANNOTATION 'If this address is default billing address', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_default_shipping" boolean NOT NULL OPTIONS (ANNOTATION 'If this address is default shipping address.', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_shipping', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_fax" string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_firstname" string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_id" string NOT NULL OPTIONS (ANNOTATION 'ID', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_lastname" string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_middlename" string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_postcode" string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_prefix" string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_region" string NOT NULL OPTIONS (ANNOTATION 'Region', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_region_code" string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_region_id" string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_region_id" string NOT NULL OPTIONS (ANNOTATION 'Region ID', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_street" string[] NOT NULL OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_suffix" string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_telephone" string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_addresses_customer-data-address-interface_vat_id" string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_confirmation string NOT NULL OPTIONS (ANNOTATION 'Confirmation', NAMEINSOURCE 'customer/confirmation', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_created_at string NOT NULL OPTIONS (ANNOTATION 'Created at time', NAMEINSOURCE 'customer/created_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_created_in string NOT NULL OPTIONS (ANNOTATION 'Created in area', NAMEINSOURCE 'customer/created_in', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "customer_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_default_billing string NOT NULL OPTIONS (ANNOTATION 'Default billing address id', NAMEINSOURCE 'customer/default_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_default_shipping string NOT NULL OPTIONS (ANNOTATION 'Default shipping address id', NAMEINSOURCE 'customer/default_shipping', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_disable_auto_group_change string NOT NULL OPTIONS (ANNOTATION 'Disable auto group change flag.', NAMEINSOURCE 'customer/disable_auto_group_change', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_dob string NOT NULL OPTIONS (ANNOTATION 'Date of birth', NAMEINSOURCE 'customer/dob', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_email string NOT NULL OPTIONS (ANNOTATION 'Email address', NAMEINSOURCE 'customer/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_extension_attributes_is_subscribed boolean NOT NULL OPTIONS (NAMEINSOURCE 'customer/extension_attributes/is_subscribed', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'customer/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_gender string NOT NULL OPTIONS (ANNOTATION 'Gender', NAMEINSOURCE 'customer/gender', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_group_id string NOT NULL OPTIONS (ANNOTATION 'Group id', NAMEINSOURCE 'customer/group_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'customer/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'customer/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'customer/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'customer/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_store_id string NOT NULL OPTIONS (ANNOTATION 'Store id', NAMEINSOURCE 'customer/store_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'customer/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_taxvat string NOT NULL OPTIONS (ANNOTATION 'Tax Vat', NAMEINSOURCE 'customer/taxvat', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_updated_at string NOT NULL OPTIONS (ANNOTATION 'Updated at time', NAMEINSOURCE 'customer/updated_at', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN customer_website_id string NOT NULL OPTIONS (ANNOTATION 'Website id', NAMEINSOURCE 'customer/website_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN passwordHash string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE ("addresses_customer-data-address-interface_city" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/city'), "addresses_customer-data-address-interface_company" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/company'), "addresses_customer-data-address-interface_country_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/country_id'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value'), "addresses_customer-data-address-interface_customer_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/customer_id'), "addresses_customer-data-address-interface_default_billing" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_billing'), "addresses_customer-data-address-interface_default_shipping" boolean OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/default_shipping'), "addresses_customer-data-address-interface_fax" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/fax'), "addresses_customer-data-address-interface_firstname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/firstname'), "addresses_customer-data-address-interface_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/id'), "addresses_customer-data-address-interface_lastname" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/lastname'), "addresses_customer-data-address-interface_middlename" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/middlename'), "addresses_customer-data-address-interface_postcode" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/postcode'), "addresses_customer-data-address-interface_prefix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/prefix'), "addresses_customer-data-address-interface_region_region" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region'), "addresses_customer-data-address-interface_region_region_code" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_code'), "addresses_customer-data-address-interface_region_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region/region_id'), "addresses_customer-data-address-interface_region_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/region_id'), "addresses_customer-data-address-interface_street" string[] OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/street'), "addresses_customer-data-address-interface_suffix" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/suffix'), "addresses_customer-data-address-interface_telephone" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/telephone'), "addresses_customer-data-address-interface_vat_id" string OPTIONS (NAMEINSOURCE 'addresses[]/customer-data-address-interface/vat_id'), confirmation string, created_at string, created_in string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), default_billing string, default_shipping string, disable_auto_group_change string, dob string, email string, extension_attributes_is_subscribed boolean OPTIONS (NAMEINSOURCE 'extension_attributes/is_subscribed'), firstname string, gender string, group_id string, id string, lastname string, middlename string, prefix string, store_id string, suffix string, taxvat string, updated_at string, website_id string)
OPTIONS (ANNOTATION 'Create or update a customer.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/customers/{id}');

CREATE FOREIGN PROCEDURE directoryCountryInformationAcquirerV1GetCountriesInfoGet() RETURNS TABLE ("available_regions_directory-data-region-information-interface_code" string OPTIONS (NAMEINSOURCE 'available_regions[]/directory-data-region-information-interface/code'), "available_regions_directory-data-region-information-interface_id" string OPTIONS (NAMEINSOURCE 'available_regions[]/directory-data-region-information-interface/id'), "available_regions_directory-data-region-information-interface_name" string OPTIONS (NAMEINSOURCE 'available_regions[]/directory-data-region-information-interface/name'), full_name_english string, full_name_locale string, id string, three_letter_abbreviation string, two_letter_abbreviation string)
OPTIONS (ANNOTATION 'Get all countries and regions information for the store.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/directory/countries');

CREATE FOREIGN PROCEDURE directoryCountryInformationAcquirerV1GetCountryInfoGet(IN countryId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE ("available_regions_directory-data-region-information-interface_code" string OPTIONS (NAMEINSOURCE 'available_regions[]/directory-data-region-information-interface/code'), "available_regions_directory-data-region-information-interface_id" string OPTIONS (NAMEINSOURCE 'available_regions[]/directory-data-region-information-interface/id'), "available_regions_directory-data-region-information-interface_name" string OPTIONS (NAMEINSOURCE 'available_regions[]/directory-data-region-information-interface/name'), full_name_english string, full_name_locale string, id string, three_letter_abbreviation string, two_letter_abbreviation string)
OPTIONS (ANNOTATION 'Get country and region information for the store.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/directory/countries/{countryId}');

CREATE FOREIGN PROCEDURE directoryCurrencyInformationAcquirerV1GetCurrencyInfoGet() RETURNS TABLE (available_currency_codes string[], base_currency_code string, base_currency_symbol string, default_display_currency_code string, default_display_currency_symbol string, "exchange_rates_directory-data-exchange-rate-interface_currency_to" string OPTIONS (NAMEINSOURCE 'exchange_rates[]/directory-data-exchange-rate-interface/currency_to'), "exchange_rates_directory-data-exchange-rate-interface_rate" string OPTIONS (NAMEINSOURCE 'exchange_rates[]/directory-data-exchange-rate-interface/rate'))
OPTIONS (ANNOTATION 'Get currency information for the store.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/directory/currency');

CREATE FOREIGN PROCEDURE eavAttributeSetManagementV1CreatePost(IN attributeSet_attribute_set_id string NOT NULL OPTIONS (ANNOTATION 'Attribute set ID', NAMEINSOURCE 'attributeSet/attribute_set_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN attributeSet_attribute_set_name string NOT NULL OPTIONS (ANNOTATION 'Attribute set name', NAMEINSOURCE 'attributeSet/attribute_set_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN attributeSet_entity_type_id string NOT NULL OPTIONS (ANNOTATION 'Attribute set entity type id', NAMEINSOURCE 'attributeSet/entity_type_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN attributeSet_sort_order string NOT NULL OPTIONS (ANNOTATION 'Attribute set sort order index', NAMEINSOURCE 'attributeSet/sort_order', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN entityTypeCode string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN skeletonId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (attribute_set_id string, attribute_set_name string, entity_type_id string, sort_order string)
OPTIONS (ANNOTATION 'Create attribute set from data', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/eav/attribute-sets');

CREATE FOREIGN PROCEDURE eavAttributeSetRepositoryV1GetListGet(IN "searchCriteria[filterGroups][][filters][][field]" string NOT NULL OPTIONS (ANNOTATION 'Field', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][value]" string NOT NULL OPTIONS (ANNOTATION 'Value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][conditionType]" string NOT NULL OPTIONS (ANNOTATION 'Condition type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][field]" string NOT NULL OPTIONS (ANNOTATION 'Sorting field.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][direction]" string NOT NULL OPTIONS (ANNOTATION 'Sorting direction.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[pageSize]" string NOT NULL OPTIONS (ANNOTATION 'Page size.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[currentPage]" string NOT NULL OPTIONS (ANNOTATION 'Current page.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE ("items_eav-data-attribute-set-interface_attribute_set_id" string OPTIONS (NAMEINSOURCE 'items[]/eav-data-attribute-set-interface/attribute_set_id'), "items_eav-data-attribute-set-interface_attribute_set_name" string OPTIONS (NAMEINSOURCE 'items[]/eav-data-attribute-set-interface/attribute_set_name'), "items_eav-data-attribute-set-interface_entity_type_id" string OPTIONS (NAMEINSOURCE 'items[]/eav-data-attribute-set-interface/entity_type_id'), "items_eav-data-attribute-set-interface_sort_order" string OPTIONS (NAMEINSOURCE 'items[]/eav-data-attribute-set-interface/sort_order'), search_criteria_current_page string OPTIONS (NAMEINSOURCE 'search_criteria/current_page'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_condition_type" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/condition_type'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_field" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/field'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_value" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/value'), search_criteria_page_size string OPTIONS (NAMEINSOURCE 'search_criteria/page_size'), "search_criteria_sort_orders_framework-sort-order_direction" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/direction'), "search_criteria_sort_orders_framework-sort-order_field" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/field'), total_count string)
OPTIONS (ANNOTATION 'Retrieve list of Attribute Sets This call returns an array of objects, but detailed information about each object’s attributes might not be included. See http://devdocs.magento.com/codelinks/attributes.html#AttributeSetRepositoryInterface to determine which call to use to get detailed information about all attributes for an object.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/eav/attribute-sets/list');

CREATE FOREIGN PROCEDURE eavAttributeSetRepositoryV1GetGet(IN attributeSetId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (attribute_set_id string, attribute_set_name string, entity_type_id string, sort_order string)
OPTIONS (ANNOTATION 'Retrieve attribute set information based on given ID', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/eav/attribute-sets/{attributeSetId}');

CREATE FOREIGN PROCEDURE eavAttributeSetRepositoryV1SavePut(IN attributeSetId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN attributeSet_attribute_set_id string NOT NULL OPTIONS (ANNOTATION 'Attribute set ID', NAMEINSOURCE 'attributeSet/attribute_set_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN attributeSet_attribute_set_name string NOT NULL OPTIONS (ANNOTATION 'Attribute set name', NAMEINSOURCE 'attributeSet/attribute_set_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN attributeSet_entity_type_id string NOT NULL OPTIONS (ANNOTATION 'Attribute set entity type id', NAMEINSOURCE 'attributeSet/entity_type_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN attributeSet_sort_order string NOT NULL OPTIONS (ANNOTATION 'Attribute set sort order index', NAMEINSOURCE 'attributeSet/sort_order', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (attribute_set_id string, attribute_set_name string, entity_type_id string, sort_order string)
OPTIONS (ANNOTATION 'Save attribute set data', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/eav/attribute-sets/{attributeSetId}');

CREATE FOREIGN PROCEDURE eavAttributeSetRepositoryV1DeleteByIdDelete(OUT "return" boolean RESULT, IN attributeSetId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Remove attribute set by given ID', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/eav/attribute-sets/{attributeSetId}');

CREATE FOREIGN PROCEDURE giftWrappingWrappingRepositoryV1GetListGet(IN "searchCriteria[filterGroups][][filters][][field]" string NOT NULL OPTIONS (ANNOTATION 'Field', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][value]" string NOT NULL OPTIONS (ANNOTATION 'Value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[filterGroups][][filters][][conditionType]" string NOT NULL OPTIONS (ANNOTATION 'Condition type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][field]" string NOT NULL OPTIONS (ANNOTATION 'Sorting field.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[sortOrders][][direction]" string NOT NULL OPTIONS (ANNOTATION 'Sorting direction.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[pageSize]" string NOT NULL OPTIONS (ANNOTATION 'Page size.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query'), IN "searchCriteria[currentPage]" string NOT NULL OPTIONS (ANNOTATION 'Current page.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE ("items_gift-wrapping-data-wrapping-interface_base_currency_code" string OPTIONS (NAMEINSOURCE 'items[]/gift-wrapping-data-wrapping-interface/base_currency_code'), "items_gift-wrapping-data-wrapping-interface_base_price" string OPTIONS (NAMEINSOURCE 'items[]/gift-wrapping-data-wrapping-interface/base_price'), "items_gift-wrapping-data-wrapping-interface_design" string OPTIONS (NAMEINSOURCE 'items[]/gift-wrapping-data-wrapping-interface/design'), "items_gift-wrapping-data-wrapping-interface_image_base64_content" string OPTIONS (NAMEINSOURCE 'items[]/gift-wrapping-data-wrapping-interface/image_base64_content'), "items_gift-wrapping-data-wrapping-interface_image_name" string OPTIONS (NAMEINSOURCE 'items[]/gift-wrapping-data-wrapping-interface/image_name'), "items_gift-wrapping-data-wrapping-interface_image_url" string OPTIONS (NAMEINSOURCE 'items[]/gift-wrapping-data-wrapping-interface/image_url'), "items_gift-wrapping-data-wrapping-interface_status" string OPTIONS (NAMEINSOURCE 'items[]/gift-wrapping-data-wrapping-interface/status'), "items_gift-wrapping-data-wrapping-interface_website_ids" string[] OPTIONS (NAMEINSOURCE 'items[]/gift-wrapping-data-wrapping-interface/website_ids'), "items_gift-wrapping-data-wrapping-interface_wrapping_id" string OPTIONS (NAMEINSOURCE 'items[]/gift-wrapping-data-wrapping-interface/wrapping_id'), search_criteria_current_page string OPTIONS (NAMEINSOURCE 'search_criteria/current_page'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_condition_type" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/condition_type'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_field" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/field'), "search_criteria_filter_groups_framework-search-filter-group_filters_framework-filter_value" string OPTIONS (NAMEINSOURCE 'search_criteria/filter_groups[]/framework-search-filter-group/filters[]/framework-filter/value'), search_criteria_page_size string OPTIONS (NAMEINSOURCE 'search_criteria/page_size'), "search_criteria_sort_orders_framework-sort-order_direction" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/direction'), "search_criteria_sort_orders_framework-sort-order_field" string OPTIONS (NAMEINSOURCE 'search_criteria/sort_orders[]/framework-sort-order/field'), total_count string)
OPTIONS (ANNOTATION 'Return list of gift wrapping data objects based on search criteria', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/gift-wrappings');

CREATE FOREIGN PROCEDURE giftWrappingWrappingRepositoryV1SavePost(IN data_base_currency_code string NOT NULL OPTIONS (NAMEINSOURCE 'data/base_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_base_price string NOT NULL OPTIONS (NAMEINSOURCE 'data/base_price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_design string NOT NULL OPTIONS (NAMEINSOURCE 'data/design', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_image_base64_content string NOT NULL OPTIONS (NAMEINSOURCE 'data/image_base64_content', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_image_name string NOT NULL OPTIONS (NAMEINSOURCE 'data/image_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_image_url string NOT NULL OPTIONS (ANNOTATION 'Wrapping image URL.', NAMEINSOURCE 'data/image_url', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_status string NOT NULL OPTIONS (NAMEINSOURCE 'data/status', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_website_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'data/website_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_wrapping_id string NOT NULL OPTIONS (NAMEINSOURCE 'data/wrapping_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN storeId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (base_currency_code string, base_price string, design string, image_base64_content string, image_name string, image_url string, status string, website_ids string[], wrapping_id string)
OPTIONS (ANNOTATION 'Create/Update new gift wrapping with data object values', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/gift-wrappings');

CREATE FOREIGN PROCEDURE giftWrappingWrappingRepositoryV1GetGet(IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN storeId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'query')) RETURNS TABLE (base_currency_code string, base_price string, design string, image_base64_content string, image_name string, image_url string, status string, website_ids string[], wrapping_id string)
OPTIONS (ANNOTATION 'Return data object for specified wrapping ID and store.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/gift-wrappings/{id}');

CREATE FOREIGN PROCEDURE giftWrappingWrappingRepositoryV1DeleteByIdDelete(OUT "return" boolean RESULT, IN id string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Delete gift wrapping', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/gift-wrappings/{id}');

CREATE FOREIGN PROCEDURE giftWrappingWrappingRepositoryV1SavePut(IN wrappingId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN data_base_currency_code string NOT NULL OPTIONS (NAMEINSOURCE 'data/base_currency_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_base_price string NOT NULL OPTIONS (NAMEINSOURCE 'data/base_price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_design string NOT NULL OPTIONS (NAMEINSOURCE 'data/design', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_image_base64_content string NOT NULL OPTIONS (NAMEINSOURCE 'data/image_base64_content', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_image_name string NOT NULL OPTIONS (NAMEINSOURCE 'data/image_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_image_url string NOT NULL OPTIONS (ANNOTATION 'Wrapping image URL.', NAMEINSOURCE 'data/image_url', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_status string NOT NULL OPTIONS (NAMEINSOURCE 'data/status', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_website_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'data/website_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN data_wrapping_id string NOT NULL OPTIONS (NAMEINSOURCE 'data/wrapping_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN storeId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (base_currency_code string, base_price string, design string, image_base64_content string, image_name string, image_url string, status string, website_ids string[], wrapping_id string)
OPTIONS (ANNOTATION 'Create/Update new gift wrapping with data object values', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/gift-wrappings/{wrappingId}');

CREATE FOREIGN PROCEDURE giftRegistryShippingMethodManagementV1EstimateByRegistryIdPost(IN registryId string NOT NULL OPTIONS (ANNOTATION 'The estimate registry id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (amount string, available boolean, base_amount string, carrier_code string, carrier_title string, error_message string, method_code string, method_title string, price_excl_tax string, price_incl_tax string)
OPTIONS (ANNOTATION 'Estimate shipping', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/giftregistry/mine/estimate-shipping-methods');

CREATE FOREIGN PROCEDURE quoteGuestCartManagementV1CreateEmptyCartPost(OUT "return" string RESULT) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Enable an customer or guest user to create an empty cart and quote for an anonymous customer.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts');

CREATE FOREIGN PROCEDURE quoteGuestCartRepositoryV1GetGet(IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (billing_address_city string OPTIONS (NAMEINSOURCE 'billing_address/city'), billing_address_company string OPTIONS (NAMEINSOURCE 'billing_address/company'), billing_address_country_id string OPTIONS (NAMEINSOURCE 'billing_address/country_id'), "billing_address_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'billing_address/custom_attributes[]/framework-attribute-interface/attribute_code'), "billing_address_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'billing_address/custom_attributes[]/framework-attribute-interface/value'), billing_address_customer_address_id string OPTIONS (NAMEINSOURCE 'billing_address/customer_address_id'), billing_address_customer_id string OPTIONS (NAMEINSOURCE 'billing_address/customer_id'), billing_address_email string OPTIONS (NAMEINSOURCE 'billing_address/email'), billing_address_extension_attributes_gift_registry_id string OPTIONS (NAMEINSOURCE 'billing_address/extension_attributes/gift_registry_id'), billing_address_fax string OPTIONS (NAMEINSOURCE 'billing_address/fax'), billing_address_firstname string OPTIONS (NAMEINSOURCE 'billing_address/firstname'), billing_address_id string OPTIONS (NAMEINSOURCE 'billing_address/id'), billing_address_lastname string OPTIONS (NAMEINSOURCE 'billing_address/lastname'), billing_address_middlename string OPTIONS (NAMEINSOURCE 'billing_address/middlename'), billing_address_postcode string OPTIONS (NAMEINSOURCE 'billing_address/postcode'), billing_address_prefix string OPTIONS (NAMEINSOURCE 'billing_address/prefix'), billing_address_region string OPTIONS (NAMEINSOURCE 'billing_address/region'), billing_address_region_code string OPTIONS (NAMEINSOURCE 'billing_address/region_code'), billing_address_region_id string OPTIONS (NAMEINSOURCE 'billing_address/region_id'), billing_address_same_as_billing string OPTIONS (NAMEINSOURCE 'billing_address/same_as_billing'), billing_address_save_in_address_book string OPTIONS (NAMEINSOURCE 'billing_address/save_in_address_book'), billing_address_street string[] OPTIONS (NAMEINSOURCE 'billing_address/street'), billing_address_suffix string OPTIONS (NAMEINSOURCE 'billing_address/suffix'), billing_address_telephone string OPTIONS (NAMEINSOURCE 'billing_address/telephone'), billing_address_vat_id string OPTIONS (NAMEINSOURCE 'billing_address/vat_id'), converted_at string, created_at string, currency_base_currency_code string OPTIONS (NAMEINSOURCE 'currency/base_currency_code'), currency_base_to_global_rate string OPTIONS (NAMEINSOURCE 'currency/base_to_global_rate'), currency_base_to_quote_rate string OPTIONS (NAMEINSOURCE 'currency/base_to_quote_rate'), currency_global_currency_code string OPTIONS (NAMEINSOURCE 'currency/global_currency_code'), currency_quote_currency_code string OPTIONS (NAMEINSOURCE 'currency/quote_currency_code'), currency_store_currency_code string OPTIONS (NAMEINSOURCE 'currency/store_currency_code'), currency_store_to_base_rate string OPTIONS (NAMEINSOURCE 'currency/store_to_base_rate'), currency_store_to_quote_rate string OPTIONS (NAMEINSOURCE 'currency/store_to_quote_rate'), "customer_addresses_customer-data-address-interface_city" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/city'), "customer_addresses_customer-data-address-interface_company" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/company'), "customer_addresses_customer-data-address-interface_country_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/country_id'), "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/attribute_code'), "customer_addresses_customer-data-address-interface_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/custom_attributes[]/framework-attribute-interface/value'), "customer_addresses_customer-data-address-interface_customer_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/customer_id'), "customer_addresses_customer-data-address-interface_default_billing" boolean OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_billing'), "customer_addresses_customer-data-address-interface_default_shipping" boolean OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/default_shipping'), "customer_addresses_customer-data-address-interface_fax" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/fax'), "customer_addresses_customer-data-address-interface_firstname" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/firstname'), "customer_addresses_customer-data-address-interface_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/id'), "customer_addresses_customer-data-address-interface_lastname" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/lastname'), "customer_addresses_customer-data-address-interface_middlename" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/middlename'), "customer_addresses_customer-data-address-interface_postcode" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/postcode'), "customer_addresses_customer-data-address-interface_prefix" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/prefix'), "customer_addresses_customer-data-address-interface_region_region" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region'), "customer_addresses_customer-data-address-interface_region_region_code" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_code'), "customer_addresses_customer-data-address-interface_region_region_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region/region_id'), "customer_addresses_customer-data-address-interface_region_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/region_id'), "customer_addresses_customer-data-address-interface_street" string[] OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/street'), "customer_addresses_customer-data-address-interface_suffix" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/suffix'), "customer_addresses_customer-data-address-interface_telephone" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/telephone'), "customer_addresses_customer-data-address-interface_vat_id" string OPTIONS (NAMEINSOURCE 'customer/addresses[]/customer-data-address-interface/vat_id'), customer_confirmation string OPTIONS (NAMEINSOURCE 'customer/confirmation'), customer_created_at string OPTIONS (NAMEINSOURCE 'customer/created_at'), customer_created_in string OPTIONS (NAMEINSOURCE 'customer/created_in'), "customer_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/attribute_code'), "customer_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'customer/custom_attributes[]/framework-attribute-interface/value'), customer_default_billing string OPTIONS (NAMEINSOURCE 'customer/default_billing'), customer_default_shipping string OPTIONS (NAMEINSOURCE 'customer/default_shipping'), customer_disable_auto_group_change string OPTIONS (NAMEINSOURCE 'customer/disable_auto_group_change'), customer_dob string OPTIONS (NAMEINSOURCE 'customer/dob'), customer_email string OPTIONS (NAMEINSOURCE 'customer/email'), customer_extension_attributes_is_subscribed boolean OPTIONS (NAMEINSOURCE 'customer/extension_attributes/is_subscribed'), customer_firstname string OPTIONS (NAMEINSOURCE 'customer/firstname'), customer_gender string OPTIONS (NAMEINSOURCE 'customer/gender'), customer_group_id string OPTIONS (NAMEINSOURCE 'customer/group_id'), customer_id string OPTIONS (NAMEINSOURCE 'customer/id'), customer_lastname string OPTIONS (NAMEINSOURCE 'customer/lastname'), customer_middlename string OPTIONS (NAMEINSOURCE 'customer/middlename'), customer_prefix string OPTIONS (NAMEINSOURCE 'customer/prefix'), customer_store_id string OPTIONS (NAMEINSOURCE 'customer/store_id'), customer_suffix string OPTIONS (NAMEINSOURCE 'customer/suffix'), customer_taxvat string OPTIONS (NAMEINSOURCE 'customer/taxvat'), customer_updated_at string OPTIONS (NAMEINSOURCE 'customer/updated_at'), customer_website_id string OPTIONS (NAMEINSOURCE 'customer/website_id'), customer_is_guest boolean, customer_note string, customer_note_notify boolean, customer_tax_class_id string, "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/item_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/name'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_price" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/price'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_downloadable_option_downloadable_links" string[] OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/downloadable_option/downloadable_links'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_amount" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_amount'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_message" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_message'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_product_type" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/product_type'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_qty" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/qty'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_quote_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/quote_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_items_quote-data-cart-item-interface_sku" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/items[]/quote-data-cart-item-interface/sku'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_city" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/city'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_company" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/company'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_country_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/country_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/custom_attributes[]/framework-attribute-interface/attribute_code'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/custom_attributes[]/framework-attribute-interface/value'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_customer_address_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/customer_address_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_customer_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/customer_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_email" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/email'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_extension_attributes_gift_registry_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/extension_attributes/gift_registry_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_fax" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/fax'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_firstname" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/firstname'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_lastname" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/lastname'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_middlename" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/middlename'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_postcode" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/postcode'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_prefix" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/prefix'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region_code" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region_code'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_region_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/region_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_same_as_billing" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/same_as_billing'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_save_in_address_book" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/save_in_address_book'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_street" string[] OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/street'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_suffix" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/suffix'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_telephone" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/telephone'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_address_vat_id" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/address/vat_id'), "extension_attributes_shipping_assignments_quote-data-shipping-assignment-interface_shipping_method" string OPTIONS (NAMEINSOURCE 'extension_attributes/shipping_assignments[]/quote-data-shipping-assignment-interface/shipping/method'), id string, is_active boolean, is_virtual boolean, "items_quote-data-cart-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/item_id'), "items_quote-data-cart-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/name'), "items_quote-data-cart-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/price'), "items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "items_quote-data-cart-item-interface_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "items_quote-data-cart-item-interface_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "items_quote-data-cart-item-interface_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), "items_quote-data-cart-item-interface_product_option_extension_attributes_downloadable_option_downloadable_links" string[] OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/downloadable_option/downloadable_links'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_amount'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_message" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_message'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), "items_quote-data-cart-item-interface_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), "items_quote-data-cart-item-interface_product_type" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/product_type'), "items_quote-data-cart-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/qty'), "items_quote-data-cart-item-interface_quote_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/quote_id'), "items_quote-data-cart-item-interface_sku" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-cart-item-interface/sku'), items_count string, items_qty string, orig_order_id string, reserved_order_id string, store_id string, updated_at string)
OPTIONS (ANNOTATION 'Enable a guest user to return information for a specified cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}');

CREATE FOREIGN PROCEDURE quoteGuestCartManagementV1AssignCustomerPut(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN customerId string NOT NULL OPTIONS (ANNOTATION 'The customer ID.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN storeId string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Assign a specified customer to a specified shopping cart.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}');

CREATE FOREIGN PROCEDURE quoteGuestBillingAddressManagementV1GetGet(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (city string, company string, country_id string, "custom_attributes_framework-attribute-interface_attribute_code" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/attribute_code'), "custom_attributes_framework-attribute-interface_value" string OPTIONS (NAMEINSOURCE 'custom_attributes[]/framework-attribute-interface/value'), customer_address_id string, customer_id string, email string, extension_attributes_gift_registry_id string OPTIONS (NAMEINSOURCE 'extension_attributes/gift_registry_id'), fax string, firstname string, id string, lastname string, middlename string, postcode string, prefix string, region string, region_code string, region_id string, same_as_billing string, save_in_address_book string, street string[], suffix string, telephone string, vat_id string)
OPTIONS (ANNOTATION 'Return the billing address for a specified quote.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/billing-address');

CREATE FOREIGN PROCEDURE quoteGuestBillingAddressManagementV1AssignPost(OUT "return" string RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Assign a specified billing address to a specified cart.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/billing-address');

CREATE FOREIGN PROCEDURE quoteGuestCartTotalManagementV1CollectTotalsPut(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN "additionalData_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'additionalData/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'additionalData/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_customer_id" string NOT NULL OPTIONS (ANNOTATION 'Customer ID. Otherwise, null.', NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_extension_attributes_entity_id" string NOT NULL OPTIONS (NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/extension_attributes/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_extension_attributes_entity_type" string NOT NULL OPTIONS (NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/extension_attributes/entity_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_extension_attributes_wrapping_add_printed_card" boolean NOT NULL OPTIONS (NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/extension_attributes/wrapping_add_printed_card', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_extension_attributes_wrapping_allow_gift_receipt" boolean NOT NULL OPTIONS (NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/extension_attributes/wrapping_allow_gift_receipt', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_extension_attributes_wrapping_id" string NOT NULL OPTIONS (NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/extension_attributes/wrapping_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_gift_message_id" string NOT NULL OPTIONS (ANNOTATION 'Gift message ID. Otherwise, null.', NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/gift_message_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_message" string NOT NULL OPTIONS (ANNOTATION 'Message text.', NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_recipient" string NOT NULL OPTIONS (ANNOTATION 'Recipient name.', NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/recipient', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "additionalData_extension_attributes_gift_messages_gift-message-data-message-interface_sender" string NOT NULL OPTIONS (ANNOTATION 'Sender name.', NAMEINSOURCE 'additionalData/extension_attributes/gift_messages[]/gift-message-data-message-interface/sender', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_additional_data string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_extension_attributes_agreement_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/extension_attributes/agreement_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_method string NOT NULL OPTIONS (ANNOTATION 'Payment method code', NAMEINSOURCE 'paymentMethod/method', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_po_number string NOT NULL OPTIONS (ANNOTATION 'Purchase order number', NAMEINSOURCE 'paymentMethod/po_number', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN shippingCarrierCode string NOT NULL OPTIONS (ANNOTATION 'The carrier code.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN shippingMethodCode string NOT NULL OPTIONS (ANNOTATION 'The shipping method code.', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (base_currency_code string, base_discount_amount string, base_grand_total string, base_shipping_amount string, base_shipping_discount_amount string, base_shipping_incl_tax string, base_shipping_tax_amount string, base_subtotal string, base_subtotal_incl_tax string, base_subtotal_with_discount string, base_tax_amount string, coupon_code string, discount_amount string, extension_attributes_base_customer_balance_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/base_customer_balance_amount'), extension_attributes_base_reward_currency_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/base_reward_currency_amount'), extension_attributes_customer_balance_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/customer_balance_amount'), extension_attributes_reward_currency_amount string OPTIONS (NAMEINSOURCE 'extension_attributes/reward_currency_amount'), extension_attributes_reward_points_balance string OPTIONS (NAMEINSOURCE 'extension_attributes/reward_points_balance'), grand_total string, "items_quote-data-totals-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_discount_amount'), "items_quote-data-totals-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_price'), "items_quote-data-totals-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_price_incl_tax'), "items_quote-data-totals-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_row_total'), "items_quote-data-totals-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_row_total_incl_tax'), "items_quote-data-totals-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/base_tax_amount'), "items_quote-data-totals-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/discount_amount'), "items_quote-data-totals-item-interface_discount_percent" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/discount_percent'), "items_quote-data-totals-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/item_id'), "items_quote-data-totals-item-interface_name" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/name'), "items_quote-data-totals-item-interface_options" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/options'), "items_quote-data-totals-item-interface_price" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/price'), "items_quote-data-totals-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/price_incl_tax'), "items_quote-data-totals-item-interface_qty" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/qty'), "items_quote-data-totals-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total'), "items_quote-data-totals-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total_incl_tax'), "items_quote-data-totals-item-interface_row_total_with_discount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/row_total_with_discount'), "items_quote-data-totals-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/tax_amount'), "items_quote-data-totals-item-interface_tax_percent" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/tax_percent'), "items_quote-data-totals-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/weee_tax_applied'), "items_quote-data-totals-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'items[]/quote-data-totals-item-interface/weee_tax_applied_amount'), items_qty string, quote_currency_code string, shipping_amount string, shipping_discount_amount string, shipping_incl_tax string, shipping_tax_amount string, subtotal string, subtotal_incl_tax string, subtotal_with_discount string, tax_amount string, "total_segments_quote-data-total-segment-interface_area" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/area'), "total_segments_quote-data-total-segment-interface_code" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/code'), "total_segments_quote-data-total-segment-interface_extension_attributes_gift_cards" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gift_cards'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_add_card" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_add_card'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_allow_gift_receipt" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_allow_gift_receipt'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_item_ids" string[] OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_item_ids'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_order_id" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_order_id'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_price" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_price_incl_tax" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price_incl_tax'), "total_segments_quote-data-total-segment-interface_extension_attributes_gw_tax_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_tax_amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_amount" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/amount'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_group_id" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/group_id'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_percent" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/percent'), "total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_title" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/title'), "total_segments_quote-data-total-segment-interface_title" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/title'), "total_segments_quote-data-total-segment-interface_value" string OPTIONS (NAMEINSOURCE 'total_segments[]/quote-data-total-segment-interface/value'), weee_tax_applied_amount string)
OPTIONS (ANNOTATION 'Set shipping/billing methods and additional data for cart and collect totals for guest.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/collect-totals');

CREATE FOREIGN PROCEDURE quoteGuestCouponManagementV1GetGet(OUT "return" string RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Return information for a coupon in a specified cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/coupons');

CREATE FOREIGN PROCEDURE quoteGuestCouponManagementV1RemoveDelete(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Delete a coupon from a specified cart.', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/coupons');

CREATE FOREIGN PROCEDURE quoteGuestCouponManagementV1SetPut(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN couponCode string NOT NULL OPTIONS (ANNOTATION 'The coupon code data.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Add a coupon by code to a specified cart.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/coupons/{couponCode}');

CREATE FOREIGN PROCEDURE quoteGuestShipmentEstimationV1EstimateByExtendedAddressPost(IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (amount string, available boolean, base_amount string, carrier_code string, carrier_title string, error_message string, method_code string, method_title string, price_excl_tax string, price_incl_tax string)
OPTIONS (ANNOTATION 'Estimate shipping by address and return list of available shipping methods', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/estimate-shipping-methods');

CREATE FOREIGN PROCEDURE giftMessageGuestCartRepositoryV1GetGet(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The shopping cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (customer_id string, extension_attributes_entity_id string OPTIONS (NAMEINSOURCE 'extension_attributes/entity_id'), extension_attributes_entity_type string OPTIONS (NAMEINSOURCE 'extension_attributes/entity_type'), extension_attributes_wrapping_add_printed_card boolean OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_add_printed_card'), extension_attributes_wrapping_allow_gift_receipt boolean OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_allow_gift_receipt'), extension_attributes_wrapping_id string OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_id'), gift_message_id string, message string, recipient string, sender string)
OPTIONS (ANNOTATION 'Return the gift message for a specified order.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/gift-message');

CREATE FOREIGN PROCEDURE giftMessageGuestCartRepositoryV1SavePost(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN giftMessage_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer ID. Otherwise, null.', NAMEINSOURCE 'giftMessage/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_entity_id string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_entity_type string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/entity_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_add_printed_card boolean NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_add_printed_card', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_allow_gift_receipt boolean NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_allow_gift_receipt', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_id string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_gift_message_id string NOT NULL OPTIONS (ANNOTATION 'Gift message ID. Otherwise, null.', NAMEINSOURCE 'giftMessage/gift_message_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_message string NOT NULL OPTIONS (ANNOTATION 'Message text.', NAMEINSOURCE 'giftMessage/message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_recipient string NOT NULL OPTIONS (ANNOTATION 'Recipient name.', NAMEINSOURCE 'giftMessage/recipient', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_sender string NOT NULL OPTIONS (ANNOTATION 'Sender name.', NAMEINSOURCE 'giftMessage/sender', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Set the gift message for an entire order.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/gift-message');

CREATE FOREIGN PROCEDURE giftMessageGuestItemRepositoryV1GetGet(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The shopping cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN itemId string NOT NULL OPTIONS (ANNOTATION 'The item ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (customer_id string, extension_attributes_entity_id string OPTIONS (NAMEINSOURCE 'extension_attributes/entity_id'), extension_attributes_entity_type string OPTIONS (NAMEINSOURCE 'extension_attributes/entity_type'), extension_attributes_wrapping_add_printed_card boolean OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_add_printed_card'), extension_attributes_wrapping_allow_gift_receipt boolean OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_allow_gift_receipt'), extension_attributes_wrapping_id string OPTIONS (NAMEINSOURCE 'extension_attributes/wrapping_id'), gift_message_id string, message string, recipient string, sender string)
OPTIONS (ANNOTATION 'Return the gift message for a specified item in a specified shopping cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/gift-message/{itemId}');

CREATE FOREIGN PROCEDURE giftMessageGuestItemRepositoryV1SavePost(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN itemId string NOT NULL OPTIONS (ANNOTATION 'The item ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN giftMessage_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer ID. Otherwise, null.', NAMEINSOURCE 'giftMessage/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_entity_id string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/entity_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_entity_type string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/entity_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_add_printed_card boolean NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_add_printed_card', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_allow_gift_receipt boolean NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_allow_gift_receipt', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_extension_attributes_wrapping_id string NOT NULL OPTIONS (NAMEINSOURCE 'giftMessage/extension_attributes/wrapping_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_gift_message_id string NOT NULL OPTIONS (ANNOTATION 'Gift message ID. Otherwise, null.', NAMEINSOURCE 'giftMessage/gift_message_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_message string NOT NULL OPTIONS (ANNOTATION 'Message text.', NAMEINSOURCE 'giftMessage/message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_recipient string NOT NULL OPTIONS (ANNOTATION 'Recipient name.', NAMEINSOURCE 'giftMessage/recipient', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN giftMessage_sender string NOT NULL OPTIONS (ANNOTATION 'Sender name.', NAMEINSOURCE 'giftMessage/sender', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Set the gift message for a specified item in a specified shopping cart.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/gift-message/{itemId}');

CREATE FOREIGN PROCEDURE quoteGuestCartItemRepositoryV1GetListGet(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (item_id string, name string, price string, "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), product_option_extension_attributes_downloadable_option_downloadable_links string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/downloadable_option/downloadable_links'), product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_message string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_message'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), product_type string, qty string, quote_id string, sku string)
OPTIONS (ANNOTATION 'List items that are assigned to a specified cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/items');

CREATE FOREIGN PROCEDURE quoteGuestCartItemRepositoryV1SavePost(IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN cartItem_item_id string NOT NULL OPTIONS (ANNOTATION 'Item ID. Otherwise, null.', NAMEINSOURCE 'cartItem/item_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_name string NOT NULL OPTIONS (ANNOTATION 'Product name. Otherwise, null.', NAMEINSOURCE 'cartItem/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_price string NOT NULL OPTIONS (ANNOTATION 'Product price. Otherwise, null.', NAMEINSOURCE 'cartItem/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Bundle option id.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string NOT NULL OPTIONS (ANNOTATION 'Bundle option quantity.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] NOT NULL OPTIONS (NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option SKU', NAMEINSOURCE 'cartItem/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Item id', NAMEINSOURCE 'cartItem/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string NOT NULL OPTIONS (ANNOTATION 'Media data (base64 encoded content)', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string NOT NULL OPTIONS (ANNOTATION 'Image name', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string NOT NULL OPTIONS (ANNOTATION 'MIME type', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Option value', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_downloadable_option_downloadable_links string[] NOT NULL OPTIONS (NAMEINSOURCE 'cartItem/product_option/extension_attributes/downloadable_option/downloadable_links', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string NOT NULL OPTIONS (ANNOTATION 'Gift card open amount value.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_amount string NOT NULL OPTIONS (ANNOTATION 'Gift card amount.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_message string NOT NULL OPTIONS (ANNOTATION 'Giftcard message.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient email.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient name.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string NOT NULL OPTIONS (ANNOTATION 'Gift card sender email.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string NOT NULL OPTIONS (ANNOTATION 'Gift card sender name.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_type string NOT NULL OPTIONS (ANNOTATION 'Product type. Otherwise, null.', NAMEINSOURCE 'cartItem/product_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_qty string NOT NULL OPTIONS (ANNOTATION 'Product quantity.', NAMEINSOURCE 'cartItem/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_quote_id string NOT NULL OPTIONS (ANNOTATION 'Quote id.', NAMEINSOURCE 'cartItem/quote_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_sku string NOT NULL OPTIONS (ANNOTATION 'Product SKU. Otherwise, null.', NAMEINSOURCE 'cartItem/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (item_id string, name string, price string, "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), product_option_extension_attributes_downloadable_option_downloadable_links string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/downloadable_option/downloadable_links'), product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_message string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_message'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), product_type string, qty string, quote_id string, sku string)
OPTIONS (ANNOTATION 'Add the specified item to the specified cart.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/items');

CREATE FOREIGN PROCEDURE quoteGuestCartItemRepositoryV1SavePut(IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN itemId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN cartItem_item_id string NOT NULL OPTIONS (ANNOTATION 'Item ID. Otherwise, null.', NAMEINSOURCE 'cartItem/item_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_name string NOT NULL OPTIONS (ANNOTATION 'Product name. Otherwise, null.', NAMEINSOURCE 'cartItem/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_price string NOT NULL OPTIONS (ANNOTATION 'Product price. Otherwise, null.', NAMEINSOURCE 'cartItem/price', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Bundle option id.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string NOT NULL OPTIONS (ANNOTATION 'Bundle option quantity.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] NOT NULL OPTIONS (NAMEINSOURCE 'cartItem/product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option SKU', NAMEINSOURCE 'cartItem/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Item id', NAMEINSOURCE 'cartItem/product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string NOT NULL OPTIONS (ANNOTATION 'Media data (base64 encoded content)', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string NOT NULL OPTIONS (ANNOTATION 'Image name', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string NOT NULL OPTIONS (ANNOTATION 'MIME type', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string NOT NULL OPTIONS (ANNOTATION 'Option id', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "cartItem_product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string NOT NULL OPTIONS (ANNOTATION 'Option value', NAMEINSOURCE 'cartItem/product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_downloadable_option_downloadable_links string[] NOT NULL OPTIONS (NAMEINSOURCE 'cartItem/product_option/extension_attributes/downloadable_option/downloadable_links', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string NOT NULL OPTIONS (ANNOTATION 'Gift card open amount value.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_amount string NOT NULL OPTIONS (ANNOTATION 'Gift card amount.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_amount', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_message string NOT NULL OPTIONS (ANNOTATION 'Giftcard message.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_message', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient email.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string NOT NULL OPTIONS (ANNOTATION 'Gift card recipient name.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string NOT NULL OPTIONS (ANNOTATION 'Gift card sender email.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_sender_email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string NOT NULL OPTIONS (ANNOTATION 'Gift card sender name.', NAMEINSOURCE 'cartItem/product_option/extension_attributes/giftcard_item_option/giftcard_sender_name', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_product_type string NOT NULL OPTIONS (ANNOTATION 'Product type. Otherwise, null.', NAMEINSOURCE 'cartItem/product_type', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_qty string NOT NULL OPTIONS (ANNOTATION 'Product quantity.', NAMEINSOURCE 'cartItem/qty', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_quote_id string NOT NULL OPTIONS (ANNOTATION 'Quote id.', NAMEINSOURCE 'cartItem/quote_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN cartItem_sku string NOT NULL OPTIONS (ANNOTATION 'Product SKU. Otherwise, null.', NAMEINSOURCE 'cartItem/sku', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (item_id string, name string, price string, "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_id'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_qty" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_qty'), "product_option_extension_attributes_bundle_options_bundle-data-bundle-option-interface_option_selections" string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/bundle_options[]/bundle-data-bundle-option-interface/option_selections'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_id'), "product_option_extension_attributes_configurable_item_options_configurable-product-data-configurable-item-option-value-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/configurable_item_options[]/configurable-product-data-configurable-item-option-value-interface/option_value'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_base64_encoded_data" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/base64_encoded_data'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_name" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/name'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_extension_attributes_file_info_type" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/extension_attributes/file_info/type'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_id" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_id'), "product_option_extension_attributes_custom_options_catalog-data-custom-option-interface_option_value" string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/custom_options[]/catalog-data-custom-option-interface/option_value'), product_option_extension_attributes_downloadable_option_downloadable_links string[] OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/downloadable_option/downloadable_links'), product_option_extension_attributes_giftcard_item_option_custom_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/custom_giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_amount string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_amount'), product_option_extension_attributes_giftcard_item_option_giftcard_message string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_message'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_email'), product_option_extension_attributes_giftcard_item_option_giftcard_recipient_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_recipient_name'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_email string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_email'), product_option_extension_attributes_giftcard_item_option_giftcard_sender_name string OPTIONS (NAMEINSOURCE 'product_option/extension_attributes/giftcard_item_option/giftcard_sender_name'), product_type string, qty string, quote_id string, sku string)
OPTIONS (ANNOTATION 'Add the specified item to the specified cart.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/items/{itemId}');

CREATE FOREIGN PROCEDURE quoteGuestCartItemRepositoryV1DeleteByIdDelete(OUT "return" boolean RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN itemId string NOT NULL OPTIONS (ANNOTATION 'The item ID of the item to be removed.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Remove the specified item from the specified cart.', "teiid_rest:METHOD" 'DELETE', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/items/{itemId}');

CREATE FOREIGN PROCEDURE quoteGuestCartManagementV1PlaceOrderPut(OUT "return" string RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN paymentMethod_additional_data string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_extension_attributes_agreement_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/extension_attributes/agreement_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_method string NOT NULL OPTIONS (ANNOTATION 'Payment method code', NAMEINSOURCE 'paymentMethod/method', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_po_number string NOT NULL OPTIONS (ANNOTATION 'Purchase order number', NAMEINSOURCE 'paymentMethod/po_number', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Place an order for a specified cart.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/order');

CREATE FOREIGN PROCEDURE checkoutGuestPaymentInformationManagementV1GetPaymentInformationGet(IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE ("payment_methods_quote-data-payment-method-interface_code" string OPTIONS (NAMEINSOURCE 'payment_methods[]/quote-data-payment-method-interface/code'), "payment_methods_quote-data-payment-method-interface_title" string OPTIONS (NAMEINSOURCE 'payment_methods[]/quote-data-payment-method-interface/title'), totals_base_currency_code string OPTIONS (NAMEINSOURCE 'totals/base_currency_code'), totals_base_discount_amount string OPTIONS (NAMEINSOURCE 'totals/base_discount_amount'), totals_base_grand_total string OPTIONS (NAMEINSOURCE 'totals/base_grand_total'), totals_base_shipping_amount string OPTIONS (NAMEINSOURCE 'totals/base_shipping_amount'), totals_base_shipping_discount_amount string OPTIONS (NAMEINSOURCE 'totals/base_shipping_discount_amount'), totals_base_shipping_incl_tax string OPTIONS (NAMEINSOURCE 'totals/base_shipping_incl_tax'), totals_base_shipping_tax_amount string OPTIONS (NAMEINSOURCE 'totals/base_shipping_tax_amount'), totals_base_subtotal string OPTIONS (NAMEINSOURCE 'totals/base_subtotal'), totals_base_subtotal_incl_tax string OPTIONS (NAMEINSOURCE 'totals/base_subtotal_incl_tax'), totals_base_subtotal_with_discount string OPTIONS (NAMEINSOURCE 'totals/base_subtotal_with_discount'), totals_base_tax_amount string OPTIONS (NAMEINSOURCE 'totals/base_tax_amount'), totals_coupon_code string OPTIONS (NAMEINSOURCE 'totals/coupon_code'), totals_discount_amount string OPTIONS (NAMEINSOURCE 'totals/discount_amount'), totals_extension_attributes_base_customer_balance_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/base_customer_balance_amount'), totals_extension_attributes_base_reward_currency_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/base_reward_currency_amount'), totals_extension_attributes_customer_balance_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/customer_balance_amount'), totals_extension_attributes_reward_currency_amount string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/reward_currency_amount'), totals_extension_attributes_reward_points_balance string OPTIONS (NAMEINSOURCE 'totals/extension_attributes/reward_points_balance'), totals_grand_total string OPTIONS (NAMEINSOURCE 'totals/grand_total'), "totals_items_quote-data-totals-item-interface_base_discount_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_discount_amount'), "totals_items_quote-data-totals-item-interface_base_price" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_price'), "totals_items_quote-data-totals-item-interface_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_price_incl_tax'), "totals_items_quote-data-totals-item-interface_base_row_total" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_row_total'), "totals_items_quote-data-totals-item-interface_base_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_row_total_incl_tax'), "totals_items_quote-data-totals-item-interface_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/base_tax_amount'), "totals_items_quote-data-totals-item-interface_discount_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/discount_amount'), "totals_items_quote-data-totals-item-interface_discount_percent" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/discount_percent'), "totals_items_quote-data-totals-item-interface_item_id" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/item_id'), "totals_items_quote-data-totals-item-interface_name" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/name'), "totals_items_quote-data-totals-item-interface_options" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/options'), "totals_items_quote-data-totals-item-interface_price" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/price'), "totals_items_quote-data-totals-item-interface_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/price_incl_tax'), "totals_items_quote-data-totals-item-interface_qty" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/qty'), "totals_items_quote-data-totals-item-interface_row_total" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/row_total'), "totals_items_quote-data-totals-item-interface_row_total_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/row_total_incl_tax'), "totals_items_quote-data-totals-item-interface_row_total_with_discount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/row_total_with_discount'), "totals_items_quote-data-totals-item-interface_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/tax_amount'), "totals_items_quote-data-totals-item-interface_tax_percent" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/tax_percent'), "totals_items_quote-data-totals-item-interface_weee_tax_applied" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/weee_tax_applied'), "totals_items_quote-data-totals-item-interface_weee_tax_applied_amount" string OPTIONS (NAMEINSOURCE 'totals/items[]/quote-data-totals-item-interface/weee_tax_applied_amount'), totals_items_qty string OPTIONS (NAMEINSOURCE 'totals/items_qty'), totals_quote_currency_code string OPTIONS (NAMEINSOURCE 'totals/quote_currency_code'), totals_shipping_amount string OPTIONS (NAMEINSOURCE 'totals/shipping_amount'), totals_shipping_discount_amount string OPTIONS (NAMEINSOURCE 'totals/shipping_discount_amount'), totals_shipping_incl_tax string OPTIONS (NAMEINSOURCE 'totals/shipping_incl_tax'), totals_shipping_tax_amount string OPTIONS (NAMEINSOURCE 'totals/shipping_tax_amount'), totals_subtotal string OPTIONS (NAMEINSOURCE 'totals/subtotal'), totals_subtotal_incl_tax string OPTIONS (NAMEINSOURCE 'totals/subtotal_incl_tax'), totals_subtotal_with_discount string OPTIONS (NAMEINSOURCE 'totals/subtotal_with_discount'), totals_tax_amount string OPTIONS (NAMEINSOURCE 'totals/tax_amount'), "totals_total_segments_quote-data-total-segment-interface_area" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/area'), "totals_total_segments_quote-data-total-segment-interface_code" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/code'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gift_cards" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gift_cards'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_add_card" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_add_card'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_allow_gift_receipt" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_allow_gift_receipt'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_base_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_base_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_card_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_card_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_item_ids" string[] OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_item_ids'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_base_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_base_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_items_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_items_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_order_id" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_order_id'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_price" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_price_incl_tax" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_price_incl_tax'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_gw_tax_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/gw_tax_amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_amount" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/amount'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_group_id" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/group_id'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_percent" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/percent'), "totals_total_segments_quote-data-total-segment-interface_extension_attributes_tax_grandtotal_details_tax-data-grand-total-details-interface_rates_tax-data-grand-total-rates-interface_title" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/extension_attributes/tax_grandtotal_details[]/tax-data-grand-total-details-interface/rates[]/tax-data-grand-total-rates-interface/title'), "totals_total_segments_quote-data-total-segment-interface_title" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/title'), "totals_total_segments_quote-data-total-segment-interface_value" string OPTIONS (NAMEINSOURCE 'totals/total_segments[]/quote-data-total-segment-interface/value'), totals_weee_tax_applied_amount string OPTIONS (NAMEINSOURCE 'totals/weee_tax_applied_amount'))
OPTIONS (ANNOTATION 'Get payment information', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/payment-information');

CREATE FOREIGN PROCEDURE checkoutGuestPaymentInformationManagementV1SavePaymentInformationAndPlaceOrderPost(OUT "return" string RESULT, IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN billingAddress_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'billingAddress/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'billingAddress/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'billingAddress/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "billingAddress_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'billingAddress/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "billingAddress_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'billingAddress/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'billingAddress/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'billingAddress/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'billingAddress/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'billingAddress/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'billingAddress/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'billingAddress/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'billingAddress/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'billingAddress/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'billingAddress/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'billingAddress/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'billingAddress/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'billingAddress/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'billingAddress/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'billingAddress/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'billingAddress/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'billingAddress/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'billingAddress/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'billingAddress/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'billingAddress/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'billingAddress/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN email string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_additional_data string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_extension_attributes_agreement_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/extension_attributes/agreement_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_method string NOT NULL OPTIONS (ANNOTATION 'Payment method code', NAMEINSOURCE 'paymentMethod/method', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_po_number string NOT NULL OPTIONS (ANNOTATION 'Purchase order number', NAMEINSOURCE 'paymentMethod/po_number', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Set payment information and place order for a specified cart.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/payment-information');

CREATE FOREIGN PROCEDURE quoteGuestPaymentMethodManagementV1GetListGet(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (code string, title string)
OPTIONS (ANNOTATION 'List available payment methods for a specified shopping cart. This call returns an array of objects, but detailed information about each object’s attributes might not be included.  See http://devdocs.magento.com/codelinks/attributes.html#GuestPaymentMethodManagementInterface to determine which call to use to get detailed information about all attributes for an object.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/payment-methods');

CREATE FOREIGN PROCEDURE quoteGuestPaymentMethodManagementV1GetGet(IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path')) RETURNS TABLE (additional_data string[], extension_attributes_agreement_ids string[] OPTIONS (NAMEINSOURCE 'extension_attributes/agreement_ids'), "method" string, po_number string)
OPTIONS (ANNOTATION 'Return the payment method for a specified shopping cart.', "teiid_rest:METHOD" 'GET', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/selected-payment-method');

CREATE FOREIGN PROCEDURE quoteGuestPaymentMethodManagementV1SetPut(OUT "return" string RESULT, IN cartId string NOT NULL OPTIONS (ANNOTATION 'The cart ID.', "teiid_rest:PARAMETER_TYPE" 'path'), IN method_additional_data string[] NOT NULL OPTIONS (NAMEINSOURCE 'method/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN method_extension_attributes_agreement_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'method/extension_attributes/agreement_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN method_method string NOT NULL OPTIONS (ANNOTATION 'Payment method code', NAMEINSOURCE 'method/method', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN method_po_number string NOT NULL OPTIONS (ANNOTATION 'Purchase order number', NAMEINSOURCE 'method/po_number', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Add a specified payment method to a specified shopping cart.', "teiid_rest:METHOD" 'PUT', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/selected-payment-method');

CREATE FOREIGN PROCEDURE checkoutGuestPaymentInformationManagementV1SavePaymentInformationPost(OUT "return" string RESULT, IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN billingAddress_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'billingAddress/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'billingAddress/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'billingAddress/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "billingAddress_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'billingAddress/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "billingAddress_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'billingAddress/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'billingAddress/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'billingAddress/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'billingAddress/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'billingAddress/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'billingAddress/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'billingAddress/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'billingAddress/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'billingAddress/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'billingAddress/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'billingAddress/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'billingAddress/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'billingAddress/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'billingAddress/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'billingAddress/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'billingAddress/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'billingAddress/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'billingAddress/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'billingAddress/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'billingAddress/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN billingAddress_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'billingAddress/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN email string NOT NULL OPTIONS ("teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_additional_data string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/additional_data', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_extension_attributes_agreement_ids string[] NOT NULL OPTIONS (NAMEINSOURCE 'paymentMethod/extension_attributes/agreement_ids', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_method string NOT NULL OPTIONS (ANNOTATION 'Payment method code', NAMEINSOURCE 'paymentMethod/method', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN paymentMethod_po_number string NOT NULL OPTIONS (ANNOTATION 'Purchase order number', NAMEINSOURCE 'paymentMethod/po_number', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body')) RETURNS TABLE (code string, message string, trace string)
OPTIONS (ANNOTATION 'Set payment information for a specified cart.', "teiid_rest:METHOD" 'POST', "teiid_rest:URI" 'http://t213.vg/rest/default/V1/guest-carts/{cartId}/set-payment-information');

CREATE FOREIGN PROCEDURE checkoutGuestShippingInformationManagementV1SaveAddressInformationPost(IN cartId string NOT NULL OPTIONS ("teiid_rest:PARAMETER_TYPE" 'path'), IN addressInformation_billing_address_city string NOT NULL OPTIONS (ANNOTATION 'City name', NAMEINSOURCE 'addressInformation/billing_address/city', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_company string NOT NULL OPTIONS (ANNOTATION 'Company', NAMEINSOURCE 'addressInformation/billing_address/company', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_country_id string NOT NULL OPTIONS (ANNOTATION 'Country id', NAMEINSOURCE 'addressInformation/billing_address/country_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_billing_address_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'addressInformation/billing_address/custom_attributes[]/framework-attribute-interface/attribute_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_billing_address_custom_attributes_framework-attribute-interface_value" string NOT NULL OPTIONS (ANNOTATION 'Attribute value', NAMEINSOURCE 'addressInformation/billing_address/custom_attributes[]/framework-attribute-interface/value', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_customer_address_id string NOT NULL OPTIONS (ANNOTATION 'Customer address id', NAMEINSOURCE 'addressInformation/billing_address/customer_address_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_customer_id string NOT NULL OPTIONS (ANNOTATION 'Customer id', NAMEINSOURCE 'addressInformation/billing_address/customer_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_email string NOT NULL OPTIONS (ANNOTATION 'Billing/shipping email', NAMEINSOURCE 'addressInformation/billing_address/email', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_extension_attributes_gift_registry_id string NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/billing_address/extension_attributes/gift_registry_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_fax string NOT NULL OPTIONS (ANNOTATION 'Fax number', NAMEINSOURCE 'addressInformation/billing_address/fax', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_firstname string NOT NULL OPTIONS (ANNOTATION 'First name', NAMEINSOURCE 'addressInformation/billing_address/firstname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_id string NOT NULL OPTIONS (ANNOTATION 'Id', NAMEINSOURCE 'addressInformation/billing_address/id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_lastname string NOT NULL OPTIONS (ANNOTATION 'Last name', NAMEINSOURCE 'addressInformation/billing_address/lastname', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_middlename string NOT NULL OPTIONS (ANNOTATION 'Middle name', NAMEINSOURCE 'addressInformation/billing_address/middlename', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_postcode string NOT NULL OPTIONS (ANNOTATION 'Postcode', NAMEINSOURCE 'addressInformation/billing_address/postcode', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_prefix string NOT NULL OPTIONS (ANNOTATION 'Prefix', NAMEINSOURCE 'addressInformation/billing_address/prefix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_region string NOT NULL OPTIONS (ANNOTATION 'Region name', NAMEINSOURCE 'addressInformation/billing_address/region', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_region_code string NOT NULL OPTIONS (ANNOTATION 'Region code', NAMEINSOURCE 'addressInformation/billing_address/region_code', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_region_id string NOT NULL OPTIONS (ANNOTATION 'Region id', NAMEINSOURCE 'addressInformation/billing_address/region_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_same_as_billing string NOT NULL OPTIONS (ANNOTATION 'Same as billing flag', NAMEINSOURCE 'addressInformation/billing_address/same_as_billing', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_save_in_address_book string NOT NULL OPTIONS (ANNOTATION 'Save in address book flag', NAMEINSOURCE 'addressInformation/billing_address/save_in_address_book', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_street string[] NOT NULL OPTIONS (NAMEINSOURCE 'addressInformation/billing_address/street', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_suffix string NOT NULL OPTIONS (ANNOTATION 'Suffix', NAMEINSOURCE 'addressInformation/billing_address/suffix', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_telephone string NOT NULL OPTIONS (ANNOTATION 'Telephone number', NAMEINSOURCE 'addressInformation/billing_address/telephone', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN addressInformation_billing_address_vat_id string NOT NULL OPTIONS (ANNOTATION 'Vat id', NAMEINSOURCE 'addressInformation/billing_address/vat_id', "teiid_rel:default_handling" 'omit', "teiid_rest:PARAMETER_TYPE" 'body'), IN "addressInformation_custom_attributes_framework-attribute-interface_attribute_code" string NOT NULL OPTIONS (ANNOTATION 'Attribute code', NAMEINSOURCE 'addressInformation/custom_attributes[]/framework-attribute-int